; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define half @bitcast_i16_to_f16(i16 %a, i32 %b) {
; SI-LABEL: bitcast_i16_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB0_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB0_4
; SI-NEXT:  .LBB0_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB0_3: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v2
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB0_2
; SI-NEXT:  .LBB0_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i16_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i16_to_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_i16_to_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB0_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v0.l, 3
; GFX11-TRUE16-NEXT:  .LBB0_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_i16_to_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v0, 3
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i16 %a, 3
  %a2 = bitcast i16 %a1 to half
  br label %end

cmp.false:
  %a3 = bitcast i16 %a to half
  br label %end

end:
  %phi = phi half [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret half %phi
}

define inreg half @bitcast_i16_to_f16_scalar(i16 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i16_to_f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_and_b32 s6, s16, 0xffff
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s6
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s6
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_i16_to_f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_i16_to_f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_i16_to_f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_vccz .LBB1_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_3:
; GFX11-NEXT:  .LBB1_4: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i16 %a, 3
  %a2 = bitcast i16 %a1 to half
  br label %end

cmp.false:
  %a3 = bitcast i16 %a to half
  br label %end

end:
  %phi = phi half [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret half %phi
}

define i16 @bitcast_f16_to_i16(half %a, i32 %b) {
; SI-LABEL: bitcast_f16_to_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f16_to_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f16_to_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f16_e32 v0, 0x200, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_f16_to_i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB2_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v1.l, 0x200, v0.l
; GFX11-TRUE16-NEXT:  .LBB2_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_f16_to_i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 0x200, v0
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd half %a, 0xH0200
  %a2 = bitcast half %a1 to i16
  br label %end

cmp.false:
  %a3 = bitcast half %a to i16
  br label %end

end:
  %phi = phi i16 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i16 %phi
}

define inreg i16 @bitcast_f16_to_i16_scalar(half inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f16_to_i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s16
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    s_cbranch_scc0 .LBB3_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_3
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:  .LBB3_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    s_branch .LBB3_2
;
; VI-LABEL: bitcast_f16_to_i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB3_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_4
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_3:
; VI-NEXT:    s_branch .LBB3_2
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f16_to_i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_add_f16_e32 v0, s16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_3:
; GFX9-NEXT:    s_branch .LBB3_2
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_f16_to_i16_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-TRUE16-NEXT:    s_mov_b32 s1, 0
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-TRUE16-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_f16_e64 v0.l, 0x200, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB3_3:
; GFX11-TRUE16-NEXT:    s_branch .LBB3_2
; GFX11-TRUE16-NEXT:  .LBB3_4:
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_f16_to_i16_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-FAKE16-NEXT:    s_mov_b32 s1, 0
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-FAKE16-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f16_e64 v0, 0x200, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB3_3:
; GFX11-FAKE16-NEXT:    s_branch .LBB3_2
; GFX11-FAKE16-NEXT:  .LBB3_4:
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd half %a, 0xH0200
  %a2 = bitcast half %a1 to i16
  br label %end

cmp.false:
  %a3 = bitcast half %a to i16
  br label %end

end:
  %phi = phi i16 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i16 %phi
}

define bfloat @bitcast_i16_to_bf16(i16 %a, i32 %b) {
; SI-LABEL: bitcast_i16_to_bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i16_to_bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i16_to_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_i16_to_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB4_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v0.l, 3
; GFX11-TRUE16-NEXT:  .LBB4_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_i16_to_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v0, 3
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i16 %a, 3
  %a2 = bitcast i16 %a1 to bfloat
  br label %end

cmp.false:
  %a3 = bitcast i16 %a to bfloat
  br label %end

end:
  %phi = phi bfloat [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret bfloat %phi
}

define inreg bfloat @bitcast_i16_to_bf16_scalar(i16 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i16_to_bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_and_b32 s6, s16, 0xffff
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshl_b32 s7, s6, 16
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    s_lshl_b32 s4, s6, 16
; SI-NEXT:    s_add_i32 s7, s4, 0x30000
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s7
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_i16_to_bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_i16_to_bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_i16_to_bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_vccz .LBB5_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_3:
; GFX11-NEXT:  .LBB5_4: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i16 %a, 3
  %a2 = bitcast i16 %a1 to bfloat
  br label %end

cmp.false:
  %a3 = bitcast i16 %a to bfloat
  br label %end

end:
  %phi = phi bfloat [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret bfloat %phi
}

define i16 @bitcast_bf16_to_i16(bfloat %a, i32 %b) {
; SI-LABEL: bitcast_bf16_to_i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v0
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB6_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB6_4
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB6_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  .LBB6_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_bf16_to_i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_bf16_to_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_add3_u32 v1, v1, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_bf16_to_i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_hi16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v2.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB6_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v1, v1, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-TRUE16-NEXT:  .LBB6_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_bf16_to_i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v1, v1, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:  .LBB6_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd bfloat %a, 0xR40C0
  %a2 = bitcast bfloat %a1 to i16
  br label %end

cmp.false:
  %a3 = bitcast bfloat %a to i16
  br label %end

end:
  %phi = phi i16 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i16 %phi
}

define inreg i16 @bitcast_bf16_to_i16_scalar(bfloat inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_bf16_to_i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    v_mul_f32_e64 v1, 1.0, s16
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_bf16_to_i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_4
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_3:
; VI-NEXT:    s_branch .LBB7_2
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_bf16_to_i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_4
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x7fff, v1
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_3:
; GFX9-NEXT:    s_branch .LBB7_2
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_bf16_to_i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_4
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_3:
; GFX11-NEXT:    s_branch .LBB7_2
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd bfloat %a, 0xR40C0
  %a2 = bitcast bfloat %a1 to i16
  br label %end

cmp.false:
  %a3 = bitcast bfloat %a to i16
  br label %end

end:
  %phi = phi i16 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i16 %phi
}

define bfloat @bitcast_f16_to_bf16(half %a, i32 %b) {
; SI-LABEL: bitcast_f16_to_bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB8_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB8_4
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB8_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  .LBB8_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f16_to_bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f16_to_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f16_e32 v0, 0x200, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_f16_to_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v1
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB8_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_f16_e32 v1.l, 0x200, v0.l
; GFX11-TRUE16-NEXT:  .LBB8_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_f16_to_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f16_e32 v0, 0x200, v0
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd half %a, 0xH0200
  %a2 = bitcast half %a1 to bfloat
  br label %end

cmp.false:
  %a3 = bitcast half %a to bfloat
  br label %end

end:
  %phi = phi bfloat [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret bfloat %phi
}

define inreg bfloat @bitcast_f16_to_bf16_scalar(half inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f16_to_bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s16
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_f16_to_bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB9_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_4
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_3:
; VI-NEXT:    s_branch .LBB9_2
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f16_to_bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_4
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_add_f16_e32 v0, s16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_3:
; GFX9-NEXT:    s_branch .LBB9_2
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_f16_to_bf16_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-TRUE16-NEXT:    s_mov_b32 s1, 0
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB9_4
; GFX11-TRUE16-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_f16_e64 v0.l, 0x200, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB9_3:
; GFX11-TRUE16-NEXT:    s_branch .LBB9_2
; GFX11-TRUE16-NEXT:  .LBB9_4:
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_f16_to_bf16_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-FAKE16-NEXT:    s_mov_b32 s1, 0
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB9_4
; GFX11-FAKE16-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f16_e64 v0, 0x200, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB9_3:
; GFX11-FAKE16-NEXT:    s_branch .LBB9_2
; GFX11-FAKE16-NEXT:  .LBB9_4:
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd half %a, 0xH0200
  %a2 = bitcast half %a1 to bfloat
  br label %end

cmp.false:
  %a3 = bitcast half %a to bfloat
  br label %end

end:
  %phi = phi bfloat [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret bfloat %phi
}

define half @bitcast_bf16_to_f16(bfloat %a, i32 %b) {
; SI-LABEL: bitcast_bf16_to_f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; SI-NEXT:    v_mul_f32_e32 v1, 1.0, v0
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB10_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB10_4
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB10_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  .LBB10_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_bf16_to_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_bf16_to_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_add3_u32 v1, v1, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_bf16_to_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_hi16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v2.l
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB10_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v1, v1, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-TRUE16-NEXT:  .LBB10_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_bf16_to_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v1
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v1, v1, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:  .LBB10_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd bfloat %a, 0xR40C0
  %a2 = bitcast bfloat %a1 to half
  br label %end

cmp.false:
  %a3 = bitcast bfloat %a to half
  br label %end

end:
  %phi = phi half [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret half %phi
}

define inreg half @bitcast_bf16_to_f16_scalar(bfloat inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_bf16_to_f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s17, 0
; SI-NEXT:    v_mul_f32_e64 v1, 1.0, s16
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_bf16_to_f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s17, 0
; VI-NEXT:    s_cbranch_scc0 .LBB11_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_4
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_3:
; VI-NEXT:    s_branch .LBB11_2
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_bf16_to_f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x7fff, v1
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_branch .LBB11_2
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_bf16_to_f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s1, 0
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd bfloat %a, 0xR40C0
  %a2 = bitcast bfloat %a1 to half
  br label %end

cmp.false:
  %a3 = bitcast bfloat %a to half
  br label %end

end:
  %phi = phi half [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret half %phi
}
