# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=lunarlake -instruction-tables < %s | FileCheck %s

f2xm1

fabs

fadd %st, %st(1)
fadd %st(2)
fadds (%ecx)
faddl (%ecx)
faddp %st(1)
faddp %st(2)
fiadds (%ecx)
fiaddl (%ecx)

fbld (%ecx)
fbstp (%eax)

fchs

fnclex

fcmovb %st(1), %st
fcmovbe %st(1), %st
fcmove %st(1), %st
fcmovnb %st(1), %st
fcmovnbe %st(1), %st
fcmovne %st(1), %st
fcmovnu %st(1), %st
fcmovu %st(1), %st

fcom %st(1)
fcom %st(3)
fcoms (%ecx)
fcoml (%eax)
fcomp %st(1)
fcomp %st(3)
fcomps (%ecx)
fcompl (%eax)
fcompp

fcomi %st(3)
fcompi %st(3)

fcos

fdecstp

fdiv %st, %st(1)
fdiv %st(2)
fdivs (%ecx)
fdivl (%eax)
fdivp %st(1)
fdivp %st(2)
fidivs (%ecx)
fidivl (%eax)

fdivr %st, %st(1)
fdivr %st(2)
fdivrs (%ecx)
fdivrl (%eax)
fdivrp %st(1)
fdivrp %st(2)
fidivrs (%ecx)
fidivrl (%eax)

ffree %st(0)

ficoms (%ecx)
ficoml (%eax)
ficomps (%ecx)
ficompl (%eax)

filds (%edx)
fildl (%ecx)
fildll (%eax)

fincstp

fninit

fists (%edx)
fistl (%ecx)
fistps (%edx)
fistpl (%ecx)
fistpll (%eax)

fisttps (%edx)
fisttpl (%ecx)
fisttpll (%eax)

fld %st(0)
flds (%edx)
fldl (%ecx)
fldt (%eax)

fldcw (%eax)
fldenv (%eax)

fld1
fldl2e
fldl2t
fldlg2
fldln2
fldpi
fldz

fmul %st, %st(1)
fmul %st(2)
fmuls (%ecx)
fmull (%eax)
fmulp %st(1)
fmulp %st(2)
fimuls (%ecx)
fimull (%eax)

fnop

fpatan

fprem
fprem1

fptan

frndint

frstor (%eax)

fnsave (%eax)

fscale

fsin

fsincos

fsqrt

fst %st(0)
fsts (%edx)
fstl (%ecx)
fstp %st(0)
fstpl (%edx)
fstpl (%ecx)
fstpt (%eax)

fnstcw (%eax)
fnstenv (%eax)
fnstsw (%eax)

frstor (%eax)
fsave (%eax)

fsub %st, %st(1)
fsub %st(2)
fsubs (%ecx)
fsubl (%eax)
fsubp %st(1)
fsubp %st(2)
fisubs (%ecx)
fisubl (%eax)

fsubr %st, %st(1)
fsubr %st(2)
fsubrs (%ecx)
fsubrl (%eax)
fsubrp %st(1)
fsubrp %st(2)
fisubrs (%ecx)
fisubrl (%eax)

ftst

fucom %st(1)
fucom %st(3)
fucomp %st(1)
fucomp %st(3)
fucompp

fucomi %st(3)
fucompi %st(3)

fwait

fxam

fxch %st(1)
fxch %st(3)

fxrstor (%eax)
fxsave (%eax)

fxtract

fyl2x
fyl2xp1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      100   0.17                  U     f2xm1
# CHECK-NEXT:  1      1     0.50                  U     fabs
# CHECK-NEXT:  1      2     0.50                  U     fadd	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     fadd	%st(2), %st
# CHECK-NEXT:  2      10    0.33    *             U     fadds	(%ecx)
# CHECK-NEXT:  2      10    0.33    *             U     faddl	(%ecx)
# CHECK-NEXT:  1      2     0.50                  U     faddp	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     faddp	%st, %st(2)
# CHECK-NEXT:  3      13    0.67    *             U     fiadds	(%ecx)
# CHECK-NEXT:  3      13    0.67    *             U     fiaddl	(%ecx)
# CHECK-NEXT:  1      100   0.17    *             U     fbld	(%ecx)
# CHECK-NEXT:  2      1     0.50           *      U     fbstp	(%eax)
# CHECK-NEXT:  1      1     0.50                  U     fchs
# CHECK-NEXT:  4      4     1.00                  U     fnclex
# CHECK-NEXT:  1      3     0.50                  U     fcmovb	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovbe	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmove	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovnb	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovnbe	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovne	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovnu	%st(1), %st
# CHECK-NEXT:  1      3     0.50                  U     fcmovu	%st(1), %st
# CHECK-NEXT:  1      1     0.50                  U     fcom	%st(1)
# CHECK-NEXT:  1      1     0.50                  U     fcom	%st(3)
# CHECK-NEXT:  2      8     0.50    *             U     fcoms	(%ecx)
# CHECK-NEXT:  2      8     0.50    *             U     fcoml	(%eax)
# CHECK-NEXT:  1      1     0.50                  U     fcomp	%st(1)
# CHECK-NEXT:  1      1     0.50                  U     fcomp	%st(3)
# CHECK-NEXT:  2      8     0.50    *             U     fcomps	(%ecx)
# CHECK-NEXT:  2      8     0.50    *             U     fcompl	(%eax)
# CHECK-NEXT:  1      100   0.17                  U     fcompp
# CHECK-NEXT:  1      1     0.50                  U     fcomi	%st(3), %st
# CHECK-NEXT:  1      1     0.50                  U     fcompi	%st(3), %st
# CHECK-NEXT:  1      100   0.17                  U     fcos
# CHECK-NEXT:  2      2     0.67                  U     fdecstp
# CHECK-NEXT:  1      15    1.00                  U     fdiv	%st, %st(1)
# CHECK-NEXT:  1      20    1.00                  U     fdiv	%st(2), %st
# CHECK-NEXT:  2      22    1.00    *             U     fdivs	(%ecx)
# CHECK-NEXT:  2      22    1.00    *             U     fdivl	(%eax)
# CHECK-NEXT:  1      15    1.00                  U     fdivp	%st, %st(1)
# CHECK-NEXT:  1      15    1.00                  U     fdivp	%st, %st(2)
# CHECK-NEXT:  3      25    1.00    *             U     fidivs	(%ecx)
# CHECK-NEXT:  3      25    1.00    *             U     fidivl	(%eax)
# CHECK-NEXT:  1      20    1.00                  U     fdivr	%st, %st(1)
# CHECK-NEXT:  1      15    1.00                  U     fdivr	%st(2), %st
# CHECK-NEXT:  2      27    1.00    *             U     fdivrs	(%ecx)
# CHECK-NEXT:  2      27    1.00    *             U     fdivrl	(%eax)
# CHECK-NEXT:  1      20    1.00                  U     fdivrp	%st, %st(1)
# CHECK-NEXT:  1      20    1.00                  U     fdivrp	%st, %st(2)
# CHECK-NEXT:  3      30    1.00    *             U     fidivrs	(%ecx)
# CHECK-NEXT:  3      30    1.00    *             U     fidivrl	(%eax)
# CHECK-NEXT:  1      100   0.17                  U     ffree	%st(0)
# CHECK-NEXT:  3      11    0.67    *             U     ficoms	(%ecx)
# CHECK-NEXT:  3      11    0.67    *             U     ficoml	(%eax)
# CHECK-NEXT:  3      11    0.67    *             U     ficomps	(%ecx)
# CHECK-NEXT:  3      11    0.67    *             U     ficompl	(%eax)
# CHECK-NEXT:  2      10    0.33    *             U     filds	(%edx)
# CHECK-NEXT:  2      10    0.33    *             U     fildl	(%ecx)
# CHECK-NEXT:  2      10    0.33    *             U     fildll	(%eax)
# CHECK-NEXT:  1      1     0.33                  U     fincstp
# CHECK-NEXT:  15     75    3.00                  U     fninit
# CHECK-NEXT:  2      12    0.50           *      U     fists	(%edx)
# CHECK-NEXT:  2      12    0.50           *      U     fistl	(%ecx)
# CHECK-NEXT:  2      12    0.50           *      U     fistps	(%edx)
# CHECK-NEXT:  2      12    0.50           *      U     fistpl	(%ecx)
# CHECK-NEXT:  2      12    0.50           *      U     fistpll	(%eax)
# CHECK-NEXT:  2      12    0.50           *      U     fisttps	(%edx)
# CHECK-NEXT:  2      12    0.50           *      U     fisttpl	(%ecx)
# CHECK-NEXT:  2      12    0.50           *      U     fisttpll	(%eax)
# CHECK-NEXT:  1      1     0.17                  U     fld	%st(0)
# CHECK-NEXT:  1      4     0.33    *             U     flds	(%edx)
# CHECK-NEXT:  1      4     0.33    *             U     fldl	(%ecx)
# CHECK-NEXT:  1      4     0.33    *             U     fldt	(%eax)
# CHECK-NEXT:  3      7     0.50    *             U     fldcw	(%eax)
# CHECK-NEXT:  64     62    10.25   *             U     fldenv	(%eax)
# CHECK-NEXT:  2      1     1.00                  U     fld1
# CHECK-NEXT:  2      1     1.00                  U     fldl2e
# CHECK-NEXT:  2      1     1.00                  U     fldl2t
# CHECK-NEXT:  2      1     1.00                  U     fldlg2
# CHECK-NEXT:  2      1     1.00                  U     fldln2
# CHECK-NEXT:  2      1     1.00                  U     fldpi
# CHECK-NEXT:  1      1     0.50                  U     fldz
# CHECK-NEXT:  1      4     0.25                  U     fmul	%st, %st(1)
# CHECK-NEXT:  1      4     0.25                  U     fmul	%st(2), %st
# CHECK-NEXT:  2      11    0.50    *             U     fmuls	(%ecx)
# CHECK-NEXT:  2      11    0.50    *             U     fmull	(%eax)
# CHECK-NEXT:  1      4     0.25                  U     fmulp	%st, %st(1)
# CHECK-NEXT:  1      4     0.25                  U     fmulp	%st, %st(2)
# CHECK-NEXT:  3      14    0.50    *             U     fimuls	(%ecx)
# CHECK-NEXT:  3      14    0.50    *             U     fimull	(%eax)
# CHECK-NEXT:  1      1     0.33                  U     fnop
# CHECK-NEXT:  1      100   0.17                  U     fpatan
# CHECK-NEXT:  1      100   0.17                  U     fprem
# CHECK-NEXT:  1      100   0.17                  U     fprem1
# CHECK-NEXT:  1      100   0.17                  U     fptan
# CHECK-NEXT:  1      100   0.17                  U     frndint
# CHECK-NEXT:  1      100   0.17    *             U     frstor	(%eax)
# CHECK-NEXT:  1      100   0.17           *      U     fnsave	(%eax)
# CHECK-NEXT:  1      100   0.17                  U     fscale
# CHECK-NEXT:  1      100   0.17                  U     fsin
# CHECK-NEXT:  1      100   0.17                  U     fsincos
# CHECK-NEXT:  1      21    7.00                  U     fsqrt
# CHECK-NEXT:  1      1     0.17                  U     fst	%st(0)
# CHECK-NEXT:  1      1     0.50           *      U     fsts	(%edx)
# CHECK-NEXT:  1      1     0.50           *      U     fstl	(%ecx)
# CHECK-NEXT:  1      1     0.17                  U     fstp	%st(0)
# CHECK-NEXT:  2      1     0.50           *      U     fstpl	(%edx)
# CHECK-NEXT:  2      1     0.50           *      U     fstpl	(%ecx)
# CHECK-NEXT:  2      1     0.50           *      U     fstpt	(%eax)
# CHECK-NEXT:  3      2     0.50           *      U     fnstcw	(%eax)
# CHECK-NEXT:  100    106   10.00          *      U     fnstenv	(%eax)
# CHECK-NEXT:  3      3     0.50           *      U     fnstsw	(%eax)
# CHECK-NEXT:  1      100   0.17    *             U     frstor	(%eax)
# CHECK-NEXT:  2      2     0.50                  U     wait
# CHECK-NEXT:  1      100   0.17           *      U     fnsave	(%eax)
# CHECK-NEXT:  1      2     0.50                  U     fsub	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     fsub	%st(2), %st
# CHECK-NEXT:  2      10    0.33    *             U     fsubs	(%ecx)
# CHECK-NEXT:  2      10    0.33    *             U     fsubl	(%eax)
# CHECK-NEXT:  1      2     0.50                  U     fsubp	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     fsubp	%st, %st(2)
# CHECK-NEXT:  3      13    0.67    *             U     fisubs	(%ecx)
# CHECK-NEXT:  3      13    0.67    *             U     fisubl	(%eax)
# CHECK-NEXT:  1      2     0.50                  U     fsubr	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     fsubr	%st(2), %st
# CHECK-NEXT:  2      10    0.33    *             U     fsubrs	(%ecx)
# CHECK-NEXT:  2      10    0.33    *             U     fsubrl	(%eax)
# CHECK-NEXT:  1      2     0.50                  U     fsubrp	%st, %st(1)
# CHECK-NEXT:  1      2     0.50                  U     fsubrp	%st, %st(2)
# CHECK-NEXT:  3      13    0.67    *             U     fisubrs	(%ecx)
# CHECK-NEXT:  3      13    0.67    *             U     fisubrl	(%eax)
# CHECK-NEXT:  1      2     0.33                  U     ftst
# CHECK-NEXT:  1      1     0.50                  U     fucom	%st(1)
# CHECK-NEXT:  1      1     0.50                  U     fucom	%st(3)
# CHECK-NEXT:  1      1     0.50                  U     fucomp	%st(1)
# CHECK-NEXT:  1      1     0.50                  U     fucomp	%st(3)
# CHECK-NEXT:  1      2     0.33                  U     fucompp
# CHECK-NEXT:  1      1     0.50                  U     fucomi	%st(3), %st
# CHECK-NEXT:  1      1     0.50                  U     fucompi	%st(3), %st
# CHECK-NEXT:  2      2     0.50                  U     wait
# CHECK-NEXT:  1      2     0.33                  U     fxam
# CHECK-NEXT:  15     17    2.00                  U     fxch	%st(1)
# CHECK-NEXT:  15     17    2.00                  U     fxch	%st(3)
# CHECK-NEXT:  90     63    13.50   *      *      U     fxrstor	(%eax)
# CHECK-NEXT:  110    100   19.00   *      *      U     fxsave	(%eax)
# CHECK-NEXT:  1      100   0.17                  U     fxtract
# CHECK-NEXT:  1      100   0.17                  U     fyl2x
# CHECK-NEXT:  1      100   0.17                  U     fyl2xp1

# CHECK:      Resources:
# CHECK-NEXT: [0]   - LNLPPort00
# CHECK-NEXT: [1]   - LNLPPort01
# CHECK-NEXT: [2]   - LNLPPort02
# CHECK-NEXT: [3]   - LNLPPort03
# CHECK-NEXT: [4]   - LNLPPort04
# CHECK-NEXT: [5]   - LNLPPort05
# CHECK-NEXT: [6]   - LNLPPort10
# CHECK-NEXT: [7]   - LNLPPort11
# CHECK-NEXT: [8]   - LNLPPort20
# CHECK-NEXT: [9]   - LNLPPort21
# CHECK-NEXT: [10]  - LNLPPort22
# CHECK-NEXT: [11]  - LNLPPort25
# CHECK-NEXT: [12]  - LNLPPort26
# CHECK-NEXT: [13]  - LNLPPort27
# CHECK-NEXT: [14]  - LNLPPortInvalid
# CHECK-NEXT: [15]  - LNLPVPort00
# CHECK-NEXT: [16]  - LNLPVPort01
# CHECK-NEXT: [17]  - LNLPVPort02
# CHECK-NEXT: [18]  - LNLPVPort03

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]
# CHECK-NEXT: 37.67  44.00  21.67  33.00  21.67  33.00  32.50  32.50  32.33  32.33  32.33  15.33  15.33  15.33  7.00   53.00  53.00  64.00  64.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]   Instructions:
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     f2xm1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fabs
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fadd	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fadd	%st(2), %st
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fadds	(%ecx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     faddl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   faddp	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   faddp	%st, %st(2)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fiadds	(%ecx)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fiaddl	(%ecx)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fbld	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fbstp	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fchs
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   1.00   1.00   fnclex
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovb	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovbe	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmove	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovnb	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovnbe	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovne	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovnu	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcmovu	%st(1), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcom	%st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcom	%st(3)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     fcoms	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     fcoml	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcomp	%st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcomp	%st(3)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     fcomps	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     fcompl	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fcompp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcomi	%st(3), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fcompi	%st(3), %st
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fcos
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -      -      -      -      -      -      -      -      -      -      -      -     fdecstp
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdiv	%st, %st(1)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdiv	%st(2), %st
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fdivs	(%ecx)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fdivl	(%eax)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivp	%st, %st(1)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivp	%st, %st(2)
# CHECK-NEXT: 1.00   0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fidivs	(%ecx)
# CHECK-NEXT: 1.00   0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fidivl	(%eax)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivr	%st, %st(1)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivr	%st(2), %st
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fdivrs	(%ecx)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fdivrl	(%eax)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivrp	%st, %st(1)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     fdivrp	%st, %st(2)
# CHECK-NEXT: 1.00   0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fidivrs	(%ecx)
# CHECK-NEXT: 1.00   0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fidivrl	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     ffree	%st(0)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     ficoms	(%ecx)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     ficoml	(%eax)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     ficomps	(%ecx)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     ficompl	(%eax)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     filds	(%edx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fildl	(%ecx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fildll	(%eax)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     fincstp
# CHECK-NEXT:  -     3.00    -     3.00    -     3.00    -      -      -      -      -      -      -      -      -     1.50   1.50   1.50   1.50   fninit
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fists	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fistl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fistps	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fistpl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fistpll	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fisttps	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fisttpl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50    -      -      -     0.33   0.33   0.33    -      -      -      -      -     fisttpll	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fld	%st(0)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     flds	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fldl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fldt	(%eax)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   fldcw	(%eax)
# CHECK-NEXT: 3.33   1.67   3.33   1.67   3.33   1.67    -      -     2.67   2.67   2.67    -      -      -      -     9.75   9.75   10.75  10.75  fldenv	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fld1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fldl2e
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fldl2t
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fldlg2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fldln2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   1.00   fldpi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fldz
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fmul	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fmul	%st(2), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.75   0.75   fmuls	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.75   0.75   fmull	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fmulp	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   fmulp	%st, %st(2)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -     0.25   0.25   0.75   0.75   fimuls	(%ecx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -     0.25   0.25   0.75   0.75   fimull	(%eax)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     fnop
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fpatan
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fprem
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fprem1
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fptan
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     frndint
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     frstor	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fnsave	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fscale
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fsin
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fsincos
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     7.00   0.50   0.50    -      -     fsqrt
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fst	%st(0)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fsts	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fstl	(%ecx)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fstp	%st(0)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fstpl	(%edx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fstpl	(%ecx)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -      -      -     fstpt	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   fnstcw	(%eax)
# CHECK-NEXT: 7.00   6.33   7.00   5.33   7.00   5.33   5.50   5.50   3.67   3.67   3.67    -      -      -      -     7.50   7.50   12.50  12.50  fnstenv	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   fnstsw	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     frstor	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   wait
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fnsave	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsub	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsub	%st(2), %st
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fsubs	(%ecx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fsubl	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubp	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubp	%st, %st(2)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fisubs	(%ecx)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fisubl	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubr	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubr	%st(2), %st
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fsubrs	(%ecx)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fsubrl	(%eax)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubrp	%st, %st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   fsubrp	%st, %st(2)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fisubrs	(%ecx)
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     fisubrl	(%eax)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     ftst
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucom	%st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucom	%st(3)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucomp	%st(1)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucomp	%st(3)
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     fucompp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucomi	%st(3), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     fucompi	%st(3), %st
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   wait
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     fxam
# CHECK-NEXT: 1.33   1.00   1.33   1.00   1.33   1.00    -      -      -      -      -      -      -      -      -     2.50   2.50   1.50   1.50   fxch	%st(1)
# CHECK-NEXT: 1.33   1.00   1.33   1.00   1.33   1.00    -      -      -      -      -      -      -      -      -     2.50   2.50   1.50   1.50   fxch	%st(3)
# CHECK-NEXT: 0.67   0.33   0.67   0.33   0.67   0.33    -      -     11.00  11.00  11.00   -      -      -      -     11.75  11.75  15.25  15.25  fxrstor	(%eax)
# CHECK-NEXT: 4.17   12.50  4.17   2.50   4.17   2.50   19.00  19.00  0.67   0.67   0.67   12.67  12.67  12.67   -      -      -     1.00   1.00   fxsave	(%eax)
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fxtract
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fyl2x
# CHECK-NEXT: 0.17   0.17   0.17   0.17   0.17   0.17    -      -      -      -      -      -      -      -      -      -      -      -      -     fyl2xp1
