; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=mergefunc -S < %s | FileCheck %s

; This test makes sure that the mergefunc pass does not merge functions
; that have different nonnull assertions.

%1 = type ptr

define void @f1(ptr %0, ptr %1) {
; CHECK-LABEL: @f1(
; CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP1:%.*]], align 8, !nonnull !0
; CHECK-NEXT:    store ptr [[TMP3]], ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8, !nonnull !0
  store ptr %3, ptr %0, align 8
  ret void
}

define void @f2(ptr %0, ptr %1) {
; CHECK-LABEL: @f2(
; CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP1:%.*]], align 8
; CHECK-NEXT:    store ptr [[TMP3]], ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8
  store ptr %3, ptr %0, align 8
  ret void
}

define void @noundef(ptr %0, ptr %1) {
; CHECK-LABEL: @noundef(
; CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP1:%.*]], align 8, !noundef !0
; CHECK-NEXT:    store ptr [[TMP3]], ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8, !noundef !0
  store ptr %3, ptr %0, align 8
  ret void
}

define void @noalias_1(ptr %0, ptr %1) {
; CHECK-LABEL: @noalias_1(
; CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP1:%.*]], align 8, !noalias !1
; CHECK-NEXT:    store ptr [[TMP3]], ptr [[TMP0:%.*]], align 8, !alias.scope !1
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8, !noalias !4
  store ptr %3, ptr %0, align 8, !alias.scope !4
  ret void
}

define void @noundef_dbg(ptr %0, ptr %1) {
; CHECK-LABEL: @noundef_dbg(
; CHECK-NEXT:    tail call void @noundef(ptr [[TMP0:%.*]], ptr [[TMP1:%.*]])
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8, !noundef !0, !dbg !1
  store ptr %3, ptr %0, align 8
  ret void
}

; FIXME: This is merged despite different noalias metadata.
define void @noalias_2(ptr %0, ptr %1) {
; CHECK-LABEL: @noalias_2(
; CHECK-NEXT:    tail call void @noalias_1(ptr [[TMP0:%.*]], ptr [[TMP1:%.*]])
; CHECK-NEXT:    ret void
;
  %3 = load ptr, ptr %1, align 8, !noalias !7
  store ptr %3, ptr %0, align 8, !alias.scope !7
  ret void
}

!0 = !{}
!1 = !{}
!2 = !{!2}
!3 = !{!3, !2}
!4 = !{!3}
!5 = !{!5}
!6 = !{!6, !5}
!7 = !{!6}
