; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=loop-unroll-full -S %s | FileCheck %s

; Validate that loop unroll full doesn't try to fully unroll values whose trip counts are too large.

define void @foo(i64 %end) {
; CHECK-LABEL: define void @foo(
; CHECK-SAME: i64 [[END:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOPHEADER:%.*]]
; CHECK:       loopheader:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEW:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[EXIT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[EXIT]], label [[FOR_COND_CLEANUP_LOOPEXIT:%.*]], label [[CONT23:%.*]]
; CHECK:       for.cond.cleanup.loopexit:
; CHECK-NEXT:    ret void
; CHECK:       cont23:
; CHECK-NEXT:    [[EXITCOND241:%.*]] = icmp eq i64 [[IV]], 2147483647
; CHECK-NEXT:    br i1 [[EXITCOND241]], label [[HANDLER_ADD_OVERFLOW:%.*]], label [[BACKEDGE]]
; CHECK:       handler.add_overflow:
; CHECK-NEXT:    unreachable
; CHECK:       backedge:
; CHECK-NEXT:    [[IV_NEW]] = add i64 [[IV]], 1
; CHECK-NEXT:    br label [[LOOPHEADER]], !llvm.loop [[LOOP0:![0-9]+]]
;
entry:
  br label %loopheader

loopheader:
  %iv = phi i64 [ 0, %entry ], [ %iv_new, %backedge ]
  %exit = icmp eq i64 %iv, %end
  br i1 %exit, label %for.cond.cleanup.loopexit, label %cont23

for.cond.cleanup.loopexit:
  ret void

cont23:
  %exitcond241 = icmp eq i64 %iv, 2147483647
  br i1 %exitcond241, label %handler.add_overflow, label %backedge

handler.add_overflow:
  unreachable

backedge: ; preds = %cont23
  %iv_new = add i64 %iv, 1
  br label %loopheader, !llvm.loop !0
}

!0 = distinct !{!0, !1}
!1 = !{!"llvm.loop.unroll.full"}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.unroll.full"}
;.
