; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the sprintf library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; RUN: opt < %s -mtriple xcore-xmos-elf -passes=instcombine -S | FileCheck %s -check-prefixes=CHECK,WITHSTPCPY,CHECK-IPRINTF
; RUN: opt < %s -mtriple=i386-pc-windows-msvc -passes=instcombine -S | FileCheck %s --check-prefixes=CHECK,NOSTPCPY
; RUN: opt < %s -mtriple=i386-mingw32 -passes=instcombine -S | FileCheck %s --check-prefixes=CHECK,NOSTPCPY
; RUN: opt < %s -mtriple=armv7-none-linux-android16 -passes=instcombine -S | FileCheck %s --check-prefixes=CHECK,NOSTPCPY
; RUN: opt < %s -mtriple=armv7-none-linux-android21 -passes=instcombine -S | FileCheck %s --check-prefixes=CHECK,WITHSTPCPY
; RUN: opt < %s -mtriple=x86_64-scei-ps4 -passes=instcombine -S | FileCheck %s --check-prefixes=CHECK,NOSTPCPY

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

@hello_world = constant [13 x i8] c"hello world\0A\00"
@null = constant [1 x i8] zeroinitializer
@null_hello = constant [7 x i8] c"\00hello\00"
@h = constant [2 x i8] c"h\00"
@percent_c = constant [3 x i8] c"%c\00"
@percent_d = constant [3 x i8] c"%d\00"
@percent_f = constant [3 x i8] c"%f\00"
@percent_s = constant [3 x i8] c"%s\00"

declare i32 @sprintf(ptr, ptr, ...)

; Check sprintf(dst, fmt) -> llvm.memcpy(str, fmt, strlen(fmt) + 1, 1).

define void @test_simplify1(ptr %dst) {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(13) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(13) @hello_world, i32 13, i1 false)
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @hello_world)
  ret void
}

define void @test_simplify2(ptr %dst) {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    store i8 0, ptr [[DST:%.*]], align 1
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @null)
  ret void
}

define void @test_simplify3(ptr %dst) {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    store i8 0, ptr [[DST:%.*]], align 1
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @null_hello)
  ret void
}

; Check sprintf(dst, "%c", chr) -> *(ptr)dst = chr; *((ptr)dst + 1) = 0.

define void @test_simplify4(ptr %dst) {
; CHECK-LABEL: @test_simplify4(
; CHECK-NEXT:    store i8 104, ptr [[DST:%.*]], align 1
; CHECK-NEXT:    [[NUL:%.*]] = getelementptr inbounds nuw i8, ptr [[DST]], i32 1
; CHECK-NEXT:    store i8 0, ptr [[NUL]], align 1
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_c, i8 104)
  ret void
}

; Check sprintf(dst, "%s", str) -> strcpy(dst, "%s", str) if result is unused.

define void @test_simplify5(ptr %dst, ptr %str) {
; CHECK-LABEL: @test_simplify5(
; CHECK-NEXT:    [[STRCPY:%.*]] = call ptr @strcpy(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) [[STR:%.*]])
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_s, ptr %str)
  ret void
}

; Check sprintf(dst, format, ...) -> siprintf(str, format, ...) if no floating.

define void @test_simplify6(ptr %dst) {
; CHECK-IPRINTF-LABEL: @test_simplify6(
; CHECK-IPRINTF-NEXT:    [[TMP1:%.*]] = call i32 (ptr, ptr, ...) @siprintf(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) @percent_d, i32 187)
; CHECK-IPRINTF-NEXT:    ret void
;
; NOSTPCPY-LABEL: @test_simplify6(
; NOSTPCPY-NEXT:    [[TMP1:%.*]] = call i32 (ptr, ptr, ...) @sprintf(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) @percent_d, i32 187)
; NOSTPCPY-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_d, i32 187)
  ret void
}

; Check sprintf(dst, "%s", str) -> llvm.memcpy(dest, str, strlen(str) + 1, 1).

define i32 @test_simplify7(ptr %dst, ptr %str) {
; WITHSTPCPY-LABEL: @test_simplify7(
; WITHSTPCPY-NEXT:    [[STPCPY:%.*]] = call ptr @stpcpy(ptr [[DST:%.*]], ptr [[STR:%.*]])
; WITHSTPCPY-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[STPCPY]] to i32
; WITHSTPCPY-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[DST]] to i32
; WITHSTPCPY-NEXT:    [[R:%.*]] = sub i32 [[TMP1]], [[TMP2]]
; WITHSTPCPY-NEXT:    ret i32 [[R]]
;
; NOSTPCPY-LABEL: @test_simplify7(
; NOSTPCPY-NEXT:    [[STRLEN:%.*]] = call i32 @strlen(ptr noundef nonnull dereferenceable(1) [[STR:%.*]])
; NOSTPCPY-NEXT:    [[LENINC:%.*]] = add i32 [[STRLEN]], 1
; NOSTPCPY-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[DST:%.*]], ptr nonnull align 1 [[STR]], i32 [[LENINC]], i1 false)
; NOSTPCPY-NEXT:    ret i32 [[STRLEN]]
;
  %r = call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_s, ptr %str)
  ret i32 %r
}

; Check sprintf(dst, "%s", str) -> llvm.memcpy(dest, str, strlen(str) + 1, 1).
define i32 @test_simplify8(ptr %dst) {
; CHECK-LABEL: @test_simplify8(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(13) [[DST:%.*]], ptr noundef nonnull align 1 dereferenceable(13) @hello_world, i32 13, i1 false)
; CHECK-NEXT:    ret i32 12
;
  %r = call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_s, ptr @hello_world)
  ret i32 %r
}

; Check sprintf(dst, "%s", str) -> stpcpy(dest, str) - dest

define i32 @test_simplify9(ptr %dst, ptr %str) {
; WITHSTPCPY-LABEL: @test_simplify9(
; WITHSTPCPY-NEXT:    [[STPCPY:%.*]] = call ptr @stpcpy(ptr [[DST:%.*]], ptr [[STR:%.*]])
; WITHSTPCPY-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[STPCPY]] to i32
; WITHSTPCPY-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[DST]] to i32
; WITHSTPCPY-NEXT:    [[R:%.*]] = sub i32 [[TMP1]], [[TMP2]]
; WITHSTPCPY-NEXT:    ret i32 [[R]]
;
; NOSTPCPY-LABEL: @test_simplify9(
; NOSTPCPY-NEXT:    [[STRLEN:%.*]] = call i32 @strlen(ptr noundef nonnull dereferenceable(1) [[STR:%.*]])
; NOSTPCPY-NEXT:    [[LENINC:%.*]] = add i32 [[STRLEN]], 1
; NOSTPCPY-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[DST:%.*]], ptr nonnull align 1 [[STR]], i32 [[LENINC]], i1 false)
; NOSTPCPY-NEXT:    ret i32 [[STRLEN]]
;
  %r = call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_s, ptr %str)
  ret i32 %r
}

define void @test_no_simplify1(ptr %dst) {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 (ptr, ptr, ...) @sprintf(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) @percent_f, double 1.870000e+00)
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_f, double 1.87)
  ret void
}

define void @test_no_simplify2(ptr %dst, ptr %fmt, double %d) {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 (ptr, ptr, ...) @sprintf(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) [[FMT:%.*]], double [[D:%.*]])
; CHECK-NEXT:    ret void
;
  call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr %fmt, double %d)
  ret void
}

define i32 @test_no_simplify3(ptr %dst, ptr %str) minsize {
; WITHSTPCPY-LABEL: @test_no_simplify3(
; WITHSTPCPY-NEXT:    [[STPCPY:%.*]] = call ptr @stpcpy(ptr [[DST:%.*]], ptr [[STR:%.*]])
; WITHSTPCPY-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[STPCPY]] to i32
; WITHSTPCPY-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[DST]] to i32
; WITHSTPCPY-NEXT:    [[R:%.*]] = sub i32 [[TMP1]], [[TMP2]]
; WITHSTPCPY-NEXT:    ret i32 [[R]]
;
; NOSTPCPY-LABEL: @test_no_simplify3(
; NOSTPCPY-NEXT:    [[R:%.*]] = call i32 (ptr, ptr, ...) @sprintf(ptr noundef nonnull dereferenceable(1) [[DST:%.*]], ptr noundef nonnull dereferenceable(1) @percent_s, ptr [[STR:%.*]])
; NOSTPCPY-NEXT:    ret i32 [[R]]
;
  %r = call i32 (ptr, ptr, ...) @sprintf(ptr %dst, ptr @percent_s, ptr %str)
  ret i32 %r
}
