; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=aggressive-instcombine -S | FileCheck %s

define i16 @shl_1(i8 %x) {
; CHECK-LABEL: @shl_1(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[SHL:%.*]] = shl i16 [[ZEXT]], 1
; CHECK-NEXT:    ret i16 [[SHL]]
;
  %zext = zext i8 %x to i32
  %shl = shl i32 %zext, 1
  %trunc = trunc i32 %shl to i16
  ret i16 %trunc
}

define i16 @shl_15(i8 %x) {
; CHECK-LABEL: @shl_15(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[SHL:%.*]] = shl i16 [[ZEXT]], 15
; CHECK-NEXT:    ret i16 [[SHL]]
;
  %zext = zext i8 %x to i32
  %shl = shl i32 %zext, 15
  %trunc = trunc i32 %shl to i16
  ret i16 %trunc
}

; Negative test - shift amount isn't less than target bitwidth

define i16 @shl_16(i8 %x) {
; CHECK-LABEL: @shl_16(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[ZEXT]], 16
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[SHL]] to i16
; CHECK-NEXT:    ret i16 [[TRUNC]]
;
  %zext = zext i8 %x to i32
  %shl = shl i32 %zext, 16
  %trunc = trunc i32 %shl to i16
  ret i16 %trunc
}

; Negative test -- variable shift amount

define i16 @shl_var_shift_amount(i8 %x, i8 %y) {
; CHECK-LABEL: @shl_var_shift_amount(
; CHECK-NEXT:    [[ZEXT_X:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[ZEXT_Y:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[ZEXT_X]], [[ZEXT_Y]]
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[SHL]] to i16
; CHECK-NEXT:    ret i16 [[TRUNC]]
;
  %zext.x = zext i8 %x to i32
  %zext.y = zext i8 %y to i32
  %shl = shl i32 %zext.x, %zext.y
  %trunc = trunc i32 %shl to i16
  ret i16 %trunc
}

define i16 @shl_var_bounded_shift_amount(i8 %x, i8 %y) {
; CHECK-LABEL: @shl_var_bounded_shift_amount(
; CHECK-NEXT:    [[ZEXT_X:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[ZEXT_Y:%.*]] = zext i8 [[Y:%.*]] to i16
; CHECK-NEXT:    [[AND:%.*]] = and i16 [[ZEXT_Y]], 15
; CHECK-NEXT:    [[SHL:%.*]] = shl i16 [[ZEXT_X]], [[AND]]
; CHECK-NEXT:    ret i16 [[SHL]]
;
  %zext.x = zext i8 %x to i32
  %zext.y = zext i8 %y to i32
  %and = and i32 %zext.y, 15
  %shl = shl i32 %zext.x, %and
  %trunc = trunc i32 %shl to i16
  ret i16 %trunc
}

; Negative test (https://reviews.llvm.org/D108091#2950930)

define i32 @shl_check_no_overflow(i32 %x, i16 %amt) {
; CHECK-LABEL: @shl_check_no_overflow(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[SEXT:%.*]] = sext i16 [[AMT:%.*]] to i64
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[SEXT]], 4294967295
; CHECK-NEXT:    [[SHL:%.*]] = shl i64 [[ZEXT]], [[AND]]
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i64 [[SHL]] to i32
; CHECK-NEXT:    ret i32 [[TRUNC]]
;
  %zext = zext i32 %x to i64
  %sext = sext i16 %amt to i64
  %and = and i64 %sext, 4294967295
  %shl = shl i64 %zext, %and
  %trunc = trunc i64 %shl to i32
  ret i32 %trunc
}

define <2 x i16> @shl_vector(<2 x i8> %x) {
; CHECK-LABEL: @shl_vector(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i16>
; CHECK-NEXT:    [[S:%.*]] = shl <2 x i16> [[Z]], <i16 4, i16 10>
; CHECK-NEXT:    ret <2 x i16> [[S]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %s = shl <2 x i32> %z, <i32 4, i32 10>
  %t = trunc <2 x i32> %s to <2 x i16>
  ret <2 x i16> %t
}

; Negative test - can only fold to <2 x i16>, requiring new vector type

define <2 x i8> @shl_vector_no_new_vector_type(<2 x i8> %x) {
; CHECK-LABEL: @shl_vector_no_new_vector_type(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[S:%.*]] = shl <2 x i32> [[Z]], <i32 4, i32 10>
; CHECK-NEXT:    [[T:%.*]] = trunc <2 x i32> [[S]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[T]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %s = shl <2 x i32> %z, <i32 4, i32 10>
  %t = trunc <2 x i32> %s to <2 x i8>
  ret <2 x i8> %t
}

; Negative test

define <2 x i16> @shl_vector_large_shift_amount(<2 x i8> %x) {
; CHECK-LABEL: @shl_vector_large_shift_amount(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[S:%.*]] = shl <2 x i32> [[Z]], <i32 16, i32 5>
; CHECK-NEXT:    [[T:%.*]] = trunc <2 x i32> [[S]] to <2 x i16>
; CHECK-NEXT:    ret <2 x i16> [[T]]
;
  %z = zext <2 x i8> %x to <2 x i32>
  %s = shl <2 x i32> %z, <i32 16, i32 5>
  %t = trunc <2 x i32> %s to <2 x i16>
  ret <2 x i16> %t
}

define i16 @shl_nuw(i8 %x) {
; CHECK-LABEL: @shl_nuw(
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[S:%.*]] = shl i16 [[Z]], 15
; CHECK-NEXT:    ret i16 [[S]]
;
  %z = zext i8 %x to i32
  %s = shl nuw i32 %z, 15
  %t = trunc i32 %s to i16
  ret i16 %t
}

define i16 @shl_nsw(i8 %x) {
; CHECK-LABEL: @shl_nsw(
; CHECK-NEXT:    [[Z:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[S:%.*]] = shl i16 [[Z]], 15
; CHECK-NEXT:    ret i16 [[S]]
;
  %z = zext i8 %x to i32
  %s = shl nsw i32 %z, 15
  %t = trunc i32 %s to i16
  ret i16 %t
}
