; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=i686-windows-msvc < %s | FileCheck -check-prefix=CHECK32 %s
; RUN: llc -mtriple=x86_64-windows-msvc < %s | FileCheck -check-prefix=CHECK64 %s

define i64 @test_sdiv_i64(i64 %a, i64 %b) {
; CHECK32-LABEL: test_sdiv_i64:
; CHECK32:       # %bb.0:
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    calll __alldiv
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: test_sdiv_i64:
; CHECK64:       # %bb.0:
; CHECK64-NEXT:    movq %rdx, %r8
; CHECK64-NEXT:    movq %rcx, %rax
; CHECK64-NEXT:    cqto
; CHECK64-NEXT:    idivq %r8
; CHECK64-NEXT:    retq
  %ret = sdiv i64 %a, %b
  ret i64 %ret
}

define i64 @test_srem_i64(i64 %a, i64 %b) {
; CHECK32-LABEL: test_srem_i64:
; CHECK32:       # %bb.0:
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    calll __allrem
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: test_srem_i64:
; CHECK64:       # %bb.0:
; CHECK64-NEXT:    movq %rdx, %r8
; CHECK64-NEXT:    movq %rcx, %rax
; CHECK64-NEXT:    cqto
; CHECK64-NEXT:    idivq %r8
; CHECK64-NEXT:    movq %rdx, %rax
; CHECK64-NEXT:    retq
  %ret = srem i64 %a, %b
  ret i64 %ret
}

define i64 @test_udiv_i64(i64 %a, i64 %b) {
; CHECK32-LABEL: test_udiv_i64:
; CHECK32:       # %bb.0:
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    calll __aulldiv
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: test_udiv_i64:
; CHECK64:       # %bb.0:
; CHECK64-NEXT:    movq %rdx, %r8
; CHECK64-NEXT:    movq %rcx, %rax
; CHECK64-NEXT:    xorl %edx, %edx
; CHECK64-NEXT:    divq %r8
; CHECK64-NEXT:    retq
  %ret = udiv i64 %a, %b
  ret i64 %ret
}

define i64 @test_urem_i64(i64 %a, i64 %b) {
; CHECK32-LABEL: test_urem_i64:
; CHECK32:       # %bb.0:
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    pushl {{[0-9]+}}(%esp)
; CHECK32-NEXT:    calll __aullrem
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: test_urem_i64:
; CHECK64:       # %bb.0:
; CHECK64-NEXT:    movq %rdx, %r8
; CHECK64-NEXT:    movq %rcx, %rax
; CHECK64-NEXT:    xorl %edx, %edx
; CHECK64-NEXT:    divq %r8
; CHECK64-NEXT:    movq %rdx, %rax
; CHECK64-NEXT:    retq
  %ret = urem i64 %a, %b
  ret i64 %ret
}

define i64 @test_mul_i64(i64 %a, i64 %b) {
; CHECK32-LABEL: test_mul_i64:
; CHECK32:       # %bb.0:
; CHECK32-NEXT:    pushl %esi
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK32-NEXT:    movl %ecx, %eax
; CHECK32-NEXT:    mull %esi
; CHECK32-NEXT:    imull {{[0-9]+}}(%esp), %ecx
; CHECK32-NEXT:    addl %ecx, %edx
; CHECK32-NEXT:    imull {{[0-9]+}}(%esp), %esi
; CHECK32-NEXT:    addl %esi, %edx
; CHECK32-NEXT:    popl %esi
; CHECK32-NEXT:    retl
;
; CHECK64-LABEL: test_mul_i64:
; CHECK64:       # %bb.0:
; CHECK64-NEXT:    movq %rcx, %rax
; CHECK64-NEXT:    imulq %rdx, %rax
; CHECK64-NEXT:    retq
  %ret = mul i64 %a, %b
  ret i64 %ret
}
