; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mcpu=generic | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=generic | FileCheck %s --check-prefix=X64

; Verify that we correctly lower the "Read Performance-Monitoring Counters"
; x86 builtin.

define i64 @test_builtin_read_pmc(i32 %ID) {
; X86-LABEL: test_builtin_read_pmc:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    rdpmc
; X86-NEXT:    retl
;
; X64-LABEL: test_builtin_read_pmc:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %ecx
; X64-NEXT:    rdpmc
; X64-NEXT:    shlq $32, %rdx
; X64-NEXT:    orq %rdx, %rax
; X64-NEXT:    retq
  %1 = tail call i64 @llvm.x86.rdpmc(i32 %ID)
  ret i64 %1
}
declare i64 @llvm.x86.rdpmc(i32 %ID)

