; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zve64d,+f,+d,+zvfh,+zvfbfmin \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg2ff_nxv1i8_triscv.vector.tuple_nxv1i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1i8_triscv.vector.tuple_nxv1i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg2ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg2ff_nxv2i8_triscv.vector.tuple_nxv2i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2i8_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg2ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg2ff_nxv4i8_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4i8_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg2ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg2ff_nxv8i8_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8i8_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg2ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vlseg2ff_nxv16i8_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv16i8_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

define <vscale x 16 x i8> @test_vlseg2ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e8ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 32 x i1>, i64, i64, i64)

define <vscale x 32 x i8> @test_vlseg2ff_nxv32i8_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv32i8_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vlseg2e8ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 32 x i8> %2
}

define <vscale x 32 x i8> @test_vlseg2ff_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 32 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e8ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 32 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 32 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg3ff_nxv1i8_triscv.vector.tuple_nxv1i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1i8_triscv.vector.tuple_nxv1i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg3ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg3ff_nxv2i8_triscv.vector.tuple_nxv2i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2i8_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg3ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg3ff_nxv4i8_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4i8_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg3ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg3ff_nxv8i8_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv8i8_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg3ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vlseg3ff_nxv16i8_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv16i8_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vlseg3e8ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

define <vscale x 16 x i8> @test_vlseg3ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e8ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg4ff_nxv1i8_triscv.vector.tuple_nxv1i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1i8_triscv.vector.tuple_nxv1i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg4ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg4ff_nxv2i8_triscv.vector.tuple_nxv2i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2i8_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg4ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg4ff_nxv4i8_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4i8_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg4ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg4ff_nxv8i8_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv8i8_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg4ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vlseg4ff_nxv16i8_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv16i8_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vlseg4e8ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

define <vscale x 16 x i8> @test_vlseg4ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e8ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg5ff_nxv1i8_triscv.vector.tuple_nxv1i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1i8_triscv.vector.tuple_nxv1i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg5ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg5ff_nxv2i8_triscv.vector.tuple_nxv2i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2i8_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg5ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg5ff_nxv4i8_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv4i8_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg5ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg5ff_nxv8i8_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv8i8_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg5ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg6ff_nxv1i8_triscv.vector.tuple_nxv1i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1i8_triscv.vector.tuple_nxv1i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg6ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg6ff_nxv2i8_triscv.vector.tuple_nxv2i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2i8_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg6ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg6ff_nxv4i8_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv4i8_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg6ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg6ff_nxv8i8_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv8i8_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg6ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg7ff_nxv1i8_triscv.vector.tuple_nxv1i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1i8_triscv.vector.tuple_nxv1i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg7ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg7ff_nxv2i8_triscv.vector.tuple_nxv2i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2i8_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg7ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg7ff_nxv4i8_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv4i8_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg7ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg7ff_nxv8i8_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv8i8_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg7ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vlseg8ff_nxv1i8_triscv.vector.tuple_nxv1i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1i8_triscv.vector.tuple_nxv1i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

define <vscale x 1 x i8> @test_vlseg8ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 1 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vlseg8ff_nxv2i8_triscv.vector.tuple_nxv2i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2i8_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

define <vscale x 2 x i8> @test_vlseg8ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vlseg8ff_nxv4i8_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv4i8_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

define <vscale x 4 x i8> @test_vlseg8ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, i64, i64)
declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vlseg8ff_nxv8i8_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv8i8_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

define <vscale x 8 x i8> @test_vlseg8ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e8ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i8> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg2ff_nxv1i16_triscv.vector.tuple_nxv2i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1i16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg2ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg2ff_nxv2i16_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2i16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg2ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg2ff_nxv4i16_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4i16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg2ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vlseg2ff_nxv8i16_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8i16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

define <vscale x 8 x i16> @test_vlseg2ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i16> @test_vlseg2ff_nxv16i16_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv16i16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i16> %2
}

define <vscale x 16 x i16> @test_vlseg2ff_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg3ff_nxv1i16_triscv.vector.tuple_nxv2i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1i16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg3ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg3ff_nxv2i16_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2i16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg3ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg3ff_nxv4i16_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4i16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg3ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vlseg3ff_nxv8i16_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv8i16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

define <vscale x 8 x i16> @test_vlseg3ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg4ff_nxv1i16_triscv.vector.tuple_nxv2i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1i16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg4ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg4ff_nxv2i16_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2i16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg4ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg4ff_nxv4i16_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4i16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg4ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vlseg4ff_nxv8i16_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv8i16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

define <vscale x 8 x i16> @test_vlseg4ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg5ff_nxv1i16_triscv.vector.tuple_nxv2i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1i16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg5ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg5ff_nxv2i16_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2i16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg5ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg5ff_nxv4i16_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv4i16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg5ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg6ff_nxv1i16_triscv.vector.tuple_nxv2i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1i16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg6ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg6ff_nxv2i16_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2i16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg6ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg6ff_nxv4i16_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv4i16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg6ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg7ff_nxv1i16_triscv.vector.tuple_nxv2i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1i16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg7ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg7ff_nxv2i16_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2i16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg7ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg7ff_nxv4i16_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv4i16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg7ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vlseg8ff_nxv1i16_triscv.vector.tuple_nxv2i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1i16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

define <vscale x 1 x i16> @test_vlseg8ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vlseg8ff_nxv2i16_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2i16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

define <vscale x 2 x i16> @test_vlseg8ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vlseg8ff_nxv4i16_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv4i16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @test_vlseg8ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i16> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg2ff_nxv1i32_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1i32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg2ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg2ff_nxv2i32_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2i32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg2ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vlseg2ff_nxv4i32_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4i32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @test_vlseg2ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i32> @test_vlseg2ff_nxv8i32_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8i32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i32> %2
}

define <vscale x 8 x i32> @test_vlseg2ff_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e32ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg3ff_nxv1i32_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1i32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg3ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg3ff_nxv2i32_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2i32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg3ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vlseg3ff_nxv4i32_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4i32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @test_vlseg3ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg4ff_nxv1i32_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1i32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg4ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg4ff_nxv2i32_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2i32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg4ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vlseg4ff_nxv4i32_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4i32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @test_vlseg4ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg5ff_nxv1i32_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1i32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg5ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg5ff_nxv2i32_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2i32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg5ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg6ff_nxv1i32_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1i32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg6ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg6ff_nxv2i32_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2i32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg6ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg7ff_nxv1i32_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1i32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg7ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg7ff_nxv2i32_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2i32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg7ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vlseg8ff_nxv1i32_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1i32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

define <vscale x 1 x i32> @test_vlseg8ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vlseg8ff_nxv2i32_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2i32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

define <vscale x 2 x i32> @test_vlseg8ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i32> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg2ff_nxv1i64_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1i64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg2ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vlseg2ff_nxv2i64_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2i64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

define <vscale x 2 x i64> @test_vlseg2ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i64> @test_vlseg2ff_nxv4i64_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4i64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @test_vlseg2ff_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e64ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg3ff_nxv1i64_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1i64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg3e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg3ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vlseg3ff_nxv2i64_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2i64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg3e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

define <vscale x 2 x i64> @test_vlseg3ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg4ff_nxv1i64_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1i64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg4e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg4ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vlseg4ff_nxv2i64_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2i64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg4e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

define <vscale x 2 x i64> @test_vlseg4ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg5ff_nxv1i64_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1i64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg5e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg5ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg6ff_nxv1i64_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1i64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg6e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg6ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg7ff_nxv1i64_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1i64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg7e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg7ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

declare {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vlseg8ff_nxv1i64_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1i64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg8e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}

define <vscale x 1 x i64> @test_vlseg8ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x i64> %2
}


define <vscale x 1 x half> @test_vlseg2ff_nxv1f16_triscv.vector.tuple_nxv2i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1f16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg2ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg2ff_nxv2f16_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2f16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg2ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg2ff_nxv4f16_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4f16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg2ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 8 x half> @test_vlseg2ff_nxv8f16_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8f16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}

define <vscale x 8 x half> @test_vlseg2ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}


define <vscale x 16 x half> @test_vlseg2ff_nxv16f16_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv16f16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x half> %2
}

define <vscale x 16 x half> @test_vlseg2ff_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x half> %2
}


define <vscale x 1 x half> @test_vlseg3ff_nxv1f16_triscv.vector.tuple_nxv2i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1f16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg3ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg3ff_nxv2f16_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2f16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg3ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg3ff_nxv4f16_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4f16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg3ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 8 x half> @test_vlseg3ff_nxv8f16_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv8f16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}

define <vscale x 8 x half> @test_vlseg3ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}


define <vscale x 1 x half> @test_vlseg4ff_nxv1f16_triscv.vector.tuple_nxv2i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1f16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg4ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg4ff_nxv2f16_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2f16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg4ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg4ff_nxv4f16_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4f16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg4ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 8 x half> @test_vlseg4ff_nxv8f16_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv8f16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}

define <vscale x 8 x half> @test_vlseg4ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x half> %2
}


define <vscale x 1 x half> @test_vlseg5ff_nxv1f16_triscv.vector.tuple_nxv2i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1f16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg5ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg5ff_nxv2f16_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2f16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg5ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg5ff_nxv4f16_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv4f16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg5ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 1 x half> @test_vlseg6ff_nxv1f16_triscv.vector.tuple_nxv2i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1f16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg6ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg6ff_nxv2f16_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2f16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg6ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg6ff_nxv4f16_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv4f16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg6ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 1 x half> @test_vlseg7ff_nxv1f16_triscv.vector.tuple_nxv2i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1f16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg7ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg7ff_nxv2f16_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2f16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg7ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg7ff_nxv4f16_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv4f16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg7ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 1 x half> @test_vlseg8ff_nxv1f16_triscv.vector.tuple_nxv2i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1f16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}

define <vscale x 1 x half> @test_vlseg8ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x half> %2
}


define <vscale x 2 x half> @test_vlseg8ff_nxv2f16_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2f16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}

define <vscale x 2 x half> @test_vlseg8ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x half> %2
}


define <vscale x 4 x half> @test_vlseg8ff_nxv4f16_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv4f16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}

define <vscale x 4 x half> @test_vlseg8ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x half> %2
}


define <vscale x 1 x float> @test_vlseg2ff_nxv1f32_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1f32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg2ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg2ff_nxv2f32_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2f32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg2ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 4 x float> @test_vlseg2ff_nxv4f32_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4f32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @test_vlseg2ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}


define <vscale x 8 x float> @test_vlseg2ff_nxv8f32_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8f32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vlseg2e32ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x float> %2
}

define <vscale x 8 x float> @test_vlseg2ff_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e32ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x float> %2
}


define <vscale x 1 x float> @test_vlseg3ff_nxv1f32_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1f32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg3ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg3ff_nxv2f32_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2f32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg3ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 4 x float> @test_vlseg3ff_nxv4f32_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4f32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg3e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @test_vlseg3ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}


define <vscale x 1 x float> @test_vlseg4ff_nxv1f32_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1f32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg4ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg4ff_nxv2f32_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2f32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg4ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 4 x float> @test_vlseg4ff_nxv4f32_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4f32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vlseg4e32ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @test_vlseg4ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e32ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x float> %2
}


define <vscale x 1 x float> @test_vlseg5ff_nxv1f32_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1f32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg5ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg5ff_nxv2f32_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2f32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg5ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 1 x float> @test_vlseg6ff_nxv1f32_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1f32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg6ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg6ff_nxv2f32_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2f32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg6ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 1 x float> @test_vlseg7ff_nxv1f32_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1f32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg7ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg7ff_nxv2f32_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2f32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg7ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 1 x float> @test_vlseg8ff_nxv1f32_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1f32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}

define <vscale x 1 x float> @test_vlseg8ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1f32_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x float> %2
}


define <vscale x 2 x float> @test_vlseg8ff_nxv2f32_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2f32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}

define <vscale x 2 x float> @test_vlseg8ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2f32_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e32ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x float> %2
}


define <vscale x 1 x double> @test_vlseg2ff_nxv1f64_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1f64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg2ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 2 x double> @test_vlseg2ff_nxv2f64_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2f64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}

define <vscale x 2 x double> @test_vlseg2ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}


define <vscale x 4 x double> @test_vlseg2ff_nxv4f64_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4f64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vlseg2e64ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x double> @llvm.riscv.tuple.extract.nxv4f64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @test_vlseg2ff_mask_nxv4f64_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4f64_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e64ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x double> @llvm.riscv.tuple.extract.nxv4f64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x double> %2
}


define <vscale x 1 x double> @test_vlseg3ff_nxv1f64_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1f64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg3e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg3ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 2 x double> @test_vlseg3ff_nxv2f64_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2f64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg3e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}

define <vscale x 2 x double> @test_vlseg3ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}


define <vscale x 1 x double> @test_vlseg4ff_nxv1f64_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1f64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg4e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg4ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 2 x double> @test_vlseg4ff_nxv2f64_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2f64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vlseg4e64ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}

define <vscale x 2 x double> @test_vlseg4ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2f64_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e64ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x double> @llvm.riscv.tuple.extract.nxv2f64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x double> %2
}


define <vscale x 1 x double> @test_vlseg5ff_nxv1f64_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1f64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg5e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg5ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x double> @test_vlseg6ff_nxv1f64_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1f64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg6e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg6ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x double> @test_vlseg7ff_nxv1f64_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1f64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg7e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg7ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x double> @test_vlseg8ff_nxv1f64_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1f64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vlseg8e64ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @test_vlseg8ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1f64_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e64ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x double> @llvm.riscv.tuple.extract.nxv1f64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x bfloat> @test_vlseg2ff_nxv1bf16_triscv.vector.tuple_nxv2i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv1bf16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg2ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg2ff_nxv2bf16_triscv.vector.tuple_nxv4i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv2bf16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg2ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg2ff_nxv4bf16_triscv.vector.tuple_nxv8i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv4bf16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg2ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vlseg2e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 8 x bfloat> @test_vlseg2ff_nxv8bf16_triscv.vector.tuple_nxv16i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv8bf16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}

define <vscale x 8 x bfloat> @test_vlseg2ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vlseg2e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}


define <vscale x 16 x bfloat> @test_vlseg2ff_nxv16bf16_triscv.vector.tuple_nxv32i8_2t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_nxv16bf16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x bfloat> @llvm.riscv.tuple.extract.nxv16bf16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x bfloat> %2
}

define <vscale x 16 x bfloat> @test_vlseg2ff_mask_nxv16bf16_triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, i64 %vl, <vscale x 16 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg2ff_mask_nxv16bf16_triscv.vector.tuple_nxv32i8_2t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vmv4r.v v4, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    vlseg2e16ff.v v4, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} @llvm.riscv.vlseg2ff.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %val, ptr %base, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 0
  %2 = call <vscale x 16 x bfloat> @llvm.riscv.tuple.extract.nxv16bf16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 32 x i8>, 2), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 16 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg3ff_nxv1bf16_triscv.vector.tuple_nxv2i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv1bf16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg3ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg3ff_nxv2bf16_triscv.vector.tuple_nxv4i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv2bf16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg3ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg3ff_nxv4bf16_triscv.vector.tuple_nxv8i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv4bf16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg3ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vlseg3e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 8 x bfloat> @test_vlseg3ff_nxv8bf16_triscv.vector.tuple_nxv16i8_3t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_nxv8bf16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}

define <vscale x 8 x bfloat> @test_vlseg3ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg3ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_3t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vlseg3e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} @llvm.riscv.vlseg3ff.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 3), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg4ff_nxv1bf16_triscv.vector.tuple_nxv2i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv1bf16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg4ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg4ff_nxv2bf16_triscv.vector.tuple_nxv4i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv2bf16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg4ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg4ff_nxv4bf16_triscv.vector.tuple_nxv8i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv4bf16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg4ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vlseg4e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 8 x bfloat> @test_vlseg4ff_nxv8bf16_triscv.vector.tuple_nxv16i8_4t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_nxv8bf16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}

define <vscale x 8 x bfloat> @test_vlseg4ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, i64 %vl, <vscale x 8 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg4ff_mask_nxv8bf16_triscv.vector.tuple_nxv16i8_4t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv2r.v v6, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    vmv2r.v v10, v12
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vlseg4e16ff.v v6, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} @llvm.riscv.vlseg4ff.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %val, ptr %base, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 0
  %2 = call <vscale x 8 x bfloat> @llvm.riscv.tuple.extract.nxv8bf16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 16 x i8>, 4), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 8 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg5ff_nxv1bf16_triscv.vector.tuple_nxv2i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv1bf16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg5ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg5ff_nxv2bf16_triscv.vector.tuple_nxv4i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv2bf16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg5ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg5ff_nxv4bf16_triscv.vector.tuple_nxv8i8_5t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_nxv4bf16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg5ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg5ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_5t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vlseg5e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} @llvm.riscv.vlseg5ff.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 5), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg6ff_nxv1bf16_triscv.vector.tuple_nxv2i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv1bf16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg6ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg6ff_nxv2bf16_triscv.vector.tuple_nxv4i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv2bf16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg6ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg6ff_nxv4bf16_triscv.vector.tuple_nxv8i8_6t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_nxv4bf16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg6ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg6ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_6t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vlseg6e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} @llvm.riscv.vlseg6ff.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 6), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg7ff_nxv1bf16_triscv.vector.tuple_nxv2i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv1bf16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg7ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg7ff_nxv2bf16_triscv.vector.tuple_nxv4i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv2bf16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg7ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg7ff_nxv4bf16_triscv.vector.tuple_nxv8i8_7t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_nxv4bf16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg7ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg7ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_7t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vlseg7e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} @llvm.riscv.vlseg7ff.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 7), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}


define <vscale x 1 x bfloat> @test_vlseg8ff_nxv1bf16_triscv.vector.tuple_nxv2i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv1bf16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}

define <vscale x 1 x bfloat> @test_vlseg8ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 1 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv1bf16_triscv.vector.tuple_nxv2i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %val, ptr %base, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 1 x bfloat> @llvm.riscv.tuple.extract.nxv1bf16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 2 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 1 x bfloat> %2
}


define <vscale x 2 x bfloat> @test_vlseg8ff_nxv2bf16_triscv.vector.tuple_nxv4i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv2bf16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}

define <vscale x 2 x bfloat> @test_vlseg8ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 2 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv2bf16_triscv.vector.tuple_nxv4i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %val, ptr %base, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 2 x bfloat> @llvm.riscv.tuple.extract.nxv2bf16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 4 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 2 x bfloat> %2
}


define <vscale x 4 x bfloat> @test_vlseg8ff_nxv4bf16_triscv.vector.tuple_nxv8i8_8t(ptr %base, i64 %vl, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_nxv4bf16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0)
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, i64 %vl, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

define <vscale x 4 x bfloat> @test_vlseg8ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, i64 %vl, <vscale x 4 x i1> %mask, ptr %outvl) {
; CHECK-LABEL: test_vlseg8ff_mask_nxv4bf16_triscv.vector.tuple_nxv8i8_8t:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v7, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vmv1r.v v10, v11
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vlseg8e16ff.v v7, (a0), v0.t
; CHECK-NEXT:    csrr a0, vl
; CHECK-NEXT:    sd a0, 0(a2)
; CHECK-NEXT:    ret
entry:
  %0 = tail call {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} @llvm.riscv.vlseg8ff.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %val, ptr %base, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 0
  %2 = call <vscale x 4 x bfloat> @llvm.riscv.tuple.extract.nxv4bf16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %1, i32 1)
  %3 = extractvalue {target("riscv.vector.tuple", <vscale x 8 x i8>, 8), i64} %0, 1
  store i64 %3, ptr %outvl
  ret <vscale x 4 x bfloat> %2
}

