; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zvfbfmin -verify-machineinstrs | FileCheck %s

define void @store_nxv1bf16(<vscale x 1 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 1 x bfloat> %v, ptr %p
  ret void
}

define void @store_nxv2bf16(<vscale x 2 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 2 x bfloat> %v, ptr %p
  ret void
}

define void @store_nxv4bf16(<vscale x 4 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 4 x bfloat> %v, ptr %p
  ret void
}

define void @store_nxv8bf16(<vscale x 8 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 8 x bfloat> %v, ptr %p
  ret void
}

define void @store_nxv16bf16(<vscale x 16 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 16 x bfloat> %v, ptr %p
  ret void
}

define void @store_nxv32bf32(<vscale x 32 x bfloat> %v, ptr %p) {
; CHECK-LABEL: store_nxv32bf32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  store <vscale x 32 x bfloat> %v, ptr %p
  ret void
}

define void @truncstore(<vscale x 4 x float> %v, ptr %p) {
; CHECK-LABEL: truncstore:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v10, v8
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %w = fptrunc <vscale x 4 x float> %v to <vscale x 4 x bfloat>
  store <vscale x 4 x bfloat> %w, ptr %p
  ret void
}
