; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32  < %s | FileCheck -check-prefixes=RV32,NO-ZBA %s
; RUN: llc -mtriple=riscv32 -mattr=+zba  < %s | FileCheck -check-prefixes=RV32,ZBA %s
; RUN: llc -mtriple=riscv32 -mattr=+xandesperf  < %s | FileCheck -check-prefixes=RV32,XANDESPERF %s

define i32 @add_shl_oneUse(i32 %x, i32 %y) nounwind {
; NO-ZBA-LABEL: add_shl_oneUse:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    slli a0, a0, 3
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    addi a0, a0, 984
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_oneUse:
; ZBA:       # %bb.0:
; ZBA-NEXT:    addi a0, a0, 123
; ZBA-NEXT:    sh3add a0, a0, a1
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_oneUse:
; XANDESPERF:       # %bb.0:
; XANDESPERF-NEXT:    addi a0, a0, 123
; XANDESPERF-NEXT:    nds.lea.d a0, a1, a0
; XANDESPERF-NEXT:    ret
  %add.0 = add i32 %x, 123
  %shl = shl i32 %add.0, 3
  %add.1 = add i32 %shl, %y
  ret i32 %add.1
}

define void @add_shl_moreOneUse_inStore(ptr %array1, i32 %a, i32 %b)  {
; NO-ZBA-LABEL: add_shl_moreOneUse_inStore:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a3, a1, 5
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    sw a2, 20(a0)
; NO-ZBA-NEXT:    sw a2, 24(a0)
; NO-ZBA-NEXT:    sw a3, 140(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_inStore:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a3, a1, 5
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    sw a2, 20(a0)
; ZBA-NEXT:    sw a2, 24(a0)
; ZBA-NEXT:    sw a3, 140(a0)
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_inStore:
; XANDESPERF:       # %bb.0: # %entry
; XANDESPERF-NEXT:    addi a3, a1, 5
; XANDESPERF-NEXT:    nds.lea.w a0, a0, a1
; XANDESPERF-NEXT:    sw a2, 20(a0)
; XANDESPERF-NEXT:    sw a2, 24(a0)
; XANDESPERF-NEXT:    sw a3, 140(a0)
; XANDESPERF-NEXT:    ret
entry:
  %add = add nsw i32 %a, 5
  %arrayidx = getelementptr inbounds i32, ptr %array1, i32 %add
  store i32 %b, ptr %arrayidx
  %0 = getelementptr i32, ptr %array1, i32 %a
  %arrayidx3 = getelementptr i8, ptr %0, i32 24
  store i32 %b, ptr %arrayidx3
  %arrayidx5 = getelementptr i8, ptr %0, i32 140
  store i32 %add, ptr %arrayidx5
  ret void
}

define void @add_shl_moreOneUse_inStore_addexceedsign12(ptr %array1, i32 %a, i32 %b)  {
; NO-ZBA-LABEL: add_shl_moreOneUse_inStore_addexceedsign12:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a3, a1, 2047
; NO-ZBA-NEXT:    lui a4, 2
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    addi a3, a3, 1
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    add a0, a0, a4
; NO-ZBA-NEXT:    sw a2, 0(a0)
; NO-ZBA-NEXT:    sw a3, 4(a0)
; NO-ZBA-NEXT:    sw a2, 120(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_inStore_addexceedsign12:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a3, a1, 2047
; ZBA-NEXT:    lui a4, 2
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    addi a3, a3, 1
; ZBA-NEXT:    add a0, a0, a4
; ZBA-NEXT:    sw a2, 0(a0)
; ZBA-NEXT:    sw a3, 4(a0)
; ZBA-NEXT:    sw a2, 120(a0)
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_inStore_addexceedsign12:
; XANDESPERF:       # %bb.0: # %entry
; XANDESPERF-NEXT:    addi a3, a1, 2047
; XANDESPERF-NEXT:    lui a4, 2
; XANDESPERF-NEXT:    nds.lea.w a0, a0, a1
; XANDESPERF-NEXT:    addi a3, a3, 1
; XANDESPERF-NEXT:    add a0, a0, a4
; XANDESPERF-NEXT:    sw a2, 0(a0)
; XANDESPERF-NEXT:    sw a3, 4(a0)
; XANDESPERF-NEXT:    sw a2, 120(a0)
; XANDESPERF-NEXT:    ret
entry:
  %add = add nsw i32 %a, 2048
  %arrayidx = getelementptr inbounds i32, ptr %array1, i32 %add
  store i32 %b, ptr %arrayidx
  %0 = getelementptr i32, ptr %array1, i32 %a
  %arrayidx2 = getelementptr i8, ptr %0, i32 8196
  store i32 %add, ptr %arrayidx2
  %arrayidx4 = getelementptr i8, ptr %0, i32 8312
  store i32 %b, ptr %arrayidx4
  ret void
}

define void @add_shl_moreOneUse_inSelect(ptr %array1, i32 %a, i32 %b, i32 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_inSelect:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a4, a1, 5
; NO-ZBA-NEXT:    mv a5, a4
; NO-ZBA-NEXT:    bgtz a3, .LBB3_2
; NO-ZBA-NEXT:  # %bb.1: # %entry
; NO-ZBA-NEXT:    mv a5, a2
; NO-ZBA-NEXT:  .LBB3_2: # %entry
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    sw a5, 20(a0)
; NO-ZBA-NEXT:    sw a5, 24(a0)
; NO-ZBA-NEXT:    sw a4, 140(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_inSelect:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a4, a1, 5
; ZBA-NEXT:    mv a5, a4
; ZBA-NEXT:    bgtz a3, .LBB3_2
; ZBA-NEXT:  # %bb.1: # %entry
; ZBA-NEXT:    mv a5, a2
; ZBA-NEXT:  .LBB3_2: # %entry
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    sw a5, 20(a0)
; ZBA-NEXT:    sw a5, 24(a0)
; ZBA-NEXT:    sw a4, 140(a0)
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_inSelect:
; XANDESPERF:       # %bb.0: # %entry
; XANDESPERF-NEXT:    addi a4, a1, 5
; XANDESPERF-NEXT:    mv a5, a4
; XANDESPERF-NEXT:    bgtz a3, .LBB3_2
; XANDESPERF-NEXT:  # %bb.1: # %entry
; XANDESPERF-NEXT:    mv a5, a2
; XANDESPERF-NEXT:  .LBB3_2: # %entry
; XANDESPERF-NEXT:    nds.lea.w a0, a0, a1
; XANDESPERF-NEXT:    sw a5, 20(a0)
; XANDESPERF-NEXT:    sw a5, 24(a0)
; XANDESPERF-NEXT:    sw a4, 140(a0)
; XANDESPERF-NEXT:    ret
entry:
  %add = add nsw i32 %a, 5
  %cmp = icmp sgt i32 %x, 0
  %cond = select i1 %cmp, i32 %add, i32 %b
  %arrayidx = getelementptr inbounds i32, ptr %array1, i32 %add
  store i32 %cond, ptr %arrayidx
  %0 = getelementptr i32, ptr %array1, i32 %a
  %arrayidx2 = getelementptr i32, ptr %0, i32 6
  store i32 %cond, ptr %arrayidx2
  %arrayidx4 = getelementptr i32, ptr %0, i32 35
  store i32 %add, ptr %arrayidx4
  ret void
}

define void @add_shl_moreOneUse_inSelect_addexceedsign12(ptr %array1, i32 %a, i32 %b, i32 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_inSelect_addexceedsign12:
; NO-ZBA:       # %bb.0: # %entry
; NO-ZBA-NEXT:    addi a4, a1, 2047
; NO-ZBA-NEXT:    addi a4, a4, 1
; NO-ZBA-NEXT:    mv a5, a4
; NO-ZBA-NEXT:    bgtz a3, .LBB4_2
; NO-ZBA-NEXT:  # %bb.1: # %entry
; NO-ZBA-NEXT:    mv a5, a2
; NO-ZBA-NEXT:  .LBB4_2: # %entry
; NO-ZBA-NEXT:    lui a2, 2
; NO-ZBA-NEXT:    slli a1, a1, 2
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    add a0, a0, a2
; NO-ZBA-NEXT:    sw a5, 0(a0)
; NO-ZBA-NEXT:    sw a5, 4(a0)
; NO-ZBA-NEXT:    sw a4, 120(a0)
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_inSelect_addexceedsign12:
; ZBA:       # %bb.0: # %entry
; ZBA-NEXT:    addi a4, a1, 2047
; ZBA-NEXT:    addi a4, a4, 1
; ZBA-NEXT:    mv a5, a4
; ZBA-NEXT:    bgtz a3, .LBB4_2
; ZBA-NEXT:  # %bb.1: # %entry
; ZBA-NEXT:    mv a5, a2
; ZBA-NEXT:  .LBB4_2: # %entry
; ZBA-NEXT:    lui a2, 2
; ZBA-NEXT:    sh2add a0, a1, a0
; ZBA-NEXT:    add a0, a0, a2
; ZBA-NEXT:    sw a5, 0(a0)
; ZBA-NEXT:    sw a5, 4(a0)
; ZBA-NEXT:    sw a4, 120(a0)
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_inSelect_addexceedsign12:
; XANDESPERF:       # %bb.0: # %entry
; XANDESPERF-NEXT:    addi a4, a1, 2047
; XANDESPERF-NEXT:    addi a4, a4, 1
; XANDESPERF-NEXT:    mv a5, a4
; XANDESPERF-NEXT:    bgtz a3, .LBB4_2
; XANDESPERF-NEXT:  # %bb.1: # %entry
; XANDESPERF-NEXT:    mv a5, a2
; XANDESPERF-NEXT:  .LBB4_2: # %entry
; XANDESPERF-NEXT:    lui a2, 2
; XANDESPERF-NEXT:    nds.lea.w a0, a0, a1
; XANDESPERF-NEXT:    add a0, a0, a2
; XANDESPERF-NEXT:    sw a5, 0(a0)
; XANDESPERF-NEXT:    sw a5, 4(a0)
; XANDESPERF-NEXT:    sw a4, 120(a0)
; XANDESPERF-NEXT:    ret
entry:
  %add = add nsw i32 %a, 2048
  %cmp = icmp sgt i32 %x, 0
  %spec.select = select i1 %cmp, i32 %add, i32 %b
  %0 = getelementptr inbounds i32, ptr %array1, i32 %add
  store i32 %spec.select, ptr %0, align 4
  %1 = getelementptr i32, ptr %array1, i32 %a
  %arrayidx4 = getelementptr i8, ptr %1, i32 8196
  store i32 %spec.select, ptr %arrayidx4
  %arrayidx6 = getelementptr i8, ptr %1, i32 8312
  store i32 %add, ptr %arrayidx6
  ret void
}

define i32 @add_shl_moreOneUse_sh1add(i32 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh1add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 1
; NO-ZBA-NEXT:    ori a0, a0, 2
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh1add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh1add a0, a0, a0
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_sh1add:
; XANDESPERF:       # %bb.0:
; XANDESPERF-NEXT:    ori a0, a0, 1
; XANDESPERF-NEXT:    nds.lea.h a0, a0, a0
; XANDESPERF-NEXT:    ret
  %or = or i32 %x, 1
  %mul = shl i32 %or, 1
  %add = add i32 %mul, %or
  ret i32 %add
}

define i32 @add_shl_moreOneUse_sh2add(i32 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh2add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 2
; NO-ZBA-NEXT:    ori a0, a0, 4
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh2add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh2add a0, a0, a0
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_sh2add:
; XANDESPERF:       # %bb.0:
; XANDESPERF-NEXT:    ori a0, a0, 1
; XANDESPERF-NEXT:    nds.lea.w a0, a0, a0
; XANDESPERF-NEXT:    ret
  %or = or i32 %x, 1
  %mul = shl i32 %or, 2
  %add = add i32 %mul, %or
  ret i32 %add
}

define i32 @add_shl_moreOneUse_sh3add(i32 %x) {
; NO-ZBA-LABEL: add_shl_moreOneUse_sh3add:
; NO-ZBA:       # %bb.0:
; NO-ZBA-NEXT:    ori a1, a0, 1
; NO-ZBA-NEXT:    slli a0, a0, 3
; NO-ZBA-NEXT:    ori a0, a0, 8
; NO-ZBA-NEXT:    add a0, a0, a1
; NO-ZBA-NEXT:    ret
;
; ZBA-LABEL: add_shl_moreOneUse_sh3add:
; ZBA:       # %bb.0:
; ZBA-NEXT:    ori a0, a0, 1
; ZBA-NEXT:    sh3add a0, a0, a0
; ZBA-NEXT:    ret
;
; XANDESPERF-LABEL: add_shl_moreOneUse_sh3add:
; XANDESPERF:       # %bb.0:
; XANDESPERF-NEXT:    ori a0, a0, 1
; XANDESPERF-NEXT:    nds.lea.d a0, a0, a0
; XANDESPERF-NEXT:    ret
  %or = or i32 %x, 1
  %mul = shl i32 %or, 3
  %add = add i32 %mul, %or
  ret i32 %add
}

define i32 @add_shl_moreOneUse_sh4add(i32 %x) {
; RV32-LABEL: add_shl_moreOneUse_sh4add:
; RV32:       # %bb.0:
; RV32-NEXT:    ori a1, a0, 1
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    ori a0, a0, 16
; RV32-NEXT:    add a0, a0, a1
; RV32-NEXT:    ret
  %or = or i32 %x, 1
  %mul = shl i32 %or, 4
  %add = add i32 %mul, %or
  ret i32 %add
}
