; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

;; fsqrt
define void @sqrt_v4f32(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: sqrt_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfsqrt.s $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x float>, ptr %a0, align 16
  %sqrt = call <4 x float> @llvm.sqrt.v4f32 (<4 x float> %v0)
  store <4 x float> %sqrt, ptr %res, align 16
  ret void
}

define void @sqrt_v2f64(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: sqrt_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfsqrt.d $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0, align 16
  %sqrt = call <2 x double> @llvm.sqrt.v2f64 (<2 x double> %v0)
  store <2 x double> %sqrt, ptr %res, align 16
  ret void
}

;; 1.0 / (fsqrt vec)
define void @one_div_sqrt_v4f32(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_div_sqrt_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfrsqrt.s $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x float>, ptr %a0, align 16
  %sqrt = call <4 x float> @llvm.sqrt.v4f32 (<4 x float> %v0)
  %div = fdiv <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>, %sqrt
  store <4 x float> %div, ptr %res, align 16
  ret void
}

define void @one_div_sqrt_v2f64(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_div_sqrt_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfrsqrt.d $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0, align 16
  %sqrt = call <2 x double> @llvm.sqrt.v2f64 (<2 x double> %v0)
  %div = fdiv <2 x double> <double 1.0, double 1.0>, %sqrt
  store <2 x double> %div, ptr %res, align 16
  ret void
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
