; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64

declare i8 @llvm.ctlz.i8(i8, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i64 @llvm.ctlz.i64(i64, i1)
declare i8 @llvm.ctpop.i8(i8)
declare i16 @llvm.ctpop.i16(i16)
declare i32 @llvm.ctpop.i32(i32)
declare i64 @llvm.ctpop.i64(i64)
declare i8 @llvm.cttz.i8(i8, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i64 @llvm.cttz.i64(i64, i1)

define i8 @test_ctlz_i8(i8 %a) nounwind {
; LA32R-LABEL: test_ctlz_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a1, $a0, 254
; LA32R-NEXT:    srli.w $a1, $a1, 1
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 252
; LA32R-NEXT:    srli.w $a1, $a1, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 240
; LA32R-NEXT:    srli.w $a1, $a1, 4
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    andi $a1, $a1, 85
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 51
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    andi $a0, $a0, 51
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a0, $a0, 15
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctlz_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 255
; LA32S-NEXT:    clz.w $a0, $a0
; LA32S-NEXT:    addi.w $a0, $a0, -24
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -56
; LA64-NEXT:    ret
  %tmp = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_ctlz_i16(i16 %a) nounwind {
; LA32R-LABEL: test_ctlz_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a1, 15
; LA32R-NEXT:    ori $a2, $a1, 4094
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    srli.w $a2, $a2, 1
; LA32R-NEXT:    or $a0, $a0, $a2
; LA32R-NEXT:    ori $a2, $a1, 4092
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    srli.w $a2, $a2, 2
; LA32R-NEXT:    or $a0, $a0, $a2
; LA32R-NEXT:    ori $a2, $a1, 4080
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    srli.w $a2, $a2, 4
; LA32R-NEXT:    or $a0, $a0, $a2
; LA32R-NEXT:    ori $a1, $a1, 3840
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a1, 8
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 5
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 3
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 15
; LA32R-NEXT:    andi $a0, $a0, 3840
; LA32R-NEXT:    srli.w $a0, $a0, 8
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctlz_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32S-NEXT:    clz.w $a0, $a0
; LA32S-NEXT:    addi.w $a0, $a0, -16
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    addi.d $a0, $a0, -48
; LA64-NEXT:    ret
  %tmp = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_ctlz_i32(i32 %a) nounwind {
; LA32R-LABEL: test_ctlz_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 349525
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 209715
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 61680
; LA32R-NEXT:    ori $a1, $a1, 3855
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 4112
; LA32R-NEXT:    ori $a1, $a1, 257
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctlz_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    clz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    clz.w $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_ctlz_i64(i64 %a) nounwind {
; LA32R-LABEL: test_ctlz_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 349525
; LA32R-NEXT:    ori $a5, $a2, 1365
; LA32R-NEXT:    lu12i.w $a2, 209715
; LA32R-NEXT:    ori $a4, $a2, 819
; LA32R-NEXT:    lu12i.w $a2, 61680
; LA32R-NEXT:    ori $a2, $a2, 3855
; LA32R-NEXT:    lu12i.w $a3, 4112
; LA32R-NEXT:    ori $a3, $a3, 257
; LA32R-NEXT:    bne $a1, $zero, .LBB3_2
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    and $a1, $a1, $a5
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    and $a1, $a0, $a4
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a4
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    mul.w $a0, $a0, $a3
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    addi.w $a0, $a0, 32
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB3_2:
; LA32R-NEXT:    srli.w $a0, $a1, 1
; LA32R-NEXT:    or $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    and $a1, $a1, $a5
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    and $a1, $a0, $a4
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a4
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    mul.w $a0, $a0, $a3
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctlz_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    sltu $a2, $zero, $a1
; LA32S-NEXT:    clz.w $a1, $a1
; LA32S-NEXT:    maskeqz $a1, $a1, $a2
; LA32S-NEXT:    clz.w $a0, $a0
; LA32S-NEXT:    addi.w $a0, $a0, 32
; LA32S-NEXT:    masknez $a0, $a0, $a2
; LA32S-NEXT:    or $a0, $a1, $a0
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctlz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    clz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_not_ctlz_i8(i8 %a) nounwind {
; LA32R-LABEL: test_not_ctlz_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    ori $a1, $zero, 254
; LA32R-NEXT:    andn $a1, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a1, 1
; LA32R-NEXT:    orn $a0, $a1, $a0
; LA32R-NEXT:    andi $a1, $a0, 252
; LA32R-NEXT:    srli.w $a1, $a1, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 240
; LA32R-NEXT:    srli.w $a1, $a1, 4
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    andi $a1, $a1, 85
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 51
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    andi $a0, $a0, 51
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a0, $a0, 15
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_ctlz_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a0, $a0, 24
; LA32S-NEXT:    clo.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a0, $a0, 56
; LA64-NEXT:    clo.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i8 %a, -1
  %tmp = call i8 @llvm.ctlz.i8(i8 %neg, i1 false)
  ret i8 %tmp
}

define i16 @test_not_ctlz_i16(i16 %a) nounwind {
; LA32R-LABEL: test_not_ctlz_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a1, 15
; LA32R-NEXT:    ori $a2, $a1, 4094
; LA32R-NEXT:    andn $a2, $a2, $a0
; LA32R-NEXT:    srli.w $a2, $a2, 1
; LA32R-NEXT:    orn $a0, $a2, $a0
; LA32R-NEXT:    ori $a2, $a1, 4092
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    srli.w $a2, $a2, 2
; LA32R-NEXT:    or $a0, $a0, $a2
; LA32R-NEXT:    ori $a2, $a1, 4080
; LA32R-NEXT:    and $a2, $a0, $a2
; LA32R-NEXT:    srli.w $a2, $a2, 4
; LA32R-NEXT:    or $a0, $a0, $a2
; LA32R-NEXT:    ori $a1, $a1, 3840
; LA32R-NEXT:    and $a1, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a1, 8
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 5
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 3
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 15
; LA32R-NEXT:    andi $a0, $a0, 3840
; LA32R-NEXT:    srli.w $a0, $a0, 8
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_ctlz_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    slli.w $a0, $a0, 16
; LA32S-NEXT:    clo.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    slli.d $a0, $a0, 48
; LA64-NEXT:    clo.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i16 %a, -1
  %tmp = call i16 @llvm.ctlz.i16(i16 %neg, i1 false)
  ret i16 %tmp
}

define i32 @test_not_ctlz_i32(i32 %a) nounwind {
; LA32R-LABEL: test_not_ctlz_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    nor $a1, $a0, $zero
; LA32R-NEXT:    srli.w $a1, $a1, 1
; LA32R-NEXT:    orn $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 349525
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 209715
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 61680
; LA32R-NEXT:    ori $a1, $a1, 3855
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 4112
; LA32R-NEXT:    ori $a1, $a1, 257
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_ctlz_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    clo.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    clo.w $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i32 %a, -1
  %tmp = call i32 @llvm.ctlz.i32(i32 %neg, i1 false)
  ret i32 %tmp
}

define i64 @test_not_ctlz_i64(i64 %a) nounwind {
; LA32R-LABEL: test_not_ctlz_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    nor $a6, $a1, $zero
; LA32R-NEXT:    lu12i.w $a2, 349525
; LA32R-NEXT:    ori $a5, $a2, 1365
; LA32R-NEXT:    lu12i.w $a2, 209715
; LA32R-NEXT:    ori $a4, $a2, 819
; LA32R-NEXT:    lu12i.w $a2, 61680
; LA32R-NEXT:    ori $a2, $a2, 3855
; LA32R-NEXT:    lu12i.w $a3, 4112
; LA32R-NEXT:    ori $a3, $a3, 257
; LA32R-NEXT:    bne $a6, $zero, .LBB7_2
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    nor $a1, $a0, $zero
; LA32R-NEXT:    srli.w $a1, $a1, 1
; LA32R-NEXT:    orn $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    and $a1, $a1, $a5
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    and $a1, $a0, $a4
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a4
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    mul.w $a0, $a0, $a3
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    addi.w $a0, $a0, 32
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB7_2:
; LA32R-NEXT:    srli.w $a0, $a6, 1
; LA32R-NEXT:    orn $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 2
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 8
; LA32R-NEXT:    or $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 16
; LA32R-NEXT:    nor $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    and $a1, $a1, $a5
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    and $a1, $a0, $a4
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a4
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    mul.w $a0, $a0, $a3
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_ctlz_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    nor $a2, $a1, $zero
; LA32S-NEXT:    sltu $a2, $zero, $a2
; LA32S-NEXT:    clo.w $a0, $a0
; LA32S-NEXT:    addi.w $a0, $a0, 32
; LA32S-NEXT:    masknez $a0, $a0, $a2
; LA32S-NEXT:    clo.w $a1, $a1
; LA32S-NEXT:    maskeqz $a1, $a1, $a2
; LA32S-NEXT:    or $a0, $a1, $a0
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_ctlz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    clo.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i64 %a, -1
  %tmp = call i64 @llvm.ctlz.i64(i64 %neg, i1 false)
  ret i64 %tmp
}

define i8 @test_ctpop_i8(i8 %a) nounwind {
; LA32R-LABEL: test_ctpop_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    andi $a1, $a1, 85
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 51
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    andi $a0, $a0, 51
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a0, $a0, 15
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctpop_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srli.w $a1, $a0, 1
; LA32S-NEXT:    andi $a1, $a1, 85
; LA32S-NEXT:    sub.w $a0, $a0, $a1
; LA32S-NEXT:    andi $a1, $a0, 51
; LA32S-NEXT:    srli.w $a0, $a0, 2
; LA32S-NEXT:    andi $a0, $a0, 51
; LA32S-NEXT:    add.w $a0, $a1, $a0
; LA32S-NEXT:    srli.w $a1, $a0, 4
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    andi $a0, $a0, 15
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    vldi $vr0, 0
; LA64-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; LA64-NEXT:    vpcnt.d $vr0, $vr0
; LA64-NEXT:    vpickve2gr.d $a0, $vr0, 0
; LA64-NEXT:    ret
  %1 = call i8 @llvm.ctpop.i8(i8 %a)
  ret i8 %1
}

define i16 @test_ctpop_i16(i16 %a) nounwind {
; LA32R-LABEL: test_ctpop_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 5
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 3
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 15
; LA32R-NEXT:    andi $a0, $a0, 3840
; LA32R-NEXT:    srli.w $a0, $a0, 8
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctpop_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srli.w $a1, $a0, 1
; LA32S-NEXT:    lu12i.w $a2, 5
; LA32S-NEXT:    ori $a2, $a2, 1365
; LA32S-NEXT:    and $a1, $a1, $a2
; LA32S-NEXT:    sub.w $a0, $a0, $a1
; LA32S-NEXT:    lu12i.w $a1, 3
; LA32S-NEXT:    ori $a1, $a1, 819
; LA32S-NEXT:    and $a2, $a0, $a1
; LA32S-NEXT:    srli.w $a0, $a0, 2
; LA32S-NEXT:    and $a0, $a0, $a1
; LA32S-NEXT:    add.w $a0, $a2, $a0
; LA32S-NEXT:    srli.w $a1, $a0, 4
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    bstrpick.w $a1, $a0, 11, 8
; LA32S-NEXT:    andi $a0, $a0, 15
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    vldi $vr0, 0
; LA64-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; LA64-NEXT:    vpcnt.d $vr0, $vr0
; LA64-NEXT:    vpickve2gr.d $a0, $vr0, 0
; LA64-NEXT:    ret
  %1 = call i16 @llvm.ctpop.i16(i16 %a)
  ret i16 %1
}

define i32 @test_ctpop_i32(i32 %a) nounwind {
; LA32R-LABEL: test_ctpop_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 349525
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 209715
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 61680
; LA32R-NEXT:    ori $a1, $a1, 3855
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 4112
; LA32R-NEXT:    ori $a1, $a1, 257
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctpop_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srli.w $a1, $a0, 1
; LA32S-NEXT:    lu12i.w $a2, 349525
; LA32S-NEXT:    ori $a2, $a2, 1365
; LA32S-NEXT:    and $a1, $a1, $a2
; LA32S-NEXT:    sub.w $a0, $a0, $a1
; LA32S-NEXT:    lu12i.w $a1, 209715
; LA32S-NEXT:    ori $a1, $a1, 819
; LA32S-NEXT:    and $a2, $a0, $a1
; LA32S-NEXT:    srli.w $a0, $a0, 2
; LA32S-NEXT:    and $a0, $a0, $a1
; LA32S-NEXT:    add.w $a0, $a2, $a0
; LA32S-NEXT:    srli.w $a1, $a0, 4
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    lu12i.w $a1, 61680
; LA32S-NEXT:    ori $a1, $a1, 3855
; LA32S-NEXT:    and $a0, $a0, $a1
; LA32S-NEXT:    lu12i.w $a1, 4112
; LA32S-NEXT:    ori $a1, $a1, 257
; LA32S-NEXT:    mul.w $a0, $a0, $a1
; LA32S-NEXT:    srli.w $a0, $a0, 24
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    bstrpick.d $a0, $a0, 31, 0
; LA64-NEXT:    vldi $vr0, 0
; LA64-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; LA64-NEXT:    vpcnt.d $vr0, $vr0
; LA64-NEXT:    vpickve2gr.d $a0, $vr0, 0
; LA64-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

define i64 @test_ctpop_i64(i64 %a) nounwind {
; LA32R-LABEL: test_ctpop_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    srli.w $a2, $a1, 1
; LA32R-NEXT:    lu12i.w $a3, 349525
; LA32R-NEXT:    ori $a3, $a3, 1365
; LA32R-NEXT:    and $a2, $a2, $a3
; LA32R-NEXT:    sub.w $a1, $a1, $a2
; LA32R-NEXT:    lu12i.w $a2, 209715
; LA32R-NEXT:    ori $a2, $a2, 819
; LA32R-NEXT:    and $a4, $a1, $a2
; LA32R-NEXT:    srli.w $a1, $a1, 2
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    add.w $a1, $a4, $a1
; LA32R-NEXT:    srli.w $a4, $a1, 4
; LA32R-NEXT:    add.w $a1, $a1, $a4
; LA32R-NEXT:    lu12i.w $a4, 61680
; LA32R-NEXT:    ori $a4, $a4, 3855
; LA32R-NEXT:    and $a1, $a1, $a4
; LA32R-NEXT:    lu12i.w $a5, 4112
; LA32R-NEXT:    ori $a5, $a5, 257
; LA32R-NEXT:    mul.w $a1, $a1, $a5
; LA32R-NEXT:    srli.w $a1, $a1, 24
; LA32R-NEXT:    srli.w $a6, $a0, 1
; LA32R-NEXT:    and $a3, $a6, $a3
; LA32R-NEXT:    sub.w $a0, $a0, $a3
; LA32R-NEXT:    and $a3, $a0, $a2
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a2
; LA32R-NEXT:    add.w $a0, $a3, $a0
; LA32R-NEXT:    srli.w $a2, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a2
; LA32R-NEXT:    and $a0, $a0, $a4
; LA32R-NEXT:    mul.w $a0, $a0, $a5
; LA32R-NEXT:    srli.w $a0, $a0, 24
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_ctpop_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    srli.w $a2, $a1, 1
; LA32S-NEXT:    lu12i.w $a3, 349525
; LA32S-NEXT:    ori $a3, $a3, 1365
; LA32S-NEXT:    and $a2, $a2, $a3
; LA32S-NEXT:    sub.w $a1, $a1, $a2
; LA32S-NEXT:    lu12i.w $a2, 209715
; LA32S-NEXT:    ori $a2, $a2, 819
; LA32S-NEXT:    and $a4, $a1, $a2
; LA32S-NEXT:    srli.w $a1, $a1, 2
; LA32S-NEXT:    and $a1, $a1, $a2
; LA32S-NEXT:    add.w $a1, $a4, $a1
; LA32S-NEXT:    srli.w $a4, $a1, 4
; LA32S-NEXT:    add.w $a1, $a1, $a4
; LA32S-NEXT:    lu12i.w $a4, 61680
; LA32S-NEXT:    ori $a4, $a4, 3855
; LA32S-NEXT:    and $a1, $a1, $a4
; LA32S-NEXT:    lu12i.w $a5, 4112
; LA32S-NEXT:    ori $a5, $a5, 257
; LA32S-NEXT:    mul.w $a1, $a1, $a5
; LA32S-NEXT:    srli.w $a1, $a1, 24
; LA32S-NEXT:    srli.w $a6, $a0, 1
; LA32S-NEXT:    and $a3, $a6, $a3
; LA32S-NEXT:    sub.w $a0, $a0, $a3
; LA32S-NEXT:    and $a3, $a0, $a2
; LA32S-NEXT:    srli.w $a0, $a0, 2
; LA32S-NEXT:    and $a0, $a0, $a2
; LA32S-NEXT:    add.w $a0, $a3, $a0
; LA32S-NEXT:    srli.w $a2, $a0, 4
; LA32S-NEXT:    add.w $a0, $a0, $a2
; LA32S-NEXT:    and $a0, $a0, $a4
; LA32S-NEXT:    mul.w $a0, $a0, $a5
; LA32S-NEXT:    srli.w $a0, $a0, 24
; LA32S-NEXT:    add.w $a0, $a0, $a1
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_ctpop_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    vldi $vr0, 0
; LA64-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; LA64-NEXT:    vpcnt.d $vr0, $vr0
; LA64-NEXT:    vpickve2gr.d $a0, $vr0, 0
; LA64-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %1
}

define i8 @test_cttz_i8(i8 %a) nounwind {
; LA32R-LABEL: test_cttz_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $a0, -1
; LA32R-NEXT:    andn $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    andi $a1, $a1, 85
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 51
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    andi $a0, $a0, 51
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a0, $a0, 15
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_cttz_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a0, $a0, 256
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_cttz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a0, $a0, 256
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i8 @llvm.cttz.i8(i8 %a, i1 false)
  ret i8 %tmp
}

define i16 @test_cttz_i16(i16 %a) nounwind {
; LA32R-LABEL: test_cttz_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $a0, -1
; LA32R-NEXT:    andn $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 5
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 3
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 15
; LA32R-NEXT:    andi $a0, $a0, 3840
; LA32R-NEXT:    srli.w $a0, $a0, 8
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_cttz_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a1, 16
; LA32S-NEXT:    or $a0, $a0, $a1
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_cttz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 16
; LA64-NEXT:    or $a0, $a0, $a1
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i16 @llvm.cttz.i16(i16 %a, i1 false)
  ret i16 %tmp
}

define i32 @test_cttz_i32(i32 %a) nounwind {
; LA32R-LABEL: test_cttz_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    bne $a0, $zero, .LBB14_2
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    ori $a0, $zero, 32
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB14_2:
; LA32R-NEXT:    sub.w $a1, $zero, $a0
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 30667
; LA32R-NEXT:    ori $a1, $a1, 1329
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 27
; LA32R-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI14_0)
; LA32R-NEXT:    addi.w $a1, $a1, %pc_lo12(.LCPI14_0)
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ld.bu $a0, $a0, 0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_cttz_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_cttz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    ctz.w $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i64 @test_cttz_i64(i64 %a) nounwind {
; LA32R-LABEL: test_cttz_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    lu12i.w $a2, 30667
; LA32R-NEXT:    ori $a2, $a2, 1329
; LA32R-NEXT:    pcalau12i $a3, %pc_hi20(.LCPI15_0)
; LA32R-NEXT:    addi.w $a3, $a3, %pc_lo12(.LCPI15_0)
; LA32R-NEXT:    bne $a1, $zero, .LBB15_3
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    ori $a1, $zero, 32
; LA32R-NEXT:    beq $a0, $zero, .LBB15_4
; LA32R-NEXT:  .LBB15_2:
; LA32R-NEXT:    sub.w $a1, $zero, $a0
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    mul.w $a0, $a0, $a2
; LA32R-NEXT:    srli.w $a0, $a0, 27
; LA32R-NEXT:    add.w $a0, $a3, $a0
; LA32R-NEXT:    ld.bu $a0, $a0, 0
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB15_3:
; LA32R-NEXT:    sub.w $a4, $zero, $a1
; LA32R-NEXT:    and $a1, $a1, $a4
; LA32R-NEXT:    mul.w $a1, $a1, $a2
; LA32R-NEXT:    srli.w $a1, $a1, 27
; LA32R-NEXT:    add.w $a1, $a3, $a1
; LA32R-NEXT:    ld.bu $a1, $a1, 0
; LA32R-NEXT:    bne $a0, $zero, .LBB15_2
; LA32R-NEXT:  .LBB15_4:
; LA32R-NEXT:    addi.w $a0, $a1, 32
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_cttz_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    sltu $a2, $zero, $a0
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    maskeqz $a0, $a0, $a2
; LA32S-NEXT:    ctz.w $a1, $a1
; LA32S-NEXT:    addi.w $a1, $a1, 32
; LA32S-NEXT:    masknez $a1, $a1, $a2
; LA32S-NEXT:    or $a0, $a0, $a1
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_cttz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %tmp = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %tmp
}

define i8 @test_not_cttz_i8(i8 %a) nounwind {
; LA32R-LABEL: test_not_cttz_i8:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $a0, 1
; LA32R-NEXT:    andn $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    andi $a1, $a1, 85
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 51
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    andi $a0, $a0, 51
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a0, $a0, 15
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_cttz_i8:
; LA32S:       # %bb.0:
; LA32S-NEXT:    ori $a1, $zero, 256
; LA32S-NEXT:    orn $a0, $a1, $a0
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i8:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a1, $zero, 256
; LA64-NEXT:    orn $a0, $a1, $a0
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i8 %a, -1
  %tmp = call i8 @llvm.cttz.i8(i8 %neg, i1 false)
  ret i8 %tmp
}

define i16 @test_not_cttz_i16(i16 %a) nounwind {
; LA32R-LABEL: test_not_cttz_i16:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $a1, $a0, 1
; LA32R-NEXT:    andn $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a1, $a0, 1
; LA32R-NEXT:    lu12i.w $a2, 5
; LA32R-NEXT:    ori $a2, $a2, 1365
; LA32R-NEXT:    and $a1, $a1, $a2
; LA32R-NEXT:    sub.w $a0, $a0, $a1
; LA32R-NEXT:    lu12i.w $a1, 3
; LA32R-NEXT:    ori $a1, $a1, 819
; LA32R-NEXT:    and $a2, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 2
; LA32R-NEXT:    and $a0, $a0, $a1
; LA32R-NEXT:    add.w $a0, $a2, $a0
; LA32R-NEXT:    srli.w $a1, $a0, 4
; LA32R-NEXT:    add.w $a0, $a0, $a1
; LA32R-NEXT:    andi $a1, $a0, 15
; LA32R-NEXT:    andi $a0, $a0, 3840
; LA32R-NEXT:    srli.w $a0, $a0, 8
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_cttz_i16:
; LA32S:       # %bb.0:
; LA32S-NEXT:    lu12i.w $a1, 16
; LA32S-NEXT:    orn $a0, $a1, $a0
; LA32S-NEXT:    ctz.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i16:
; LA64:       # %bb.0:
; LA64-NEXT:    lu12i.w $a1, 16
; LA64-NEXT:    orn $a0, $a1, $a0
; LA64-NEXT:    ctz.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i16 %a, -1
  %tmp = call i16 @llvm.cttz.i16(i16 %neg, i1 false)
  ret i16 %tmp
}

define i32 @test_not_cttz_i32(i32 %a) nounwind {
; LA32R-LABEL: test_not_cttz_i32:
; LA32R:       # %bb.0:
; LA32R-NEXT:    nor $a1, $a0, $zero
; LA32R-NEXT:    bne $a1, $zero, .LBB18_2
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    ori $a0, $zero, 32
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB18_2:
; LA32R-NEXT:    sub.w $a1, $zero, $a1
; LA32R-NEXT:    andn $a0, $a1, $a0
; LA32R-NEXT:    lu12i.w $a1, 30667
; LA32R-NEXT:    ori $a1, $a1, 1329
; LA32R-NEXT:    mul.w $a0, $a0, $a1
; LA32R-NEXT:    srli.w $a0, $a0, 27
; LA32R-NEXT:    pcalau12i $a1, %pc_hi20(.LCPI18_0)
; LA32R-NEXT:    addi.w $a1, $a1, %pc_lo12(.LCPI18_0)
; LA32R-NEXT:    add.w $a0, $a1, $a0
; LA32R-NEXT:    ld.bu $a0, $a0, 0
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_cttz_i32:
; LA32S:       # %bb.0:
; LA32S-NEXT:    cto.w $a0, $a0
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i32:
; LA64:       # %bb.0:
; LA64-NEXT:    cto.w $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i32 %a, -1
  %tmp = call i32 @llvm.cttz.i32(i32 %neg, i1 false)
  ret i32 %tmp
}

define i64 @test_not_cttz_i64(i64 %a) nounwind {
; LA32R-LABEL: test_not_cttz_i64:
; LA32R:       # %bb.0:
; LA32R-NEXT:    nor $a5, $a1, $zero
; LA32R-NEXT:    nor $a2, $a0, $zero
; LA32R-NEXT:    lu12i.w $a3, 30667
; LA32R-NEXT:    ori $a3, $a3, 1329
; LA32R-NEXT:    pcalau12i $a4, %pc_hi20(.LCPI19_0)
; LA32R-NEXT:    addi.w $a4, $a4, %pc_lo12(.LCPI19_0)
; LA32R-NEXT:    bne $a5, $zero, .LBB19_3
; LA32R-NEXT:  # %bb.1:
; LA32R-NEXT:    ori $a1, $zero, 32
; LA32R-NEXT:    beq $a2, $zero, .LBB19_4
; LA32R-NEXT:  .LBB19_2:
; LA32R-NEXT:    sub.w $a1, $zero, $a2
; LA32R-NEXT:    andn $a0, $a1, $a0
; LA32R-NEXT:    mul.w $a0, $a0, $a3
; LA32R-NEXT:    srli.w $a0, $a0, 27
; LA32R-NEXT:    add.w $a0, $a4, $a0
; LA32R-NEXT:    ld.bu $a0, $a0, 0
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB19_3:
; LA32R-NEXT:    sub.w $a5, $zero, $a5
; LA32R-NEXT:    andn $a1, $a5, $a1
; LA32R-NEXT:    mul.w $a1, $a1, $a3
; LA32R-NEXT:    srli.w $a1, $a1, 27
; LA32R-NEXT:    add.w $a1, $a4, $a1
; LA32R-NEXT:    ld.bu $a1, $a1, 0
; LA32R-NEXT:    bne $a2, $zero, .LBB19_2
; LA32R-NEXT:  .LBB19_4:
; LA32R-NEXT:    addi.w $a0, $a1, 32
; LA32R-NEXT:    move $a1, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: test_not_cttz_i64:
; LA32S:       # %bb.0:
; LA32S-NEXT:    nor $a2, $a0, $zero
; LA32S-NEXT:    sltu $a2, $zero, $a2
; LA32S-NEXT:    cto.w $a1, $a1
; LA32S-NEXT:    addi.w $a1, $a1, 32
; LA32S-NEXT:    masknez $a1, $a1, $a2
; LA32S-NEXT:    cto.w $a0, $a0
; LA32S-NEXT:    maskeqz $a0, $a0, $a2
; LA32S-NEXT:    or $a0, $a0, $a1
; LA32S-NEXT:    move $a1, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: test_not_cttz_i64:
; LA64:       # %bb.0:
; LA64-NEXT:    cto.d $a0, $a0
; LA64-NEXT:    ret
  %neg = xor i64 %a, -1
  %tmp = call i64 @llvm.cttz.i64(i64 %neg, i1 false)
  ret i64 %tmp
}
