; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3

; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math-f32=preserve-sign < %s | FileCheck -check-prefixes=GCN-DAZ,GCN-DAZ-SAFE,SI-DAZ-SAFE %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math-f32=ieee < %s          | FileCheck -check-prefixes=GCN-IEEE,GCN-IEEE-SAFE,SI-IEEE-SAFE %s

; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=hawaii -denormal-fp-math-f32=preserve-sign < %s | FileCheck -check-prefixes=GCN-DAZ,GCN-DAZ-SAFE,CI-DAZ-SAFE %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=hawaii -denormal-fp-math-f32=ieee < %s          | FileCheck -check-prefixes=GCN-IEEE,GCN-IEEE-SAFE,CI-IEEE-SAFE %s


declare i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
declare float @llvm.sqrt.f32(float) nounwind readnone
declare <2 x float> @llvm.sqrt.v2f32(<2 x float>) nounwind readnone

define amdgpu_kernel void @rsq_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) {
; GCN-DAZ-SAFE-LABEL: rsq_f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s6, -1
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s10, s6
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s11, s7
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s8, s2
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s9, s3
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s2, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, s0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s5, s1
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s2, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v1, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v4, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v3, v3, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v4, v1, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-DAZ-SAFE-NEXT:    s_endpgm
;
; SI-IEEE-SAFE-LABEL: rsq_f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; SI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; SI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, 0x7f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e64 s[0:1], s0, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-IEEE-SAFE-NEXT:    s_endpgm
;
; CI-IEEE-SAFE-LABEL: rsq_f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; CI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; CI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e64 s[0:1], s0, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-IEEE-SAFE-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %in, align 4
  %sqrt = call contract float @llvm.sqrt.f32(float %val) nounwind readnone
  %div = fdiv contract float 1.0, %sqrt, !fpmath !0
  store float %div, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @rsq_f32_sgpr(ptr addrspace(1) noalias %out, float %val) {
; GCN-DAZ-SAFE-LABEL: rsq_f32_sgpr:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_load_dword s0, s[4:5], 0xb
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v0, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v1, 0x4f800000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s3, 0xf000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s2, -1
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, s0, v1
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, s0
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, -v1, v2, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v3, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v3, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, -v2, v2, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v3, v1, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GCN-DAZ-SAFE-NEXT:    s_endpgm
;
; SI-IEEE-SAFE-LABEL: rsq_f32_sgpr:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_load_dword s0, s[4:5], 0xb
; SI-IEEE-SAFE-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x9
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v0, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x4f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; SI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, s0, v1
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, s0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], s0, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v2, v1, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v2, vcc, -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-IEEE-SAFE-NEXT:    s_endpgm
;
; CI-IEEE-SAFE-LABEL: rsq_f32_sgpr:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_load_dword s0, s[4:5], 0xb
; CI-IEEE-SAFE-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x9
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v0, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x4f800000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; CI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, s0, v1
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, s0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], s0, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v2, v1, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v2, vcc, -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-IEEE-SAFE-NEXT:    s_endpgm
  %sqrt = call contract float @llvm.sqrt.f32(float %val) nounwind readnone
  %div = fdiv contract float 1.0, %sqrt, !fpmath !0
  store float %div, ptr addrspace(1) %out, align 4
  ret void
}

; Recognize that this is rsqrt(a) * rcp(b) * c,
; not 1 / ( 1 / sqrt(a)) * rcp(b) * c.

; NOTE: c * rcp( sqrt(a) * b ) is generated when we move rcp generation to AMGGPUCogenPrepare.
define amdgpu_kernel void @rsqrt_fmul(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; GCN-DAZ-SAFE-LABEL: rsqrt_fmul:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s3, 0xf000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s2, 0
; GCN-DAZ-SAFE-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v1, 0
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-DAZ-SAFE-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 glc
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64 offset:4 glc
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v4, v[0:1], s[8:11], 0 addr64 offset:8 glc
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v6, 0x260
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x4f800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v5, v2
; GCN-DAZ-SAFE-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v7, v2, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0.5, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v8, -v5, v7, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, v7, v8, v7
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v5, v8, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v8, -v7, v7, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v8, v5, v7
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v7, 0x37800000, v5
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v2, v6
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v2, v3
; GCN-DAZ-SAFE-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v4
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v5, v3
; GCN-DAZ-SAFE-NEXT:    v_div_scale_f32 v6, vcc, v4, v2, v4
; GCN-DAZ-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v8, -v3, v7, v6
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, -v3, v7, v6
; GCN-DAZ-SAFE-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GCN-DAZ-SAFE-NEXT:    v_div_fmas_f32 v3, v3, v5, v7
; GCN-DAZ-SAFE-NEXT:    v_div_fixup_f32 v2, v3, v2, v4
; GCN-DAZ-SAFE-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; GCN-DAZ-SAFE-NEXT:    s_endpgm
;
; GCN-IEEE-SAFE-LABEL: rsqrt_fmul:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x9
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s2, 0
; GCN-IEEE-SAFE-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GCN-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0
; GCN-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GCN-IEEE-SAFE-NEXT:    s_mov_b64 s[10:11], s[2:3]
; GCN-IEEE-SAFE-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 glc
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-IEEE-SAFE-NEXT:    buffer_load_dword v3, v[0:1], s[8:11], 0 addr64 offset:4 glc
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-IEEE-SAFE-NEXT:    buffer_load_dword v4, v[0:1], s[8:11], 0 addr64 offset:8 glc
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; GCN-IEEE-SAFE-NEXT:    v_mov_b32_e32 v6, 0x260
; GCN-IEEE-SAFE-NEXT:    v_mul_f32_e32 v5, 0x4f800000, v2
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s0, v2
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GCN-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v5, v2
; GCN-IEEE-SAFE-NEXT:    v_add_i32_e64 v7, s[0:1], -1, v5
; GCN-IEEE-SAFE-NEXT:    v_add_i32_e64 v8, s[0:1], 1, v5
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v9, -v7, v5, v2
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v10, -v8, v5, v2
; GCN-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[0:1], 0, v9
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v5, v7, s[0:1]
; GCN-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], 0, v10
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[0:1]
; GCN-IEEE-SAFE-NEXT:    v_mul_f32_e32 v7, 0x37800000, v5
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GCN-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v2, v6
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc
; GCN-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, v2, v3
; GCN-IEEE-SAFE-NEXT:    v_div_scale_f32 v3, s[0:1], v2, v2, v4
; GCN-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v5, v3
; GCN-IEEE-SAFE-NEXT:    v_div_scale_f32 v6, vcc, v4, v2, v4
; GCN-IEEE-SAFE-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v7, -v3, v5, 1.0
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GCN-IEEE-SAFE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v8, -v3, v7, v6
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v3, v7, v6
; GCN-IEEE-SAFE-NEXT:    v_div_fmas_f32 v3, v3, v5, v7
; GCN-IEEE-SAFE-NEXT:    v_div_fixup_f32 v2, v3, v2, v4
; GCN-IEEE-SAFE-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; GCN-IEEE-SAFE-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() nounwind readnone
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %gep.0 = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.1 = getelementptr float, ptr addrspace(1) %gep.0, i32 1
  %gep.2 = getelementptr float, ptr addrspace(1) %gep.0, i32 2

  %a = load volatile float, ptr addrspace(1) %gep.0
  %b = load volatile float, ptr addrspace(1) %gep.1
  %c = load volatile float, ptr addrspace(1) %gep.2

  %x = call contract float @llvm.sqrt.f32(float %a)
  %y = fmul contract float %x, %b
  %z = fdiv contract float %c, %y
  store float %z, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @neg_rsq_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) {
; GCN-DAZ-SAFE-LABEL: neg_rsq_f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s6, -1
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s10, s6
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s11, s7
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s8, s2
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s9, s3
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s2, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, s0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s5, s1
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s2, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v1, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v4, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v3, v3, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v4, v1, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-DAZ-SAFE-NEXT:    s_endpgm
;
; SI-IEEE-SAFE-LABEL: neg_rsq_f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; SI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; SI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, 0x7f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e64 s[0:1], s0, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], |v0|, s2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v0, v1, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-IEEE-SAFE-NEXT:    s_endpgm
;
; CI-IEEE-SAFE-LABEL: neg_rsq_f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; CI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; CI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e64 s[0:1], s0, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, v0, v2, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-IEEE-SAFE-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %in, align 4
  %sqrt = call contract float @llvm.sqrt.f32(float %val)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  store float %div, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @neg_rsq_neg_f32(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) {
; GCN-DAZ-SAFE-LABEL: neg_rsq_neg_f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s6, -1
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s10, s6
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s11, s7
; GCN-DAZ-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s8, s2
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s9, s3
; GCN-DAZ-SAFE-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s2, 0x8f800000
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, s0
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s5, s1
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0xcf800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s2, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v1, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v4, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v3, v3, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v4, v1, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-DAZ-SAFE-NEXT:    s_endpgm
;
; SI-IEEE-SAFE-LABEL: neg_rsq_neg_f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; SI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; SI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0x8f800000
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s2, 0x7f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0xcf800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], s0, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; SI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], |v0|, s2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v0, v1, s[0:1]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-IEEE-SAFE-NEXT:    s_endpgm
;
; CI-IEEE-SAFE-LABEL: neg_rsq_neg_f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0xf000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, -1
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s2, s6
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s3, s7
; CI-IEEE-SAFE-NEXT:    s_waitcnt lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, s10
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s1, s11
; CI-IEEE-SAFE-NEXT:    buffer_load_dword v0, off, s[0:3], 0
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s0, 0x8f800000
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v1, 0x260
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, s8
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s5, s9
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0)
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0xcf800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[0:1], s0, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v3, vcc, -1, v2
; CI-IEEE-SAFE-NEXT:    v_add_i32_e32 v4, vcc, 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, v0
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v4, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e32 vcc, 0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v3, s[0:1]
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-IEEE-SAFE-NEXT:    s_endpgm
  %val = load float, ptr addrspace(1) %in, align 4
  %val.fneg = fneg float %val
  %sqrt = call contract float @llvm.sqrt.f32(float %val.fneg)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  store float %div, ptr addrspace(1) %out, align 4
  ret void
}

define float @v_neg_rsq_neg_f32(float %val) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_neg_f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0xcf800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, -v1, v2, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v3, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v2, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v3, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v4, v1, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_neg_f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0xcf800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v0, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_neg_f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0xcf800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v1, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %val.fneg = fneg float %val
  %sqrt = call contract float @llvm.sqrt.f32(float %val.fneg)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  ret float %div
}

define <2 x float> @v_neg_rsq_neg_v2f32(<2 x float> %val) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_neg_v2f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s5, 0x4f800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e64 v2, -v1, s5
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v2, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v1, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v3, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v4, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v5, v2, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e64 v3, -v0, s5
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v3, v0
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v4, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v0, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0.5, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v6, -v2, v2, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v5, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v6, v3, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v1, -v1
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_neg_v2f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x8f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0x4f800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v2, -v1, s7
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v1
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v4, -v0, s7
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v0
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v2, v4, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], 1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v5, v4, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v0, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v2, v1
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_neg_v2f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x8f800000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0x4f800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v2, -v1, s7
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v1
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v4, -v0, s7
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v0
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v2, v4, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], 1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v5, v4, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v2, v1
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %val.fneg = fneg <2 x float> %val
  %sqrt = call contract <2 x float> @llvm.sqrt.v2f32(<2 x float> %val.fneg)
  %div = fdiv contract <2 x float> <float -1.0, float -1.0>, %sqrt, !fpmath !0
  ret <2 x float> %div
}

define float @v_neg_rsq_neg_f32_foldable_user(float %val0, float %val1) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_neg_f32_foldable_user:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0xcf800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v2, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v3, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v4, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v5, v2, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_neg_f32_foldable_user:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0xcf800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v0, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_neg_f32_foldable_user:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0xcf800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %val0.neg = fneg float %val0
  %sqrt = call contract float @llvm.sqrt.f32(float %val0.neg)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  %user = fmul contract float %div, %val1
  ret float %user
}

define <2 x float> @v_neg_rsq_neg_v2f32_foldable_user(<2 x float> %val0, <2 x float> %val1) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_neg_v2f32_foldable_user:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0x8f800000
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s5, 0x4f800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e64 v4, -v1, s5
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v4, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v4, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, v1, v4
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v4, 0.5, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v6, -v4, v5, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v5, v6, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, -v5, v5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v4, v6, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v7, v4, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e64 v5, -v0, s5
; GCN-DAZ-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v5, v0
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v6, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v6
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v4, v0, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0.5, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, -v5, v4, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v4, v7, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v8, -v4, v4, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v5, v7, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v8, v5, v4
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v6
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v1, -v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_neg_v2f32_foldable_user:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x8f800000
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0x4f800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v4, -v1, s7
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v1
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], -1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v5, v4, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v6, s[4:5], 1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v6, v4, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v5, v6, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v6, -v0, s7
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v6, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v6, v0
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v5, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], -1, v6
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v7, -v4, v6, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v7
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v6, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v7, s[4:5], 1, v6
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v7, v6, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x37800000, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, -v0, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v4, v0
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, -v1, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v4, v1
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_neg_v2f32_foldable_user:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x8f800000
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s7, 0x4f800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v4, -v1, s7
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v1, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v1
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], -1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v5, v4, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v6, s[4:5], 1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v6, v4, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v5, v6, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e64 v6, -v0, s7
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e32 vcc, s6, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v0, -v0, v6, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v6, v0
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v5, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], -1, v6
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v7, -v4, v6, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v7
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v6, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v7, s[4:5], 1, v6
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v7, v6, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x37800000, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v4, v0
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v1
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v4, v1
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %val0.fneg = fneg <2 x float> %val0
  %sqrt = call contract <2 x float> @llvm.sqrt.v2f32(<2 x float> %val0.fneg)
  %div = fdiv contract <2 x float> <float -1.0, float -1.0>, %sqrt, !fpmath !0
  %user = fmul contract <2 x float> %div, %val1
  ret <2 x float> %user
}

define float @v_neg_rsq_f32(float %val) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v0, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, -v1, v2, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v3, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v2, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v1, v3, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v1, v4, v1, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, -v0, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v1, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  ret float %div
}

define <2 x float> @v_neg_rsq_v2f32(<2 x float> %val) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_v2f32:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v2, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v1, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v3, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v4, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v5, v2, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v3, v0
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v4, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, v0, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0.5, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v2, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v6, -v2, v2, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v5, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v6, v3, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v1, -v1
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_v2f32:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v1
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v0
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v2, v4, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], 1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v5, v4, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v0, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v2, v1
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_v2f32:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v1
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v0
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v1, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v5, -v2, v4, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], 1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v5, v4, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v1
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v2, v1
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract <2 x float> @llvm.sqrt.v2f32(<2 x float> %val)
  %div = fdiv contract <2 x float> <float -1.0, float -1.0>, %sqrt, !fpmath !0
  ret <2 x float> %div
}

define float @v_neg_rsq_f32_foldable_user(float %val0, float %val1) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_f32_foldable_user:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v2, v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, -v2, v3, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v3, v3, v4, v3
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, -v3, v3, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v2, v4, v2
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v2, v5, v2, v3
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_f32_foldable_user:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, -v0, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_f32_foldable_user:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], -1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v3, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v3, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], 1, v2
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v2, -v4, v2, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v3, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v3, 0x37800000, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v3, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v2, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v2, v2
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v2, v0
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v1
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val0)
  %div = fdiv contract float -1.0, %sqrt, !fpmath !0
  %user = fmul contract float %div, %val1
  ret float %user
}

define <2 x float> @v_neg_rsq_v2f32_foldable_user(<2 x float> %val0, <2 x float> %val1) {
; GCN-DAZ-SAFE-LABEL: v_neg_rsq_v2f32_foldable_user:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v4, 0x4f800000, v1
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v1
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v4, v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, v1, v4
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v4, 0.5, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v6, -v4, v5, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v5, v6, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, -v5, v5, v1
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v4, v6, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v7, v4, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x4f800000, v0
; GCN-DAZ-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_rsq_f32_e32 v5, v0
; GCN-DAZ-SAFE-NEXT:    v_mov_b32_e32 v6, 0x260
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v6
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v4, v0, v5
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0.5, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v7, -v5, v4, 0.5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v4, v7, v4
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v8, -v4, v4, v0
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v5, v5, v7, v5
; GCN-DAZ-SAFE-NEXT:    v_fma_f32 v4, v8, v5, v4
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-DAZ-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v6
; GCN-DAZ-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v0, -v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e64 v1, -v1
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GCN-DAZ-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_neg_rsq_v2f32_foldable_user:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x4f800000, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v1
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], -1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v5, v4, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v6, s[4:5], 1, v4
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v6, v4, v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v5, v6, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v6, v0
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v5, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], -1, v6
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v7, -v4, v6, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v7
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v6, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v7, s[4:5], 1, v6
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v7, v6, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x37800000, v4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v5
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v0|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, -v0, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v4, v0
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v1
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], |v1|, s6
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, -v1, v4, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v4, v1
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_neg_rsq_v2f32_foldable_user:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s6, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v4, 0x4f800000, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v4, v1
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v5, s[4:5], -1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v5, v4, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v6, s[4:5], 1, v4
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v4, -v6, v4, v1
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v5, v6, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v5, 0x37800000, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s6, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v6, v0
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v5, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e64 s[4:5], v1, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v4, v1, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v4, s[4:5], -1, v6
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v7, -v4, v6, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v7
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v6, v4, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v7, s[4:5], 1, v6
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v6, -v7, v6, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v6
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v4, v4, v7, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v6, 0x37800000, v4
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v5
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v4, v0
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e64 v4, -v1
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v4, v4
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v1, vcc, 0, v1
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v4, v1
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract <2 x float> @llvm.sqrt.v2f32(<2 x float> %val0)
  %div = fdiv contract <2 x float> <float -1.0, float -1.0>, %sqrt, !fpmath !0
  %user = fmul contract <2 x float> %div, %val1
  ret <2 x float> %user
}

define float @v_rsq_f32(float %val) {
; GCN-DAZ-LABEL: v_rsq_f32:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-SAFE-LABEL: v_rsq_f32:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x800000
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, 0, 24, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GCN-IEEE-SAFE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, 0, 12, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GCN-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  ret float %div
}

define { float, float } @v_rsq_f32_multi_use(float %val) {
; GCN-DAZ-SAFE-LABEL: v_rsq_f32_multi_use:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_sqrt_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v1, v0
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_rsq_f32_multi_use:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v2, vcc, 0, v2
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_rsq_f32_multi_use:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v2, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v2, vcc, 0, v2
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val), !fpmath !1
  %insert.0 = insertvalue { float, float } poison, float %sqrt, 0
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  %insert.1 = insertvalue { float, float } %insert.0, float %div, 1
  ret { float, float } %insert.1
}

define float @v_rsq_f32_missing_contract0(float %val) {
; GCN-DAZ-SAFE-LABEL: v_rsq_f32_missing_contract0:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_sqrt_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_rsq_f32_missing_contract0:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_rsq_f32_missing_contract0:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call float @llvm.sqrt.f32(float %val), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  ret float %div
}

define float @v_rsq_f32_missing_contract1(float %val) {
; GCN-DAZ-SAFE-LABEL: v_rsq_f32_missing_contract1:
; GCN-DAZ-SAFE:       ; %bb.0:
; GCN-DAZ-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-SAFE-NEXT:    v_sqrt_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-DAZ-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; SI-IEEE-SAFE-LABEL: v_rsq_f32_missing_contract1:
; SI-IEEE-SAFE:       ; %bb.0:
; SI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; SI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; SI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; SI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; SI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x7f800000
; SI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; SI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, s4
; SI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; SI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; SI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; SI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; SI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; SI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-IEEE-SAFE-LABEL: v_rsq_f32_missing_contract1:
; CI-IEEE-SAFE:       ; %bb.0:
; CI-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0xf800000
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v1, 0x4f800000, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; CI-IEEE-SAFE-NEXT:    v_sqrt_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v2, s[4:5], -1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v3, -v2, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_ge_f32_e64 s[4:5], 0, v3
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, v1, v2, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_add_i32_e64 v3, s[4:5], 1, v1
; CI-IEEE-SAFE-NEXT:    v_fma_f32 v1, -v3, v1, v0
; CI-IEEE-SAFE-NEXT:    v_cmp_lt_f32_e64 s[4:5], 0, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, v2, v3, s[4:5]
; CI-IEEE-SAFE-NEXT:    v_mul_f32_e32 v2, 0x37800000, v1
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; CI-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x260
; CI-IEEE-SAFE-NEXT:    v_cmp_class_f32_e32 vcc, v0, v2
; CI-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; CI-IEEE-SAFE-NEXT:    v_frexp_mant_f32_e32 v1, v0
; CI-IEEE-SAFE-NEXT:    v_rcp_f32_e32 v1, v1
; CI-IEEE-SAFE-NEXT:    v_frexp_exp_i32_f32_e32 v0, v0
; CI-IEEE-SAFE-NEXT:    v_sub_i32_e32 v0, vcc, 0, v0
; CI-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v1, v0
; CI-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val), !fpmath !1
  %div = fdiv float 1.0, %sqrt, !fpmath !1
  ret float %div
}

; Test that we contract into FMA for an fadd user after introducing
; the fmul.
define float @v_rsq_f32_contractable_user(float %val0, float %val1) {
; GCN-DAZ-LABEL: v_rsq_f32_contractable_user:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-SAFE-LABEL: v_rsq_f32_contractable_user:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x800000
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 24, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GCN-IEEE-SAFE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x45800000
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v0, v0, v2, v1
; GCN-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val0), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  %add = fadd contract float %div, %val1
  ret float %add
}

; Missing contract on the fdiv
define float @v_rsq_f32_contractable_user_missing_contract0(float %val0, float %val1) {
; GCN-DAZ-LABEL: v_rsq_f32_contractable_user_missing_contract0:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-SAFE-LABEL: v_rsq_f32_contractable_user_missing_contract0:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x800000
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 24, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GCN-IEEE-SAFE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-SAFE-NEXT:    v_mov_b32_e32 v2, 0x45800000
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e32 v2, 1.0, v2, vcc
; GCN-IEEE-SAFE-NEXT:    v_fma_f32 v0, v0, v2, v1
; GCN-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val0), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  %add = fadd contract float %div, %val1
  ret float %add
}

; Missing contract on the fadd
define float @v_rsq_f32_contractable_user_missing_contract1(float %val0, float %val1) {
; GCN-DAZ-LABEL: v_rsq_f32_contractable_user_missing_contract1:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-SAFE-LABEL: v_rsq_f32_contractable_user_missing_contract1:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x800000
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 24, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GCN-IEEE-SAFE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v2, 0, 12, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GCN-IEEE-SAFE-NEXT:    v_add_f32_e32 v0, v0, v1
; GCN-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val0), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  %add = fadd float %div, %val1
  ret float %add
}

define float @v_rsq_f32_known_never_denormal(float nofpclass(sub) %val) {
; GCN-DAZ-LABEL: v_rsq_f32_known_never_denormal:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-LABEL: v_rsq_f32_known_never_denormal:
; GCN-IEEE:       ; %bb.0:
; GCN-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  ret float %div
}

define float @v_rsq_f32_known_never_posdenormal(float nofpclass(psub) %val) {
; GCN-DAZ-LABEL: v_rsq_f32_known_never_posdenormal:
; GCN-DAZ:       ; %bb.0:
; GCN-DAZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-DAZ-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-DAZ-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IEEE-SAFE-LABEL: v_rsq_f32_known_never_posdenormal:
; GCN-IEEE-SAFE:       ; %bb.0:
; GCN-IEEE-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IEEE-SAFE-NEXT:    s_mov_b32 s4, 0x800000
; GCN-IEEE-SAFE-NEXT:    v_cmp_gt_f32_e32 vcc, s4, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, 0, 24, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GCN-IEEE-SAFE-NEXT:    v_rsq_f32_e32 v0, v0
; GCN-IEEE-SAFE-NEXT:    v_cndmask_b32_e64 v1, 0, 12, vcc
; GCN-IEEE-SAFE-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GCN-IEEE-SAFE-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract float @llvm.sqrt.f32(float %val), !fpmath !1
  %div = fdiv contract float 1.0, %sqrt, !fpmath !1
  ret float %div
}

!0 = !{float 2.500000e+00}
!1 = !{float 1.000000e+00}

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CI-DAZ-SAFE: {{.*}}
; SI-DAZ-SAFE: {{.*}}
