; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib %s | FileCheck %s

declare <2 x float> @_Z4fmaxDv2_ff(<2 x float>, float)
declare <2 x float> @_Z4fmaxDv2_fS_(<2 x float>, <2 x float>)
declare <3 x float> @_Z4fmaxDv3_ff(<3 x float>, float)
declare <3 x float> @_Z4fmaxDv3_fS_(<3 x float>, <3 x float>)
declare <4 x float> @_Z4fmaxDv4_ff(<4 x float>, float)
declare <4 x float> @_Z4fmaxDv4_fS_(<4 x float>, <4 x float>)
declare <8 x float> @_Z4fmaxDv8_ff(<8 x float>, float)
declare <8 x float> @_Z4fmaxDv8_fS_(<8 x float>, <8 x float>)
declare <16 x float> @_Z4fmaxDv16_ff(<16 x float>, float)
declare <16 x float> @_Z4fmaxDv16_fS_(<16 x float>, <16 x float>)
declare <2 x double> @_Z4fmaxDv2_dd(<2 x double>, double)
declare <2 x double> @_Z4fmaxDv2_dS_(<2 x double>, <2 x double>)
declare <3 x double> @_Z4fmaxDv3_dd(<3 x double>, double)
declare <3 x double> @_Z4fmaxDv3_dS_(<3 x double>, <3 x double>)
declare <4 x double> @_Z4fmaxDv4_dd(<4 x double>, double)
declare <4 x double> @_Z4fmaxDv4_dS_(<4 x double>, <4 x double>)
declare <8 x double> @_Z4fmaxDv8_dd(<8 x double>, double)
declare <8 x double> @_Z4fmaxDv8_dS_(<8 x double>, <8 x double>)
declare <16 x double> @_Z4fmaxDv16_dd(<16 x double>, double)
declare <16 x double> @_Z4fmaxDv16_dS_(<16 x double>, <16 x double>)
declare <2 x half> @_Z4fmaxDv2_DhDh(<2 x half>, half)
declare <2 x half> @_Z4fmaxDv2_DhS_(<2 x half>, <2 x half>)
declare <3 x half> @_Z4fmaxDv3_DhDh(<3 x half>, half)
declare <3 x half> @_Z4fmaxDv3_DhS_(<3 x half>, <3 x half>)
declare <4 x half> @_Z4fmaxDv4_DhDh(<4 x half>, half)
declare <4 x half> @_Z4fmaxDv4_DhS_(<4 x half>, <4 x half>)
declare <8 x half> @_Z4fmaxDv8_DhDh(<8 x half>, half)
declare <8 x half> @_Z4fmaxDv8_DhS_(<8 x half>, <8 x half>)
declare <16 x half> @_Z4fmaxDv16_DhDh(<16 x half>, half)
declare <16 x half> @_Z4fmaxDv16_DhS_(<16 x half>, <16 x half>)

define <2 x float> @test_fmax_v2f32_f32(<2 x float> %x, float %y) {
; CHECK-LABEL: define <2 x float> @test_fmax_v2f32_f32
; CHECK-SAME: (<2 x float> [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <2 x float> poison, float [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <2 x float> [[DOTSPLATINSERT]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x float> @llvm.maxnum.v2f32(<2 x float> [[X]], <2 x float> [[DOTSPLAT]])
; CHECK-NEXT:    ret <2 x float> [[MIN]]
;
  %min = tail call <2 x float> @_Z4fmaxDv2_ff(<2 x float> %x, float %y)
  ret <2 x float> %min
}

define <2 x float> @test_fmax_f32_v2f32(float %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_fmax_f32_v2f32
; CHECK-SAME: (float [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <2 x float> poison, float [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <2 x float> [[INSERT]], <2 x float> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x float> @llvm.maxnum.v2f32(<2 x float> [[SHUFFLE]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[MIN]]
;
  %insert = insertelement <2 x float> poison, float %x, i64 0
  %shuffle = shufflevector <2 x float> %insert, <2 x float> poison, <2 x i32> zeroinitializer
  %min = tail call <2 x float> @_Z4fmaxDv2_fS_(<2 x float> %shuffle, <2 x float> %y)
  ret <2 x float> %min
}

define <3 x float> @test_fmax_v3f32_f32(<3 x float> %x, float %y) {
; CHECK-LABEL: define <3 x float> @test_fmax_v3f32_f32
; CHECK-SAME: (<3 x float> [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <3 x float> poison, float [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <3 x float> [[DOTSPLATINSERT]], <3 x float> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x float> @llvm.maxnum.v3f32(<3 x float> [[X]], <3 x float> [[DOTSPLAT]])
; CHECK-NEXT:    ret <3 x float> [[MIN]]
;
  %min = tail call <3 x float> @_Z4fmaxDv3_ff(<3 x float> %x, float %y)
  ret <3 x float> %min
}

define <3 x float> @test_fmax_f32_v3f32(float %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_fmax_f32_v3f32
; CHECK-SAME: (float [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <3 x float> poison, float [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <3 x float> [[INSERT]], <3 x float> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x float> @llvm.maxnum.v3f32(<3 x float> [[SHUFFLE]], <3 x float> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[MIN]]
;
  %insert = insertelement <3 x float> poison, float %x, i64 0
  %shuffle = shufflevector <3 x float> %insert, <3 x float> poison, <3 x i32> zeroinitializer
  %min = tail call <3 x float> @_Z4fmaxDv3_fS_(<3 x float> %shuffle, <3 x float> %y)
  ret <3 x float> %min
}

define <4 x float> @test_fmax_v4f32_f32(<4 x float> %x, float %y) {
; CHECK-LABEL: define <4 x float> @test_fmax_v4f32_f32
; CHECK-SAME: (<4 x float> [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <4 x float> poison, float [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <4 x float> [[DOTSPLATINSERT]], <4 x float> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x float> @llvm.maxnum.v4f32(<4 x float> [[X]], <4 x float> [[DOTSPLAT]])
; CHECK-NEXT:    ret <4 x float> [[MIN]]
;
  %min = tail call <4 x float> @_Z4fmaxDv4_ff(<4 x float> %x, float %y)
  ret <4 x float> %min
}

define <4 x float> @test_fmax_f32_v4f32(float %x, <4 x float> %y) {
; CHECK-LABEL: define <4 x float> @test_fmax_f32_v4f32
; CHECK-SAME: (float [[X:%.*]], <4 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <4 x float> poison, float [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <4 x float> [[INSERT]], <4 x float> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x float> @llvm.maxnum.v4f32(<4 x float> [[SHUFFLE]], <4 x float> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[MIN]]
;
  %insert = insertelement <4 x float> poison, float %x, i64 0
  %shuffle = shufflevector <4 x float> %insert, <4 x float> poison, <4 x i32> zeroinitializer
  %min = tail call <4 x float> @_Z4fmaxDv4_fS_(<4 x float> %shuffle, <4 x float> %y)
  ret <4 x float> %min
}

define <8 x float> @test_fmax_v8f32_f32(<8 x float> %x, float %y) {
; CHECK-LABEL: define <8 x float> @test_fmax_v8f32_f32
; CHECK-SAME: (<8 x float> [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <8 x float> poison, float [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <8 x float> [[DOTSPLATINSERT]], <8 x float> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x float> @llvm.maxnum.v8f32(<8 x float> [[X]], <8 x float> [[DOTSPLAT]])
; CHECK-NEXT:    ret <8 x float> [[MIN]]
;
  %min = tail call <8 x float> @_Z4fmaxDv8_ff(<8 x float> %x, float %y)
  ret <8 x float> %min
}

define <8 x float> @test_fmax_f32_v8f32(float %x, <8 x float> %y) {
; CHECK-LABEL: define <8 x float> @test_fmax_f32_v8f32
; CHECK-SAME: (float [[X:%.*]], <8 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <8 x float> poison, float [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <8 x float> [[INSERT]], <8 x float> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x float> @llvm.maxnum.v8f32(<8 x float> [[SHUFFLE]], <8 x float> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[MIN]]
;
  %insert = insertelement <8 x float> poison, float %x, i64 0
  %shuffle = shufflevector <8 x float> %insert, <8 x float> poison, <8 x i32> zeroinitializer
  %min = tail call <8 x float> @_Z4fmaxDv8_fS_(<8 x float> %shuffle, <8 x float> %y)
  ret <8 x float> %min
}

define <16 x float> @test_fmax_v16f32_f32(<16 x float> %x, float %y) {
; CHECK-LABEL: define <16 x float> @test_fmax_v16f32_f32
; CHECK-SAME: (<16 x float> [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <16 x float> poison, float [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <16 x float> [[DOTSPLATINSERT]], <16 x float> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x float> @llvm.maxnum.v16f32(<16 x float> [[X]], <16 x float> [[DOTSPLAT]])
; CHECK-NEXT:    ret <16 x float> [[MIN]]
;
  %min = tail call <16 x float> @_Z4fmaxDv16_ff(<16 x float> %x, float %y)
  ret <16 x float> %min
}

define <16 x float> @test_fmax_f32_v16f32(float %x, <16 x float> %y) {
; CHECK-LABEL: define <16 x float> @test_fmax_f32_v16f32
; CHECK-SAME: (float [[X:%.*]], <16 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <16 x float> poison, float [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <16 x float> [[INSERT]], <16 x float> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x float> @llvm.maxnum.v16f32(<16 x float> [[SHUFFLE]], <16 x float> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[MIN]]
;
  %insert = insertelement <16 x float> poison, float %x, i64 0
  %shuffle = shufflevector <16 x float> %insert, <16 x float> poison, <16 x i32> zeroinitializer
  %min = tail call <16 x float> @_Z4fmaxDv16_fS_(<16 x float> %shuffle, <16 x float> %y)
  ret <16 x float> %min
}

define <2 x double> @test_fmax_v2f64_f64(<2 x double> %x, double %y) {
; CHECK-LABEL: define <2 x double> @test_fmax_v2f64_f64
; CHECK-SAME: (<2 x double> [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <2 x double> poison, double [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <2 x double> [[DOTSPLATINSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x double> @llvm.maxnum.v2f64(<2 x double> [[X]], <2 x double> [[DOTSPLAT]])
; CHECK-NEXT:    ret <2 x double> [[MIN]]
;
  %min = tail call <2 x double> @_Z4fmaxDv2_dd(<2 x double> %x, double %y)
  ret <2 x double> %min
}

define <2 x double> @test_fmax_f64_v2f64(double %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_fmax_f64_v2f64
; CHECK-SAME: (double [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <2 x double> poison, double [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <2 x double> [[INSERT]], <2 x double> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x double> @llvm.maxnum.v2f64(<2 x double> [[SHUFFLE]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[MIN]]
;
  %insert = insertelement <2 x double> poison, double %x, i64 0
  %shuffle = shufflevector <2 x double> %insert, <2 x double> poison, <2 x i32> zeroinitializer
  %min = tail call <2 x double> @_Z4fmaxDv2_dS_(<2 x double> %shuffle, <2 x double> %y)
  ret <2 x double> %min
}

define <3 x double> @test_fmax_v3f64_f64(<3 x double> %x, double %y) {
; CHECK-LABEL: define <3 x double> @test_fmax_v3f64_f64
; CHECK-SAME: (<3 x double> [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <3 x double> poison, double [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <3 x double> [[DOTSPLATINSERT]], <3 x double> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x double> @llvm.maxnum.v3f64(<3 x double> [[X]], <3 x double> [[DOTSPLAT]])
; CHECK-NEXT:    ret <3 x double> [[MIN]]
;
  %min = tail call <3 x double> @_Z4fmaxDv3_dd(<3 x double> %x, double %y)
  ret <3 x double> %min
}

define <3 x double> @test_fmax_f64_v3f64(double %x, <3 x double> %y) {
; CHECK-LABEL: define <3 x double> @test_fmax_f64_v3f64
; CHECK-SAME: (double [[X:%.*]], <3 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <3 x double> poison, double [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <3 x double> [[INSERT]], <3 x double> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x double> @llvm.maxnum.v3f64(<3 x double> [[SHUFFLE]], <3 x double> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[MIN]]
;
  %insert = insertelement <3 x double> poison, double %x, i64 0
  %shuffle = shufflevector <3 x double> %insert, <3 x double> poison, <3 x i32> zeroinitializer
  %min = tail call <3 x double> @_Z4fmaxDv3_dS_(<3 x double> %shuffle, <3 x double> %y)
  ret <3 x double> %min
}

define <4 x double> @test_fmax_v4f64_f64(<4 x double> %x, double %y) {
; CHECK-LABEL: define <4 x double> @test_fmax_v4f64_f64
; CHECK-SAME: (<4 x double> [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <4 x double> poison, double [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <4 x double> [[DOTSPLATINSERT]], <4 x double> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x double> @llvm.maxnum.v4f64(<4 x double> [[X]], <4 x double> [[DOTSPLAT]])
; CHECK-NEXT:    ret <4 x double> [[MIN]]
;
  %min = tail call <4 x double> @_Z4fmaxDv4_dd(<4 x double> %x, double %y)
  ret <4 x double> %min
}

define <4 x double> @test_fmax_f64_v4f64(double %x, <4 x double> %y) {
; CHECK-LABEL: define <4 x double> @test_fmax_f64_v4f64
; CHECK-SAME: (double [[X:%.*]], <4 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <4 x double> poison, double [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <4 x double> [[INSERT]], <4 x double> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x double> @llvm.maxnum.v4f64(<4 x double> [[SHUFFLE]], <4 x double> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[MIN]]
;
  %insert = insertelement <4 x double> poison, double %x, i64 0
  %shuffle = shufflevector <4 x double> %insert, <4 x double> poison, <4 x i32> zeroinitializer
  %min = tail call <4 x double> @_Z4fmaxDv4_dS_(<4 x double> %shuffle, <4 x double> %y)
  ret <4 x double> %min
}

define <8 x double> @test_fmax_v8f64_f64(<8 x double> %x, double %y) {
; CHECK-LABEL: define <8 x double> @test_fmax_v8f64_f64
; CHECK-SAME: (<8 x double> [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <8 x double> poison, double [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <8 x double> [[DOTSPLATINSERT]], <8 x double> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x double> @llvm.maxnum.v8f64(<8 x double> [[X]], <8 x double> [[DOTSPLAT]])
; CHECK-NEXT:    ret <8 x double> [[MIN]]
;
  %min = tail call <8 x double> @_Z4fmaxDv8_dd(<8 x double> %x, double %y)
  ret <8 x double> %min
}

define <8 x double> @test_fmax_f64_v8f64(double %x, <8 x double> %y) {
; CHECK-LABEL: define <8 x double> @test_fmax_f64_v8f64
; CHECK-SAME: (double [[X:%.*]], <8 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <8 x double> poison, double [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <8 x double> [[INSERT]], <8 x double> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x double> @llvm.maxnum.v8f64(<8 x double> [[SHUFFLE]], <8 x double> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[MIN]]
;
  %insert = insertelement <8 x double> poison, double %x, i64 0
  %shuffle = shufflevector <8 x double> %insert, <8 x double> poison, <8 x i32> zeroinitializer
  %min = tail call <8 x double> @_Z4fmaxDv8_dS_(<8 x double> %shuffle, <8 x double> %y)
  ret <8 x double> %min
}

define <16 x double> @test_fmax_v16f64_f64(<16 x double> %x, double %y) {
; CHECK-LABEL: define <16 x double> @test_fmax_v16f64_f64
; CHECK-SAME: (<16 x double> [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <16 x double> poison, double [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <16 x double> [[DOTSPLATINSERT]], <16 x double> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x double> @llvm.maxnum.v16f64(<16 x double> [[X]], <16 x double> [[DOTSPLAT]])
; CHECK-NEXT:    ret <16 x double> [[MIN]]
;
  %min = tail call <16 x double> @_Z4fmaxDv16_dd(<16 x double> %x, double %y)
  ret <16 x double> %min
}

define <16 x double> @test_fmax_f64_v16f64(double %x, <16 x double> %y) {
; CHECK-LABEL: define <16 x double> @test_fmax_f64_v16f64
; CHECK-SAME: (double [[X:%.*]], <16 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <16 x double> poison, double [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <16 x double> [[INSERT]], <16 x double> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x double> @llvm.maxnum.v16f64(<16 x double> [[SHUFFLE]], <16 x double> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[MIN]]
;
  %insert = insertelement <16 x double> poison, double %x, i64 0
  %shuffle = shufflevector <16 x double> %insert, <16 x double> poison, <16 x i32> zeroinitializer
  %min = tail call <16 x double> @_Z4fmaxDv16_dS_(<16 x double> %shuffle, <16 x double> %y)
  ret <16 x double> %min
}

define <2 x half> @test_fmax_v2f16_f16(<2 x half> %x, half %y) {
; CHECK-LABEL: define <2 x half> @test_fmax_v2f16_f16
; CHECK-SAME: (<2 x half> [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <2 x half> poison, half [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <2 x half> [[DOTSPLATINSERT]], <2 x half> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x half> @llvm.maxnum.v2f16(<2 x half> [[X]], <2 x half> [[DOTSPLAT]])
; CHECK-NEXT:    ret <2 x half> [[MIN]]
;
  %min = tail call <2 x half> @_Z4fmaxDv2_DhDh(<2 x half> %x, half %y)
  ret <2 x half> %min
}

define <2 x half> @test_fmax_f16_v2f16(half %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_fmax_f16_v2f16
; CHECK-SAME: (half [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <2 x half> poison, half [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <2 x half> [[INSERT]], <2 x half> poison, <2 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <2 x half> @llvm.maxnum.v2f16(<2 x half> [[SHUFFLE]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[MIN]]
;
  %insert = insertelement <2 x half> poison, half %x, i64 0
  %shuffle = shufflevector <2 x half> %insert, <2 x half> poison, <2 x i32> zeroinitializer
  %min = tail call <2 x half> @_Z4fmaxDv2_DhS_(<2 x half> %shuffle, <2 x half> %y)
  ret <2 x half> %min
}

define <3 x half> @test_fmax_v3f16_f16(<3 x half> %x, half %y) {
; CHECK-LABEL: define <3 x half> @test_fmax_v3f16_f16
; CHECK-SAME: (<3 x half> [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <3 x half> poison, half [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <3 x half> [[DOTSPLATINSERT]], <3 x half> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x half> @llvm.maxnum.v3f16(<3 x half> [[X]], <3 x half> [[DOTSPLAT]])
; CHECK-NEXT:    ret <3 x half> [[MIN]]
;
  %min = tail call <3 x half> @_Z4fmaxDv3_DhDh(<3 x half> %x, half %y)
  ret <3 x half> %min
}

define <3 x half> @test_fmax_f16_v3f16(half %x, <3 x half> %y) {
; CHECK-LABEL: define <3 x half> @test_fmax_f16_v3f16
; CHECK-SAME: (half [[X:%.*]], <3 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <3 x half> poison, half [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <3 x half> [[INSERT]], <3 x half> poison, <3 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <3 x half> @llvm.maxnum.v3f16(<3 x half> [[SHUFFLE]], <3 x half> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[MIN]]
;
  %insert = insertelement <3 x half> poison, half %x, i64 0
  %shuffle = shufflevector <3 x half> %insert, <3 x half> poison, <3 x i32> zeroinitializer
  %min = tail call <3 x half> @_Z4fmaxDv3_DhS_(<3 x half> %shuffle, <3 x half> %y)
  ret <3 x half> %min
}

define <4 x half> @test_fmax_v4f16_f16(<4 x half> %x, half %y) {
; CHECK-LABEL: define <4 x half> @test_fmax_v4f16_f16
; CHECK-SAME: (<4 x half> [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <4 x half> poison, half [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <4 x half> [[DOTSPLATINSERT]], <4 x half> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x half> @llvm.maxnum.v4f16(<4 x half> [[X]], <4 x half> [[DOTSPLAT]])
; CHECK-NEXT:    ret <4 x half> [[MIN]]
;
  %min = tail call <4 x half> @_Z4fmaxDv4_DhDh(<4 x half> %x, half %y)
  ret <4 x half> %min
}

define <4 x half> @test_fmax_f16_v4f16(half %x, <4 x half> %y) {
; CHECK-LABEL: define <4 x half> @test_fmax_f16_v4f16
; CHECK-SAME: (half [[X:%.*]], <4 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <4 x half> poison, half [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <4 x half> [[INSERT]], <4 x half> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <4 x half> @llvm.maxnum.v4f16(<4 x half> [[SHUFFLE]], <4 x half> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[MIN]]
;
  %insert = insertelement <4 x half> poison, half %x, i64 0
  %shuffle = shufflevector <4 x half> %insert, <4 x half> poison, <4 x i32> zeroinitializer
  %min = tail call <4 x half> @_Z4fmaxDv4_DhS_(<4 x half> %shuffle, <4 x half> %y)
  ret <4 x half> %min
}

define <8 x half> @test_fmax_v8f16_f16(<8 x half> %x, half %y) {
; CHECK-LABEL: define <8 x half> @test_fmax_v8f16_f16
; CHECK-SAME: (<8 x half> [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <8 x half> poison, half [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <8 x half> [[DOTSPLATINSERT]], <8 x half> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x half> @llvm.maxnum.v8f16(<8 x half> [[X]], <8 x half> [[DOTSPLAT]])
; CHECK-NEXT:    ret <8 x half> [[MIN]]
;
  %min = tail call <8 x half> @_Z4fmaxDv8_DhDh(<8 x half> %x, half %y)
  ret <8 x half> %min
}

define <8 x half> @test_fmax_f16_v8f16(half %x, <8 x half> %y) {
; CHECK-LABEL: define <8 x half> @test_fmax_f16_v8f16
; CHECK-SAME: (half [[X:%.*]], <8 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <8 x half> poison, half [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <8 x half> [[INSERT]], <8 x half> poison, <8 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <8 x half> @llvm.maxnum.v8f16(<8 x half> [[SHUFFLE]], <8 x half> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[MIN]]
;
  %insert = insertelement <8 x half> poison, half %x, i64 0
  %shuffle = shufflevector <8 x half> %insert, <8 x half> poison, <8 x i32> zeroinitializer
  %min = tail call <8 x half> @_Z4fmaxDv8_DhS_(<8 x half> %shuffle, <8 x half> %y)
  ret <8 x half> %min
}

define <16 x half> @test_fmax_v16f16_f16(<16 x half> %x, half %y) {
; CHECK-LABEL: define <16 x half> @test_fmax_v16f16_f16
; CHECK-SAME: (<16 x half> [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[DOTSPLATINSERT:%.*]] = insertelement <16 x half> poison, half [[Y]], i64 0
; CHECK-NEXT:    [[DOTSPLAT:%.*]] = shufflevector <16 x half> [[DOTSPLATINSERT]], <16 x half> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x half> @llvm.maxnum.v16f16(<16 x half> [[X]], <16 x half> [[DOTSPLAT]])
; CHECK-NEXT:    ret <16 x half> [[MIN]]
;
  %min = tail call <16 x half> @_Z4fmaxDv16_DhDh(<16 x half> %x, half %y)
  ret <16 x half> %min
}

define <16 x half> @test_fmax_f16_v16f16(half %x, <16 x half> %y) {
; CHECK-LABEL: define <16 x half> @test_fmax_f16_v16f16
; CHECK-SAME: (half [[X:%.*]], <16 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[INSERT:%.*]] = insertelement <16 x half> poison, half [[X]], i64 0
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <16 x half> [[INSERT]], <16 x half> poison, <16 x i32> zeroinitializer
; CHECK-NEXT:    [[MIN:%.*]] = tail call <16 x half> @llvm.maxnum.v16f16(<16 x half> [[SHUFFLE]], <16 x half> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[MIN]]
;
  %insert = insertelement <16 x half> poison, half %x, i64 0
  %shuffle = shufflevector <16 x half> %insert, <16 x half> poison, <16 x i32> zeroinitializer
  %min = tail call <16 x half> @_Z4fmaxDv16_DhS_(<16 x half> %shuffle, <16 x half> %y)
  ret <16 x half> %min
}
