; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define double @bitcast_i64_to_f64(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_i64_to_f64_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_i64_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_i64_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_i64_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB1_3
; GFX11-NEXT:  .LBB1_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB1_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_4:
; GFX11-NEXT:    s_branch .LBB1_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define i64 @bitcast_f64_to_i64(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB2_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast double %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_f64_to_i64_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB3_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_4
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_3:
; SI-NEXT:    s_branch .LBB3_2
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB3_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_4
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_3:
; VI-NEXT:    s_branch .LBB3_2
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_3:
; GFX9-NEXT:    s_branch .LBB3_2
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:    s_branch .LBB3_2
; GFX11-NEXT:  .LBB3_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast double %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <2 x i32> @bitcast_i64_to_v2i32(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_i64_to_v2i32_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_i64_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_i64_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_i64_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB5_3
; GFX11-NEXT:  .LBB5_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB5_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_4:
; GFX11-NEXT:    s_branch .LBB5_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define i64 @bitcast_v2i32_to_i64(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v2i32_to_i64_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v2i32_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v2i32_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v2i32_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_3
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB7_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    s_branch .LBB7_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <2 x float> @bitcast_i64_to_v2f32(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_i64_to_v2f32_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_i64_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_i64_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_i64_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB9_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_branch .LBB9_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define i64 @bitcast_v2f32_to_i64(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v2f32_to_i64_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB11_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_4
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_3:
; SI-NEXT:    s_branch .LBB11_2
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB11_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_4
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_3:
; VI-NEXT:    s_branch .LBB11_2
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_branch .LBB11_2
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <4 x i16> @bitcast_i64_to_v4i16(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v2, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_i64_to_v4i16_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_i64_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_i64_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_i64_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define i64 @bitcast_v4i16_to_i64(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_4
; SI-NEXT:  .LBB14_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB14_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  .LBB14_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_e32 v2, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_u16_e32 v2, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v4i16_to_i64_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v4i16_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v4i16_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB15_4
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_3:
; GFX9-NEXT:    s_branch .LBB15_2
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_4
; GFX11-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB15_3:
; GFX11-NEXT:    s_branch .LBB15_2
; GFX11-NEXT:  .LBB15_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <4 x half> @bitcast_i64_to_v4f16(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v1
; SI-NEXT:    v_mov_b32_e32 v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_4
; SI-NEXT:  .LBB16_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB16_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v4
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  .LBB16_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_i64_to_v4f16_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_lshr_b32 s6, s4, 16
; SI-NEXT:    s_lshr_b32 s7, s5, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s6
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_i64_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_i64_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_i64_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define i64 @bitcast_v4f16_to_i64(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_4
; SI-NEXT:  .LBB18_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB18_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  .LBB18_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 0x200
; VI-NEXT:    v_add_f16_sdwa v3, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v2, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v4f16_to_i64_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v4f16_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB19_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB19_4
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_add_f16_sdwa v2, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_3:
; VI-NEXT:    s_branch .LBB19_2
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB19_4
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_3:
; GFX9-NEXT:    s_branch .LBB19_2
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB19_4
; GFX11-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB19_3:
; GFX11-NEXT:    s_branch .LBB19_2
; GFX11-NEXT:  .LBB19_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <4 x bfloat> @bitcast_i64_to_v4bf16(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v1
; SI-NEXT:    v_mov_b32_e32 v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_4
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB20_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  .LBB20_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_i64_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_i64_to_v4bf16_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB21_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_and_b32 s8, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB21_3
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_and_b32 s6, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s5, 16
; SI-NEXT:    s_and_b32 s8, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s4, 16
; SI-NEXT:  .LBB21_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    v_mov_b32_e32 v1, s8
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB21_2
;
; VI-LABEL: bitcast_i64_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB21_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_3
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB21_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    s_branch .LBB21_2
;
; GFX9-LABEL: bitcast_i64_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_3
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB21_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    s_branch .LBB21_2
;
; GFX11-LABEL: bitcast_i64_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB21_3
; GFX11-NEXT:  .LBB21_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB21_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_4:
; GFX11-NEXT:    s_branch .LBB21_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define i64 @bitcast_v4bf16_to_i64(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_4
; SI-NEXT:  .LBB22_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB22_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  .LBB22_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s7
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_i64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v1, v7, v10 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v9, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v3
; GFX11-TRUE16-NEXT:  .LBB22_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_i64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v8, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB22_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v4bf16_to_i64_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v2, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s18
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v4bf16_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB23_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_4
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_3:
; VI-NEXT:    s_branch .LBB23_2
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_4
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v2
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v2, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_3:
; GFX9-NEXT:    s_branch .LBB23_2
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB23_4
; GFX11-NEXT:  .LBB23_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s1
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v4, v8, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_3:
; GFX11-NEXT:    s_branch .LBB23_2
; GFX11-NEXT:  .LBB23_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <8 x i8> @bitcast_i64_to_v8i8(i64 %a, i32 %b) {
; SI-LABEL: bitcast_i64_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB24_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB24_4
; SI-NEXT:  .LBB24_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB24_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  .LBB24_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_i64_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_i64_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_i64_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:  ; %bb.4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_i64_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB24_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:  .LBB24_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_i64_to_v8i8_scalar(i64 inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_i64_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB25_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB25_3
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:  .LBB25_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB25_2
;
; VI-LABEL: bitcast_i64_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB25_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s5, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB25_3
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s5, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:  .LBB25_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s9
; VI-NEXT:    v_mov_b32_e32 v6, s8
; VI-NEXT:    v_mov_b32_e32 v7, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    s_branch .LBB25_2
;
; GFX9-LABEL: bitcast_i64_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB25_3
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:  .LBB25_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    s_branch .LBB25_2
;
; GFX11-LABEL: bitcast_i64_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s4, s1, 16
; GFX11-NEXT:    s_lshr_b32 s5, s1, 8
; GFX11-NEXT:    s_lshr_b32 s6, s0, 16
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB25_3
; GFX11-NEXT:  .LBB25_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_lshr_b32 s6, s0, 16
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s4, s1, 16
; GFX11-NEXT:    s_lshr_b32 s5, s1, 8
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:  .LBB25_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s7
; GFX11-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s4 :: v_dual_mov_b32 v7, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_4:
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    s_branch .LBB25_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add i64 %a, 3
  %a2 = bitcast i64 %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast i64 %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define i64 @bitcast_v8i8_to_i64(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v10, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v8, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v7
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_4
; SI-NEXT:  .LBB26_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB26_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  .LBB26_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_or_b32_e32 v0, v10, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB26_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB26_4
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB26_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  .LBB26_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_4
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB26_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  .LBB26_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_i64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-TRUE16-NEXT:  .LBB26_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-TRUE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_i64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-FAKE16-NEXT:  .LBB26_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-FAKE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define inreg i64 @bitcast_v8i8_to_i64_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v8i8_to_i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB27_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB27_3
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB27_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB27_2
;
; GFX9-LABEL: bitcast_v8i8_to_i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB27_3
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB27_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB27_2
;
; GFX11-LABEL: bitcast_v8i8_to_i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB27_3
; GFX11-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB27_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB27_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to i64
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to i64
  br label %end

end:
  %phi = phi i64 [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret i64 %phi
}

define <2 x i32> @bitcast_f64_to_v2i32(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB28_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_f64_to_v2i32_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB29_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB29_4
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_3:
; SI-NEXT:    s_branch .LBB29_2
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB29_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB29_4
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_3:
; VI-NEXT:    s_branch .LBB29_2
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB29_4
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_3:
; GFX9-NEXT:    s_branch .LBB29_2
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_4
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_3:
; GFX11-NEXT:    s_branch .LBB29_2
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define double @bitcast_v2i32_to_f64(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v2i32_to_f64_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v2i32_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v2i32_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB31_3
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB31_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    s_branch .LBB31_2
;
; GFX11-LABEL: bitcast_v2i32_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB31_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_4:
; GFX11-NEXT:    s_branch .LBB31_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <2 x float> @bitcast_f64_to_v2f32(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB32_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_f64_to_v2f32_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB33_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB33_4
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_3:
; SI-NEXT:    s_branch .LBB33_2
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB33_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB33_4
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_3:
; VI-NEXT:    s_branch .LBB33_2
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB33_4
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_3:
; GFX9-NEXT:    s_branch .LBB33_2
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_4
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3:
; GFX11-NEXT:    s_branch .LBB33_2
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define double @bitcast_v2f32_to_f64(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v2f32_to_f64_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB35_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB35_4
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_3:
; SI-NEXT:    s_branch .LBB35_2
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB35_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB35_4
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_3:
; VI-NEXT:    s_branch .LBB35_2
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB35_4
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_3:
; GFX9-NEXT:    s_branch .LBB35_2
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB35_4
; GFX11-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3:
; GFX11-NEXT:    s_branch .LBB35_2
; GFX11-NEXT:  .LBB35_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <4 x i16> @bitcast_f64_to_v4i16(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v1
; SI-NEXT:    v_mov_b32_e32 v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v1, v5, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_alignbit_b32 v1, v5, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v4
; SI-NEXT:    v_mov_b32_e32 v2, v5
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB36_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB36_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_f64_to_v4i16_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB37_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB37_4
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[4:5], s[16:17], 1.0
; SI-NEXT:    v_alignbit_b32 v1, v5, v4, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; SI-NEXT:    s_branch .LBB37_5
; SI-NEXT:  .LBB37_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB37_2
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    v_mov_b32_e32 v5, s17
; SI-NEXT:    v_mov_b32_e32 v4, s16
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:  .LBB37_5: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, v4
; SI-NEXT:    v_mov_b32_e32 v2, v5
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB37_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB37_4
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_3:
; VI-NEXT:    s_branch .LBB37_2
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB37_4
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_3:
; GFX9-NEXT:    s_branch .LBB37_2
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB37_4
; GFX11-NEXT:  .LBB37_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_3:
; GFX11-NEXT:    s_branch .LBB37_2
; GFX11-NEXT:  .LBB37_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define double @bitcast_v4i16_to_f64(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_4
; SI-NEXT:  .LBB38_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB38_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_2
; SI-NEXT:  .LBB38_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_e32 v2, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_u16_e32 v2, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v4i16_to_f64_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB39_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB39_3
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:  .LBB39_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB39_2
;
; VI-LABEL: bitcast_v4i16_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB39_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB39_3
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB39_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    s_branch .LBB39_2
;
; GFX9-LABEL: bitcast_v4i16_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB39_4
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_3:
; GFX9-NEXT:    s_branch .LBB39_2
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB39_4
; GFX11-NEXT:  .LBB39_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:    s_branch .LBB39_2
; GFX11-NEXT:  .LBB39_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <4 x half> @bitcast_f64_to_v4f16(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v2
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:  .LBB40_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:  .LBB40_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v4
; SI-NEXT:    v_mov_b32_e32 v1, v5
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB40_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_f64_to_v4f16_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_f64_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB41_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB41_4
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_3:
; VI-NEXT:    s_branch .LBB41_2
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB41_4
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_3:
; GFX9-NEXT:    s_branch .LBB41_2
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_4
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_3:
; GFX11-NEXT:    s_branch .LBB41_2
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define double @bitcast_v4f16_to_f64(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_4
; SI-NEXT:  .LBB42_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB42_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  .LBB42_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 0x200
; VI-NEXT:    v_add_f16_sdwa v3, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v2, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v4f16_to_f64_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v4f16_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB43_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB43_4
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_add_f16_sdwa v2, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_3:
; VI-NEXT:    s_branch .LBB43_2
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB43_4
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB43_3:
; GFX9-NEXT:    s_branch .LBB43_2
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB43_4
; GFX11-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB43_3:
; GFX11-NEXT:    s_branch .LBB43_2
; GFX11-NEXT:  .LBB43_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <4 x bfloat> @bitcast_f64_to_v4bf16(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v5
; SI-NEXT:    v_mov_b32_e32 v1, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB44_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_f64_to_v4bf16_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB45_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s9, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s8, s17, 16
; SI-NEXT:    s_and_b32 s7, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB45_4
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_3:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    s_branch .LBB45_2
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB45_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB45_4
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_3:
; VI-NEXT:    s_branch .LBB45_2
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB45_4
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_3:
; GFX9-NEXT:    s_branch .LBB45_2
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_4
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_3:
; GFX11-NEXT:    s_branch .LBB45_2
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define double @bitcast_v4bf16_to_f64(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_4
; SI-NEXT:  .LBB46_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB46_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_2
; SI-NEXT:  .LBB46_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB46_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB46_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s7
; GFX9-NEXT:  .LBB46_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_f64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v1, v7, v10 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v9, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v3
; GFX11-TRUE16-NEXT:  .LBB46_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_f64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v8, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB46_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v4bf16_to_f64_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v2, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s18
; SI-NEXT:    s_cbranch_scc0 .LBB47_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; SI-NEXT:    s_cbranch_execnz .LBB47_3
; SI-NEXT:  .LBB47_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB47_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB47_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB47_2
;
; VI-LABEL: bitcast_v4bf16_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB47_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB47_4
; VI-NEXT:  .LBB47_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB47_3:
; VI-NEXT:    s_branch .LBB47_2
; VI-NEXT:  .LBB47_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB47_4
; GFX9-NEXT:  .LBB47_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v2
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v2, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB47_3:
; GFX9-NEXT:    s_branch .LBB47_2
; GFX9-NEXT:  .LBB47_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB47_4
; GFX11-NEXT:  .LBB47_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s1
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v4, v8, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB47_3:
; GFX11-NEXT:    s_branch .LBB47_2
; GFX11-NEXT:  .LBB47_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <8 x i8> @bitcast_f64_to_v8i8(double %a, i32 %b) {
; SI-LABEL: bitcast_f64_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v1
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v3, v9, v8, 24
; SI-NEXT:    v_alignbit_b32 v2, v9, v8, 16
; SI-NEXT:    v_alignbit_b32 v1, v9, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_alignbit_b32 v3, v9, v8, 24
; SI-NEXT:    v_alignbit_b32 v2, v9, v8, 16
; SI-NEXT:    v_alignbit_b32 v1, v9, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v8
; SI-NEXT:    v_mov_b32_e32 v4, v9
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB48_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  .LBB48_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB48_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  .LBB48_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_f64_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB48_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  .LBB48_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_f64_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB48_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  .LBB48_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_f64_to_v8i8_scalar(double inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_f64_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB49_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s8, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB49_4
; SI-NEXT:  .LBB49_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[8:9], s[16:17], 1.0
; SI-NEXT:    v_alignbit_b32 v3, v9, v8, 24
; SI-NEXT:    v_alignbit_b32 v2, v9, v8, 16
; SI-NEXT:    v_alignbit_b32 v1, v9, v8, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; SI-NEXT:    s_branch .LBB49_5
; SI-NEXT:  .LBB49_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB49_2
; SI-NEXT:  .LBB49_4:
; SI-NEXT:    v_mov_b32_e32 v9, s17
; SI-NEXT:    v_mov_b32_e32 v8, s16
; SI-NEXT:    v_mov_b32_e32 v7, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v5, s6
; SI-NEXT:  .LBB49_5: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, v8
; SI-NEXT:    v_mov_b32_e32 v4, v9
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_f64_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB49_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s9, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s5, s17, 8
; VI-NEXT:    s_lshr_b32 s11, s16, 16
; VI-NEXT:    s_lshr_b32 s10, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB49_4
; VI-NEXT:  .LBB49_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[8:9], s[16:17], 1.0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:    s_branch .LBB49_5
; VI-NEXT:  .LBB49_3:
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    s_branch .LBB49_2
; VI-NEXT:  .LBB49_4:
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    v_mov_b32_e32 v9, s17
; VI-NEXT:    v_mov_b32_e32 v2, s11
; VI-NEXT:    v_mov_b32_e32 v1, s10
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v7, s9
; VI-NEXT:    v_mov_b32_e32 v6, s8
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:  .LBB49_5: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_f64_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s9, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s5, s17, 8
; GFX9-NEXT:    s_lshr_b32 s11, s16, 16
; GFX9-NEXT:    s_lshr_b32 s10, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB49_4
; GFX9-NEXT:  .LBB49_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[8:9], s[16:17], 1.0
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:    s_branch .LBB49_5
; GFX9-NEXT:  .LBB49_3:
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    s_branch .LBB49_2
; GFX9-NEXT:  .LBB49_4:
; GFX9-NEXT:    v_mov_b32_e32 v8, s16
; GFX9-NEXT:    v_mov_b32_e32 v9, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s11
; GFX9-NEXT:    v_mov_b32_e32 v1, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v7, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-NEXT:  .LBB49_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_f64_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s6, s1, 24
; GFX11-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-NEXT:    s_lshr_b32 s3, s1, 8
; GFX11-NEXT:    s_lshr_b32 s8, s0, 16
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB49_4
; GFX11-NEXT:  .LBB49_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[8:9], s[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-NEXT:    s_branch .LBB49_5
; GFX11-NEXT:  .LBB49_3:
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB49_2
; GFX11-NEXT:  .LBB49_4:
; GFX11-NEXT:    v_dual_mov_b32 v8, s0 :: v_dual_mov_b32 v9, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s8 :: v_dual_mov_b32 v1, s7
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v6, s5
; GFX11-NEXT:    v_mov_b32_e32 v7, s6
; GFX11-NEXT:    v_mov_b32_e32 v5, s3
; GFX11-NEXT:  .LBB49_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd double %a, 1.000000e+00
  %a2 = bitcast double %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast double %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define double @bitcast_v8i8_to_f64(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v10, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v8, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v7
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_4
; SI-NEXT:  .LBB50_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB50_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB50_2
; SI-NEXT:  .LBB50_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_or_b32_e32 v0, v10, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB50_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB50_4
; VI-NEXT:  .LBB50_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB50_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB50_2
; VI-NEXT:  .LBB50_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB50_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB50_4
; GFX9-NEXT:  .LBB50_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB50_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB50_2
; GFX9-NEXT:  .LBB50_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_f64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB50_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB50_4
; GFX11-TRUE16-NEXT:  .LBB50_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB50_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB50_2
; GFX11-TRUE16-NEXT:  .LBB50_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_f64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB50_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB50_4
; GFX11-FAKE16-NEXT:  .LBB50_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB50_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB50_2
; GFX11-FAKE16-NEXT:  .LBB50_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define inreg double @bitcast_v8i8_to_f64_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB51_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB51_3
; SI-NEXT:  .LBB51_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:  .LBB51_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB51_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB51_2
;
; VI-LABEL: bitcast_v8i8_to_f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB51_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB51_3
; VI-NEXT:  .LBB51_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB51_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB51_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB51_2
;
; GFX9-LABEL: bitcast_v8i8_to_f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB51_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB51_3
; GFX9-NEXT:  .LBB51_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB51_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB51_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB51_2
;
; GFX11-LABEL: bitcast_v8i8_to_f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB51_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB51_3
; GFX11-NEXT:  .LBB51_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB51_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB51_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB51_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to double
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to double
  br label %end

end:
  %phi = phi double [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret double %phi
}

define <2 x float> @bitcast_v2i32_to_v2f32(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_v2i32_to_v2f32_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB53_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB53_3
; SI-NEXT:  .LBB53_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB53_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB53_4:
; SI-NEXT:    s_branch .LBB53_2
;
; VI-LABEL: bitcast_v2i32_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB53_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB53_3
; VI-NEXT:  .LBB53_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB53_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB53_4:
; VI-NEXT:    s_branch .LBB53_2
;
; GFX9-LABEL: bitcast_v2i32_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB53_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB53_3
; GFX9-NEXT:  .LBB53_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB53_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB53_4:
; GFX9-NEXT:    s_branch .LBB53_2
;
; GFX11-LABEL: bitcast_v2i32_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB53_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB53_3
; GFX11-NEXT:  .LBB53_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB53_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB53_4:
; GFX11-NEXT:    s_branch .LBB53_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define <2 x i32> @bitcast_v2f32_to_v2i32(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_v2f32_to_v2i32_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB55_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB55_4
; SI-NEXT:  .LBB55_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB55_3:
; SI-NEXT:    s_branch .LBB55_2
; SI-NEXT:  .LBB55_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB55_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB55_4
; VI-NEXT:  .LBB55_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB55_3:
; VI-NEXT:    s_branch .LBB55_2
; VI-NEXT:  .LBB55_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB55_4
; GFX9-NEXT:  .LBB55_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB55_3:
; GFX9-NEXT:    s_branch .LBB55_2
; GFX9-NEXT:  .LBB55_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB55_4
; GFX11-NEXT:  .LBB55_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB55_3:
; GFX11-NEXT:    s_branch .LBB55_2
; GFX11-NEXT:  .LBB55_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define <4 x i16> @bitcast_v2i32_to_v4i16(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v2, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_v2i32_to_v4i16_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB57_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB57_3
; SI-NEXT:  .LBB57_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:  .LBB57_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB57_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB57_2
;
; VI-LABEL: bitcast_v2i32_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB57_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB57_3
; VI-NEXT:  .LBB57_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB57_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB57_4:
; VI-NEXT:    s_branch .LBB57_2
;
; GFX9-LABEL: bitcast_v2i32_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB57_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB57_3
; GFX9-NEXT:  .LBB57_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB57_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB57_4:
; GFX9-NEXT:    s_branch .LBB57_2
;
; GFX11-LABEL: bitcast_v2i32_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB57_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB57_3
; GFX11-NEXT:  .LBB57_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB57_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB57_4:
; GFX11-NEXT:    s_branch .LBB57_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define <2 x i32> @bitcast_v4i16_to_v2i32(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_4
; SI-NEXT:  .LBB58_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB58_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB58_2
; SI-NEXT:  .LBB58_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_e32 v2, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_u16_e32 v2, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_v4i16_to_v2i32_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB59_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB59_3
; SI-NEXT:  .LBB59_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:  .LBB59_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB59_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB59_2
;
; VI-LABEL: bitcast_v4i16_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB59_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB59_3
; VI-NEXT:  .LBB59_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB59_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB59_4:
; VI-NEXT:    s_branch .LBB59_2
;
; GFX9-LABEL: bitcast_v4i16_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB59_4
; GFX9-NEXT:  .LBB59_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB59_3:
; GFX9-NEXT:    s_branch .LBB59_2
; GFX9-NEXT:  .LBB59_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB59_4
; GFX11-NEXT:  .LBB59_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB59_3:
; GFX11-NEXT:    s_branch .LBB59_2
; GFX11-NEXT:  .LBB59_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define <4 x half> @bitcast_v2i32_to_v4f16(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB60_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB60_4
; SI-NEXT:  .LBB60_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB60_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB60_2
; SI-NEXT:  .LBB60_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_v2i32_to_v4f16_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB61_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB61_3
; SI-NEXT:  .LBB61_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s4, s16, 3
; SI-NEXT:    s_add_i32 s6, s17, 3
; SI-NEXT:    s_lshr_b32 s5, s4, 16
; SI-NEXT:    s_lshr_b32 s7, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s5
; SI-NEXT:  .LBB61_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB61_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB61_2
;
; VI-LABEL: bitcast_v2i32_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB61_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB61_3
; VI-NEXT:  .LBB61_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB61_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB61_4:
; VI-NEXT:    s_branch .LBB61_2
;
; GFX9-LABEL: bitcast_v2i32_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB61_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB61_3
; GFX9-NEXT:  .LBB61_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB61_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB61_4:
; GFX9-NEXT:    s_branch .LBB61_2
;
; GFX11-LABEL: bitcast_v2i32_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB61_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB61_3
; GFX11-NEXT:  .LBB61_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB61_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB61_4:
; GFX11-NEXT:    s_branch .LBB61_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define <2 x i32> @bitcast_v4f16_to_v2i32(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB62_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB62_4
; SI-NEXT:  .LBB62_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB62_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB62_2
; SI-NEXT:  .LBB62_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 0x200
; VI-NEXT:    v_add_f16_sdwa v3, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v2, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_v4f16_to_v2i32_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB63_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_cbranch_execnz .LBB63_3
; SI-NEXT:  .LBB63_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:  .LBB63_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB63_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB63_2
;
; VI-LABEL: bitcast_v4f16_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB63_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB63_4
; VI-NEXT:  .LBB63_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_add_f16_sdwa v2, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB63_3:
; VI-NEXT:    s_branch .LBB63_2
; VI-NEXT:  .LBB63_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB63_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB63_4
; GFX9-NEXT:  .LBB63_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB63_3:
; GFX9-NEXT:    s_branch .LBB63_2
; GFX9-NEXT:  .LBB63_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB63_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB63_4
; GFX11-NEXT:  .LBB63_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB63_3:
; GFX11-NEXT:    s_branch .LBB63_2
; GFX11-NEXT:  .LBB63_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define <4 x bfloat> @bitcast_v2i32_to_v4bf16(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v1
; SI-NEXT:    v_mov_b32_e32 v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB64_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB64_4
; SI-NEXT:  .LBB64_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB64_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB64_2
; SI-NEXT:  .LBB64_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2i32_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_v2i32_to_v4bf16_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB65_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_and_b32 s8, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB65_3
; SI-NEXT:  .LBB65_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s4, s16, 3
; SI-NEXT:    s_add_i32 s5, s17, 3
; SI-NEXT:    s_and_b32 s6, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s5, 16
; SI-NEXT:    s_and_b32 s8, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s4, 16
; SI-NEXT:  .LBB65_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    v_mov_b32_e32 v1, s8
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB65_4:
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB65_2
;
; VI-LABEL: bitcast_v2i32_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB65_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB65_3
; VI-NEXT:  .LBB65_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB65_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB65_4:
; VI-NEXT:    s_branch .LBB65_2
;
; GFX9-LABEL: bitcast_v2i32_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB65_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB65_3
; GFX9-NEXT:  .LBB65_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB65_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB65_4:
; GFX9-NEXT:    s_branch .LBB65_2
;
; GFX11-LABEL: bitcast_v2i32_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB65_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB65_3
; GFX11-NEXT:  .LBB65_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB65_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB65_4:
; GFX11-NEXT:    s_branch .LBB65_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define <2 x i32> @bitcast_v4bf16_to_v2i32(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB66_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB66_4
; SI-NEXT:  .LBB66_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB66_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB66_2
; SI-NEXT:  .LBB66_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB66_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB66_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB66_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s7
; GFX9-NEXT:  .LBB66_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_v2i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB66_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v1, v7, v10 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v9, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v3
; GFX11-TRUE16-NEXT:  .LBB66_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_v2i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB66_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v8, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB66_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_v4bf16_to_v2i32_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v2, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s18
; SI-NEXT:    s_cbranch_scc0 .LBB67_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; SI-NEXT:    s_cbranch_execnz .LBB67_3
; SI-NEXT:  .LBB67_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB67_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB67_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB67_2
;
; VI-LABEL: bitcast_v4bf16_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB67_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB67_4
; VI-NEXT:  .LBB67_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB67_3:
; VI-NEXT:    s_branch .LBB67_2
; VI-NEXT:  .LBB67_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB67_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB67_4
; GFX9-NEXT:  .LBB67_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v2
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v2, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB67_3:
; GFX9-NEXT:    s_branch .LBB67_2
; GFX9-NEXT:  .LBB67_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB67_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB67_4
; GFX11-NEXT:  .LBB67_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s1
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v4, v8, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB67_3:
; GFX11-NEXT:    s_branch .LBB67_2
; GFX11-NEXT:  .LBB67_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define <8 x i8> @bitcast_v2i32_to_v8i8(<2 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v2i32_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB68_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB68_4
; SI-NEXT:  .LBB68_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB68_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB68_2
; SI-NEXT:  .LBB68_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2i32_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2i32_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v2i32_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v2i32_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB68_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  .LBB68_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_v2i32_to_v8i8_scalar(<2 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2i32_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB69_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB69_3
; SI-NEXT:  .LBB69_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:  .LBB69_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB69_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB69_2
;
; VI-LABEL: bitcast_v2i32_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB69_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s5, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB69_3
; VI-NEXT:  .LBB69_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s5, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:  .LBB69_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s9
; VI-NEXT:    v_mov_b32_e32 v6, s8
; VI-NEXT:    v_mov_b32_e32 v7, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB69_4:
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    s_branch .LBB69_2
;
; GFX9-LABEL: bitcast_v2i32_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB69_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB69_3
; GFX9-NEXT:  .LBB69_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:  .LBB69_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB69_4:
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    s_branch .LBB69_2
;
; GFX11-LABEL: bitcast_v2i32_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB69_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s4, s1, 16
; GFX11-NEXT:    s_lshr_b32 s5, s1, 8
; GFX11-NEXT:    s_lshr_b32 s6, s0, 16
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB69_3
; GFX11-NEXT:  .LBB69_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s4, s1, 16
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s5, s1, 8
; GFX11-NEXT:    s_lshr_b32 s6, s0, 16
; GFX11-NEXT:    s_lshr_b32 s7, s0, 8
; GFX11-NEXT:  .LBB69_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s7
; GFX11-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s4 :: v_dual_mov_b32 v7, s3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB69_4:
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    s_branch .LBB69_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <2 x i32> %a, splat (i32 3)
  %a2 = bitcast <2 x i32> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <2 x i32> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define <2 x i32> @bitcast_v8i8_to_v2i32(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v10, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v8, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v7
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB70_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB70_4
; SI-NEXT:  .LBB70_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB70_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB70_2
; SI-NEXT:  .LBB70_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_or_b32_e32 v0, v10, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB70_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB70_4
; VI-NEXT:  .LBB70_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB70_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB70_2
; VI-NEXT:  .LBB70_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB70_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB70_4
; GFX9-NEXT:  .LBB70_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB70_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB70_2
; GFX9-NEXT:  .LBB70_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_v2i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB70_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB70_4
; GFX11-TRUE16-NEXT:  .LBB70_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB70_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB70_2
; GFX11-TRUE16-NEXT:  .LBB70_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_v2i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB70_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB70_4
; GFX11-FAKE16-NEXT:  .LBB70_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB70_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB70_2
; GFX11-FAKE16-NEXT:  .LBB70_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define inreg <2 x i32> @bitcast_v8i8_to_v2i32_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_v2i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB71_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB71_3
; SI-NEXT:  .LBB71_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:  .LBB71_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB71_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB71_2
;
; VI-LABEL: bitcast_v8i8_to_v2i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB71_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB71_3
; VI-NEXT:  .LBB71_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB71_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB71_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB71_2
;
; GFX9-LABEL: bitcast_v8i8_to_v2i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB71_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB71_3
; GFX9-NEXT:  .LBB71_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB71_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB71_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB71_2
;
; GFX11-LABEL: bitcast_v8i8_to_v2i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB71_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB71_3
; GFX11-NEXT:  .LBB71_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB71_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB71_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB71_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <2 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <2 x i32>
  br label %end

end:
  %phi = phi <2 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x i32> %phi
}

define <4 x i16> @bitcast_v2f32_to_v4i16(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:  ; %bb.4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v2, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_v2f32_to_v4i16_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB73_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB73_4
; SI-NEXT:  .LBB73_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB73_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB73_2
; SI-NEXT:  .LBB73_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB73_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB73_4
; VI-NEXT:  .LBB73_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB73_3:
; VI-NEXT:    s_branch .LBB73_2
; VI-NEXT:  .LBB73_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB73_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB73_4
; GFX9-NEXT:  .LBB73_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB73_3:
; GFX9-NEXT:    s_branch .LBB73_2
; GFX9-NEXT:  .LBB73_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB73_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB73_4
; GFX11-NEXT:  .LBB73_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB73_3:
; GFX11-NEXT:    s_branch .LBB73_2
; GFX11-NEXT:  .LBB73_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define <2 x float> @bitcast_v4i16_to_v2f32(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB74_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB74_4
; SI-NEXT:  .LBB74_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB74_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v4
; SI-NEXT:    v_or_b32_e32 v1, v1, v3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB74_2
; SI-NEXT:  .LBB74_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x30000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 3
; VI-NEXT:    v_add_u16_e32 v2, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_u16_e32 v2, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_v4i16_to_v2f32_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB75_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB75_3
; SI-NEXT:  .LBB75_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:  .LBB75_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB75_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB75_2
;
; VI-LABEL: bitcast_v4i16_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB75_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB75_3
; VI-NEXT:  .LBB75_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB75_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB75_4:
; VI-NEXT:    s_branch .LBB75_2
;
; GFX9-LABEL: bitcast_v4i16_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB75_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB75_4
; GFX9-NEXT:  .LBB75_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB75_3:
; GFX9-NEXT:    s_branch .LBB75_2
; GFX9-NEXT:  .LBB75_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB75_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB75_4
; GFX11-NEXT:  .LBB75_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB75_3:
; GFX11-NEXT:    s_branch .LBB75_2
; GFX11-NEXT:  .LBB75_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define <4 x half> @bitcast_v2f32_to_v4f16(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB76_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB76_4
; SI-NEXT:  .LBB76_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB76_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB76_2
; SI-NEXT:  .LBB76_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_v2f32_to_v4f16_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB77_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB77_3
; SI-NEXT:  .LBB77_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB77_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB77_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB77_2
;
; VI-LABEL: bitcast_v2f32_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB77_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB77_4
; VI-NEXT:  .LBB77_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB77_3:
; VI-NEXT:    s_branch .LBB77_2
; VI-NEXT:  .LBB77_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB77_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB77_4
; GFX9-NEXT:  .LBB77_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB77_3:
; GFX9-NEXT:    s_branch .LBB77_2
; GFX9-NEXT:  .LBB77_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB77_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB77_4
; GFX11-NEXT:  .LBB77_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB77_3:
; GFX11-NEXT:    s_branch .LBB77_2
; GFX11-NEXT:  .LBB77_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define <2 x float> @bitcast_v4f16_to_v2f32(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB78_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB78_4
; SI-NEXT:  .LBB78_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB78_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB78_2
; SI-NEXT:  .LBB78_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 0x200
; VI-NEXT:    v_add_f16_sdwa v3, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v2, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v3
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_v4f16_to_v2f32_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB79_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    s_cbranch_execnz .LBB79_3
; SI-NEXT:  .LBB79_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:  .LBB79_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB79_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB79_2
;
; VI-LABEL: bitcast_v4f16_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB79_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB79_4
; VI-NEXT:  .LBB79_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_add_f16_sdwa v2, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB79_3:
; VI-NEXT:    s_branch .LBB79_2
; VI-NEXT:  .LBB79_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB79_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB79_4
; GFX9-NEXT:  .LBB79_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB79_3:
; GFX9-NEXT:    s_branch .LBB79_2
; GFX9-NEXT:  .LBB79_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB79_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB79_4
; GFX11-NEXT:  .LBB79_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB79_3:
; GFX11-NEXT:    s_branch .LBB79_2
; GFX11-NEXT:  .LBB79_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define <4 x bfloat> @bitcast_v2f32_to_v4bf16(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v5, v1
; SI-NEXT:    v_mov_b32_e32 v4, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB80_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB80_4
; SI-NEXT:  .LBB80_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB80_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB80_2
; SI-NEXT:  .LBB80_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v5
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_v2f32_to_v4bf16_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB81_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_and_b32 s8, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB81_4
; SI-NEXT:  .LBB81_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB81_3:
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB81_2
; SI-NEXT:  .LBB81_4:
; SI-NEXT:    v_mov_b32_e32 v0, s9
; SI-NEXT:    v_mov_b32_e32 v1, s8
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB81_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB81_4
; VI-NEXT:  .LBB81_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB81_3:
; VI-NEXT:    s_branch .LBB81_2
; VI-NEXT:  .LBB81_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB81_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB81_4
; GFX9-NEXT:  .LBB81_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB81_3:
; GFX9-NEXT:    s_branch .LBB81_2
; GFX9-NEXT:  .LBB81_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB81_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB81_4
; GFX11-NEXT:  .LBB81_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB81_3:
; GFX11-NEXT:    s_branch .LBB81_2
; GFX11-NEXT:  .LBB81_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define <2 x float> @bitcast_v4bf16_to_v2f32(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB82_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB82_4
; SI-NEXT:  .LBB82_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB82_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB82_2
; SI-NEXT:  .LBB82_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB82_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB82_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB82_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s7
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s7
; GFX9-NEXT:  .LBB82_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_v2f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB82_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v1, v7, v10 :: v_dual_lshlrev_b32 v0, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v9, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v8, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v3
; GFX11-TRUE16-NEXT:  .LBB82_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_v2f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB82_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_lshlrev_b32 v2, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v0, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v8, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v2, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB82_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_v4bf16_to_v2f32_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v2, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v3, 1.0, s18
; SI-NEXT:    s_cbranch_scc0 .LBB83_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_alignbit_b32 v0, v0, v5, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; SI-NEXT:    s_cbranch_execnz .LBB83_3
; SI-NEXT:  .LBB83_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB83_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB83_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB83_2
;
; VI-LABEL: bitcast_v4bf16_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB83_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB83_4
; VI-NEXT:  .LBB83_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB83_3:
; VI-NEXT:    s_branch .LBB83_2
; VI-NEXT:  .LBB83_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB83_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB83_4
; GFX9-NEXT:  .LBB83_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v3, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v2
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v2, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB83_3:
; GFX9-NEXT:    s_branch .LBB83_2
; GFX9-NEXT:  .LBB83_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB83_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB83_4
; GFX11-NEXT:  .LBB83_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s1
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v4, v8, vcc_lo
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v3, 16, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB83_3:
; GFX11-NEXT:    s_branch .LBB83_2
; GFX11-NEXT:  .LBB83_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define <8 x i8> @bitcast_v2f32_to_v8i8(<2 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v2f32_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB84_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB84_4
; SI-NEXT:  .LBB84_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB84_3: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB84_2
; SI-NEXT:  .LBB84_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v2f32_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v2f32_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB84_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  .LBB84_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_v2f32_to_v8i8_scalar(<2 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v2f32_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s18, 0
; SI-NEXT:    s_cbranch_scc0 .LBB85_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB85_4
; SI-NEXT:  .LBB85_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v4, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB85_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB85_2
; SI-NEXT:  .LBB85_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v2f32_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB85_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s5, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB85_4
; VI-NEXT:  .LBB85_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v9, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v8, s16, 1.0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:    s_branch .LBB85_5
; VI-NEXT:  .LBB85_3:
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    s_branch .LBB85_2
; VI-NEXT:  .LBB85_4:
; VI-NEXT:    v_mov_b32_e32 v8, s16
; VI-NEXT:    v_mov_b32_e32 v9, s17
; VI-NEXT:    v_mov_b32_e32 v1, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v5, s9
; VI-NEXT:    v_mov_b32_e32 v6, s8
; VI-NEXT:    v_mov_b32_e32 v7, s5
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:  .LBB85_5: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v2f32_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB85_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB85_4
; GFX9-NEXT:  .LBB85_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v9, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v8, s16, 1.0
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:    s_branch .LBB85_5
; GFX9-NEXT:  .LBB85_3:
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    s_branch .LBB85_2
; GFX9-NEXT:  .LBB85_4:
; GFX9-NEXT:    v_mov_b32_e32 v8, s16
; GFX9-NEXT:    v_mov_b32_e32 v9, s17
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB85_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v2f32_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB85_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-NEXT:    s_lshr_b32 s6, s1, 8
; GFX11-NEXT:    s_lshr_b32 s7, s0, 16
; GFX11-NEXT:    s_lshr_b32 s8, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB85_4
; GFX11-NEXT:  .LBB85_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v9, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v8, s0, 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-NEXT:    s_branch .LBB85_5
; GFX11-NEXT:  .LBB85_3:
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    s_branch .LBB85_2
; GFX11-NEXT:  .LBB85_4:
; GFX11-NEXT:    v_dual_mov_b32 v8, s0 :: v_dual_mov_b32 v9, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, s8 :: v_dual_mov_b32 v2, s7
; GFX11-NEXT:    v_dual_mov_b32 v5, s6 :: v_dual_mov_b32 v6, s5
; GFX11-NEXT:    v_mov_b32_e32 v7, s3
; GFX11-NEXT:    v_mov_b32_e32 v3, s2
; GFX11-NEXT:  .LBB85_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <2 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <2 x float> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <2 x float> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define <2 x float> @bitcast_v8i8_to_v2f32(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_v2f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v10, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v8, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 24, v7
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB86_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB86_4
; SI-NEXT:  .LBB86_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB86_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_or_b32_e32 v0, v0, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v1, v1, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB86_2
; SI-NEXT:  .LBB86_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_or_b32_e32 v0, v10, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x3000000, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_v2f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB86_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB86_4
; VI-NEXT:  .LBB86_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB86_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB86_2
; VI-NEXT:  .LBB86_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB86_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB86_4
; GFX9-NEXT:  .LBB86_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB86_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB86_2
; GFX9-NEXT:  .LBB86_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_v2f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB86_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB86_4
; GFX11-TRUE16-NEXT:  .LBB86_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB86_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB86_2
; GFX11-TRUE16-NEXT:  .LBB86_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_v2f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB86_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB86_4
; GFX11-FAKE16-NEXT:  .LBB86_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB86_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB86_2
; GFX11-FAKE16-NEXT:  .LBB86_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define inreg <2 x float> @bitcast_v8i8_to_v2f32_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_v2f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB87_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_cbranch_execnz .LBB87_3
; SI-NEXT:  .LBB87_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:  .LBB87_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB87_4:
; SI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; SI-NEXT:    s_branch .LBB87_2
;
; VI-LABEL: bitcast_v8i8_to_v2f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB87_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB87_3
; VI-NEXT:  .LBB87_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB87_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB87_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB87_2
;
; GFX9-LABEL: bitcast_v8i8_to_v2f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB87_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB87_3
; GFX9-NEXT:  .LBB87_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB87_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB87_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB87_2
;
; GFX11-LABEL: bitcast_v8i8_to_v2f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB87_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB87_3
; GFX11-NEXT:  .LBB87_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB87_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB87_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB87_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <2 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <2 x float>
  br label %end

end:
  %phi = phi <2 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <2 x float> %phi
}

define <4 x half> @bitcast_v4i16_to_v4f16(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v8, v3
; SI-NEXT:    v_mov_b32_e32 v5, v2
; SI-NEXT:    v_mov_b32_e32 v6, v1
; SI-NEXT:    v_mov_b32_e32 v7, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB88_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB88_4
; SI-NEXT:  .LBB88_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB88_3: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v8
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB88_2
; SI-NEXT:  .LBB88_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 3
; VI-NEXT:    v_add_u16_sdwa v3, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v2, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_v4i16_to_v4f16_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB89_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:    s_cbranch_execnz .LBB89_3
; SI-NEXT:  .LBB89_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s19
; SI-NEXT:  .LBB89_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB89_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB89_2
;
; VI-LABEL: bitcast_v4i16_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB89_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB89_3
; VI-NEXT:  .LBB89_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s7, s17, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s17, s6, 0x30000
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB89_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB89_4:
; VI-NEXT:    s_branch .LBB89_2
;
; GFX9-LABEL: bitcast_v4i16_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB89_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB89_4
; GFX9-NEXT:  .LBB89_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB89_3:
; GFX9-NEXT:    s_branch .LBB89_2
; GFX9-NEXT:  .LBB89_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB89_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB89_4
; GFX11-NEXT:  .LBB89_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB89_3:
; GFX11-NEXT:    s_branch .LBB89_2
; GFX11-NEXT:  .LBB89_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define <4 x i16> @bitcast_v4f16_to_v4i16(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB90_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v4
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB90_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 0x200
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v4, v1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v4i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_v4f16_to_v4i16_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v1, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v2, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v3, s19
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB91_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB91_3
; SI-NEXT:  .LBB91_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v4
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB91_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB91_4:
; SI-NEXT:    s_branch .LBB91_2
;
; VI-LABEL: bitcast_v4f16_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB91_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB91_4
; VI-NEXT:  .LBB91_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_add_f16_e32 v2, s16, v0
; VI-NEXT:    v_add_f16_sdwa v3, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s17, v0
; VI-NEXT:    v_add_f16_sdwa v0, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v0
; VI-NEXT:    v_or_b32_e32 v0, v2, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB91_3:
; VI-NEXT:    s_branch .LBB91_2
; VI-NEXT:  .LBB91_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB91_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB91_4
; GFX9-NEXT:  .LBB91_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB91_3:
; GFX9-NEXT:    s_branch .LBB91_2
; GFX9-NEXT:  .LBB91_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB91_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB91_4
; GFX11-NEXT:  .LBB91_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB91_3:
; GFX11-NEXT:    s_branch .LBB91_2
; GFX11-NEXT:  .LBB91_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define <4 x bfloat> @bitcast_v4i16_to_v4bf16(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v6, v2
; SI-NEXT:    v_mov_b32_e32 v5, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB92_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB92_4
; SI-NEXT:  .LBB92_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB92_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB92_2
; SI-NEXT:  .LBB92_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v3, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v5
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 3
; VI-NEXT:    v_add_u16_sdwa v3, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v2, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v1, 3, v1
; VI-NEXT:    v_add_u16_e32 v0, 3, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_or_b32_e32 v0, v0, v3
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_v4i16_to_v4bf16_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB93_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshl_b32 s6, s16, 16
; SI-NEXT:    s_lshl_b32 s7, s17, 16
; SI-NEXT:    s_lshl_b32 s9, s18, 16
; SI-NEXT:    s_lshl_b32 s8, s19, 16
; SI-NEXT:    s_cbranch_execnz .LBB93_3
; SI-NEXT:  .LBB93_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s19, 16
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s17, 16
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_and_b32 s7, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s5, 16
; SI-NEXT:    s_and_b32 s8, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s4, 16
; SI-NEXT:  .LBB93_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB93_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB93_2
;
; VI-LABEL: bitcast_v4i16_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB93_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB93_3
; VI-NEXT:  .LBB93_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s7, s17, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s6, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s17, s6, 0x30000
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB93_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB93_4:
; VI-NEXT:    s_branch .LBB93_2
;
; GFX9-LABEL: bitcast_v4i16_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB93_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB93_4
; GFX9-NEXT:  .LBB93_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB93_3:
; GFX9-NEXT:    s_branch .LBB93_2
; GFX9-NEXT:  .LBB93_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB93_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB93_4
; GFX11-NEXT:  .LBB93_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB93_3:
; GFX11-NEXT:    s_branch .LBB93_2
; GFX11-NEXT:  .LBB93_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define <4 x i16> @bitcast_v4bf16_to_v4i16(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB94_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB94_4
; SI-NEXT:  .LBB94_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB94_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB94_2
; SI-NEXT:  .LBB94_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; SI-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB94_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB94_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB94_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v3, s6
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s6
; GFX9-NEXT:  .LBB94_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_v4i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB94_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v10, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v10, v10, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_add_f32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v3, v6, v7, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v10, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v1, v0, 16, v1
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v0, v3, 16, v2
; GFX11-TRUE16-NEXT:  .LBB94_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_v4i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB94_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v3, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v2, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB94_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_v4bf16_to_v4i16_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s19
; SI-NEXT:    s_cbranch_scc0 .LBB95_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; SI-NEXT:    s_cbranch_execnz .LBB95_3
; SI-NEXT:  .LBB95_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; SI-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:  .LBB95_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB95_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB95_2
;
; VI-LABEL: bitcast_v4bf16_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB95_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB95_4
; VI-NEXT:  .LBB95_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v1, v0, v1, 16
; VI-NEXT:    v_alignbit_b32 v0, v3, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB95_3:
; VI-NEXT:    s_branch .LBB95_2
; VI-NEXT:  .LBB95_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB95_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB95_4
; GFX9-NEXT:  .LBB95_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_add_f32_e32 v3, s4, v0
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v3
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v0
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff0000
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_or_b32 v0, v3, v4, v0
; GFX9-NEXT:    v_and_or_b32 v1, v1, v4, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB95_3:
; GFX9-NEXT:    s_branch .LBB95_2
; GFX9-NEXT:  .LBB95_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB95_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB95_4
; GFX11-NEXT:  .LBB95_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s0, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s0, 0, s0
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s1
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_and_or_b32 v1, 0xffff0000, v3, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v4, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v0, 0xffff0000, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB95_3:
; GFX11-NEXT:    s_branch .LBB95_2
; GFX11-NEXT:  .LBB95_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define <8 x i8> @bitcast_v4i16_to_v8i8(<4 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v4i16_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v3
; SI-NEXT:    v_mov_b32_e32 v8, v2
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB96_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB96_4
; SI-NEXT:  .LBB96_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB96_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v0, v0, v12
; SI-NEXT:    v_or_b32_e32 v4, v1, v11
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v10
; SI-NEXT:    v_bfe_u32 v7, v10, 8, 8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB96_2
; SI-NEXT:  .LBB96_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v0, v12, v0
; SI-NEXT:    v_or_b32_e32 v1, v11, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x30000, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i16_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_mov_b32_e32 v8, v1
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB96_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v2, 3
; VI-NEXT:    v_add_u16_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_u16_e32 v8, 3, v1
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; VI-NEXT:    v_add_u16_e32 v9, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_or_b32_e32 v0, v9, v0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v4, 8, v0
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:  .LBB96_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v9
; VI-NEXT:    v_mov_b32_e32 v1, v4
; VI-NEXT:    v_mov_b32_e32 v4, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i16_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4i16_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4i16_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB96_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  .LBB96_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_v4i16_to_v8i8_scalar(<4 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i16_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB97_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s6, s4, s5
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s19, 16
; SI-NEXT:    s_or_b32 s7, s4, s5
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s7, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 8
; SI-NEXT:    s_lshr_b32 s9, s7, 8
; SI-NEXT:    s_and_b32 s10, s19, 0xffff
; SI-NEXT:    s_bfe_u32 s8, s19, 0x80008
; SI-NEXT:    s_cbranch_execnz .LBB97_3
; SI-NEXT:  .LBB97_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s6, s4, 0x30000
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s19, 16
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s7, s4, 0x30000
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_alignbit_b32 v3, s7, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s7, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 8
; SI-NEXT:    s_lshr_b32 s8, s7, 24
; SI-NEXT:    s_lshr_b32 s10, s7, 16
; SI-NEXT:    s_lshr_b32 s9, s7, 8
; SI-NEXT:  .LBB97_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    v_mov_b32_e32 v7, s8
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB97_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB97_2
;
; VI-LABEL: bitcast_v4i16_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB97_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s10, s17, 24
; VI-NEXT:    s_lshr_b32 s8, s17, 16
; VI-NEXT:    s_lshr_b32 s5, s17, 8
; VI-NEXT:    s_lshr_b32 s11, s16, 16
; VI-NEXT:    s_lshr_b32 s12, s16, 8
; VI-NEXT:    s_mov_b32 s9, s17
; VI-NEXT:    s_cbranch_execnz .LBB97_3
; VI-NEXT:  .LBB97_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s5, s17, 16
; VI-NEXT:    s_add_i32 s9, s17, 3
; VI-NEXT:    s_add_i32 s8, s5, 3
; VI-NEXT:    s_and_b32 s4, s9, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s8, 16
; VI-NEXT:    s_or_b32 s7, s4, s5
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s5, s16, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s6, s4, 0x30000
; VI-NEXT:    s_lshr_b64 s[4:5], s[6:7], 24
; VI-NEXT:    s_lshr_b32 s5, s7, 8
; VI-NEXT:    s_lshr_b32 s11, s6, 16
; VI-NEXT:    s_lshr_b32 s12, s6, 8
; VI-NEXT:    s_bfe_u32 s10, s8, 0x80008
; VI-NEXT:  .LBB97_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s12
; VI-NEXT:    v_mov_b32_e32 v2, s11
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s9
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    v_mov_b32_e32 v6, s8
; VI-NEXT:    v_mov_b32_e32 v7, s10
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB97_4:
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    s_branch .LBB97_2
;
; GFX9-LABEL: bitcast_v4i16_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB97_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB97_4
; GFX9-NEXT:  .LBB97_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v9, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:    s_branch .LBB97_5
; GFX9-NEXT:  .LBB97_3:
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    s_branch .LBB97_2
; GFX9-NEXT:  .LBB97_4:
; GFX9-NEXT:    v_mov_b32_e32 v8, s16
; GFX9-NEXT:    v_mov_b32_e32 v9, s17
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB97_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i16_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB97_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-NEXT:    s_lshr_b32 s6, s1, 8
; GFX11-NEXT:    s_lshr_b32 s7, s0, 16
; GFX11-NEXT:    s_lshr_b32 s8, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB97_4
; GFX11-NEXT:  .LBB97_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v9, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v8, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-NEXT:    s_branch .LBB97_5
; GFX11-NEXT:  .LBB97_3:
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    s_branch .LBB97_2
; GFX11-NEXT:  .LBB97_4:
; GFX11-NEXT:    v_dual_mov_b32 v8, s0 :: v_dual_mov_b32 v9, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, s8 :: v_dual_mov_b32 v2, s7
; GFX11-NEXT:    v_dual_mov_b32 v5, s6 :: v_dual_mov_b32 v6, s5
; GFX11-NEXT:    v_mov_b32_e32 v7, s3
; GFX11-NEXT:    v_mov_b32_e32 v3, s2
; GFX11-NEXT:  .LBB97_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i16> %a, splat (i16 3)
  %a2 = bitcast <4 x i16> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i16> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define <4 x i16> @bitcast_v8i8_to_v4i16(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_v4i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v9, v2
; SI-NEXT:    v_mov_b32_e32 v10, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v7, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v8, 8, v1
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB98_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB98_4
; SI-NEXT:  .LBB98_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB98_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v11
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v3, v5, v1
; SI-NEXT:    v_or_b32_e32 v2, v0, v3
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v4, v4, v8
; SI-NEXT:    v_or_b32_e32 v0, v7, v0
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB98_2
; SI-NEXT:  .LBB98_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v9
; SI-NEXT:    v_or_b32_e32 v0, v8, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v7, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v1, v11, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v5, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x3000000, v1
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_v4i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB98_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB98_4
; VI-NEXT:  .LBB98_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB98_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB98_2
; VI-NEXT:  .LBB98_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB98_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB98_4
; GFX9-NEXT:  .LBB98_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB98_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB98_2
; GFX9-NEXT:  .LBB98_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_v4i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB98_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB98_4
; GFX11-TRUE16-NEXT:  .LBB98_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB98_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB98_2
; GFX11-TRUE16-NEXT:  .LBB98_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_v4i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB98_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB98_4
; GFX11-FAKE16-NEXT:  .LBB98_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB98_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB98_2
; GFX11-FAKE16-NEXT:  .LBB98_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define inreg <4 x i16> @bitcast_v8i8_to_v4i16_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_v4i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB99_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s22, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s7, s4, s5
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_or_b32 s4, s6, s4
; SI-NEXT:    s_and_b32 s6, s16, 0xff
; SI-NEXT:    s_lshl_b32 s8, s17, 8
; SI-NEXT:    s_or_b32 s6, s6, s8
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 16
; SI-NEXT:    s_or_b32 s6, s6, s4
; SI-NEXT:    s_lshr_b32 s8, s5, 16
; SI-NEXT:    s_cbranch_execnz .LBB99_3
; SI-NEXT:  .LBB99_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s6, s4, 0x3000000
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s7
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_add_i32 s7, s4, 0x3000000
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_alignbit_b32 v1, s7, v0, 16
; SI-NEXT:    s_lshr_b32 s8, s7, 16
; SI-NEXT:  .LBB99_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_mov_b32_e32 v3, s8
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB99_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    s_branch .LBB99_2
;
; VI-LABEL: bitcast_v8i8_to_v4i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB99_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB99_3
; VI-NEXT:  .LBB99_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB99_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB99_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB99_2
;
; GFX9-LABEL: bitcast_v8i8_to_v4i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB99_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB99_3
; GFX9-NEXT:  .LBB99_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB99_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB99_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB99_2
;
; GFX11-LABEL: bitcast_v8i8_to_v4i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB99_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB99_3
; GFX11-NEXT:  .LBB99_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB99_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB99_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB99_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x i16>
  br label %end

end:
  %phi = phi <4 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i16> %phi
}

define <4 x bfloat> @bitcast_v4f16_to_v4bf16(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v3
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB100_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB100_4
; SI-NEXT:  .LBB100_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB100_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v8
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB100_2
; SI-NEXT:  .LBB100_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v5
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v3, 0x200
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v0
; VI-NEXT:    v_add_f16_sdwa v0, v0, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v4, v1
; VI-NEXT:    v_or_b32_e32 v0, v2, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_v4f16_to_v4bf16_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v5, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v7, s19
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB101_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; SI-NEXT:    s_cbranch_execnz .LBB101_3
; SI-NEXT:  .LBB101_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v4
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:  .LBB101_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB101_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB101_2
;
; VI-LABEL: bitcast_v4f16_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB101_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB101_4
; VI-NEXT:  .LBB101_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_add_f16_e32 v2, s16, v0
; VI-NEXT:    v_add_f16_sdwa v3, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s17, v0
; VI-NEXT:    v_add_f16_sdwa v0, v4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v0
; VI-NEXT:    v_or_b32_e32 v0, v2, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB101_3:
; VI-NEXT:    s_branch .LBB101_2
; VI-NEXT:  .LBB101_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB101_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB101_4
; GFX9-NEXT:  .LBB101_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB101_3:
; GFX9-NEXT:    s_branch .LBB101_2
; GFX9-NEXT:  .LBB101_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB101_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB101_4
; GFX11-NEXT:  .LBB101_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB101_3:
; GFX11-NEXT:    s_branch .LBB101_2
; GFX11-NEXT:  .LBB101_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define <4 x half> @bitcast_v4bf16_to_v4f16(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v4, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v5, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v6, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v7, 1.0, v3
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB102_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB102_4
; SI-NEXT:  .LBB102_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB102_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB102_2
; SI-NEXT:  .LBB102_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB102_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v3, 16
; VI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; VI-NEXT:  .LBB102_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB102_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v3, s6
; GFX9-NEXT:    v_perm_b32 v1, v2, v1, s6
; GFX9-NEXT:  .LBB102_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_v4f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB102_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v1, v6, v7 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v3, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v9, v11 :: v_dual_and_b32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v8, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v3, v0
; GFX11-TRUE16-NEXT:  .LBB102_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_v4f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB102_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 0x40c00000, v3 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v2, 0x40c00000, v2 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v3, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v2, v1, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB102_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_v4bf16_to_v4f16_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v4, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v5, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v6, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v7, 1.0, s19
; SI-NEXT:    s_cbranch_scc0 .LBB103_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    s_cbranch_execnz .LBB103_3
; SI-NEXT:  .LBB103_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v7
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v6
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v5
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v4
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:  .LBB103_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB103_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB103_2
;
; VI-LABEL: bitcast_v4bf16_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB103_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB103_4
; VI-NEXT:  .LBB103_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v3, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v1
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v1, v0, v1, 16
; VI-NEXT:    v_alignbit_b32 v0, v3, v2, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB103_3:
; VI-NEXT:    s_branch .LBB103_2
; VI-NEXT:  .LBB103_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB103_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB103_4
; GFX9-NEXT:  .LBB103_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_add_f32_e32 v3, s4, v0
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v3
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v0
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    v_and_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_and_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v3, 16, v0
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB103_3:
; GFX9-NEXT:    s_branch .LBB103_2
; GFX9-NEXT:  .LBB103_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s2, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB103_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s2
; GFX11-NEXT:    s_cbranch_vccnz .LBB103_4
; GFX11-NEXT:  .LBB103_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s1
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s0, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s0, 0, s0
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s1
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s0
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v4, v8 :: v_dual_and_b32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v1, v4, 16, v1
; GFX11-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB103_3:
; GFX11-NEXT:    s_branch .LBB103_2
; GFX11-NEXT:  .LBB103_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define <8 x i8> @bitcast_v4f16_to_v8i8(<4 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v4f16_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v2
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB104_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB104_4
; SI-NEXT:  .LBB104_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB104_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v4, v8, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB104_2
; SI-NEXT:  .LBB104_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v8
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v2
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_or_b32_e32 v4, v2, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f16_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB104_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_add_f16_sdwa v6, v9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_sdwa v2, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v9
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v2
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v8
; VI-NEXT:    v_or_b32_e32 v1, v9, v1
; VI-NEXT:    v_or_b32_e32 v0, v8, v0
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:  .LBB104_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB104_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  .LBB104_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4f16_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:  ; %bb.4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4f16_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB104_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  .LBB104_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_v4f16_to_v8i8_scalar(<4 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f16_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v9, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v6, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v8, s18
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    s_cbranch_scc0 .LBB105_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_or_b32_e32 v4, v8, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:    s_cbranch_execnz .LBB105_3
; SI-NEXT:  .LBB105_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v8
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v2
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; SI-NEXT:    v_or_b32_e32 v4, v2, v1
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; SI-NEXT:  .LBB105_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB105_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_branch .LBB105_2
;
; VI-LABEL: bitcast_v4f16_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB105_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s8, s17, 24
; VI-NEXT:    s_lshr_b32 s10, s17, 16
; VI-NEXT:    s_lshr_b32 s5, s17, 8
; VI-NEXT:    s_lshr_b32 s11, s16, 16
; VI-NEXT:    s_lshr_b32 s9, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB105_4
; VI-NEXT:  .LBB105_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_add_f16_e32 v6, s4, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; VI-NEXT:    v_add_f16_e32 v8, s17, v0
; VI-NEXT:    v_add_f16_e32 v2, s4, v0
; VI-NEXT:    v_or_b32_e32 v10, v8, v1
; VI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v9, v0, v1
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[9:10]
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v10
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v9
; VI-NEXT:    v_bfe_u32 v7, v6, 8, 8
; VI-NEXT:    v_mov_b32_e32 v4, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB105_3:
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    s_branch .LBB105_2
; VI-NEXT:  .LBB105_4:
; VI-NEXT:    v_mov_b32_e32 v2, s11
; VI-NEXT:    v_mov_b32_e32 v6, s10
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v7, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f16_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB105_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s5, s17, 24
; GFX9-NEXT:    s_lshr_b32 s8, s17, 16
; GFX9-NEXT:    s_lshr_b32 s9, s17, 8
; GFX9-NEXT:    s_lshr_b32 s10, s16, 16
; GFX9-NEXT:    s_lshr_b32 s11, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB105_4
; GFX9-NEXT:  .LBB105_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v9, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:    s_branch .LBB105_5
; GFX9-NEXT:  .LBB105_3:
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    s_branch .LBB105_2
; GFX9-NEXT:  .LBB105_4:
; GFX9-NEXT:    v_mov_b32_e32 v8, s16
; GFX9-NEXT:    v_mov_b32_e32 v9, s17
; GFX9-NEXT:    v_mov_b32_e32 v1, s11
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-NEXT:    v_mov_b32_e32 v6, s8
; GFX9-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB105_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f16_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB105_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s3, s1, 24
; GFX11-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-NEXT:    s_lshr_b32 s6, s1, 8
; GFX11-NEXT:    s_lshr_b32 s7, s0, 16
; GFX11-NEXT:    s_lshr_b32 s8, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB105_4
; GFX11-NEXT:  .LBB105_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v9, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v8, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-NEXT:    s_branch .LBB105_5
; GFX11-NEXT:  .LBB105_3:
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    s_branch .LBB105_2
; GFX11-NEXT:  .LBB105_4:
; GFX11-NEXT:    v_dual_mov_b32 v8, s0 :: v_dual_mov_b32 v9, s1
; GFX11-NEXT:    v_dual_mov_b32 v1, s8 :: v_dual_mov_b32 v2, s7
; GFX11-NEXT:    v_dual_mov_b32 v5, s6 :: v_dual_mov_b32 v6, s5
; GFX11-NEXT:    v_mov_b32_e32 v7, s3
; GFX11-NEXT:    v_mov_b32_e32 v3, s2
; GFX11-NEXT:  .LBB105_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <4 x half> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x half> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define <4 x half> @bitcast_v8i8_to_v4f16(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_v4f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v2
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v12, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v8, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 8, v7
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB106_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB106_4
; SI-NEXT:  .LBB106_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB106_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v10
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v6
; SI-NEXT:    v_or_b32_e32 v0, v0, v12
; SI-NEXT:    v_or_b32_e32 v1, v1, v11
; SI-NEXT:    v_or_b32_e32 v2, v2, v8
; SI-NEXT:    v_or_b32_e32 v3, v3, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB106_2
; SI-NEXT:  .LBB106_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v6
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v5, v0
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x300, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v8, v0
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x300, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 0x300, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_or_b32_e32 v0, v12, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_v4f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB106_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB106_4
; VI-NEXT:  .LBB106_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB106_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB106_2
; VI-NEXT:  .LBB106_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB106_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB106_4
; GFX9-NEXT:  .LBB106_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB106_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB106_2
; GFX9-NEXT:  .LBB106_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_v4f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB106_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB106_4
; GFX11-TRUE16-NEXT:  .LBB106_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB106_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB106_2
; GFX11-TRUE16-NEXT:  .LBB106_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_v4f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB106_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB106_4
; GFX11-FAKE16-NEXT:  .LBB106_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB106_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB106_2
; GFX11-FAKE16-NEXT:  .LBB106_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define inreg <4 x half> @bitcast_v8i8_to_v4f16_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_v4f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB107_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s19, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    s_lshl_b32 s5, s23, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_cbranch_execnz .LBB107_3
; SI-NEXT:  .LBB107_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    s_lshl_b32 s5, s23, 8
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_lshl_b32 s7, s19, 8
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s16, 0xff
; SI-NEXT:    s_lshl_b32 s8, s17, 8
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_addk_i32 s7, 0x300
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:  .LBB107_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB107_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_branch .LBB107_2
;
; VI-LABEL: bitcast_v8i8_to_v4f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB107_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB107_3
; VI-NEXT:  .LBB107_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB107_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB107_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB107_2
;
; GFX9-LABEL: bitcast_v8i8_to_v4f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB107_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB107_3
; GFX9-NEXT:  .LBB107_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB107_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB107_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB107_2
;
; GFX11-LABEL: bitcast_v8i8_to_v4f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB107_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB107_3
; GFX11-NEXT:  .LBB107_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB107_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB107_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB107_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x half>
  br label %end

end:
  %phi = phi <4 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x half> %phi
}

define <8 x i8> @bitcast_v4bf16_to_v8i8(<4 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v4bf16_to_v8i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v2
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB108_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB108_4
; SI-NEXT:  .LBB108_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB108_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v11, 16
; SI-NEXT:    v_alignbit_b32 v4, v6, v9, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB108_2
; SI-NEXT:  .LBB108_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_alignbit_b32 v4, v6, v1, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4bf16_to_v8i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v1
; VI-NEXT:    v_mov_b32_e32 v8, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; VI-NEXT:    ; implicit-def: $vgpr1
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; VI-NEXT:  ; %bb.2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB108_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v9
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v9
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v3, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_bfe_u32 v3, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, s6, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v4, vcc, s6, v4
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v1, v6, v2, 16
; VI-NEXT:    v_alignbit_b32 v0, v0, v3, 16
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v0
; VI-NEXT:  .LBB108_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v0, v8
; VI-NEXT:    v_mov_b32_e32 v4, v9
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v8i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX9-NEXT:  ; %bb.2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB108_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_add3_u32 v1, v1, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v8
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v2, v2, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v10, v1, v0, s7
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v9
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v2, v2, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_perm_b32 v11, v1, v2, s7
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX9-NEXT:  .LBB108_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v4, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4bf16_to_v8i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v2
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB108_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[10:11], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.h, v9.h
; GFX11-TRUE16-NEXT:  .LBB108_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB108_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v8.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v9
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 0x40c00000, v0 :: v_dual_lshlrev_b32 v0, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, 0x400000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_add_f32 v1, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_bfe_u32 v3, v5, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v4, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v3, v3, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v7, v10, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v9, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v3, v6, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v12, v8, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v8, 0xffff, v3, v2
; GFX11-TRUE16-NEXT:    v_bfi_b32 v9, 0xffff, v1, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[10:11], 24, v[8:9]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-TRUE16-NEXT:  .LBB108_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v8.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4bf16_to_v8i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v9, v1 :: v_dual_mov_b32 v8, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[8:9]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v8
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB108_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 0x40c00000, v1 :: v_dual_lshlrev_b32 v0, 16, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v0, 0x40c00000, v0 :: v_dual_lshlrev_b32 v3, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v6, v6, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    v_add3_u32 v4, v4, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v6, v7 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v9, v9, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v8, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v1, v0, 0x7060302
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v9, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v2, v3, 0x7060302
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-FAKE16-NEXT:  .LBB108_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v8
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v9
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define inreg <8 x i8> @bitcast_v4bf16_to_v8i8_scalar(<4 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4bf16_to_v8i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s20, 0
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v8, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v9, 1.0, s18
; SI-NEXT:    s_cbranch_scc0 .LBB109_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v11, 16
; SI-NEXT:    v_alignbit_b32 v4, v6, v9, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_cbranch_execnz .LBB109_3
; SI-NEXT:  .LBB109_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v7
; SI-NEXT:    v_alignbit_b32 v4, v6, v1, 16
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v7
; SI-NEXT:  .LBB109_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB109_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    s_branch .LBB109_2
;
; VI-LABEL: bitcast_v4bf16_to_v8i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s18, 0
; VI-NEXT:    s_cbranch_scc0 .LBB109_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s8, s17, 24
; VI-NEXT:    s_lshr_b32 s5, s17, 16
; VI-NEXT:    s_lshr_b32 s9, s17, 8
; VI-NEXT:    s_lshr_b32 s10, s16, 16
; VI-NEXT:    s_lshr_b32 s11, s16, 8
; VI-NEXT:    s_cbranch_execnz .LBB109_4
; VI-NEXT:  .LBB109_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v4, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v1
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v2, v6, v3, 16
; VI-NEXT:    v_alignbit_b32 v1, v0, v4, 16
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v4
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[1:2]
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; VI-NEXT:    v_mov_b32_e32 v4, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB109_3:
; VI-NEXT:    ; implicit-def: $sgpr11
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr9
; VI-NEXT:    ; implicit-def: $sgpr5
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    s_branch .LBB109_2
; VI-NEXT:  .LBB109_4:
; VI-NEXT:    v_mov_b32_e32 v1, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v5, s9
; VI-NEXT:    v_mov_b32_e32 v7, s8
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v6, s5
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4bf16_to_v8i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB109_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s9, s17, 24
; GFX9-NEXT:    s_lshr_b32 s11, s17, 16
; GFX9-NEXT:    s_lshr_b32 s10, s17, 8
; GFX9-NEXT:    s_lshr_b32 s8, s16, 16
; GFX9-NEXT:    s_lshr_b32 s5, s16, 8
; GFX9-NEXT:    s_cbranch_execnz .LBB109_4
; GFX9-NEXT:  .LBB109_2: ; %cmp.true
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v0
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff, v0
; GFX9-NEXT:    s_pack_lh_b32_b16 s4, 0, s17
; GFX9-NEXT:    v_lshl_or_b32 v9, v2, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v1
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; GFX9-NEXT:    v_lshl_or_b32 v10, v6, 16, v1
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[9:10]
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v10
; GFX9-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB109_3:
; GFX9-NEXT:    ; implicit-def: $sgpr5
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr11
; GFX9-NEXT:    ; implicit-def: $sgpr9
; GFX9-NEXT:    s_branch .LBB109_2
; GFX9-NEXT:  .LBB109_4:
; GFX9-NEXT:    v_mov_b32_e32 v6, s11
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v7, s9
; GFX9-NEXT:    v_mov_b32_e32 v5, s10
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4bf16_to_v8i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB109_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s6, s1, 24
; GFX11-NEXT:    s_lshr_b32 s8, s1, 16
; GFX11-NEXT:    s_lshr_b32 s7, s1, 8
; GFX11-NEXT:    s_lshr_b32 s5, s0, 16
; GFX11-NEXT:    s_lshr_b32 s3, s0, 8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB109_4
; GFX11-NEXT:  .LBB109_2: ; %cmp.true
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0, s0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 16
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s2
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s0
; GFX11-NEXT:    s_lshl_b32 s0, s1, 16
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, 0, s1
; GFX11-NEXT:    v_add_f32_e64 v2, 0x40c00000, s0
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v8, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v6, v6, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x7fff, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v6, v10 :: v_dual_add_nc_u32 v3, v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v4, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; GFX11-NEXT:    v_lshl_or_b32 v9, v2, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v10, v6, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[9:10]
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v10
; GFX11-NEXT:    v_mov_b32_e32 v4, v8
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB109_3:
; GFX11-NEXT:    ; implicit-def: $sgpr3
; GFX11-NEXT:    ; implicit-def: $sgpr5
; GFX11-NEXT:    ; implicit-def: $sgpr2
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB109_2
; GFX11-NEXT:  .LBB109_4:
; GFX11-NEXT:    v_dual_mov_b32 v6, s8 :: v_dual_mov_b32 v7, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v5, s7
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v4, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <4 x bfloat> %a1 to <8 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x bfloat> %a to <8 x i8>
  br label %end

end:
  %phi = phi <8 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i8> %phi
}

define <4 x bfloat> @bitcast_v8i8_to_v4bf16(<8 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v8i8_to_v4bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v10, v1
; SI-NEXT:    v_mov_b32_e32 v9, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    v_lshlrev_b32_e32 v8, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v5, 24, v7
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB110_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 24, v10
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v4
; SI-NEXT:    v_or_b32_e32 v2, v2, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v3, v5, v2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:  .LBB110_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB110_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v4
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v6
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v5, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v9
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 8, v10
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v8, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x3000000, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; SI-NEXT:  .LBB110_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v2, v7
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i8_to_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v9, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB110_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB110_4
; VI-NEXT:  .LBB110_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB110_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr4
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB110_2
; VI-NEXT:  .LBB110_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v9
; VI-NEXT:    v_add_u16_e32 v1, 3, v2
; VI-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v2, 0x300
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v6
; VI-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v1
; VI-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i8_to_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_lshlrev_b16_e32 v10, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v8, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v5, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v3, 8, v7
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB110_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB110_4
; GFX9-NEXT:  .LBB110_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB110_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr4
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB110_2
; GFX9-NEXT:  .LBB110_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v9
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v2
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v8, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v4
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v6
; GFX9-NEXT:    v_or_b32_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i8_to_v4bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.h, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v2.h, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.l, 8, v5.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v3.h, 8, v7.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB110_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB110_4
; GFX11-TRUE16-NEXT:  .LBB110_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB110_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v0.h, v2.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v1.h, v3.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr2_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr4_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr6_lo16
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_hi16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB110_2
; GFX11-TRUE16-NEXT:  .LBB110_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v5.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v4.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v4.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v6.l, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v2.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v3.l, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v3.h, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i8_to_v4bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v9, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v3, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB110_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB110_4
; GFX11-FAKE16-NEXT:  .LBB110_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB110_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr4
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB110_2
; GFX11-FAKE16-NEXT:  .LBB110_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v9, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v2, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v4, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v8, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v7, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}

define inreg <4 x bfloat> @bitcast_v8i8_to_v4bf16_scalar(<8 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i8_to_v4bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB111_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s17, 24
; SI-NEXT:    s_or_b32 s6, s5, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_or_b32 s7, s5, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_lshl_b32 s8, s4, 16
; SI-NEXT:    s_and_b32 s4, s22, 0xff
; SI-NEXT:    s_lshl_b32 s4, s4, 16
; SI-NEXT:    s_lshl_b32 s5, s23, 24
; SI-NEXT:    s_or_b32 s9, s5, s4
; SI-NEXT:    s_cbranch_execnz .LBB111_3
; SI-NEXT:  .LBB111_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_and_b32 s4, s20, 0xff
; SI-NEXT:    s_lshl_b32 s5, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s23, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s16, 0xff
; SI-NEXT:    s_lshl_b32 s6, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s18, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_and_b32 s7, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s5, 16
; SI-NEXT:    s_and_b32 s9, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s8, s4, 16
; SI-NEXT:  .LBB111_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB111_4:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    s_branch .LBB111_2
;
; VI-LABEL: bitcast_v8i8_to_v4bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB111_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_cbranch_execnz .LBB111_3
; VI-NEXT:  .LBB111_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:  .LBB111_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB111_4:
; VI-NEXT:    ; implicit-def: $sgpr4_sgpr5
; VI-NEXT:    s_branch .LBB111_2
;
; GFX9-LABEL: bitcast_v8i8_to_v4bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB111_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB111_3
; GFX9-NEXT:  .LBB111_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s5, s6, s5
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:  .LBB111_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB111_4:
; GFX9-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-NEXT:    s_branch .LBB111_2
;
; GFX11-LABEL: bitcast_v8i8_to_v4bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s6, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB111_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s4, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_b32 s7, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s17, 8
; GFX11-NEXT:    s_and_b32 s9, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s19, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    s_or_b32 s8, s9, s10
; GFX11-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_or_b32 s4, s4, s5
; GFX11-NEXT:    s_or_b32 s5, s7, s8
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s6
; GFX11-NEXT:    s_cbranch_vccnz .LBB111_3
; GFX11-NEXT:  .LBB111_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_and_b32 s1, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s3, 8
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s17, 8
; GFX11-NEXT:    s_and_b32 s4, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s19, 8
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_or_b32 s3, s5, s4
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_or_b32 s4, s0, s1
; GFX11-NEXT:    s_or_b32 s5, s2, s3
; GFX11-NEXT:  .LBB111_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB111_4:
; GFX11-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX11-NEXT:    s_branch .LBB111_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i8> %a, splat (i8 3)
  %a2 = bitcast <8 x i8> %a1 to <4 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i8> %a to <4 x bfloat>
  br label %end

end:
  %phi = phi <4 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x bfloat> %phi
}
