; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; ADR
; Tests adr z0.s, [z0.s, z0.s, lsl #<1,2,3>]
; Other formats are tested in llvm/test/CodeGen/AArch64/sve-gep.ll
;

define <vscale x 4 x i32>  @adr_32bit_lsl1(<vscale x 4 x i32>  %base, <vscale x 4 x i32> %idx) #0 {
; CHECK-LABEL: adr_32bit_lsl1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adr z0.s, [z0.s, z1.s, lsl #1]
; CHECK-NEXT:    ret
  %offset = shl <vscale x 4 x i32> %idx, splat (i32 1)
  %address = add <vscale x 4 x i32> %base, %offset
  ret <vscale x 4 x i32>  %address
}

define <vscale x 4 x i32>  @adr_32bit_lsl2(<vscale x 4 x i32>  %base, <vscale x 4 x i32> %idx) #0 {
; CHECK-LABEL: adr_32bit_lsl2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adr z0.s, [z0.s, z1.s, lsl #2]
; CHECK-NEXT:    ret
  %offset = shl <vscale x 4 x i32> %idx, splat (i32 2)
  %address = add <vscale x 4 x i32> %base, %offset
  ret <vscale x 4 x i32>  %address
}

define <vscale x 4 x i32>  @adr_32bit_lsl3(<vscale x 4 x i32>  %base, <vscale x 4 x i32> %idx) #0 {
; CHECK-LABEL: adr_32bit_lsl3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adr z0.s, [z0.s, z1.s, lsl #3]
; CHECK-NEXT:    ret
  %offset = shl <vscale x 4 x i32> %idx, splat (i32 3)
  %address = add <vscale x 4 x i32> %base, %offset
  ret <vscale x 4 x i32>  %address
}

attributes #0 = { "target-features"="+sve" }
