; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "^[ \t]*//.*$" --version 4
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme2,+sme-f8f16,+sme-f8f32 -verify-machineinstrs -force-streaming < %s | FileCheck %s

target triple = "aarch64-linux"

define void @test_fdot16_1x2_indexed(i32 %slice.0, <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zm) #0 {
; CHECK-LABEL: test_fdot16_1x2_indexed:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx2], { z0.b, z1.b }, z2.b[1]
; CHECK:    ret
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.lane.za16.vg1x2(i32 %slice,
                                                       <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                       <vscale x 16 x i8> %zm, i32 1)
  ret void
}

define void @test_fdot16_1x4_indexed(i32 %slice.0, <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
; CHECK-LABEL: test_fdot16_1x4_indexed:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx4], { z0.b - z3.b }, z4.b[1]
; CHECK:    ret
                                     <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.lane.za16.vg1x4(i32 %slice,
                                                       <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                       <vscale x 16 x i8> %zm, i32 1)
  ret void
}

define void @test_fdot32_1x2_indexed(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x2_indexed:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx2], { z0.b, z1.b }, z2.b[1]
; CHECK:    ret
                                     <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                     <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.lane.za32.vg1x2(i32 %slice,
                                                       <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                       <vscale x 16 x i8> %zm, i32 1)
  ret void
}

define void @test_fdot32_1x4_indexed(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x4_indexed:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx4], { z0.b - z3.b }, z4.b[1]
; CHECK:    ret
                                     <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                     <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.lane.za32.vg1x4(i32 %slice,
                                                       <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                       <vscale x 16 x i8> %zm, i32 1)
  ret void
}

define void @test_fdot32_1x2_single(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x2_single:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx2], { z0.b, z1.b }, z2.b
; CHECK:    ret
                                    <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                    <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.single.za32.vg1x2(i32 %slice,
                                                         <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                         <vscale x 16 x i8> %zm)
  ret void
}

define void @test_fdot32_1x4_single(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x4_single:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx4], { z0.b - z3.b }, z4.b
; CHECK:    ret
                                    <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                    <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.single.za32.vg1x4(i32 %slice,
                                                         <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                         <vscale x 16 x i8> %zm)
  ret void
}

define void @test_fdot32_1x2_multi(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x2_multi:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx2], { z0.b, z1.b }, { z2.b, z3.b }
; CHECK:    ret
                                   <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                   <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.multi.za32.vg1x2(i32 %slice,
                                                        <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                        <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2)
  ret void
}

define void @test_fdot32_1x4_multi(i32 %slice.0,
; CHECK-LABEL: test_fdot32_1x4_multi:
; CHECK:    mov w8, w0
; CHECK:    fdot za.s[w8, 7, vgx4], { z0.b - z3.b }, { z4.b - z7.b }
; CHECK:    ret
                                   <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,  <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                   <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2,  <vscale x 16 x i8> %zm3, <vscale x 16 x i8> %zm4) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.multi.za32.vg1x4(i32 %slice,
                                                        <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                        <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2, <vscale x 16 x i8> %zm3, <vscale x 16 x i8> %zm4)
  ret void
}

define void @test_fdot16_1x2_single(i32 %slice.0,
; CHECK-LABEL: test_fdot16_1x2_single:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx2], { z0.b, z1.b }, z2.b
; CHECK:    ret
                                    <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                    <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.single.za16.vg1x2(i32 %slice,
                                                         <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                         <vscale x 16 x i8> %zm)
  ret void
}

define void @test_fdot16_1x4_single(i32 %slice.0,
; CHECK-LABEL: test_fdot16_1x4_single:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx4], { z0.b - z3.b }, z4.b
; CHECK:    ret
                                    <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                    <vscale x 16 x i8> %zm) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.single.za16.vg1x4(i32 %slice,
                                                         <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                         <vscale x 16 x i8> %zm)
  ret void
}

define void @test_fdot16_1x2_multi(i32 %slice.0,
; CHECK-LABEL: test_fdot16_1x2_multi:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx2], { z0.b, z1.b }, { z2.b, z3.b }
; CHECK:    ret
                                   <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                   <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.multi.za16.vg1x2(i32 %slice,
                                                        <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,
                                                        <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2)
  ret void
}

define void @test_fdot16_1x4_multi(i32 %slice.0,
; CHECK-LABEL: test_fdot16_1x4_multi:
; CHECK:    mov w8, w0
; CHECK:    fdot za.h[w8, 7, vgx4], { z0.b - z3.b }, { z4.b - z7.b }
; CHECK:    ret
                                   <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2,  <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                   <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2,  <vscale x 16 x i8> %zm3, <vscale x 16 x i8> %zm4) #0 {
  %slice = add i32 %slice.0, 7
  call void @llvm.aarch64.sme.fp8.fdot.multi.za16.vg1x4(i32 %slice,
                                                        <vscale x 16 x i8> %zn1, <vscale x 16 x i8> %zn2, <vscale x 16 x i8> %zn3, <vscale x 16 x i8> %zn4,
                                                        <vscale x 16 x i8> %zm1, <vscale x 16 x i8> %zm2, <vscale x 16 x i8> %zm3, <vscale x 16 x i8> %zm4)
  ret void
}

attributes #0 = { "target-features" = "+sme,+sme-f8f32,+sme-f8f16" }
