; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s
; RUN: llc < %s -mtriple=aarch64 --global-isel | FileCheck %s --check-prefix=GISEL

define i35 @f(i35 %0) {
; CHECK-LABEL: f:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx x8, x0, #0, #35
; CHECK-NEXT:    mov w9, #1 // =0x1
; CHECK-NEXT:    sdiv x10, x9, x8
; CHECK-NEXT:    msub x8, x10, x8, x9
; CHECK-NEXT:    clz x8, x8
; CHECK-NEXT:    sub x8, x8, #29
; CHECK-NEXT:    ubfx x0, x8, #5, #30
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f:
; GISEL:       // %bb.0:
; GISEL-NEXT:    sbfx x8, x0, #0, #35
; GISEL-NEXT:    mov w9, #1 // =0x1
; GISEL-NEXT:    sdiv x10, x9, x8
; GISEL-NEXT:    msub x8, x10, x8, x9
; GISEL-NEXT:    and x8, x8, #0x7ffffffff
; GISEL-NEXT:    clz x8, x8
; GISEL-NEXT:    sub x8, x8, #29
; GISEL-NEXT:    ubfx x0, x8, #5, #30
; GISEL-NEXT:    ret
  %2 = srem i35 1, %0
  %3 = call i35 @llvm.ctlz.i35(i35 %2, i1 false)
  %4 = lshr i35 %3, 5
  ret i35 %4
}

declare i35 @llvm.ctlz.i35(i35, i1 immarg)
