; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64 -mattr=-fullfp16 | FileCheck %s --check-prefixes=CHECK-COMMON,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK-COMMON,CHECK-FP16

define <4 x half> @add_h(<4 x half> %a, <4 x half> %b) {
; CHECK-CVT-LABEL: add_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fadd v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: add_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fadd v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret
entry:

  %0 = fadd <4 x half> %a, %b
  ret <4 x half> %0
}

define <4 x half> @build_h4(<4 x half> %a) {
; CHECK-COMMON-LABEL: build_h4:
; CHECK-COMMON:       // %bb.0: // %entry
; CHECK-COMMON-NEXT:    mov w8, #15565 // =0x3ccd
; CHECK-COMMON-NEXT:    dup v0.4h, w8
; CHECK-COMMON-NEXT:    ret
entry:
  ret <4 x half> <half 0xH3CCD, half 0xH3CCD, half 0xH3CCD, half 0xH3CCD>
}

define <4 x half> @sub_h(<4 x half> %a, <4 x half> %b) {
; CHECK-CVT-LABEL: sub_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fsub v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sub_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fsub v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret
entry:

  %0 = fsub <4 x half> %a, %b
  ret <4 x half> %0
}

define <4 x half> @mul_h(<4 x half> %a, <4 x half> %b) {
; CHECK-CVT-LABEL: mul_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fmul v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: mul_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fmul v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret
entry:

  %0 = fmul <4 x half> %a, %b
  ret <4 x half> %0
}

define <4 x half> @div_h(<4 x half> %a, <4 x half> %b) {
; CHECK-CVT-LABEL: div_h:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fdiv v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: div_h:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fdiv v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret
entry:

  %0 = fdiv <4 x half> %a, %b
  ret <4 x half> %0
}

define <4 x half> @load_h(ptr %a) {
; CHECK-COMMON-LABEL: load_h:
; CHECK-COMMON:       // %bb.0: // %entry
; CHECK-COMMON-NEXT:    ldr d0, [x0]
; CHECK-COMMON-NEXT:    ret
entry:
  %0 = load <4 x half>, ptr %a, align 4
  ret <4 x half> %0
}

define void @store_h(ptr %a, <4 x half> %b) {
; CHECK-COMMON-LABEL: store_h:
; CHECK-COMMON:       // %bb.0: // %entry
; CHECK-COMMON-NEXT:    str d0, [x0]
; CHECK-COMMON-NEXT:    ret
entry:
  store <4 x half> %b, ptr %a, align 4
  ret void
}

define <4 x half> @s_to_h(<4 x float> %a) {
; CHECK-COMMON-LABEL: s_to_h:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = fptrunc <4 x float> %a to <4 x half>
  ret <4 x half> %1
}

define <4 x half> @d_to_h(<4 x double> %a) {
; CHECK-COMMON-LABEL: d_to_h:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fcvtxn v0.2s, v0.2d
; CHECK-COMMON-NEXT:    fcvtxn2 v0.4s, v1.2d
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = fptrunc <4 x double> %a to <4 x half>
  ret <4 x half> %1
}

define <4 x float> @h_to_s(<4 x half> %a) {
; CHECK-COMMON-LABEL: h_to_s:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-COMMON-NEXT:    ret
  %1 = fpext <4 x half> %a to <4 x float>
  ret <4 x float> %1
}

define <4 x double> @h_to_d(<4 x half> %a) {
; CHECK-COMMON-LABEL: h_to_d:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-COMMON-NEXT:    fcvtl2 v1.2d, v0.4s
; CHECK-COMMON-NEXT:    fcvtl v0.2d, v0.2s
; CHECK-COMMON-NEXT:    ret
  %1 = fpext <4 x half> %a to <4 x double>
  ret <4 x double> %1
}

define <4 x half> @bitcast_i_to_h(float, <4 x i16> %a) {
; CHECK-COMMON-LABEL: bitcast_i_to_h:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fmov d0, d1
; CHECK-COMMON-NEXT:    ret
  %2 = bitcast <4 x i16> %a to <4 x half>
  ret <4 x half> %2
}

define <4 x i16> @bitcast_h_to_i(float, <4 x half> %a) {
; CHECK-COMMON-LABEL: bitcast_h_to_i:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    fmov d0, d1
; CHECK-COMMON-NEXT:    ret
  %2 = bitcast <4 x half> %a to <4 x i16>
  ret <4 x i16> %2
}

define <4 x half> @sitofp_i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %1
}

define <4 x half> @sitofp_i16(<4 x i16> %a) #0 {
; CHECK-CVT-LABEL: sitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    scvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = sitofp <4 x i16> %a to <4 x half>
  ret <4 x half> %1
}


define <4 x half> @sitofp_i32(<4 x i32> %a) #0 {
; CHECK-COMMON-LABEL: sitofp_i32:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    scvtf v0.4s, v0.4s
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = sitofp <4 x i32> %a to <4 x half>
  ret <4 x half> %1
}


define <4 x half> @sitofp_i64(<4 x i64> %a) #0 {
; CHECK-COMMON-LABEL: sitofp_i64:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    scvtf v0.2d, v0.2d
; CHECK-COMMON-NEXT:    scvtf v1.2d, v1.2d
; CHECK-COMMON-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-COMMON-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = sitofp <4 x i64> %a to <4 x half>
  ret <4 x half> %1
}

define <4 x half> @uitofp_i8(<4 x i8> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %1
}


define <4 x half> @uitofp_i16(<4 x i16> %a) #0 {
; CHECK-CVT-LABEL: uitofp_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-CVT-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-CVT-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = uitofp <4 x i16> %a to <4 x half>
  ret <4 x half> %1
}


define <4 x half> @uitofp_i32(<4 x i32> %a) #0 {
; CHECK-COMMON-LABEL: uitofp_i32:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = uitofp <4 x i32> %a to <4 x half>
  ret <4 x half> %1
}


define <4 x half> @uitofp_i64(<4 x i64> %a) #0 {
; CHECK-COMMON-LABEL: uitofp_i64:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-COMMON-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-COMMON-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-COMMON-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-COMMON-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-COMMON-NEXT:    ret
  %1 = uitofp <4 x i64> %a to <4 x half>
  ret <4 x half> %1
}

define void @test_insert_at_zero(half %a, ptr %b) #0 {
; CHECK-COMMON-LABEL: test_insert_at_zero:
; CHECK-COMMON:       // %bb.0:
; CHECK-COMMON-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-COMMON-NEXT:    str d0, [x0]
; CHECK-COMMON-NEXT:    ret
  %1 = insertelement <4 x half> undef, half %a, i64 0
  store <4 x half> %1, ptr %b, align 4
  ret void
}

define <4 x i8> @fptosi_i8(<4 x half> %a) #0 {
; CHECK-CVT-LABEL: fptosi_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = fptosi<4 x half> %a to <4 x i8>
  ret <4 x i8> %1
}

define <4 x i16> @fptosi_i16(<4 x half> %a) #0 {
; CHECK-CVT-LABEL: fptosi_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = fptosi<4 x half> %a to <4 x i16>
  ret <4 x i16> %1
}

define <4 x i8> @fptoui_i8(<4 x half> %a) #0 {
; CHECK-CVT-LABEL: fptoui_i8:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzs v0.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i8:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
; NOTE: fcvtzs selected here because the xtn shaves the sign bit
  %1 = fptoui<4 x half> %a to <4 x i8>
  ret <4 x i8> %1
}

define <4 x i16> @fptoui_i16(<4 x half> %a) #0 {
; CHECK-CVT-LABEL: fptoui_i16:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtzu v0.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu v0.4h, v0.4h
; CHECK-FP16-NEXT:    ret
  %1 = fptoui<4 x half> %a to <4 x i16>
  ret <4 x i16> %1
}

define <4 x i1> @test_fcmp_une(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_une:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    mvn v0.16b, v0.16b
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_une:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmeq v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp une <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ueq(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ueq:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ueq:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v2.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ueq <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ugt(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ugt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ugt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ugt <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_uge(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_uge:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_uge:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp uge <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ult(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ult:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ult:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ult <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ule(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ule:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ule:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ule <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_uno(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_uno:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    mvn v0.8b, v0.8b
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_uno:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v2.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-FP16-NEXT:    mvn v0.8b, v0.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp uno <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_one(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_one:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_one:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v2.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp one <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_oeq(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_oeq:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_oeq:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmeq v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret

  %1 = fcmp oeq <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ogt(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ogt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ogt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ogt <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_oge(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_oge:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_oge:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    ret

  %1 = fcmp oge <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_olt(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_olt:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_olt:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    ret

  %1 = fcmp olt <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ole(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ole:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ole:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ole <4 x half> %a, %b
  ret <4 x i1> %1
}

define <4 x i1> @test_fcmp_ord(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-CVT-LABEL: test_fcmp_ord:
; CHECK-CVT:       // %bb.0:
; CHECK-CVT-NEXT:    fcvtl v1.4s, v1.4h
; CHECK-CVT-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-CVT-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-CVT-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-CVT-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-CVT-NEXT:    xtn v0.4h, v0.4s
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: test_fcmp_ord:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmge v2.4h, v0.4h, v1.4h
; CHECK-FP16-NEXT:    fcmgt v0.4h, v1.4h, v0.4h
; CHECK-FP16-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-FP16-NEXT:    ret

  %1 = fcmp ord <4 x half> %a, %b
  ret <4 x i1> %1
}

attributes #0 = { nounwind }
