; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=arm64-eabi -aarch64-neon-syntax=apple | FileCheck %s
; RUN: llc < %s -mtriple=arm64-eabi -aarch64-neon-syntax=apple -global-isel | FileCheck %s

define <8 x i8> @vuzpi8(<8 x i8> %A, <8 x i8> %B) nounwind {
; CHECK-LABEL: vuzpi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8b v2, v0, v1
; CHECK-NEXT:    uzp2.8b v0, v0, v1
; CHECK-NEXT:    add.8b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i8> %A, <8 x i8> %B, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i8> %A, <8 x i8> %B, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = add <8 x i8> %tmp3, %tmp4
  ret <8 x i8> %tmp5
}

define <4 x i16> @vuzpi16(<4 x i16> %A, <4 x i16> %B) nounwind {
; CHECK-LABEL: vuzpi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.4h v2, v0, v1
; CHECK-NEXT:    uzp2.4h v0, v0, v1
; CHECK-NEXT:    add.4h v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <4 x i16> %A, <4 x i16> %B, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <4 x i16> %A, <4 x i16> %B, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %tmp5 = add <4 x i16> %tmp3, %tmp4
  ret <4 x i16> %tmp5
}

define <16 x i8> @vuzpQi8(<16 x i8> %A, <16 x i8> %B) nounwind {
; CHECK-LABEL: vuzpQi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.16b v2, v0, v1
; CHECK-NEXT:    uzp2.16b v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <16 x i8> %A, <16 x i8> %B, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %tmp4 = shufflevector <16 x i8> %A, <16 x i8> %B, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %tmp5 = xor <16 x i8> %tmp3, %tmp4
  ret <16 x i8> %tmp5
}

define <8 x i16> @vuzpQi16(<8 x i16> %A, <8 x i16> %B) nounwind {
; CHECK-LABEL: vuzpQi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8h v2, v0, v1
; CHECK-NEXT:    uzp2.8h v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = xor <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <4 x i32> @vuzpQi32(<4 x i32> %A, <4 x i32> %B) nounwind {
; CHECK-LABEL: vuzpQi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.4s v2, v0, v1
; CHECK-NEXT:    uzp2.4s v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <4 x i32> %A, <4 x i32> %B, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %tmp5 = xor <4 x i32> %tmp3, %tmp4
  ret <4 x i32> %tmp5
}

define <4 x float> @vuzpQf(<4 x float> %A, <4 x float> %B) nounwind {
; CHECK-LABEL: vuzpQf:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.4s v2, v0, v1
; CHECK-NEXT:    uzp2.4s v0, v0, v1
; CHECK-NEXT:    fsub.4s v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <4 x float> %A, <4 x float> %B, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <4 x float> %A, <4 x float> %B, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %tmp5 = fsub <4 x float> %tmp3, %tmp4
  ret <4 x float> %tmp5
}

; Undef shuffle indices should not prevent matching to VUZP:

define <8 x i8> @vuzpi8_undef(<8 x i8> %A, <8 x i8> %B) nounwind {
; CHECK-LABEL: vuzpi8_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8b v2, v0, v1
; CHECK-NEXT:    uzp2.8b v0, v0, v1
; CHECK-NEXT:    add.8b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i8> %A, <8 x i8> %B, <8 x i32> <i32 0, i32 2, i32 undef, i32 undef, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i8> %A, <8 x i8> %B, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 undef, i32 undef, i32 13, i32 15>
  %tmp5 = add <8 x i8> %tmp3, %tmp4
  ret <8 x i8> %tmp5
}

define <8 x i16> @vuzpQi16_undef1(<8 x i16> %A, <8 x i16> %B) nounwind {
; CHECK-LABEL: vuzpQi16_undef1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8h v2, v0, v1
; CHECK-NEXT:    uzp2.8h v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 0, i32 undef, i32 4, i32 undef, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 1, i32 3, i32 5, i32 undef, i32 undef, i32 11, i32 13, i32 15>
  %tmp5 = xor <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <8 x i16> @vuzpQi16_undef0(<8 x i16> %A, <8 x i16> %B) nounwind {
; CHECK-LABEL: vuzpQi16_undef0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8h v2, v0, v1
; CHECK-NEXT:    uzp2.8h v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = xor <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <8 x i16> @vuzpQi16_undef01(<8 x i16> %A, <8 x i16> %B) nounwind {
; CHECK-LABEL: vuzpQi16_undef01:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8h v2, v0, v1
; CHECK-NEXT:    uzp2.8h v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 undef, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 undef, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = xor <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}

define <8 x i16> @vuzpQi16_undef012(<8 x i16> %A, <8 x i16> %B) nounwind {
; CHECK-LABEL: vuzpQi16_undef012:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1.8h v2, v0, v1
; CHECK-NEXT:    uzp2.8h v0, v0, v1
; CHECK-NEXT:    eor.16b v0, v2, v0
; CHECK-NEXT:    ret
  %tmp3 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %A, <8 x i16> %B, <8 x i32> <i32 undef, i32 undef, i32 undef, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = xor <8 x i16> %tmp3, %tmp4
  ret <8 x i16> %tmp5
}
