; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='sroa<preserve-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-PRESERVE-CFG
; RUN: opt < %s -passes='sroa<modify-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-MODIFY-CFG

declare void @llvm.assume(i1)
declare void @llvm.lifetime.start.p0(i64 %size, ptr nocapture %ptr)
declare void @llvm.lifetime.end.p0(i64 %size, ptr nocapture %ptr)

define void @positive_assume_uses(ptr %arg) {
; CHECK-LABEL: @positive_assume_uses(
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "nonnull"(ptr [[ARG:%.*]]), "ignore"(ptr undef, i64 2) ]
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef, i64 8), "nonnull"(ptr [[ARG]]) ]
; CHECK-NEXT:    ret void
;
  %A = alloca i32
  call void @llvm.assume(i1 true) ["nonnull"(ptr %arg), "align"(ptr %A, i64 2)]
  store i32 1, ptr %A
  call void @llvm.assume(i1 true) ["align"(ptr %A, i64 8), "nonnull"(ptr %arg)]
  ret void
}

define void @negative_assume_condition_use() {
; CHECK-LABEL: @negative_assume_condition_use(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[CND:%.*]] = icmp eq ptr [[A]], null
; CHECK-NEXT:    call void @llvm.assume(i1 [[CND]])
; CHECK-NEXT:    store i32 1, ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
  %A = alloca i32
  %cnd = icmp eq ptr %A, null
  call void @llvm.assume(i1 %cnd)
  store i32 1, ptr %A
  ret void
}

define void @positive_multiple_assume_uses() {
; CHECK-LABEL: @positive_multiple_assume_uses(
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef, i64 8), "ignore"(ptr undef, i64 16) ]
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef), "ignore"(ptr undef, i64 2) ]
; CHECK-NEXT:    ret void
;
  %A = alloca {i8, i16}
  call void @llvm.assume(i1 true) ["align"(ptr %A, i64 8), "align"(ptr %A, i64 16)]
  store {i8, i16} zeroinitializer, ptr %A
  call void @llvm.assume(i1 true) ["nonnull"(ptr %A), "align"(ptr %A, i64 2)]
  ret void
}

define void @positive_gep_assume_uses() {
; CHECK-LABEL: @positive_gep_assume_uses(
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef, i64 8), "ignore"(ptr undef, i64 16) ]
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef), "ignore"(ptr undef, i64 2) ]
; CHECK-NEXT:    ret void
;
  %A = alloca {i8, i16}
  %B = getelementptr {i8, i16}, ptr %A, i32 0, i32 0
  call void @llvm.lifetime.start.p0(i64 2, ptr %B)
  call void @llvm.assume(i1 true) ["align"(ptr %B, i64 8), "align"(ptr %B, i64 16)]
  store {i8, i16} zeroinitializer, ptr %A
  call void @llvm.lifetime.end.p0(i64 2, ptr %B)
  call void @llvm.assume(i1 true) ["nonnull"(ptr %B), "align"(ptr %B, i64 2)]
  ret void
}

define void @positive_mixed_assume_uses() {
; CHECK-LABEL: @positive_mixed_assume_uses(
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef), "ignore"(ptr undef, i64 8), "ignore"(ptr undef, i64 16) ]
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef), "ignore"(ptr undef, i64 2), "ignore"(ptr undef) ]
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "ignore"(ptr undef), "ignore"(ptr undef, i64 2), "ignore"(ptr undef) ]
; CHECK-NEXT:    ret void
;
  %A = alloca i8
  call void @llvm.lifetime.start.p0(i64 2, ptr %A)
  call void @llvm.assume(i1 true) ["nonnull"(ptr %A), "align"(ptr %A, i64 8), "align"(ptr %A, i64 16)]
  store i8 1, ptr %A
  call void @llvm.lifetime.end.p0(i64 2, ptr %A)
  call void @llvm.assume(i1 true) ["nonnull"(ptr %A), "align"(ptr %A, i64 2), "nonnull"(ptr %A)]
  call void @llvm.assume(i1 true) ["nonnull"(ptr %A), "align"(ptr %A, i64 2), "nonnull"(ptr %A)]
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-MODIFY-CFG: {{.*}}
; CHECK-PRESERVE-CFG: {{.*}}
