; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -passes=jump-threading < %s | FileCheck %s

; Test for assert that fired after
; ddb3f12c428bc4bd5a98913d74dfd7f2402bdfd8. simplifyFCmpInst is called
; with a literal negative nan without a context instruction.


; simplifyFCmpInst gets called without a context instruction and
; expects to simplify an ordered compare with a negative nan.
define i1 @simplify_fcmp_negative_nan_oeq(i1 %cond, float %arg) {
; CHECK-LABEL: define i1 @simplify_fcmp_negative_nan_oeq(
; CHECK-SAME: i1 [[COND:%.*]], float [[ARG:%.*]]) {
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB5:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[I3:%.*]] = fcmp oeq float 0.000000e+00, [[ARG]]
; CHECK-NEXT:    br i1 [[I3]], label [[BB5]], label [[BB5]]
; CHECK:       bb5:
; CHECK-NEXT:    [[I33:%.*]] = phi i1 [ [[I3]], [[BB2]] ], [ [[I3]], [[BB2]] ], [ false, [[BB:%.*]] ]
; CHECK-NEXT:    ret i1 [[I33]]
;
bb:
  br i1 %cond, label %bb1, label %bb2

bb1:
  br label %bb2

bb2:                                              ; preds = %bb1, %bb
  %i = phi float [ 0xFFFFFFFFE0000000, %bb ], [ 0.000000e+00, %bb1 ]
  %i3 = fcmp oeq float %i, %arg
  br i1 %i3, label %bb4, label %bb5

bb4:                                              ; preds = %bb2
  br label %bb5

bb5:                                              ; preds = %bb4, %bb2
  ret i1 %i3
}

; simplifyFCmpInst gets called without a context instruction and
; expects to simplify an unordered compare with a negative nan.
define i1 @simplify_fcmp_negative_nan_ueq(i1 %cond, float %arg) {
; CHECK-LABEL: define i1 @simplify_fcmp_negative_nan_ueq(
; CHECK-SAME: i1 [[COND:%.*]], float [[ARG:%.*]]) {
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB5:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[I3:%.*]] = fcmp ueq float 0.000000e+00, [[ARG]]
; CHECK-NEXT:    br i1 [[I3]], label [[BB5]], label [[BB5]]
; CHECK:       bb5:
; CHECK-NEXT:    [[I33:%.*]] = phi i1 [ [[I3]], [[BB2]] ], [ [[I3]], [[BB2]] ], [ true, [[BB:%.*]] ]
; CHECK-NEXT:    ret i1 [[I33]]
;
bb:
  br i1 %cond, label %bb1, label %bb2

bb1:
  br label %bb2

bb2:                                              ; preds = %bb1, %bb
  %i = phi float [ 0xFFFFFFFFE0000000, %bb ], [ 0.000000e+00, %bb1 ]
  %i3 = fcmp ueq float %i, %arg
  br i1 %i3, label %bb4, label %bb5

bb4:                                              ; preds = %bb2
  br label %bb5

bb5:                                              ; preds = %bb4, %bb2
  ret i1 %i3
}

define i1 @simplify_fcmp_positive_nan_oeq(i1 %cond, float %arg) {
; CHECK-LABEL: define i1 @simplify_fcmp_positive_nan_oeq(
; CHECK-SAME: i1 [[COND:%.*]], float [[ARG:%.*]]) {
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br i1 [[COND]], label [[BB2:%.*]], label [[BB5:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[I3:%.*]] = fcmp oeq float 0.000000e+00, [[ARG]]
; CHECK-NEXT:    br i1 [[I3]], label [[BB5]], label [[BB5]]
; CHECK:       bb5:
; CHECK-NEXT:    [[I33:%.*]] = phi i1 [ [[I3]], [[BB2]] ], [ [[I3]], [[BB2]] ], [ false, [[BB:%.*]] ]
; CHECK-NEXT:    ret i1 [[I33]]
;
bb:
  br i1 %cond, label %bb1, label %bb2

bb1:
  br label %bb2

bb2:                                              ; preds = %bb1, %bb
  %i = phi float [ 0x7FFFFFFFE0000000, %bb ], [ 0.000000e+00, %bb1 ]
  %i3 = fcmp oeq float %i, %arg
  br i1 %i3, label %bb4, label %bb5

bb4:                                              ; preds = %bb2
  br label %bb5

bb5:                                              ; preds = %bb4, %bb2
  ret i1 %i3
}
