; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine %s -S -o - | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

%test1.struct = type { i32, i32 }
@test1.aligned_glbl = global %test1.struct zeroinitializer, align 4
define void @test1(ptr %ptr) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    store i64 0, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    ret void
;
  %and = and i64 ptrtoint (ptr getelementptr (%test1.struct, ptr @test1.aligned_glbl, i32 0, i32 1) to i64), 3
  store i64 %and, ptr %ptr
  ret void
}

; Make sure we do not infinite loop trying to convert a constant expression back-and-forth.

@channel_wg4idx = external dso_local constant [9 x i8], align 1

define i64 @OpenFilter(i64 %x) {
; CHECK-LABEL: @OpenFilter(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[X:%.*]] to i8
; CHECK-NEXT:    [[T:%.*]] = sub i8 [[TMP1]], ptrtoint (ptr @channel_wg4idx to i8)
; CHECK-NEXT:    [[R:%.*]] = zext i8 [[T]] to i64
; CHECK-NEXT:    ret i64 [[R]]
;
  %sub = sub i64 %x, ptrtoint (ptr @channel_wg4idx to i64)
  %t = trunc i64 %sub to i8
  %r = zext i8 %t to i64
  ret i64 %r
}
