; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces %s | FileCheck %s

; Addrspacecasts or bitcasts must be inserted after the instructions that define their uses.

%struct.s0 = type { ptr, i32 }
%struct.s1 = type { %struct.s0 }

@global0 = protected addrspace(4) externally_initialized global %struct.s1 zeroinitializer

declare i32 @func(ptr %arg)

define i32 @addrspacecast_insert_pos_assert() {
; CHECK-LABEL: @addrspacecast_insert_pos_assert(
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i32, align 4, addrspace(5)
; CHECK-NEXT:    [[LOAD0:%.*]] = load ptr, ptr addrspace(4) @global0, align 8
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[LOAD0]] to ptr addrspace(1)
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(1) [[TMP1]] to ptr
; CHECK-NEXT:    [[LOAD1:%.*]] = load i32, ptr addrspace(5) [[ALLOCA]], align 4
; CHECK-NEXT:    [[SEXT:%.*]] = sext i32 [[LOAD1]] to i64
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i32, ptr [[TMP2]], i64 [[SEXT]]
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @func(ptr [[GEP]])
; CHECK-NEXT:    ret i32 [[CALL]]
;
  %alloca = alloca i32, align 4, addrspace(5)
  %cast = addrspacecast ptr addrspace(5) %alloca to ptr
  %load0 = load ptr, ptr addrspace(4) @global0
  %load1 = load i32, ptr %cast
  %sext = sext i32 %load1 to i64
  %gep = getelementptr inbounds i32, ptr %load0, i64 %sext
  %call = call i32 @func(ptr %gep)
  ret i32 %call
}

define void @bitcast_insert_pos_assert_1() {
; CHECK-LABEL: @bitcast_insert_pos_assert_1(
; CHECK-NEXT:  bb.0:
; CHECK-NEXT:    [[ASC0:%.*]] = addrspacecast ptr addrspace(5) undef to ptr
; CHECK-NEXT:    [[PTI0:%.*]] = ptrtoint ptr [[ASC0]] to i64
; CHECK-NEXT:    br label [[BB_1:%.*]]
; CHECK:       bb.1:
; CHECK-NEXT:    br i1 undef, label [[BB_2:%.*]], label [[BB_3:%.*]]
; CHECK:       bb.2:
; CHECK-NEXT:    [[LOAD0:%.*]] = load ptr, ptr addrspace(5) undef, align 8
; CHECK-NEXT:    br label [[BB_3]]
; CHECK:       bb.3:
; CHECK-NEXT:    ret void
;
bb.0:
  %asc0 = addrspacecast ptr addrspace(5) undef to ptr
  %pti0 = ptrtoint ptr %asc0 to i64
  br label %bb.1

bb.1:
  br i1 undef, label %bb.2, label %bb.3

bb.2:
  %pti1 = ptrtoint ptr %asc0 to i64
  %itp0 = inttoptr i64 %pti1 to ptr
  %load0 = load ptr, ptr %itp0, align 8
  br label %bb.3

bb.3:
  ret void
}

define void @bitcast_insert_pos_assert_2() {
; CHECK-LABEL: @bitcast_insert_pos_assert_2(
; CHECK-NEXT:    [[ALLOCA0:%.*]] = alloca [[STRUCT_S1:%.*]], align 16, addrspace(5)
; CHECK-NEXT:    [[ASC0:%.*]] = addrspacecast ptr addrspace(5) [[ALLOCA0]] to ptr
; CHECK-NEXT:    [[PTI0:%.*]] = ptrtoint ptr [[ASC0]] to i64
; CHECK-NEXT:    [[ITP0:%.*]] = inttoptr i64 [[PTI0]] to ptr
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(5) [[ALLOCA0]] to ptr
; CHECK-NEXT:    [[GEP0:%.*]] = getelementptr i64, ptr [[TMP1]], i64 1
; CHECK-NEXT:    ret void
;
  %alloca0 = alloca %struct.s1, align 16, addrspace(5)
  %asc0 = addrspacecast ptr addrspace(5) %alloca0 to ptr
  %pti0 = ptrtoint ptr %asc0 to i64
  %itp0 = inttoptr i64 %pti0 to ptr
  %itp1 = ptrtoint ptr %asc0 to i64
  %itp2 = inttoptr i64 %itp1 to ptr
  %gep0 = getelementptr i64, ptr %itp2, i64 1
  ret void
}
