; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -verify-loop-info -irce-print-changed-loops -passes=irce -S < %s 2>&1 | FileCheck %s
; RUN: opt -verify-loop-info -irce-print-changed-loops -passes='require<branch-prob>,irce' -S < %s 2>&1 | FileCheck %s

; CHECK-LABEL: irce: in function test_01: constrained Loop at depth 1 containing:
; CHECK-LABEL: irce: in function test_02: constrained Loop at depth 1 containing:
; CHECK-LABEL: irce: in function test_03: constrained Loop at depth 1 containing:
; CHECK-LABEL: irce: in function test_04: constrained Loop at depth 1 containing:
; CHECK-LABEL: irce: in function test_05: constrained Loop at depth 1 containing:

; This test used to demonstrate a miscompile: the outer loop's IV iterates in
; range of [2, 400) and the range check is done against value 331. Due to a bug
; in range intersection IRCE manages to eliminate the range check without
; inserting a postloop, which is incorrect. We treat the range of this test as
; an unsigned range and are able to intersect ranges correctly and insert a
; postloop.

define void @test_01() {
; CHECK-LABEL: define void @test_01() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_PREHEADER:%.*]], label [[MAIN_PSEUDO_EXIT:%.*]]
; CHECK:       loop_header.preheader:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop_header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 2, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[IV_PREV:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ], [ 1, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[IV_PREV]], -1
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_SPLIT_US:%.*]], label [[EXIT_LOOPEXIT1:%.*]]
; CHECK:       loop_header.split.us:
; CHECK-NEXT:    br label [[INNER_LOOP:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INNER_COND:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], 31
; CHECK-NEXT:    br i1 [[INNER_COND]], label [[INNER_LOOP]], label [[RANGE_CHECK_BLOCK:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit.loopexit1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
; CHECK:       range_check_block:
; CHECK-NEXT:    [[RANGE_CHECK:%.*]] = icmp slt i32 [[IV]], 331
; CHECK-NEXT:    br i1 true, label [[LOOP_LATCH]], label [[DEOPT_LOOPEXIT2:%.*]]
; CHECK:       loop_latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp ult i32 [[IV_NEXT]], 400
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 [[IV_NEXT]], 331
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOP_HEADER]], label [[MAIN_EXIT_SELECTOR:%.*]]
; CHECK:       main.exit.selector:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[IV_LCSSA:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[IV_NEXT_LCSSA]], 400
; CHECK-NEXT:    br i1 [[TMP1]], label [[MAIN_PSEUDO_EXIT]], label [[EXIT]]
; CHECK:       main.pseudo.exit:
; CHECK-NEXT:    [[IV_COPY:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[IV_PREV_COPY:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[IV_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[INDVAR_END:%.*]] = phi i32 [ 2, [[ENTRY]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    br label [[POSTLOOP:%.*]]
; CHECK:       deopt.loopexit:
; CHECK-NEXT:    br label [[DEOPT:%.*]]
; CHECK:       deopt.loopexit2:
; CHECK-NEXT:    br label [[DEOPT]]
; CHECK:       deopt:
; CHECK-NEXT:    ret void
; CHECK:       postloop:
; CHECK-NEXT:    br label [[LOOP_HEADER_POSTLOOP:%.*]]
; CHECK:       loop_header.postloop:
; CHECK-NEXT:    [[IV_POSTLOOP:%.*]] = phi i32 [ [[IV_COPY]], [[POSTLOOP]] ], [ [[IV_NEXT_POSTLOOP:%.*]], [[LOOP_LATCH_POSTLOOP:%.*]] ]
; CHECK-NEXT:    [[IV_PREV_POSTLOOP:%.*]] = phi i32 [ [[IV_PREV_COPY]], [[POSTLOOP]] ], [ [[IV_POSTLOOP]], [[LOOP_LATCH_POSTLOOP]] ]
; CHECK-NEXT:    [[TMP2_POSTLOOP:%.*]] = icmp sgt i32 [[IV_PREV_POSTLOOP]], -1
; CHECK-NEXT:    br i1 [[TMP2_POSTLOOP]], label [[LOOP_HEADER_SPLIT_US_POSTLOOP:%.*]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       loop_header.split.us.postloop:
; CHECK-NEXT:    br label [[INNER_LOOP_POSTLOOP:%.*]]
; CHECK:       inner_loop.postloop:
; CHECK-NEXT:    [[INNER_IV_POSTLOOP:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US_POSTLOOP]] ], [ [[INNER_IV_NEXT_POSTLOOP:%.*]], [[INNER_LOOP_POSTLOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT_POSTLOOP]] = add nuw nsw i32 [[INNER_IV_POSTLOOP]], 1
; CHECK-NEXT:    [[INNER_COND_POSTLOOP:%.*]] = icmp ult i32 [[INNER_IV_NEXT_POSTLOOP]], 31
; CHECK-NEXT:    br i1 [[INNER_COND_POSTLOOP]], label [[INNER_LOOP_POSTLOOP]], label [[RANGE_CHECK_BLOCK_POSTLOOP:%.*]]
; CHECK:       range_check_block.postloop:
; CHECK-NEXT:    [[RANGE_CHECK_POSTLOOP:%.*]] = icmp slt i32 [[IV_POSTLOOP]], 331
; CHECK-NEXT:    br i1 [[RANGE_CHECK_POSTLOOP]], label [[LOOP_LATCH_POSTLOOP]], label [[DEOPT_LOOPEXIT:%.*]]
; CHECK:       loop_latch.postloop:
; CHECK-NEXT:    [[IV_NEXT_POSTLOOP]] = add i32 [[IV_POSTLOOP]], 1
; CHECK-NEXT:    [[LOOP_COND_POSTLOOP:%.*]] = icmp ult i32 [[IV_NEXT_POSTLOOP]], 400
; CHECK-NEXT:    br i1 [[LOOP_COND_POSTLOOP]], label [[LOOP_HEADER_POSTLOOP]], label [[EXIT_LOOPEXIT]], !llvm.loop [[LOOP0:![0-9]+]], !loop_constrainer.loop.clone [[META5:![0-9]+]]
;

entry:
  br label %loop_header

loop_header:                            ; preds = %loop_latch, %entry
  %iv = phi i32 [ 2, %entry ], [ %iv_next, %loop_latch ]
  %iv.prev = phi i32 [ 1, %entry ], [ %iv, %loop_latch ]
  %tmp2 = icmp sgt i32 %iv.prev, -1
  br i1 %tmp2, label %loop_header.split.us, label %exit

loop_header.split.us:                   ; preds = %loop_header
  br label %inner_loop

inner_loop:                                   ; preds = %inner_loop, %loop_header.split.us
  %inner_iv = phi i32 [ 1, %loop_header.split.us ], [ %inner_iv_next, %inner_loop ]
  %inner_iv_next = add nuw nsw i32 %inner_iv, 1
  %inner_cond = icmp ult i32 %inner_iv_next, 31
  br i1 %inner_cond, label %inner_loop, label %range_check_block

exit:                                            ; preds = %loop_latch, %loop_header
  ret void

range_check_block:                                          ; preds = %inner_loop
  %range_check = icmp slt i32 %iv, 331
  br i1 %range_check, label %loop_latch, label %deopt

loop_latch:                                         ; preds = %range_check_block
  %iv_next = add i32 %iv, 1
  %loop_cond = icmp ult i32 %iv_next, 400
  br i1 %loop_cond, label %loop_header, label %exit

deopt:                                          ; preds = %range_check_block
  ret void
}

; Similar to test_01, but here the range check is done against 450. No postloop
; is required.

define void @test_02() {
; CHECK-LABEL: define void @test_02() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop_header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[IV_PREV:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[IV]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[IV_PREV]], -1
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_SPLIT_US:%.*]], label [[EXIT:%.*]]
; CHECK:       loop_header.split.us:
; CHECK-NEXT:    br label [[INNER_LOOP:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INNER_COND:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], 31
; CHECK-NEXT:    br i1 [[INNER_COND]], label [[INNER_LOOP]], label [[RANGE_CHECK_BLOCK:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
; CHECK:       range_check_block:
; CHECK-NEXT:    [[RANGE_CHECK:%.*]] = icmp slt i32 [[IV]], 450
; CHECK-NEXT:    br i1 true, label [[LOOP_LATCH]], label [[DEOPT:%.*]]
; CHECK:       loop_latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp ult i32 [[IV_NEXT]], 400
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP_HEADER]], label [[EXIT]]
; CHECK:       deopt:
; CHECK-NEXT:    ret void
;

entry:
  br label %loop_header

loop_header:                            ; preds = %loop_latch, %entry
  %iv = phi i32 [ 2, %entry ], [ %iv_next, %loop_latch ]
  %iv.prev = phi i32 [ 1, %entry ], [ %iv, %loop_latch ]
  %tmp2 = icmp sgt i32 %iv.prev, -1
  br i1 %tmp2, label %loop_header.split.us, label %exit

loop_header.split.us:                   ; preds = %loop_header
  br label %inner_loop

inner_loop:                                   ; preds = %inner_loop, %loop_header.split.us
  %inner_iv = phi i32 [ 1, %loop_header.split.us ], [ %inner_iv_next, %inner_loop ]
  %inner_iv_next = add nuw nsw i32 %inner_iv, 1
  %inner_cond = icmp ult i32 %inner_iv_next, 31
  br i1 %inner_cond, label %inner_loop, label %range_check_block

exit:                                            ; preds = %loop_latch, %loop_header
  ret void

range_check_block:                                          ; preds = %inner_loop
  %range_check = icmp slt i32 %iv, 450
  br i1 %range_check, label %loop_latch, label %deopt

loop_latch:                                         ; preds = %range_check_block
  %iv_next = add i32 %iv, 1
  %loop_cond = icmp ult i32 %iv_next, 400
  br i1 %loop_cond, label %loop_header, label %exit

deopt:                                          ; preds = %range_check_block
  ret void
}

; Range check is made against 0, so the safe iteration range is empty. IRCE
; should not apply to the inner loop. The condition %tmp2 can be eliminated.

define void @test_03() {
; CHECK-LABEL: define void @test_03() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop_header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[IV_PREV:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[IV]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[IV_PREV]], -1
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_SPLIT_US:%.*]], label [[EXIT:%.*]]
; CHECK:       loop_header.split.us:
; CHECK-NEXT:    br label [[INNER_LOOP:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INNER_COND:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], 31
; CHECK-NEXT:    br i1 [[INNER_COND]], label [[INNER_LOOP]], label [[RANGE_CHECK_BLOCK:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
; CHECK:       range_check_block:
; CHECK-NEXT:    [[RANGE_CHECK:%.*]] = icmp slt i32 [[IV]], 0
; CHECK-NEXT:    br i1 [[RANGE_CHECK]], label [[LOOP_LATCH]], label [[DEOPT:%.*]]
; CHECK:       loop_latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp ult i32 [[IV_NEXT]], 400
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP_HEADER]], label [[EXIT]]
; CHECK:       deopt:
; CHECK-NEXT:    ret void
;

entry:
  br label %loop_header

loop_header:                            ; preds = %loop_latch, %entry
  %iv = phi i32 [ 2, %entry ], [ %iv_next, %loop_latch ]
  %iv.prev = phi i32 [ 1, %entry ], [ %iv, %loop_latch ]
  %tmp2 = icmp sgt i32 %iv.prev, -1
  br i1 %tmp2, label %loop_header.split.us, label %exit

loop_header.split.us:                   ; preds = %loop_header
  br label %inner_loop

inner_loop:                                   ; preds = %inner_loop, %loop_header.split.us
  %inner_iv = phi i32 [ 1, %loop_header.split.us ], [ %inner_iv_next, %inner_loop ]
  %inner_iv_next = add nuw nsw i32 %inner_iv, 1
  %inner_cond = icmp ult i32 %inner_iv_next, 31
  br i1 %inner_cond, label %inner_loop, label %range_check_block

exit:                                            ; preds = %loop_latch, %loop_header
  ret void

range_check_block:                                          ; preds = %inner_loop
  %range_check = icmp slt i32 %iv, 0
  br i1 %range_check, label %loop_latch, label %deopt

loop_latch:                                         ; preds = %range_check_block
  %iv_next = add i32 %iv, 1
  %loop_cond = icmp ult i32 %iv_next, 400
  br i1 %loop_cond, label %loop_header, label %exit

deopt:                                          ; preds = %range_check_block
  ret void
}

; We can also properly eliminate range check against %n which is not always
; known positive.

define void @test_04(ptr %p) {
; CHECK-LABEL: define void @test_04
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[N:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SMIN:%.*]] = call i32 @llvm.smin.i32(i32 [[N]], i32 0)
; CHECK-NEXT:    [[TMP0:%.*]] = sub i32 [[N]], [[SMIN]]
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[SMIN]], i32 -1)
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i32 [[SMAX]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = mul i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[UMIN:%.*]] = call i32 @llvm.umin.i32(i32 [[TMP2]], i32 400)
; CHECK-NEXT:    [[EXIT_MAINLOOP_AT:%.*]] = call i32 @llvm.umax.i32(i32 [[UMIN]], i32 2)
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ult i32 2, [[EXIT_MAINLOOP_AT]]
; CHECK-NEXT:    br i1 [[TMP3]], label [[LOOP_HEADER_PREHEADER:%.*]], label [[MAIN_PSEUDO_EXIT:%.*]]
; CHECK:       loop_header.preheader:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop_header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 2, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[IV_PREV:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ], [ 1, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[IV_PREV]], -1
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_SPLIT_US:%.*]], label [[EXIT_LOOPEXIT1:%.*]]
; CHECK:       loop_header.split.us:
; CHECK-NEXT:    br label [[INNER_LOOP:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INNER_COND:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], 31
; CHECK-NEXT:    br i1 [[INNER_COND]], label [[INNER_LOOP]], label [[RANGE_CHECK_BLOCK:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit.loopexit1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
; CHECK:       range_check_block:
; CHECK-NEXT:    [[RANGE_CHECK:%.*]] = icmp slt i32 [[IV]], [[N]]
; CHECK-NEXT:    br i1 true, label [[LOOP_LATCH]], label [[DEOPT_LOOPEXIT2:%.*]]
; CHECK:       loop_latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp ult i32 [[IV_NEXT]], 400
; CHECK-NEXT:    [[TMP4:%.*]] = icmp ult i32 [[IV_NEXT]], [[EXIT_MAINLOOP_AT]]
; CHECK-NEXT:    br i1 [[TMP4]], label [[LOOP_HEADER]], label [[MAIN_EXIT_SELECTOR:%.*]]
; CHECK:       main.exit.selector:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[IV_LCSSA:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = icmp ult i32 [[IV_NEXT_LCSSA]], 400
; CHECK-NEXT:    br i1 [[TMP5]], label [[MAIN_PSEUDO_EXIT]], label [[EXIT]]
; CHECK:       main.pseudo.exit:
; CHECK-NEXT:    [[IV_COPY:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[IV_PREV_COPY:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[IV_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[INDVAR_END:%.*]] = phi i32 [ 2, [[ENTRY]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    br label [[POSTLOOP:%.*]]
; CHECK:       deopt.loopexit:
; CHECK-NEXT:    br label [[DEOPT:%.*]]
; CHECK:       deopt.loopexit2:
; CHECK-NEXT:    br label [[DEOPT]]
; CHECK:       deopt:
; CHECK-NEXT:    ret void
; CHECK:       postloop:
; CHECK-NEXT:    br label [[LOOP_HEADER_POSTLOOP:%.*]]
; CHECK:       loop_header.postloop:
; CHECK-NEXT:    [[IV_POSTLOOP:%.*]] = phi i32 [ [[IV_COPY]], [[POSTLOOP]] ], [ [[IV_NEXT_POSTLOOP:%.*]], [[LOOP_LATCH_POSTLOOP:%.*]] ]
; CHECK-NEXT:    [[IV_PREV_POSTLOOP:%.*]] = phi i32 [ [[IV_PREV_COPY]], [[POSTLOOP]] ], [ [[IV_POSTLOOP]], [[LOOP_LATCH_POSTLOOP]] ]
; CHECK-NEXT:    [[TMP2_POSTLOOP:%.*]] = icmp sgt i32 [[IV_PREV_POSTLOOP]], -1
; CHECK-NEXT:    br i1 [[TMP2_POSTLOOP]], label [[LOOP_HEADER_SPLIT_US_POSTLOOP:%.*]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       loop_header.split.us.postloop:
; CHECK-NEXT:    br label [[INNER_LOOP_POSTLOOP:%.*]]
; CHECK:       inner_loop.postloop:
; CHECK-NEXT:    [[INNER_IV_POSTLOOP:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US_POSTLOOP]] ], [ [[INNER_IV_NEXT_POSTLOOP:%.*]], [[INNER_LOOP_POSTLOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT_POSTLOOP]] = add nuw nsw i32 [[INNER_IV_POSTLOOP]], 1
; CHECK-NEXT:    [[INNER_COND_POSTLOOP:%.*]] = icmp ult i32 [[INNER_IV_NEXT_POSTLOOP]], 31
; CHECK-NEXT:    br i1 [[INNER_COND_POSTLOOP]], label [[INNER_LOOP_POSTLOOP]], label [[RANGE_CHECK_BLOCK_POSTLOOP:%.*]]
; CHECK:       range_check_block.postloop:
; CHECK-NEXT:    [[RANGE_CHECK_POSTLOOP:%.*]] = icmp slt i32 [[IV_POSTLOOP]], [[N]]
; CHECK-NEXT:    br i1 [[RANGE_CHECK_POSTLOOP]], label [[LOOP_LATCH_POSTLOOP]], label [[DEOPT_LOOPEXIT:%.*]]
; CHECK:       loop_latch.postloop:
; CHECK-NEXT:    [[IV_NEXT_POSTLOOP]] = add i32 [[IV_POSTLOOP]], 1
; CHECK-NEXT:    [[LOOP_COND_POSTLOOP:%.*]] = icmp ult i32 [[IV_NEXT_POSTLOOP]], 400
; CHECK-NEXT:    br i1 [[LOOP_COND_POSTLOOP]], label [[LOOP_HEADER_POSTLOOP]], label [[EXIT_LOOPEXIT]], !llvm.loop [[LOOP6:![0-9]+]], !loop_constrainer.loop.clone [[META5]]
;

entry:
  %n = load i32, ptr %p
  br label %loop_header

loop_header:                            ; preds = %loop_latch, %entry
  %iv = phi i32 [ 2, %entry ], [ %iv_next, %loop_latch ]
  %iv.prev = phi i32 [ 1, %entry ], [ %iv, %loop_latch ]
  %tmp2 = icmp sgt i32 %iv.prev, -1
  br i1 %tmp2, label %loop_header.split.us, label %exit

loop_header.split.us:                   ; preds = %loop_header
  br label %inner_loop

inner_loop:                                   ; preds = %inner_loop, %loop_header.split.us
  %inner_iv = phi i32 [ 1, %loop_header.split.us ], [ %inner_iv_next, %inner_loop ]
  %inner_iv_next = add nuw nsw i32 %inner_iv, 1
  %inner_cond = icmp ult i32 %inner_iv_next, 31
  br i1 %inner_cond, label %inner_loop, label %range_check_block

exit:                                            ; preds = %loop_latch, %loop_header
  ret void

range_check_block:                                          ; preds = %inner_loop
  %range_check = icmp slt i32 %iv, %n
  br i1 %range_check, label %loop_latch, label %deopt

loop_latch:                                         ; preds = %range_check_block
  %iv_next = add i32 %iv, 1
  %loop_cond = icmp ult i32 %iv_next, 400
  br i1 %loop_cond, label %loop_header, label %exit

deopt:                                          ; preds = %range_check_block
  ret void
}

; Same as test_04, but range guarantees that %n is positive. So we can safely
; intersect ranges (with insertion of postloop).

define void @test_05(ptr %p) {
; CHECK-LABEL: define void @test_05
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[N:%.*]] = load i32, ptr [[P]], align 4, !range [[RNG7:![0-9]+]]
; CHECK-NEXT:    [[EXIT_MAINLOOP_AT:%.*]] = call i32 @llvm.umax.i32(i32 [[N]], i32 2)
; CHECK-NEXT:    [[TMP0:%.*]] = icmp ult i32 2, [[EXIT_MAINLOOP_AT]]
; CHECK-NEXT:    br i1 [[TMP0]], label [[LOOP_HEADER_PREHEADER:%.*]], label [[MAIN_PSEUDO_EXIT:%.*]]
; CHECK:       loop_header.preheader:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop_header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 2, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[IV_PREV:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ], [ 1, [[LOOP_HEADER_PREHEADER]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp sgt i32 [[IV_PREV]], -1
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_SPLIT_US:%.*]], label [[EXIT_LOOPEXIT1:%.*]]
; CHECK:       loop_header.split.us:
; CHECK-NEXT:    br label [[INNER_LOOP:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[INNER_IV:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US]] ], [ [[INNER_IV_NEXT:%.*]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT]] = add nuw nsw i32 [[INNER_IV]], 1
; CHECK-NEXT:    [[INNER_COND:%.*]] = icmp ult i32 [[INNER_IV_NEXT]], 31
; CHECK-NEXT:    br i1 [[INNER_COND]], label [[INNER_LOOP]], label [[RANGE_CHECK_BLOCK:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit.loopexit1:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
; CHECK:       range_check_block:
; CHECK-NEXT:    [[RANGE_CHECK:%.*]] = icmp slt i32 [[IV]], [[N]]
; CHECK-NEXT:    br i1 true, label [[LOOP_LATCH]], label [[DEOPT_LOOPEXIT2:%.*]]
; CHECK:       loop_latch:
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp ult i32 [[IV_NEXT]], 400
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[IV_NEXT]], [[EXIT_MAINLOOP_AT]]
; CHECK-NEXT:    br i1 [[TMP1]], label [[LOOP_HEADER]], label [[MAIN_EXIT_SELECTOR:%.*]]
; CHECK:       main.exit.selector:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[IV_LCSSA:%.*]] = phi i32 [ [[IV]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult i32 [[IV_NEXT_LCSSA]], 400
; CHECK-NEXT:    br i1 [[TMP2]], label [[MAIN_PSEUDO_EXIT]], label [[EXIT]]
; CHECK:       main.pseudo.exit:
; CHECK-NEXT:    [[IV_COPY:%.*]] = phi i32 [ 2, [[ENTRY:%.*]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[IV_PREV_COPY:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ [[IV_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    [[INDVAR_END:%.*]] = phi i32 [ 2, [[ENTRY]] ], [ [[IV_NEXT_LCSSA]], [[MAIN_EXIT_SELECTOR]] ]
; CHECK-NEXT:    br label [[POSTLOOP:%.*]]
; CHECK:       deopt.loopexit:
; CHECK-NEXT:    br label [[DEOPT:%.*]]
; CHECK:       deopt.loopexit2:
; CHECK-NEXT:    br label [[DEOPT]]
; CHECK:       deopt:
; CHECK-NEXT:    ret void
; CHECK:       postloop:
; CHECK-NEXT:    br label [[LOOP_HEADER_POSTLOOP:%.*]]
; CHECK:       loop_header.postloop:
; CHECK-NEXT:    [[IV_POSTLOOP:%.*]] = phi i32 [ [[IV_COPY]], [[POSTLOOP]] ], [ [[IV_NEXT_POSTLOOP:%.*]], [[LOOP_LATCH_POSTLOOP:%.*]] ]
; CHECK-NEXT:    [[IV_PREV_POSTLOOP:%.*]] = phi i32 [ [[IV_PREV_COPY]], [[POSTLOOP]] ], [ [[IV_POSTLOOP]], [[LOOP_LATCH_POSTLOOP]] ]
; CHECK-NEXT:    [[TMP2_POSTLOOP:%.*]] = icmp sgt i32 [[IV_PREV_POSTLOOP]], -1
; CHECK-NEXT:    br i1 [[TMP2_POSTLOOP]], label [[LOOP_HEADER_SPLIT_US_POSTLOOP:%.*]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       loop_header.split.us.postloop:
; CHECK-NEXT:    br label [[INNER_LOOP_POSTLOOP:%.*]]
; CHECK:       inner_loop.postloop:
; CHECK-NEXT:    [[INNER_IV_POSTLOOP:%.*]] = phi i32 [ 1, [[LOOP_HEADER_SPLIT_US_POSTLOOP]] ], [ [[INNER_IV_NEXT_POSTLOOP:%.*]], [[INNER_LOOP_POSTLOOP]] ]
; CHECK-NEXT:    [[INNER_IV_NEXT_POSTLOOP]] = add nuw nsw i32 [[INNER_IV_POSTLOOP]], 1
; CHECK-NEXT:    [[INNER_COND_POSTLOOP:%.*]] = icmp ult i32 [[INNER_IV_NEXT_POSTLOOP]], 31
; CHECK-NEXT:    br i1 [[INNER_COND_POSTLOOP]], label [[INNER_LOOP_POSTLOOP]], label [[RANGE_CHECK_BLOCK_POSTLOOP:%.*]]
; CHECK:       range_check_block.postloop:
; CHECK-NEXT:    [[RANGE_CHECK_POSTLOOP:%.*]] = icmp slt i32 [[IV_POSTLOOP]], [[N]]
; CHECK-NEXT:    br i1 [[RANGE_CHECK_POSTLOOP]], label [[LOOP_LATCH_POSTLOOP]], label [[DEOPT_LOOPEXIT:%.*]]
; CHECK:       loop_latch.postloop:
; CHECK-NEXT:    [[IV_NEXT_POSTLOOP]] = add i32 [[IV_POSTLOOP]], 1
; CHECK-NEXT:    [[LOOP_COND_POSTLOOP:%.*]] = icmp ult i32 [[IV_NEXT_POSTLOOP]], 400
; CHECK-NEXT:    br i1 [[LOOP_COND_POSTLOOP]], label [[LOOP_HEADER_POSTLOOP]], label [[EXIT_LOOPEXIT]], !llvm.loop [[LOOP8:![0-9]+]], !loop_constrainer.loop.clone [[META5]]
;

entry:
  %n = load i32, ptr %p, !range !0
  br label %loop_header

loop_header:                            ; preds = %loop_latch, %entry
  %iv = phi i32 [ 2, %entry ], [ %iv_next, %loop_latch ]
  %iv.prev = phi i32 [ 1, %entry ], [ %iv, %loop_latch ]
  %tmp2 = icmp sgt i32 %iv.prev, -1
  br i1 %tmp2, label %loop_header.split.us, label %exit

loop_header.split.us:                   ; preds = %loop_header
  br label %inner_loop

inner_loop:                                   ; preds = %inner_loop, %loop_header.split.us
  %inner_iv = phi i32 [ 1, %loop_header.split.us ], [ %inner_iv_next, %inner_loop ]
  %inner_iv_next = add nuw nsw i32 %inner_iv, 1
  %inner_cond = icmp ult i32 %inner_iv_next, 31
  br i1 %inner_cond, label %inner_loop, label %range_check_block

exit:                                            ; preds = %loop_latch, %loop_header
  ret void

range_check_block:                                          ; preds = %inner_loop
  %range_check = icmp slt i32 %iv, %n
  br i1 %range_check, label %loop_latch, label %deopt

loop_latch:                                         ; preds = %range_check_block
  %iv_next = add i32 %iv, 1
  %loop_cond = icmp ult i32 %iv_next, 400
  br i1 %loop_cond, label %loop_header, label %exit

deopt:                                          ; preds = %range_check_block
  ret void
}

!0 = !{i32 0, i32 50}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]], [[META3:![0-9]+]], [[META4:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.unroll.disable"}
; CHECK: [[META2]] = !{!"llvm.loop.vectorize.enable", i1 false}
; CHECK: [[META3]] = !{!"llvm.loop.licm_versioning.disable"}
; CHECK: [[META4]] = !{!"llvm.loop.distribute.enable", i1 false}
; CHECK: [[META5]] = !{}
; CHECK: [[LOOP6]] = distinct !{[[LOOP6]], [[META1]], [[META2]], [[META3]], [[META4]]}
; CHECK: [[RNG7]] = !{i32 0, i32 50}
; CHECK: [[LOOP8]] = distinct !{[[LOOP8]], [[META1]], [[META2]], [[META3]], [[META4]]}
;.
