; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

declare { float, i32 } @llvm.frexp.f32.i32(float)
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>)
declare { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float>)

define { float, i32 } @ret_frexp_f32(float %arg0) {
; CHECK-LABEL: define { float, i32 } @ret_frexp_f32
; CHECK-SAME: (float [[ARG0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float [[ARG0]]) #[[ATTR7:[0-9]+]]
; CHECK-NEXT:    ret { float, i32 } [[CALL]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  ret { float, i32 } %call
}

define { float, i32 } @ret_frexp_f32_nonan(float nofpclass(nan) %arg0) {
; CHECK-LABEL: define { float, i32 } @ret_frexp_f32_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    ret { float, i32 } [[CALL]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  ret { float, i32 } %call
}

define float @ret_frexp_f32_0_nonan(float nofpclass(nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan sub) float @ret_frexp_f32_0_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nosnan(float nofpclass(snan) %arg0) {
; CHECK-LABEL: define nofpclass(snan sub) float @ret_frexp_f32_0_nosnan
; CHECK-SAME: (float nofpclass(snan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(snan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noqnan(float nofpclass(qnan) %arg0) {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_noqnan
; CHECK-SAME: (float nofpclass(qnan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(qnan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define i32 @ret_frexp_f32_1_nonan(float nofpclass(nan) %arg0) {
; CHECK-LABEL: define i32 @ret_frexp_f32_1_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_1:%.*]] = extractvalue { float, i32 } [[CALL]], 1
; CHECK-NEXT:    ret i32 [[CALL_1]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.1 = extractvalue { float, i32 } %call, 1
  ret i32 %call.1
}

define <2 x float> @ret_frexp_v2f32_0_nonan(<2 x float> nofpclass(nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan sub) <2 x float> @ret_frexp_v2f32_0_nonan
; CHECK-SAME: (<2 x float> nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[CALL]], 0
; CHECK-NEXT:    ret <2 x float> [[CALL_0]]
;
  %call = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %arg0)
  %call.0 = extractvalue { <2 x float>, <2 x i32> } %call, 0
  ret <2 x float> %call.0
}

define <2 x i32> @ret_frexp_v2f32_1_nonan(<2 x float> nofpclass(nan) %arg0) {
; CHECK-LABEL: define <2 x i32> @ret_frexp_v2f32_1_nonan
; CHECK-SAME: (<2 x float> nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { <2 x float>, <2 x i32> } [[CALL]], 1
; CHECK-NEXT:    ret <2 x i32> [[CALL_0]]
;
  %call = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %arg0)
  %call.0 = extractvalue { <2 x float>, <2 x i32> } %call, 1
  ret <2 x i32> %call.0
}

define float @ret_frexp_v4f32_0_nonan_elt1(<4 x float> nofpclass(nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan sub) float @ret_frexp_v4f32_0_nonan_elt1
; CHECK-SAME: (<4 x float> nofpclass(nan) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> nofpclass(nan) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { <4 x float>, <4 x i32> } [[CALL]], 0
; CHECK-NEXT:    [[ELT_2:%.*]] = extractelement <4 x float> [[CALL_0]], i32 2
; CHECK-NEXT:    ret float [[ELT_2]]
;
  %call = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %arg0)
  %call.0 = extractvalue { <4 x float>, <4 x i32> } %call, 0
  %elt.2 = extractelement <4 x float> %call.0, i32 2
  ret float %elt.2
}

define float @ret_frexp_f32_0_nopos_nopzero(float nofpclass(pinf psub pnorm pzero) %arg0) {
; CHECK-LABEL: define nofpclass(pinf pzero sub pnorm) float @ret_frexp_f32_0_nopos_nopzero
; CHECK-SAME: (float nofpclass(pinf pzero psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pinf pzero psub pnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopos_nopzero_nonan(float nofpclass(pinf psub pnorm pzero nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan pinf pzero sub pnorm) float @ret_frexp_f32_0_nopos_nopzero_nonan
; CHECK-SAME: (float nofpclass(nan pinf pzero psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan pinf pzero psub pnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopos(float nofpclass(pinf psub pnorm) %arg0) {
; CHECK-LABEL: define nofpclass(pinf sub) float @ret_frexp_f32_0_nopos
; CHECK-SAME: (float nofpclass(pinf psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pinf psub pnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopos_nonan(float nofpclass(pinf psub pnorm nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan pinf sub) float @ret_frexp_f32_0_nopos_nonan
; CHECK-SAME: (float nofpclass(nan pinf psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan pinf psub pnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopos_nozero(float nofpclass(pinf psub pnorm zero) %arg0) {
; CHECK-LABEL: define nofpclass(pinf zero sub pnorm) float @ret_frexp_f32_0_nopos_nozero
; CHECK-SAME: (float nofpclass(pinf zero psub pnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pinf zero psub pnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noneg_nonzero(float nofpclass(ninf nsub nnorm nzero) %arg0) {
; CHECK-LABEL: define nofpclass(ninf nzero sub nnorm) float @ret_frexp_f32_0_noneg_nonzero
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noneg_nonzero_nonan(float nofpclass(ninf nsub nnorm nzero nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan ninf nzero sub nnorm) float @ret_frexp_f32_0_noneg_nonzero_nonan
; CHECK-SAME: (float nofpclass(nan ninf nzero nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan ninf nzero nsub nnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noneg(float nofpclass(ninf nsub nnorm) %arg0) {
; CHECK-LABEL: define nofpclass(ninf sub) float @ret_frexp_f32_0_noneg
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(ninf nsub nnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noneg_nonan(float nofpclass(ninf nsub nnorm nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan ninf sub) float @ret_frexp_f32_0_noneg_nonan
; CHECK-SAME: (float nofpclass(nan ninf nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan ninf nsub nnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noneg_nozero(float nofpclass(ninf nsub nnorm nzero) %arg0) {
; CHECK-LABEL: define nofpclass(ninf nzero sub nnorm) float @ret_frexp_f32_0_noneg_nozero
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(ninf nzero nsub nnorm) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero(float nofpclass(pzero) %arg0) {
; CHECK-LABEL: define nofpclass(pzero sub) float @ret_frexp_f32_0_nopzero
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero(float nofpclass(nzero) %arg0) {
; CHECK-LABEL: define nofpclass(nzero sub) float @ret_frexp_f32_0_nonzero
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nozero(float nofpclass(zero) %arg0) {
; CHECK-LABEL: define nofpclass(zero sub) float @ret_frexp_f32_0_nozero
; CHECK-SAME: (float nofpclass(zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(zero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopinf(float nofpclass(pinf) %arg0) {
; CHECK-LABEL: define nofpclass(pinf sub) float @ret_frexp_f32_0_nopinf
; CHECK-SAME: (float nofpclass(pinf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pinf) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noninf(float nofpclass(ninf) %arg0) {
; CHECK-LABEL: define nofpclass(ninf sub) float @ret_frexp_f32_0_noninf
; CHECK-SAME: (float nofpclass(ninf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(ninf) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_noinf(float nofpclass(inf) %arg0) {
; CHECK-LABEL: define nofpclass(inf sub) float @ret_frexp_f32_0_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(inf) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nozero_nonan(float nofpclass(zero nan) %arg0) {
; CHECK-LABEL: define nofpclass(nan zero sub) float @ret_frexp_f32_0_nozero_nonan
; CHECK-SAME: (float nofpclass(nan zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan zero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nozero_noinf(float nofpclass(zero inf) %arg0) {
; CHECK-LABEL: define nofpclass(inf zero sub) float @ret_frexp_f32_0_nozero_noinf
; CHECK-SAME: (float nofpclass(inf zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(inf zero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nozero_nonan_noinf(float nofpclass(zero nan inf) %arg0) {
; CHECK-LABEL: define nofpclass(nan inf zero sub) float @ret_frexp_f32_0_nozero_nonan_noinf
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nan inf zero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero_ftz_daz(float nofpclass(nzero) %arg0) #1 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nonzero_ftz_daz
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero_ftpz_dapz(float nofpclass(nzero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(nzero sub) float @ret_frexp_f32_0_nonzero_ftpz_dapz
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero_dynamic_dynamic(float nofpclass(nzero) %arg0) #3 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nonzero_dynamic_dynamic
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero_ieee_daz(float nofpclass(nzero) %arg0) #4 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nonzero_ieee_daz
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nonzero_daz_ieee(float nofpclass(nzero) %arg0) #5 {
; CHECK-LABEL: define nofpclass(nzero sub) float @ret_frexp_f32_0_nonzero_daz_ieee
; CHECK-SAME: (float nofpclass(nzero) [[ARG0:%.*]]) #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(nzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero_ftz_daz(float nofpclass(pzero) %arg0) #1 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nopzero_ftz_daz
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero_ftpz_dapz(float nofpclass(pzero) %arg0) #2 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nopzero_ftpz_dapz
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero_dynamic_dynamic(float nofpclass(pzero) %arg0) #3 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nopzero_dynamic_dynamic
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR4]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero_ieee_daz(float nofpclass(pzero) %arg0) #4 {
; CHECK-LABEL: define nofpclass(sub) float @ret_frexp_f32_0_nopzero_ieee_daz
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR5]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}

define float @ret_frexp_f32_0_nopzero_daz_ieee(float nofpclass(pzero) %arg0) #5 {
; CHECK-LABEL: define nofpclass(pzero sub) float @ret_frexp_f32_0_nopzero_daz_ieee
; CHECK-SAME: (float nofpclass(pzero) [[ARG0:%.*]]) #[[ATTR6]] {
; CHECK-NEXT:    [[CALL:%.*]] = call { float, i32 } @llvm.frexp.f32.i32(float nofpclass(pzero) [[ARG0]]) #[[ATTR7]]
; CHECK-NEXT:    [[CALL_0:%.*]] = extractvalue { float, i32 } [[CALL]], 0
; CHECK-NEXT:    ret float [[CALL_0]]
;
  %call = call { float, i32 } @llvm.frexp.f32.i32(float %arg0)
  %call.0 = extractvalue { float, i32 } %call, 0
  ret float %call.0
}


attributes #0 = { "denormal-fp-math"="ieee,ieee" }
attributes #1 = { "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #2 = { "denormal-fp-math"="positive-zero,positive-zero" }
attributes #3 = { "denormal-fp-math"="dynamic,dynamic" }
attributes #4 = { "denormal-fp-math"="ieee,preserve-sign" }
attributes #5 = { "denormal-fp-math"="preserve-sign,ieee" }


;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
