; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

%struct.ss = type { i32, i64 }

define internal void @f(ptr byval(%struct.ss)  %b, ptr byval(i32) %X) nounwind  {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@f
; CHECK-SAME: (i32 [[TMP0:%.*]], i64 [[TMP1:%.*]], i32 [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X_PRIV:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store i32 [[TMP2]], ptr [[X_PRIV]], align 4
; CHECK-NEXT:    [[B_PRIV:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[B_PRIV]], align 4
; CHECK-NEXT:    [[B_PRIV_B4:%.*]] = getelementptr i8, ptr [[B_PRIV]], i64 4
; CHECK-NEXT:    store i64 [[TMP1]], ptr [[B_PRIV_B4]], align 4
; CHECK-NEXT:    [[VAL1:%.*]] = load i32, ptr [[B_PRIV]], align 8
; CHECK-NEXT:    [[VAL2:%.*]] = add i32 [[VAL1]], 1
; CHECK-NEXT:    store i32 [[VAL2]], ptr [[B_PRIV]], align 8
; CHECK-NEXT:    store i32 0, ptr [[X_PRIV]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %val1 = load i32, ptr %b, align 4
  %val2 = add i32 %val1, 1
  store i32 %val2, ptr %b, align 4

  store i32 0, ptr %X
  ret void
}

define i32 @test(ptr %X) {
;
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@test
; TUNIT-SAME: (ptr nocapture nofree nonnull readonly [[X:%.*]]) #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[S:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
; TUNIT-NEXT:    store i32 1, ptr [[S]], align 8
; TUNIT-NEXT:    [[VAL4:%.*]] = getelementptr [[STRUCT_SS]], ptr [[S]], i32 0, i32 1
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[S]], align 8
; TUNIT-NEXT:    [[S_B4:%.*]] = getelementptr i8, ptr [[S]], i64 4
; TUNIT-NEXT:    [[TMP1:%.*]] = load i64, ptr [[S_B4]], align 8
; TUNIT-NEXT:    [[TMP2:%.*]] = load i32, ptr [[X]], align 4
; TUNIT-NEXT:    call void @f(i32 [[TMP0]], i64 [[TMP1]], i32 [[TMP2]]) #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    ret i32 0
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@test
; CGSCC-SAME: (ptr nocapture nofree noundef nonnull readonly align 4 dereferenceable(4) [[X:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[S:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
; CGSCC-NEXT:    [[VAL4:%.*]] = getelementptr [[STRUCT_SS]], ptr [[S]], i32 0, i32 1
; CGSCC-NEXT:    ret i32 0
;
entry:
  %S = alloca %struct.ss
  store i32 1, ptr %S, align 8
  %val4 = getelementptr %struct.ss, ptr %S, i32 0, i32 1
  store i64 2, ptr %val4, align 4
  call void @f(ptr byval(%struct.ss) %S, ptr byval(i32) %X)
  ret i32 0
}
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree nosync nounwind willreturn memory(argmem: readwrite) }
;.
