// RUN: llvm-mc -triple x86_64 -x86-asm-syntax=intel -output-asm-variant=1 --show-encoding %s | FileCheck %s

// CHECK: cmpbexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe6,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpbexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpbexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe6,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpbexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpbexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe6,0x0d,0x00,0x00,0x00,0x00]
          cmpbexadd dword ptr [rip], ecx, eax

// CHECK: cmpbexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe6,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpbexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpbexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe6,0x89,0xfc,0x01,0x00,0x00]
          cmpbexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpbexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe6,0x8a,0x00,0xfe,0xff,0xff]
          cmpbexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpbexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe6,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpbexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpbexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe6,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpbexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpbexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe6,0x0d,0x00,0x00,0x00,0x00]
          cmpbexadd qword ptr [rip], r9, r10

// CHECK: cmpbexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe6,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpbexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpbexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe6,0x89,0xf8,0x03,0x00,0x00]
          cmpbexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpbexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe6,0x8a,0x00,0xfc,0xff,0xff]
          cmpbexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpbxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe2,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpbxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpbxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe2,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpbxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpbxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe2,0x0d,0x00,0x00,0x00,0x00]
          cmpbxadd dword ptr [rip], ecx, eax

// CHECK: cmpbxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe2,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpbxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpbxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe2,0x89,0xfc,0x01,0x00,0x00]
          cmpbxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpbxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe2,0x8a,0x00,0xfe,0xff,0xff]
          cmpbxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpbxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe2,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpbxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpbxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe2,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpbxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpbxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe2,0x0d,0x00,0x00,0x00,0x00]
          cmpbxadd qword ptr [rip], r9, r10

// CHECK: cmpbxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe2,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpbxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpbxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe2,0x89,0xf8,0x03,0x00,0x00]
          cmpbxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpbxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe2,0x8a,0x00,0xfc,0xff,0xff]
          cmpbxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmplexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xee,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmplexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmplexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xee,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmplexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmplexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xee,0x0d,0x00,0x00,0x00,0x00]
          cmplexadd dword ptr [rip], ecx, eax

// CHECK: cmplexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xee,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmplexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmplexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xee,0x89,0xfc,0x01,0x00,0x00]
          cmplexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmplexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xee,0x8a,0x00,0xfe,0xff,0xff]
          cmplexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmplexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xee,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmplexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmplexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xee,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmplexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmplexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xee,0x0d,0x00,0x00,0x00,0x00]
          cmplexadd qword ptr [rip], r9, r10

// CHECK: cmplexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xee,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmplexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmplexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xee,0x89,0xf8,0x03,0x00,0x00]
          cmplexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmplexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xee,0x8a,0x00,0xfc,0xff,0xff]
          cmplexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmplxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xec,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmplxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmplxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xec,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmplxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmplxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xec,0x0d,0x00,0x00,0x00,0x00]
          cmplxadd dword ptr [rip], ecx, eax

// CHECK: cmplxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xec,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmplxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmplxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xec,0x89,0xfc,0x01,0x00,0x00]
          cmplxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmplxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xec,0x8a,0x00,0xfe,0xff,0xff]
          cmplxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmplxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xec,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmplxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmplxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xec,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmplxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmplxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xec,0x0d,0x00,0x00,0x00,0x00]
          cmplxadd qword ptr [rip], r9, r10

// CHECK: cmplxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xec,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmplxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmplxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xec,0x89,0xf8,0x03,0x00,0x00]
          cmplxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmplxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xec,0x8a,0x00,0xfc,0xff,0xff]
          cmplxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpaxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe7,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpaxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpaxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe7,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpaxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpaxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe7,0x0d,0x00,0x00,0x00,0x00]
          cmpaxadd dword ptr [rip], ecx, eax

// CHECK: cmpaxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe7,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpaxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpaxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe7,0x89,0xfc,0x01,0x00,0x00]
          cmpaxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpaxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe7,0x8a,0x00,0xfe,0xff,0xff]
          cmpaxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpaxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe7,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpaxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpaxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe7,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpaxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpaxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe7,0x0d,0x00,0x00,0x00,0x00]
          cmpaxadd qword ptr [rip], r9, r10

// CHECK: cmpaxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe7,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpaxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpaxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe7,0x89,0xf8,0x03,0x00,0x00]
          cmpaxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpaxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe7,0x8a,0x00,0xfc,0xff,0xff]
          cmpaxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpaexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe3,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpaexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpaexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe3,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpaexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpaexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe3,0x0d,0x00,0x00,0x00,0x00]
          cmpaexadd dword ptr [rip], ecx, eax

// CHECK: cmpaexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe3,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpaexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpaexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe3,0x89,0xfc,0x01,0x00,0x00]
          cmpaexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpaexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe3,0x8a,0x00,0xfe,0xff,0xff]
          cmpaexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpaexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe3,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpaexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpaexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe3,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpaexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpaexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe3,0x0d,0x00,0x00,0x00,0x00]
          cmpaexadd qword ptr [rip], r9, r10

// CHECK: cmpaexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe3,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpaexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpaexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe3,0x89,0xf8,0x03,0x00,0x00]
          cmpaexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpaexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe3,0x8a,0x00,0xfc,0xff,0xff]
          cmpaexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpgxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xef,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpgxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpgxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xef,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpgxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpgxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xef,0x0d,0x00,0x00,0x00,0x00]
          cmpgxadd dword ptr [rip], ecx, eax

// CHECK: cmpgxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xef,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpgxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpgxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xef,0x89,0xfc,0x01,0x00,0x00]
          cmpgxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpgxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xef,0x8a,0x00,0xfe,0xff,0xff]
          cmpgxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpgxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xef,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpgxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpgxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xef,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpgxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpgxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xef,0x0d,0x00,0x00,0x00,0x00]
          cmpgxadd qword ptr [rip], r9, r10

// CHECK: cmpgxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xef,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpgxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpgxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xef,0x89,0xf8,0x03,0x00,0x00]
          cmpgxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpgxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xef,0x8a,0x00,0xfc,0xff,0xff]
          cmpgxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpgexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xed,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpgexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpgexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xed,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpgexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpgexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xed,0x0d,0x00,0x00,0x00,0x00]
          cmpgexadd dword ptr [rip], ecx, eax

// CHECK: cmpgexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xed,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpgexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpgexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xed,0x89,0xfc,0x01,0x00,0x00]
          cmpgexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpgexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xed,0x8a,0x00,0xfe,0xff,0xff]
          cmpgexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpgexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xed,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpgexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpgexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xed,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpgexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpgexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xed,0x0d,0x00,0x00,0x00,0x00]
          cmpgexadd qword ptr [rip], r9, r10

// CHECK: cmpgexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xed,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpgexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpgexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xed,0x89,0xf8,0x03,0x00,0x00]
          cmpgexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpgexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xed,0x8a,0x00,0xfc,0xff,0xff]
          cmpgexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpnoxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe1,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnoxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpnoxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe1,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnoxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpnoxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe1,0x0d,0x00,0x00,0x00,0x00]
          cmpnoxadd dword ptr [rip], ecx, eax

// CHECK: cmpnoxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe1,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpnoxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpnoxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe1,0x89,0xfc,0x01,0x00,0x00]
          cmpnoxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpnoxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe1,0x8a,0x00,0xfe,0xff,0xff]
          cmpnoxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpnoxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe1,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnoxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpnoxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe1,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnoxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpnoxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe1,0x0d,0x00,0x00,0x00,0x00]
          cmpnoxadd qword ptr [rip], r9, r10

// CHECK: cmpnoxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe1,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpnoxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpnoxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe1,0x89,0xf8,0x03,0x00,0x00]
          cmpnoxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpnoxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe1,0x8a,0x00,0xfc,0xff,0xff]
          cmpnoxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpnpxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xeb,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnpxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpnpxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xeb,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnpxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpnpxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xeb,0x0d,0x00,0x00,0x00,0x00]
          cmpnpxadd dword ptr [rip], ecx, eax

// CHECK: cmpnpxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xeb,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpnpxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpnpxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xeb,0x89,0xfc,0x01,0x00,0x00]
          cmpnpxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpnpxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xeb,0x8a,0x00,0xfe,0xff,0xff]
          cmpnpxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpnpxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xeb,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnpxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpnpxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xeb,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnpxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpnpxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xeb,0x0d,0x00,0x00,0x00,0x00]
          cmpnpxadd qword ptr [rip], r9, r10

// CHECK: cmpnpxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xeb,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpnpxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpnpxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xeb,0x89,0xf8,0x03,0x00,0x00]
          cmpnpxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpnpxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xeb,0x8a,0x00,0xfc,0xff,0xff]
          cmpnpxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpnsxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe9,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnsxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpnsxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe9,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnsxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpnsxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe9,0x0d,0x00,0x00,0x00,0x00]
          cmpnsxadd dword ptr [rip], ecx, eax

// CHECK: cmpnsxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe9,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpnsxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpnsxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe9,0x89,0xfc,0x01,0x00,0x00]
          cmpnsxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpnsxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe9,0x8a,0x00,0xfe,0xff,0xff]
          cmpnsxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpnsxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe9,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnsxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpnsxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe9,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnsxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpnsxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe9,0x0d,0x00,0x00,0x00,0x00]
          cmpnsxadd qword ptr [rip], r9, r10

// CHECK: cmpnsxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe9,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpnsxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpnsxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe9,0x89,0xf8,0x03,0x00,0x00]
          cmpnsxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpnsxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe9,0x8a,0x00,0xfc,0xff,0xff]
          cmpnsxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpnexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe5,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpnexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe5,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpnexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe5,0x0d,0x00,0x00,0x00,0x00]
          cmpnexadd dword ptr [rip], ecx, eax

// CHECK: cmpnexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe5,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpnexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpnexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe5,0x89,0xfc,0x01,0x00,0x00]
          cmpnexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpnexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe5,0x8a,0x00,0xfe,0xff,0xff]
          cmpnexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpnexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe5,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpnexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpnexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe5,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpnexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpnexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe5,0x0d,0x00,0x00,0x00,0x00]
          cmpnexadd qword ptr [rip], r9, r10

// CHECK: cmpnexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe5,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpnexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpnexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe5,0x89,0xf8,0x03,0x00,0x00]
          cmpnexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpnexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe5,0x8a,0x00,0xfc,0xff,0xff]
          cmpnexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpoxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe0,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpoxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpoxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe0,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpoxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpoxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe0,0x0d,0x00,0x00,0x00,0x00]
          cmpoxadd dword ptr [rip], ecx, eax

// CHECK: cmpoxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe0,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpoxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpoxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe0,0x89,0xfc,0x01,0x00,0x00]
          cmpoxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpoxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe0,0x8a,0x00,0xfe,0xff,0xff]
          cmpoxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpoxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe0,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpoxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpoxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe0,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpoxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpoxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe0,0x0d,0x00,0x00,0x00,0x00]
          cmpoxadd qword ptr [rip], r9, r10

// CHECK: cmpoxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe0,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpoxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpoxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe0,0x89,0xf8,0x03,0x00,0x00]
          cmpoxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpoxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe0,0x8a,0x00,0xfc,0xff,0xff]
          cmpoxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmppxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xea,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmppxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmppxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xea,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmppxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmppxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xea,0x0d,0x00,0x00,0x00,0x00]
          cmppxadd dword ptr [rip], ecx, eax

// CHECK: cmppxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xea,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmppxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmppxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xea,0x89,0xfc,0x01,0x00,0x00]
          cmppxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmppxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xea,0x8a,0x00,0xfe,0xff,0xff]
          cmppxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmppxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xea,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmppxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmppxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xea,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmppxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmppxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xea,0x0d,0x00,0x00,0x00,0x00]
          cmppxadd qword ptr [rip], r9, r10

// CHECK: cmppxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xea,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmppxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmppxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xea,0x89,0xf8,0x03,0x00,0x00]
          cmppxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmppxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xea,0x8a,0x00,0xfc,0xff,0xff]
          cmppxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpsxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe8,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpsxadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpsxadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe8,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpsxadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpsxadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe8,0x0d,0x00,0x00,0x00,0x00]
          cmpsxadd dword ptr [rip], ecx, eax

// CHECK: cmpsxadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe8,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpsxadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpsxadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe8,0x89,0xfc,0x01,0x00,0x00]
          cmpsxadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpsxadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe8,0x8a,0x00,0xfe,0xff,0xff]
          cmpsxadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpsxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe8,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpsxadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpsxadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe8,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpsxadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpsxadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe8,0x0d,0x00,0x00,0x00,0x00]
          cmpsxadd qword ptr [rip], r9, r10

// CHECK: cmpsxadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe8,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpsxadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpsxadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe8,0x89,0xf8,0x03,0x00,0x00]
          cmpsxadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpsxadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe8,0x8a,0x00,0xfc,0xff,0xff]
          cmpsxadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax
// CHECK: encoding: [0xc4,0xa2,0x79,0xe4,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpexadd dword ptr [rbp + 8*r14 + 268435456], ecx, eax

// CHECK: cmpexadd dword ptr [r8 + 4*rax + 291], ecx, eax
// CHECK: encoding: [0xc4,0xc2,0x79,0xe4,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpexadd dword ptr [r8 + 4*rax + 291], ecx, eax

// CHECK: cmpexadd dword ptr [rip], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe4,0x0d,0x00,0x00,0x00,0x00]
          cmpexadd dword ptr [rip], ecx, eax

// CHECK: cmpexadd dword ptr [2*rbp - 128], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe4,0x0c,0x6d,0x80,0xff,0xff,0xff]
          cmpexadd dword ptr [2*rbp - 128], ecx, eax

// CHECK: cmpexadd dword ptr [rcx + 508], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe4,0x89,0xfc,0x01,0x00,0x00]
          cmpexadd dword ptr [rcx + 508], ecx, eax

// CHECK: cmpexadd dword ptr [rdx - 512], ecx, eax
// CHECK: encoding: [0xc4,0xe2,0x79,0xe4,0x8a,0x00,0xfe,0xff,0xff]
          cmpexadd dword ptr [rdx - 512], ecx, eax

// CHECK: cmpexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10
// CHECK: encoding: [0xc4,0x22,0xa9,0xe4,0x8c,0xf5,0x00,0x00,0x00,0x10]
          cmpexadd qword ptr [rbp + 8*r14 + 268435456], r9, r10

// CHECK: cmpexadd qword ptr [r8 + 4*rax + 291], r9, r10
// CHECK: encoding: [0xc4,0x42,0xa9,0xe4,0x8c,0x80,0x23,0x01,0x00,0x00]
          cmpexadd qword ptr [r8 + 4*rax + 291], r9, r10

// CHECK: cmpexadd qword ptr [rip], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe4,0x0d,0x00,0x00,0x00,0x00]
          cmpexadd qword ptr [rip], r9, r10

// CHECK: cmpexadd qword ptr [2*rbp - 256], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe4,0x0c,0x6d,0x00,0xff,0xff,0xff]
          cmpexadd qword ptr [2*rbp - 256], r9, r10

// CHECK: cmpexadd qword ptr [rcx + 1016], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe4,0x89,0xf8,0x03,0x00,0x00]
          cmpexadd qword ptr [rcx + 1016], r9, r10

// CHECK: cmpexadd qword ptr [rdx - 1024], r9, r10
// CHECK: encoding: [0xc4,0x62,0xa9,0xe4,0x8a,0x00,0xfc,0xff,0xff]
          cmpexadd qword ptr [rdx - 1024], r9, r10

// CHECK: cmpbexadd dword ptr [rip], r8d, ecx
// CHECK: encoding: [0xc4,0x62,0x71,0xe6,0x05,0x00,0x00,0x00,0x00]
          cmpbexadd dword ptr [rip], r8d, ecx
