// RUN: llvm-mc -triple i386-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: addpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
addpd -485498096(%edx,%eax,4), %xmm1

// CHECK: addpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
addpd 485498096(%edx,%eax,4), %xmm1

// CHECK: addpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x8a,0xf0,0x1c,0xf0,0x1c]
addpd 485498096(%edx), %xmm1

// CHECK: addpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x0d,0xf0,0x1c,0xf0,0x1c]
addpd 485498096, %xmm1

// CHECK: addpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x4c,0x02,0x40]
addpd 64(%edx,%eax), %xmm1

// CHECK: addpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0x0a]
addpd (%edx), %xmm1

// CHECK: addpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x58,0xc9]
addpd %xmm1, %xmm1

// CHECK: addsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
addsd -485498096(%edx,%eax,4), %xmm1

// CHECK: addsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
addsd 485498096(%edx,%eax,4), %xmm1

// CHECK: addsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x8a,0xf0,0x1c,0xf0,0x1c]
addsd 485498096(%edx), %xmm1

// CHECK: addsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x0d,0xf0,0x1c,0xf0,0x1c]
addsd 485498096, %xmm1

// CHECK: addsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x4c,0x02,0x40]
addsd 64(%edx,%eax), %xmm1

// CHECK: addsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0x0a]
addsd (%edx), %xmm1

// CHECK: addsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x58,0xc9]
addsd %xmm1, %xmm1

// CHECK: andnpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
andnpd -485498096(%edx,%eax,4), %xmm1

// CHECK: andnpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
andnpd 485498096(%edx,%eax,4), %xmm1

// CHECK: andnpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x8a,0xf0,0x1c,0xf0,0x1c]
andnpd 485498096(%edx), %xmm1

// CHECK: andnpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x0d,0xf0,0x1c,0xf0,0x1c]
andnpd 485498096, %xmm1

// CHECK: andnpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x4c,0x02,0x40]
andnpd 64(%edx,%eax), %xmm1

// CHECK: andnpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0x0a]
andnpd (%edx), %xmm1

// CHECK: andnpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x55,0xc9]
andnpd %xmm1, %xmm1

// CHECK: andpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
andpd -485498096(%edx,%eax,4), %xmm1

// CHECK: andpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
andpd 485498096(%edx,%eax,4), %xmm1

// CHECK: andpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x8a,0xf0,0x1c,0xf0,0x1c]
andpd 485498096(%edx), %xmm1

// CHECK: andpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x0d,0xf0,0x1c,0xf0,0x1c]
andpd 485498096, %xmm1

// CHECK: andpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x4c,0x02,0x40]
andpd 64(%edx,%eax), %xmm1

// CHECK: andpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0x0a]
andpd (%edx), %xmm1

// CHECK: andpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x54,0xc9]
andpd %xmm1, %xmm1

// CHECK: cmpeqpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
cmpeqpd -485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqpd 485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqpd 485498096(%edx), %xmm1

// CHECK: cmpeqpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqpd 485498096, %xmm1

// CHECK: cmpeqpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x4c,0x02,0x40,0x00]
cmpeqpd 64(%edx,%eax), %xmm1

// CHECK: cmpeqpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0x0a,0x00]
cmpeqpd (%edx), %xmm1

// CHECK: cmpeqpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xc2,0xc9,0x00]
cmpeqpd %xmm1, %xmm1

// CHECK: cmpeqsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
cmpeqsd -485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqsd 485498096(%edx,%eax,4), %xmm1

// CHECK: cmpeqsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqsd 485498096(%edx), %xmm1

// CHECK: cmpeqsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqsd 485498096, %xmm1

// CHECK: cmpeqsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x4c,0x02,0x40,0x00]
cmpeqsd 64(%edx,%eax), %xmm1

// CHECK: cmpeqsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0x0a,0x00]
cmpeqsd (%edx), %xmm1

// CHECK: cmpeqsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0xc2,0xc9,0x00]
cmpeqsd %xmm1, %xmm1

// CHECK: comisd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
comisd -485498096(%edx,%eax,4), %xmm1

// CHECK: comisd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
comisd 485498096(%edx,%eax,4), %xmm1

// CHECK: comisd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x8a,0xf0,0x1c,0xf0,0x1c]
comisd 485498096(%edx), %xmm1

// CHECK: comisd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x0d,0xf0,0x1c,0xf0,0x1c]
comisd 485498096, %xmm1

// CHECK: comisd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x4c,0x02,0x40]
comisd 64(%edx,%eax), %xmm1

// CHECK: comisd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0x0a]
comisd (%edx), %xmm1

// CHECK: comisd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2f,0xc9]
comisd %xmm1, %xmm1

// CHECK: cvtdq2pd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtdq2pd -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtdq2pd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtdq2pd 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtdq2pd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtdq2pd 485498096(%edx), %xmm1

// CHECK: cvtdq2pd 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtdq2pd 485498096, %xmm1

// CHECK: cvtdq2pd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x4c,0x02,0x40]
cvtdq2pd 64(%edx,%eax), %xmm1

// CHECK: cvtdq2pd (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0x0a]
cvtdq2pd (%edx), %xmm1

// CHECK: cvtdq2pd %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0xe6,0xc9]
cvtdq2pd %xmm1, %xmm1

// CHECK: cvtdq2ps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtdq2ps -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtdq2ps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtdq2ps 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtdq2ps 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5b,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtdq2ps 485498096(%edx), %xmm1

// CHECK: cvtdq2ps 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5b,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtdq2ps 485498096, %xmm1

// CHECK: cvtdq2ps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5b,0x4c,0x02,0x40]
cvtdq2ps 64(%edx,%eax), %xmm1

// CHECK: cvtdq2ps (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5b,0x0a]
cvtdq2ps (%edx), %xmm1

// CHECK: cvtdq2ps %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5b,0xc9]
cvtdq2ps %xmm1, %xmm1

// CHECK: cvtpd2dq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtpd2dq -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpd2dq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtpd2dq 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpd2dq 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtpd2dq 485498096(%edx), %xmm1

// CHECK: cvtpd2dq 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtpd2dq 485498096, %xmm1

// CHECK: cvtpd2dq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x4c,0x02,0x40]
cvtpd2dq 64(%edx,%eax), %xmm1

// CHECK: cvtpd2dq (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0x0a]
cvtpd2dq (%edx), %xmm1

// CHECK: cvtpd2dq %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0xe6,0xc9]
cvtpd2dq %xmm1, %xmm1

// CHECK: cvtpd2pi -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
cvtpd2pi -485498096(%edx,%eax,4), %mm4

// CHECK: cvtpd2pi 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
cvtpd2pi 485498096(%edx,%eax,4), %mm4

// CHECK: cvtpd2pi 485498096(%edx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0xa2,0xf0,0x1c,0xf0,0x1c]
cvtpd2pi 485498096(%edx), %mm4

// CHECK: cvtpd2pi 485498096, %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x25,0xf0,0x1c,0xf0,0x1c]
cvtpd2pi 485498096, %mm4

// CHECK: cvtpd2pi 64(%edx,%eax), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x64,0x02,0x40]
cvtpd2pi 64(%edx,%eax), %mm4

// CHECK: cvtpd2pi (%edx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x22]
cvtpd2pi (%edx), %mm4

// CHECK: cvtpd2pi %xmm1, %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0xe1]
cvtpd2pi %xmm1, %mm4

// CHECK: cvtpd2ps -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtpd2ps -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpd2ps 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtpd2ps 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpd2ps 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtpd2ps 485498096(%edx), %xmm1

// CHECK: cvtpd2ps 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtpd2ps 485498096, %xmm1

// CHECK: cvtpd2ps 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x4c,0x02,0x40]
cvtpd2ps 64(%edx,%eax), %xmm1

// CHECK: cvtpd2ps (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0x0a]
cvtpd2ps (%edx), %xmm1

// CHECK: cvtpd2ps %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5a,0xc9]
cvtpd2ps %xmm1, %xmm1

// CHECK: cvtpi2pd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtpi2pd -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpi2pd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtpi2pd 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtpi2pd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtpi2pd 485498096(%edx), %xmm1

// CHECK: cvtpi2pd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtpi2pd 485498096, %xmm1

// CHECK: cvtpi2pd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x4c,0x02,0x40]
cvtpi2pd 64(%edx,%eax), %xmm1

// CHECK: cvtpi2pd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0x0a]
cvtpi2pd (%edx), %xmm1

// CHECK: cvtpi2pd %mm4, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2a,0xcc]
cvtpi2pd %mm4, %xmm1

// CHECK: cvtps2dq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtps2dq -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtps2dq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtps2dq 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtps2dq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtps2dq 485498096(%edx), %xmm1

// CHECK: cvtps2dq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtps2dq 485498096, %xmm1

// CHECK: cvtps2dq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x4c,0x02,0x40]
cvtps2dq 64(%edx,%eax), %xmm1

// CHECK: cvtps2dq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0x0a]
cvtps2dq (%edx), %xmm1

// CHECK: cvtps2dq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5b,0xc9]
cvtps2dq %xmm1, %xmm1

// CHECK: cvtps2pd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtps2pd -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtps2pd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x0f,0x5a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtps2pd 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtps2pd 485498096(%edx), %xmm1
// CHECK: encoding: [0x0f,0x5a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtps2pd 485498096(%edx), %xmm1

// CHECK: cvtps2pd 485498096, %xmm1
// CHECK: encoding: [0x0f,0x5a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtps2pd 485498096, %xmm1

// CHECK: cvtps2pd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x0f,0x5a,0x4c,0x02,0x40]
cvtps2pd 64(%edx,%eax), %xmm1

// CHECK: cvtps2pd (%edx), %xmm1
// CHECK: encoding: [0x0f,0x5a,0x0a]
cvtps2pd (%edx), %xmm1

// CHECK: cvtps2pd %xmm1, %xmm1
// CHECK: encoding: [0x0f,0x5a,0xc9]
cvtps2pd %xmm1, %xmm1

// CHECK: cvtsd2ss -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtsd2ss -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsd2ss 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtsd2ss 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsd2ss 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtsd2ss 485498096(%edx), %xmm1

// CHECK: cvtsd2ss 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtsd2ss 485498096, %xmm1

// CHECK: cvtsd2ss 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x4c,0x02,0x40]
cvtsd2ss 64(%edx,%eax), %xmm1

// CHECK: cvtsd2ss (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0x0a]
cvtsd2ss (%edx), %xmm1

// CHECK: cvtsd2ss %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5a,0xc9]
cvtsd2ss %xmm1, %xmm1

// CHECK: cvtsi2sdl -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtsi2sdl -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsi2sdl 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtsi2sdl 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtsi2sdl 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtsi2sdl 485498096(%edx), %xmm1

// CHECK: cvtsi2sdl 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtsi2sdl 485498096, %xmm1

// CHECK: cvtsi2sdl 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x4c,0x02,0x40]
cvtsi2sdl 64(%edx,%eax), %xmm1

// CHECK: cvtsi2sdl (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x2a,0x0a]
cvtsi2sdl (%edx), %xmm1

// CHECK: cvtss2sd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvtss2sd -485498096(%edx,%eax,4), %xmm1

// CHECK: cvtss2sd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvtss2sd 485498096(%edx,%eax,4), %xmm1

// CHECK: cvtss2sd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x8a,0xf0,0x1c,0xf0,0x1c]
cvtss2sd 485498096(%edx), %xmm1

// CHECK: cvtss2sd 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x0d,0xf0,0x1c,0xf0,0x1c]
cvtss2sd 485498096, %xmm1

// CHECK: cvtss2sd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x4c,0x02,0x40]
cvtss2sd 64(%edx,%eax), %xmm1

// CHECK: cvtss2sd (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0x0a]
cvtss2sd (%edx), %xmm1

// CHECK: cvtss2sd %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5a,0xc9]
cvtss2sd %xmm1, %xmm1

// CHECK: cvttpd2dq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvttpd2dq -485498096(%edx,%eax,4), %xmm1

// CHECK: cvttpd2dq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvttpd2dq 485498096(%edx,%eax,4), %xmm1

// CHECK: cvttpd2dq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x8a,0xf0,0x1c,0xf0,0x1c]
cvttpd2dq 485498096(%edx), %xmm1

// CHECK: cvttpd2dq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x0d,0xf0,0x1c,0xf0,0x1c]
cvttpd2dq 485498096, %xmm1

// CHECK: cvttpd2dq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x4c,0x02,0x40]
cvttpd2dq 64(%edx,%eax), %xmm1

// CHECK: cvttpd2dq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0x0a]
cvttpd2dq (%edx), %xmm1

// CHECK: cvttpd2dq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe6,0xc9]
cvttpd2dq %xmm1, %xmm1

// CHECK: cvttpd2pi -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
cvttpd2pi -485498096(%edx,%eax,4), %mm4

// CHECK: cvttpd2pi 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
cvttpd2pi 485498096(%edx,%eax,4), %mm4

// CHECK: cvttpd2pi 485498096(%edx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0xa2,0xf0,0x1c,0xf0,0x1c]
cvttpd2pi 485498096(%edx), %mm4

// CHECK: cvttpd2pi 485498096, %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x25,0xf0,0x1c,0xf0,0x1c]
cvttpd2pi 485498096, %mm4

// CHECK: cvttpd2pi 64(%edx,%eax), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x64,0x02,0x40]
cvttpd2pi 64(%edx,%eax), %mm4

// CHECK: cvttpd2pi (%edx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x22]
cvttpd2pi (%edx), %mm4

// CHECK: cvttpd2pi %xmm1, %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0xe1]
cvttpd2pi %xmm1, %mm4

// CHECK: cvttps2dq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
cvttps2dq -485498096(%edx,%eax,4), %xmm1

// CHECK: cvttps2dq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
cvttps2dq 485498096(%edx,%eax,4), %xmm1

// CHECK: cvttps2dq 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x8a,0xf0,0x1c,0xf0,0x1c]
cvttps2dq 485498096(%edx), %xmm1

// CHECK: cvttps2dq 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x0d,0xf0,0x1c,0xf0,0x1c]
cvttps2dq 485498096, %xmm1

// CHECK: cvttps2dq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x4c,0x02,0x40]
cvttps2dq 64(%edx,%eax), %xmm1

// CHECK: cvttps2dq (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0x0a]
cvttps2dq (%edx), %xmm1

// CHECK: cvttps2dq %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x5b,0xc9]
cvttps2dq %xmm1, %xmm1

// CHECK: divpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
divpd -485498096(%edx,%eax,4), %xmm1

// CHECK: divpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
divpd 485498096(%edx,%eax,4), %xmm1

// CHECK: divpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x8a,0xf0,0x1c,0xf0,0x1c]
divpd 485498096(%edx), %xmm1

// CHECK: divpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x0d,0xf0,0x1c,0xf0,0x1c]
divpd 485498096, %xmm1

// CHECK: divpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x4c,0x02,0x40]
divpd 64(%edx,%eax), %xmm1

// CHECK: divpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0x0a]
divpd (%edx), %xmm1

// CHECK: divpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5e,0xc9]
divpd %xmm1, %xmm1

// CHECK: divsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
divsd -485498096(%edx,%eax,4), %xmm1

// CHECK: divsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
divsd 485498096(%edx,%eax,4), %xmm1

// CHECK: divsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x8a,0xf0,0x1c,0xf0,0x1c]
divsd 485498096(%edx), %xmm1

// CHECK: divsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x0d,0xf0,0x1c,0xf0,0x1c]
divsd 485498096, %xmm1

// CHECK: divsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x4c,0x02,0x40]
divsd 64(%edx,%eax), %xmm1

// CHECK: divsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0x0a]
divsd (%edx), %xmm1

// CHECK: divsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5e,0xc9]
divsd %xmm1, %xmm1

// CHECK: lfence
// CHECK: encoding: [0x0f,0xae,0xe8]
lfence

// CHECK: maskmovdqu %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf7,0xc9]
maskmovdqu %xmm1, %xmm1

// CHECK: maxpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
maxpd -485498096(%edx,%eax,4), %xmm1

// CHECK: maxpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
maxpd 485498096(%edx,%eax,4), %xmm1

// CHECK: maxpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x8a,0xf0,0x1c,0xf0,0x1c]
maxpd 485498096(%edx), %xmm1

// CHECK: maxpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x0d,0xf0,0x1c,0xf0,0x1c]
maxpd 485498096, %xmm1

// CHECK: maxpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x4c,0x02,0x40]
maxpd 64(%edx,%eax), %xmm1

// CHECK: maxpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0x0a]
maxpd (%edx), %xmm1

// CHECK: maxpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5f,0xc9]
maxpd %xmm1, %xmm1

// CHECK: maxsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
maxsd -485498096(%edx,%eax,4), %xmm1

// CHECK: maxsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
maxsd 485498096(%edx,%eax,4), %xmm1

// CHECK: maxsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x8a,0xf0,0x1c,0xf0,0x1c]
maxsd 485498096(%edx), %xmm1

// CHECK: maxsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x0d,0xf0,0x1c,0xf0,0x1c]
maxsd 485498096, %xmm1

// CHECK: maxsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x4c,0x02,0x40]
maxsd 64(%edx,%eax), %xmm1

// CHECK: maxsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0x0a]
maxsd (%edx), %xmm1

// CHECK: maxsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5f,0xc9]
maxsd %xmm1, %xmm1

// CHECK: mfence
// CHECK: encoding: [0x0f,0xae,0xf0]
mfence

// CHECK: minpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
minpd -485498096(%edx,%eax,4), %xmm1

// CHECK: minpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
minpd 485498096(%edx,%eax,4), %xmm1

// CHECK: minpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x8a,0xf0,0x1c,0xf0,0x1c]
minpd 485498096(%edx), %xmm1

// CHECK: minpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x0d,0xf0,0x1c,0xf0,0x1c]
minpd 485498096, %xmm1

// CHECK: minpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x4c,0x02,0x40]
minpd 64(%edx,%eax), %xmm1

// CHECK: minpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0x0a]
minpd (%edx), %xmm1

// CHECK: minpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5d,0xc9]
minpd %xmm1, %xmm1

// CHECK: minsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
minsd -485498096(%edx,%eax,4), %xmm1

// CHECK: minsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
minsd 485498096(%edx,%eax,4), %xmm1

// CHECK: minsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x8a,0xf0,0x1c,0xf0,0x1c]
minsd 485498096(%edx), %xmm1

// CHECK: minsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x0d,0xf0,0x1c,0xf0,0x1c]
minsd 485498096, %xmm1

// CHECK: minsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x4c,0x02,0x40]
minsd 64(%edx,%eax), %xmm1

// CHECK: minsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0x0a]
minsd (%edx), %xmm1

// CHECK: minsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5d,0xc9]
minsd %xmm1, %xmm1

// CHECK: movapd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movapd -485498096(%edx,%eax,4), %xmm1

// CHECK: movapd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movapd 485498096(%edx,%eax,4), %xmm1

// CHECK: movapd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x8a,0xf0,0x1c,0xf0,0x1c]
movapd 485498096(%edx), %xmm1

// CHECK: movapd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x0d,0xf0,0x1c,0xf0,0x1c]
movapd 485498096, %xmm1

// CHECK: movapd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x4c,0x02,0x40]
movapd 64(%edx,%eax), %xmm1

// CHECK: movapd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0x0a]
movapd (%edx), %xmm1

// CHECK: movapd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x29,0x0d,0xf0,0x1c,0xf0,0x1c]
movapd %xmm1, 485498096

// CHECK: movapd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x29,0x8a,0xf0,0x1c,0xf0,0x1c]
movapd %xmm1, 485498096(%edx)

// CHECK: movapd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x29,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movapd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movapd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x29,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movapd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movapd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x29,0x4c,0x02,0x40]
movapd %xmm1, 64(%edx,%eax)

// CHECK: movapd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x29,0x0a]
movapd %xmm1, (%edx)

// CHECK: movapd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x28,0xc9]
movapd %xmm1, %xmm1

// CHECK: movd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movd -485498096(%edx,%eax,4), %xmm1

// CHECK: movd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movd 485498096(%edx,%eax,4), %xmm1

// CHECK: movd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x8a,0xf0,0x1c,0xf0,0x1c]
movd 485498096(%edx), %xmm1

// CHECK: movd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x0d,0xf0,0x1c,0xf0,0x1c]
movd 485498096, %xmm1

// CHECK: movd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x4c,0x02,0x40]
movd 64(%edx,%eax), %xmm1

// CHECK: movd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6e,0x0a]
movd (%edx), %xmm1

// CHECK: movdq2q %xmm1, %mm4
// CHECK: encoding: [0xf2,0x0f,0xd6,0xe1]
movdq2q %xmm1, %mm4

// CHECK: movdqa -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movdqa -485498096(%edx,%eax,4), %xmm1

// CHECK: movdqa 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movdqa 485498096(%edx,%eax,4), %xmm1

// CHECK: movdqa 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x8a,0xf0,0x1c,0xf0,0x1c]
movdqa 485498096(%edx), %xmm1

// CHECK: movdqa 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x0d,0xf0,0x1c,0xf0,0x1c]
movdqa 485498096, %xmm1

// CHECK: movdqa 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x4c,0x02,0x40]
movdqa 64(%edx,%eax), %xmm1

// CHECK: movdqa (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0x0a]
movdqa (%edx), %xmm1

// CHECK: movdqa %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x7f,0x0d,0xf0,0x1c,0xf0,0x1c]
movdqa %xmm1, 485498096

// CHECK: movdqa %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x7f,0x8a,0xf0,0x1c,0xf0,0x1c]
movdqa %xmm1, 485498096(%edx)

// CHECK: movdqa %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x7f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movdqa %xmm1, -485498096(%edx,%eax,4)

// CHECK: movdqa %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x7f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movdqa %xmm1, 485498096(%edx,%eax,4)

// CHECK: movdqa %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x7f,0x4c,0x02,0x40]
movdqa %xmm1, 64(%edx,%eax)

// CHECK: movdqa %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x7f,0x0a]
movdqa %xmm1, (%edx)

// CHECK: movdqa %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6f,0xc9]
movdqa %xmm1, %xmm1

// CHECK: movdqu -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movdqu -485498096(%edx,%eax,4), %xmm1

// CHECK: movdqu 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movdqu 485498096(%edx,%eax,4), %xmm1

// CHECK: movdqu 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x8a,0xf0,0x1c,0xf0,0x1c]
movdqu 485498096(%edx), %xmm1

// CHECK: movdqu 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x0d,0xf0,0x1c,0xf0,0x1c]
movdqu 485498096, %xmm1

// CHECK: movdqu 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x4c,0x02,0x40]
movdqu 64(%edx,%eax), %xmm1

// CHECK: movdqu (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0x0a]
movdqu (%edx), %xmm1

// CHECK: movdqu %xmm1, 485498096
// CHECK: encoding: [0xf3,0x0f,0x7f,0x0d,0xf0,0x1c,0xf0,0x1c]
movdqu %xmm1, 485498096

// CHECK: movdqu %xmm1, 485498096(%edx)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x8a,0xf0,0x1c,0xf0,0x1c]
movdqu %xmm1, 485498096(%edx)

// CHECK: movdqu %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movdqu %xmm1, -485498096(%edx,%eax,4)

// CHECK: movdqu %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movdqu %xmm1, 485498096(%edx,%eax,4)

// CHECK: movdqu %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x4c,0x02,0x40]
movdqu %xmm1, 64(%edx,%eax)

// CHECK: movdqu %xmm1, (%edx)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x0a]
movdqu %xmm1, (%edx)

// CHECK: movdqu %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x6f,0xc9]
movdqu %xmm1, %xmm1

// CHECK: movd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x7e,0x0d,0xf0,0x1c,0xf0,0x1c]
movd %xmm1, 485498096

// CHECK: movd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x7e,0x8a,0xf0,0x1c,0xf0,0x1c]
movd %xmm1, 485498096(%edx)

// CHECK: movd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x7e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x7e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x7e,0x4c,0x02,0x40]
movd %xmm1, 64(%edx,%eax)

// CHECK: movd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x7e,0x0a]
movd %xmm1, (%edx)

// CHECK: movhpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movhpd -485498096(%edx,%eax,4), %xmm1

// CHECK: movhpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movhpd 485498096(%edx,%eax,4), %xmm1

// CHECK: movhpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x8a,0xf0,0x1c,0xf0,0x1c]
movhpd 485498096(%edx), %xmm1

// CHECK: movhpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x0d,0xf0,0x1c,0xf0,0x1c]
movhpd 485498096, %xmm1

// CHECK: movhpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x4c,0x02,0x40]
movhpd 64(%edx,%eax), %xmm1

// CHECK: movhpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x16,0x0a]
movhpd (%edx), %xmm1

// CHECK: movhpd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x17,0x0d,0xf0,0x1c,0xf0,0x1c]
movhpd %xmm1, 485498096

// CHECK: movhpd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x17,0x8a,0xf0,0x1c,0xf0,0x1c]
movhpd %xmm1, 485498096(%edx)

// CHECK: movhpd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x17,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movhpd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movhpd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x17,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movhpd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movhpd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x17,0x4c,0x02,0x40]
movhpd %xmm1, 64(%edx,%eax)

// CHECK: movhpd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x17,0x0a]
movhpd %xmm1, (%edx)

// CHECK: movlpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movlpd -485498096(%edx,%eax,4), %xmm1

// CHECK: movlpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movlpd 485498096(%edx,%eax,4), %xmm1

// CHECK: movlpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x8a,0xf0,0x1c,0xf0,0x1c]
movlpd 485498096(%edx), %xmm1

// CHECK: movlpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x0d,0xf0,0x1c,0xf0,0x1c]
movlpd 485498096, %xmm1

// CHECK: movlpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x4c,0x02,0x40]
movlpd 64(%edx,%eax), %xmm1

// CHECK: movlpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x12,0x0a]
movlpd (%edx), %xmm1

// CHECK: movlpd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x13,0x0d,0xf0,0x1c,0xf0,0x1c]
movlpd %xmm1, 485498096

// CHECK: movlpd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x13,0x8a,0xf0,0x1c,0xf0,0x1c]
movlpd %xmm1, 485498096(%edx)

// CHECK: movlpd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x13,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movlpd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movlpd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x13,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movlpd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movlpd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x13,0x4c,0x02,0x40]
movlpd %xmm1, 64(%edx,%eax)

// CHECK: movlpd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x13,0x0a]
movlpd %xmm1, (%edx)

// CHECK: movntdq %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0xe7,0x0d,0xf0,0x1c,0xf0,0x1c]
movntdq %xmm1, 485498096

// CHECK: movntdq %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0xe7,0x8a,0xf0,0x1c,0xf0,0x1c]
movntdq %xmm1, 485498096(%edx)

// CHECK: movntdq %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0xe7,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movntdq %xmm1, -485498096(%edx,%eax,4)

// CHECK: movntdq %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0xe7,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movntdq %xmm1, 485498096(%edx,%eax,4)

// CHECK: movntdq %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0xe7,0x4c,0x02,0x40]
movntdq %xmm1, 64(%edx,%eax)

// CHECK: movntdq %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0xe7,0x0a]
movntdq %xmm1, (%edx)

// CHECK: movntpd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x2b,0x0d,0xf0,0x1c,0xf0,0x1c]
movntpd %xmm1, 485498096

// CHECK: movntpd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x2b,0x8a,0xf0,0x1c,0xf0,0x1c]
movntpd %xmm1, 485498096(%edx)

// CHECK: movntpd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x2b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movntpd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movntpd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x2b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movntpd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movntpd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x2b,0x4c,0x02,0x40]
movntpd %xmm1, 64(%edx,%eax)

// CHECK: movntpd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x2b,0x0a]
movntpd %xmm1, (%edx)

// CHECK: movq2dq %mm4, %xmm1
// CHECK: encoding: [0xf3,0x0f,0xd6,0xcc]
movq2dq %mm4, %xmm1

// CHECK: movq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movq -485498096(%edx,%eax,4), %xmm1

// CHECK: movq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movq 485498096(%edx,%eax,4), %xmm1

// CHECK: movq 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x8a,0xf0,0x1c,0xf0,0x1c]
movq 485498096(%edx), %xmm1

// CHECK: movq 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x0d,0xf0,0x1c,0xf0,0x1c]
movq 485498096, %xmm1

// CHECK: movq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x4c,0x02,0x40]
movq 64(%edx,%eax), %xmm1

// CHECK: movq (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0x0a]
movq (%edx), %xmm1

// CHECK: movq %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0xd6,0x0d,0xf0,0x1c,0xf0,0x1c]
movq %xmm1, 485498096

// CHECK: movq %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0xd6,0x8a,0xf0,0x1c,0xf0,0x1c]
movq %xmm1, 485498096(%edx)

// CHECK: movq %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0xd6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movq %xmm1, -485498096(%edx,%eax,4)

// CHECK: movq %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0xd6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movq %xmm1, 485498096(%edx,%eax,4)

// CHECK: movq %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0xd6,0x4c,0x02,0x40]
movq %xmm1, 64(%edx,%eax)

// CHECK: movq %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0xd6,0x0a]
movq %xmm1, (%edx)

// CHECK: movq %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x7e,0xc9]
movq %xmm1, %xmm1

// CHECK: movsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movsd -485498096(%edx,%eax,4), %xmm1

// CHECK: movsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movsd 485498096(%edx,%eax,4), %xmm1

// CHECK: movsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x8a,0xf0,0x1c,0xf0,0x1c]
movsd 485498096(%edx), %xmm1

// CHECK: movsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x0d,0xf0,0x1c,0xf0,0x1c]
movsd 485498096, %xmm1

// CHECK: movsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x4c,0x02,0x40]
movsd 64(%edx,%eax), %xmm1

// CHECK: movsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0x0a]
movsd (%edx), %xmm1

// CHECK: movsd %xmm1, 485498096
// CHECK: encoding: [0xf2,0x0f,0x11,0x0d,0xf0,0x1c,0xf0,0x1c]
movsd %xmm1, 485498096

// CHECK: movsd %xmm1, 485498096(%edx)
// CHECK: encoding: [0xf2,0x0f,0x11,0x8a,0xf0,0x1c,0xf0,0x1c]
movsd %xmm1, 485498096(%edx)

// CHECK: movsd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0xf2,0x0f,0x11,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movsd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movsd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0xf2,0x0f,0x11,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movsd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movsd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0xf2,0x0f,0x11,0x4c,0x02,0x40]
movsd %xmm1, 64(%edx,%eax)

// CHECK: movsd %xmm1, (%edx)
// CHECK: encoding: [0xf2,0x0f,0x11,0x0a]
movsd %xmm1, (%edx)

// CHECK: movsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x10,0xc9]
movsd %xmm1, %xmm1

// CHECK: movupd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movupd -485498096(%edx,%eax,4), %xmm1

// CHECK: movupd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movupd 485498096(%edx,%eax,4), %xmm1

// CHECK: movupd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x8a,0xf0,0x1c,0xf0,0x1c]
movupd 485498096(%edx), %xmm1

// CHECK: movupd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x0d,0xf0,0x1c,0xf0,0x1c]
movupd 485498096, %xmm1

// CHECK: movupd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x4c,0x02,0x40]
movupd 64(%edx,%eax), %xmm1

// CHECK: movupd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0x0a]
movupd (%edx), %xmm1

// CHECK: movupd %xmm1, 485498096
// CHECK: encoding: [0x66,0x0f,0x11,0x0d,0xf0,0x1c,0xf0,0x1c]
movupd %xmm1, 485498096

// CHECK: movupd %xmm1, 485498096(%edx)
// CHECK: encoding: [0x66,0x0f,0x11,0x8a,0xf0,0x1c,0xf0,0x1c]
movupd %xmm1, 485498096(%edx)

// CHECK: movupd %xmm1, -485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x11,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
movupd %xmm1, -485498096(%edx,%eax,4)

// CHECK: movupd %xmm1, 485498096(%edx,%eax,4)
// CHECK: encoding: [0x66,0x0f,0x11,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
movupd %xmm1, 485498096(%edx,%eax,4)

// CHECK: movupd %xmm1, 64(%edx,%eax)
// CHECK: encoding: [0x66,0x0f,0x11,0x4c,0x02,0x40]
movupd %xmm1, 64(%edx,%eax)

// CHECK: movupd %xmm1, (%edx)
// CHECK: encoding: [0x66,0x0f,0x11,0x0a]
movupd %xmm1, (%edx)

// CHECK: movupd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x10,0xc9]
movupd %xmm1, %xmm1

// CHECK: mulpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
mulpd -485498096(%edx,%eax,4), %xmm1

// CHECK: mulpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
mulpd 485498096(%edx,%eax,4), %xmm1

// CHECK: mulpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x8a,0xf0,0x1c,0xf0,0x1c]
mulpd 485498096(%edx), %xmm1

// CHECK: mulpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x0d,0xf0,0x1c,0xf0,0x1c]
mulpd 485498096, %xmm1

// CHECK: mulpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x4c,0x02,0x40]
mulpd 64(%edx,%eax), %xmm1

// CHECK: mulpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0x0a]
mulpd (%edx), %xmm1

// CHECK: mulpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x59,0xc9]
mulpd %xmm1, %xmm1

// CHECK: mulsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
mulsd -485498096(%edx,%eax,4), %xmm1

// CHECK: mulsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
mulsd 485498096(%edx,%eax,4), %xmm1

// CHECK: mulsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x8a,0xf0,0x1c,0xf0,0x1c]
mulsd 485498096(%edx), %xmm1

// CHECK: mulsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x0d,0xf0,0x1c,0xf0,0x1c]
mulsd 485498096, %xmm1

// CHECK: mulsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x4c,0x02,0x40]
mulsd 64(%edx,%eax), %xmm1

// CHECK: mulsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0x0a]
mulsd (%edx), %xmm1

// CHECK: mulsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x59,0xc9]
mulsd %xmm1, %xmm1

// CHECK: orpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
orpd -485498096(%edx,%eax,4), %xmm1

// CHECK: orpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
orpd 485498096(%edx,%eax,4), %xmm1

// CHECK: orpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x8a,0xf0,0x1c,0xf0,0x1c]
orpd 485498096(%edx), %xmm1

// CHECK: orpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x0d,0xf0,0x1c,0xf0,0x1c]
orpd 485498096, %xmm1

// CHECK: orpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x4c,0x02,0x40]
orpd 64(%edx,%eax), %xmm1

// CHECK: orpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0x0a]
orpd (%edx), %xmm1

// CHECK: orpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x56,0xc9]
orpd %xmm1, %xmm1

// CHECK: packssdw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
packssdw -485498096(%edx,%eax,4), %xmm1

// CHECK: packssdw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
packssdw 485498096(%edx,%eax,4), %xmm1

// CHECK: packssdw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x8a,0xf0,0x1c,0xf0,0x1c]
packssdw 485498096(%edx), %xmm1

// CHECK: packssdw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x0d,0xf0,0x1c,0xf0,0x1c]
packssdw 485498096, %xmm1

// CHECK: packssdw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x4c,0x02,0x40]
packssdw 64(%edx,%eax), %xmm1

// CHECK: packssdw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0x0a]
packssdw (%edx), %xmm1

// CHECK: packssdw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6b,0xc9]
packssdw %xmm1, %xmm1

// CHECK: packsswb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
packsswb -485498096(%edx,%eax,4), %xmm1

// CHECK: packsswb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
packsswb 485498096(%edx,%eax,4), %xmm1

// CHECK: packsswb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x8a,0xf0,0x1c,0xf0,0x1c]
packsswb 485498096(%edx), %xmm1

// CHECK: packsswb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x0d,0xf0,0x1c,0xf0,0x1c]
packsswb 485498096, %xmm1

// CHECK: packsswb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x4c,0x02,0x40]
packsswb 64(%edx,%eax), %xmm1

// CHECK: packsswb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0x0a]
packsswb (%edx), %xmm1

// CHECK: packsswb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x63,0xc9]
packsswb %xmm1, %xmm1

// CHECK: packuswb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
packuswb -485498096(%edx,%eax,4), %xmm1

// CHECK: packuswb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
packuswb 485498096(%edx,%eax,4), %xmm1

// CHECK: packuswb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x8a,0xf0,0x1c,0xf0,0x1c]
packuswb 485498096(%edx), %xmm1

// CHECK: packuswb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x0d,0xf0,0x1c,0xf0,0x1c]
packuswb 485498096, %xmm1

// CHECK: packuswb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x4c,0x02,0x40]
packuswb 64(%edx,%eax), %xmm1

// CHECK: packuswb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0x0a]
packuswb (%edx), %xmm1

// CHECK: packuswb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x67,0xc9]
packuswb %xmm1, %xmm1

// CHECK: paddb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddb -485498096(%edx,%eax,4), %xmm1

// CHECK: paddb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddb 485498096(%edx,%eax,4), %xmm1

// CHECK: paddb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x8a,0xf0,0x1c,0xf0,0x1c]
paddb 485498096(%edx), %xmm1

// CHECK: paddb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x0d,0xf0,0x1c,0xf0,0x1c]
paddb 485498096, %xmm1

// CHECK: paddb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x4c,0x02,0x40]
paddb 64(%edx,%eax), %xmm1

// CHECK: paddb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0x0a]
paddb (%edx), %xmm1

// CHECK: paddb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfc,0xc9]
paddb %xmm1, %xmm1

// CHECK: paddd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddd -485498096(%edx,%eax,4), %xmm1

// CHECK: paddd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddd 485498096(%edx,%eax,4), %xmm1

// CHECK: paddd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x8a,0xf0,0x1c,0xf0,0x1c]
paddd 485498096(%edx), %xmm1

// CHECK: paddd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x0d,0xf0,0x1c,0xf0,0x1c]
paddd 485498096, %xmm1

// CHECK: paddd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x4c,0x02,0x40]
paddd 64(%edx,%eax), %xmm1

// CHECK: paddd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0x0a]
paddd (%edx), %xmm1

// CHECK: paddd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfe,0xc9]
paddd %xmm1, %xmm1

// CHECK: paddq -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xd4,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
paddq -485498096(%edx,%eax,4), %mm4

// CHECK: paddq 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xd4,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
paddq 485498096(%edx,%eax,4), %mm4

// CHECK: paddq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddq -485498096(%edx,%eax,4), %xmm1

// CHECK: paddq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddq 485498096(%edx,%eax,4), %xmm1

// CHECK: paddq 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0xd4,0xa2,0xf0,0x1c,0xf0,0x1c]
paddq 485498096(%edx), %mm4

// CHECK: paddq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x8a,0xf0,0x1c,0xf0,0x1c]
paddq 485498096(%edx), %xmm1

// CHECK: paddq 485498096, %mm4
// CHECK: encoding: [0x0f,0xd4,0x25,0xf0,0x1c,0xf0,0x1c]
paddq 485498096, %mm4

// CHECK: paddq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x0d,0xf0,0x1c,0xf0,0x1c]
paddq 485498096, %xmm1

// CHECK: paddq 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0xd4,0x64,0x02,0x40]
paddq 64(%edx,%eax), %mm4

// CHECK: paddq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x4c,0x02,0x40]
paddq 64(%edx,%eax), %xmm1

// CHECK: paddq (%edx), %mm4
// CHECK: encoding: [0x0f,0xd4,0x22]
paddq (%edx), %mm4

// CHECK: paddq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0x0a]
paddq (%edx), %xmm1

// CHECK: paddq %mm4, %mm4
// CHECK: encoding: [0x0f,0xd4,0xe4]
paddq %mm4, %mm4

// CHECK: paddq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd4,0xc9]
paddq %xmm1, %xmm1

// CHECK: paddsb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddsb -485498096(%edx,%eax,4), %xmm1

// CHECK: paddsb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddsb 485498096(%edx,%eax,4), %xmm1

// CHECK: paddsb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x8a,0xf0,0x1c,0xf0,0x1c]
paddsb 485498096(%edx), %xmm1

// CHECK: paddsb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x0d,0xf0,0x1c,0xf0,0x1c]
paddsb 485498096, %xmm1

// CHECK: paddsb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x4c,0x02,0x40]
paddsb 64(%edx,%eax), %xmm1

// CHECK: paddsb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0x0a]
paddsb (%edx), %xmm1

// CHECK: paddsb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xec,0xc9]
paddsb %xmm1, %xmm1

// CHECK: paddsw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddsw -485498096(%edx,%eax,4), %xmm1

// CHECK: paddsw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddsw 485498096(%edx,%eax,4), %xmm1

// CHECK: paddsw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x8a,0xf0,0x1c,0xf0,0x1c]
paddsw 485498096(%edx), %xmm1

// CHECK: paddsw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x0d,0xf0,0x1c,0xf0,0x1c]
paddsw 485498096, %xmm1

// CHECK: paddsw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x4c,0x02,0x40]
paddsw 64(%edx,%eax), %xmm1

// CHECK: paddsw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0x0a]
paddsw (%edx), %xmm1

// CHECK: paddsw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xed,0xc9]
paddsw %xmm1, %xmm1

// CHECK: paddusb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddusb -485498096(%edx,%eax,4), %xmm1

// CHECK: paddusb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddusb 485498096(%edx,%eax,4), %xmm1

// CHECK: paddusb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x8a,0xf0,0x1c,0xf0,0x1c]
paddusb 485498096(%edx), %xmm1

// CHECK: paddusb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x0d,0xf0,0x1c,0xf0,0x1c]
paddusb 485498096, %xmm1

// CHECK: paddusb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x4c,0x02,0x40]
paddusb 64(%edx,%eax), %xmm1

// CHECK: paddusb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0x0a]
paddusb (%edx), %xmm1

// CHECK: paddusb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdc,0xc9]
paddusb %xmm1, %xmm1

// CHECK: paddusw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddusw -485498096(%edx,%eax,4), %xmm1

// CHECK: paddusw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddusw 485498096(%edx,%eax,4), %xmm1

// CHECK: paddusw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x8a,0xf0,0x1c,0xf0,0x1c]
paddusw 485498096(%edx), %xmm1

// CHECK: paddusw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x0d,0xf0,0x1c,0xf0,0x1c]
paddusw 485498096, %xmm1

// CHECK: paddusw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x4c,0x02,0x40]
paddusw 64(%edx,%eax), %xmm1

// CHECK: paddusw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0x0a]
paddusw (%edx), %xmm1

// CHECK: paddusw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdd,0xc9]
paddusw %xmm1, %xmm1

// CHECK: paddw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
paddw -485498096(%edx,%eax,4), %xmm1

// CHECK: paddw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
paddw 485498096(%edx,%eax,4), %xmm1

// CHECK: paddw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x8a,0xf0,0x1c,0xf0,0x1c]
paddw 485498096(%edx), %xmm1

// CHECK: paddw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x0d,0xf0,0x1c,0xf0,0x1c]
paddw 485498096, %xmm1

// CHECK: paddw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x4c,0x02,0x40]
paddw 64(%edx,%eax), %xmm1

// CHECK: paddw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0x0a]
paddw (%edx), %xmm1

// CHECK: paddw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfd,0xc9]
paddw %xmm1, %xmm1

// CHECK: pand -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pand -485498096(%edx,%eax,4), %xmm1

// CHECK: pand 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pand 485498096(%edx,%eax,4), %xmm1

// CHECK: pand 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x8a,0xf0,0x1c,0xf0,0x1c]
pand 485498096(%edx), %xmm1

// CHECK: pand 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x0d,0xf0,0x1c,0xf0,0x1c]
pand 485498096, %xmm1

// CHECK: pand 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x4c,0x02,0x40]
pand 64(%edx,%eax), %xmm1

// CHECK: pand (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0x0a]
pand (%edx), %xmm1

// CHECK: pandn -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pandn -485498096(%edx,%eax,4), %xmm1

// CHECK: pandn 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pandn 485498096(%edx,%eax,4), %xmm1

// CHECK: pandn 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x8a,0xf0,0x1c,0xf0,0x1c]
pandn 485498096(%edx), %xmm1

// CHECK: pandn 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x0d,0xf0,0x1c,0xf0,0x1c]
pandn 485498096, %xmm1

// CHECK: pandn 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x4c,0x02,0x40]
pandn 64(%edx,%eax), %xmm1

// CHECK: pandn (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0x0a]
pandn (%edx), %xmm1

// CHECK: pandn %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdf,0xc9]
pandn %xmm1, %xmm1

// CHECK: pand %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xdb,0xc9]
pand %xmm1, %xmm1

// CHECK: pavgb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pavgb -485498096(%edx,%eax,4), %xmm1

// CHECK: pavgb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pavgb 485498096(%edx,%eax,4), %xmm1

// CHECK: pavgb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x8a,0xf0,0x1c,0xf0,0x1c]
pavgb 485498096(%edx), %xmm1

// CHECK: pavgb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x0d,0xf0,0x1c,0xf0,0x1c]
pavgb 485498096, %xmm1

// CHECK: pavgb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x4c,0x02,0x40]
pavgb 64(%edx,%eax), %xmm1

// CHECK: pavgb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0x0a]
pavgb (%edx), %xmm1

// CHECK: pavgb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe0,0xc9]
pavgb %xmm1, %xmm1

// CHECK: pavgw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pavgw -485498096(%edx,%eax,4), %xmm1

// CHECK: pavgw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pavgw 485498096(%edx,%eax,4), %xmm1

// CHECK: pavgw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x8a,0xf0,0x1c,0xf0,0x1c]
pavgw 485498096(%edx), %xmm1

// CHECK: pavgw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x0d,0xf0,0x1c,0xf0,0x1c]
pavgw 485498096, %xmm1

// CHECK: pavgw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x4c,0x02,0x40]
pavgw 64(%edx,%eax), %xmm1

// CHECK: pavgw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0x0a]
pavgw (%edx), %xmm1

// CHECK: pavgw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe3,0xc9]
pavgw %xmm1, %xmm1

// CHECK: pcmpeqb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpeqb -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpeqb 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpeqb 485498096(%edx), %xmm1

// CHECK: pcmpeqb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpeqb 485498096, %xmm1

// CHECK: pcmpeqb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x4c,0x02,0x40]
pcmpeqb 64(%edx,%eax), %xmm1

// CHECK: pcmpeqb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0x0a]
pcmpeqb (%edx), %xmm1

// CHECK: pcmpeqb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x74,0xc9]
pcmpeqb %xmm1, %xmm1

// CHECK: pcmpeqd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpeqd -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpeqd 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpeqd 485498096(%edx), %xmm1

// CHECK: pcmpeqd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpeqd 485498096, %xmm1

// CHECK: pcmpeqd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x4c,0x02,0x40]
pcmpeqd 64(%edx,%eax), %xmm1

// CHECK: pcmpeqd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0x0a]
pcmpeqd (%edx), %xmm1

// CHECK: pcmpeqd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x76,0xc9]
pcmpeqd %xmm1, %xmm1

// CHECK: pcmpeqw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpeqw -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpeqw 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpeqw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpeqw 485498096(%edx), %xmm1

// CHECK: pcmpeqw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpeqw 485498096, %xmm1

// CHECK: pcmpeqw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x4c,0x02,0x40]
pcmpeqw 64(%edx,%eax), %xmm1

// CHECK: pcmpeqw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0x0a]
pcmpeqw (%edx), %xmm1

// CHECK: pcmpeqw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x75,0xc9]
pcmpeqw %xmm1, %xmm1

// CHECK: pcmpgtb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpgtb -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpgtb 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpgtb 485498096(%edx), %xmm1

// CHECK: pcmpgtb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpgtb 485498096, %xmm1

// CHECK: pcmpgtb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x4c,0x02,0x40]
pcmpgtb 64(%edx,%eax), %xmm1

// CHECK: pcmpgtb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0x0a]
pcmpgtb (%edx), %xmm1

// CHECK: pcmpgtb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x64,0xc9]
pcmpgtb %xmm1, %xmm1

// CHECK: pcmpgtd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpgtd -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpgtd 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpgtd 485498096(%edx), %xmm1

// CHECK: pcmpgtd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpgtd 485498096, %xmm1

// CHECK: pcmpgtd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x4c,0x02,0x40]
pcmpgtd 64(%edx,%eax), %xmm1

// CHECK: pcmpgtd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0x0a]
pcmpgtd (%edx), %xmm1

// CHECK: pcmpgtd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x66,0xc9]
pcmpgtd %xmm1, %xmm1

// CHECK: pcmpgtw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pcmpgtw -485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pcmpgtw 485498096(%edx,%eax,4), %xmm1

// CHECK: pcmpgtw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x8a,0xf0,0x1c,0xf0,0x1c]
pcmpgtw 485498096(%edx), %xmm1

// CHECK: pcmpgtw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x0d,0xf0,0x1c,0xf0,0x1c]
pcmpgtw 485498096, %xmm1

// CHECK: pcmpgtw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x4c,0x02,0x40]
pcmpgtw 64(%edx,%eax), %xmm1

// CHECK: pcmpgtw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0x0a]
pcmpgtw (%edx), %xmm1

// CHECK: pcmpgtw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x65,0xc9]
pcmpgtw %xmm1, %xmm1

// CHECK: pextrw $0, %xmm1, %eax
// CHECK: encoding: [0x66,0x0f,0xc5,0xc1,0x00]
pextrw $0, %xmm1, %eax

// CHECK: pinsrw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pinsrw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pinsrw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096(%edx), %xmm1

// CHECK: pinsrw $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096, %xmm1

// CHECK: pinsrw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x4c,0x02,0x40,0x00]
pinsrw $0, 64(%edx,%eax), %xmm1

// CHECK: pinsrw $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc4,0x0a,0x00]
pinsrw $0, (%edx), %xmm1

// CHECK: pmaddwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaddwd -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaddwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaddwd 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaddwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaddwd 485498096(%edx), %xmm1

// CHECK: pmaddwd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaddwd 485498096, %xmm1

// CHECK: pmaddwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x4c,0x02,0x40]
pmaddwd 64(%edx,%eax), %xmm1

// CHECK: pmaddwd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0x0a]
pmaddwd (%edx), %xmm1

// CHECK: pmaddwd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf5,0xc9]
pmaddwd %xmm1, %xmm1

// CHECK: pmaxsw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxsw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxsw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxsw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxsw 485498096(%edx), %xmm1

// CHECK: pmaxsw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxsw 485498096, %xmm1

// CHECK: pmaxsw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x4c,0x02,0x40]
pmaxsw 64(%edx,%eax), %xmm1

// CHECK: pmaxsw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0x0a]
pmaxsw (%edx), %xmm1

// CHECK: pmaxsw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xee,0xc9]
pmaxsw %xmm1, %xmm1

// CHECK: pmaxub -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmaxub -485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxub 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmaxub 485498096(%edx,%eax,4), %xmm1

// CHECK: pmaxub 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x8a,0xf0,0x1c,0xf0,0x1c]
pmaxub 485498096(%edx), %xmm1

// CHECK: pmaxub 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x0d,0xf0,0x1c,0xf0,0x1c]
pmaxub 485498096, %xmm1

// CHECK: pmaxub 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x4c,0x02,0x40]
pmaxub 64(%edx,%eax), %xmm1

// CHECK: pmaxub (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0x0a]
pmaxub (%edx), %xmm1

// CHECK: pmaxub %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xde,0xc9]
pmaxub %xmm1, %xmm1

// CHECK: pminsw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminsw -485498096(%edx,%eax,4), %xmm1

// CHECK: pminsw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminsw 485498096(%edx,%eax,4), %xmm1

// CHECK: pminsw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x8a,0xf0,0x1c,0xf0,0x1c]
pminsw 485498096(%edx), %xmm1

// CHECK: pminsw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x0d,0xf0,0x1c,0xf0,0x1c]
pminsw 485498096, %xmm1

// CHECK: pminsw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x4c,0x02,0x40]
pminsw 64(%edx,%eax), %xmm1

// CHECK: pminsw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0x0a]
pminsw (%edx), %xmm1

// CHECK: pminsw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xea,0xc9]
pminsw %xmm1, %xmm1

// CHECK: pminub -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pminub -485498096(%edx,%eax,4), %xmm1

// CHECK: pminub 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pminub 485498096(%edx,%eax,4), %xmm1

// CHECK: pminub 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x8a,0xf0,0x1c,0xf0,0x1c]
pminub 485498096(%edx), %xmm1

// CHECK: pminub 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x0d,0xf0,0x1c,0xf0,0x1c]
pminub 485498096, %xmm1

// CHECK: pminub 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x4c,0x02,0x40]
pminub 64(%edx,%eax), %xmm1

// CHECK: pminub (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0x0a]
pminub (%edx), %xmm1

// CHECK: pminub %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xda,0xc9]
pminub %xmm1, %xmm1

// CHECK: pmulhuw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmulhuw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmulhuw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmulhuw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmulhuw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x8a,0xf0,0x1c,0xf0,0x1c]
pmulhuw 485498096(%edx), %xmm1

// CHECK: pmulhuw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x0d,0xf0,0x1c,0xf0,0x1c]
pmulhuw 485498096, %xmm1

// CHECK: pmulhuw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x4c,0x02,0x40]
pmulhuw 64(%edx,%eax), %xmm1

// CHECK: pmulhuw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0x0a]
pmulhuw (%edx), %xmm1

// CHECK: pmulhuw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe4,0xc9]
pmulhuw %xmm1, %xmm1

// CHECK: pmulhw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmulhw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmulhw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmulhw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmulhw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x8a,0xf0,0x1c,0xf0,0x1c]
pmulhw 485498096(%edx), %xmm1

// CHECK: pmulhw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x0d,0xf0,0x1c,0xf0,0x1c]
pmulhw 485498096, %xmm1

// CHECK: pmulhw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x4c,0x02,0x40]
pmulhw 64(%edx,%eax), %xmm1

// CHECK: pmulhw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0x0a]
pmulhw (%edx), %xmm1

// CHECK: pmulhw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe5,0xc9]
pmulhw %xmm1, %xmm1

// CHECK: pmullw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmullw -485498096(%edx,%eax,4), %xmm1

// CHECK: pmullw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmullw 485498096(%edx,%eax,4), %xmm1

// CHECK: pmullw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x8a,0xf0,0x1c,0xf0,0x1c]
pmullw 485498096(%edx), %xmm1

// CHECK: pmullw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x0d,0xf0,0x1c,0xf0,0x1c]
pmullw 485498096, %xmm1

// CHECK: pmullw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x4c,0x02,0x40]
pmullw 64(%edx,%eax), %xmm1

// CHECK: pmullw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0x0a]
pmullw (%edx), %xmm1

// CHECK: pmullw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd5,0xc9]
pmullw %xmm1, %xmm1

// CHECK: pmuludq -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xf4,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
pmuludq -485498096(%edx,%eax,4), %mm4

// CHECK: pmuludq 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xf4,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096(%edx,%eax,4), %mm4

// CHECK: pmuludq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pmuludq -485498096(%edx,%eax,4), %xmm1

// CHECK: pmuludq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096(%edx,%eax,4), %xmm1

// CHECK: pmuludq 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0xf4,0xa2,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096(%edx), %mm4

// CHECK: pmuludq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x8a,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096(%edx), %xmm1

// CHECK: pmuludq 485498096, %mm4
// CHECK: encoding: [0x0f,0xf4,0x25,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096, %mm4

// CHECK: pmuludq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x0d,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096, %xmm1

// CHECK: pmuludq 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0xf4,0x64,0x02,0x40]
pmuludq 64(%edx,%eax), %mm4

// CHECK: pmuludq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x4c,0x02,0x40]
pmuludq 64(%edx,%eax), %xmm1

// CHECK: pmuludq (%edx), %mm4
// CHECK: encoding: [0x0f,0xf4,0x22]
pmuludq (%edx), %mm4

// CHECK: pmuludq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0x0a]
pmuludq (%edx), %xmm1

// CHECK: pmuludq %mm4, %mm4
// CHECK: encoding: [0x0f,0xf4,0xe4]
pmuludq %mm4, %mm4

// CHECK: pmuludq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf4,0xc9]
pmuludq %xmm1, %xmm1

// CHECK: por -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
por -485498096(%edx,%eax,4), %xmm1

// CHECK: por 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
por 485498096(%edx,%eax,4), %xmm1

// CHECK: por 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x8a,0xf0,0x1c,0xf0,0x1c]
por 485498096(%edx), %xmm1

// CHECK: por 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x0d,0xf0,0x1c,0xf0,0x1c]
por 485498096, %xmm1

// CHECK: por 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x4c,0x02,0x40]
por 64(%edx,%eax), %xmm1

// CHECK: por (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0x0a]
por (%edx), %xmm1

// CHECK: por %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xeb,0xc9]
por %xmm1, %xmm1

// CHECK: psadbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psadbw -485498096(%edx,%eax,4), %xmm1

// CHECK: psadbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psadbw 485498096(%edx,%eax,4), %xmm1

// CHECK: psadbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x8a,0xf0,0x1c,0xf0,0x1c]
psadbw 485498096(%edx), %xmm1

// CHECK: psadbw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x0d,0xf0,0x1c,0xf0,0x1c]
psadbw 485498096, %xmm1

// CHECK: psadbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x4c,0x02,0x40]
psadbw 64(%edx,%eax), %xmm1

// CHECK: psadbw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0x0a]
psadbw (%edx), %xmm1

// CHECK: psadbw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf6,0xc9]
psadbw %xmm1, %xmm1

// CHECK: pshufd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pshufd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pshufd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pshufd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pshufd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pshufd $0, 485498096(%edx), %xmm1

// CHECK: pshufd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pshufd $0, 485498096, %xmm1

// CHECK: pshufd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x4c,0x02,0x40,0x00]
pshufd $0, 64(%edx,%eax), %xmm1

// CHECK: pshufd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0x0a,0x00]
pshufd $0, (%edx), %xmm1

// CHECK: pshufd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x70,0xc9,0x00]
pshufd $0, %xmm1, %xmm1

// CHECK: pshufhw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pshufhw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pshufhw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pshufhw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pshufhw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pshufhw $0, 485498096(%edx), %xmm1

// CHECK: pshufhw $0, 485498096, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pshufhw $0, 485498096, %xmm1

// CHECK: pshufhw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x4c,0x02,0x40,0x00]
pshufhw $0, 64(%edx,%eax), %xmm1

// CHECK: pshufhw $0, (%edx), %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0x0a,0x00]
pshufhw $0, (%edx), %xmm1

// CHECK: pshufhw $0, %xmm1, %xmm1
// CHECK: encoding: [0xf3,0x0f,0x70,0xc9,0x00]
pshufhw $0, %xmm1, %xmm1

// CHECK: pshuflw $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
pshuflw $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: pshuflw $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
pshuflw $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: pshuflw $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
pshuflw $0, 485498096(%edx), %xmm1

// CHECK: pshuflw $0, 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
pshuflw $0, 485498096, %xmm1

// CHECK: pshuflw $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x4c,0x02,0x40,0x00]
pshuflw $0, 64(%edx,%eax), %xmm1

// CHECK: pshuflw $0, (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0x0a,0x00]
pshuflw $0, (%edx), %xmm1

// CHECK: pshuflw $0, %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x70,0xc9,0x00]
pshuflw $0, %xmm1, %xmm1

// CHECK: pslld $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x72,0xf1,0x00]
pslld $0, %xmm1

// CHECK: pslld -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pslld -485498096(%edx,%eax,4), %xmm1

// CHECK: pslld 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pslld 485498096(%edx,%eax,4), %xmm1

// CHECK: pslld 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x8a,0xf0,0x1c,0xf0,0x1c]
pslld 485498096(%edx), %xmm1

// CHECK: pslld 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x0d,0xf0,0x1c,0xf0,0x1c]
pslld 485498096, %xmm1

// CHECK: pslld 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x4c,0x02,0x40]
pslld 64(%edx,%eax), %xmm1

// CHECK: pslld (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0x0a]
pslld (%edx), %xmm1

// CHECK: pslldq $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x73,0xf9,0x00]
pslldq $0, %xmm1

// CHECK: pslld %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf2,0xc9]
pslld %xmm1, %xmm1

// CHECK: psllq $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x73,0xf1,0x00]
psllq $0, %xmm1

// CHECK: psllq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psllq -485498096(%edx,%eax,4), %xmm1

// CHECK: psllq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psllq 485498096(%edx,%eax,4), %xmm1

// CHECK: psllq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x8a,0xf0,0x1c,0xf0,0x1c]
psllq 485498096(%edx), %xmm1

// CHECK: psllq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x0d,0xf0,0x1c,0xf0,0x1c]
psllq 485498096, %xmm1

// CHECK: psllq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x4c,0x02,0x40]
psllq 64(%edx,%eax), %xmm1

// CHECK: psllq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0x0a]
psllq (%edx), %xmm1

// CHECK: psllq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf3,0xc9]
psllq %xmm1, %xmm1

// CHECK: psllw $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x71,0xf1,0x00]
psllw $0, %xmm1

// CHECK: psllw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psllw -485498096(%edx,%eax,4), %xmm1

// CHECK: psllw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psllw 485498096(%edx,%eax,4), %xmm1

// CHECK: psllw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x8a,0xf0,0x1c,0xf0,0x1c]
psllw 485498096(%edx), %xmm1

// CHECK: psllw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x0d,0xf0,0x1c,0xf0,0x1c]
psllw 485498096, %xmm1

// CHECK: psllw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x4c,0x02,0x40]
psllw 64(%edx,%eax), %xmm1

// CHECK: psllw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0x0a]
psllw (%edx), %xmm1

// CHECK: psllw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf1,0xc9]
psllw %xmm1, %xmm1

// CHECK: psrad $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x72,0xe1,0x00]
psrad $0, %xmm1

// CHECK: psrad -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psrad -485498096(%edx,%eax,4), %xmm1

// CHECK: psrad 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psrad 485498096(%edx,%eax,4), %xmm1

// CHECK: psrad 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x8a,0xf0,0x1c,0xf0,0x1c]
psrad 485498096(%edx), %xmm1

// CHECK: psrad 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x0d,0xf0,0x1c,0xf0,0x1c]
psrad 485498096, %xmm1

// CHECK: psrad 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x4c,0x02,0x40]
psrad 64(%edx,%eax), %xmm1

// CHECK: psrad (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0x0a]
psrad (%edx), %xmm1

// CHECK: psrad %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe2,0xc9]
psrad %xmm1, %xmm1

// CHECK: psraw $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x71,0xe1,0x00]
psraw $0, %xmm1

// CHECK: psraw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psraw -485498096(%edx,%eax,4), %xmm1

// CHECK: psraw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psraw 485498096(%edx,%eax,4), %xmm1

// CHECK: psraw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x8a,0xf0,0x1c,0xf0,0x1c]
psraw 485498096(%edx), %xmm1

// CHECK: psraw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x0d,0xf0,0x1c,0xf0,0x1c]
psraw 485498096, %xmm1

// CHECK: psraw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x4c,0x02,0x40]
psraw 64(%edx,%eax), %xmm1

// CHECK: psraw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0x0a]
psraw (%edx), %xmm1

// CHECK: psraw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe1,0xc9]
psraw %xmm1, %xmm1

// CHECK: psrld $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x72,0xd1,0x00]
psrld $0, %xmm1

// CHECK: psrld -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psrld -485498096(%edx,%eax,4), %xmm1

// CHECK: psrld 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psrld 485498096(%edx,%eax,4), %xmm1

// CHECK: psrld 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x8a,0xf0,0x1c,0xf0,0x1c]
psrld 485498096(%edx), %xmm1

// CHECK: psrld 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x0d,0xf0,0x1c,0xf0,0x1c]
psrld 485498096, %xmm1

// CHECK: psrld 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x4c,0x02,0x40]
psrld 64(%edx,%eax), %xmm1

// CHECK: psrld (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0x0a]
psrld (%edx), %xmm1

// CHECK: psrldq $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x73,0xd9,0x00]
psrldq $0, %xmm1

// CHECK: psrld %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd2,0xc9]
psrld %xmm1, %xmm1

// CHECK: psrlq $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x73,0xd1,0x00]
psrlq $0, %xmm1

// CHECK: psrlq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psrlq -485498096(%edx,%eax,4), %xmm1

// CHECK: psrlq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psrlq 485498096(%edx,%eax,4), %xmm1

// CHECK: psrlq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x8a,0xf0,0x1c,0xf0,0x1c]
psrlq 485498096(%edx), %xmm1

// CHECK: psrlq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x0d,0xf0,0x1c,0xf0,0x1c]
psrlq 485498096, %xmm1

// CHECK: psrlq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x4c,0x02,0x40]
psrlq 64(%edx,%eax), %xmm1

// CHECK: psrlq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0x0a]
psrlq (%edx), %xmm1

// CHECK: psrlq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd3,0xc9]
psrlq %xmm1, %xmm1

// CHECK: psrlw $0, %xmm1
// CHECK: encoding: [0x66,0x0f,0x71,0xd1,0x00]
psrlw $0, %xmm1

// CHECK: psrlw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psrlw -485498096(%edx,%eax,4), %xmm1

// CHECK: psrlw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psrlw 485498096(%edx,%eax,4), %xmm1

// CHECK: psrlw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x8a,0xf0,0x1c,0xf0,0x1c]
psrlw 485498096(%edx), %xmm1

// CHECK: psrlw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x0d,0xf0,0x1c,0xf0,0x1c]
psrlw 485498096, %xmm1

// CHECK: psrlw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x4c,0x02,0x40]
psrlw 64(%edx,%eax), %xmm1

// CHECK: psrlw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0x0a]
psrlw (%edx), %xmm1

// CHECK: psrlw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd1,0xc9]
psrlw %xmm1, %xmm1

// CHECK: psubb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubb -485498096(%edx,%eax,4), %xmm1

// CHECK: psubb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubb 485498096(%edx,%eax,4), %xmm1

// CHECK: psubb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x8a,0xf0,0x1c,0xf0,0x1c]
psubb 485498096(%edx), %xmm1

// CHECK: psubb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x0d,0xf0,0x1c,0xf0,0x1c]
psubb 485498096, %xmm1

// CHECK: psubb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x4c,0x02,0x40]
psubb 64(%edx,%eax), %xmm1

// CHECK: psubb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0x0a]
psubb (%edx), %xmm1

// CHECK: psubb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf8,0xc9]
psubb %xmm1, %xmm1

// CHECK: psubd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubd -485498096(%edx,%eax,4), %xmm1

// CHECK: psubd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubd 485498096(%edx,%eax,4), %xmm1

// CHECK: psubd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x8a,0xf0,0x1c,0xf0,0x1c]
psubd 485498096(%edx), %xmm1

// CHECK: psubd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x0d,0xf0,0x1c,0xf0,0x1c]
psubd 485498096, %xmm1

// CHECK: psubd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x4c,0x02,0x40]
psubd 64(%edx,%eax), %xmm1

// CHECK: psubd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0x0a]
psubd (%edx), %xmm1

// CHECK: psubd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfa,0xc9]
psubd %xmm1, %xmm1

// CHECK: psubq -485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xfb,0xa4,0x82,0x10,0xe3,0x0f,0xe3]
psubq -485498096(%edx,%eax,4), %mm4

// CHECK: psubq 485498096(%edx,%eax,4), %mm4
// CHECK: encoding: [0x0f,0xfb,0xa4,0x82,0xf0,0x1c,0xf0,0x1c]
psubq 485498096(%edx,%eax,4), %mm4

// CHECK: psubq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubq -485498096(%edx,%eax,4), %xmm1

// CHECK: psubq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubq 485498096(%edx,%eax,4), %xmm1

// CHECK: psubq 485498096(%edx), %mm4
// CHECK: encoding: [0x0f,0xfb,0xa2,0xf0,0x1c,0xf0,0x1c]
psubq 485498096(%edx), %mm4

// CHECK: psubq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x8a,0xf0,0x1c,0xf0,0x1c]
psubq 485498096(%edx), %xmm1

// CHECK: psubq 485498096, %mm4
// CHECK: encoding: [0x0f,0xfb,0x25,0xf0,0x1c,0xf0,0x1c]
psubq 485498096, %mm4

// CHECK: psubq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x0d,0xf0,0x1c,0xf0,0x1c]
psubq 485498096, %xmm1

// CHECK: psubq 64(%edx,%eax), %mm4
// CHECK: encoding: [0x0f,0xfb,0x64,0x02,0x40]
psubq 64(%edx,%eax), %mm4

// CHECK: psubq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x4c,0x02,0x40]
psubq 64(%edx,%eax), %xmm1

// CHECK: psubq (%edx), %mm4
// CHECK: encoding: [0x0f,0xfb,0x22]
psubq (%edx), %mm4

// CHECK: psubq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0x0a]
psubq (%edx), %xmm1

// CHECK: psubq %mm4, %mm4
// CHECK: encoding: [0x0f,0xfb,0xe4]
psubq %mm4, %mm4

// CHECK: psubq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xfb,0xc9]
psubq %xmm1, %xmm1

// CHECK: psubsb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubsb -485498096(%edx,%eax,4), %xmm1

// CHECK: psubsb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubsb 485498096(%edx,%eax,4), %xmm1

// CHECK: psubsb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x8a,0xf0,0x1c,0xf0,0x1c]
psubsb 485498096(%edx), %xmm1

// CHECK: psubsb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x0d,0xf0,0x1c,0xf0,0x1c]
psubsb 485498096, %xmm1

// CHECK: psubsb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x4c,0x02,0x40]
psubsb 64(%edx,%eax), %xmm1

// CHECK: psubsb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0x0a]
psubsb (%edx), %xmm1

// CHECK: psubsb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe8,0xc9]
psubsb %xmm1, %xmm1

// CHECK: psubsw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubsw -485498096(%edx,%eax,4), %xmm1

// CHECK: psubsw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubsw 485498096(%edx,%eax,4), %xmm1

// CHECK: psubsw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x8a,0xf0,0x1c,0xf0,0x1c]
psubsw 485498096(%edx), %xmm1

// CHECK: psubsw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x0d,0xf0,0x1c,0xf0,0x1c]
psubsw 485498096, %xmm1

// CHECK: psubsw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x4c,0x02,0x40]
psubsw 64(%edx,%eax), %xmm1

// CHECK: psubsw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0x0a]
psubsw (%edx), %xmm1

// CHECK: psubsw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xe9,0xc9]
psubsw %xmm1, %xmm1

// CHECK: psubusb -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubusb -485498096(%edx,%eax,4), %xmm1

// CHECK: psubusb 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubusb 485498096(%edx,%eax,4), %xmm1

// CHECK: psubusb 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x8a,0xf0,0x1c,0xf0,0x1c]
psubusb 485498096(%edx), %xmm1

// CHECK: psubusb 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x0d,0xf0,0x1c,0xf0,0x1c]
psubusb 485498096, %xmm1

// CHECK: psubusb 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x4c,0x02,0x40]
psubusb 64(%edx,%eax), %xmm1

// CHECK: psubusb (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0x0a]
psubusb (%edx), %xmm1

// CHECK: psubusb %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd8,0xc9]
psubusb %xmm1, %xmm1

// CHECK: psubusw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubusw -485498096(%edx,%eax,4), %xmm1

// CHECK: psubusw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubusw 485498096(%edx,%eax,4), %xmm1

// CHECK: psubusw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x8a,0xf0,0x1c,0xf0,0x1c]
psubusw 485498096(%edx), %xmm1

// CHECK: psubusw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x0d,0xf0,0x1c,0xf0,0x1c]
psubusw 485498096, %xmm1

// CHECK: psubusw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x4c,0x02,0x40]
psubusw 64(%edx,%eax), %xmm1

// CHECK: psubusw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0x0a]
psubusw (%edx), %xmm1

// CHECK: psubusw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xd9,0xc9]
psubusw %xmm1, %xmm1

// CHECK: psubw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
psubw -485498096(%edx,%eax,4), %xmm1

// CHECK: psubw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
psubw 485498096(%edx,%eax,4), %xmm1

// CHECK: psubw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x8a,0xf0,0x1c,0xf0,0x1c]
psubw 485498096(%edx), %xmm1

// CHECK: psubw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x0d,0xf0,0x1c,0xf0,0x1c]
psubw 485498096, %xmm1

// CHECK: psubw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x4c,0x02,0x40]
psubw 64(%edx,%eax), %xmm1

// CHECK: psubw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0x0a]
psubw (%edx), %xmm1

// CHECK: psubw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xf9,0xc9]
psubw %xmm1, %xmm1

// CHECK: punpckhbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpckhbw -485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpckhbw 485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x8a,0xf0,0x1c,0xf0,0x1c]
punpckhbw 485498096(%edx), %xmm1

// CHECK: punpckhbw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x0d,0xf0,0x1c,0xf0,0x1c]
punpckhbw 485498096, %xmm1

// CHECK: punpckhbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x4c,0x02,0x40]
punpckhbw 64(%edx,%eax), %xmm1

// CHECK: punpckhbw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0x0a]
punpckhbw (%edx), %xmm1

// CHECK: punpckhbw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x68,0xc9]
punpckhbw %xmm1, %xmm1

// CHECK: punpckhdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpckhdq -485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpckhdq 485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x8a,0xf0,0x1c,0xf0,0x1c]
punpckhdq 485498096(%edx), %xmm1

// CHECK: punpckhdq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x0d,0xf0,0x1c,0xf0,0x1c]
punpckhdq 485498096, %xmm1

// CHECK: punpckhdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x4c,0x02,0x40]
punpckhdq 64(%edx,%eax), %xmm1

// CHECK: punpckhdq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0x0a]
punpckhdq (%edx), %xmm1

// CHECK: punpckhdq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6a,0xc9]
punpckhdq %xmm1, %xmm1

// CHECK: punpckhqdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpckhqdq -485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhqdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpckhqdq 485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhqdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x8a,0xf0,0x1c,0xf0,0x1c]
punpckhqdq 485498096(%edx), %xmm1

// CHECK: punpckhqdq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x0d,0xf0,0x1c,0xf0,0x1c]
punpckhqdq 485498096, %xmm1

// CHECK: punpckhqdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x4c,0x02,0x40]
punpckhqdq 64(%edx,%eax), %xmm1

// CHECK: punpckhqdq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0x0a]
punpckhqdq (%edx), %xmm1

// CHECK: punpckhqdq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6d,0xc9]
punpckhqdq %xmm1, %xmm1

// CHECK: punpckhwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpckhwd -485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpckhwd 485498096(%edx,%eax,4), %xmm1

// CHECK: punpckhwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x8a,0xf0,0x1c,0xf0,0x1c]
punpckhwd 485498096(%edx), %xmm1

// CHECK: punpckhwd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x0d,0xf0,0x1c,0xf0,0x1c]
punpckhwd 485498096, %xmm1

// CHECK: punpckhwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x4c,0x02,0x40]
punpckhwd 64(%edx,%eax), %xmm1

// CHECK: punpckhwd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0x0a]
punpckhwd (%edx), %xmm1

// CHECK: punpckhwd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x69,0xc9]
punpckhwd %xmm1, %xmm1

// CHECK: punpcklbw -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpcklbw -485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklbw 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpcklbw 485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklbw 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x8a,0xf0,0x1c,0xf0,0x1c]
punpcklbw 485498096(%edx), %xmm1

// CHECK: punpcklbw 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x0d,0xf0,0x1c,0xf0,0x1c]
punpcklbw 485498096, %xmm1

// CHECK: punpcklbw 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x4c,0x02,0x40]
punpcklbw 64(%edx,%eax), %xmm1

// CHECK: punpcklbw (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0x0a]
punpcklbw (%edx), %xmm1

// CHECK: punpcklbw %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x60,0xc9]
punpcklbw %xmm1, %xmm1

// CHECK: punpckldq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpckldq -485498096(%edx,%eax,4), %xmm1

// CHECK: punpckldq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpckldq 485498096(%edx,%eax,4), %xmm1

// CHECK: punpckldq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x8a,0xf0,0x1c,0xf0,0x1c]
punpckldq 485498096(%edx), %xmm1

// CHECK: punpckldq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x0d,0xf0,0x1c,0xf0,0x1c]
punpckldq 485498096, %xmm1

// CHECK: punpckldq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x4c,0x02,0x40]
punpckldq 64(%edx,%eax), %xmm1

// CHECK: punpckldq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0x0a]
punpckldq (%edx), %xmm1

// CHECK: punpckldq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x62,0xc9]
punpckldq %xmm1, %xmm1

// CHECK: punpcklqdq -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpcklqdq -485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklqdq 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpcklqdq 485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklqdq 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x8a,0xf0,0x1c,0xf0,0x1c]
punpcklqdq 485498096(%edx), %xmm1

// CHECK: punpcklqdq 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x0d,0xf0,0x1c,0xf0,0x1c]
punpcklqdq 485498096, %xmm1

// CHECK: punpcklqdq 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x4c,0x02,0x40]
punpcklqdq 64(%edx,%eax), %xmm1

// CHECK: punpcklqdq (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0x0a]
punpcklqdq (%edx), %xmm1

// CHECK: punpcklqdq %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x6c,0xc9]
punpcklqdq %xmm1, %xmm1

// CHECK: punpcklwd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
punpcklwd -485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklwd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
punpcklwd 485498096(%edx,%eax,4), %xmm1

// CHECK: punpcklwd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x8a,0xf0,0x1c,0xf0,0x1c]
punpcklwd 485498096(%edx), %xmm1

// CHECK: punpcklwd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x0d,0xf0,0x1c,0xf0,0x1c]
punpcklwd 485498096, %xmm1

// CHECK: punpcklwd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x4c,0x02,0x40]
punpcklwd 64(%edx,%eax), %xmm1

// CHECK: punpcklwd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0x0a]
punpcklwd (%edx), %xmm1

// CHECK: punpcklwd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x61,0xc9]
punpcklwd %xmm1, %xmm1

// CHECK: pxor -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
pxor -485498096(%edx,%eax,4), %xmm1

// CHECK: pxor 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
pxor 485498096(%edx,%eax,4), %xmm1

// CHECK: pxor 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x8a,0xf0,0x1c,0xf0,0x1c]
pxor 485498096(%edx), %xmm1

// CHECK: pxor 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x0d,0xf0,0x1c,0xf0,0x1c]
pxor 485498096, %xmm1

// CHECK: pxor 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x4c,0x02,0x40]
pxor 64(%edx,%eax), %xmm1

// CHECK: pxor (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0x0a]
pxor (%edx), %xmm1

// CHECK: pxor %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xef,0xc9]
pxor %xmm1, %xmm1

// CHECK: shufpd $0, -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x8c,0x82,0x10,0xe3,0x0f,0xe3,0x00]
shufpd $0, -485498096(%edx,%eax,4), %xmm1

// CHECK: shufpd $0, 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x8c,0x82,0xf0,0x1c,0xf0,0x1c,0x00]
shufpd $0, 485498096(%edx,%eax,4), %xmm1

// CHECK: shufpd $0, 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x8a,0xf0,0x1c,0xf0,0x1c,0x00]
shufpd $0, 485498096(%edx), %xmm1

// CHECK: shufpd $0, 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x0d,0xf0,0x1c,0xf0,0x1c,0x00]
shufpd $0, 485498096, %xmm1

// CHECK: shufpd $0, 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x4c,0x02,0x40,0x00]
shufpd $0, 64(%edx,%eax), %xmm1

// CHECK: shufpd $0, (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0x0a,0x00]
shufpd $0, (%edx), %xmm1

// CHECK: shufpd $0, %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0xc6,0xc9,0x00]
shufpd $0, %xmm1, %xmm1

// CHECK: sqrtpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
sqrtpd -485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
sqrtpd 485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x8a,0xf0,0x1c,0xf0,0x1c]
sqrtpd 485498096(%edx), %xmm1

// CHECK: sqrtpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x0d,0xf0,0x1c,0xf0,0x1c]
sqrtpd 485498096, %xmm1

// CHECK: sqrtpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x4c,0x02,0x40]
sqrtpd 64(%edx,%eax), %xmm1

// CHECK: sqrtpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0x0a]
sqrtpd (%edx), %xmm1

// CHECK: sqrtpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x51,0xc9]
sqrtpd %xmm1, %xmm1

// CHECK: sqrtsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
sqrtsd -485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
sqrtsd 485498096(%edx,%eax,4), %xmm1

// CHECK: sqrtsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x8a,0xf0,0x1c,0xf0,0x1c]
sqrtsd 485498096(%edx), %xmm1

// CHECK: sqrtsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x0d,0xf0,0x1c,0xf0,0x1c]
sqrtsd 485498096, %xmm1

// CHECK: sqrtsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x4c,0x02,0x40]
sqrtsd 64(%edx,%eax), %xmm1

// CHECK: sqrtsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0x0a]
sqrtsd (%edx), %xmm1

// CHECK: sqrtsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x51,0xc9]
sqrtsd %xmm1, %xmm1

// CHECK: subpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
subpd -485498096(%edx,%eax,4), %xmm1

// CHECK: subpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
subpd 485498096(%edx,%eax,4), %xmm1

// CHECK: subpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x8a,0xf0,0x1c,0xf0,0x1c]
subpd 485498096(%edx), %xmm1

// CHECK: subpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x0d,0xf0,0x1c,0xf0,0x1c]
subpd 485498096, %xmm1

// CHECK: subpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x4c,0x02,0x40]
subpd 64(%edx,%eax), %xmm1

// CHECK: subpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0x0a]
subpd (%edx), %xmm1

// CHECK: subpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x5c,0xc9]
subpd %xmm1, %xmm1

// CHECK: subsd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
subsd -485498096(%edx,%eax,4), %xmm1

// CHECK: subsd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
subsd 485498096(%edx,%eax,4), %xmm1

// CHECK: subsd 485498096(%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x8a,0xf0,0x1c,0xf0,0x1c]
subsd 485498096(%edx), %xmm1

// CHECK: subsd 485498096, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x0d,0xf0,0x1c,0xf0,0x1c]
subsd 485498096, %xmm1

// CHECK: subsd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x4c,0x02,0x40]
subsd 64(%edx,%eax), %xmm1

// CHECK: subsd (%edx), %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0x0a]
subsd (%edx), %xmm1

// CHECK: subsd %xmm1, %xmm1
// CHECK: encoding: [0xf2,0x0f,0x5c,0xc9]
subsd %xmm1, %xmm1

// CHECK: ucomisd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
ucomisd -485498096(%edx,%eax,4), %xmm1

// CHECK: ucomisd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
ucomisd 485498096(%edx,%eax,4), %xmm1

// CHECK: ucomisd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x8a,0xf0,0x1c,0xf0,0x1c]
ucomisd 485498096(%edx), %xmm1

// CHECK: ucomisd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x0d,0xf0,0x1c,0xf0,0x1c]
ucomisd 485498096, %xmm1

// CHECK: ucomisd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x4c,0x02,0x40]
ucomisd 64(%edx,%eax), %xmm1

// CHECK: ucomisd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0x0a]
ucomisd (%edx), %xmm1

// CHECK: ucomisd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x2e,0xc9]
ucomisd %xmm1, %xmm1

// CHECK: unpckhpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
unpckhpd -485498096(%edx,%eax,4), %xmm1

// CHECK: unpckhpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
unpckhpd 485498096(%edx,%eax,4), %xmm1

// CHECK: unpckhpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x8a,0xf0,0x1c,0xf0,0x1c]
unpckhpd 485498096(%edx), %xmm1

// CHECK: unpckhpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x0d,0xf0,0x1c,0xf0,0x1c]
unpckhpd 485498096, %xmm1

// CHECK: unpckhpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x4c,0x02,0x40]
unpckhpd 64(%edx,%eax), %xmm1

// CHECK: unpckhpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0x0a]
unpckhpd (%edx), %xmm1

// CHECK: unpckhpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x15,0xc9]
unpckhpd %xmm1, %xmm1

// CHECK: unpcklpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
unpcklpd -485498096(%edx,%eax,4), %xmm1

// CHECK: unpcklpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
unpcklpd 485498096(%edx,%eax,4), %xmm1

// CHECK: unpcklpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x8a,0xf0,0x1c,0xf0,0x1c]
unpcklpd 485498096(%edx), %xmm1

// CHECK: unpcklpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x0d,0xf0,0x1c,0xf0,0x1c]
unpcklpd 485498096, %xmm1

// CHECK: unpcklpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x4c,0x02,0x40]
unpcklpd 64(%edx,%eax), %xmm1

// CHECK: unpcklpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0x0a]
unpcklpd (%edx), %xmm1

// CHECK: unpcklpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x14,0xc9]
unpcklpd %xmm1, %xmm1

// CHECK: xorpd -485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x8c,0x82,0x10,0xe3,0x0f,0xe3]
xorpd -485498096(%edx,%eax,4), %xmm1

// CHECK: xorpd 485498096(%edx,%eax,4), %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x8c,0x82,0xf0,0x1c,0xf0,0x1c]
xorpd 485498096(%edx,%eax,4), %xmm1

// CHECK: xorpd 485498096(%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x8a,0xf0,0x1c,0xf0,0x1c]
xorpd 485498096(%edx), %xmm1

// CHECK: xorpd 485498096, %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x0d,0xf0,0x1c,0xf0,0x1c]
xorpd 485498096, %xmm1

// CHECK: xorpd 64(%edx,%eax), %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x4c,0x02,0x40]
xorpd 64(%edx,%eax), %xmm1

// CHECK: xorpd (%edx), %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0x0a]
xorpd (%edx), %xmm1

// CHECK: xorpd %xmm1, %xmm1
// CHECK: encoding: [0x66,0x0f,0x57,0xc9]
xorpd %xmm1, %xmm1

