// RUN: llvm-mc -triple=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

v_mad_legacy_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xff,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x65,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x66,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x67,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x80,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xff,0x0f,0x04]

v_mad_legacy_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0c,0x04]

v_mad_legacy_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_legacy_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_legacy_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_legacy_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_legacy_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_legacy_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_legacy_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_legacy_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_legacy_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_legacy_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_legacy_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_legacy_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_legacy_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xff,0x0c,0x04]

v_mad_legacy_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x01,0x0d,0x04]

v_mad_legacy_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x83,0x0d,0x04]

v_mad_legacy_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_legacy_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xef,0x0d,0x04]

v_mad_legacy_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_legacy_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_legacy_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_legacy_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xfe,0x07]

v_mad_legacy_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x00]

v_mad_legacy_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x96,0x01]

v_mad_legacy_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x9a,0x01]

v_mad_legacy_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x9e,0x01]

v_mad_legacy_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xaa,0x01]

v_mad_legacy_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xae,0x01]

v_mad_legacy_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xb2,0x01]

v_mad_legacy_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xb6,0x01]

v_mad_legacy_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xba,0x01]

v_mad_legacy_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xbe,0x01]

v_mad_legacy_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xee,0x01]

v_mad_legacy_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xf2,0x01]

v_mad_legacy_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xfa,0x01]

v_mad_legacy_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xfe,0x01]

v_mad_legacy_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x02,0x02]

v_mad_legacy_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x06,0x03]

v_mad_legacy_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xc2,0x03]

v_mad_legacy_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xde,0x03]

v_mad_legacy_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xee,0x03]

v_mad_legacy_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xf2,0x03]

v_mad_legacy_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0xf6,0x03]

v_mad_legacy_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x24]

v_mad_legacy_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x44]

v_mad_legacy_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x84]

v_mad_legacy_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0xe4]

v_mad_legacy_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc0,0xd1,0x01,0x05,0x0e,0x04]

v_mad_legacy_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x0c]

v_mad_legacy_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x14]

v_mad_legacy_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc0,0xd1,0x01,0x05,0x0e,0x1c]

v_mad_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xff,0x05,0x0e,0x04]

v_mad_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x04,0x0e,0x04]

v_mad_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x65,0x04,0x0e,0x04]

v_mad_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x66,0x04,0x0e,0x04]

v_mad_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x67,0x04,0x0e,0x04]

v_mad_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x80,0x04,0x0e,0x04]

v_mad_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xff,0x0f,0x04]

v_mad_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0c,0x04]

v_mad_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xff,0x0c,0x04]

v_mad_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x01,0x0d,0x04]

v_mad_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x83,0x0d,0x04]

v_mad_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xef,0x0d,0x04]

v_mad_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xfe,0x07]

v_mad_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x00]

v_mad_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x96,0x01]

v_mad_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x9a,0x01]

v_mad_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x9e,0x01]

v_mad_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xaa,0x01]

v_mad_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xae,0x01]

v_mad_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xb2,0x01]

v_mad_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xb6,0x01]

v_mad_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xba,0x01]

v_mad_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xbe,0x01]

v_mad_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xee,0x01]

v_mad_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xf2,0x01]

v_mad_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xfa,0x01]

v_mad_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xfe,0x01]

v_mad_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x02,0x02]

v_mad_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x06,0x03]

v_mad_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xc2,0x03]

v_mad_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xde,0x03]

v_mad_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xee,0x03]

v_mad_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xf2,0x03]

v_mad_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0xf6,0x03]

v_mad_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x24]

v_mad_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x44]

v_mad_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x84]

v_mad_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0xe4]

v_mad_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc1,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x0c]

v_mad_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x14]

v_mad_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc1,0xd1,0x01,0x05,0x0e,0x1c]

v_mad_i32_i24 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc2,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i32_i24 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xff,0x05,0x0e,0x04]

v_mad_i32_i24 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x04,0x0e,0x04]

v_mad_i32_i24 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x65,0x04,0x0e,0x04]

v_mad_i32_i24 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x66,0x04,0x0e,0x04]

v_mad_i32_i24 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x67,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_i32_i24 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_i32_i24 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_i32_i24 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_i32_i24 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_i32_i24 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_i32_i24 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_i32_i24 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_i32_i24 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x80,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_i32_i24 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_i32_i24 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_i32_i24 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_i32_i24 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_i32_i24 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_i32_i24 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_i32_i24 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xff,0x0f,0x04]

v_mad_i32_i24 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x0c,0x04]

v_mad_i32_i24 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_i32_i24 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_i32_i24 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_i32_i24 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_i32_i24 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_i32_i24 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_i32_i24 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_i32_i24 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_i32_i24 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_i32_i24 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_i32_i24 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xff,0x0c,0x04]

v_mad_i32_i24 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x01,0x0d,0x04]

v_mad_i32_i24 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x83,0x0d,0x04]

v_mad_i32_i24 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_i32_i24 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xef,0x0d,0x04]

v_mad_i32_i24 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_i32_i24 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_i32_i24 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_i32_i24 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xfe,0x07]

v_mad_i32_i24 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x0e,0x00]

v_mad_i32_i24 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x96,0x01]

v_mad_i32_i24 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x9a,0x01]

v_mad_i32_i24 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x9e,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xaa,0x01]

v_mad_i32_i24 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xae,0x01]

v_mad_i32_i24 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xb2,0x01]

v_mad_i32_i24 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xb6,0x01]

v_mad_i32_i24 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xba,0x01]

v_mad_i32_i24 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xbe,0x01]

v_mad_i32_i24 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xee,0x01]

v_mad_i32_i24 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xf2,0x01]

v_mad_i32_i24 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xfa,0x01]

v_mad_i32_i24 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xfe,0x01]

v_mad_i32_i24 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x02,0x02]

v_mad_i32_i24 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0x06,0x03]

v_mad_i32_i24 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xc2,0x03]

v_mad_i32_i24 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xde,0x03]

v_mad_i32_i24 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xee,0x03]

v_mad_i32_i24 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xf2,0x03]

v_mad_i32_i24 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc2,0xd1,0x01,0x05,0xf6,0x03]

v_mad_i32_i24 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc2,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc3,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u32_u24 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xff,0x05,0x0e,0x04]

v_mad_u32_u24 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x04,0x0e,0x04]

v_mad_u32_u24 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x65,0x04,0x0e,0x04]

v_mad_u32_u24 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x66,0x04,0x0e,0x04]

v_mad_u32_u24 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x67,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_u32_u24 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_u32_u24 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_u32_u24 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_u32_u24 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_u32_u24 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_u32_u24 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_u32_u24 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_u32_u24 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x80,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_u32_u24 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_u32_u24 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_u32_u24 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_u32_u24 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_u32_u24 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_u32_u24 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_u32_u24 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xff,0x0f,0x04]

v_mad_u32_u24 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x0c,0x04]

v_mad_u32_u24 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_u32_u24 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_u32_u24 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_u32_u24 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_u32_u24 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_u32_u24 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_u32_u24 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_u32_u24 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_u32_u24 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_u32_u24 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_u32_u24 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xff,0x0c,0x04]

v_mad_u32_u24 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x01,0x0d,0x04]

v_mad_u32_u24 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x83,0x0d,0x04]

v_mad_u32_u24 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_u32_u24 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xef,0x0d,0x04]

v_mad_u32_u24 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_u32_u24 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_u32_u24 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_u32_u24 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xfe,0x07]

v_mad_u32_u24 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x0e,0x00]

v_mad_u32_u24 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x96,0x01]

v_mad_u32_u24 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x9a,0x01]

v_mad_u32_u24 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x9e,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xaa,0x01]

v_mad_u32_u24 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xae,0x01]

v_mad_u32_u24 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xb2,0x01]

v_mad_u32_u24 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xb6,0x01]

v_mad_u32_u24 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xba,0x01]

v_mad_u32_u24 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xbe,0x01]

v_mad_u32_u24 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xee,0x01]

v_mad_u32_u24 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xf2,0x01]

v_mad_u32_u24 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xfa,0x01]

v_mad_u32_u24 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xfe,0x01]

v_mad_u32_u24 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x02,0x02]

v_mad_u32_u24 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0x06,0x03]

v_mad_u32_u24 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xc2,0x03]

v_mad_u32_u24 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xde,0x03]

v_mad_u32_u24 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xee,0x03]

v_mad_u32_u24 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xf2,0x03]

v_mad_u32_u24 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc3,0xd1,0x01,0x05,0xf6,0x03]

v_mad_u32_u24 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc3,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xff,0x05,0x0e,0x04]

v_cubeid_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x04,0x0e,0x04]

v_cubeid_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x65,0x04,0x0e,0x04]

v_cubeid_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x66,0x04,0x0e,0x04]

v_cubeid_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x67,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6a,0x04,0x0e,0x04]

v_cubeid_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6b,0x04,0x0e,0x04]

v_cubeid_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6c,0x04,0x0e,0x04]

v_cubeid_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6d,0x04,0x0e,0x04]

v_cubeid_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6e,0x04,0x0e,0x04]

v_cubeid_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x6f,0x04,0x0e,0x04]

v_cubeid_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x7b,0x04,0x0e,0x04]

v_cubeid_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x7c,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x7e,0x04,0x0e,0x04]

v_cubeid_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x7f,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x80,0x04,0x0e,0x04]

v_cubeid_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xc1,0x04,0x0e,0x04]

v_cubeid_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xf0,0x04,0x0e,0x04]

v_cubeid_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xf7,0x04,0x0e,0x04]

v_cubeid_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xfb,0x04,0x0e,0x04]

v_cubeid_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xfc,0x04,0x0e,0x04]

v_cubeid_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xfd,0x04,0x0e,0x04]

v_cubeid_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0xfe,0x04,0x0e,0x04]

v_cubeid_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xff,0x0f,0x04]

v_cubeid_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0c,0x04]

v_cubeid_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xcb,0x0c,0x04]

v_cubeid_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xcd,0x0c,0x04]

v_cubeid_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xcf,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xd5,0x0c,0x04]

v_cubeid_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xd7,0x0c,0x04]

v_cubeid_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xd9,0x0c,0x04]

v_cubeid_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xdb,0x0c,0x04]

v_cubeid_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xdd,0x0c,0x04]

v_cubeid_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xdf,0x0c,0x04]

v_cubeid_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xf7,0x0c,0x04]

v_cubeid_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xf9,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xfd,0x0c,0x04]

v_cubeid_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xff,0x0c,0x04]

v_cubeid_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x01,0x0d,0x04]

v_cubeid_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x83,0x0d,0x04]

v_cubeid_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xe1,0x0d,0x04]

v_cubeid_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xef,0x0d,0x04]

v_cubeid_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xf7,0x0d,0x04]

v_cubeid_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xf9,0x0d,0x04]

v_cubeid_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0xfb,0x0d,0x04]

v_cubeid_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xfe,0x07]

v_cubeid_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x00]

v_cubeid_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x96,0x01]

v_cubeid_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x9a,0x01]

v_cubeid_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x9e,0x01]

v_cubeid_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xaa,0x01]

v_cubeid_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xae,0x01]

v_cubeid_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xb2,0x01]

v_cubeid_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xb6,0x01]

v_cubeid_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xba,0x01]

v_cubeid_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xbe,0x01]

v_cubeid_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xee,0x01]

v_cubeid_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xf2,0x01]

v_cubeid_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xfa,0x01]

v_cubeid_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xfe,0x01]

v_cubeid_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x02,0x02]

v_cubeid_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x06,0x03]

v_cubeid_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xc2,0x03]

v_cubeid_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xde,0x03]

v_cubeid_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xee,0x03]

v_cubeid_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xf2,0x03]

v_cubeid_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0xf6,0x03]

v_cubeid_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x24]

v_cubeid_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x44]

v_cubeid_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x84]

v_cubeid_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0xe4]

v_cubeid_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc4,0xd1,0x01,0x05,0x0e,0x04]

v_cubeid_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x0c]

v_cubeid_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x14]

v_cubeid_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc4,0xd1,0x01,0x05,0x0e,0x1c]

v_cubesc_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xff,0x05,0x0e,0x04]

v_cubesc_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x04,0x0e,0x04]

v_cubesc_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x65,0x04,0x0e,0x04]

v_cubesc_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x66,0x04,0x0e,0x04]

v_cubesc_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x67,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6a,0x04,0x0e,0x04]

v_cubesc_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6b,0x04,0x0e,0x04]

v_cubesc_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6c,0x04,0x0e,0x04]

v_cubesc_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6d,0x04,0x0e,0x04]

v_cubesc_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6e,0x04,0x0e,0x04]

v_cubesc_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x6f,0x04,0x0e,0x04]

v_cubesc_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x7b,0x04,0x0e,0x04]

v_cubesc_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x7c,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x7e,0x04,0x0e,0x04]

v_cubesc_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x7f,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x80,0x04,0x0e,0x04]

v_cubesc_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xc1,0x04,0x0e,0x04]

v_cubesc_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xf0,0x04,0x0e,0x04]

v_cubesc_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xf7,0x04,0x0e,0x04]

v_cubesc_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xfb,0x04,0x0e,0x04]

v_cubesc_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xfc,0x04,0x0e,0x04]

v_cubesc_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xfd,0x04,0x0e,0x04]

v_cubesc_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0xfe,0x04,0x0e,0x04]

v_cubesc_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xff,0x0f,0x04]

v_cubesc_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0c,0x04]

v_cubesc_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xcb,0x0c,0x04]

v_cubesc_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xcd,0x0c,0x04]

v_cubesc_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xcf,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xd5,0x0c,0x04]

v_cubesc_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xd7,0x0c,0x04]

v_cubesc_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xd9,0x0c,0x04]

v_cubesc_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xdb,0x0c,0x04]

v_cubesc_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xdd,0x0c,0x04]

v_cubesc_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xdf,0x0c,0x04]

v_cubesc_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xf7,0x0c,0x04]

v_cubesc_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xf9,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xfd,0x0c,0x04]

v_cubesc_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xff,0x0c,0x04]

v_cubesc_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x01,0x0d,0x04]

v_cubesc_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x83,0x0d,0x04]

v_cubesc_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xe1,0x0d,0x04]

v_cubesc_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xef,0x0d,0x04]

v_cubesc_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xf7,0x0d,0x04]

v_cubesc_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xf9,0x0d,0x04]

v_cubesc_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0xfb,0x0d,0x04]

v_cubesc_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xfe,0x07]

v_cubesc_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x00]

v_cubesc_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x96,0x01]

v_cubesc_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x9a,0x01]

v_cubesc_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x9e,0x01]

v_cubesc_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xaa,0x01]

v_cubesc_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xae,0x01]

v_cubesc_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xb2,0x01]

v_cubesc_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xb6,0x01]

v_cubesc_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xba,0x01]

v_cubesc_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xbe,0x01]

v_cubesc_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xee,0x01]

v_cubesc_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xf2,0x01]

v_cubesc_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xfa,0x01]

v_cubesc_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xfe,0x01]

v_cubesc_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x02,0x02]

v_cubesc_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x06,0x03]

v_cubesc_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xc2,0x03]

v_cubesc_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xde,0x03]

v_cubesc_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xee,0x03]

v_cubesc_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xf2,0x03]

v_cubesc_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0xf6,0x03]

v_cubesc_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x24]

v_cubesc_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x44]

v_cubesc_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x84]

v_cubesc_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0xe4]

v_cubesc_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc5,0xd1,0x01,0x05,0x0e,0x04]

v_cubesc_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x0c]

v_cubesc_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x14]

v_cubesc_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc5,0xd1,0x01,0x05,0x0e,0x1c]

v_cubetc_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xff,0x05,0x0e,0x04]

v_cubetc_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x04,0x0e,0x04]

v_cubetc_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x65,0x04,0x0e,0x04]

v_cubetc_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x66,0x04,0x0e,0x04]

v_cubetc_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x67,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6a,0x04,0x0e,0x04]

v_cubetc_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6b,0x04,0x0e,0x04]

v_cubetc_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6c,0x04,0x0e,0x04]

v_cubetc_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6d,0x04,0x0e,0x04]

v_cubetc_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6e,0x04,0x0e,0x04]

v_cubetc_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x6f,0x04,0x0e,0x04]

v_cubetc_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x7b,0x04,0x0e,0x04]

v_cubetc_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x7c,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x7e,0x04,0x0e,0x04]

v_cubetc_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x7f,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x80,0x04,0x0e,0x04]

v_cubetc_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xc1,0x04,0x0e,0x04]

v_cubetc_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xf0,0x04,0x0e,0x04]

v_cubetc_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xf7,0x04,0x0e,0x04]

v_cubetc_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xfb,0x04,0x0e,0x04]

v_cubetc_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xfc,0x04,0x0e,0x04]

v_cubetc_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xfd,0x04,0x0e,0x04]

v_cubetc_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0xfe,0x04,0x0e,0x04]

v_cubetc_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xff,0x0f,0x04]

v_cubetc_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0c,0x04]

v_cubetc_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xcb,0x0c,0x04]

v_cubetc_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xcd,0x0c,0x04]

v_cubetc_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xcf,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xd5,0x0c,0x04]

v_cubetc_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xd7,0x0c,0x04]

v_cubetc_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xd9,0x0c,0x04]

v_cubetc_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xdb,0x0c,0x04]

v_cubetc_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xdd,0x0c,0x04]

v_cubetc_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xdf,0x0c,0x04]

v_cubetc_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xf7,0x0c,0x04]

v_cubetc_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xf9,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xfd,0x0c,0x04]

v_cubetc_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xff,0x0c,0x04]

v_cubetc_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x01,0x0d,0x04]

v_cubetc_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x83,0x0d,0x04]

v_cubetc_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xe1,0x0d,0x04]

v_cubetc_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xef,0x0d,0x04]

v_cubetc_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xf7,0x0d,0x04]

v_cubetc_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xf9,0x0d,0x04]

v_cubetc_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0xfb,0x0d,0x04]

v_cubetc_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xfe,0x07]

v_cubetc_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x00]

v_cubetc_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x96,0x01]

v_cubetc_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x9a,0x01]

v_cubetc_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x9e,0x01]

v_cubetc_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xaa,0x01]

v_cubetc_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xae,0x01]

v_cubetc_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xb2,0x01]

v_cubetc_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xb6,0x01]

v_cubetc_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xba,0x01]

v_cubetc_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xbe,0x01]

v_cubetc_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xee,0x01]

v_cubetc_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xf2,0x01]

v_cubetc_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xfa,0x01]

v_cubetc_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xfe,0x01]

v_cubetc_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x02,0x02]

v_cubetc_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x06,0x03]

v_cubetc_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xc2,0x03]

v_cubetc_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xde,0x03]

v_cubetc_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xee,0x03]

v_cubetc_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xf2,0x03]

v_cubetc_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0xf6,0x03]

v_cubetc_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x24]

v_cubetc_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x44]

v_cubetc_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x84]

v_cubetc_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0xe4]

v_cubetc_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc6,0xd1,0x01,0x05,0x0e,0x04]

v_cubetc_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x0c]

v_cubetc_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x14]

v_cubetc_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc6,0xd1,0x01,0x05,0x0e,0x1c]

v_cubema_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xff,0x05,0x0e,0x04]

v_cubema_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x04,0x0e,0x04]

v_cubema_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x65,0x04,0x0e,0x04]

v_cubema_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x66,0x04,0x0e,0x04]

v_cubema_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x67,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6a,0x04,0x0e,0x04]

v_cubema_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6b,0x04,0x0e,0x04]

v_cubema_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6c,0x04,0x0e,0x04]

v_cubema_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6d,0x04,0x0e,0x04]

v_cubema_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6e,0x04,0x0e,0x04]

v_cubema_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x6f,0x04,0x0e,0x04]

v_cubema_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x7b,0x04,0x0e,0x04]

v_cubema_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x7c,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x7e,0x04,0x0e,0x04]

v_cubema_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x7f,0x04,0x0e,0x04]

v_cubema_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x80,0x04,0x0e,0x04]

v_cubema_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xc1,0x04,0x0e,0x04]

v_cubema_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xf0,0x04,0x0e,0x04]

v_cubema_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xf7,0x04,0x0e,0x04]

v_cubema_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xfb,0x04,0x0e,0x04]

v_cubema_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xfc,0x04,0x0e,0x04]

v_cubema_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xfd,0x04,0x0e,0x04]

v_cubema_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0xfe,0x04,0x0e,0x04]

v_cubema_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xff,0x0f,0x04]

v_cubema_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0c,0x04]

v_cubema_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xcb,0x0c,0x04]

v_cubema_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xcd,0x0c,0x04]

v_cubema_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xcf,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xd5,0x0c,0x04]

v_cubema_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xd7,0x0c,0x04]

v_cubema_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xd9,0x0c,0x04]

v_cubema_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xdb,0x0c,0x04]

v_cubema_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xdd,0x0c,0x04]

v_cubema_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xdf,0x0c,0x04]

v_cubema_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xf7,0x0c,0x04]

v_cubema_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xf9,0x0c,0x04]

v_cubema_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xfd,0x0c,0x04]

v_cubema_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xff,0x0c,0x04]

v_cubema_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x01,0x0d,0x04]

v_cubema_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x83,0x0d,0x04]

v_cubema_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xe1,0x0d,0x04]

v_cubema_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xef,0x0d,0x04]

v_cubema_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xf7,0x0d,0x04]

v_cubema_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xf9,0x0d,0x04]

v_cubema_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0xfb,0x0d,0x04]

v_cubema_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xfe,0x07]

v_cubema_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x00]

v_cubema_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x96,0x01]

v_cubema_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x9a,0x01]

v_cubema_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x9e,0x01]

v_cubema_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xaa,0x01]

v_cubema_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xae,0x01]

v_cubema_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xb2,0x01]

v_cubema_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xb6,0x01]

v_cubema_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xba,0x01]

v_cubema_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xbe,0x01]

v_cubema_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xee,0x01]

v_cubema_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xf2,0x01]

v_cubema_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xfa,0x01]

v_cubema_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xfe,0x01]

v_cubema_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x02,0x02]

v_cubema_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x06,0x03]

v_cubema_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xc2,0x03]

v_cubema_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xde,0x03]

v_cubema_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xee,0x03]

v_cubema_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xf2,0x03]

v_cubema_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0xf6,0x03]

v_cubema_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x24]

v_cubema_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x44]

v_cubema_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x84]

v_cubema_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0xe4]

v_cubema_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xc7,0xd1,0x01,0x05,0x0e,0x04]

v_cubema_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x0c]

v_cubema_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x14]

v_cubema_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xc7,0xd1,0x01,0x05,0x0e,0x1c]

v_bfe_u32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x0e,0x04]

v_bfe_u32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc8,0xd1,0x01,0x05,0x0e,0x04]

v_bfe_u32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xff,0x05,0x0e,0x04]

v_bfe_u32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x04,0x0e,0x04]

v_bfe_u32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x65,0x04,0x0e,0x04]

v_bfe_u32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x66,0x04,0x0e,0x04]

v_bfe_u32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x67,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6a,0x04,0x0e,0x04]

v_bfe_u32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6b,0x04,0x0e,0x04]

v_bfe_u32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6c,0x04,0x0e,0x04]

v_bfe_u32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6d,0x04,0x0e,0x04]

v_bfe_u32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6e,0x04,0x0e,0x04]

v_bfe_u32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x6f,0x04,0x0e,0x04]

v_bfe_u32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x7b,0x04,0x0e,0x04]

v_bfe_u32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x7c,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x7e,0x04,0x0e,0x04]

v_bfe_u32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x7f,0x04,0x0e,0x04]

v_bfe_u32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x80,0x04,0x0e,0x04]

v_bfe_u32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xc1,0x04,0x0e,0x04]

v_bfe_u32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xf0,0x04,0x0e,0x04]

v_bfe_u32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xf7,0x04,0x0e,0x04]

v_bfe_u32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xfb,0x04,0x0e,0x04]

v_bfe_u32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xfc,0x04,0x0e,0x04]

v_bfe_u32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xfd,0x04,0x0e,0x04]

v_bfe_u32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0xfe,0x04,0x0e,0x04]

v_bfe_u32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xff,0x0f,0x04]

v_bfe_u32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x0c,0x04]

v_bfe_u32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xcb,0x0c,0x04]

v_bfe_u32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xcd,0x0c,0x04]

v_bfe_u32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xcf,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xd5,0x0c,0x04]

v_bfe_u32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xd7,0x0c,0x04]

v_bfe_u32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xd9,0x0c,0x04]

v_bfe_u32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xdb,0x0c,0x04]

v_bfe_u32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xdd,0x0c,0x04]

v_bfe_u32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xdf,0x0c,0x04]

v_bfe_u32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xf7,0x0c,0x04]

v_bfe_u32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xf9,0x0c,0x04]

v_bfe_u32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xfd,0x0c,0x04]

v_bfe_u32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xff,0x0c,0x04]

v_bfe_u32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x01,0x0d,0x04]

v_bfe_u32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x83,0x0d,0x04]

v_bfe_u32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xe1,0x0d,0x04]

v_bfe_u32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xef,0x0d,0x04]

v_bfe_u32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xf7,0x0d,0x04]

v_bfe_u32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xf9,0x0d,0x04]

v_bfe_u32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0xfb,0x0d,0x04]

v_bfe_u32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xfe,0x07]

v_bfe_u32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x0e,0x00]

v_bfe_u32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x96,0x01]

v_bfe_u32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x9a,0x01]

v_bfe_u32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x9e,0x01]

v_bfe_u32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xaa,0x01]

v_bfe_u32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xae,0x01]

v_bfe_u32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xb2,0x01]

v_bfe_u32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xb6,0x01]

v_bfe_u32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xba,0x01]

v_bfe_u32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xbe,0x01]

v_bfe_u32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xee,0x01]

v_bfe_u32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xf2,0x01]

v_bfe_u32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xfa,0x01]

v_bfe_u32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xfe,0x01]

v_bfe_u32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x02,0x02]

v_bfe_u32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0x06,0x03]

v_bfe_u32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xc2,0x03]

v_bfe_u32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xde,0x03]

v_bfe_u32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xee,0x03]

v_bfe_u32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xf2,0x03]

v_bfe_u32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc8,0xd1,0x01,0x05,0xf6,0x03]

v_bfe_i32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x0e,0x04]

v_bfe_i32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xc9,0xd1,0x01,0x05,0x0e,0x04]

v_bfe_i32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xff,0x05,0x0e,0x04]

v_bfe_i32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x04,0x0e,0x04]

v_bfe_i32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x65,0x04,0x0e,0x04]

v_bfe_i32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x66,0x04,0x0e,0x04]

v_bfe_i32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x67,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6a,0x04,0x0e,0x04]

v_bfe_i32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6b,0x04,0x0e,0x04]

v_bfe_i32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6c,0x04,0x0e,0x04]

v_bfe_i32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6d,0x04,0x0e,0x04]

v_bfe_i32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6e,0x04,0x0e,0x04]

v_bfe_i32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x6f,0x04,0x0e,0x04]

v_bfe_i32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x7b,0x04,0x0e,0x04]

v_bfe_i32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x7c,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x7e,0x04,0x0e,0x04]

v_bfe_i32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x7f,0x04,0x0e,0x04]

v_bfe_i32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x80,0x04,0x0e,0x04]

v_bfe_i32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xc1,0x04,0x0e,0x04]

v_bfe_i32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xf0,0x04,0x0e,0x04]

v_bfe_i32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xf7,0x04,0x0e,0x04]

v_bfe_i32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xfb,0x04,0x0e,0x04]

v_bfe_i32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xfc,0x04,0x0e,0x04]

v_bfe_i32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xfd,0x04,0x0e,0x04]

v_bfe_i32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0xfe,0x04,0x0e,0x04]

v_bfe_i32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xff,0x0f,0x04]

v_bfe_i32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x0c,0x04]

v_bfe_i32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xcb,0x0c,0x04]

v_bfe_i32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xcd,0x0c,0x04]

v_bfe_i32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xcf,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xd5,0x0c,0x04]

v_bfe_i32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xd7,0x0c,0x04]

v_bfe_i32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xd9,0x0c,0x04]

v_bfe_i32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xdb,0x0c,0x04]

v_bfe_i32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xdd,0x0c,0x04]

v_bfe_i32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xdf,0x0c,0x04]

v_bfe_i32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xf7,0x0c,0x04]

v_bfe_i32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xf9,0x0c,0x04]

v_bfe_i32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xfd,0x0c,0x04]

v_bfe_i32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xff,0x0c,0x04]

v_bfe_i32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x01,0x0d,0x04]

v_bfe_i32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x83,0x0d,0x04]

v_bfe_i32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xe1,0x0d,0x04]

v_bfe_i32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xef,0x0d,0x04]

v_bfe_i32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xf7,0x0d,0x04]

v_bfe_i32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xf9,0x0d,0x04]

v_bfe_i32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0xfb,0x0d,0x04]

v_bfe_i32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xfe,0x07]

v_bfe_i32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x0e,0x00]

v_bfe_i32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x96,0x01]

v_bfe_i32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x9a,0x01]

v_bfe_i32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x9e,0x01]

v_bfe_i32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xaa,0x01]

v_bfe_i32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xae,0x01]

v_bfe_i32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xb2,0x01]

v_bfe_i32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xb6,0x01]

v_bfe_i32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xba,0x01]

v_bfe_i32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xbe,0x01]

v_bfe_i32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xee,0x01]

v_bfe_i32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xf2,0x01]

v_bfe_i32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xfa,0x01]

v_bfe_i32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xfe,0x01]

v_bfe_i32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x02,0x02]

v_bfe_i32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0x06,0x03]

v_bfe_i32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xc2,0x03]

v_bfe_i32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xde,0x03]

v_bfe_i32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xee,0x03]

v_bfe_i32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xf2,0x03]

v_bfe_i32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xc9,0xd1,0x01,0x05,0xf6,0x03]

v_bfi_b32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x0e,0x04]

v_bfi_b32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xca,0xd1,0x01,0x05,0x0e,0x04]

v_bfi_b32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xff,0x05,0x0e,0x04]

v_bfi_b32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x04,0x0e,0x04]

v_bfi_b32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x65,0x04,0x0e,0x04]

v_bfi_b32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x66,0x04,0x0e,0x04]

v_bfi_b32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x67,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6a,0x04,0x0e,0x04]

v_bfi_b32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6b,0x04,0x0e,0x04]

v_bfi_b32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6c,0x04,0x0e,0x04]

v_bfi_b32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6d,0x04,0x0e,0x04]

v_bfi_b32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6e,0x04,0x0e,0x04]

v_bfi_b32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x6f,0x04,0x0e,0x04]

v_bfi_b32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x7b,0x04,0x0e,0x04]

v_bfi_b32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x7c,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x7e,0x04,0x0e,0x04]

v_bfi_b32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x7f,0x04,0x0e,0x04]

v_bfi_b32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x80,0x04,0x0e,0x04]

v_bfi_b32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xc1,0x04,0x0e,0x04]

v_bfi_b32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xf0,0x04,0x0e,0x04]

v_bfi_b32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xf7,0x04,0x0e,0x04]

v_bfi_b32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xfb,0x04,0x0e,0x04]

v_bfi_b32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xfc,0x04,0x0e,0x04]

v_bfi_b32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xfd,0x04,0x0e,0x04]

v_bfi_b32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0xfe,0x04,0x0e,0x04]

v_bfi_b32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xff,0x0f,0x04]

v_bfi_b32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x0c,0x04]

v_bfi_b32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xcb,0x0c,0x04]

v_bfi_b32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xcd,0x0c,0x04]

v_bfi_b32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xcf,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xd5,0x0c,0x04]

v_bfi_b32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xd7,0x0c,0x04]

v_bfi_b32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xd9,0x0c,0x04]

v_bfi_b32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xdb,0x0c,0x04]

v_bfi_b32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xdd,0x0c,0x04]

v_bfi_b32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xdf,0x0c,0x04]

v_bfi_b32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xf7,0x0c,0x04]

v_bfi_b32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xf9,0x0c,0x04]

v_bfi_b32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xfd,0x0c,0x04]

v_bfi_b32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xff,0x0c,0x04]

v_bfi_b32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x01,0x0d,0x04]

v_bfi_b32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x83,0x0d,0x04]

v_bfi_b32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xe1,0x0d,0x04]

v_bfi_b32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xef,0x0d,0x04]

v_bfi_b32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xf7,0x0d,0x04]

v_bfi_b32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xf9,0x0d,0x04]

v_bfi_b32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0xfb,0x0d,0x04]

v_bfi_b32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xfe,0x07]

v_bfi_b32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x0e,0x00]

v_bfi_b32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x96,0x01]

v_bfi_b32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x9a,0x01]

v_bfi_b32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x9e,0x01]

v_bfi_b32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xaa,0x01]

v_bfi_b32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xae,0x01]

v_bfi_b32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xb2,0x01]

v_bfi_b32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xb6,0x01]

v_bfi_b32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xba,0x01]

v_bfi_b32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xbe,0x01]

v_bfi_b32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xee,0x01]

v_bfi_b32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xf2,0x01]

v_bfi_b32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xfa,0x01]

v_bfi_b32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xfe,0x01]

v_bfi_b32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x02,0x02]

v_bfi_b32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0x06,0x03]

v_bfi_b32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xc2,0x03]

v_bfi_b32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xde,0x03]

v_bfi_b32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xee,0x03]

v_bfi_b32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xf2,0x03]

v_bfi_b32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xca,0xd1,0x01,0x05,0xf6,0x03]

v_fma_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xff,0x05,0x0e,0x04]

v_fma_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x04,0x0e,0x04]

v_fma_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x65,0x04,0x0e,0x04]

v_fma_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x66,0x04,0x0e,0x04]

v_fma_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x67,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6a,0x04,0x0e,0x04]

v_fma_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6b,0x04,0x0e,0x04]

v_fma_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6c,0x04,0x0e,0x04]

v_fma_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6d,0x04,0x0e,0x04]

v_fma_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6e,0x04,0x0e,0x04]

v_fma_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x6f,0x04,0x0e,0x04]

v_fma_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x7b,0x04,0x0e,0x04]

v_fma_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x7c,0x04,0x0e,0x04]

v_fma_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x7e,0x04,0x0e,0x04]

v_fma_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x7f,0x04,0x0e,0x04]

v_fma_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x80,0x04,0x0e,0x04]

v_fma_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xc1,0x04,0x0e,0x04]

v_fma_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xf0,0x04,0x0e,0x04]

v_fma_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xf7,0x04,0x0e,0x04]

v_fma_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xfb,0x04,0x0e,0x04]

v_fma_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xfc,0x04,0x0e,0x04]

v_fma_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xfd,0x04,0x0e,0x04]

v_fma_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0xfe,0x04,0x0e,0x04]

v_fma_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xff,0x0f,0x04]

v_fma_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0c,0x04]

v_fma_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xcb,0x0c,0x04]

v_fma_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xcd,0x0c,0x04]

v_fma_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xcf,0x0c,0x04]

v_fma_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xd5,0x0c,0x04]

v_fma_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xd7,0x0c,0x04]

v_fma_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xd9,0x0c,0x04]

v_fma_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xdb,0x0c,0x04]

v_fma_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xdd,0x0c,0x04]

v_fma_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xdf,0x0c,0x04]

v_fma_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xf7,0x0c,0x04]

v_fma_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xf9,0x0c,0x04]

v_fma_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xfd,0x0c,0x04]

v_fma_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xff,0x0c,0x04]

v_fma_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x01,0x0d,0x04]

v_fma_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x83,0x0d,0x04]

v_fma_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xe1,0x0d,0x04]

v_fma_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xef,0x0d,0x04]

v_fma_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xf7,0x0d,0x04]

v_fma_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xf9,0x0d,0x04]

v_fma_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0xfb,0x0d,0x04]

v_fma_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xfe,0x07]

v_fma_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x00]

v_fma_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x96,0x01]

v_fma_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x9a,0x01]

v_fma_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x9e,0x01]

v_fma_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xaa,0x01]

v_fma_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xae,0x01]

v_fma_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xb2,0x01]

v_fma_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xb6,0x01]

v_fma_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xba,0x01]

v_fma_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xbe,0x01]

v_fma_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xee,0x01]

v_fma_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xf2,0x01]

v_fma_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xfa,0x01]

v_fma_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xfe,0x01]

v_fma_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x02,0x02]

v_fma_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x06,0x03]

v_fma_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xc2,0x03]

v_fma_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xde,0x03]

v_fma_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xee,0x03]

v_fma_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xf2,0x03]

v_fma_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0xf6,0x03]

v_fma_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x24]

v_fma_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x44]

v_fma_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x84]

v_fma_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0xe4]

v_fma_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xcb,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x0c]

v_fma_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x14]

v_fma_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xcb,0xd1,0x01,0x05,0x0e,0x1c]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// CHECK: [0xfe,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xfe,0x05,0x0e,0x04]

v_fma_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x02,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x04,0x04,0x0e,0x04]

v_fma_f64 v[5:6], s[100:101], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x64,0x04,0x0e,0x04]

v_fma_f64 v[5:6], flat_scratch, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x66,0x04,0x0e,0x04]

v_fma_f64 v[5:6], vcc, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x6a,0x04,0x0e,0x04]

v_fma_f64 v[5:6], tba, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x6c,0x04,0x0e,0x04]

v_fma_f64 v[5:6], tma, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x6e,0x04,0x0e,0x04]

v_fma_f64 v[5:6], ttmp[10:11], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x7a,0x04,0x0e,0x04]

v_fma_f64 v[5:6], exec, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x7e,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x80,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -1, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xc1,0x04,0x0e,0x04]

v_fma_f64 v[5:6], 0.5, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xf0,0x04,0x0e,0x04]

v_fma_f64 v[5:6], -4.0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xf7,0x04,0x0e,0x04]

v_fma_f64 v[5:6], src_vccz, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xfb,0x04,0x0e,0x04]

v_fma_f64 v[5:6], src_execz, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xfc,0x04,0x0e,0x04]

v_fma_f64 v[5:6], src_scc, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0xfd,0x04,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xfd,0x0f,0x04]

v_fma_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x09,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x0d,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], s[100:101], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xc9,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], flat_scratch, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xcd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], vcc, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xd5,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], tba, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xd9,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], tma, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xdd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], ttmp[10:11], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xf5,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], exec, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xfd,0x0c,0x04]

v_fma_f64 v[5:6], v[1:2], 0, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x01,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -1, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x83,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xe1,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xef,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], src_vccz, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xf7,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], src_execz, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xf9,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], src_scc, v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0xfb,0x0d,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xfa,0x07]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x1a,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x22,0x00]

v_fma_f64 v[5:6], v[1:2], v[2:3], s[100:101]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x92,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], flat_scratch
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x9a,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], vcc
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xaa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], tba
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xb2,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], tma
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xba,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], ttmp[10:11]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xea,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], exec
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xfa,0x01]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x02,0x02]

v_fma_f64 v[5:6], v[1:2], v[2:3], -1
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x06,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], 0.5
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xc2,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], -4.0
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xde,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], src_vccz
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xee,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], src_execz
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xf2,0x03]

v_fma_f64 v[5:6], v[1:2], v[2:3], src_scc
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0xf6,0x03]

v_fma_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x24]

v_fma_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x44]

v_fma_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x84]

v_fma_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0xe4]

v_fma_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// CHECK: [0x05,0x01,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// CHECK: [0x05,0x02,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// CHECK: [0x05,0x04,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// CHECK: [0x05,0x07,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// CHECK: [0x05,0x80,0xcc,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x0c]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x14]

v_fma_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// CHECK: [0x05,0x00,0xcc,0xd1,0x01,0x05,0x0e,0x1c]

v_lerp_u8 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x0e,0x04]

v_lerp_u8 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xcd,0xd1,0x01,0x05,0x0e,0x04]

v_lerp_u8 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xff,0x05,0x0e,0x04]

v_lerp_u8 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x04,0x0e,0x04]

v_lerp_u8 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x65,0x04,0x0e,0x04]

v_lerp_u8 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x66,0x04,0x0e,0x04]

v_lerp_u8 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x67,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6a,0x04,0x0e,0x04]

v_lerp_u8 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6b,0x04,0x0e,0x04]

v_lerp_u8 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6c,0x04,0x0e,0x04]

v_lerp_u8 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6d,0x04,0x0e,0x04]

v_lerp_u8 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6e,0x04,0x0e,0x04]

v_lerp_u8 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x6f,0x04,0x0e,0x04]

v_lerp_u8 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x7b,0x04,0x0e,0x04]

v_lerp_u8 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x7c,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x7e,0x04,0x0e,0x04]

v_lerp_u8 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x7f,0x04,0x0e,0x04]

v_lerp_u8 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x80,0x04,0x0e,0x04]

v_lerp_u8 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xc1,0x04,0x0e,0x04]

v_lerp_u8 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xf0,0x04,0x0e,0x04]

v_lerp_u8 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xf7,0x04,0x0e,0x04]

v_lerp_u8 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xfb,0x04,0x0e,0x04]

v_lerp_u8 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xfc,0x04,0x0e,0x04]

v_lerp_u8 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xfd,0x04,0x0e,0x04]

v_lerp_u8 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0xfe,0x04,0x0e,0x04]

v_lerp_u8 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xff,0x0f,0x04]

v_lerp_u8 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x0c,0x04]

v_lerp_u8 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xcb,0x0c,0x04]

v_lerp_u8 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xcd,0x0c,0x04]

v_lerp_u8 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xcf,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xd5,0x0c,0x04]

v_lerp_u8 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xd7,0x0c,0x04]

v_lerp_u8 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xd9,0x0c,0x04]

v_lerp_u8 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xdb,0x0c,0x04]

v_lerp_u8 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xdd,0x0c,0x04]

v_lerp_u8 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xdf,0x0c,0x04]

v_lerp_u8 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xf7,0x0c,0x04]

v_lerp_u8 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xf9,0x0c,0x04]

v_lerp_u8 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xfd,0x0c,0x04]

v_lerp_u8 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xff,0x0c,0x04]

v_lerp_u8 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x01,0x0d,0x04]

v_lerp_u8 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x83,0x0d,0x04]

v_lerp_u8 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xe1,0x0d,0x04]

v_lerp_u8 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xef,0x0d,0x04]

v_lerp_u8 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xf7,0x0d,0x04]

v_lerp_u8 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xf9,0x0d,0x04]

v_lerp_u8 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0xfb,0x0d,0x04]

v_lerp_u8 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xfe,0x07]

v_lerp_u8 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x0e,0x00]

v_lerp_u8 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x96,0x01]

v_lerp_u8 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x9a,0x01]

v_lerp_u8 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x9e,0x01]

v_lerp_u8 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xaa,0x01]

v_lerp_u8 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xae,0x01]

v_lerp_u8 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xb2,0x01]

v_lerp_u8 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xb6,0x01]

v_lerp_u8 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xba,0x01]

v_lerp_u8 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xbe,0x01]

v_lerp_u8 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xee,0x01]

v_lerp_u8 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xf2,0x01]

v_lerp_u8 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xfa,0x01]

v_lerp_u8 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xfe,0x01]

v_lerp_u8 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x02,0x02]

v_lerp_u8 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0x06,0x03]

v_lerp_u8 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xc2,0x03]

v_lerp_u8 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xde,0x03]

v_lerp_u8 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xee,0x03]

v_lerp_u8 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xf2,0x03]

v_lerp_u8 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xcd,0xd1,0x01,0x05,0xf6,0x03]

v_alignbit_b32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xce,0xd1,0x01,0x05,0x0e,0x04]

v_alignbit_b32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xff,0x05,0x0e,0x04]

v_alignbit_b32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x04,0x0e,0x04]

v_alignbit_b32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x65,0x04,0x0e,0x04]

v_alignbit_b32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x66,0x04,0x0e,0x04]

v_alignbit_b32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x67,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6a,0x04,0x0e,0x04]

v_alignbit_b32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6b,0x04,0x0e,0x04]

v_alignbit_b32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6c,0x04,0x0e,0x04]

v_alignbit_b32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6d,0x04,0x0e,0x04]

v_alignbit_b32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6e,0x04,0x0e,0x04]

v_alignbit_b32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x6f,0x04,0x0e,0x04]

v_alignbit_b32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x7b,0x04,0x0e,0x04]

v_alignbit_b32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x7c,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x7e,0x04,0x0e,0x04]

v_alignbit_b32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x7f,0x04,0x0e,0x04]

v_alignbit_b32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x80,0x04,0x0e,0x04]

v_alignbit_b32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xc1,0x04,0x0e,0x04]

v_alignbit_b32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xf0,0x04,0x0e,0x04]

v_alignbit_b32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xf7,0x04,0x0e,0x04]

v_alignbit_b32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xfb,0x04,0x0e,0x04]

v_alignbit_b32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xfc,0x04,0x0e,0x04]

v_alignbit_b32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xfd,0x04,0x0e,0x04]

v_alignbit_b32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0xfe,0x04,0x0e,0x04]

v_alignbit_b32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xff,0x0f,0x04]

v_alignbit_b32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x0c,0x04]

v_alignbit_b32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xcb,0x0c,0x04]

v_alignbit_b32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xcd,0x0c,0x04]

v_alignbit_b32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xcf,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xd5,0x0c,0x04]

v_alignbit_b32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xd7,0x0c,0x04]

v_alignbit_b32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xd9,0x0c,0x04]

v_alignbit_b32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xdb,0x0c,0x04]

v_alignbit_b32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xdd,0x0c,0x04]

v_alignbit_b32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xdf,0x0c,0x04]

v_alignbit_b32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xf7,0x0c,0x04]

v_alignbit_b32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xf9,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xfd,0x0c,0x04]

v_alignbit_b32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xff,0x0c,0x04]

v_alignbit_b32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x01,0x0d,0x04]

v_alignbit_b32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x83,0x0d,0x04]

v_alignbit_b32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xe1,0x0d,0x04]

v_alignbit_b32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xef,0x0d,0x04]

v_alignbit_b32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xf7,0x0d,0x04]

v_alignbit_b32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xf9,0x0d,0x04]

v_alignbit_b32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0xfb,0x0d,0x04]

v_alignbit_b32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xfe,0x07]

v_alignbit_b32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x0e,0x00]

v_alignbit_b32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x96,0x01]

v_alignbit_b32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x9a,0x01]

v_alignbit_b32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x9e,0x01]

v_alignbit_b32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xaa,0x01]

v_alignbit_b32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xae,0x01]

v_alignbit_b32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xb2,0x01]

v_alignbit_b32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xb6,0x01]

v_alignbit_b32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xba,0x01]

v_alignbit_b32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xbe,0x01]

v_alignbit_b32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xee,0x01]

v_alignbit_b32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xf2,0x01]

v_alignbit_b32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xfa,0x01]

v_alignbit_b32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xfe,0x01]

v_alignbit_b32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x02,0x02]

v_alignbit_b32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0x06,0x03]

v_alignbit_b32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xc2,0x03]

v_alignbit_b32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xde,0x03]

v_alignbit_b32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xee,0x03]

v_alignbit_b32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xf2,0x03]

v_alignbit_b32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xce,0xd1,0x01,0x05,0xf6,0x03]

v_alignbyte_b32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xcf,0xd1,0x01,0x05,0x0e,0x04]

v_alignbyte_b32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xff,0x05,0x0e,0x04]

v_alignbyte_b32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x04,0x0e,0x04]

v_alignbyte_b32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x65,0x04,0x0e,0x04]

v_alignbyte_b32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x66,0x04,0x0e,0x04]

v_alignbyte_b32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x67,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6a,0x04,0x0e,0x04]

v_alignbyte_b32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6b,0x04,0x0e,0x04]

v_alignbyte_b32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6c,0x04,0x0e,0x04]

v_alignbyte_b32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6d,0x04,0x0e,0x04]

v_alignbyte_b32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6e,0x04,0x0e,0x04]

v_alignbyte_b32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x6f,0x04,0x0e,0x04]

v_alignbyte_b32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x7b,0x04,0x0e,0x04]

v_alignbyte_b32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x7c,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x7e,0x04,0x0e,0x04]

v_alignbyte_b32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x7f,0x04,0x0e,0x04]

v_alignbyte_b32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x80,0x04,0x0e,0x04]

v_alignbyte_b32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xc1,0x04,0x0e,0x04]

v_alignbyte_b32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xf0,0x04,0x0e,0x04]

v_alignbyte_b32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xf7,0x04,0x0e,0x04]

v_alignbyte_b32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xfb,0x04,0x0e,0x04]

v_alignbyte_b32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xfc,0x04,0x0e,0x04]

v_alignbyte_b32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xfd,0x04,0x0e,0x04]

v_alignbyte_b32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0xfe,0x04,0x0e,0x04]

v_alignbyte_b32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xff,0x0f,0x04]

v_alignbyte_b32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x0c,0x04]

v_alignbyte_b32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xcb,0x0c,0x04]

v_alignbyte_b32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xcd,0x0c,0x04]

v_alignbyte_b32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xcf,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xd5,0x0c,0x04]

v_alignbyte_b32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xd7,0x0c,0x04]

v_alignbyte_b32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xd9,0x0c,0x04]

v_alignbyte_b32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xdb,0x0c,0x04]

v_alignbyte_b32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xdd,0x0c,0x04]

v_alignbyte_b32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xdf,0x0c,0x04]

v_alignbyte_b32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xf7,0x0c,0x04]

v_alignbyte_b32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xf9,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xfd,0x0c,0x04]

v_alignbyte_b32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xff,0x0c,0x04]

v_alignbyte_b32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x01,0x0d,0x04]

v_alignbyte_b32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x83,0x0d,0x04]

v_alignbyte_b32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xe1,0x0d,0x04]

v_alignbyte_b32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xef,0x0d,0x04]

v_alignbyte_b32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xf7,0x0d,0x04]

v_alignbyte_b32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xf9,0x0d,0x04]

v_alignbyte_b32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0xfb,0x0d,0x04]

v_alignbyte_b32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xfe,0x07]

v_alignbyte_b32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x0e,0x00]

v_alignbyte_b32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x96,0x01]

v_alignbyte_b32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x9a,0x01]

v_alignbyte_b32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x9e,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xaa,0x01]

v_alignbyte_b32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xae,0x01]

v_alignbyte_b32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xb2,0x01]

v_alignbyte_b32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xb6,0x01]

v_alignbyte_b32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xba,0x01]

v_alignbyte_b32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xbe,0x01]

v_alignbyte_b32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xee,0x01]

v_alignbyte_b32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xf2,0x01]

v_alignbyte_b32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xfa,0x01]

v_alignbyte_b32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xfe,0x01]

v_alignbyte_b32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x02,0x02]

v_alignbyte_b32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0x06,0x03]

v_alignbyte_b32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xc2,0x03]

v_alignbyte_b32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xde,0x03]

v_alignbyte_b32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xee,0x03]

v_alignbyte_b32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xf2,0x03]

v_alignbyte_b32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xcf,0xd1,0x01,0x05,0xf6,0x03]

v_min3_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xff,0x05,0x0e,0x04]

v_min3_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x04,0x0e,0x04]

v_min3_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x65,0x04,0x0e,0x04]

v_min3_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x66,0x04,0x0e,0x04]

v_min3_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x67,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6a,0x04,0x0e,0x04]

v_min3_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6b,0x04,0x0e,0x04]

v_min3_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6c,0x04,0x0e,0x04]

v_min3_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6d,0x04,0x0e,0x04]

v_min3_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6e,0x04,0x0e,0x04]

v_min3_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x6f,0x04,0x0e,0x04]

v_min3_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x7b,0x04,0x0e,0x04]

v_min3_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x7c,0x04,0x0e,0x04]

v_min3_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x7e,0x04,0x0e,0x04]

v_min3_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x7f,0x04,0x0e,0x04]

v_min3_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x80,0x04,0x0e,0x04]

v_min3_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xc1,0x04,0x0e,0x04]

v_min3_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xf0,0x04,0x0e,0x04]

v_min3_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xf7,0x04,0x0e,0x04]

v_min3_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xfb,0x04,0x0e,0x04]

v_min3_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xfc,0x04,0x0e,0x04]

v_min3_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xfd,0x04,0x0e,0x04]

v_min3_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0xfe,0x04,0x0e,0x04]

v_min3_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xff,0x0f,0x04]

v_min3_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0c,0x04]

v_min3_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xcb,0x0c,0x04]

v_min3_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xcd,0x0c,0x04]

v_min3_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xcf,0x0c,0x04]

v_min3_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xd5,0x0c,0x04]

v_min3_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xd7,0x0c,0x04]

v_min3_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xd9,0x0c,0x04]

v_min3_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xdb,0x0c,0x04]

v_min3_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xdd,0x0c,0x04]

v_min3_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xdf,0x0c,0x04]

v_min3_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xf7,0x0c,0x04]

v_min3_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xf9,0x0c,0x04]

v_min3_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xfd,0x0c,0x04]

v_min3_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xff,0x0c,0x04]

v_min3_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x01,0x0d,0x04]

v_min3_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x83,0x0d,0x04]

v_min3_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xe1,0x0d,0x04]

v_min3_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xef,0x0d,0x04]

v_min3_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xf7,0x0d,0x04]

v_min3_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xf9,0x0d,0x04]

v_min3_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0xfb,0x0d,0x04]

v_min3_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xfe,0x07]

v_min3_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x00]

v_min3_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x96,0x01]

v_min3_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x9a,0x01]

v_min3_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x9e,0x01]

v_min3_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xaa,0x01]

v_min3_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xae,0x01]

v_min3_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xb2,0x01]

v_min3_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xb6,0x01]

v_min3_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xba,0x01]

v_min3_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xbe,0x01]

v_min3_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xee,0x01]

v_min3_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xf2,0x01]

v_min3_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xfa,0x01]

v_min3_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xfe,0x01]

v_min3_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x02,0x02]

v_min3_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x06,0x03]

v_min3_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xc2,0x03]

v_min3_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xde,0x03]

v_min3_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xee,0x03]

v_min3_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xf2,0x03]

v_min3_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0xf6,0x03]

v_min3_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x24]

v_min3_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x44]

v_min3_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x84]

v_min3_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0xe4]

v_min3_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xd0,0xd1,0x01,0x05,0x0e,0x04]

v_min3_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x0c]

v_min3_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x14]

v_min3_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xd0,0xd1,0x01,0x05,0x0e,0x1c]

v_min3_i32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x0e,0x04]

v_min3_i32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd1,0xd1,0x01,0x05,0x0e,0x04]

v_min3_i32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xff,0x05,0x0e,0x04]

v_min3_i32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x04,0x0e,0x04]

v_min3_i32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x65,0x04,0x0e,0x04]

v_min3_i32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x66,0x04,0x0e,0x04]

v_min3_i32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x67,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6a,0x04,0x0e,0x04]

v_min3_i32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6b,0x04,0x0e,0x04]

v_min3_i32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6c,0x04,0x0e,0x04]

v_min3_i32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6d,0x04,0x0e,0x04]

v_min3_i32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6e,0x04,0x0e,0x04]

v_min3_i32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x6f,0x04,0x0e,0x04]

v_min3_i32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x7b,0x04,0x0e,0x04]

v_min3_i32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x7c,0x04,0x0e,0x04]

v_min3_i32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x7e,0x04,0x0e,0x04]

v_min3_i32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x7f,0x04,0x0e,0x04]

v_min3_i32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x80,0x04,0x0e,0x04]

v_min3_i32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xc1,0x04,0x0e,0x04]

v_min3_i32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xf0,0x04,0x0e,0x04]

v_min3_i32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xf7,0x04,0x0e,0x04]

v_min3_i32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xfb,0x04,0x0e,0x04]

v_min3_i32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xfc,0x04,0x0e,0x04]

v_min3_i32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xfd,0x04,0x0e,0x04]

v_min3_i32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0xfe,0x04,0x0e,0x04]

v_min3_i32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xff,0x0f,0x04]

v_min3_i32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x0c,0x04]

v_min3_i32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xcb,0x0c,0x04]

v_min3_i32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xcd,0x0c,0x04]

v_min3_i32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xcf,0x0c,0x04]

v_min3_i32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xd5,0x0c,0x04]

v_min3_i32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xd7,0x0c,0x04]

v_min3_i32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xd9,0x0c,0x04]

v_min3_i32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xdb,0x0c,0x04]

v_min3_i32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xdd,0x0c,0x04]

v_min3_i32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xdf,0x0c,0x04]

v_min3_i32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xf7,0x0c,0x04]

v_min3_i32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xf9,0x0c,0x04]

v_min3_i32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xfd,0x0c,0x04]

v_min3_i32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xff,0x0c,0x04]

v_min3_i32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x01,0x0d,0x04]

v_min3_i32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x83,0x0d,0x04]

v_min3_i32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xe1,0x0d,0x04]

v_min3_i32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xef,0x0d,0x04]

v_min3_i32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xf7,0x0d,0x04]

v_min3_i32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xf9,0x0d,0x04]

v_min3_i32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0xfb,0x0d,0x04]

v_min3_i32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xfe,0x07]

v_min3_i32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x0e,0x00]

v_min3_i32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x96,0x01]

v_min3_i32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x9a,0x01]

v_min3_i32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x9e,0x01]

v_min3_i32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xaa,0x01]

v_min3_i32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xae,0x01]

v_min3_i32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xb2,0x01]

v_min3_i32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xb6,0x01]

v_min3_i32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xba,0x01]

v_min3_i32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xbe,0x01]

v_min3_i32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xee,0x01]

v_min3_i32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xf2,0x01]

v_min3_i32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xfa,0x01]

v_min3_i32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xfe,0x01]

v_min3_i32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x02,0x02]

v_min3_i32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0x06,0x03]

v_min3_i32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xc2,0x03]

v_min3_i32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xde,0x03]

v_min3_i32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xee,0x03]

v_min3_i32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xf2,0x03]

v_min3_i32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd1,0xd1,0x01,0x05,0xf6,0x03]

v_min3_u32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x0e,0x04]

v_min3_u32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd2,0xd1,0x01,0x05,0x0e,0x04]

v_min3_u32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xff,0x05,0x0e,0x04]

v_min3_u32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x04,0x0e,0x04]

v_min3_u32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x65,0x04,0x0e,0x04]

v_min3_u32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x66,0x04,0x0e,0x04]

v_min3_u32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x67,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6a,0x04,0x0e,0x04]

v_min3_u32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6b,0x04,0x0e,0x04]

v_min3_u32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6c,0x04,0x0e,0x04]

v_min3_u32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6d,0x04,0x0e,0x04]

v_min3_u32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6e,0x04,0x0e,0x04]

v_min3_u32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x6f,0x04,0x0e,0x04]

v_min3_u32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x7b,0x04,0x0e,0x04]

v_min3_u32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x7c,0x04,0x0e,0x04]

v_min3_u32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x7e,0x04,0x0e,0x04]

v_min3_u32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x7f,0x04,0x0e,0x04]

v_min3_u32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x80,0x04,0x0e,0x04]

v_min3_u32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xc1,0x04,0x0e,0x04]

v_min3_u32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xf0,0x04,0x0e,0x04]

v_min3_u32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xf7,0x04,0x0e,0x04]

v_min3_u32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xfb,0x04,0x0e,0x04]

v_min3_u32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xfc,0x04,0x0e,0x04]

v_min3_u32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xfd,0x04,0x0e,0x04]

v_min3_u32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0xfe,0x04,0x0e,0x04]

v_min3_u32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xff,0x0f,0x04]

v_min3_u32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x0c,0x04]

v_min3_u32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xcb,0x0c,0x04]

v_min3_u32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xcd,0x0c,0x04]

v_min3_u32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xcf,0x0c,0x04]

v_min3_u32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xd5,0x0c,0x04]

v_min3_u32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xd7,0x0c,0x04]

v_min3_u32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xd9,0x0c,0x04]

v_min3_u32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xdb,0x0c,0x04]

v_min3_u32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xdd,0x0c,0x04]

v_min3_u32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xdf,0x0c,0x04]

v_min3_u32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xf7,0x0c,0x04]

v_min3_u32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xf9,0x0c,0x04]

v_min3_u32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xfd,0x0c,0x04]

v_min3_u32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xff,0x0c,0x04]

v_min3_u32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x01,0x0d,0x04]

v_min3_u32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x83,0x0d,0x04]

v_min3_u32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xe1,0x0d,0x04]

v_min3_u32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xef,0x0d,0x04]

v_min3_u32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xf7,0x0d,0x04]

v_min3_u32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xf9,0x0d,0x04]

v_min3_u32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0xfb,0x0d,0x04]

v_min3_u32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xfe,0x07]

v_min3_u32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x0e,0x00]

v_min3_u32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x96,0x01]

v_min3_u32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x9a,0x01]

v_min3_u32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x9e,0x01]

v_min3_u32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xaa,0x01]

v_min3_u32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xae,0x01]

v_min3_u32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xb2,0x01]

v_min3_u32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xb6,0x01]

v_min3_u32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xba,0x01]

v_min3_u32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xbe,0x01]

v_min3_u32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xee,0x01]

v_min3_u32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xf2,0x01]

v_min3_u32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xfa,0x01]

v_min3_u32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xfe,0x01]

v_min3_u32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x02,0x02]

v_min3_u32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0x06,0x03]

v_min3_u32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xc2,0x03]

v_min3_u32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xde,0x03]

v_min3_u32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xee,0x03]

v_min3_u32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xf2,0x03]

v_min3_u32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd2,0xd1,0x01,0x05,0xf6,0x03]

v_max3_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xff,0x05,0x0e,0x04]

v_max3_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x04,0x0e,0x04]

v_max3_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x65,0x04,0x0e,0x04]

v_max3_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x66,0x04,0x0e,0x04]

v_max3_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x67,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6a,0x04,0x0e,0x04]

v_max3_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6b,0x04,0x0e,0x04]

v_max3_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6c,0x04,0x0e,0x04]

v_max3_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6d,0x04,0x0e,0x04]

v_max3_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6e,0x04,0x0e,0x04]

v_max3_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x6f,0x04,0x0e,0x04]

v_max3_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x7b,0x04,0x0e,0x04]

v_max3_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x7c,0x04,0x0e,0x04]

v_max3_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x7e,0x04,0x0e,0x04]

v_max3_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x7f,0x04,0x0e,0x04]

v_max3_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x80,0x04,0x0e,0x04]

v_max3_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xc1,0x04,0x0e,0x04]

v_max3_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xf0,0x04,0x0e,0x04]

v_max3_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xf7,0x04,0x0e,0x04]

v_max3_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xfb,0x04,0x0e,0x04]

v_max3_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xfc,0x04,0x0e,0x04]

v_max3_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xfd,0x04,0x0e,0x04]

v_max3_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0xfe,0x04,0x0e,0x04]

v_max3_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xff,0x0f,0x04]

v_max3_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0c,0x04]

v_max3_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xcb,0x0c,0x04]

v_max3_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xcd,0x0c,0x04]

v_max3_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xcf,0x0c,0x04]

v_max3_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xd5,0x0c,0x04]

v_max3_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xd7,0x0c,0x04]

v_max3_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xd9,0x0c,0x04]

v_max3_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xdb,0x0c,0x04]

v_max3_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xdd,0x0c,0x04]

v_max3_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xdf,0x0c,0x04]

v_max3_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xf7,0x0c,0x04]

v_max3_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xf9,0x0c,0x04]

v_max3_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xfd,0x0c,0x04]

v_max3_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xff,0x0c,0x04]

v_max3_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x01,0x0d,0x04]

v_max3_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x83,0x0d,0x04]

v_max3_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xe1,0x0d,0x04]

v_max3_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xef,0x0d,0x04]

v_max3_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xf7,0x0d,0x04]

v_max3_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xf9,0x0d,0x04]

v_max3_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0xfb,0x0d,0x04]

v_max3_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xfe,0x07]

v_max3_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x00]

v_max3_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x96,0x01]

v_max3_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x9a,0x01]

v_max3_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x9e,0x01]

v_max3_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xaa,0x01]

v_max3_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xae,0x01]

v_max3_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xb2,0x01]

v_max3_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xb6,0x01]

v_max3_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xba,0x01]

v_max3_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xbe,0x01]

v_max3_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xee,0x01]

v_max3_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xf2,0x01]

v_max3_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xfa,0x01]

v_max3_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xfe,0x01]

v_max3_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x02,0x02]

v_max3_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x06,0x03]

v_max3_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xc2,0x03]

v_max3_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xde,0x03]

v_max3_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xee,0x03]

v_max3_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xf2,0x03]

v_max3_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0xf6,0x03]

v_max3_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x24]

v_max3_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x44]

v_max3_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x84]

v_max3_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0xe4]

v_max3_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xd3,0xd1,0x01,0x05,0x0e,0x04]

v_max3_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x0c]

v_max3_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x14]

v_max3_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xd3,0xd1,0x01,0x05,0x0e,0x1c]

v_max3_i32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x0e,0x04]

v_max3_i32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd4,0xd1,0x01,0x05,0x0e,0x04]

v_max3_i32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xff,0x05,0x0e,0x04]

v_max3_i32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x04,0x0e,0x04]

v_max3_i32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x65,0x04,0x0e,0x04]

v_max3_i32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x66,0x04,0x0e,0x04]

v_max3_i32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x67,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6a,0x04,0x0e,0x04]

v_max3_i32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6b,0x04,0x0e,0x04]

v_max3_i32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6c,0x04,0x0e,0x04]

v_max3_i32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6d,0x04,0x0e,0x04]

v_max3_i32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6e,0x04,0x0e,0x04]

v_max3_i32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x6f,0x04,0x0e,0x04]

v_max3_i32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x7b,0x04,0x0e,0x04]

v_max3_i32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x7c,0x04,0x0e,0x04]

v_max3_i32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x7e,0x04,0x0e,0x04]

v_max3_i32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x7f,0x04,0x0e,0x04]

v_max3_i32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x80,0x04,0x0e,0x04]

v_max3_i32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xc1,0x04,0x0e,0x04]

v_max3_i32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xf0,0x04,0x0e,0x04]

v_max3_i32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xf7,0x04,0x0e,0x04]

v_max3_i32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xfb,0x04,0x0e,0x04]

v_max3_i32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xfc,0x04,0x0e,0x04]

v_max3_i32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xfd,0x04,0x0e,0x04]

v_max3_i32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0xfe,0x04,0x0e,0x04]

v_max3_i32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xff,0x0f,0x04]

v_max3_i32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x0c,0x04]

v_max3_i32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xcb,0x0c,0x04]

v_max3_i32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xcd,0x0c,0x04]

v_max3_i32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xcf,0x0c,0x04]

v_max3_i32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xd5,0x0c,0x04]

v_max3_i32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xd7,0x0c,0x04]

v_max3_i32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xd9,0x0c,0x04]

v_max3_i32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xdb,0x0c,0x04]

v_max3_i32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xdd,0x0c,0x04]

v_max3_i32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xdf,0x0c,0x04]

v_max3_i32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xf7,0x0c,0x04]

v_max3_i32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xf9,0x0c,0x04]

v_max3_i32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xfd,0x0c,0x04]

v_max3_i32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xff,0x0c,0x04]

v_max3_i32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x01,0x0d,0x04]

v_max3_i32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x83,0x0d,0x04]

v_max3_i32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xe1,0x0d,0x04]

v_max3_i32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xef,0x0d,0x04]

v_max3_i32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xf7,0x0d,0x04]

v_max3_i32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xf9,0x0d,0x04]

v_max3_i32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0xfb,0x0d,0x04]

v_max3_i32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xfe,0x07]

v_max3_i32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x0e,0x00]

v_max3_i32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x96,0x01]

v_max3_i32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x9a,0x01]

v_max3_i32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x9e,0x01]

v_max3_i32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xaa,0x01]

v_max3_i32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xae,0x01]

v_max3_i32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xb2,0x01]

v_max3_i32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xb6,0x01]

v_max3_i32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xba,0x01]

v_max3_i32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xbe,0x01]

v_max3_i32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xee,0x01]

v_max3_i32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xf2,0x01]

v_max3_i32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xfa,0x01]

v_max3_i32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xfe,0x01]

v_max3_i32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x02,0x02]

v_max3_i32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0x06,0x03]

v_max3_i32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xc2,0x03]

v_max3_i32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xde,0x03]

v_max3_i32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xee,0x03]

v_max3_i32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xf2,0x03]

v_max3_i32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd4,0xd1,0x01,0x05,0xf6,0x03]

v_max3_u32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x0e,0x04]

v_max3_u32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd5,0xd1,0x01,0x05,0x0e,0x04]

v_max3_u32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xff,0x05,0x0e,0x04]

v_max3_u32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x04,0x0e,0x04]

v_max3_u32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x65,0x04,0x0e,0x04]

v_max3_u32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x66,0x04,0x0e,0x04]

v_max3_u32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x67,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6a,0x04,0x0e,0x04]

v_max3_u32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6b,0x04,0x0e,0x04]

v_max3_u32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6c,0x04,0x0e,0x04]

v_max3_u32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6d,0x04,0x0e,0x04]

v_max3_u32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6e,0x04,0x0e,0x04]

v_max3_u32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x6f,0x04,0x0e,0x04]

v_max3_u32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x7b,0x04,0x0e,0x04]

v_max3_u32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x7c,0x04,0x0e,0x04]

v_max3_u32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x7e,0x04,0x0e,0x04]

v_max3_u32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x7f,0x04,0x0e,0x04]

v_max3_u32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x80,0x04,0x0e,0x04]

v_max3_u32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xc1,0x04,0x0e,0x04]

v_max3_u32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xf0,0x04,0x0e,0x04]

v_max3_u32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xf7,0x04,0x0e,0x04]

v_max3_u32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xfb,0x04,0x0e,0x04]

v_max3_u32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xfc,0x04,0x0e,0x04]

v_max3_u32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xfd,0x04,0x0e,0x04]

v_max3_u32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0xfe,0x04,0x0e,0x04]

v_max3_u32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xff,0x0f,0x04]

v_max3_u32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x0c,0x04]

v_max3_u32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xcb,0x0c,0x04]

v_max3_u32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xcd,0x0c,0x04]

v_max3_u32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xcf,0x0c,0x04]

v_max3_u32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xd5,0x0c,0x04]

v_max3_u32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xd7,0x0c,0x04]

v_max3_u32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xd9,0x0c,0x04]

v_max3_u32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xdb,0x0c,0x04]

v_max3_u32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xdd,0x0c,0x04]

v_max3_u32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xdf,0x0c,0x04]

v_max3_u32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xf7,0x0c,0x04]

v_max3_u32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xf9,0x0c,0x04]

v_max3_u32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xfd,0x0c,0x04]

v_max3_u32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xff,0x0c,0x04]

v_max3_u32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x01,0x0d,0x04]

v_max3_u32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x83,0x0d,0x04]

v_max3_u32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xe1,0x0d,0x04]

v_max3_u32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xef,0x0d,0x04]

v_max3_u32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xf7,0x0d,0x04]

v_max3_u32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xf9,0x0d,0x04]

v_max3_u32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0xfb,0x0d,0x04]

v_max3_u32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xfe,0x07]

v_max3_u32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x0e,0x00]

v_max3_u32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x96,0x01]

v_max3_u32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x9a,0x01]

v_max3_u32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x9e,0x01]

v_max3_u32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xaa,0x01]

v_max3_u32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xae,0x01]

v_max3_u32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xb2,0x01]

v_max3_u32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xb6,0x01]

v_max3_u32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xba,0x01]

v_max3_u32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xbe,0x01]

v_max3_u32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xee,0x01]

v_max3_u32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xf2,0x01]

v_max3_u32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xfa,0x01]

v_max3_u32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xfe,0x01]

v_max3_u32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x02,0x02]

v_max3_u32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0x06,0x03]

v_max3_u32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xc2,0x03]

v_max3_u32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xde,0x03]

v_max3_u32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xee,0x03]

v_max3_u32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xf2,0x03]

v_max3_u32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd5,0xd1,0x01,0x05,0xf6,0x03]

v_med3_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xff,0x05,0x0e,0x04]

v_med3_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x04,0x0e,0x04]

v_med3_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x65,0x04,0x0e,0x04]

v_med3_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x66,0x04,0x0e,0x04]

v_med3_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x67,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6a,0x04,0x0e,0x04]

v_med3_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6b,0x04,0x0e,0x04]

v_med3_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6c,0x04,0x0e,0x04]

v_med3_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6d,0x04,0x0e,0x04]

v_med3_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6e,0x04,0x0e,0x04]

v_med3_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x6f,0x04,0x0e,0x04]

v_med3_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x7b,0x04,0x0e,0x04]

v_med3_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x7c,0x04,0x0e,0x04]

v_med3_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x7e,0x04,0x0e,0x04]

v_med3_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x7f,0x04,0x0e,0x04]

v_med3_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x80,0x04,0x0e,0x04]

v_med3_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xc1,0x04,0x0e,0x04]

v_med3_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xf0,0x04,0x0e,0x04]

v_med3_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xf7,0x04,0x0e,0x04]

v_med3_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xfb,0x04,0x0e,0x04]

v_med3_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xfc,0x04,0x0e,0x04]

v_med3_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xfd,0x04,0x0e,0x04]

v_med3_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0xfe,0x04,0x0e,0x04]

v_med3_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xff,0x0f,0x04]

v_med3_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0c,0x04]

v_med3_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xcb,0x0c,0x04]

v_med3_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xcd,0x0c,0x04]

v_med3_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xcf,0x0c,0x04]

v_med3_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xd5,0x0c,0x04]

v_med3_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xd7,0x0c,0x04]

v_med3_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xd9,0x0c,0x04]

v_med3_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xdb,0x0c,0x04]

v_med3_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xdd,0x0c,0x04]

v_med3_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xdf,0x0c,0x04]

v_med3_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xf7,0x0c,0x04]

v_med3_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xf9,0x0c,0x04]

v_med3_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xfd,0x0c,0x04]

v_med3_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xff,0x0c,0x04]

v_med3_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x01,0x0d,0x04]

v_med3_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x83,0x0d,0x04]

v_med3_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xe1,0x0d,0x04]

v_med3_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xef,0x0d,0x04]

v_med3_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xf7,0x0d,0x04]

v_med3_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xf9,0x0d,0x04]

v_med3_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0xfb,0x0d,0x04]

v_med3_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xfe,0x07]

v_med3_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x00]

v_med3_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x96,0x01]

v_med3_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x9a,0x01]

v_med3_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x9e,0x01]

v_med3_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xaa,0x01]

v_med3_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xae,0x01]

v_med3_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xb2,0x01]

v_med3_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xb6,0x01]

v_med3_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xba,0x01]

v_med3_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xbe,0x01]

v_med3_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xee,0x01]

v_med3_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xf2,0x01]

v_med3_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xfa,0x01]

v_med3_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xfe,0x01]

v_med3_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x02,0x02]

v_med3_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x06,0x03]

v_med3_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xc2,0x03]

v_med3_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xde,0x03]

v_med3_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xee,0x03]

v_med3_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xf2,0x03]

v_med3_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0xf6,0x03]

v_med3_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x24]

v_med3_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x44]

v_med3_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x84]

v_med3_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0xe4]

v_med3_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xd6,0xd1,0x01,0x05,0x0e,0x04]

v_med3_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x0c]

v_med3_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x14]

v_med3_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xd6,0xd1,0x01,0x05,0x0e,0x1c]

v_med3_i32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x0e,0x04]

v_med3_i32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd7,0xd1,0x01,0x05,0x0e,0x04]

v_med3_i32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xff,0x05,0x0e,0x04]

v_med3_i32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x04,0x0e,0x04]

v_med3_i32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x65,0x04,0x0e,0x04]

v_med3_i32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x66,0x04,0x0e,0x04]

v_med3_i32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x67,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6a,0x04,0x0e,0x04]

v_med3_i32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6b,0x04,0x0e,0x04]

v_med3_i32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6c,0x04,0x0e,0x04]

v_med3_i32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6d,0x04,0x0e,0x04]

v_med3_i32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6e,0x04,0x0e,0x04]

v_med3_i32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x6f,0x04,0x0e,0x04]

v_med3_i32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x7b,0x04,0x0e,0x04]

v_med3_i32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x7c,0x04,0x0e,0x04]

v_med3_i32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x7e,0x04,0x0e,0x04]

v_med3_i32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x7f,0x04,0x0e,0x04]

v_med3_i32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x80,0x04,0x0e,0x04]

v_med3_i32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xc1,0x04,0x0e,0x04]

v_med3_i32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xf0,0x04,0x0e,0x04]

v_med3_i32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xf7,0x04,0x0e,0x04]

v_med3_i32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xfb,0x04,0x0e,0x04]

v_med3_i32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xfc,0x04,0x0e,0x04]

v_med3_i32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xfd,0x04,0x0e,0x04]

v_med3_i32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0xfe,0x04,0x0e,0x04]

v_med3_i32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xff,0x0f,0x04]

v_med3_i32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x0c,0x04]

v_med3_i32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xcb,0x0c,0x04]

v_med3_i32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xcd,0x0c,0x04]

v_med3_i32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xcf,0x0c,0x04]

v_med3_i32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xd5,0x0c,0x04]

v_med3_i32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xd7,0x0c,0x04]

v_med3_i32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xd9,0x0c,0x04]

v_med3_i32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xdb,0x0c,0x04]

v_med3_i32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xdd,0x0c,0x04]

v_med3_i32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xdf,0x0c,0x04]

v_med3_i32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xf7,0x0c,0x04]

v_med3_i32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xf9,0x0c,0x04]

v_med3_i32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xfd,0x0c,0x04]

v_med3_i32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xff,0x0c,0x04]

v_med3_i32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x01,0x0d,0x04]

v_med3_i32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x83,0x0d,0x04]

v_med3_i32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xe1,0x0d,0x04]

v_med3_i32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xef,0x0d,0x04]

v_med3_i32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xf7,0x0d,0x04]

v_med3_i32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xf9,0x0d,0x04]

v_med3_i32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0xfb,0x0d,0x04]

v_med3_i32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xfe,0x07]

v_med3_i32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x0e,0x00]

v_med3_i32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x96,0x01]

v_med3_i32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x9a,0x01]

v_med3_i32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x9e,0x01]

v_med3_i32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xaa,0x01]

v_med3_i32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xae,0x01]

v_med3_i32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xb2,0x01]

v_med3_i32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xb6,0x01]

v_med3_i32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xba,0x01]

v_med3_i32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xbe,0x01]

v_med3_i32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xee,0x01]

v_med3_i32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xf2,0x01]

v_med3_i32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xfa,0x01]

v_med3_i32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xfe,0x01]

v_med3_i32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x02,0x02]

v_med3_i32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0x06,0x03]

v_med3_i32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xc2,0x03]

v_med3_i32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xde,0x03]

v_med3_i32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xee,0x03]

v_med3_i32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xf2,0x03]

v_med3_i32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd7,0xd1,0x01,0x05,0xf6,0x03]

v_med3_u32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x0e,0x04]

v_med3_u32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd8,0xd1,0x01,0x05,0x0e,0x04]

v_med3_u32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xff,0x05,0x0e,0x04]

v_med3_u32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x04,0x0e,0x04]

v_med3_u32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x65,0x04,0x0e,0x04]

v_med3_u32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x66,0x04,0x0e,0x04]

v_med3_u32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x67,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6a,0x04,0x0e,0x04]

v_med3_u32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6b,0x04,0x0e,0x04]

v_med3_u32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6c,0x04,0x0e,0x04]

v_med3_u32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6d,0x04,0x0e,0x04]

v_med3_u32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6e,0x04,0x0e,0x04]

v_med3_u32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x6f,0x04,0x0e,0x04]

v_med3_u32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x7b,0x04,0x0e,0x04]

v_med3_u32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x7c,0x04,0x0e,0x04]

v_med3_u32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x7e,0x04,0x0e,0x04]

v_med3_u32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x7f,0x04,0x0e,0x04]

v_med3_u32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x80,0x04,0x0e,0x04]

v_med3_u32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xc1,0x04,0x0e,0x04]

v_med3_u32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xf0,0x04,0x0e,0x04]

v_med3_u32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xf7,0x04,0x0e,0x04]

v_med3_u32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xfb,0x04,0x0e,0x04]

v_med3_u32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xfc,0x04,0x0e,0x04]

v_med3_u32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xfd,0x04,0x0e,0x04]

v_med3_u32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0xfe,0x04,0x0e,0x04]

v_med3_u32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xff,0x0f,0x04]

v_med3_u32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x0c,0x04]

v_med3_u32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xcb,0x0c,0x04]

v_med3_u32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xcd,0x0c,0x04]

v_med3_u32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xcf,0x0c,0x04]

v_med3_u32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xd5,0x0c,0x04]

v_med3_u32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xd7,0x0c,0x04]

v_med3_u32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xd9,0x0c,0x04]

v_med3_u32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xdb,0x0c,0x04]

v_med3_u32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xdd,0x0c,0x04]

v_med3_u32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xdf,0x0c,0x04]

v_med3_u32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xf7,0x0c,0x04]

v_med3_u32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xf9,0x0c,0x04]

v_med3_u32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xfd,0x0c,0x04]

v_med3_u32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xff,0x0c,0x04]

v_med3_u32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x01,0x0d,0x04]

v_med3_u32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x83,0x0d,0x04]

v_med3_u32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xe1,0x0d,0x04]

v_med3_u32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xef,0x0d,0x04]

v_med3_u32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xf7,0x0d,0x04]

v_med3_u32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xf9,0x0d,0x04]

v_med3_u32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0xfb,0x0d,0x04]

v_med3_u32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xfe,0x07]

v_med3_u32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x0e,0x00]

v_med3_u32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x96,0x01]

v_med3_u32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x9a,0x01]

v_med3_u32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x9e,0x01]

v_med3_u32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xaa,0x01]

v_med3_u32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xae,0x01]

v_med3_u32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xb2,0x01]

v_med3_u32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xb6,0x01]

v_med3_u32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xba,0x01]

v_med3_u32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xbe,0x01]

v_med3_u32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xee,0x01]

v_med3_u32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xf2,0x01]

v_med3_u32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xfa,0x01]

v_med3_u32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xfe,0x01]

v_med3_u32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x02,0x02]

v_med3_u32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0x06,0x03]

v_med3_u32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xc2,0x03]

v_med3_u32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xde,0x03]

v_med3_u32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xee,0x03]

v_med3_u32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xf2,0x03]

v_med3_u32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd8,0xd1,0x01,0x05,0xf6,0x03]

v_sad_u8 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u8 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xd9,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u8 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xff,0x05,0x0e,0x04]

v_sad_u8 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x04,0x0e,0x04]

v_sad_u8 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x65,0x04,0x0e,0x04]

v_sad_u8 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x66,0x04,0x0e,0x04]

v_sad_u8 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x67,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6a,0x04,0x0e,0x04]

v_sad_u8 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6b,0x04,0x0e,0x04]

v_sad_u8 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6c,0x04,0x0e,0x04]

v_sad_u8 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6d,0x04,0x0e,0x04]

v_sad_u8 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6e,0x04,0x0e,0x04]

v_sad_u8 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x6f,0x04,0x0e,0x04]

v_sad_u8 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x7b,0x04,0x0e,0x04]

v_sad_u8 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x7c,0x04,0x0e,0x04]

v_sad_u8 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x7e,0x04,0x0e,0x04]

v_sad_u8 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x7f,0x04,0x0e,0x04]

v_sad_u8 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x80,0x04,0x0e,0x04]

v_sad_u8 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xc1,0x04,0x0e,0x04]

v_sad_u8 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xf0,0x04,0x0e,0x04]

v_sad_u8 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xf7,0x04,0x0e,0x04]

v_sad_u8 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xfb,0x04,0x0e,0x04]

v_sad_u8 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xfc,0x04,0x0e,0x04]

v_sad_u8 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xfd,0x04,0x0e,0x04]

v_sad_u8 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0xfe,0x04,0x0e,0x04]

v_sad_u8 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xff,0x0f,0x04]

v_sad_u8 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x0c,0x04]

v_sad_u8 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xcb,0x0c,0x04]

v_sad_u8 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xcd,0x0c,0x04]

v_sad_u8 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xcf,0x0c,0x04]

v_sad_u8 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xd5,0x0c,0x04]

v_sad_u8 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xd7,0x0c,0x04]

v_sad_u8 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xd9,0x0c,0x04]

v_sad_u8 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xdb,0x0c,0x04]

v_sad_u8 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xdd,0x0c,0x04]

v_sad_u8 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xdf,0x0c,0x04]

v_sad_u8 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xf7,0x0c,0x04]

v_sad_u8 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xf9,0x0c,0x04]

v_sad_u8 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xfd,0x0c,0x04]

v_sad_u8 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xff,0x0c,0x04]

v_sad_u8 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x01,0x0d,0x04]

v_sad_u8 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x83,0x0d,0x04]

v_sad_u8 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xe1,0x0d,0x04]

v_sad_u8 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xef,0x0d,0x04]

v_sad_u8 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xf7,0x0d,0x04]

v_sad_u8 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xf9,0x0d,0x04]

v_sad_u8 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0xfb,0x0d,0x04]

v_sad_u8 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xfe,0x07]

v_sad_u8 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x0e,0x00]

v_sad_u8 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x96,0x01]

v_sad_u8 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x9a,0x01]

v_sad_u8 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x9e,0x01]

v_sad_u8 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xaa,0x01]

v_sad_u8 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xae,0x01]

v_sad_u8 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xb2,0x01]

v_sad_u8 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xb6,0x01]

v_sad_u8 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xba,0x01]

v_sad_u8 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xbe,0x01]

v_sad_u8 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xee,0x01]

v_sad_u8 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xf2,0x01]

v_sad_u8 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xfa,0x01]

v_sad_u8 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xfe,0x01]

v_sad_u8 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x02,0x02]

v_sad_u8 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0x06,0x03]

v_sad_u8 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xc2,0x03]

v_sad_u8 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xde,0x03]

v_sad_u8 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xee,0x03]

v_sad_u8 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xf2,0x03]

v_sad_u8 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xd9,0xd1,0x01,0x05,0xf6,0x03]

v_sad_u8 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xd9,0xd1,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xda,0xd1,0x01,0x05,0x0e,0x04]

v_sad_hi_u8 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xff,0x05,0x0e,0x04]

v_sad_hi_u8 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x04,0x0e,0x04]

v_sad_hi_u8 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x65,0x04,0x0e,0x04]

v_sad_hi_u8 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x66,0x04,0x0e,0x04]

v_sad_hi_u8 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x67,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6a,0x04,0x0e,0x04]

v_sad_hi_u8 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6b,0x04,0x0e,0x04]

v_sad_hi_u8 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6c,0x04,0x0e,0x04]

v_sad_hi_u8 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6d,0x04,0x0e,0x04]

v_sad_hi_u8 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6e,0x04,0x0e,0x04]

v_sad_hi_u8 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x6f,0x04,0x0e,0x04]

v_sad_hi_u8 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x7b,0x04,0x0e,0x04]

v_sad_hi_u8 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x7c,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x7e,0x04,0x0e,0x04]

v_sad_hi_u8 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x7f,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x80,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xc1,0x04,0x0e,0x04]

v_sad_hi_u8 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xf0,0x04,0x0e,0x04]

v_sad_hi_u8 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xf7,0x04,0x0e,0x04]

v_sad_hi_u8 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xfb,0x04,0x0e,0x04]

v_sad_hi_u8 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xfc,0x04,0x0e,0x04]

v_sad_hi_u8 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xfd,0x04,0x0e,0x04]

v_sad_hi_u8 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0xfe,0x04,0x0e,0x04]

v_sad_hi_u8 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xff,0x0f,0x04]

v_sad_hi_u8 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x0c,0x04]

v_sad_hi_u8 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xcb,0x0c,0x04]

v_sad_hi_u8 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xcd,0x0c,0x04]

v_sad_hi_u8 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xcf,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xd5,0x0c,0x04]

v_sad_hi_u8 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xd7,0x0c,0x04]

v_sad_hi_u8 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xd9,0x0c,0x04]

v_sad_hi_u8 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xdb,0x0c,0x04]

v_sad_hi_u8 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xdd,0x0c,0x04]

v_sad_hi_u8 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xdf,0x0c,0x04]

v_sad_hi_u8 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xf7,0x0c,0x04]

v_sad_hi_u8 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xf9,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xfd,0x0c,0x04]

v_sad_hi_u8 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xff,0x0c,0x04]

v_sad_hi_u8 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x01,0x0d,0x04]

v_sad_hi_u8 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x83,0x0d,0x04]

v_sad_hi_u8 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xe1,0x0d,0x04]

v_sad_hi_u8 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xef,0x0d,0x04]

v_sad_hi_u8 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xf7,0x0d,0x04]

v_sad_hi_u8 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xf9,0x0d,0x04]

v_sad_hi_u8 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0xfb,0x0d,0x04]

v_sad_hi_u8 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xfe,0x07]

v_sad_hi_u8 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x0e,0x00]

v_sad_hi_u8 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x96,0x01]

v_sad_hi_u8 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x9a,0x01]

v_sad_hi_u8 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x9e,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xaa,0x01]

v_sad_hi_u8 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xae,0x01]

v_sad_hi_u8 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xb2,0x01]

v_sad_hi_u8 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xb6,0x01]

v_sad_hi_u8 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xba,0x01]

v_sad_hi_u8 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xbe,0x01]

v_sad_hi_u8 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xee,0x01]

v_sad_hi_u8 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xf2,0x01]

v_sad_hi_u8 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xfa,0x01]

v_sad_hi_u8 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xfe,0x01]

v_sad_hi_u8 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x02,0x02]

v_sad_hi_u8 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0x06,0x03]

v_sad_hi_u8 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xc2,0x03]

v_sad_hi_u8 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xde,0x03]

v_sad_hi_u8 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xee,0x03]

v_sad_hi_u8 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xf2,0x03]

v_sad_hi_u8 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xda,0xd1,0x01,0x05,0xf6,0x03]

v_sad_hi_u8 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xda,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xdb,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xff,0x05,0x0e,0x04]

v_sad_u16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x04,0x0e,0x04]

v_sad_u16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x65,0x04,0x0e,0x04]

v_sad_u16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x66,0x04,0x0e,0x04]

v_sad_u16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x67,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6a,0x04,0x0e,0x04]

v_sad_u16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6b,0x04,0x0e,0x04]

v_sad_u16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6c,0x04,0x0e,0x04]

v_sad_u16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6d,0x04,0x0e,0x04]

v_sad_u16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6e,0x04,0x0e,0x04]

v_sad_u16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x6f,0x04,0x0e,0x04]

v_sad_u16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x7b,0x04,0x0e,0x04]

v_sad_u16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x7c,0x04,0x0e,0x04]

v_sad_u16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x7e,0x04,0x0e,0x04]

v_sad_u16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x7f,0x04,0x0e,0x04]

v_sad_u16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x80,0x04,0x0e,0x04]

v_sad_u16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xc1,0x04,0x0e,0x04]

v_sad_u16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xf0,0x04,0x0e,0x04]

v_sad_u16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xf7,0x04,0x0e,0x04]

v_sad_u16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xfb,0x04,0x0e,0x04]

v_sad_u16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xfc,0x04,0x0e,0x04]

v_sad_u16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xfd,0x04,0x0e,0x04]

v_sad_u16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0xfe,0x04,0x0e,0x04]

v_sad_u16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xff,0x0f,0x04]

v_sad_u16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x0c,0x04]

v_sad_u16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xcb,0x0c,0x04]

v_sad_u16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xcd,0x0c,0x04]

v_sad_u16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xcf,0x0c,0x04]

v_sad_u16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xd5,0x0c,0x04]

v_sad_u16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xd7,0x0c,0x04]

v_sad_u16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xd9,0x0c,0x04]

v_sad_u16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xdb,0x0c,0x04]

v_sad_u16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xdd,0x0c,0x04]

v_sad_u16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xdf,0x0c,0x04]

v_sad_u16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xf7,0x0c,0x04]

v_sad_u16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xf9,0x0c,0x04]

v_sad_u16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xfd,0x0c,0x04]

v_sad_u16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xff,0x0c,0x04]

v_sad_u16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x01,0x0d,0x04]

v_sad_u16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x83,0x0d,0x04]

v_sad_u16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xe1,0x0d,0x04]

v_sad_u16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xef,0x0d,0x04]

v_sad_u16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xf7,0x0d,0x04]

v_sad_u16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xf9,0x0d,0x04]

v_sad_u16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0xfb,0x0d,0x04]

v_sad_u16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xfe,0x07]

v_sad_u16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x0e,0x00]

v_sad_u16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x96,0x01]

v_sad_u16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x9a,0x01]

v_sad_u16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x9e,0x01]

v_sad_u16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xaa,0x01]

v_sad_u16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xae,0x01]

v_sad_u16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xb2,0x01]

v_sad_u16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xb6,0x01]

v_sad_u16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xba,0x01]

v_sad_u16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xbe,0x01]

v_sad_u16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xee,0x01]

v_sad_u16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xf2,0x01]

v_sad_u16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xfa,0x01]

v_sad_u16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xfe,0x01]

v_sad_u16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x02,0x02]

v_sad_u16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0x06,0x03]

v_sad_u16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xc2,0x03]

v_sad_u16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xde,0x03]

v_sad_u16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xee,0x03]

v_sad_u16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xf2,0x03]

v_sad_u16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xdb,0xd1,0x01,0x05,0xf6,0x03]

v_sad_u16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xdb,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xdc,0xd1,0x01,0x05,0x0e,0x04]

v_sad_u32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xff,0x05,0x0e,0x04]

v_sad_u32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x04,0x0e,0x04]

v_sad_u32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x65,0x04,0x0e,0x04]

v_sad_u32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x66,0x04,0x0e,0x04]

v_sad_u32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x67,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6a,0x04,0x0e,0x04]

v_sad_u32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6b,0x04,0x0e,0x04]

v_sad_u32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6c,0x04,0x0e,0x04]

v_sad_u32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6d,0x04,0x0e,0x04]

v_sad_u32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6e,0x04,0x0e,0x04]

v_sad_u32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x6f,0x04,0x0e,0x04]

v_sad_u32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x7b,0x04,0x0e,0x04]

v_sad_u32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x7c,0x04,0x0e,0x04]

v_sad_u32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x7e,0x04,0x0e,0x04]

v_sad_u32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x7f,0x04,0x0e,0x04]

v_sad_u32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x80,0x04,0x0e,0x04]

v_sad_u32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xc1,0x04,0x0e,0x04]

v_sad_u32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xf0,0x04,0x0e,0x04]

v_sad_u32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xf7,0x04,0x0e,0x04]

v_sad_u32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xfb,0x04,0x0e,0x04]

v_sad_u32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xfc,0x04,0x0e,0x04]

v_sad_u32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xfd,0x04,0x0e,0x04]

v_sad_u32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0xfe,0x04,0x0e,0x04]

v_sad_u32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xff,0x0f,0x04]

v_sad_u32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x0c,0x04]

v_sad_u32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xcb,0x0c,0x04]

v_sad_u32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xcd,0x0c,0x04]

v_sad_u32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xcf,0x0c,0x04]

v_sad_u32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xd5,0x0c,0x04]

v_sad_u32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xd7,0x0c,0x04]

v_sad_u32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xd9,0x0c,0x04]

v_sad_u32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xdb,0x0c,0x04]

v_sad_u32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xdd,0x0c,0x04]

v_sad_u32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xdf,0x0c,0x04]

v_sad_u32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xf7,0x0c,0x04]

v_sad_u32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xf9,0x0c,0x04]

v_sad_u32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xfd,0x0c,0x04]

v_sad_u32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xff,0x0c,0x04]

v_sad_u32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x01,0x0d,0x04]

v_sad_u32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x83,0x0d,0x04]

v_sad_u32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xe1,0x0d,0x04]

v_sad_u32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xef,0x0d,0x04]

v_sad_u32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xf7,0x0d,0x04]

v_sad_u32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xf9,0x0d,0x04]

v_sad_u32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0xfb,0x0d,0x04]

v_sad_u32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xfe,0x07]

v_sad_u32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x0e,0x00]

v_sad_u32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x96,0x01]

v_sad_u32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x9a,0x01]

v_sad_u32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x9e,0x01]

v_sad_u32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xaa,0x01]

v_sad_u32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xae,0x01]

v_sad_u32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xb2,0x01]

v_sad_u32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xb6,0x01]

v_sad_u32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xba,0x01]

v_sad_u32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xbe,0x01]

v_sad_u32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xee,0x01]

v_sad_u32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xf2,0x01]

v_sad_u32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xfa,0x01]

v_sad_u32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xfe,0x01]

v_sad_u32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x02,0x02]

v_sad_u32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0x06,0x03]

v_sad_u32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xc2,0x03]

v_sad_u32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xde,0x03]

v_sad_u32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xee,0x03]

v_sad_u32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xf2,0x03]

v_sad_u32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xdc,0xd1,0x01,0x05,0xf6,0x03]

v_sad_u32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xdc,0xd1,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xdd,0xd1,0x01,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xff,0x05,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x65,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x66,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x67,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6a,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6b,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6c,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6d,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6e,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x6f,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x7b,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x7c,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x7e,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x7f,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x80,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xc1,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xf0,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xf7,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xfb,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xfc,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xfd,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0xfe,0x04,0x0e,0x04]

v_cvt_pk_u8_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xff,0x0f,0x04]

v_cvt_pk_u8_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xcb,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xcd,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xcf,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xd5,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xd7,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xd9,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xdb,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xdd,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xdf,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xf7,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xf9,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xfd,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xff,0x0c,0x04]

v_cvt_pk_u8_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x01,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x83,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xe1,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xef,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xf7,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xf9,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0xfb,0x0d,0x04]

v_cvt_pk_u8_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xfe,0x07]

v_cvt_pk_u8_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x0e,0x00]

v_cvt_pk_u8_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x96,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x9a,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x9e,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xaa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xae,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xb2,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xb6,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xba,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xbe,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xee,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xf2,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xfa,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xfe,0x01]

v_cvt_pk_u8_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x02,0x02]

v_cvt_pk_u8_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x06,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xc2,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xde,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xee,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xf2,0x03]

v_cvt_pk_u8_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0xf6,0x03]

v_cvt_pk_u8_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xdd,0xd1,0x01,0x05,0x0e,0x24]

v_cvt_pk_u8_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xdd,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xff,0x05,0x0e,0x04]

v_div_fixup_f32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x04,0x0e,0x04]

v_div_fixup_f32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x65,0x04,0x0e,0x04]

v_div_fixup_f32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x66,0x04,0x0e,0x04]

v_div_fixup_f32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x67,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6a,0x04,0x0e,0x04]

v_div_fixup_f32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6b,0x04,0x0e,0x04]

v_div_fixup_f32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6c,0x04,0x0e,0x04]

v_div_fixup_f32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6d,0x04,0x0e,0x04]

v_div_fixup_f32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6e,0x04,0x0e,0x04]

v_div_fixup_f32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x6f,0x04,0x0e,0x04]

v_div_fixup_f32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x7b,0x04,0x0e,0x04]

v_div_fixup_f32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x7c,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x7e,0x04,0x0e,0x04]

v_div_fixup_f32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x7f,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x80,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xc1,0x04,0x0e,0x04]

v_div_fixup_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xf0,0x04,0x0e,0x04]

v_div_fixup_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xf7,0x04,0x0e,0x04]

v_div_fixup_f32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xfb,0x04,0x0e,0x04]

v_div_fixup_f32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xfc,0x04,0x0e,0x04]

v_div_fixup_f32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xfd,0x04,0x0e,0x04]

v_div_fixup_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0xfe,0x04,0x0e,0x04]

v_div_fixup_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xff,0x0f,0x04]

v_div_fixup_f32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0c,0x04]

v_div_fixup_f32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xcb,0x0c,0x04]

v_div_fixup_f32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xcd,0x0c,0x04]

v_div_fixup_f32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xcf,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xd5,0x0c,0x04]

v_div_fixup_f32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xd7,0x0c,0x04]

v_div_fixup_f32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xd9,0x0c,0x04]

v_div_fixup_f32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xdb,0x0c,0x04]

v_div_fixup_f32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xdd,0x0c,0x04]

v_div_fixup_f32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xdf,0x0c,0x04]

v_div_fixup_f32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xf7,0x0c,0x04]

v_div_fixup_f32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xf9,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xfd,0x0c,0x04]

v_div_fixup_f32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xff,0x0c,0x04]

v_div_fixup_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x01,0x0d,0x04]

v_div_fixup_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x83,0x0d,0x04]

v_div_fixup_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xe1,0x0d,0x04]

v_div_fixup_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xef,0x0d,0x04]

v_div_fixup_f32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xf7,0x0d,0x04]

v_div_fixup_f32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xf9,0x0d,0x04]

v_div_fixup_f32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0xfb,0x0d,0x04]

v_div_fixup_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xfe,0x07]

v_div_fixup_f32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x00]

v_div_fixup_f32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x96,0x01]

v_div_fixup_f32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x9a,0x01]

v_div_fixup_f32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x9e,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xaa,0x01]

v_div_fixup_f32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xae,0x01]

v_div_fixup_f32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xb2,0x01]

v_div_fixup_f32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xb6,0x01]

v_div_fixup_f32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xba,0x01]

v_div_fixup_f32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xbe,0x01]

v_div_fixup_f32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xee,0x01]

v_div_fixup_f32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xf2,0x01]

v_div_fixup_f32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xfa,0x01]

v_div_fixup_f32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xfe,0x01]

v_div_fixup_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x02,0x02]

v_div_fixup_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x06,0x03]

v_div_fixup_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xc2,0x03]

v_div_fixup_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xde,0x03]

v_div_fixup_f32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xee,0x03]

v_div_fixup_f32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xf2,0x03]

v_div_fixup_f32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0xf6,0x03]

v_div_fixup_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x24]

v_div_fixup_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x44]

v_div_fixup_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x84]

v_div_fixup_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0xe4]

v_div_fixup_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xde,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x0c]

v_div_fixup_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x14]

v_div_fixup_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xde,0xd1,0x01,0x05,0x0e,0x1c]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// CHECK: [0xfe,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xfe,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[2:3], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x02,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[4:5], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x04,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], s[100:101], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x64,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], flat_scratch, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x66,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], vcc, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x6a,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], tba, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x6c,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], tma, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x6e,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], ttmp[10:11], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x7a,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], exec, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x7e,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x80,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -1, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xc1,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], 0.5, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xf0,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], -4.0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xf7,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], src_vccz, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xfb,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], src_execz, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xfc,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], src_scc, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0xfd,0x04,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xfd,0x0f,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[4:5], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x09,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[6:7], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x0d,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], s[100:101], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xc9,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], flat_scratch, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xcd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], vcc, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xd5,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], tba, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xd9,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], tma, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xdd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], ttmp[10:11], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xf5,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], exec, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xfd,0x0c,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x01,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -1, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x83,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xe1,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xef,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], src_vccz, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xf7,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], src_execz, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xf9,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], src_scc, v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0xfb,0x0d,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xfa,0x07]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[6:7]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x1a,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[8:9]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x22,0x00]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], s[100:101]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x92,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], flat_scratch
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x9a,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], vcc
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xaa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], tba
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xb2,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], tma
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xba,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], ttmp[10:11]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xea,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], exec
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xfa,0x01]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x02,0x02]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -1
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x06,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], 0.5
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xc2,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -4.0
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xde,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], src_vccz
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xee,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], src_execz
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xf2,0x03]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], src_scc
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0xf6,0x03]

v_div_fixup_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x24]

v_div_fixup_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x44]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x84]

v_div_fixup_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0xe4]

v_div_fixup_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// CHECK: [0x05,0x01,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// CHECK: [0x05,0x02,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// CHECK: [0x05,0x04,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// CHECK: [0x05,0x07,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// CHECK: [0x05,0x80,0xdf,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x0c]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x14]

v_div_fixup_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// CHECK: [0x05,0x00,0xdf,0xd1,0x01,0x05,0x0e,0x1c]

v_div_scale_f32 v5, vcc, v1, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x0e,0x04]

v_div_scale_f32 v255, vcc, v1, v2, v3
// CHECK: [0xff,0x6a,0xe0,0xd1,0x01,0x05,0x0e,0x04]

v_div_scale_f32 v5, vcc, v255, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xff,0x05,0x0e,0x04]

v_div_scale_f32 v5, vcc, s1, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, s101, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x65,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x66,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x67,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, vcc_lo, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6a,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, vcc_hi, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6b,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, tba_lo, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6c,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, tba_hi, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6d,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, tma_lo, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6e,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, tma_hi, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x6f,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, ttmp11, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x7b,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, m0, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x7c,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, exec_lo, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x7e,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, exec_hi, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x7f,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, 0, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x80,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, -1, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xc1,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, 0.5, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xf0,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, -4.0, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xf7,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, src_vccz, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xfb,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, src_execz, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xfc,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, src_scc, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xfd,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, src_lds_direct, v2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0xfe,0x04,0x0e,0x04]

v_div_scale_f32 v5, vcc, v1, v255, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xff,0x0f,0x04]

v_div_scale_f32 v5, vcc, v1, s2, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, s101, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xcb,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xcd,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xcf,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, vcc_lo, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xd5,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, vcc_hi, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xd7,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, tba_lo, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xd9,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, tba_hi, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xdb,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, tma_lo, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xdd,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, tma_hi, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xdf,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, ttmp11, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xf7,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, m0, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xf9,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, exec_lo, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xfd,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, exec_hi, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xff,0x0c,0x04]

v_div_scale_f32 v5, vcc, v1, 0, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x01,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, -1, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x83,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, 0.5, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xe1,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, -4.0, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xef,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, src_vccz, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xf7,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, src_execz, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xf9,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, src_scc, v3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0xfb,0x0d,0x04]

v_div_scale_f32 v5, vcc, v1, v2, v255
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xfe,0x07]

v_div_scale_f32 v5, vcc, v1, v2, s3
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x0e,0x00]

v_div_scale_f32 v5, vcc, v1, v2, s101
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x96,0x01]

v_div_scale_f32 v5, vcc, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x9a,0x01]

v_div_scale_f32 v5, vcc, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x9e,0x01]

v_div_scale_f32 v5, vcc, v1, v2, vcc_lo
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xaa,0x01]

v_div_scale_f32 v5, vcc, v1, v2, vcc_hi
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xae,0x01]

v_div_scale_f32 v5, vcc, v1, v2, tba_lo
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xb2,0x01]

v_div_scale_f32 v5, vcc, v1, v2, tba_hi
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xb6,0x01]

v_div_scale_f32 v5, vcc, v1, v2, tma_lo
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xba,0x01]

v_div_scale_f32 v5, vcc, v1, v2, tma_hi
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xbe,0x01]

v_div_scale_f32 v5, vcc, v1, v2, ttmp11
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xee,0x01]

v_div_scale_f32 v5, vcc, v1, v2, m0
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xf2,0x01]

v_div_scale_f32 v5, vcc, v1, v2, exec_lo
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xfa,0x01]

v_div_scale_f32 v5, vcc, v1, v2, exec_hi
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xfe,0x01]

v_div_scale_f32 v5, vcc, v1, v2, 0
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x02,0x02]

v_div_scale_f32 v5, vcc, v1, v2, -1
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0x06,0x03]

v_div_scale_f32 v5, vcc, v1, v2, 0.5
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xc2,0x03]

v_div_scale_f32 v5, vcc, v1, v2, -4.0
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xde,0x03]

v_div_scale_f32 v5, vcc, v1, v2, src_vccz
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xee,0x03]

v_div_scale_f32 v5, vcc, v1, v2, src_execz
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xf2,0x03]

v_div_scale_f32 v5, vcc, v1, v2, src_scc
// CHECK: [0x05,0x6a,0xe0,0xd1,0x01,0x05,0xf6,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x0e,0x04]

v_div_scale_f64 v[254:255], vcc, v[1:2], v[2:3], v[3:4]
// CHECK: [0xfe,0x6a,0xe1,0xd1,0x01,0x05,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, v[254:255], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xfe,0x05,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, s[2:3], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x02,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, s[4:5], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x04,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, s[100:101], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x64,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, flat_scratch, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x66,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, vcc, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x6a,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, tba, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x6c,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, tma, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x6e,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, ttmp[10:11], v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x7a,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, exec, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x7e,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, 0, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x80,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, -1, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xc1,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, 0.5, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xf0,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, -4.0, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xf7,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, src_vccz, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xfb,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, src_execz, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xfc,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, src_scc, v[2:3], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0xfd,0x04,0x0e,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[254:255], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xfd,0x0f,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], s[4:5], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x09,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], s[6:7], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x0d,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], s[100:101], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xc9,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], flat_scratch, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xcd,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], vcc, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xd5,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], tba, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xd9,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], tma, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xdd,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], ttmp[10:11], v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xf5,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], exec, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xfd,0x0c,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], 0, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x01,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], -1, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x83,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xe1,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xef,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], src_vccz, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xf7,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], src_execz, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xf9,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], src_scc, v[3:4]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0xfb,0x0d,0x04]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], v[254:255]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xfa,0x07]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], s[6:7]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x1a,0x00]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], s[8:9]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x22,0x00]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], s[100:101]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x92,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], flat_scratch
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x9a,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], vcc
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xaa,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], tba
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xb2,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], tma
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xba,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], ttmp[10:11]
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xea,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], exec
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xfa,0x01]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], 0
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x02,0x02]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], -1
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0x06,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], 0.5
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xc2,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], -4.0
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xde,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], src_vccz
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xee,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], src_execz
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xf2,0x03]

v_div_scale_f64 v[5:6], vcc, v[1:2], v[2:3], src_scc
// CHECK: [0x05,0x6a,0xe1,0xd1,0x01,0x05,0xf6,0x03]

v_div_fmas_f32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0xff,0x05,0x0e,0x04]

v_div_fmas_f32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x80,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0xc1,0x04,0x0e,0x04]

v_div_fmas_f32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0xf0,0x04,0x0e,0x04]

v_div_fmas_f32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0xf7,0x04,0x0e,0x04]

v_div_fmas_f32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0xfe,0x04,0x0e,0x04]

v_div_fmas_f32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0xff,0x0f,0x04]

v_div_fmas_f32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x01,0x0d,0x04]

v_div_fmas_f32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x83,0x0d,0x04]

v_div_fmas_f32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0xe1,0x0d,0x04]

v_div_fmas_f32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0xef,0x0d,0x04]

v_div_fmas_f32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0xfe,0x07]

v_div_fmas_f32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x02,0x02]

v_div_fmas_f32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x06,0x03]

v_div_fmas_f32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0xc2,0x03]

v_div_fmas_f32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0xde,0x03]

v_div_fmas_f32 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x24]

v_div_fmas_f32 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x44]

v_div_fmas_f32 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x84]

v_div_fmas_f32 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0xe4]

v_div_fmas_f32 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xe2,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f32 v5, v1, v2, v3 mul:2
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x0c]

v_div_fmas_f32 v5, v1, v2, v3 mul:4
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x14]

v_div_fmas_f32 v5, v1, v2, v3 div:2
// CHECK: [0x05,0x00,0xe2,0xd1,0x01,0x05,0x0e,0x1c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[254:255], v[1:2], v[2:3], v[3:4]
// CHECK: [0xfe,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[254:255], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0xfe,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], vcc, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x6a,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x80,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -1, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0xc1,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], 0.5, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0xf0,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], -4.0, v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0xf7,0x04,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[254:255], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0xfd,0x0f,0x04]

v_div_fmas_f64 v[5:6], v[1:2], vcc, v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0xd5,0x0c,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0, v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x01,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -1, v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x83,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0xe1,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0xef,0x0d,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[254:255]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0xfa,0x07]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], vcc
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0xaa,0x01]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x02,0x02]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -1
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x06,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], 0.5
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0xc2,0x03]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -4.0
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0xde,0x03]

v_div_fmas_f64 v[5:6], -v[1:2], v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x24]

v_div_fmas_f64 v[5:6], v[1:2], -v[2:3], v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x44]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x84]

v_div_fmas_f64 v[5:6], -v[1:2], -v[2:3], -v[3:4]
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0xe4]

v_div_fmas_f64 v[5:6], |v[1:2]|, v[2:3], v[3:4]
// CHECK: [0x05,0x01,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], |v[2:3]|, v[3:4]
// CHECK: [0x05,0x02,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], |v[3:4]|
// CHECK: [0x05,0x04,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], |v[1:2]|, |v[2:3]|, |v[3:4]|
// CHECK: [0x05,0x07,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] clamp
// CHECK: [0x05,0x80,0xe3,0xd1,0x01,0x05,0x0e,0x04]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:2
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x0c]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] mul:4
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x14]

v_div_fmas_f64 v[5:6], v[1:2], v[2:3], v[3:4] div:2
// CHECK: [0x05,0x00,0xe3,0xd1,0x01,0x05,0x0e,0x1c]

v_msad_u8 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x0e,0x04]

v_msad_u8 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xe4,0xd1,0x01,0x05,0x0e,0x04]

v_msad_u8 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xff,0x05,0x0e,0x04]

v_msad_u8 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x04,0x0e,0x04]

v_msad_u8 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x65,0x04,0x0e,0x04]

v_msad_u8 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x66,0x04,0x0e,0x04]

v_msad_u8 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x67,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6a,0x04,0x0e,0x04]

v_msad_u8 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6b,0x04,0x0e,0x04]

v_msad_u8 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6c,0x04,0x0e,0x04]

v_msad_u8 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6d,0x04,0x0e,0x04]

v_msad_u8 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6e,0x04,0x0e,0x04]

v_msad_u8 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x6f,0x04,0x0e,0x04]

v_msad_u8 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x7b,0x04,0x0e,0x04]

v_msad_u8 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x7c,0x04,0x0e,0x04]

v_msad_u8 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x7e,0x04,0x0e,0x04]

v_msad_u8 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x7f,0x04,0x0e,0x04]

v_msad_u8 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x80,0x04,0x0e,0x04]

v_msad_u8 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xc1,0x04,0x0e,0x04]

v_msad_u8 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xf0,0x04,0x0e,0x04]

v_msad_u8 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xf7,0x04,0x0e,0x04]

v_msad_u8 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xfb,0x04,0x0e,0x04]

v_msad_u8 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xfc,0x04,0x0e,0x04]

v_msad_u8 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xfd,0x04,0x0e,0x04]

v_msad_u8 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0xfe,0x04,0x0e,0x04]

v_msad_u8 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xff,0x0f,0x04]

v_msad_u8 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x0c,0x04]

v_msad_u8 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xcb,0x0c,0x04]

v_msad_u8 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xcd,0x0c,0x04]

v_msad_u8 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xcf,0x0c,0x04]

v_msad_u8 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xd5,0x0c,0x04]

v_msad_u8 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xd7,0x0c,0x04]

v_msad_u8 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xd9,0x0c,0x04]

v_msad_u8 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xdb,0x0c,0x04]

v_msad_u8 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xdd,0x0c,0x04]

v_msad_u8 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xdf,0x0c,0x04]

v_msad_u8 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xf7,0x0c,0x04]

v_msad_u8 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xf9,0x0c,0x04]

v_msad_u8 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xfd,0x0c,0x04]

v_msad_u8 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xff,0x0c,0x04]

v_msad_u8 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x01,0x0d,0x04]

v_msad_u8 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x83,0x0d,0x04]

v_msad_u8 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xe1,0x0d,0x04]

v_msad_u8 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xef,0x0d,0x04]

v_msad_u8 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xf7,0x0d,0x04]

v_msad_u8 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xf9,0x0d,0x04]

v_msad_u8 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0xfb,0x0d,0x04]

v_msad_u8 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xfe,0x07]

v_msad_u8 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x0e,0x00]

v_msad_u8 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x96,0x01]

v_msad_u8 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x9a,0x01]

v_msad_u8 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x9e,0x01]

v_msad_u8 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xaa,0x01]

v_msad_u8 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xae,0x01]

v_msad_u8 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xb2,0x01]

v_msad_u8 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xb6,0x01]

v_msad_u8 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xba,0x01]

v_msad_u8 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xbe,0x01]

v_msad_u8 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xee,0x01]

v_msad_u8 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xf2,0x01]

v_msad_u8 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xfa,0x01]

v_msad_u8 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xfe,0x01]

v_msad_u8 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x02,0x02]

v_msad_u8 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0x06,0x03]

v_msad_u8 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xc2,0x03]

v_msad_u8 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xde,0x03]

v_msad_u8 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xee,0x03]

v_msad_u8 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xf2,0x03]

v_msad_u8 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xe4,0xd1,0x01,0x05,0xf6,0x03]

v_msad_u8 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xe4,0xd1,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// CHECK: [0xfe,0x00,0xe5,0xd1,0x01,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xfe,0x05,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x02,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x04,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], s[100:101], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x64,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], flat_scratch, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x66,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x6a,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], tba, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x6c,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], tma, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x6e,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], ttmp[10:11], v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x7a,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x7e,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x80,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xc1,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], 0.5, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xf0,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], -4.0, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xf7,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], src_vccz, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xfb,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], src_execz, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xfc,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], src_scc, v2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0xfd,0x04,0x0e,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xff,0x0f,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], s101, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xcb,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], flat_scratch_lo, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xcd,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], flat_scratch_hi, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xcf,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xd5,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xd7,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], tba_lo, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xd9,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], tba_hi, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xdb,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], tma_lo, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xdd,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], tma_hi, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xdf,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xf7,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xf9,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xfd,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xff,0x0c,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x01,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x83,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xe1,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xef,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], src_vccz, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xf7,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], src_execz, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xf9,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], src_scc, v[3:4]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0xfb,0x0d,0x04]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xfa,0x07]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x1a,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x22,0x00]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, s[100:101]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x92,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, flat_scratch
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x9a,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xaa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, tba
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xb2,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, tma
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xba,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[10:11]
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xea,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xfa,0x01]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x02,0x02]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0x06,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, 0.5
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xc2,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, -4.0
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xde,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, src_vccz
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xee,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, src_execz
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xf2,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, src_scc
// CHECK: [0x05,0x00,0xe5,0xd1,0x01,0x05,0xf6,0x03]

v_qsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4] clamp
// CHECK: [0x05,0x80,0xe5,0xd1,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[254:255], v[1:2], v2, v[3:4]
// CHECK: [0xfe,0x00,0xe6,0xd1,0x01,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[254:255], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xfe,0x05,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[2:3], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x02,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[4:5], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x04,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], s[100:101], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x64,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], flat_scratch, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x66,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], vcc, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x6a,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], tba, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x6c,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], tma, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x6e,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], ttmp[10:11], v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x7a,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], exec, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x7e,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], 0, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x80,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], -1, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xc1,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], 0.5, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xf0,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], -4.0, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xf7,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], src_vccz, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xfb,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], src_execz, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xfc,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], src_scc, v2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0xfd,0x04,0x0e,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v255, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xff,0x0f,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s2, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], s101, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xcb,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], flat_scratch_lo, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xcd,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], flat_scratch_hi, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xcf,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_lo, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xd5,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], vcc_hi, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xd7,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], tba_lo, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xd9,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], tba_hi, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xdb,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], tma_lo, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xdd,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], tma_hi, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xdf,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], ttmp11, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xf7,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], m0, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xf9,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_lo, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xfd,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], exec_hi, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xff,0x0c,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], 0, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x01,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], -1, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x83,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], 0.5, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xe1,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], -4.0, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xef,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], src_vccz, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xf7,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], src_execz, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xf9,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], src_scc, v[3:4]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0xfb,0x0d,0x04]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[254:255]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xfa,0x07]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[6:7]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x1a,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[8:9]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x22,0x00]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, s[100:101]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x92,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, flat_scratch
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x9a,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, vcc
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xaa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, tba
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xb2,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, tma
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xba,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, ttmp[10:11]
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xea,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, exec
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xfa,0x01]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, 0
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x02,0x02]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, -1
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0x06,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, 0.5
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xc2,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, -4.0
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xde,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, src_vccz
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xee,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, src_execz
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xf2,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, src_scc
// CHECK: [0x05,0x00,0xe6,0xd1,0x01,0x05,0xf6,0x03]

v_mqsad_pk_u16_u8 v[5:6], v[1:2], v2, v[3:4] clamp
// CHECK: [0x05,0x80,0xe6,0xd1,0x01,0x05,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0x05,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[2:3], v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x02,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[4:5], v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x04,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], s[100:101], v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x64,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], flat_scratch, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x66,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], vcc, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x6a,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], tba, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x6c,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], tma, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x6e,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], ttmp[10:11], v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x7a,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], exec, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x7e,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], 0, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x80,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], -1, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xc1,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], 0.5, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xf0,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], -4.0, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xf7,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], src_vccz, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xfb,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], src_execz, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xfc,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], src_scc, v2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0xfd,0x04,0x0e,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s2, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0x05,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], s101, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xcb,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], flat_scratch_lo, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xcd,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], flat_scratch_hi, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xcf,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_lo, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xd5,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], vcc_hi, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xd7,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], tba_lo, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xd9,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], tba_hi, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xdb,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], tma_lo, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xdd,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], tma_hi, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xdf,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], ttmp11, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xf7,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], m0, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xf9,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_lo, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xfd,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], exec_hi, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xff,0x0c,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], 0, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0x01,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], -1, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0x83,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], 0.5, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xe1,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], -4.0, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xef,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], src_vccz, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xf7,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], src_execz, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xf9,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], src_scc, v[3:6]
// CHECK: [0xfc,0x00,0xe7,0xd1,0x01,0xfb,0x0d,0x04]

v_mqsad_u32_u8 v[252:255], v[1:2], v2, v[3:6] clamp
// CHECK: [0xfc,0x80,0xe7,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[254:255], s[12:13], v1, v2, v[3:4]
// CHECK: [0xfe,0x0c,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[14:15], v1, v2, v[3:4]
// CHECK: [0x05,0x0e,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[100:101], v1, v2, v[3:4]
// CHECK: [0x05,0x64,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], flat_scratch, v1, v2, v[3:4]
// CHECK: [0x05,0x66,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], vcc, v1, v2, v[3:4]
// CHECK: [0x05,0x6a,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], tba, v1, v2, v[3:4]
// CHECK: [0x05,0x6c,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], tma, v1, v2, v[3:4]
// CHECK: [0x05,0x6e,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], ttmp[10:11], v1, v2, v[3:4]
// CHECK: [0x05,0x7a,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v255, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xff,0x05,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], s1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], s101, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x65,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], flat_scratch_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x66,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], flat_scratch_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x67,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], tba_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], tba_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], tma_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], tma_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], ttmp11, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], m0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], 0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x80,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], -1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], src_vccz, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], src_execz, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], src_scc, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], src_lds_direct, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, v255, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xff,0x0f,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, s2, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, s101, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, flat_scratch_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, flat_scratch_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, tba_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, tba_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, tma_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, tma_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, ttmp11, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, m0, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xff,0x0c,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, 0, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x01,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, -1, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x83,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xef,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, src_vccz, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, src_execz, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, src_scc, v[3:4]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[254:255]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xfa,0x07]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x1a,0x00]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x22,0x00]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, s[100:101]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x92,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x9a,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xaa,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, tba
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xb2,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, tma
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xba,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, ttmp[10:11]
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xea,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, exec
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xfa,0x01]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, 0
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x02,0x02]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -1
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0x06,0x03]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, -4.0
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xde,0x03]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, src_vccz
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xee,0x03]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, src_execz
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xf2,0x03]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, src_scc
// CHECK: [0x05,0x0c,0xe8,0xd1,0x01,0x05,0xf6,0x03]

v_mad_u64_u32 v[5:6], s[12:13], v1, v2, v[3:4] clamp
// CHECK: [0x05,0x8c,0xe8,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[254:255], s[12:13], v1, v2, v[3:4]
// CHECK: [0xfe,0x0c,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[14:15], v1, v2, v[3:4]
// CHECK: [0x05,0x0e,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[100:101], v1, v2, v[3:4]
// CHECK: [0x05,0x64,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], flat_scratch, v1, v2, v[3:4]
// CHECK: [0x05,0x66,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], vcc, v1, v2, v[3:4]
// CHECK: [0x05,0x6a,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], tba, v1, v2, v[3:4]
// CHECK: [0x05,0x6c,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], tma, v1, v2, v[3:4]
// CHECK: [0x05,0x6e,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], ttmp[10:11], v1, v2, v[3:4]
// CHECK: [0x05,0x7a,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v255, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xff,0x05,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], s1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], s101, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x65,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], flat_scratch_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x66,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], flat_scratch_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x67,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], vcc_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], vcc_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], tba_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], tba_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], tma_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], tma_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], ttmp11, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], m0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], exec_lo, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], exec_hi, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], 0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x80,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], -1, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], 0.5, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], -4.0, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], src_vccz, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], src_execz, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], src_scc, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], src_lds_direct, v2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, v255, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xff,0x0f,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, s2, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, s101, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, flat_scratch_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, flat_scratch_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, vcc_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, tba_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, tba_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, tma_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, tma_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, ttmp11, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, m0, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_lo, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, exec_hi, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xff,0x0c,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, 0, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x01,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, -1, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x83,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, 0.5, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, -4.0, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xef,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, src_vccz, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, src_execz, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, src_scc, v[3:4]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[254:255]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xfa,0x07]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x1a,0x00]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x22,0x00]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, s[100:101]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x92,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x9a,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xaa,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, tba
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xb2,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, tma
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xba,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, ttmp[10:11]
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xea,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, exec
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xfa,0x01]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, 0
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x02,0x02]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -1
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0x06,0x03]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, -4.0
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xde,0x03]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, src_vccz
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xee,0x03]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, src_execz
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xf2,0x03]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, src_scc
// CHECK: [0x05,0x0c,0xe9,0xd1,0x01,0x05,0xf6,0x03]

v_mad_i64_i32 v[5:6], s[12:13], v1, v2, v[3:4] clamp
// CHECK: [0x05,0x8c,0xe9,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xff,0x05,0x0e,0x04]

v_mad_f16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x04,0x0e,0x04]

v_mad_f16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x65,0x04,0x0e,0x04]

v_mad_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x66,0x04,0x0e,0x04]

v_mad_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x67,0x04,0x0e,0x04]

v_mad_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_f16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_f16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_f16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_f16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_f16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_f16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_f16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x80,0x04,0x0e,0x04]

v_mad_f16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xf0,0x04,0x0e,0x04]

v_mad_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xf7,0x04,0x0e,0x04]

v_mad_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_f16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xff,0x0f,0x04]

v_mad_f16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0c,0x04]

v_mad_f16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_f16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_f16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_f16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_f16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_f16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_f16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xff,0x0c,0x04]

v_mad_f16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x01,0x0d,0x04]

v_mad_f16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x83,0x0d,0x04]

v_mad_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xe1,0x0d,0x04]

v_mad_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xef,0x0d,0x04]

v_mad_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_f16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xfe,0x07]

v_mad_f16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0x00]

v_mad_f16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x96,0x01]

v_mad_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x9a,0x01]

v_mad_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x9e,0x01]

v_mad_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xaa,0x01]

v_mad_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xae,0x01]

v_mad_f16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xb2,0x01]

v_mad_f16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xb6,0x01]

v_mad_f16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xba,0x01]

v_mad_f16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xbe,0x01]

v_mad_f16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xee,0x01]

v_mad_f16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xf2,0x01]

v_mad_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xfa,0x01]

v_mad_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xfe,0x01]

v_mad_f16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x02,0x02]

v_mad_f16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x06,0x03]

v_mad_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xc2,0x03]

v_mad_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xde,0x03]

v_mad_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xee,0x03]

v_mad_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xf2,0x03]

v_mad_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0xf6,0x03]

v_mad_f16 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0x24]

v_mad_f16 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0x44]

v_mad_f16 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0x84]

v_mad_f16 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xea,0xd1,0x01,0x05,0x0e,0xe4]

v_mad_f16 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xea,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xeb,0xd1,0x01,0x05,0x0e,0x04]

v_mad_u16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xff,0x05,0x0e,0x04]

v_mad_u16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x04,0x0e,0x04]

v_mad_u16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x65,0x04,0x0e,0x04]

v_mad_u16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x66,0x04,0x0e,0x04]

v_mad_u16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x67,0x04,0x0e,0x04]

v_mad_u16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_u16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_u16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_u16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_u16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_u16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_u16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_u16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_u16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_u16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_u16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x80,0x04,0x0e,0x04]

v_mad_u16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_u16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_u16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_u16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_u16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_u16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xff,0x0f,0x04]

v_mad_u16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x0c,0x04]

v_mad_u16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_u16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_u16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_u16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_u16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_u16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_u16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_u16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_u16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_u16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_u16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_u16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_u16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xff,0x0c,0x04]

v_mad_u16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x01,0x0d,0x04]

v_mad_u16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x83,0x0d,0x04]

v_mad_u16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_u16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_u16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_u16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xfe,0x07]

v_mad_u16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x0e,0x00]

v_mad_u16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x96,0x01]

v_mad_u16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x9a,0x01]

v_mad_u16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x9e,0x01]

v_mad_u16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xaa,0x01]

v_mad_u16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xae,0x01]

v_mad_u16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xb2,0x01]

v_mad_u16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xb6,0x01]

v_mad_u16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xba,0x01]

v_mad_u16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xbe,0x01]

v_mad_u16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xee,0x01]

v_mad_u16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xf2,0x01]

v_mad_u16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xfa,0x01]

v_mad_u16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xfe,0x01]

v_mad_u16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x02,0x02]

v_mad_u16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0x06,0x03]

v_mad_u16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xee,0x03]

v_mad_u16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xf2,0x03]

v_mad_u16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xeb,0xd1,0x01,0x05,0xf6,0x03]

v_mad_u16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xeb,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xec,0xd1,0x01,0x05,0x0e,0x04]

v_mad_i16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xff,0x05,0x0e,0x04]

v_mad_i16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x04,0x0e,0x04]

v_mad_i16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x65,0x04,0x0e,0x04]

v_mad_i16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x66,0x04,0x0e,0x04]

v_mad_i16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x67,0x04,0x0e,0x04]

v_mad_i16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6a,0x04,0x0e,0x04]

v_mad_i16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6b,0x04,0x0e,0x04]

v_mad_i16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6c,0x04,0x0e,0x04]

v_mad_i16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6d,0x04,0x0e,0x04]

v_mad_i16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6e,0x04,0x0e,0x04]

v_mad_i16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x6f,0x04,0x0e,0x04]

v_mad_i16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x7b,0x04,0x0e,0x04]

v_mad_i16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x7c,0x04,0x0e,0x04]

v_mad_i16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x7e,0x04,0x0e,0x04]

v_mad_i16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x7f,0x04,0x0e,0x04]

v_mad_i16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x80,0x04,0x0e,0x04]

v_mad_i16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xc1,0x04,0x0e,0x04]

v_mad_i16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xfb,0x04,0x0e,0x04]

v_mad_i16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xfc,0x04,0x0e,0x04]

v_mad_i16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xfd,0x04,0x0e,0x04]

v_mad_i16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0xfe,0x04,0x0e,0x04]

v_mad_i16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xff,0x0f,0x04]

v_mad_i16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x0c,0x04]

v_mad_i16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xcb,0x0c,0x04]

v_mad_i16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xcd,0x0c,0x04]

v_mad_i16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xcf,0x0c,0x04]

v_mad_i16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xd5,0x0c,0x04]

v_mad_i16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xd7,0x0c,0x04]

v_mad_i16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xd9,0x0c,0x04]

v_mad_i16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xdb,0x0c,0x04]

v_mad_i16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xdd,0x0c,0x04]

v_mad_i16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xdf,0x0c,0x04]

v_mad_i16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xf7,0x0c,0x04]

v_mad_i16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xf9,0x0c,0x04]

v_mad_i16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xfd,0x0c,0x04]

v_mad_i16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xff,0x0c,0x04]

v_mad_i16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x01,0x0d,0x04]

v_mad_i16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x83,0x0d,0x04]

v_mad_i16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xf7,0x0d,0x04]

v_mad_i16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xf9,0x0d,0x04]

v_mad_i16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0xfb,0x0d,0x04]

v_mad_i16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xfe,0x07]

v_mad_i16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x0e,0x00]

v_mad_i16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x96,0x01]

v_mad_i16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x9a,0x01]

v_mad_i16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x9e,0x01]

v_mad_i16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xaa,0x01]

v_mad_i16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xae,0x01]

v_mad_i16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xb2,0x01]

v_mad_i16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xb6,0x01]

v_mad_i16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xba,0x01]

v_mad_i16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xbe,0x01]

v_mad_i16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xee,0x01]

v_mad_i16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xf2,0x01]

v_mad_i16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xfa,0x01]

v_mad_i16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xfe,0x01]

v_mad_i16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x02,0x02]

v_mad_i16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0x06,0x03]

v_mad_i16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xee,0x03]

v_mad_i16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xf2,0x03]

v_mad_i16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xec,0xd1,0x01,0x05,0xf6,0x03]

v_mad_i16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xec,0xd1,0x01,0x05,0x0e,0x04]

v_perm_b32 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x0e,0x04]

v_perm_b32 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xed,0xd1,0x01,0x05,0x0e,0x04]

v_perm_b32 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xff,0x05,0x0e,0x04]

v_perm_b32 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x04,0x0e,0x04]

v_perm_b32 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x65,0x04,0x0e,0x04]

v_perm_b32 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x66,0x04,0x0e,0x04]

v_perm_b32 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x67,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6a,0x04,0x0e,0x04]

v_perm_b32 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6b,0x04,0x0e,0x04]

v_perm_b32 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6c,0x04,0x0e,0x04]

v_perm_b32 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6d,0x04,0x0e,0x04]

v_perm_b32 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6e,0x04,0x0e,0x04]

v_perm_b32 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x6f,0x04,0x0e,0x04]

v_perm_b32 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x7b,0x04,0x0e,0x04]

v_perm_b32 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x7c,0x04,0x0e,0x04]

v_perm_b32 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x7e,0x04,0x0e,0x04]

v_perm_b32 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x7f,0x04,0x0e,0x04]

v_perm_b32 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x80,0x04,0x0e,0x04]

v_perm_b32 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xc1,0x04,0x0e,0x04]

v_perm_b32 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xf0,0x04,0x0e,0x04]

v_perm_b32 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xf7,0x04,0x0e,0x04]

v_perm_b32 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xfb,0x04,0x0e,0x04]

v_perm_b32 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xfc,0x04,0x0e,0x04]

v_perm_b32 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xfd,0x04,0x0e,0x04]

v_perm_b32 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0xfe,0x04,0x0e,0x04]

v_perm_b32 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xff,0x0f,0x04]

v_perm_b32 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x0c,0x04]

v_perm_b32 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xcb,0x0c,0x04]

v_perm_b32 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xcd,0x0c,0x04]

v_perm_b32 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xcf,0x0c,0x04]

v_perm_b32 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xd5,0x0c,0x04]

v_perm_b32 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xd7,0x0c,0x04]

v_perm_b32 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xd9,0x0c,0x04]

v_perm_b32 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xdb,0x0c,0x04]

v_perm_b32 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xdd,0x0c,0x04]

v_perm_b32 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xdf,0x0c,0x04]

v_perm_b32 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xf7,0x0c,0x04]

v_perm_b32 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xf9,0x0c,0x04]

v_perm_b32 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xfd,0x0c,0x04]

v_perm_b32 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xff,0x0c,0x04]

v_perm_b32 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x01,0x0d,0x04]

v_perm_b32 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x83,0x0d,0x04]

v_perm_b32 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xe1,0x0d,0x04]

v_perm_b32 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xef,0x0d,0x04]

v_perm_b32 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xf7,0x0d,0x04]

v_perm_b32 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xf9,0x0d,0x04]

v_perm_b32 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0xfb,0x0d,0x04]

v_perm_b32 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xfe,0x07]

v_perm_b32 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x0e,0x00]

v_perm_b32 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x96,0x01]

v_perm_b32 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x9a,0x01]

v_perm_b32 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x9e,0x01]

v_perm_b32 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xaa,0x01]

v_perm_b32 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xae,0x01]

v_perm_b32 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xb2,0x01]

v_perm_b32 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xb6,0x01]

v_perm_b32 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xba,0x01]

v_perm_b32 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xbe,0x01]

v_perm_b32 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xee,0x01]

v_perm_b32 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xf2,0x01]

v_perm_b32 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xfa,0x01]

v_perm_b32 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xfe,0x01]

v_perm_b32 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x02,0x02]

v_perm_b32 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0x06,0x03]

v_perm_b32 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xc2,0x03]

v_perm_b32 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xde,0x03]

v_perm_b32 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xee,0x03]

v_perm_b32 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xf2,0x03]

v_perm_b32 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xed,0xd1,0x01,0x05,0xf6,0x03]

v_fma_f16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xff,0x05,0x0e,0x04]

v_fma_f16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x04,0x0e,0x04]

v_fma_f16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x65,0x04,0x0e,0x04]

v_fma_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x66,0x04,0x0e,0x04]

v_fma_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x67,0x04,0x0e,0x04]

v_fma_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6a,0x04,0x0e,0x04]

v_fma_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6b,0x04,0x0e,0x04]

v_fma_f16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6c,0x04,0x0e,0x04]

v_fma_f16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6d,0x04,0x0e,0x04]

v_fma_f16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6e,0x04,0x0e,0x04]

v_fma_f16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x6f,0x04,0x0e,0x04]

v_fma_f16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x7b,0x04,0x0e,0x04]

v_fma_f16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x7c,0x04,0x0e,0x04]

v_fma_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x7e,0x04,0x0e,0x04]

v_fma_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x7f,0x04,0x0e,0x04]

v_fma_f16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x80,0x04,0x0e,0x04]

v_fma_f16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xc1,0x04,0x0e,0x04]

v_fma_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xf0,0x04,0x0e,0x04]

v_fma_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xf7,0x04,0x0e,0x04]

v_fma_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xfb,0x04,0x0e,0x04]

v_fma_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xfc,0x04,0x0e,0x04]

v_fma_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xfd,0x04,0x0e,0x04]

v_fma_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0xfe,0x04,0x0e,0x04]

v_fma_f16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xff,0x0f,0x04]

v_fma_f16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0c,0x04]

v_fma_f16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xcb,0x0c,0x04]

v_fma_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xcd,0x0c,0x04]

v_fma_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xcf,0x0c,0x04]

v_fma_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xd5,0x0c,0x04]

v_fma_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xd7,0x0c,0x04]

v_fma_f16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xd9,0x0c,0x04]

v_fma_f16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xdb,0x0c,0x04]

v_fma_f16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xdd,0x0c,0x04]

v_fma_f16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xdf,0x0c,0x04]

v_fma_f16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xf7,0x0c,0x04]

v_fma_f16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xf9,0x0c,0x04]

v_fma_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xfd,0x0c,0x04]

v_fma_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xff,0x0c,0x04]

v_fma_f16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x01,0x0d,0x04]

v_fma_f16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x83,0x0d,0x04]

v_fma_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xe1,0x0d,0x04]

v_fma_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xef,0x0d,0x04]

v_fma_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xf7,0x0d,0x04]

v_fma_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xf9,0x0d,0x04]

v_fma_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0xfb,0x0d,0x04]

v_fma_f16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xfe,0x07]

v_fma_f16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0x00]

v_fma_f16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x96,0x01]

v_fma_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x9a,0x01]

v_fma_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x9e,0x01]

v_fma_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xaa,0x01]

v_fma_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xae,0x01]

v_fma_f16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xb2,0x01]

v_fma_f16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xb6,0x01]

v_fma_f16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xba,0x01]

v_fma_f16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xbe,0x01]

v_fma_f16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xee,0x01]

v_fma_f16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xf2,0x01]

v_fma_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xfa,0x01]

v_fma_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xfe,0x01]

v_fma_f16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x02,0x02]

v_fma_f16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x06,0x03]

v_fma_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xc2,0x03]

v_fma_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xde,0x03]

v_fma_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xee,0x03]

v_fma_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xf2,0x03]

v_fma_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0xf6,0x03]

v_fma_f16 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0x24]

v_fma_f16 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0x44]

v_fma_f16 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0x84]

v_fma_f16 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xee,0xd1,0x01,0x05,0x0e,0xe4]

v_fma_f16 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_fma_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xee,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v255, v1, v2, v3
// CHECK: [0xff,0x00,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v255, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xff,0x05,0x0e,0x04]

v_div_fixup_f16 v5, s1, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x04,0x0e,0x04]

v_div_fixup_f16 v5, s101, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x65,0x04,0x0e,0x04]

v_div_fixup_f16 v5, flat_scratch_lo, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x66,0x04,0x0e,0x04]

v_div_fixup_f16 v5, flat_scratch_hi, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x67,0x04,0x0e,0x04]

v_div_fixup_f16 v5, vcc_lo, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6a,0x04,0x0e,0x04]

v_div_fixup_f16 v5, vcc_hi, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6b,0x04,0x0e,0x04]

v_div_fixup_f16 v5, tba_lo, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6c,0x04,0x0e,0x04]

v_div_fixup_f16 v5, tba_hi, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6d,0x04,0x0e,0x04]

v_div_fixup_f16 v5, tma_lo, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6e,0x04,0x0e,0x04]

v_div_fixup_f16 v5, tma_hi, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x6f,0x04,0x0e,0x04]

v_div_fixup_f16 v5, ttmp11, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x7b,0x04,0x0e,0x04]

v_div_fixup_f16 v5, m0, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x7c,0x04,0x0e,0x04]

v_div_fixup_f16 v5, exec_lo, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x7e,0x04,0x0e,0x04]

v_div_fixup_f16 v5, exec_hi, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x7f,0x04,0x0e,0x04]

v_div_fixup_f16 v5, 0, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x80,0x04,0x0e,0x04]

v_div_fixup_f16 v5, -1, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xc1,0x04,0x0e,0x04]

v_div_fixup_f16 v5, 0.5, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xf0,0x04,0x0e,0x04]

v_div_fixup_f16 v5, -4.0, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xf7,0x04,0x0e,0x04]

v_div_fixup_f16 v5, src_vccz, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xfb,0x04,0x0e,0x04]

v_div_fixup_f16 v5, src_execz, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xfc,0x04,0x0e,0x04]

v_div_fixup_f16 v5, src_scc, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xfd,0x04,0x0e,0x04]

v_div_fixup_f16 v5, src_lds_direct, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0xfe,0x04,0x0e,0x04]

v_div_fixup_f16 v5, v1, v255, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xff,0x0f,0x04]

v_div_fixup_f16 v5, v1, s2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0c,0x04]

v_div_fixup_f16 v5, v1, s101, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xcb,0x0c,0x04]

v_div_fixup_f16 v5, v1, flat_scratch_lo, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xcd,0x0c,0x04]

v_div_fixup_f16 v5, v1, flat_scratch_hi, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xcf,0x0c,0x04]

v_div_fixup_f16 v5, v1, vcc_lo, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xd5,0x0c,0x04]

v_div_fixup_f16 v5, v1, vcc_hi, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xd7,0x0c,0x04]

v_div_fixup_f16 v5, v1, tba_lo, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xd9,0x0c,0x04]

v_div_fixup_f16 v5, v1, tba_hi, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xdb,0x0c,0x04]

v_div_fixup_f16 v5, v1, tma_lo, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xdd,0x0c,0x04]

v_div_fixup_f16 v5, v1, tma_hi, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xdf,0x0c,0x04]

v_div_fixup_f16 v5, v1, ttmp11, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xf7,0x0c,0x04]

v_div_fixup_f16 v5, v1, m0, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xf9,0x0c,0x04]

v_div_fixup_f16 v5, v1, exec_lo, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xfd,0x0c,0x04]

v_div_fixup_f16 v5, v1, exec_hi, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xff,0x0c,0x04]

v_div_fixup_f16 v5, v1, 0, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x01,0x0d,0x04]

v_div_fixup_f16 v5, v1, -1, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x83,0x0d,0x04]

v_div_fixup_f16 v5, v1, 0.5, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xe1,0x0d,0x04]

v_div_fixup_f16 v5, v1, -4.0, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xef,0x0d,0x04]

v_div_fixup_f16 v5, v1, src_vccz, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xf7,0x0d,0x04]

v_div_fixup_f16 v5, v1, src_execz, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xf9,0x0d,0x04]

v_div_fixup_f16 v5, v1, src_scc, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0xfb,0x0d,0x04]

v_div_fixup_f16 v5, v1, v2, v255
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xfe,0x07]

v_div_fixup_f16 v5, v1, v2, s3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0x00]

v_div_fixup_f16 v5, v1, v2, s101
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x96,0x01]

v_div_fixup_f16 v5, v1, v2, flat_scratch_lo
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x9a,0x01]

v_div_fixup_f16 v5, v1, v2, flat_scratch_hi
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x9e,0x01]

v_div_fixup_f16 v5, v1, v2, vcc_lo
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xaa,0x01]

v_div_fixup_f16 v5, v1, v2, vcc_hi
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xae,0x01]

v_div_fixup_f16 v5, v1, v2, tba_lo
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xb2,0x01]

v_div_fixup_f16 v5, v1, v2, tba_hi
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xb6,0x01]

v_div_fixup_f16 v5, v1, v2, tma_lo
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xba,0x01]

v_div_fixup_f16 v5, v1, v2, tma_hi
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xbe,0x01]

v_div_fixup_f16 v5, v1, v2, ttmp11
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xee,0x01]

v_div_fixup_f16 v5, v1, v2, m0
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xf2,0x01]

v_div_fixup_f16 v5, v1, v2, exec_lo
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xfa,0x01]

v_div_fixup_f16 v5, v1, v2, exec_hi
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xfe,0x01]

v_div_fixup_f16 v5, v1, v2, 0
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x02,0x02]

v_div_fixup_f16 v5, v1, v2, -1
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x06,0x03]

v_div_fixup_f16 v5, v1, v2, 0.5
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xc2,0x03]

v_div_fixup_f16 v5, v1, v2, -4.0
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xde,0x03]

v_div_fixup_f16 v5, v1, v2, src_vccz
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xee,0x03]

v_div_fixup_f16 v5, v1, v2, src_execz
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xf2,0x03]

v_div_fixup_f16 v5, v1, v2, src_scc
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0xf6,0x03]

v_div_fixup_f16 v5, -v1, v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0x24]

v_div_fixup_f16 v5, v1, -v2, v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0x44]

v_div_fixup_f16 v5, v1, v2, -v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0x84]

v_div_fixup_f16 v5, -v1, -v2, -v3
// CHECK: [0x05,0x00,0xef,0xd1,0x01,0x05,0x0e,0xe4]

v_div_fixup_f16 v5, |v1|, v2, v3
// CHECK: [0x05,0x01,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, |v2|, v3
// CHECK: [0x05,0x02,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, |v3|
// CHECK: [0x05,0x04,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, |v1|, |v2|, |v3|
// CHECK: [0x05,0x07,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_div_fixup_f16 v5, v1, v2, v3 clamp
// CHECK: [0x05,0x80,0xef,0xd1,0x01,0x05,0x0e,0x04]

v_cvt_pkaccum_u8_f32 v5, v1, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32 v255, v1, v2
// CHECK: [0xff,0x00,0xf0,0xd1,0x01,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, v255, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xff,0x05,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, s1, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, s101, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x65,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x66,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x67,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6a,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6b,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6c,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6d,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6e,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x6f,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x7b,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, m0, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x7c,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x7e,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x7f,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, 0, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x80,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, -1, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xc1,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, 0.5, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xf0,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, -4.0, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xf7,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xfb,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, src_execz, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xfc,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, src_scc, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xfd,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0xfe,0x04,0x02,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, v255
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xff,0x03,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, s2
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x05,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, s101
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xcb,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xcd,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xcf,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xd5,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xd7,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xd9,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xdb,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xdd,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xdf,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xf7,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, m0
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xf9,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xfd,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xff,0x00,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, 0
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x01,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, -1
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x83,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, 0.5
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xe1,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, -4.0
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xef,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xf7,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, src_execz
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xf9,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, v1, src_scc
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0xfb,0x01,0x00]

v_cvt_pkaccum_u8_f32 v5, -v1, v2
// CHECK: [0x05,0x00,0xf0,0xd1,0x01,0x05,0x02,0x20]

v_cvt_pkaccum_u8_f32 v5, |v1|, v2
// CHECK: [0x05,0x01,0xf0,0xd1,0x01,0x05,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v255, v2, attr0.x
// CHECK: [0xff,0x00,0x74,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr1.x
// CHECK: [0x05,0x00,0x74,0xd2,0x01,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr31.x
// CHECK: [0x05,0x00,0x74,0xd2,0x1f,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr32.x
// CHECK: [0x05,0x00,0x74,0xd2,0x20,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v255, attr0.x
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0xfe,0x03,0x00]

v_interp_p1ll_f16 v5, -v2, attr0.x
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x04,0x02,0x40]

v_interp_p1ll_f16 v5, |v2|, attr0.x
// CHECK: [0x05,0x02,0x74,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.y
// CHECK: [0x05,0x00,0x74,0xd2,0x40,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.z
// CHECK: [0x05,0x00,0x74,0xd2,0x80,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.w
// CHECK: [0x05,0x00,0x74,0xd2,0xc0,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x high
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x05,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x clamp
// CHECK: [0x05,0x80,0x74,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1ll_f16 v5, v2, attr0.x mul:2
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x04,0x02,0x08]

v_interp_p1ll_f16 v5, v2, attr0.x mul:4
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x04,0x02,0x10]

v_interp_p1ll_f16 v5, v2, attr0.x div:2
// CHECK: [0x05,0x00,0x74,0xd2,0x00,0x04,0x02,0x18]

v_interp_p1lv_f16 v5, v2, attr0.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v255, v2, attr0.x, v3
// CHECK: [0xff,0x00,0x75,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr1.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x01,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr31.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x1f,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr32.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x20,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v255, attr0.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0xfe,0x0f,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v255
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0xfe,0x07]

v_interp_p1lv_f16 v5, -v2, attr0.x, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x44]

v_interp_p1lv_f16 v5, v2, attr0.x, -v3
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x84]

v_interp_p1lv_f16 v5, |v2|, attr0.x, v3
// CHECK: [0x05,0x02,0x75,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, |v3|
// CHECK: [0x05,0x04,0x75,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.y, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x40,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.z, v3
// CHECK: [0x05,0x00,0x75,0xd2,0x80,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.w, v3
// CHECK: [0x05,0x00,0x75,0xd2,0xc0,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 high
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x05,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 clamp
// CHECK: [0x05,0x80,0x75,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 mul:2
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x0c]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 mul:4
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x14]

v_interp_p1lv_f16 v5, v2, attr0.x, v3 div:2
// CHECK: [0x05,0x00,0x75,0xd2,0x00,0x04,0x0e,0x1c]

v_interp_p2_f16 v5, v2, attr0.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v255, v2, attr0.x, v3
// CHECK: [0xff,0x00,0x76,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr1.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x01,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr31.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x1f,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr32.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x20,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v255, attr0.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0xfe,0x0f,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v255
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0x04,0xfe,0x07]

v_interp_p2_f16 v5, -v2, attr0.x, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0x04,0x0e,0x44]

v_interp_p2_f16 v5, v2, attr0.x, -v3
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0x04,0x0e,0x84]

v_interp_p2_f16 v5, |v2|, attr0.x, v3
// CHECK: [0x05,0x02,0x76,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, |v3|
// CHECK: [0x05,0x04,0x76,0xd2,0x00,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.y, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x40,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.z, v3
// CHECK: [0x05,0x00,0x76,0xd2,0x80,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.w, v3
// CHECK: [0x05,0x00,0x76,0xd2,0xc0,0x04,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v3 high
// CHECK: [0x05,0x00,0x76,0xd2,0x00,0x05,0x0e,0x04]

v_interp_p2_f16 v5, v2, attr0.x, v3 clamp
// CHECK: [0x05,0x80,0x76,0xd2,0x00,0x04,0x0e,0x04]

v_add_f64 v[5:6], v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[254:255], v[1:2], v[2:3]
// CHECK: [0xfe,0x00,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[254:255], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xfe,0x05,0x02,0x00]

v_add_f64 v[5:6], s[2:3], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x02,0x04,0x02,0x00]

v_add_f64 v[5:6], s[4:5], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x04,0x04,0x02,0x00]

v_add_f64 v[5:6], s[100:101], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x64,0x04,0x02,0x00]

v_add_f64 v[5:6], flat_scratch, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x66,0x04,0x02,0x00]

v_add_f64 v[5:6], vcc, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x6a,0x04,0x02,0x00]

v_add_f64 v[5:6], tba, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x6c,0x04,0x02,0x00]

v_add_f64 v[5:6], tma, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x6e,0x04,0x02,0x00]

v_add_f64 v[5:6], ttmp[10:11], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x7a,0x04,0x02,0x00]

v_add_f64 v[5:6], exec, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x7e,0x04,0x02,0x00]

v_add_f64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x80,0x04,0x02,0x00]

v_add_f64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xc1,0x04,0x02,0x00]

v_add_f64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xf0,0x04,0x02,0x00]

v_add_f64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xf7,0x04,0x02,0x00]

v_add_f64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xfb,0x04,0x02,0x00]

v_add_f64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xfc,0x04,0x02,0x00]

v_add_f64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0xfd,0x04,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[254:255]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xfd,0x03,0x00]

v_add_f64 v[5:6], v[1:2], s[4:5]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x09,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[6:7]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x0d,0x00,0x00]

v_add_f64 v[5:6], v[1:2], s[100:101]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xc9,0x00,0x00]

v_add_f64 v[5:6], v[1:2], flat_scratch
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xcd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], vcc
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xd5,0x00,0x00]

v_add_f64 v[5:6], v[1:2], tba
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xd9,0x00,0x00]

v_add_f64 v[5:6], v[1:2], tma
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xdd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], ttmp[10:11]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xf5,0x00,0x00]

v_add_f64 v[5:6], v[1:2], exec
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xfd,0x00,0x00]

v_add_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x01,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x83,0x01,0x00]

v_add_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xe1,0x01,0x00]

v_add_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xef,0x01,0x00]

v_add_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xf7,0x01,0x00]

v_add_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xf9,0x01,0x00]

v_add_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0xfb,0x01,0x00]

v_add_f64 v[5:6], -v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x20]

v_add_f64 v[5:6], v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x40]

v_add_f64 v[5:6], -v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x60]

v_add_f64 v[5:6], |v[1:2]|, v[2:3]
// CHECK: [0x05,0x01,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], |v[2:3]|
// CHECK: [0x05,0x02,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], |v[1:2]|, |v[2:3]|
// CHECK: [0x05,0x03,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[2:3] clamp
// CHECK: [0x05,0x80,0x80,0xd2,0x01,0x05,0x02,0x00]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:2
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x08]

v_add_f64 v[5:6], v[1:2], v[2:3] mul:4
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x10]

v_add_f64 v[5:6], v[1:2], v[2:3] div:2
// CHECK: [0x05,0x00,0x80,0xd2,0x01,0x05,0x02,0x18]

v_mul_f64 v[5:6], v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[254:255], v[1:2], v[2:3]
// CHECK: [0xfe,0x00,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[254:255], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xfe,0x05,0x02,0x00]

v_mul_f64 v[5:6], s[2:3], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x02,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[4:5], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x04,0x04,0x02,0x00]

v_mul_f64 v[5:6], s[100:101], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x64,0x04,0x02,0x00]

v_mul_f64 v[5:6], flat_scratch, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x66,0x04,0x02,0x00]

v_mul_f64 v[5:6], vcc, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x6a,0x04,0x02,0x00]

v_mul_f64 v[5:6], tba, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x6c,0x04,0x02,0x00]

v_mul_f64 v[5:6], tma, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x6e,0x04,0x02,0x00]

v_mul_f64 v[5:6], ttmp[10:11], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x7a,0x04,0x02,0x00]

v_mul_f64 v[5:6], exec, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x7e,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x80,0x04,0x02,0x00]

v_mul_f64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xc1,0x04,0x02,0x00]

v_mul_f64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xf0,0x04,0x02,0x00]

v_mul_f64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xf7,0x04,0x02,0x00]

v_mul_f64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xfb,0x04,0x02,0x00]

v_mul_f64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xfc,0x04,0x02,0x00]

v_mul_f64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0xfd,0x04,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[254:255]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xfd,0x03,0x00]

v_mul_f64 v[5:6], v[1:2], s[4:5]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x09,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[6:7]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x0d,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], s[100:101]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xc9,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], flat_scratch
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xcd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], vcc
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xd5,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], tba
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xd9,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], tma
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xdd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], ttmp[10:11]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xf5,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], exec
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xfd,0x00,0x00]

v_mul_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x01,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x83,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xe1,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xef,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xf7,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xf9,0x01,0x00]

v_mul_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0xfb,0x01,0x00]

v_mul_f64 v[5:6], -v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x20]

v_mul_f64 v[5:6], v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x40]

v_mul_f64 v[5:6], -v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x60]

v_mul_f64 v[5:6], |v[1:2]|, v[2:3]
// CHECK: [0x05,0x01,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], |v[2:3]|
// CHECK: [0x05,0x02,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], |v[1:2]|, |v[2:3]|
// CHECK: [0x05,0x03,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[2:3] clamp
// CHECK: [0x05,0x80,0x81,0xd2,0x01,0x05,0x02,0x00]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:2
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x08]

v_mul_f64 v[5:6], v[1:2], v[2:3] mul:4
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x10]

v_mul_f64 v[5:6], v[1:2], v[2:3] div:2
// CHECK: [0x05,0x00,0x81,0xd2,0x01,0x05,0x02,0x18]

v_min_f64 v[5:6], v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[254:255], v[1:2], v[2:3]
// CHECK: [0xfe,0x00,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[254:255], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xfe,0x05,0x02,0x00]

v_min_f64 v[5:6], s[2:3], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x02,0x04,0x02,0x00]

v_min_f64 v[5:6], s[4:5], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x04,0x04,0x02,0x00]

v_min_f64 v[5:6], s[100:101], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x64,0x04,0x02,0x00]

v_min_f64 v[5:6], flat_scratch, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x66,0x04,0x02,0x00]

v_min_f64 v[5:6], vcc, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x6a,0x04,0x02,0x00]

v_min_f64 v[5:6], tba, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x6c,0x04,0x02,0x00]

v_min_f64 v[5:6], tma, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x6e,0x04,0x02,0x00]

v_min_f64 v[5:6], ttmp[10:11], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x7a,0x04,0x02,0x00]

v_min_f64 v[5:6], exec, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x7e,0x04,0x02,0x00]

v_min_f64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x80,0x04,0x02,0x00]

v_min_f64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xc1,0x04,0x02,0x00]

v_min_f64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xf0,0x04,0x02,0x00]

v_min_f64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xf7,0x04,0x02,0x00]

v_min_f64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xfb,0x04,0x02,0x00]

v_min_f64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xfc,0x04,0x02,0x00]

v_min_f64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0xfd,0x04,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[254:255]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xfd,0x03,0x00]

v_min_f64 v[5:6], v[1:2], s[4:5]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x09,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[6:7]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x0d,0x00,0x00]

v_min_f64 v[5:6], v[1:2], s[100:101]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xc9,0x00,0x00]

v_min_f64 v[5:6], v[1:2], flat_scratch
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xcd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], vcc
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xd5,0x00,0x00]

v_min_f64 v[5:6], v[1:2], tba
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xd9,0x00,0x00]

v_min_f64 v[5:6], v[1:2], tma
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xdd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], ttmp[10:11]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xf5,0x00,0x00]

v_min_f64 v[5:6], v[1:2], exec
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xfd,0x00,0x00]

v_min_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x01,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x83,0x01,0x00]

v_min_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xe1,0x01,0x00]

v_min_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xef,0x01,0x00]

v_min_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xf7,0x01,0x00]

v_min_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xf9,0x01,0x00]

v_min_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0xfb,0x01,0x00]

v_min_f64 v[5:6], -v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x20]

v_min_f64 v[5:6], v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x40]

v_min_f64 v[5:6], -v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x60]

v_min_f64 v[5:6], |v[1:2]|, v[2:3]
// CHECK: [0x05,0x01,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], |v[2:3]|
// CHECK: [0x05,0x02,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], |v[1:2]|, |v[2:3]|
// CHECK: [0x05,0x03,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[2:3] clamp
// CHECK: [0x05,0x80,0x82,0xd2,0x01,0x05,0x02,0x00]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:2
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x08]

v_min_f64 v[5:6], v[1:2], v[2:3] mul:4
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x10]

v_min_f64 v[5:6], v[1:2], v[2:3] div:2
// CHECK: [0x05,0x00,0x82,0xd2,0x01,0x05,0x02,0x18]

v_max_f64 v[5:6], v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[254:255], v[1:2], v[2:3]
// CHECK: [0xfe,0x00,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[254:255], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xfe,0x05,0x02,0x00]

v_max_f64 v[5:6], s[2:3], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x02,0x04,0x02,0x00]

v_max_f64 v[5:6], s[4:5], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x04,0x04,0x02,0x00]

v_max_f64 v[5:6], s[100:101], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x64,0x04,0x02,0x00]

v_max_f64 v[5:6], flat_scratch, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x66,0x04,0x02,0x00]

v_max_f64 v[5:6], vcc, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x6a,0x04,0x02,0x00]

v_max_f64 v[5:6], tba, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x6c,0x04,0x02,0x00]

v_max_f64 v[5:6], tma, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x6e,0x04,0x02,0x00]

v_max_f64 v[5:6], ttmp[10:11], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x7a,0x04,0x02,0x00]

v_max_f64 v[5:6], exec, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x7e,0x04,0x02,0x00]

v_max_f64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x80,0x04,0x02,0x00]

v_max_f64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xc1,0x04,0x02,0x00]

v_max_f64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xf0,0x04,0x02,0x00]

v_max_f64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xf7,0x04,0x02,0x00]

v_max_f64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xfb,0x04,0x02,0x00]

v_max_f64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xfc,0x04,0x02,0x00]

v_max_f64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0xfd,0x04,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[254:255]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xfd,0x03,0x00]

v_max_f64 v[5:6], v[1:2], s[4:5]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x09,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[6:7]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x0d,0x00,0x00]

v_max_f64 v[5:6], v[1:2], s[100:101]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xc9,0x00,0x00]

v_max_f64 v[5:6], v[1:2], flat_scratch
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xcd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], vcc
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xd5,0x00,0x00]

v_max_f64 v[5:6], v[1:2], tba
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xd9,0x00,0x00]

v_max_f64 v[5:6], v[1:2], tma
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xdd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], ttmp[10:11]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xf5,0x00,0x00]

v_max_f64 v[5:6], v[1:2], exec
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xfd,0x00,0x00]

v_max_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x01,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x83,0x01,0x00]

v_max_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xe1,0x01,0x00]

v_max_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xef,0x01,0x00]

v_max_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xf7,0x01,0x00]

v_max_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xf9,0x01,0x00]

v_max_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0xfb,0x01,0x00]

v_max_f64 v[5:6], -v[1:2], v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x20]

v_max_f64 v[5:6], v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x40]

v_max_f64 v[5:6], -v[1:2], -v[2:3]
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x60]

v_max_f64 v[5:6], |v[1:2]|, v[2:3]
// CHECK: [0x05,0x01,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], |v[2:3]|
// CHECK: [0x05,0x02,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], |v[1:2]|, |v[2:3]|
// CHECK: [0x05,0x03,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[2:3] clamp
// CHECK: [0x05,0x80,0x83,0xd2,0x01,0x05,0x02,0x00]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:2
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x08]

v_max_f64 v[5:6], v[1:2], v[2:3] mul:4
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x10]

v_max_f64 v[5:6], v[1:2], v[2:3] div:2
// CHECK: [0x05,0x00,0x83,0xd2,0x01,0x05,0x02,0x18]

v_ldexp_f64 v[5:6], v[1:2], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[254:255], v[1:2], v2
// CHECK: [0xfe,0x00,0x84,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[254:255], v2
// CHECK: [0x05,0x00,0x84,0xd2,0xfe,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], s[2:3], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x02,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[4:5], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x04,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], s[100:101], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x64,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], flat_scratch, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x66,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], vcc, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x6a,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], tba, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x6c,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], tma, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x6e,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], ttmp[10:11], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x7a,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], exec, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x7e,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0, v2
// CHECK: [0x05,0x00,0x84,0xd2,0x80,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -1, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xc1,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], 0.5, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xf0,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], -4.0, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xf7,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], src_vccz, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xfb,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], src_execz, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xfc,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], src_scc, v2
// CHECK: [0x05,0x00,0x84,0xd2,0xfd,0x04,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v255
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xff,0x03,0x00]

v_ldexp_f64 v[5:6], v[1:2], s2
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], s101
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xcb,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], flat_scratch_lo
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xcd,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], flat_scratch_hi
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xcf,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_lo
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xd5,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], vcc_hi
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xd7,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], tba_lo
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xd9,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], tba_hi
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xdb,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], tma_lo
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xdd,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], tma_hi
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xdf,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], ttmp11
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xf7,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], m0
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xf9,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_lo
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xfd,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], exec_hi
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xff,0x00,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x01,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x83,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xe1,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xef,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xf7,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xf9,0x01,0x00]

v_ldexp_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0xfb,0x01,0x00]

v_ldexp_f64 v[5:6], -v[1:2], v2
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x02,0x20]

v_ldexp_f64 v[5:6], |v[1:2]|, v2
// CHECK: [0x05,0x01,0x84,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2 clamp
// CHECK: [0x05,0x80,0x84,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:2
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x02,0x08]

v_ldexp_f64 v[5:6], v[1:2], v2 mul:4
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x02,0x10]

v_ldexp_f64 v[5:6], v[1:2], v2 div:2
// CHECK: [0x05,0x00,0x84,0xd2,0x01,0x05,0x02,0x18]

v_mul_lo_u32 v5, v1, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v255, v1, v2
// CHECK: [0xff,0x00,0x85,0xd2,0x01,0x05,0x02,0x00]

v_mul_lo_u32 v5, v255, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xff,0x05,0x02,0x00]

v_mul_lo_u32 v5, s1, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0x04,0x02,0x00]

v_mul_lo_u32 v5, s101, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x65,0x04,0x02,0x00]

v_mul_lo_u32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x66,0x04,0x02,0x00]

v_mul_lo_u32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x67,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6a,0x04,0x02,0x00]

v_mul_lo_u32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6b,0x04,0x02,0x00]

v_mul_lo_u32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6c,0x04,0x02,0x00]

v_mul_lo_u32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6d,0x04,0x02,0x00]

v_mul_lo_u32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6e,0x04,0x02,0x00]

v_mul_lo_u32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x6f,0x04,0x02,0x00]

v_mul_lo_u32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x7b,0x04,0x02,0x00]

v_mul_lo_u32 v5, m0, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x7c,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x7e,0x04,0x02,0x00]

v_mul_lo_u32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x7f,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0, v2
// CHECK: [0x05,0x00,0x85,0xd2,0x80,0x04,0x02,0x00]

v_mul_lo_u32 v5, -1, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xc1,0x04,0x02,0x00]

v_mul_lo_u32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xf0,0x04,0x02,0x00]

v_mul_lo_u32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xf7,0x04,0x02,0x00]

v_mul_lo_u32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xfb,0x04,0x02,0x00]

v_mul_lo_u32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xfc,0x04,0x02,0x00]

v_mul_lo_u32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xfd,0x04,0x02,0x00]

v_mul_lo_u32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x85,0xd2,0xfe,0x04,0x02,0x00]

v_mul_lo_u32 v5, v1, v255
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xff,0x03,0x00]

v_mul_lo_u32 v5, v1, s2
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0x05,0x00,0x00]

v_mul_lo_u32 v5, v1, s101
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xcb,0x00,0x00]

v_mul_lo_u32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xcd,0x00,0x00]

v_mul_lo_u32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xcf,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xd5,0x00,0x00]

v_mul_lo_u32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xd7,0x00,0x00]

v_mul_lo_u32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xd9,0x00,0x00]

v_mul_lo_u32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xdb,0x00,0x00]

v_mul_lo_u32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xdd,0x00,0x00]

v_mul_lo_u32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xdf,0x00,0x00]

v_mul_lo_u32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xf7,0x00,0x00]

v_mul_lo_u32 v5, v1, m0
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xf9,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xfd,0x00,0x00]

v_mul_lo_u32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xff,0x00,0x00]

v_mul_lo_u32 v5, v1, 0
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0x01,0x01,0x00]

v_mul_lo_u32 v5, v1, -1
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0x83,0x01,0x00]

v_mul_lo_u32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xe1,0x01,0x00]

v_mul_lo_u32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xef,0x01,0x00]

v_mul_lo_u32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xf7,0x01,0x00]

v_mul_lo_u32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xf9,0x01,0x00]

v_mul_lo_u32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x85,0xd2,0x01,0xfb,0x01,0x00]

v_mul_hi_u32 v5, v1, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v255, v1, v2
// CHECK: [0xff,0x00,0x86,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32 v5, v255, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_u32 v5, s1, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_u32 v5, s101, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x65,0x04,0x02,0x00]

v_mul_hi_u32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x66,0x04,0x02,0x00]

v_mul_hi_u32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_u32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_u32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_u32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_u32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_u32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_u32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_u32 v5, m0, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_u32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0, v2
// CHECK: [0x05,0x00,0x86,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_u32 v5, -1, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_u32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_u32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_u32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xfb,0x04,0x02,0x00]

v_mul_hi_u32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xfc,0x04,0x02,0x00]

v_mul_hi_u32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xfd,0x04,0x02,0x00]

v_mul_hi_u32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x86,0xd2,0xfe,0x04,0x02,0x00]

v_mul_hi_u32 v5, v1, v255
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_u32 v5, v1, s2
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_u32 v5, v1, s101
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xcb,0x00,0x00]

v_mul_hi_u32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xcd,0x00,0x00]

v_mul_hi_u32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_u32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_u32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_u32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_u32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_u32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_u32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_u32 v5, v1, m0
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_u32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_u32 v5, v1, 0
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_u32 v5, v1, -1
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_u32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_u32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_u32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xf7,0x01,0x00]

v_mul_hi_u32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xf9,0x01,0x00]

v_mul_hi_u32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x86,0xd2,0x01,0xfb,0x01,0x00]

v_mul_hi_i32 v5, v1, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v255, v1, v2
// CHECK: [0xff,0x00,0x87,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32 v5, v255, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_i32 v5, s1, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_i32 v5, s101, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x65,0x04,0x02,0x00]

v_mul_hi_i32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x66,0x04,0x02,0x00]

v_mul_hi_i32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_i32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_i32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_i32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_i32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_i32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_i32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_i32 v5, m0, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_i32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0, v2
// CHECK: [0x05,0x00,0x87,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_i32 v5, -1, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_i32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_i32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_i32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xfb,0x04,0x02,0x00]

v_mul_hi_i32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xfc,0x04,0x02,0x00]

v_mul_hi_i32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xfd,0x04,0x02,0x00]

v_mul_hi_i32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x87,0xd2,0xfe,0x04,0x02,0x00]

v_mul_hi_i32 v5, v1, v255
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_i32 v5, v1, s2
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_i32 v5, v1, s101
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xcb,0x00,0x00]

v_mul_hi_i32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xcd,0x00,0x00]

v_mul_hi_i32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_i32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_i32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_i32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_i32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_i32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_i32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_i32 v5, v1, m0
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_i32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_i32 v5, v1, 0
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_i32 v5, v1, -1
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_i32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_i32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_i32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xf7,0x01,0x00]

v_mul_hi_i32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xf9,0x01,0x00]

v_mul_hi_i32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x87,0xd2,0x01,0xfb,0x01,0x00]

v_ldexp_f32 v5, v1, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32 v255, v1, v2
// CHECK: [0xff,0x00,0x88,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v255, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xff,0x05,0x02,0x00]

v_ldexp_f32 v5, s1, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x04,0x02,0x00]

v_ldexp_f32 v5, s101, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x65,0x04,0x02,0x00]

v_ldexp_f32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x66,0x04,0x02,0x00]

v_ldexp_f32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x67,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6a,0x04,0x02,0x00]

v_ldexp_f32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6b,0x04,0x02,0x00]

v_ldexp_f32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6c,0x04,0x02,0x00]

v_ldexp_f32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6d,0x04,0x02,0x00]

v_ldexp_f32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6e,0x04,0x02,0x00]

v_ldexp_f32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x6f,0x04,0x02,0x00]

v_ldexp_f32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x7b,0x04,0x02,0x00]

v_ldexp_f32 v5, m0, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x7c,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x7e,0x04,0x02,0x00]

v_ldexp_f32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x7f,0x04,0x02,0x00]

v_ldexp_f32 v5, 0, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x80,0x04,0x02,0x00]

v_ldexp_f32 v5, -1, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xc1,0x04,0x02,0x00]

v_ldexp_f32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xf0,0x04,0x02,0x00]

v_ldexp_f32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xf7,0x04,0x02,0x00]

v_ldexp_f32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xfb,0x04,0x02,0x00]

v_ldexp_f32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xfc,0x04,0x02,0x00]

v_ldexp_f32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xfd,0x04,0x02,0x00]

v_ldexp_f32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x88,0xd2,0xfe,0x04,0x02,0x00]

v_ldexp_f32 v5, v1, v255
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xff,0x03,0x00]

v_ldexp_f32 v5, v1, s2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x00,0x00]

v_ldexp_f32 v5, v1, s101
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xcb,0x00,0x00]

v_ldexp_f32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xcd,0x00,0x00]

v_ldexp_f32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xcf,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xd5,0x00,0x00]

v_ldexp_f32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xd7,0x00,0x00]

v_ldexp_f32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xd9,0x00,0x00]

v_ldexp_f32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xdb,0x00,0x00]

v_ldexp_f32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xdd,0x00,0x00]

v_ldexp_f32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xdf,0x00,0x00]

v_ldexp_f32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xf7,0x00,0x00]

v_ldexp_f32 v5, v1, m0
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xf9,0x00,0x00]

v_ldexp_f32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xfd,0x00,0x00]

v_ldexp_f32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xff,0x00,0x00]

v_ldexp_f32 v5, v1, 0
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x01,0x01,0x00]

v_ldexp_f32 v5, v1, -1
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x83,0x01,0x00]

v_ldexp_f32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xe1,0x01,0x00]

v_ldexp_f32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xef,0x01,0x00]

v_ldexp_f32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xf7,0x01,0x00]

v_ldexp_f32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xf9,0x01,0x00]

v_ldexp_f32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0xfb,0x01,0x00]

v_ldexp_f32 v5, -v1, v2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x02,0x20]

v_ldexp_f32 v5, |v1|, v2
// CHECK: [0x05,0x01,0x88,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x88,0xd2,0x01,0x05,0x02,0x00]

v_ldexp_f32 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x02,0x08]

v_ldexp_f32 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x02,0x10]

v_ldexp_f32 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x88,0xd2,0x01,0x05,0x02,0x18]

v_readlane_b32 s5, v1, s2
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 s101, v1, s2
// CHECK: [0x65,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 flat_scratch_lo, v1, s2
// CHECK: [0x66,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 flat_scratch_hi, v1, s2
// CHECK: [0x67,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 tba_lo, v1, s2
// CHECK: [0x6c,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 tba_hi, v1, s2
// CHECK: [0x6d,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 tma_lo, v1, s2
// CHECK: [0x6e,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 tma_hi, v1, s2
// CHECK: [0x6f,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 ttmp11, v1, s2
// CHECK: [0x7b,0x00,0x89,0xd2,0x01,0x05,0x00,0x00]

v_readlane_b32 s5, v255, s2
// CHECK: [0x05,0x00,0x89,0xd2,0xff,0x05,0x00,0x00]

v_readlane_b32 s5, src_lds_direct, s2
// CHECK: [0x05,0x00,0x89,0xd2,0xfe,0x04,0x00,0x00]

v_readlane_b32 s5, v1, s101
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xcb,0x00,0x00]

v_readlane_b32 s5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xcd,0x00,0x00]

v_readlane_b32 s5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xcf,0x00,0x00]

v_readlane_b32 s5, v1, vcc_lo
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xd5,0x00,0x00]

v_readlane_b32 s5, v1, vcc_hi
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xd7,0x00,0x00]

v_readlane_b32 s5, v1, tba_lo
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xd9,0x00,0x00]

v_readlane_b32 s5, v1, tba_hi
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xdb,0x00,0x00]

v_readlane_b32 s5, v1, tma_lo
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xdd,0x00,0x00]

v_readlane_b32 s5, v1, tma_hi
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xdf,0x00,0x00]

v_readlane_b32 s5, v1, ttmp11
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xf7,0x00,0x00]

v_readlane_b32 s5, v1, m0
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0xf9,0x00,0x00]

v_readlane_b32 s5, v1, 0
// CHECK: [0x05,0x00,0x89,0xd2,0x01,0x01,0x01,0x00]

v_writelane_b32 v5, 0, s2
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0x04,0x00,0x00]

v_writelane_b32 v255, 0, s2
// CHECK: [0xff,0x00,0x8a,0xd2,0x80,0x04,0x00,0x00]

v_writelane_b32 v5, -1, s2
// CHECK: [0x05,0x00,0x8a,0xd2,0xc1,0x04,0x00,0x00]

v_writelane_b32 v5, 0.5, s2
// CHECK: [0x05,0x00,0x8a,0xd2,0xf0,0x04,0x00,0x00]

v_writelane_b32 v5, -4.0, s2
// CHECK: [0x05,0x00,0x8a,0xd2,0xf7,0x04,0x00,0x00]

v_writelane_b32 v5, 0, s101
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xca,0x00,0x00]

v_writelane_b32 v5, 0, flat_scratch_lo
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xcc,0x00,0x00]

v_writelane_b32 v5, 0, flat_scratch_hi
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xce,0x00,0x00]

v_writelane_b32 v5, 0, vcc_lo
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xd4,0x00,0x00]

v_writelane_b32 v5, 0, vcc_hi
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xd6,0x00,0x00]

v_writelane_b32 v5, 0, tba_lo
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xd8,0x00,0x00]

v_writelane_b32 v5, 0, tba_hi
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xda,0x00,0x00]

v_writelane_b32 v5, 0, tma_lo
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xdc,0x00,0x00]

v_writelane_b32 v5, 0, tma_hi
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xde,0x00,0x00]

v_writelane_b32 v5, 0, ttmp11
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xf6,0x00,0x00]

v_writelane_b32 v5, 0, m0
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0xf8,0x00,0x00]

v_writelane_b32 v5, 0, 0
// CHECK: [0x05,0x00,0x8a,0xd2,0x80,0x00,0x01,0x00]

v_bcnt_u32_b32 v5, v1, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v255, v1, v2
// CHECK: [0xff,0x00,0x8b,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, v255, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xff,0x05,0x02,0x00]

v_bcnt_u32_b32 v5, s1, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, s101, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x65,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x66,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x67,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6a,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6b,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6c,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6d,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6e,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x6f,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x7b,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, m0, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x7c,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x7e,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x7f,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0x80,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -1, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xc1,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xf0,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xf7,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xfb,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xfc,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xfd,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x8b,0xd2,0xfe,0x04,0x02,0x00]

v_bcnt_u32_b32 v5, v1, v255
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xff,0x03,0x00]

v_bcnt_u32_b32 v5, v1, s2
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0x05,0x00,0x00]

v_bcnt_u32_b32 v5, v1, s101
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xcb,0x00,0x00]

v_bcnt_u32_b32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xcd,0x00,0x00]

v_bcnt_u32_b32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xcf,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xd5,0x00,0x00]

v_bcnt_u32_b32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xd7,0x00,0x00]

v_bcnt_u32_b32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xd9,0x00,0x00]

v_bcnt_u32_b32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xdb,0x00,0x00]

v_bcnt_u32_b32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xdd,0x00,0x00]

v_bcnt_u32_b32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xdf,0x00,0x00]

v_bcnt_u32_b32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xf7,0x00,0x00]

v_bcnt_u32_b32 v5, v1, m0
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xf9,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xfd,0x00,0x00]

v_bcnt_u32_b32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xff,0x00,0x00]

v_bcnt_u32_b32 v5, v1, 0
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0x01,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -1
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0x83,0x01,0x00]

v_bcnt_u32_b32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xe1,0x01,0x00]

v_bcnt_u32_b32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xef,0x01,0x00]

v_bcnt_u32_b32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xf7,0x01,0x00]

v_bcnt_u32_b32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xf9,0x01,0x00]

v_bcnt_u32_b32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x8b,0xd2,0x01,0xfb,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v255, v1, v2
// CHECK: [0xff,0x00,0x8c,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v255, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s1, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, s101, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x65,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x66,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, m0, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -1, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xfb,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xfc,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xfd,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x8c,0xd2,0xfe,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v255
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s2
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, s101
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xcb,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xcd,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, m0
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -1
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xf7,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xf9,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x8c,0xd2,0x01,0xfb,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v255, v1, v2
// CHECK: [0xff,0x00,0x8d,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v255, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s1, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, s101, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x65,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x66,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, m0, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -1, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xfb,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xfc,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xfd,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x8d,0xd2,0xfe,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v255
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s2
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, s101
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xcb,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xcd,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, m0
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -1
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xf7,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xf9,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x8d,0xd2,0x01,0xfb,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[254:255], v1, v[2:3]
// CHECK: [0xfe,0x00,0x8f,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], v255, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xff,0x05,0x02,0x00]

v_lshlrev_b64 v[5:6], s1, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], s101, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x65,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], flat_scratch_lo, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x66,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], flat_scratch_hi, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x67,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_lo, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6a,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], vcc_hi, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6b,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], tba_lo, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6c,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], tba_hi, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6d,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], tma_lo, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6e,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], tma_hi, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x6f,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], ttmp11, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x7b,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], m0, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x7c,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_lo, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x7e,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], exec_hi, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x7f,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0x80,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xc1,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xf0,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xf7,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xfb,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xfc,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x8f,0xd2,0xfd,0x04,0x02,0x00]

v_lshlrev_b64 v[5:6], v1, v[254:255]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xfd,0x03,0x00]

v_lshlrev_b64 v[5:6], v1, s[4:5]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x09,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[6:7]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x0d,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, s[100:101]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xc9,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, flat_scratch
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xcd,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, vcc
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xd5,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, tba
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xd9,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, tma
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xdd,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, ttmp[10:11]
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xf5,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, exec
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xfd,0x00,0x00]

v_lshlrev_b64 v[5:6], v1, 0
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x01,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -1
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0x83,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, 0.5
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xe1,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, -4.0
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xef,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, src_vccz
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xf7,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, src_execz
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xf9,0x01,0x00]

v_lshlrev_b64 v[5:6], v1, src_scc
// CHECK: [0x05,0x00,0x8f,0xd2,0x01,0xfb,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[254:255], v1, v[2:3]
// CHECK: [0xfe,0x00,0x90,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], v255, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xff,0x05,0x02,0x00]

v_lshrrev_b64 v[5:6], s1, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], s101, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x65,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], flat_scratch_lo, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x66,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], flat_scratch_hi, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x67,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_lo, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6a,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], vcc_hi, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6b,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], tba_lo, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6c,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], tba_hi, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6d,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], tma_lo, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6e,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], tma_hi, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x6f,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], ttmp11, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x7b,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], m0, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x7c,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_lo, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x7e,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], exec_hi, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x7f,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0x80,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xc1,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xf0,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xf7,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xfb,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xfc,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x90,0xd2,0xfd,0x04,0x02,0x00]

v_lshrrev_b64 v[5:6], v1, v[254:255]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xfd,0x03,0x00]

v_lshrrev_b64 v[5:6], v1, s[4:5]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x09,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[6:7]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x0d,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, s[100:101]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xc9,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, flat_scratch
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xcd,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, vcc
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xd5,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, tba
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xd9,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, tma
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xdd,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, ttmp[10:11]
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xf5,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, exec
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xfd,0x00,0x00]

v_lshrrev_b64 v[5:6], v1, 0
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x01,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -1
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0x83,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, 0.5
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xe1,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, -4.0
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xef,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, src_vccz
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xf7,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, src_execz
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xf9,0x01,0x00]

v_lshrrev_b64 v[5:6], v1, src_scc
// CHECK: [0x05,0x00,0x90,0xd2,0x01,0xfb,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[254:255], v1, v[2:3]
// CHECK: [0xfe,0x00,0x91,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], v255, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xff,0x05,0x02,0x00]

v_ashrrev_i64 v[5:6], s1, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], s101, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x65,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], flat_scratch_lo, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x66,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], flat_scratch_hi, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x67,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_lo, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6a,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], vcc_hi, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6b,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], tba_lo, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6c,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], tba_hi, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6d,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], tma_lo, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6e,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], tma_hi, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x6f,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], ttmp11, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x7b,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], m0, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x7c,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_lo, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x7e,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], exec_hi, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x7f,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0x80,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -1, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xc1,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], 0.5, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xf0,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], -4.0, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xf7,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], src_vccz, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xfb,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], src_execz, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xfc,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], src_scc, v[2:3]
// CHECK: [0x05,0x00,0x91,0xd2,0xfd,0x04,0x02,0x00]

v_ashrrev_i64 v[5:6], v1, v[254:255]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xfd,0x03,0x00]

v_ashrrev_i64 v[5:6], v1, s[4:5]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x09,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[6:7]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x0d,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, s[100:101]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xc9,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, flat_scratch
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xcd,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, vcc
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xd5,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, tba
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xd9,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, tma
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xdd,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, ttmp[10:11]
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xf5,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, exec
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xfd,0x00,0x00]

v_ashrrev_i64 v[5:6], v1, 0
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x01,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -1
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0x83,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, 0.5
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xe1,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, -4.0
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xef,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, src_vccz
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xf7,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, src_execz
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xf9,0x01,0x00]

v_ashrrev_i64 v[5:6], v1, src_scc
// CHECK: [0x05,0x00,0x91,0xd2,0x01,0xfb,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[254:255], v[1:2], v2
// CHECK: [0xfe,0x00,0x92,0xd2,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[254:255], v2
// CHECK: [0x05,0x00,0x92,0xd2,0xfe,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], s[2:3], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x02,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[4:5], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x04,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], s[100:101], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x64,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], flat_scratch, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x66,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], vcc, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x6a,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], tba, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x6c,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], tma, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x6e,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], ttmp[10:11], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x7a,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], exec, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x7e,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0, v2
// CHECK: [0x05,0x00,0x92,0xd2,0x80,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -1, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xc1,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], 0.5, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xf0,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], -4.0, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xf7,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], src_vccz, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xfb,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], src_execz, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xfc,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], src_scc, v2
// CHECK: [0x05,0x00,0x92,0xd2,0xfd,0x04,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v255
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xff,0x03,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s2
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], s101
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xcb,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], flat_scratch_lo
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xcd,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], flat_scratch_hi
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xcf,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_lo
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xd5,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], vcc_hi
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xd7,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], tba_lo
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xd9,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], tba_hi
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xdb,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], tma_lo
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xdd,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], tma_hi
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xdf,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], ttmp11
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xf7,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], m0
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xf9,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_lo
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xfd,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], exec_hi
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xff,0x00,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x01,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -1
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x83,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], 0.5
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xe1,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], -4.0
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xef,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], src_vccz
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xf7,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], src_execz
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xf9,0x01,0x00]

v_trig_preop_f64 v[5:6], v[1:2], src_scc
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0xfb,0x01,0x00]

v_trig_preop_f64 v[5:6], -v[1:2], v2
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x02,0x20]

v_trig_preop_f64 v[5:6], |v[1:2]|, v2
// CHECK: [0x05,0x01,0x92,0xd2,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2 clamp
// CHECK: [0x05,0x80,0x92,0xd2,0x01,0x05,0x02,0x00]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:2
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x02,0x08]

v_trig_preop_f64 v[5:6], v[1:2], v2 mul:4
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x02,0x10]

v_trig_preop_f64 v[5:6], v[1:2], v2 div:2
// CHECK: [0x05,0x00,0x92,0xd2,0x01,0x05,0x02,0x18]

v_bfm_b32 v5, v1, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32 v255, v1, v2
// CHECK: [0xff,0x00,0x93,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32 v5, v255, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xff,0x05,0x02,0x00]

v_bfm_b32 v5, s1, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0x04,0x02,0x00]

v_bfm_b32 v5, s101, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x65,0x04,0x02,0x00]

v_bfm_b32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x66,0x04,0x02,0x00]

v_bfm_b32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x67,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6a,0x04,0x02,0x00]

v_bfm_b32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6b,0x04,0x02,0x00]

v_bfm_b32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6c,0x04,0x02,0x00]

v_bfm_b32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6d,0x04,0x02,0x00]

v_bfm_b32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6e,0x04,0x02,0x00]

v_bfm_b32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x6f,0x04,0x02,0x00]

v_bfm_b32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x7b,0x04,0x02,0x00]

v_bfm_b32 v5, m0, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x7c,0x04,0x02,0x00]

v_bfm_b32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x7e,0x04,0x02,0x00]

v_bfm_b32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x7f,0x04,0x02,0x00]

v_bfm_b32 v5, 0, v2
// CHECK: [0x05,0x00,0x93,0xd2,0x80,0x04,0x02,0x00]

v_bfm_b32 v5, -1, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xc1,0x04,0x02,0x00]

v_bfm_b32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xf0,0x04,0x02,0x00]

v_bfm_b32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xf7,0x04,0x02,0x00]

v_bfm_b32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xfb,0x04,0x02,0x00]

v_bfm_b32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xfc,0x04,0x02,0x00]

v_bfm_b32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xfd,0x04,0x02,0x00]

v_bfm_b32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x93,0xd2,0xfe,0x04,0x02,0x00]

v_bfm_b32 v5, v1, v255
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xff,0x03,0x00]

v_bfm_b32 v5, v1, s2
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0x05,0x00,0x00]

v_bfm_b32 v5, v1, s101
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xcb,0x00,0x00]

v_bfm_b32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xcd,0x00,0x00]

v_bfm_b32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xcf,0x00,0x00]

v_bfm_b32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xd5,0x00,0x00]

v_bfm_b32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xd7,0x00,0x00]

v_bfm_b32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xd9,0x00,0x00]

v_bfm_b32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xdb,0x00,0x00]

v_bfm_b32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xdd,0x00,0x00]

v_bfm_b32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xdf,0x00,0x00]

v_bfm_b32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xf7,0x00,0x00]

v_bfm_b32 v5, v1, m0
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xf9,0x00,0x00]

v_bfm_b32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xfd,0x00,0x00]

v_bfm_b32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xff,0x00,0x00]

v_bfm_b32 v5, v1, 0
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0x01,0x01,0x00]

v_bfm_b32 v5, v1, -1
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0x83,0x01,0x00]

v_bfm_b32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xe1,0x01,0x00]

v_bfm_b32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xef,0x01,0x00]

v_bfm_b32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xf7,0x01,0x00]

v_bfm_b32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xf9,0x01,0x00]

v_bfm_b32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x93,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v255, v1, v2
// CHECK: [0xff,0x00,0x94,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v255, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s1, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, s101, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x65,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x66,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, m0, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -1, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x94,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, v255
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, s101
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xcd,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, m0
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -1
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pknorm_i16_f32 v5, -v1, v2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pknorm_i16_f32 v5, v1, -v2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pknorm_i16_f32 v5, -v1, -v2
// CHECK: [0x05,0x00,0x94,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pknorm_i16_f32 v5, |v1|, v2
// CHECK: [0x05,0x01,0x94,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, v1, |v2|
// CHECK: [0x05,0x02,0x94,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_i16_f32 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x94,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v255, v1, v2
// CHECK: [0xff,0x00,0x95,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v255, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s1, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, s101, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x65,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x66,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, m0, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -1, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x95,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, v255
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, s101
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xcb,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xcd,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, m0
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -1
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pknorm_u16_f32 v5, -v1, v2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pknorm_u16_f32 v5, v1, -v2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pknorm_u16_f32 v5, -v1, -v2
// CHECK: [0x05,0x00,0x95,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pknorm_u16_f32 v5, |v1|, v2
// CHECK: [0x05,0x01,0x95,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, v1, |v2|
// CHECK: [0x05,0x02,0x95,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pknorm_u16_f32 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x95,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v255, v1, v2
// CHECK: [0xff,0x00,0x96,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, v255, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, s1, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, s101, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x65,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x66,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, m0, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, 0, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, -1, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x96,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, v255
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, s2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, s101
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xcb,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xcd,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, m0
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, 0
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, -1
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pkrtz_f16_f32 v5, -v1, v2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x05,0x02,0x20]

v_cvt_pkrtz_f16_f32 v5, v1, -v2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x05,0x02,0x40]

v_cvt_pkrtz_f16_f32 v5, -v1, -v2
// CHECK: [0x05,0x00,0x96,0xd2,0x01,0x05,0x02,0x60]

v_cvt_pkrtz_f16_f32 v5, |v1|, v2
// CHECK: [0x05,0x01,0x96,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, v1, |v2|
// CHECK: [0x05,0x02,0x96,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pkrtz_f16_f32 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x96,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v255, v1, v2
// CHECK: [0xff,0x00,0x97,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, v255, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pk_u16_u32 v5, s1, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, s101, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x65,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x66,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, m0, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0, v2
// CHECK: [0x05,0x00,0x97,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -1, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x97,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pk_u16_u32 v5, v1, v255
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pk_u16_u32 v5, v1, s2
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, s101
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xcb,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xcd,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, m0
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pk_u16_u32 v5, v1, 0
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -1
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pk_u16_u32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x97,0xd2,0x01,0xfb,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v255, v1, v2
// CHECK: [0xff,0x00,0x98,0xd2,0x01,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, v255, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xff,0x05,0x02,0x00]

v_cvt_pk_i16_i32 v5, s1, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, s101, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x65,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x66,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x67,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6a,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6b,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6c,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6d,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6e,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x6f,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x7b,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, m0, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x7c,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x7e,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x7f,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0, v2
// CHECK: [0x05,0x00,0x98,0xd2,0x80,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -1, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xc1,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, 0.5, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xf0,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, -4.0, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xf7,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xfb,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, src_execz, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xfc,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, src_scc, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xfd,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x98,0xd2,0xfe,0x04,0x02,0x00]

v_cvt_pk_i16_i32 v5, v1, v255
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xff,0x03,0x00]

v_cvt_pk_i16_i32 v5, v1, s2
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0x05,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, s101
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xcb,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xcd,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xcf,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xd5,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xd7,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xd9,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xdb,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xdd,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xdf,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xf7,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, m0
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xf9,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xfd,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xff,0x00,0x00]

v_cvt_pk_i16_i32 v5, v1, 0
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0x01,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -1
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0x83,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, 0.5
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xe1,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, -4.0
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xef,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xf7,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, src_execz
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xf9,0x01,0x00]

v_cvt_pk_i16_i32 v5, v1, src_scc
// CHECK: [0x05,0x00,0x98,0xd2,0x01,0xfb,0x01,0x00]
