// RUN: llvm-mc -triple=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

v_nop
// CHECK: [0x00,0x00,0x00,0x7e]

v_mov_b32 v5, v1
// CHECK: [0x01,0x03,0x0a,0x7e]

v_mov_b32 v255, v1
// CHECK: [0x01,0x03,0xfe,0x7f]

v_mov_b32 v5, v255
// CHECK: [0xff,0x03,0x0a,0x7e]

v_mov_b32 v5, s1
// CHECK: [0x01,0x02,0x0a,0x7e]

v_mov_b32 v5, s101
// CHECK: [0x65,0x02,0x0a,0x7e]

v_mov_b32 v5, flat_scratch_lo
// CHECK: [0x66,0x02,0x0a,0x7e]

v_mov_b32 v5, flat_scratch_hi
// CHECK: [0x67,0x02,0x0a,0x7e]

v_mov_b32 v5, vcc_lo
// CHECK: [0x6a,0x02,0x0a,0x7e]

v_mov_b32 v5, vcc_hi
// CHECK: [0x6b,0x02,0x0a,0x7e]

v_mov_b32 v5, tba_lo
// CHECK: [0x6c,0x02,0x0a,0x7e]

v_mov_b32 v5, tba_hi
// CHECK: [0x6d,0x02,0x0a,0x7e]

v_mov_b32 v5, tma_lo
// CHECK: [0x6e,0x02,0x0a,0x7e]

v_mov_b32 v5, tma_hi
// CHECK: [0x6f,0x02,0x0a,0x7e]

v_mov_b32 v5, ttmp11
// CHECK: [0x7b,0x02,0x0a,0x7e]

v_mov_b32 v5, m0
// CHECK: [0x7c,0x02,0x0a,0x7e]

v_mov_b32 v5, exec_lo
// CHECK: [0x7e,0x02,0x0a,0x7e]

v_mov_b32 v5, exec_hi
// CHECK: [0x7f,0x02,0x0a,0x7e]

v_mov_b32 v5, 0
// CHECK: [0x80,0x02,0x0a,0x7e]

v_mov_b32 v5, -1
// CHECK: [0xc1,0x02,0x0a,0x7e]

v_mov_b32 v5, 0.5
// CHECK: [0xf0,0x02,0x0a,0x7e]

v_mov_b32 v5, -4.0
// CHECK: [0xf7,0x02,0x0a,0x7e]

v_mov_b32 v5, src_vccz
// CHECK: [0xfb,0x02,0x0a,0x7e]

v_mov_b32 v5, src_execz
// CHECK: [0xfc,0x02,0x0a,0x7e]

v_mov_b32 v5, src_scc
// CHECK: [0xfd,0x02,0x0a,0x7e]

v_mov_b32 v5, src_lds_direct
// CHECK: [0xfe,0x02,0x0a,0x7e]

v_mov_b32 v5, 0xaf123456
// CHECK: [0xff,0x02,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_b32 v5, 0x3f717273
// CHECK: [0xff,0x02,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_readfirstlane_b32 s5, v1
// CHECK: [0x01,0x05,0x0a,0x7e]

v_readfirstlane_b32 s101, v1
// CHECK: [0x01,0x05,0xca,0x7e]

v_readfirstlane_b32 flat_scratch_lo, v1
// CHECK: [0x01,0x05,0xcc,0x7e]

v_readfirstlane_b32 flat_scratch_hi, v1
// CHECK: [0x01,0x05,0xce,0x7e]

v_readfirstlane_b32 tba_lo, v1
// CHECK: [0x01,0x05,0xd8,0x7e]

v_readfirstlane_b32 tba_hi, v1
// CHECK: [0x01,0x05,0xda,0x7e]

v_readfirstlane_b32 tma_lo, v1
// CHECK: [0x01,0x05,0xdc,0x7e]

v_readfirstlane_b32 tma_hi, v1
// CHECK: [0x01,0x05,0xde,0x7e]

v_readfirstlane_b32 ttmp11, v1
// CHECK: [0x01,0x05,0xf6,0x7e]

v_readfirstlane_b32 s5, v255
// CHECK: [0xff,0x05,0x0a,0x7e]

v_readfirstlane_b32 s5, src_lds_direct
// CHECK: [0xfe,0x04,0x0a,0x7e]

v_cvt_i32_f64 v5, v[1:2]
// CHECK: [0x01,0x07,0x0a,0x7e]

v_cvt_i32_f64 v255, v[1:2]
// CHECK: [0x01,0x07,0xfe,0x7f]

v_cvt_i32_f64 v5, v[254:255]
// CHECK: [0xfe,0x07,0x0a,0x7e]

v_cvt_i32_f64 v5, s[2:3]
// CHECK: [0x02,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, s[4:5]
// CHECK: [0x04,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, s[100:101]
// CHECK: [0x64,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, flat_scratch
// CHECK: [0x66,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, vcc
// CHECK: [0x6a,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, tba
// CHECK: [0x6c,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, tma
// CHECK: [0x6e,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, exec
// CHECK: [0x7e,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0
// CHECK: [0x80,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, -1
// CHECK: [0xc1,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0.5
// CHECK: [0xf0,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, -4.0
// CHECK: [0xf7,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, src_vccz
// CHECK: [0xfb,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, src_execz
// CHECK: [0xfc,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, src_scc
// CHECK: [0xfd,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0xaf123456
// CHECK: [0xff,0x06,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f64 v5, 0x3f717273
// CHECK: [0xff,0x06,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_i32 v[5:6], v1
// CHECK: [0x01,0x09,0x0a,0x7e]

v_cvt_f64_i32 v[254:255], v1
// CHECK: [0x01,0x09,0xfc,0x7f]

v_cvt_f64_i32 v[5:6], v255
// CHECK: [0xff,0x09,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], s1
// CHECK: [0x01,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], s101
// CHECK: [0x65,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], flat_scratch_lo
// CHECK: [0x66,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], flat_scratch_hi
// CHECK: [0x67,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], vcc_lo
// CHECK: [0x6a,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], vcc_hi
// CHECK: [0x6b,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tba_lo
// CHECK: [0x6c,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tba_hi
// CHECK: [0x6d,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tma_lo
// CHECK: [0x6e,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tma_hi
// CHECK: [0x6f,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], ttmp11
// CHECK: [0x7b,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], m0
// CHECK: [0x7c,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], exec_lo
// CHECK: [0x7e,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], exec_hi
// CHECK: [0x7f,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0
// CHECK: [0x80,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], -1
// CHECK: [0xc1,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0.5
// CHECK: [0xf0,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], -4.0
// CHECK: [0xf7,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], src_vccz
// CHECK: [0xfb,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], src_execz
// CHECK: [0xfc,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], src_scc
// CHECK: [0xfd,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], src_lds_direct
// CHECK: [0xfe,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0xaf123456
// CHECK: [0xff,0x08,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_i32 v[5:6], 0x3f717273
// CHECK: [0xff,0x08,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_i32 v5, v1
// CHECK: [0x01,0x0b,0x0a,0x7e]

v_cvt_f32_i32 v255, v1
// CHECK: [0x01,0x0b,0xfe,0x7f]

v_cvt_f32_i32 v5, v255
// CHECK: [0xff,0x0b,0x0a,0x7e]

v_cvt_f32_i32 v5, s1
// CHECK: [0x01,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, s101
// CHECK: [0x65,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, flat_scratch_lo
// CHECK: [0x66,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, flat_scratch_hi
// CHECK: [0x67,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, vcc_lo
// CHECK: [0x6a,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, vcc_hi
// CHECK: [0x6b,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tba_lo
// CHECK: [0x6c,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tba_hi
// CHECK: [0x6d,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tma_lo
// CHECK: [0x6e,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tma_hi
// CHECK: [0x6f,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, ttmp11
// CHECK: [0x7b,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, m0
// CHECK: [0x7c,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, exec_lo
// CHECK: [0x7e,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, exec_hi
// CHECK: [0x7f,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0
// CHECK: [0x80,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, -1
// CHECK: [0xc1,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0.5
// CHECK: [0xf0,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, -4.0
// CHECK: [0xf7,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, src_vccz
// CHECK: [0xfb,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, src_execz
// CHECK: [0xfc,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, src_scc
// CHECK: [0xfd,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, src_lds_direct
// CHECK: [0xfe,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0xaf123456
// CHECK: [0xff,0x0a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_i32 v5, 0x3f717273
// CHECK: [0xff,0x0a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_u32 v5, v1
// CHECK: [0x01,0x0d,0x0a,0x7e]

v_cvt_f32_u32 v255, v1
// CHECK: [0x01,0x0d,0xfe,0x7f]

v_cvt_f32_u32 v5, v255
// CHECK: [0xff,0x0d,0x0a,0x7e]

v_cvt_f32_u32 v5, s1
// CHECK: [0x01,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, s101
// CHECK: [0x65,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, flat_scratch_lo
// CHECK: [0x66,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, flat_scratch_hi
// CHECK: [0x67,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, vcc_lo
// CHECK: [0x6a,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, vcc_hi
// CHECK: [0x6b,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tba_lo
// CHECK: [0x6c,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tba_hi
// CHECK: [0x6d,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tma_lo
// CHECK: [0x6e,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tma_hi
// CHECK: [0x6f,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, ttmp11
// CHECK: [0x7b,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, m0
// CHECK: [0x7c,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, exec_lo
// CHECK: [0x7e,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, exec_hi
// CHECK: [0x7f,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0
// CHECK: [0x80,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, -1
// CHECK: [0xc1,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0.5
// CHECK: [0xf0,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, -4.0
// CHECK: [0xf7,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, src_vccz
// CHECK: [0xfb,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, src_execz
// CHECK: [0xfc,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, src_scc
// CHECK: [0xfd,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, src_lds_direct
// CHECK: [0xfe,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0xaf123456
// CHECK: [0xff,0x0c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_u32 v5, 0x3f717273
// CHECK: [0xff,0x0c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f32 v5, v1
// CHECK: [0x01,0x0f,0x0a,0x7e]

v_cvt_u32_f32 v255, v1
// CHECK: [0x01,0x0f,0xfe,0x7f]

v_cvt_u32_f32 v5, v255
// CHECK: [0xff,0x0f,0x0a,0x7e]

v_cvt_u32_f32 v5, s1
// CHECK: [0x01,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, s101
// CHECK: [0x65,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, vcc_lo
// CHECK: [0x6a,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, vcc_hi
// CHECK: [0x6b,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tba_lo
// CHECK: [0x6c,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tba_hi
// CHECK: [0x6d,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tma_lo
// CHECK: [0x6e,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tma_hi
// CHECK: [0x6f,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, ttmp11
// CHECK: [0x7b,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, m0
// CHECK: [0x7c,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, exec_lo
// CHECK: [0x7e,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, exec_hi
// CHECK: [0x7f,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0
// CHECK: [0x80,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, -1
// CHECK: [0xc1,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0.5
// CHECK: [0xf0,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, -4.0
// CHECK: [0xf7,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, src_vccz
// CHECK: [0xfb,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, src_execz
// CHECK: [0xfc,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, src_scc
// CHECK: [0xfd,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, src_lds_direct
// CHECK: [0xfe,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0xaf123456
// CHECK: [0xff,0x0e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f32 v5, 0x3f717273
// CHECK: [0xff,0x0e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f32 v5, v1
// CHECK: [0x01,0x11,0x0a,0x7e]

v_cvt_i32_f32 v255, v1
// CHECK: [0x01,0x11,0xfe,0x7f]

v_cvt_i32_f32 v5, v255
// CHECK: [0xff,0x11,0x0a,0x7e]

v_cvt_i32_f32 v5, s1
// CHECK: [0x01,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, s101
// CHECK: [0x65,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, m0
// CHECK: [0x7c,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0
// CHECK: [0x80,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, -1
// CHECK: [0xc1,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0.5
// CHECK: [0xf0,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, -4.0
// CHECK: [0xf7,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, src_vccz
// CHECK: [0xfb,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, src_execz
// CHECK: [0xfc,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, src_scc
// CHECK: [0xfd,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, src_lds_direct
// CHECK: [0xfe,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x10,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x10,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f16_f32 v5, v1
// CHECK: [0x01,0x15,0x0a,0x7e]

v_cvt_f16_f32 v255, v1
// CHECK: [0x01,0x15,0xfe,0x7f]

v_cvt_f16_f32 v5, v255
// CHECK: [0xff,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, s1
// CHECK: [0x01,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, s101
// CHECK: [0x65,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_lo
// CHECK: [0x6a,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_hi
// CHECK: [0x6b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tba_lo
// CHECK: [0x6c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tba_hi
// CHECK: [0x6d,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tma_lo
// CHECK: [0x6e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tma_hi
// CHECK: [0x6f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, ttmp11
// CHECK: [0x7b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, m0
// CHECK: [0x7c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_lo
// CHECK: [0x7e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_hi
// CHECK: [0x7f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0
// CHECK: [0x80,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -1
// CHECK: [0xc1,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0.5
// CHECK: [0xf0,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -4.0
// CHECK: [0xf7,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, src_vccz
// CHECK: [0xfb,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, src_execz
// CHECK: [0xfc,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, src_scc
// CHECK: [0xfd,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, src_lds_direct
// CHECK: [0xfe,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0xaf123456
// CHECK: [0xff,0x14,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v5, 0x3f717273
// CHECK: [0xff,0x14,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_f16 v5, v1
// CHECK: [0x01,0x17,0x0a,0x7e]

v_cvt_f32_f16 v255, v1
// CHECK: [0x01,0x17,0xfe,0x7f]

v_cvt_f32_f16 v5, v255
// CHECK: [0xff,0x17,0x0a,0x7e]

v_cvt_f32_f16 v5, s1
// CHECK: [0x01,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, s101
// CHECK: [0x65,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_lo
// CHECK: [0x6a,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_hi
// CHECK: [0x6b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tba_lo
// CHECK: [0x6c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tba_hi
// CHECK: [0x6d,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tma_lo
// CHECK: [0x6e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tma_hi
// CHECK: [0x6f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, ttmp11
// CHECK: [0x7b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, m0
// CHECK: [0x7c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_lo
// CHECK: [0x7e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_hi
// CHECK: [0x7f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0
// CHECK: [0x80,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -1
// CHECK: [0xc1,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0.5
// CHECK: [0xf0,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -4.0
// CHECK: [0xf7,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, src_vccz
// CHECK: [0xfb,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, src_execz
// CHECK: [0xfc,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, src_scc
// CHECK: [0xfd,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, src_lds_direct
// CHECK: [0xfe,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0xfe0b
// CHECK: [0xff,0x16,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_f32_f16 v5, 0x3456
// CHECK: [0xff,0x16,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_rpi_i32_f32 v5, v1
// CHECK: [0x01,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v255, v1
// CHECK: [0x01,0x19,0xfe,0x7f]

v_cvt_rpi_i32_f32 v5, v255
// CHECK: [0xff,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s1
// CHECK: [0x01,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s101
// CHECK: [0x65,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, m0
// CHECK: [0x7c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0
// CHECK: [0x80,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -1
// CHECK: [0xc1,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0.5
// CHECK: [0xf0,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -4.0
// CHECK: [0xf7,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, src_vccz
// CHECK: [0xfb,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, src_execz
// CHECK: [0xfc,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, src_scc
// CHECK: [0xfd,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, src_lds_direct
// CHECK: [0xfe,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x18,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_rpi_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x18,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_flr_i32_f32 v5, v1
// CHECK: [0x01,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v255, v1
// CHECK: [0x01,0x1b,0xfe,0x7f]

v_cvt_flr_i32_f32 v5, v255
// CHECK: [0xff,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s1
// CHECK: [0x01,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s101
// CHECK: [0x65,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, m0
// CHECK: [0x7c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0
// CHECK: [0x80,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -1
// CHECK: [0xc1,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0.5
// CHECK: [0xf0,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -4.0
// CHECK: [0xf7,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, src_vccz
// CHECK: [0xfb,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, src_execz
// CHECK: [0xfc,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, src_scc
// CHECK: [0xfd,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, src_lds_direct
// CHECK: [0xfe,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x1a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x1a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_off_f32_i4 v5, v1
// CHECK: [0x01,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v255, v1
// CHECK: [0x01,0x1d,0xfe,0x7f]

v_cvt_off_f32_i4 v5, v255
// CHECK: [0xff,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s1
// CHECK: [0x01,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s101
// CHECK: [0x65,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, flat_scratch_lo
// CHECK: [0x66,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, flat_scratch_hi
// CHECK: [0x67,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_lo
// CHECK: [0x6a,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_hi
// CHECK: [0x6b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tba_lo
// CHECK: [0x6c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tba_hi
// CHECK: [0x6d,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tma_lo
// CHECK: [0x6e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tma_hi
// CHECK: [0x6f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, ttmp11
// CHECK: [0x7b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, m0
// CHECK: [0x7c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_lo
// CHECK: [0x7e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_hi
// CHECK: [0x7f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0
// CHECK: [0x80,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -1
// CHECK: [0xc1,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0.5
// CHECK: [0xf0,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -4.0
// CHECK: [0xf7,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, src_vccz
// CHECK: [0xfb,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, src_execz
// CHECK: [0xfc,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, src_scc
// CHECK: [0xfd,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, src_lds_direct
// CHECK: [0xfe,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0x4f
// CHECK: [0xff,0x1c,0x0a,0x7e,0x4f,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, 0x41
// CHECK: [0xff,0x1c,0x0a,0x7e,0x41,0x00,0x00,0x00]

v_cvt_f32_f64 v5, v[1:2]
// CHECK: [0x01,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v255, v[1:2]
// CHECK: [0x01,0x1f,0xfe,0x7f]

v_cvt_f32_f64 v5, v[254:255]
// CHECK: [0xfe,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v5, s[2:3]
// CHECK: [0x02,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[4:5]
// CHECK: [0x04,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[100:101]
// CHECK: [0x64,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, flat_scratch
// CHECK: [0x66,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, vcc
// CHECK: [0x6a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, tba
// CHECK: [0x6c,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, tma
// CHECK: [0x6e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, exec
// CHECK: [0x7e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0
// CHECK: [0x80,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -1
// CHECK: [0xc1,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0.5
// CHECK: [0xf0,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -4.0
// CHECK: [0xf7,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, src_vccz
// CHECK: [0xfb,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, src_execz
// CHECK: [0xfc,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, src_scc
// CHECK: [0xfd,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0xaf123456
// CHECK: [0xff,0x1e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_f64 v5, 0x3f717273
// CHECK: [0xff,0x1e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_f32 v[5:6], v1
// CHECK: [0x01,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[254:255], v1
// CHECK: [0x01,0x21,0xfc,0x7f]

v_cvt_f64_f32 v[5:6], v255
// CHECK: [0xff,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s1
// CHECK: [0x01,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s101
// CHECK: [0x65,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], flat_scratch_lo
// CHECK: [0x66,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], flat_scratch_hi
// CHECK: [0x67,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_lo
// CHECK: [0x6a,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_hi
// CHECK: [0x6b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tba_lo
// CHECK: [0x6c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tba_hi
// CHECK: [0x6d,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tma_lo
// CHECK: [0x6e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tma_hi
// CHECK: [0x6f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], ttmp11
// CHECK: [0x7b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], m0
// CHECK: [0x7c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_lo
// CHECK: [0x7e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_hi
// CHECK: [0x7f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0
// CHECK: [0x80,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -1
// CHECK: [0xc1,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0.5
// CHECK: [0xf0,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -4.0
// CHECK: [0xf7,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], src_vccz
// CHECK: [0xfb,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], src_execz
// CHECK: [0xfc,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], src_scc
// CHECK: [0xfd,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], src_lds_direct
// CHECK: [0xfe,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0xaf123456
// CHECK: [0xff,0x20,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32 v[5:6], 0x3f717273
// CHECK: [0xff,0x20,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0 v5, v1
// CHECK: [0x01,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v255, v1
// CHECK: [0x01,0x23,0xfe,0x7f]

v_cvt_f32_ubyte0 v5, v255
// CHECK: [0xff,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s1
// CHECK: [0x01,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s101
// CHECK: [0x65,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, flat_scratch_lo
// CHECK: [0x66,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, flat_scratch_hi
// CHECK: [0x67,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_lo
// CHECK: [0x6a,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_hi
// CHECK: [0x6b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tba_lo
// CHECK: [0x6c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tba_hi
// CHECK: [0x6d,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tma_lo
// CHECK: [0x6e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tma_hi
// CHECK: [0x6f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, ttmp11
// CHECK: [0x7b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, m0
// CHECK: [0x7c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_lo
// CHECK: [0x7e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_hi
// CHECK: [0x7f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0
// CHECK: [0x80,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -1
// CHECK: [0xc1,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0.5
// CHECK: [0xf0,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -4.0
// CHECK: [0xf7,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, src_vccz
// CHECK: [0xfb,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, src_execz
// CHECK: [0xfc,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, src_scc
// CHECK: [0xfd,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, src_lds_direct
// CHECK: [0xfe,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0xaf123456
// CHECK: [0xff,0x22,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0 v5, 0x3f717273
// CHECK: [0xff,0x22,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte1 v5, v1
// CHECK: [0x01,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v255, v1
// CHECK: [0x01,0x25,0xfe,0x7f]

v_cvt_f32_ubyte1 v5, v255
// CHECK: [0xff,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s1
// CHECK: [0x01,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s101
// CHECK: [0x65,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, flat_scratch_lo
// CHECK: [0x66,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, flat_scratch_hi
// CHECK: [0x67,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_lo
// CHECK: [0x6a,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_hi
// CHECK: [0x6b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tba_lo
// CHECK: [0x6c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tba_hi
// CHECK: [0x6d,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tma_lo
// CHECK: [0x6e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tma_hi
// CHECK: [0x6f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, ttmp11
// CHECK: [0x7b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, m0
// CHECK: [0x7c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_lo
// CHECK: [0x7e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_hi
// CHECK: [0x7f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0
// CHECK: [0x80,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -1
// CHECK: [0xc1,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0.5
// CHECK: [0xf0,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -4.0
// CHECK: [0xf7,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, src_vccz
// CHECK: [0xfb,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, src_execz
// CHECK: [0xfc,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, src_scc
// CHECK: [0xfd,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, src_lds_direct
// CHECK: [0xfe,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0xaf123456
// CHECK: [0xff,0x24,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1 v5, 0x3f717273
// CHECK: [0xff,0x24,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte2 v5, v1
// CHECK: [0x01,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v255, v1
// CHECK: [0x01,0x27,0xfe,0x7f]

v_cvt_f32_ubyte2 v5, v255
// CHECK: [0xff,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s1
// CHECK: [0x01,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s101
// CHECK: [0x65,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, flat_scratch_lo
// CHECK: [0x66,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, flat_scratch_hi
// CHECK: [0x67,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_lo
// CHECK: [0x6a,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_hi
// CHECK: [0x6b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tba_lo
// CHECK: [0x6c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tba_hi
// CHECK: [0x6d,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tma_lo
// CHECK: [0x6e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tma_hi
// CHECK: [0x6f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, ttmp11
// CHECK: [0x7b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, m0
// CHECK: [0x7c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_lo
// CHECK: [0x7e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_hi
// CHECK: [0x7f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0
// CHECK: [0x80,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -1
// CHECK: [0xc1,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0.5
// CHECK: [0xf0,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -4.0
// CHECK: [0xf7,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, src_vccz
// CHECK: [0xfb,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, src_execz
// CHECK: [0xfc,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, src_scc
// CHECK: [0xfd,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, src_lds_direct
// CHECK: [0xfe,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0xaf123456
// CHECK: [0xff,0x26,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2 v5, 0x3f717273
// CHECK: [0xff,0x26,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte3 v5, v1
// CHECK: [0x01,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v255, v1
// CHECK: [0x01,0x29,0xfe,0x7f]

v_cvt_f32_ubyte3 v5, v255
// CHECK: [0xff,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s1
// CHECK: [0x01,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s101
// CHECK: [0x65,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, flat_scratch_lo
// CHECK: [0x66,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, flat_scratch_hi
// CHECK: [0x67,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_lo
// CHECK: [0x6a,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_hi
// CHECK: [0x6b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tba_lo
// CHECK: [0x6c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tba_hi
// CHECK: [0x6d,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tma_lo
// CHECK: [0x6e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tma_hi
// CHECK: [0x6f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, ttmp11
// CHECK: [0x7b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, m0
// CHECK: [0x7c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_lo
// CHECK: [0x7e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_hi
// CHECK: [0x7f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0
// CHECK: [0x80,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -1
// CHECK: [0xc1,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0.5
// CHECK: [0xf0,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -4.0
// CHECK: [0xf7,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, src_vccz
// CHECK: [0xfb,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, src_execz
// CHECK: [0xfc,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, src_scc
// CHECK: [0xfd,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, src_lds_direct
// CHECK: [0xfe,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0xaf123456
// CHECK: [0xff,0x28,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3 v5, 0x3f717273
// CHECK: [0xff,0x28,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f64 v5, v[1:2]
// CHECK: [0x01,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v255, v[1:2]
// CHECK: [0x01,0x2b,0xfe,0x7f]

v_cvt_u32_f64 v5, v[254:255]
// CHECK: [0xfe,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v5, s[2:3]
// CHECK: [0x02,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[4:5]
// CHECK: [0x04,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[100:101]
// CHECK: [0x64,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, flat_scratch
// CHECK: [0x66,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, vcc
// CHECK: [0x6a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, tba
// CHECK: [0x6c,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, tma
// CHECK: [0x6e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, exec
// CHECK: [0x7e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0
// CHECK: [0x80,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -1
// CHECK: [0xc1,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0.5
// CHECK: [0xf0,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -4.0
// CHECK: [0xf7,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, src_vccz
// CHECK: [0xfb,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, src_execz
// CHECK: [0xfc,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, src_scc
// CHECK: [0xfd,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0xaf123456
// CHECK: [0xff,0x2a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64 v5, 0x3f717273
// CHECK: [0xff,0x2a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_u32 v[5:6], v1
// CHECK: [0x01,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[254:255], v1
// CHECK: [0x01,0x2d,0xfc,0x7f]

v_cvt_f64_u32 v[5:6], v255
// CHECK: [0xff,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s1
// CHECK: [0x01,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s101
// CHECK: [0x65,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], flat_scratch_lo
// CHECK: [0x66,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], flat_scratch_hi
// CHECK: [0x67,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_lo
// CHECK: [0x6a,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_hi
// CHECK: [0x6b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tba_lo
// CHECK: [0x6c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tba_hi
// CHECK: [0x6d,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tma_lo
// CHECK: [0x6e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tma_hi
// CHECK: [0x6f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], ttmp11
// CHECK: [0x7b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], m0
// CHECK: [0x7c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_lo
// CHECK: [0x7e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_hi
// CHECK: [0x7f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0
// CHECK: [0x80,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -1
// CHECK: [0xc1,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0.5
// CHECK: [0xf0,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -4.0
// CHECK: [0xf7,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], src_vccz
// CHECK: [0xfb,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], src_execz
// CHECK: [0xfc,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], src_scc
// CHECK: [0xfd,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], src_lds_direct
// CHECK: [0xfe,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0xaf123456
// CHECK: [0xff,0x2c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32 v[5:6], 0x3f717273
// CHECK: [0xff,0x2c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x2f,0x0a,0x7e]

v_trunc_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x2f,0xfc,0x7f]

v_trunc_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x2f,0x0a,0x7e]

v_trunc_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], vcc
// CHECK: [0x6a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], tba
// CHECK: [0x6c,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], tma
// CHECK: [0x6e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], exec
// CHECK: [0x7e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0
// CHECK: [0x80,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -1
// CHECK: [0xc1,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0.5
// CHECK: [0xf0,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -4.0
// CHECK: [0xf7,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], src_execz
// CHECK: [0xfc,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], src_scc
// CHECK: [0xfd,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x2e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x2e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x31,0x0a,0x7e]

v_ceil_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x31,0xfc,0x7f]

v_ceil_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x31,0x0a,0x7e]

v_ceil_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], vcc
// CHECK: [0x6a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], tba
// CHECK: [0x6c,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], tma
// CHECK: [0x6e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], exec
// CHECK: [0x7e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0
// CHECK: [0x80,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -1
// CHECK: [0xc1,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0.5
// CHECK: [0xf0,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -4.0
// CHECK: [0xf7,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], src_execz
// CHECK: [0xfc,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], src_scc
// CHECK: [0xfd,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x30,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x30,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x33,0x0a,0x7e]

v_rndne_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x33,0xfc,0x7f]

v_rndne_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x33,0x0a,0x7e]

v_rndne_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], vcc
// CHECK: [0x6a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], tba
// CHECK: [0x6c,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], tma
// CHECK: [0x6e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], exec
// CHECK: [0x7e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0
// CHECK: [0x80,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -1
// CHECK: [0xc1,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0.5
// CHECK: [0xf0,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -4.0
// CHECK: [0xf7,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], src_execz
// CHECK: [0xfc,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], src_scc
// CHECK: [0xfd,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x32,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x32,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x35,0x0a,0x7e]

v_floor_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x35,0xfc,0x7f]

v_floor_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x35,0x0a,0x7e]

v_floor_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], vcc
// CHECK: [0x6a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], tba
// CHECK: [0x6c,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], tma
// CHECK: [0x6e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], exec
// CHECK: [0x7e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0
// CHECK: [0x80,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -1
// CHECK: [0xc1,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0.5
// CHECK: [0xf0,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -4.0
// CHECK: [0xf7,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], src_execz
// CHECK: [0xfc,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], src_scc
// CHECK: [0xfd,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x34,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x34,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f32 v5, v1
// CHECK: [0x01,0x37,0x0a,0x7e]

v_fract_f32 v255, v1
// CHECK: [0x01,0x37,0xfe,0x7f]

v_fract_f32 v5, v255
// CHECK: [0xff,0x37,0x0a,0x7e]

v_fract_f32 v5, s1
// CHECK: [0x01,0x36,0x0a,0x7e]

v_fract_f32 v5, s101
// CHECK: [0x65,0x36,0x0a,0x7e]

v_fract_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x36,0x0a,0x7e]

v_fract_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x36,0x0a,0x7e]

v_fract_f32 v5, vcc_lo
// CHECK: [0x6a,0x36,0x0a,0x7e]

v_fract_f32 v5, vcc_hi
// CHECK: [0x6b,0x36,0x0a,0x7e]

v_fract_f32 v5, tba_lo
// CHECK: [0x6c,0x36,0x0a,0x7e]

v_fract_f32 v5, tba_hi
// CHECK: [0x6d,0x36,0x0a,0x7e]

v_fract_f32 v5, tma_lo
// CHECK: [0x6e,0x36,0x0a,0x7e]

v_fract_f32 v5, tma_hi
// CHECK: [0x6f,0x36,0x0a,0x7e]

v_fract_f32 v5, ttmp11
// CHECK: [0x7b,0x36,0x0a,0x7e]

v_fract_f32 v5, m0
// CHECK: [0x7c,0x36,0x0a,0x7e]

v_fract_f32 v5, exec_lo
// CHECK: [0x7e,0x36,0x0a,0x7e]

v_fract_f32 v5, exec_hi
// CHECK: [0x7f,0x36,0x0a,0x7e]

v_fract_f32 v5, 0
// CHECK: [0x80,0x36,0x0a,0x7e]

v_fract_f32 v5, -1
// CHECK: [0xc1,0x36,0x0a,0x7e]

v_fract_f32 v5, 0.5
// CHECK: [0xf0,0x36,0x0a,0x7e]

v_fract_f32 v5, -4.0
// CHECK: [0xf7,0x36,0x0a,0x7e]

v_fract_f32 v5, src_vccz
// CHECK: [0xfb,0x36,0x0a,0x7e]

v_fract_f32 v5, src_execz
// CHECK: [0xfc,0x36,0x0a,0x7e]

v_fract_f32 v5, src_scc
// CHECK: [0xfd,0x36,0x0a,0x7e]

v_fract_f32 v5, src_lds_direct
// CHECK: [0xfe,0x36,0x0a,0x7e]

v_fract_f32 v5, 0xaf123456
// CHECK: [0xff,0x36,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f32 v5, 0x3f717273
// CHECK: [0xff,0x36,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f32 v5, v1
// CHECK: [0x01,0x39,0x0a,0x7e]

v_trunc_f32 v255, v1
// CHECK: [0x01,0x39,0xfe,0x7f]

v_trunc_f32 v5, v255
// CHECK: [0xff,0x39,0x0a,0x7e]

v_trunc_f32 v5, s1
// CHECK: [0x01,0x38,0x0a,0x7e]

v_trunc_f32 v5, s101
// CHECK: [0x65,0x38,0x0a,0x7e]

v_trunc_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x38,0x0a,0x7e]

v_trunc_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x38,0x0a,0x7e]

v_trunc_f32 v5, vcc_lo
// CHECK: [0x6a,0x38,0x0a,0x7e]

v_trunc_f32 v5, vcc_hi
// CHECK: [0x6b,0x38,0x0a,0x7e]

v_trunc_f32 v5, tba_lo
// CHECK: [0x6c,0x38,0x0a,0x7e]

v_trunc_f32 v5, tba_hi
// CHECK: [0x6d,0x38,0x0a,0x7e]

v_trunc_f32 v5, tma_lo
// CHECK: [0x6e,0x38,0x0a,0x7e]

v_trunc_f32 v5, tma_hi
// CHECK: [0x6f,0x38,0x0a,0x7e]

v_trunc_f32 v5, ttmp11
// CHECK: [0x7b,0x38,0x0a,0x7e]

v_trunc_f32 v5, m0
// CHECK: [0x7c,0x38,0x0a,0x7e]

v_trunc_f32 v5, exec_lo
// CHECK: [0x7e,0x38,0x0a,0x7e]

v_trunc_f32 v5, exec_hi
// CHECK: [0x7f,0x38,0x0a,0x7e]

v_trunc_f32 v5, 0
// CHECK: [0x80,0x38,0x0a,0x7e]

v_trunc_f32 v5, -1
// CHECK: [0xc1,0x38,0x0a,0x7e]

v_trunc_f32 v5, 0.5
// CHECK: [0xf0,0x38,0x0a,0x7e]

v_trunc_f32 v5, -4.0
// CHECK: [0xf7,0x38,0x0a,0x7e]

v_trunc_f32 v5, src_vccz
// CHECK: [0xfb,0x38,0x0a,0x7e]

v_trunc_f32 v5, src_execz
// CHECK: [0xfc,0x38,0x0a,0x7e]

v_trunc_f32 v5, src_scc
// CHECK: [0xfd,0x38,0x0a,0x7e]

v_trunc_f32 v5, src_lds_direct
// CHECK: [0xfe,0x38,0x0a,0x7e]

v_trunc_f32 v5, 0xaf123456
// CHECK: [0xff,0x38,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f32 v5, 0x3f717273
// CHECK: [0xff,0x38,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f32 v5, v1
// CHECK: [0x01,0x3b,0x0a,0x7e]

v_ceil_f32 v255, v1
// CHECK: [0x01,0x3b,0xfe,0x7f]

v_ceil_f32 v5, v255
// CHECK: [0xff,0x3b,0x0a,0x7e]

v_ceil_f32 v5, s1
// CHECK: [0x01,0x3a,0x0a,0x7e]

v_ceil_f32 v5, s101
// CHECK: [0x65,0x3a,0x0a,0x7e]

v_ceil_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x3a,0x0a,0x7e]

v_ceil_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x3a,0x0a,0x7e]

v_ceil_f32 v5, vcc_lo
// CHECK: [0x6a,0x3a,0x0a,0x7e]

v_ceil_f32 v5, vcc_hi
// CHECK: [0x6b,0x3a,0x0a,0x7e]

v_ceil_f32 v5, tba_lo
// CHECK: [0x6c,0x3a,0x0a,0x7e]

v_ceil_f32 v5, tba_hi
// CHECK: [0x6d,0x3a,0x0a,0x7e]

v_ceil_f32 v5, tma_lo
// CHECK: [0x6e,0x3a,0x0a,0x7e]

v_ceil_f32 v5, tma_hi
// CHECK: [0x6f,0x3a,0x0a,0x7e]

v_ceil_f32 v5, ttmp11
// CHECK: [0x7b,0x3a,0x0a,0x7e]

v_ceil_f32 v5, m0
// CHECK: [0x7c,0x3a,0x0a,0x7e]

v_ceil_f32 v5, exec_lo
// CHECK: [0x7e,0x3a,0x0a,0x7e]

v_ceil_f32 v5, exec_hi
// CHECK: [0x7f,0x3a,0x0a,0x7e]

v_ceil_f32 v5, 0
// CHECK: [0x80,0x3a,0x0a,0x7e]

v_ceil_f32 v5, -1
// CHECK: [0xc1,0x3a,0x0a,0x7e]

v_ceil_f32 v5, 0.5
// CHECK: [0xf0,0x3a,0x0a,0x7e]

v_ceil_f32 v5, -4.0
// CHECK: [0xf7,0x3a,0x0a,0x7e]

v_ceil_f32 v5, src_vccz
// CHECK: [0xfb,0x3a,0x0a,0x7e]

v_ceil_f32 v5, src_execz
// CHECK: [0xfc,0x3a,0x0a,0x7e]

v_ceil_f32 v5, src_scc
// CHECK: [0xfd,0x3a,0x0a,0x7e]

v_ceil_f32 v5, src_lds_direct
// CHECK: [0xfe,0x3a,0x0a,0x7e]

v_ceil_f32 v5, 0xaf123456
// CHECK: [0xff,0x3a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f32 v5, 0x3f717273
// CHECK: [0xff,0x3a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f32 v5, v1
// CHECK: [0x01,0x3d,0x0a,0x7e]

v_rndne_f32 v255, v1
// CHECK: [0x01,0x3d,0xfe,0x7f]

v_rndne_f32 v5, v255
// CHECK: [0xff,0x3d,0x0a,0x7e]

v_rndne_f32 v5, s1
// CHECK: [0x01,0x3c,0x0a,0x7e]

v_rndne_f32 v5, s101
// CHECK: [0x65,0x3c,0x0a,0x7e]

v_rndne_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x3c,0x0a,0x7e]

v_rndne_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x3c,0x0a,0x7e]

v_rndne_f32 v5, vcc_lo
// CHECK: [0x6a,0x3c,0x0a,0x7e]

v_rndne_f32 v5, vcc_hi
// CHECK: [0x6b,0x3c,0x0a,0x7e]

v_rndne_f32 v5, tba_lo
// CHECK: [0x6c,0x3c,0x0a,0x7e]

v_rndne_f32 v5, tba_hi
// CHECK: [0x6d,0x3c,0x0a,0x7e]

v_rndne_f32 v5, tma_lo
// CHECK: [0x6e,0x3c,0x0a,0x7e]

v_rndne_f32 v5, tma_hi
// CHECK: [0x6f,0x3c,0x0a,0x7e]

v_rndne_f32 v5, ttmp11
// CHECK: [0x7b,0x3c,0x0a,0x7e]

v_rndne_f32 v5, m0
// CHECK: [0x7c,0x3c,0x0a,0x7e]

v_rndne_f32 v5, exec_lo
// CHECK: [0x7e,0x3c,0x0a,0x7e]

v_rndne_f32 v5, exec_hi
// CHECK: [0x7f,0x3c,0x0a,0x7e]

v_rndne_f32 v5, 0
// CHECK: [0x80,0x3c,0x0a,0x7e]

v_rndne_f32 v5, -1
// CHECK: [0xc1,0x3c,0x0a,0x7e]

v_rndne_f32 v5, 0.5
// CHECK: [0xf0,0x3c,0x0a,0x7e]

v_rndne_f32 v5, -4.0
// CHECK: [0xf7,0x3c,0x0a,0x7e]

v_rndne_f32 v5, src_vccz
// CHECK: [0xfb,0x3c,0x0a,0x7e]

v_rndne_f32 v5, src_execz
// CHECK: [0xfc,0x3c,0x0a,0x7e]

v_rndne_f32 v5, src_scc
// CHECK: [0xfd,0x3c,0x0a,0x7e]

v_rndne_f32 v5, src_lds_direct
// CHECK: [0xfe,0x3c,0x0a,0x7e]

v_rndne_f32 v5, 0xaf123456
// CHECK: [0xff,0x3c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f32 v5, 0x3f717273
// CHECK: [0xff,0x3c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f32 v5, v1
// CHECK: [0x01,0x3f,0x0a,0x7e]

v_floor_f32 v255, v1
// CHECK: [0x01,0x3f,0xfe,0x7f]

v_floor_f32 v5, v255
// CHECK: [0xff,0x3f,0x0a,0x7e]

v_floor_f32 v5, s1
// CHECK: [0x01,0x3e,0x0a,0x7e]

v_floor_f32 v5, s101
// CHECK: [0x65,0x3e,0x0a,0x7e]

v_floor_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x3e,0x0a,0x7e]

v_floor_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x3e,0x0a,0x7e]

v_floor_f32 v5, vcc_lo
// CHECK: [0x6a,0x3e,0x0a,0x7e]

v_floor_f32 v5, vcc_hi
// CHECK: [0x6b,0x3e,0x0a,0x7e]

v_floor_f32 v5, tba_lo
// CHECK: [0x6c,0x3e,0x0a,0x7e]

v_floor_f32 v5, tba_hi
// CHECK: [0x6d,0x3e,0x0a,0x7e]

v_floor_f32 v5, tma_lo
// CHECK: [0x6e,0x3e,0x0a,0x7e]

v_floor_f32 v5, tma_hi
// CHECK: [0x6f,0x3e,0x0a,0x7e]

v_floor_f32 v5, ttmp11
// CHECK: [0x7b,0x3e,0x0a,0x7e]

v_floor_f32 v5, m0
// CHECK: [0x7c,0x3e,0x0a,0x7e]

v_floor_f32 v5, exec_lo
// CHECK: [0x7e,0x3e,0x0a,0x7e]

v_floor_f32 v5, exec_hi
// CHECK: [0x7f,0x3e,0x0a,0x7e]

v_floor_f32 v5, 0
// CHECK: [0x80,0x3e,0x0a,0x7e]

v_floor_f32 v5, -1
// CHECK: [0xc1,0x3e,0x0a,0x7e]

v_floor_f32 v5, 0.5
// CHECK: [0xf0,0x3e,0x0a,0x7e]

v_floor_f32 v5, -4.0
// CHECK: [0xf7,0x3e,0x0a,0x7e]

v_floor_f32 v5, src_vccz
// CHECK: [0xfb,0x3e,0x0a,0x7e]

v_floor_f32 v5, src_execz
// CHECK: [0xfc,0x3e,0x0a,0x7e]

v_floor_f32 v5, src_scc
// CHECK: [0xfd,0x3e,0x0a,0x7e]

v_floor_f32 v5, src_lds_direct
// CHECK: [0xfe,0x3e,0x0a,0x7e]

v_floor_f32 v5, 0xaf123456
// CHECK: [0xff,0x3e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f32 v5, 0x3f717273
// CHECK: [0xff,0x3e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_f32 v5, v1
// CHECK: [0x01,0x41,0x0a,0x7e]

v_exp_f32 v255, v1
// CHECK: [0x01,0x41,0xfe,0x7f]

v_exp_f32 v5, v255
// CHECK: [0xff,0x41,0x0a,0x7e]

v_exp_f32 v5, s1
// CHECK: [0x01,0x40,0x0a,0x7e]

v_exp_f32 v5, s101
// CHECK: [0x65,0x40,0x0a,0x7e]

v_exp_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x40,0x0a,0x7e]

v_exp_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x40,0x0a,0x7e]

v_exp_f32 v5, vcc_lo
// CHECK: [0x6a,0x40,0x0a,0x7e]

v_exp_f32 v5, vcc_hi
// CHECK: [0x6b,0x40,0x0a,0x7e]

v_exp_f32 v5, tba_lo
// CHECK: [0x6c,0x40,0x0a,0x7e]

v_exp_f32 v5, tba_hi
// CHECK: [0x6d,0x40,0x0a,0x7e]

v_exp_f32 v5, tma_lo
// CHECK: [0x6e,0x40,0x0a,0x7e]

v_exp_f32 v5, tma_hi
// CHECK: [0x6f,0x40,0x0a,0x7e]

v_exp_f32 v5, ttmp11
// CHECK: [0x7b,0x40,0x0a,0x7e]

v_exp_f32 v5, m0
// CHECK: [0x7c,0x40,0x0a,0x7e]

v_exp_f32 v5, exec_lo
// CHECK: [0x7e,0x40,0x0a,0x7e]

v_exp_f32 v5, exec_hi
// CHECK: [0x7f,0x40,0x0a,0x7e]

v_exp_f32 v5, 0
// CHECK: [0x80,0x40,0x0a,0x7e]

v_exp_f32 v5, -1
// CHECK: [0xc1,0x40,0x0a,0x7e]

v_exp_f32 v5, 0.5
// CHECK: [0xf0,0x40,0x0a,0x7e]

v_exp_f32 v5, -4.0
// CHECK: [0xf7,0x40,0x0a,0x7e]

v_exp_f32 v5, src_vccz
// CHECK: [0xfb,0x40,0x0a,0x7e]

v_exp_f32 v5, src_execz
// CHECK: [0xfc,0x40,0x0a,0x7e]

v_exp_f32 v5, src_scc
// CHECK: [0xfd,0x40,0x0a,0x7e]

v_exp_f32 v5, src_lds_direct
// CHECK: [0xfe,0x40,0x0a,0x7e]

v_exp_f32 v5, 0xaf123456
// CHECK: [0xff,0x40,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_f32 v5, 0x3f717273
// CHECK: [0xff,0x40,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_f32 v5, v1
// CHECK: [0x01,0x43,0x0a,0x7e]

v_log_f32 v255, v1
// CHECK: [0x01,0x43,0xfe,0x7f]

v_log_f32 v5, v255
// CHECK: [0xff,0x43,0x0a,0x7e]

v_log_f32 v5, s1
// CHECK: [0x01,0x42,0x0a,0x7e]

v_log_f32 v5, s101
// CHECK: [0x65,0x42,0x0a,0x7e]

v_log_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x42,0x0a,0x7e]

v_log_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x42,0x0a,0x7e]

v_log_f32 v5, vcc_lo
// CHECK: [0x6a,0x42,0x0a,0x7e]

v_log_f32 v5, vcc_hi
// CHECK: [0x6b,0x42,0x0a,0x7e]

v_log_f32 v5, tba_lo
// CHECK: [0x6c,0x42,0x0a,0x7e]

v_log_f32 v5, tba_hi
// CHECK: [0x6d,0x42,0x0a,0x7e]

v_log_f32 v5, tma_lo
// CHECK: [0x6e,0x42,0x0a,0x7e]

v_log_f32 v5, tma_hi
// CHECK: [0x6f,0x42,0x0a,0x7e]

v_log_f32 v5, ttmp11
// CHECK: [0x7b,0x42,0x0a,0x7e]

v_log_f32 v5, m0
// CHECK: [0x7c,0x42,0x0a,0x7e]

v_log_f32 v5, exec_lo
// CHECK: [0x7e,0x42,0x0a,0x7e]

v_log_f32 v5, exec_hi
// CHECK: [0x7f,0x42,0x0a,0x7e]

v_log_f32 v5, 0
// CHECK: [0x80,0x42,0x0a,0x7e]

v_log_f32 v5, -1
// CHECK: [0xc1,0x42,0x0a,0x7e]

v_log_f32 v5, 0.5
// CHECK: [0xf0,0x42,0x0a,0x7e]

v_log_f32 v5, -4.0
// CHECK: [0xf7,0x42,0x0a,0x7e]

v_log_f32 v5, src_vccz
// CHECK: [0xfb,0x42,0x0a,0x7e]

v_log_f32 v5, src_execz
// CHECK: [0xfc,0x42,0x0a,0x7e]

v_log_f32 v5, src_scc
// CHECK: [0xfd,0x42,0x0a,0x7e]

v_log_f32 v5, src_lds_direct
// CHECK: [0xfe,0x42,0x0a,0x7e]

v_log_f32 v5, 0xaf123456
// CHECK: [0xff,0x42,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_f32 v5, 0x3f717273
// CHECK: [0xff,0x42,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f32 v5, v1
// CHECK: [0x01,0x45,0x0a,0x7e]

v_rcp_f32 v255, v1
// CHECK: [0x01,0x45,0xfe,0x7f]

v_rcp_f32 v5, v255
// CHECK: [0xff,0x45,0x0a,0x7e]

v_rcp_f32 v5, s1
// CHECK: [0x01,0x44,0x0a,0x7e]

v_rcp_f32 v5, s101
// CHECK: [0x65,0x44,0x0a,0x7e]

v_rcp_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x44,0x0a,0x7e]

v_rcp_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x44,0x0a,0x7e]

v_rcp_f32 v5, vcc_lo
// CHECK: [0x6a,0x44,0x0a,0x7e]

v_rcp_f32 v5, vcc_hi
// CHECK: [0x6b,0x44,0x0a,0x7e]

v_rcp_f32 v5, tba_lo
// CHECK: [0x6c,0x44,0x0a,0x7e]

v_rcp_f32 v5, tba_hi
// CHECK: [0x6d,0x44,0x0a,0x7e]

v_rcp_f32 v5, tma_lo
// CHECK: [0x6e,0x44,0x0a,0x7e]

v_rcp_f32 v5, tma_hi
// CHECK: [0x6f,0x44,0x0a,0x7e]

v_rcp_f32 v5, ttmp11
// CHECK: [0x7b,0x44,0x0a,0x7e]

v_rcp_f32 v5, m0
// CHECK: [0x7c,0x44,0x0a,0x7e]

v_rcp_f32 v5, exec_lo
// CHECK: [0x7e,0x44,0x0a,0x7e]

v_rcp_f32 v5, exec_hi
// CHECK: [0x7f,0x44,0x0a,0x7e]

v_rcp_f32 v5, 0
// CHECK: [0x80,0x44,0x0a,0x7e]

v_rcp_f32 v5, -1
// CHECK: [0xc1,0x44,0x0a,0x7e]

v_rcp_f32 v5, 0.5
// CHECK: [0xf0,0x44,0x0a,0x7e]

v_rcp_f32 v5, -4.0
// CHECK: [0xf7,0x44,0x0a,0x7e]

v_rcp_f32 v5, src_vccz
// CHECK: [0xfb,0x44,0x0a,0x7e]

v_rcp_f32 v5, src_execz
// CHECK: [0xfc,0x44,0x0a,0x7e]

v_rcp_f32 v5, src_scc
// CHECK: [0xfd,0x44,0x0a,0x7e]

v_rcp_f32 v5, src_lds_direct
// CHECK: [0xfe,0x44,0x0a,0x7e]

v_rcp_f32 v5, 0xaf123456
// CHECK: [0xff,0x44,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f32 v5, 0x3f717273
// CHECK: [0xff,0x44,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32 v5, v1
// CHECK: [0x01,0x47,0x0a,0x7e]

v_rcp_iflag_f32 v255, v1
// CHECK: [0x01,0x47,0xfe,0x7f]

v_rcp_iflag_f32 v5, v255
// CHECK: [0xff,0x47,0x0a,0x7e]

v_rcp_iflag_f32 v5, s1
// CHECK: [0x01,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, s101
// CHECK: [0x65,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_lo
// CHECK: [0x6a,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_hi
// CHECK: [0x6b,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, tba_lo
// CHECK: [0x6c,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, tba_hi
// CHECK: [0x6d,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, tma_lo
// CHECK: [0x6e,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, tma_hi
// CHECK: [0x6f,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, ttmp11
// CHECK: [0x7b,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, m0
// CHECK: [0x7c,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_lo
// CHECK: [0x7e,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_hi
// CHECK: [0x7f,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0
// CHECK: [0x80,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, -1
// CHECK: [0xc1,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0.5
// CHECK: [0xf0,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, -4.0
// CHECK: [0xf7,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, src_vccz
// CHECK: [0xfb,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, src_execz
// CHECK: [0xfc,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, src_scc
// CHECK: [0xfd,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, src_lds_direct
// CHECK: [0xfe,0x46,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0xaf123456
// CHECK: [0xff,0x46,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32 v5, 0x3f717273
// CHECK: [0xff,0x46,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32 v5, v1
// CHECK: [0x01,0x49,0x0a,0x7e]

v_rsq_f32 v255, v1
// CHECK: [0x01,0x49,0xfe,0x7f]

v_rsq_f32 v5, v255
// CHECK: [0xff,0x49,0x0a,0x7e]

v_rsq_f32 v5, s1
// CHECK: [0x01,0x48,0x0a,0x7e]

v_rsq_f32 v5, s101
// CHECK: [0x65,0x48,0x0a,0x7e]

v_rsq_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x48,0x0a,0x7e]

v_rsq_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x48,0x0a,0x7e]

v_rsq_f32 v5, vcc_lo
// CHECK: [0x6a,0x48,0x0a,0x7e]

v_rsq_f32 v5, vcc_hi
// CHECK: [0x6b,0x48,0x0a,0x7e]

v_rsq_f32 v5, tba_lo
// CHECK: [0x6c,0x48,0x0a,0x7e]

v_rsq_f32 v5, tba_hi
// CHECK: [0x6d,0x48,0x0a,0x7e]

v_rsq_f32 v5, tma_lo
// CHECK: [0x6e,0x48,0x0a,0x7e]

v_rsq_f32 v5, tma_hi
// CHECK: [0x6f,0x48,0x0a,0x7e]

v_rsq_f32 v5, ttmp11
// CHECK: [0x7b,0x48,0x0a,0x7e]

v_rsq_f32 v5, m0
// CHECK: [0x7c,0x48,0x0a,0x7e]

v_rsq_f32 v5, exec_lo
// CHECK: [0x7e,0x48,0x0a,0x7e]

v_rsq_f32 v5, exec_hi
// CHECK: [0x7f,0x48,0x0a,0x7e]

v_rsq_f32 v5, 0
// CHECK: [0x80,0x48,0x0a,0x7e]

v_rsq_f32 v5, -1
// CHECK: [0xc1,0x48,0x0a,0x7e]

v_rsq_f32 v5, 0.5
// CHECK: [0xf0,0x48,0x0a,0x7e]

v_rsq_f32 v5, -4.0
// CHECK: [0xf7,0x48,0x0a,0x7e]

v_rsq_f32 v5, src_vccz
// CHECK: [0xfb,0x48,0x0a,0x7e]

v_rsq_f32 v5, src_execz
// CHECK: [0xfc,0x48,0x0a,0x7e]

v_rsq_f32 v5, src_scc
// CHECK: [0xfd,0x48,0x0a,0x7e]

v_rsq_f32 v5, src_lds_direct
// CHECK: [0xfe,0x48,0x0a,0x7e]

v_rsq_f32 v5, 0xaf123456
// CHECK: [0xff,0x48,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f32 v5, 0x3f717273
// CHECK: [0xff,0x48,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x4b,0x0a,0x7e]

v_rcp_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x4b,0xfc,0x7f]

v_rcp_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x4b,0x0a,0x7e]

v_rcp_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], vcc
// CHECK: [0x6a,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], tba
// CHECK: [0x6c,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], tma
// CHECK: [0x6e,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], exec
// CHECK: [0x7e,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], 0
// CHECK: [0x80,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], -1
// CHECK: [0xc1,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], 0.5
// CHECK: [0xf0,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], -4.0
// CHECK: [0xf7,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], src_execz
// CHECK: [0xfc,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], src_scc
// CHECK: [0xfd,0x4a,0x0a,0x7e]

v_rcp_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x4a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x4a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x4d,0x0a,0x7e]

v_rsq_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x4d,0xfc,0x7f]

v_rsq_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x4d,0x0a,0x7e]

v_rsq_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], vcc
// CHECK: [0x6a,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], tba
// CHECK: [0x6c,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], tma
// CHECK: [0x6e,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], exec
// CHECK: [0x7e,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], 0
// CHECK: [0x80,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], -1
// CHECK: [0xc1,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], 0.5
// CHECK: [0xf0,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], -4.0
// CHECK: [0xf7,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], src_execz
// CHECK: [0xfc,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], src_scc
// CHECK: [0xfd,0x4c,0x0a,0x7e]

v_rsq_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x4c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x4c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f32 v5, v1
// CHECK: [0x01,0x4f,0x0a,0x7e]

v_sqrt_f32 v255, v1
// CHECK: [0x01,0x4f,0xfe,0x7f]

v_sqrt_f32 v5, v255
// CHECK: [0xff,0x4f,0x0a,0x7e]

v_sqrt_f32 v5, s1
// CHECK: [0x01,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, s101
// CHECK: [0x65,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, vcc_lo
// CHECK: [0x6a,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, vcc_hi
// CHECK: [0x6b,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, tba_lo
// CHECK: [0x6c,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, tba_hi
// CHECK: [0x6d,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, tma_lo
// CHECK: [0x6e,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, tma_hi
// CHECK: [0x6f,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, ttmp11
// CHECK: [0x7b,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, m0
// CHECK: [0x7c,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, exec_lo
// CHECK: [0x7e,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, exec_hi
// CHECK: [0x7f,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, 0
// CHECK: [0x80,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, -1
// CHECK: [0xc1,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, 0.5
// CHECK: [0xf0,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, -4.0
// CHECK: [0xf7,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, src_vccz
// CHECK: [0xfb,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, src_execz
// CHECK: [0xfc,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, src_scc
// CHECK: [0xfd,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, src_lds_direct
// CHECK: [0xfe,0x4e,0x0a,0x7e]

v_sqrt_f32 v5, 0xaf123456
// CHECK: [0xff,0x4e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f32 v5, 0x3f717273
// CHECK: [0xff,0x4e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x51,0x0a,0x7e]

v_sqrt_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x51,0xfc,0x7f]

v_sqrt_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x51,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], vcc
// CHECK: [0x6a,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], tba
// CHECK: [0x6c,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], tma
// CHECK: [0x6e,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], exec
// CHECK: [0x7e,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0
// CHECK: [0x80,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], -1
// CHECK: [0xc1,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0.5
// CHECK: [0xf0,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], -4.0
// CHECK: [0xf7,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], src_execz
// CHECK: [0xfc,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], src_scc
// CHECK: [0xfd,0x50,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x50,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x50,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sin_f32 v5, v1
// CHECK: [0x01,0x53,0x0a,0x7e]

v_sin_f32 v255, v1
// CHECK: [0x01,0x53,0xfe,0x7f]

v_sin_f32 v5, v255
// CHECK: [0xff,0x53,0x0a,0x7e]

v_sin_f32 v5, s1
// CHECK: [0x01,0x52,0x0a,0x7e]

v_sin_f32 v5, s101
// CHECK: [0x65,0x52,0x0a,0x7e]

v_sin_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x52,0x0a,0x7e]

v_sin_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x52,0x0a,0x7e]

v_sin_f32 v5, vcc_lo
// CHECK: [0x6a,0x52,0x0a,0x7e]

v_sin_f32 v5, vcc_hi
// CHECK: [0x6b,0x52,0x0a,0x7e]

v_sin_f32 v5, tba_lo
// CHECK: [0x6c,0x52,0x0a,0x7e]

v_sin_f32 v5, tba_hi
// CHECK: [0x6d,0x52,0x0a,0x7e]

v_sin_f32 v5, tma_lo
// CHECK: [0x6e,0x52,0x0a,0x7e]

v_sin_f32 v5, tma_hi
// CHECK: [0x6f,0x52,0x0a,0x7e]

v_sin_f32 v5, ttmp11
// CHECK: [0x7b,0x52,0x0a,0x7e]

v_sin_f32 v5, m0
// CHECK: [0x7c,0x52,0x0a,0x7e]

v_sin_f32 v5, exec_lo
// CHECK: [0x7e,0x52,0x0a,0x7e]

v_sin_f32 v5, exec_hi
// CHECK: [0x7f,0x52,0x0a,0x7e]

v_sin_f32 v5, 0
// CHECK: [0x80,0x52,0x0a,0x7e]

v_sin_f32 v5, -1
// CHECK: [0xc1,0x52,0x0a,0x7e]

v_sin_f32 v5, 0.5
// CHECK: [0xf0,0x52,0x0a,0x7e]

v_sin_f32 v5, -4.0
// CHECK: [0xf7,0x52,0x0a,0x7e]

v_sin_f32 v5, src_vccz
// CHECK: [0xfb,0x52,0x0a,0x7e]

v_sin_f32 v5, src_execz
// CHECK: [0xfc,0x52,0x0a,0x7e]

v_sin_f32 v5, src_scc
// CHECK: [0xfd,0x52,0x0a,0x7e]

v_sin_f32 v5, src_lds_direct
// CHECK: [0xfe,0x52,0x0a,0x7e]

v_sin_f32 v5, 0xaf123456
// CHECK: [0xff,0x52,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sin_f32 v5, 0x3f717273
// CHECK: [0xff,0x52,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32 v5, v1
// CHECK: [0x01,0x55,0x0a,0x7e]

v_cos_f32 v255, v1
// CHECK: [0x01,0x55,0xfe,0x7f]

v_cos_f32 v5, v255
// CHECK: [0xff,0x55,0x0a,0x7e]

v_cos_f32 v5, s1
// CHECK: [0x01,0x54,0x0a,0x7e]

v_cos_f32 v5, s101
// CHECK: [0x65,0x54,0x0a,0x7e]

v_cos_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x54,0x0a,0x7e]

v_cos_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x54,0x0a,0x7e]

v_cos_f32 v5, vcc_lo
// CHECK: [0x6a,0x54,0x0a,0x7e]

v_cos_f32 v5, vcc_hi
// CHECK: [0x6b,0x54,0x0a,0x7e]

v_cos_f32 v5, tba_lo
// CHECK: [0x6c,0x54,0x0a,0x7e]

v_cos_f32 v5, tba_hi
// CHECK: [0x6d,0x54,0x0a,0x7e]

v_cos_f32 v5, tma_lo
// CHECK: [0x6e,0x54,0x0a,0x7e]

v_cos_f32 v5, tma_hi
// CHECK: [0x6f,0x54,0x0a,0x7e]

v_cos_f32 v5, ttmp11
// CHECK: [0x7b,0x54,0x0a,0x7e]

v_cos_f32 v5, m0
// CHECK: [0x7c,0x54,0x0a,0x7e]

v_cos_f32 v5, exec_lo
// CHECK: [0x7e,0x54,0x0a,0x7e]

v_cos_f32 v5, exec_hi
// CHECK: [0x7f,0x54,0x0a,0x7e]

v_cos_f32 v5, 0
// CHECK: [0x80,0x54,0x0a,0x7e]

v_cos_f32 v5, -1
// CHECK: [0xc1,0x54,0x0a,0x7e]

v_cos_f32 v5, 0.5
// CHECK: [0xf0,0x54,0x0a,0x7e]

v_cos_f32 v5, -4.0
// CHECK: [0xf7,0x54,0x0a,0x7e]

v_cos_f32 v5, src_vccz
// CHECK: [0xfb,0x54,0x0a,0x7e]

v_cos_f32 v5, src_execz
// CHECK: [0xfc,0x54,0x0a,0x7e]

v_cos_f32 v5, src_scc
// CHECK: [0xfd,0x54,0x0a,0x7e]

v_cos_f32 v5, src_lds_direct
// CHECK: [0xfe,0x54,0x0a,0x7e]

v_cos_f32 v5, 0xaf123456
// CHECK: [0xff,0x54,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cos_f32 v5, 0x3f717273
// CHECK: [0xff,0x54,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_not_b32 v5, v1
// CHECK: [0x01,0x57,0x0a,0x7e]

v_not_b32 v255, v1
// CHECK: [0x01,0x57,0xfe,0x7f]

v_not_b32 v5, v255
// CHECK: [0xff,0x57,0x0a,0x7e]

v_not_b32 v5, s1
// CHECK: [0x01,0x56,0x0a,0x7e]

v_not_b32 v5, s101
// CHECK: [0x65,0x56,0x0a,0x7e]

v_not_b32 v5, flat_scratch_lo
// CHECK: [0x66,0x56,0x0a,0x7e]

v_not_b32 v5, flat_scratch_hi
// CHECK: [0x67,0x56,0x0a,0x7e]

v_not_b32 v5, vcc_lo
// CHECK: [0x6a,0x56,0x0a,0x7e]

v_not_b32 v5, vcc_hi
// CHECK: [0x6b,0x56,0x0a,0x7e]

v_not_b32 v5, tba_lo
// CHECK: [0x6c,0x56,0x0a,0x7e]

v_not_b32 v5, tba_hi
// CHECK: [0x6d,0x56,0x0a,0x7e]

v_not_b32 v5, tma_lo
// CHECK: [0x6e,0x56,0x0a,0x7e]

v_not_b32 v5, tma_hi
// CHECK: [0x6f,0x56,0x0a,0x7e]

v_not_b32 v5, ttmp11
// CHECK: [0x7b,0x56,0x0a,0x7e]

v_not_b32 v5, m0
// CHECK: [0x7c,0x56,0x0a,0x7e]

v_not_b32 v5, exec_lo
// CHECK: [0x7e,0x56,0x0a,0x7e]

v_not_b32 v5, exec_hi
// CHECK: [0x7f,0x56,0x0a,0x7e]

v_not_b32 v5, 0
// CHECK: [0x80,0x56,0x0a,0x7e]

v_not_b32 v5, -1
// CHECK: [0xc1,0x56,0x0a,0x7e]

v_not_b32 v5, 0.5
// CHECK: [0xf0,0x56,0x0a,0x7e]

v_not_b32 v5, -4.0
// CHECK: [0xf7,0x56,0x0a,0x7e]

v_not_b32 v5, src_vccz
// CHECK: [0xfb,0x56,0x0a,0x7e]

v_not_b32 v5, src_execz
// CHECK: [0xfc,0x56,0x0a,0x7e]

v_not_b32 v5, src_scc
// CHECK: [0xfd,0x56,0x0a,0x7e]

v_not_b32 v5, src_lds_direct
// CHECK: [0xfe,0x56,0x0a,0x7e]

v_not_b32 v5, 0xaf123456
// CHECK: [0xff,0x56,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_not_b32 v5, 0x3f717273
// CHECK: [0xff,0x56,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_bfrev_b32 v5, v1
// CHECK: [0x01,0x59,0x0a,0x7e]

v_bfrev_b32 v255, v1
// CHECK: [0x01,0x59,0xfe,0x7f]

v_bfrev_b32 v5, v255
// CHECK: [0xff,0x59,0x0a,0x7e]

v_bfrev_b32 v5, s1
// CHECK: [0x01,0x58,0x0a,0x7e]

v_bfrev_b32 v5, s101
// CHECK: [0x65,0x58,0x0a,0x7e]

v_bfrev_b32 v5, flat_scratch_lo
// CHECK: [0x66,0x58,0x0a,0x7e]

v_bfrev_b32 v5, flat_scratch_hi
// CHECK: [0x67,0x58,0x0a,0x7e]

v_bfrev_b32 v5, vcc_lo
// CHECK: [0x6a,0x58,0x0a,0x7e]

v_bfrev_b32 v5, vcc_hi
// CHECK: [0x6b,0x58,0x0a,0x7e]

v_bfrev_b32 v5, tba_lo
// CHECK: [0x6c,0x58,0x0a,0x7e]

v_bfrev_b32 v5, tba_hi
// CHECK: [0x6d,0x58,0x0a,0x7e]

v_bfrev_b32 v5, tma_lo
// CHECK: [0x6e,0x58,0x0a,0x7e]

v_bfrev_b32 v5, tma_hi
// CHECK: [0x6f,0x58,0x0a,0x7e]

v_bfrev_b32 v5, ttmp11
// CHECK: [0x7b,0x58,0x0a,0x7e]

v_bfrev_b32 v5, m0
// CHECK: [0x7c,0x58,0x0a,0x7e]

v_bfrev_b32 v5, exec_lo
// CHECK: [0x7e,0x58,0x0a,0x7e]

v_bfrev_b32 v5, exec_hi
// CHECK: [0x7f,0x58,0x0a,0x7e]

v_bfrev_b32 v5, 0
// CHECK: [0x80,0x58,0x0a,0x7e]

v_bfrev_b32 v5, -1
// CHECK: [0xc1,0x58,0x0a,0x7e]

v_bfrev_b32 v5, 0.5
// CHECK: [0xf0,0x58,0x0a,0x7e]

v_bfrev_b32 v5, -4.0
// CHECK: [0xf7,0x58,0x0a,0x7e]

v_bfrev_b32 v5, src_vccz
// CHECK: [0xfb,0x58,0x0a,0x7e]

v_bfrev_b32 v5, src_execz
// CHECK: [0xfc,0x58,0x0a,0x7e]

v_bfrev_b32 v5, src_scc
// CHECK: [0xfd,0x58,0x0a,0x7e]

v_bfrev_b32 v5, src_lds_direct
// CHECK: [0xfe,0x58,0x0a,0x7e]

v_bfrev_b32 v5, 0xaf123456
// CHECK: [0xff,0x58,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_bfrev_b32 v5, 0x3f717273
// CHECK: [0xff,0x58,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_u32 v5, v1
// CHECK: [0x01,0x5b,0x0a,0x7e]

v_ffbh_u32 v255, v1
// CHECK: [0x01,0x5b,0xfe,0x7f]

v_ffbh_u32 v5, v255
// CHECK: [0xff,0x5b,0x0a,0x7e]

v_ffbh_u32 v5, s1
// CHECK: [0x01,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, s101
// CHECK: [0x65,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, flat_scratch_lo
// CHECK: [0x66,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, flat_scratch_hi
// CHECK: [0x67,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, vcc_lo
// CHECK: [0x6a,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, vcc_hi
// CHECK: [0x6b,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, tba_lo
// CHECK: [0x6c,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, tba_hi
// CHECK: [0x6d,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, tma_lo
// CHECK: [0x6e,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, tma_hi
// CHECK: [0x6f,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, ttmp11
// CHECK: [0x7b,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, m0
// CHECK: [0x7c,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, exec_lo
// CHECK: [0x7e,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, exec_hi
// CHECK: [0x7f,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, 0
// CHECK: [0x80,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, -1
// CHECK: [0xc1,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, 0.5
// CHECK: [0xf0,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, -4.0
// CHECK: [0xf7,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, src_vccz
// CHECK: [0xfb,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, src_execz
// CHECK: [0xfc,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, src_scc
// CHECK: [0xfd,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, src_lds_direct
// CHECK: [0xfe,0x5a,0x0a,0x7e]

v_ffbh_u32 v5, 0xaf123456
// CHECK: [0xff,0x5a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_u32 v5, 0x3f717273
// CHECK: [0xff,0x5a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbl_b32 v5, v1
// CHECK: [0x01,0x5d,0x0a,0x7e]

v_ffbl_b32 v255, v1
// CHECK: [0x01,0x5d,0xfe,0x7f]

v_ffbl_b32 v5, v255
// CHECK: [0xff,0x5d,0x0a,0x7e]

v_ffbl_b32 v5, s1
// CHECK: [0x01,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, s101
// CHECK: [0x65,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, flat_scratch_lo
// CHECK: [0x66,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, flat_scratch_hi
// CHECK: [0x67,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, vcc_lo
// CHECK: [0x6a,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, vcc_hi
// CHECK: [0x6b,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, tba_lo
// CHECK: [0x6c,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, tba_hi
// CHECK: [0x6d,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, tma_lo
// CHECK: [0x6e,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, tma_hi
// CHECK: [0x6f,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, ttmp11
// CHECK: [0x7b,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, m0
// CHECK: [0x7c,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, exec_lo
// CHECK: [0x7e,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, exec_hi
// CHECK: [0x7f,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, 0
// CHECK: [0x80,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, -1
// CHECK: [0xc1,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, 0.5
// CHECK: [0xf0,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, -4.0
// CHECK: [0xf7,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, src_vccz
// CHECK: [0xfb,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, src_execz
// CHECK: [0xfc,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, src_scc
// CHECK: [0xfd,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, src_lds_direct
// CHECK: [0xfe,0x5c,0x0a,0x7e]

v_ffbl_b32 v5, 0xaf123456
// CHECK: [0xff,0x5c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbl_b32 v5, 0x3f717273
// CHECK: [0xff,0x5c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_i32 v5, v1
// CHECK: [0x01,0x5f,0x0a,0x7e]

v_ffbh_i32 v255, v1
// CHECK: [0x01,0x5f,0xfe,0x7f]

v_ffbh_i32 v5, v255
// CHECK: [0xff,0x5f,0x0a,0x7e]

v_ffbh_i32 v5, s1
// CHECK: [0x01,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, s101
// CHECK: [0x65,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, flat_scratch_lo
// CHECK: [0x66,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, flat_scratch_hi
// CHECK: [0x67,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, vcc_lo
// CHECK: [0x6a,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, vcc_hi
// CHECK: [0x6b,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, tba_lo
// CHECK: [0x6c,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, tba_hi
// CHECK: [0x6d,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, tma_lo
// CHECK: [0x6e,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, tma_hi
// CHECK: [0x6f,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, ttmp11
// CHECK: [0x7b,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, m0
// CHECK: [0x7c,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, exec_lo
// CHECK: [0x7e,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, exec_hi
// CHECK: [0x7f,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, 0
// CHECK: [0x80,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, -1
// CHECK: [0xc1,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, 0.5
// CHECK: [0xf0,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, -4.0
// CHECK: [0xf7,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, src_vccz
// CHECK: [0xfb,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, src_execz
// CHECK: [0xfc,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, src_scc
// CHECK: [0xfd,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, src_lds_direct
// CHECK: [0xfe,0x5e,0x0a,0x7e]

v_ffbh_i32 v5, 0xaf123456
// CHECK: [0xff,0x5e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_i32 v5, 0x3f717273
// CHECK: [0xff,0x5e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f64 v5, v[1:2]
// CHECK: [0x01,0x61,0x0a,0x7e]

v_frexp_exp_i32_f64 v255, v[1:2]
// CHECK: [0x01,0x61,0xfe,0x7f]

v_frexp_exp_i32_f64 v5, v[254:255]
// CHECK: [0xfe,0x61,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[2:3]
// CHECK: [0x02,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[4:5]
// CHECK: [0x04,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[100:101]
// CHECK: [0x64,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, flat_scratch
// CHECK: [0x66,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, vcc
// CHECK: [0x6a,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, tba
// CHECK: [0x6c,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, tma
// CHECK: [0x6e,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, exec
// CHECK: [0x7e,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0
// CHECK: [0x80,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -1
// CHECK: [0xc1,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0.5
// CHECK: [0xf0,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -4.0
// CHECK: [0xf7,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, src_vccz
// CHECK: [0xfb,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, src_execz
// CHECK: [0xfc,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, src_scc
// CHECK: [0xfd,0x60,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0xaf123456
// CHECK: [0xff,0x60,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f64 v5, 0x3f717273
// CHECK: [0xff,0x60,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x63,0x0a,0x7e]

v_frexp_mant_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x63,0xfc,0x7f]

v_frexp_mant_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x63,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], vcc
// CHECK: [0x6a,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], tba
// CHECK: [0x6c,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], tma
// CHECK: [0x6e,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], exec
// CHECK: [0x7e,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0
// CHECK: [0x80,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -1
// CHECK: [0xc1,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0.5
// CHECK: [0xf0,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -4.0
// CHECK: [0xf7,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], src_execz
// CHECK: [0xfc,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], src_scc
// CHECK: [0xfd,0x62,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x62,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x62,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x65,0x0a,0x7e]

v_fract_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x65,0xfc,0x7f]

v_fract_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x65,0x0a,0x7e]

v_fract_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], s[100:101]
// CHECK: [0x64,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], flat_scratch
// CHECK: [0x66,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], vcc
// CHECK: [0x6a,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], tba
// CHECK: [0x6c,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], tma
// CHECK: [0x6e,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], exec
// CHECK: [0x7e,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], 0
// CHECK: [0x80,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], -1
// CHECK: [0xc1,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], 0.5
// CHECK: [0xf0,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], -4.0
// CHECK: [0xf7,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], src_vccz
// CHECK: [0xfb,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], src_execz
// CHECK: [0xfc,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], src_scc
// CHECK: [0xfd,0x64,0x0a,0x7e]

v_fract_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x64,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x64,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f32 v5, v1
// CHECK: [0x01,0x67,0x0a,0x7e]

v_frexp_exp_i32_f32 v255, v1
// CHECK: [0x01,0x67,0xfe,0x7f]

v_frexp_exp_i32_f32 v5, v255
// CHECK: [0xff,0x67,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s1
// CHECK: [0x01,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s101
// CHECK: [0x65,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, m0
// CHECK: [0x7c,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0
// CHECK: [0x80,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -1
// CHECK: [0xc1,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0.5
// CHECK: [0xf0,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -4.0
// CHECK: [0xf7,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, src_vccz
// CHECK: [0xfb,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, src_execz
// CHECK: [0xfc,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, src_scc
// CHECK: [0xfd,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, src_lds_direct
// CHECK: [0xfe,0x66,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x66,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x66,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f32 v5, v1
// CHECK: [0x01,0x69,0x0a,0x7e]

v_frexp_mant_f32 v255, v1
// CHECK: [0x01,0x69,0xfe,0x7f]

v_frexp_mant_f32 v5, v255
// CHECK: [0xff,0x69,0x0a,0x7e]

v_frexp_mant_f32 v5, s1
// CHECK: [0x01,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, s101
// CHECK: [0x65,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_lo
// CHECK: [0x6a,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_hi
// CHECK: [0x6b,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, tba_lo
// CHECK: [0x6c,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, tba_hi
// CHECK: [0x6d,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, tma_lo
// CHECK: [0x6e,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, tma_hi
// CHECK: [0x6f,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, ttmp11
// CHECK: [0x7b,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, m0
// CHECK: [0x7c,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_lo
// CHECK: [0x7e,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_hi
// CHECK: [0x7f,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, 0
// CHECK: [0x80,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, -1
// CHECK: [0xc1,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, 0.5
// CHECK: [0xf0,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, -4.0
// CHECK: [0xf7,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, src_vccz
// CHECK: [0xfb,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, src_execz
// CHECK: [0xfc,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, src_scc
// CHECK: [0xfd,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, src_lds_direct
// CHECK: [0xfe,0x68,0x0a,0x7e]

v_frexp_mant_f32 v5, 0xaf123456
// CHECK: [0xff,0x68,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f32 v5, 0x3f717273
// CHECK: [0xff,0x68,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_clrexcp
// CHECK: [0x00,0x6a,0x00,0x7e]

v_movreld_b32 v5, v1
// CHECK: [0x01,0x6d,0x0a,0x7e]

v_movreld_b32 v255, v1
// CHECK: [0x01,0x6d,0xfe,0x7f]

v_movreld_b32 v5, v255
// CHECK: [0xff,0x6d,0x0a,0x7e]

v_movreld_b32 v5, m0
// CHECK: [0x7c,0x6c,0x0a,0x7e]

v_movreld_b32 v5, 0
// CHECK: [0x80,0x6c,0x0a,0x7e]

v_movreld_b32 v5, -1
// CHECK: [0xc1,0x6c,0x0a,0x7e]

v_movreld_b32 v5, 0.5
// CHECK: [0xf0,0x6c,0x0a,0x7e]

v_movreld_b32 v5, -4.0
// CHECK: [0xf7,0x6c,0x0a,0x7e]

v_movreld_b32 v5, src_lds_direct
// CHECK: [0xfe,0x6c,0x0a,0x7e]

v_movrels_b32 v5, v1
// CHECK: [0x01,0x6f,0x0a,0x7e]

v_movrels_b32 v255, v1
// CHECK: [0x01,0x6f,0xfe,0x7f]

v_movrels_b32 v5, v255
// CHECK: [0xff,0x6f,0x0a,0x7e]

v_movrelsd_b32 v5, v1
// CHECK: [0x01,0x71,0x0a,0x7e]

v_movrelsd_b32 v255, v1
// CHECK: [0x01,0x71,0xfe,0x7f]

v_movrelsd_b32 v5, v255
// CHECK: [0xff,0x71,0x0a,0x7e]

v_cvt_f16_u16 v5, v1
// CHECK: [0x01,0x73,0x0a,0x7e]

v_cvt_f16_u16 v255, v1
// CHECK: [0x01,0x73,0xfe,0x7f]

v_cvt_f16_u16 v5, v255
// CHECK: [0xff,0x73,0x0a,0x7e]

v_cvt_f16_u16 v5, s1
// CHECK: [0x01,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, s101
// CHECK: [0x65,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, flat_scratch_lo
// CHECK: [0x66,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, flat_scratch_hi
// CHECK: [0x67,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, vcc_lo
// CHECK: [0x6a,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, vcc_hi
// CHECK: [0x6b,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, tba_lo
// CHECK: [0x6c,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, tba_hi
// CHECK: [0x6d,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, tma_lo
// CHECK: [0x6e,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, tma_hi
// CHECK: [0x6f,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, ttmp11
// CHECK: [0x7b,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, m0
// CHECK: [0x7c,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, exec_lo
// CHECK: [0x7e,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, exec_hi
// CHECK: [0x7f,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, 0
// CHECK: [0x80,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, -1
// CHECK: [0xc1,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, 0.5
// CHECK: [0xf0,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, -4.0
// CHECK: [0xf7,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, src_vccz
// CHECK: [0xfb,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, src_execz
// CHECK: [0xfc,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, src_scc
// CHECK: [0xfd,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, src_lds_direct
// CHECK: [0xfe,0x72,0x0a,0x7e]

v_cvt_f16_u16 v5, 0xfe0b
// CHECK: [0xff,0x72,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_f16_u16 v5, 0x3456
// CHECK: [0xff,0x72,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_f16_i16 v5, v1
// CHECK: [0x01,0x75,0x0a,0x7e]

v_cvt_f16_i16 v255, v1
// CHECK: [0x01,0x75,0xfe,0x7f]

v_cvt_f16_i16 v5, v255
// CHECK: [0xff,0x75,0x0a,0x7e]

v_cvt_f16_i16 v5, s1
// CHECK: [0x01,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, s101
// CHECK: [0x65,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, flat_scratch_lo
// CHECK: [0x66,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, flat_scratch_hi
// CHECK: [0x67,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, vcc_lo
// CHECK: [0x6a,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, vcc_hi
// CHECK: [0x6b,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, tba_lo
// CHECK: [0x6c,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, tba_hi
// CHECK: [0x6d,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, tma_lo
// CHECK: [0x6e,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, tma_hi
// CHECK: [0x6f,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, ttmp11
// CHECK: [0x7b,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, m0
// CHECK: [0x7c,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, exec_lo
// CHECK: [0x7e,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, exec_hi
// CHECK: [0x7f,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, 0
// CHECK: [0x80,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, -1
// CHECK: [0xc1,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, 0.5
// CHECK: [0xf0,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, -4.0
// CHECK: [0xf7,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, src_vccz
// CHECK: [0xfb,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, src_execz
// CHECK: [0xfc,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, src_scc
// CHECK: [0xfd,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, src_lds_direct
// CHECK: [0xfe,0x74,0x0a,0x7e]

v_cvt_f16_i16 v5, 0xfe0b
// CHECK: [0xff,0x74,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_f16_i16 v5, 0x3456
// CHECK: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_u16_f16 v5, v1
// CHECK: [0x01,0x77,0x0a,0x7e]

v_cvt_u16_f16 v255, v1
// CHECK: [0x01,0x77,0xfe,0x7f]

v_cvt_u16_f16 v5, v255
// CHECK: [0xff,0x77,0x0a,0x7e]

v_cvt_u16_f16 v5, s1
// CHECK: [0x01,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, s101
// CHECK: [0x65,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, vcc_lo
// CHECK: [0x6a,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, vcc_hi
// CHECK: [0x6b,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, tba_lo
// CHECK: [0x6c,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, tba_hi
// CHECK: [0x6d,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, tma_lo
// CHECK: [0x6e,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, tma_hi
// CHECK: [0x6f,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, ttmp11
// CHECK: [0x7b,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, m0
// CHECK: [0x7c,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, exec_lo
// CHECK: [0x7e,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, exec_hi
// CHECK: [0x7f,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, 0
// CHECK: [0x80,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, -1
// CHECK: [0xc1,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, 0.5
// CHECK: [0xf0,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, -4.0
// CHECK: [0xf7,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, src_vccz
// CHECK: [0xfb,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, src_execz
// CHECK: [0xfc,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, src_scc
// CHECK: [0xfd,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, src_lds_direct
// CHECK: [0xfe,0x76,0x0a,0x7e]

v_cvt_u16_f16 v5, 0xfe0b
// CHECK: [0xff,0x76,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_u16_f16 v5, 0x3456
// CHECK: [0xff,0x76,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cvt_i16_f16 v5, v1
// CHECK: [0x01,0x79,0x0a,0x7e]

v_cvt_i16_f16 v255, v1
// CHECK: [0x01,0x79,0xfe,0x7f]

v_cvt_i16_f16 v5, v255
// CHECK: [0xff,0x79,0x0a,0x7e]

v_cvt_i16_f16 v5, s1
// CHECK: [0x01,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, s101
// CHECK: [0x65,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, vcc_lo
// CHECK: [0x6a,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, vcc_hi
// CHECK: [0x6b,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, tba_lo
// CHECK: [0x6c,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, tba_hi
// CHECK: [0x6d,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, tma_lo
// CHECK: [0x6e,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, tma_hi
// CHECK: [0x6f,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, ttmp11
// CHECK: [0x7b,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, m0
// CHECK: [0x7c,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, exec_lo
// CHECK: [0x7e,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, exec_hi
// CHECK: [0x7f,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, 0
// CHECK: [0x80,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, -1
// CHECK: [0xc1,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, 0.5
// CHECK: [0xf0,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, -4.0
// CHECK: [0xf7,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, src_vccz
// CHECK: [0xfb,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, src_execz
// CHECK: [0xfc,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, src_scc
// CHECK: [0xfd,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, src_lds_direct
// CHECK: [0xfe,0x78,0x0a,0x7e]

v_cvt_i16_f16 v5, 0xfe0b
// CHECK: [0xff,0x78,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cvt_i16_f16 v5, 0x3456
// CHECK: [0xff,0x78,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rcp_f16 v5, v1
// CHECK: [0x01,0x7b,0x0a,0x7e]

v_rcp_f16 v255, v1
// CHECK: [0x01,0x7b,0xfe,0x7f]

v_rcp_f16 v5, v255
// CHECK: [0xff,0x7b,0x0a,0x7e]

v_rcp_f16 v5, s1
// CHECK: [0x01,0x7a,0x0a,0x7e]

v_rcp_f16 v5, s101
// CHECK: [0x65,0x7a,0x0a,0x7e]

v_rcp_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x7a,0x0a,0x7e]

v_rcp_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x7a,0x0a,0x7e]

v_rcp_f16 v5, vcc_lo
// CHECK: [0x6a,0x7a,0x0a,0x7e]

v_rcp_f16 v5, vcc_hi
// CHECK: [0x6b,0x7a,0x0a,0x7e]

v_rcp_f16 v5, tba_lo
// CHECK: [0x6c,0x7a,0x0a,0x7e]

v_rcp_f16 v5, tba_hi
// CHECK: [0x6d,0x7a,0x0a,0x7e]

v_rcp_f16 v5, tma_lo
// CHECK: [0x6e,0x7a,0x0a,0x7e]

v_rcp_f16 v5, tma_hi
// CHECK: [0x6f,0x7a,0x0a,0x7e]

v_rcp_f16 v5, ttmp11
// CHECK: [0x7b,0x7a,0x0a,0x7e]

v_rcp_f16 v5, m0
// CHECK: [0x7c,0x7a,0x0a,0x7e]

v_rcp_f16 v5, exec_lo
// CHECK: [0x7e,0x7a,0x0a,0x7e]

v_rcp_f16 v5, exec_hi
// CHECK: [0x7f,0x7a,0x0a,0x7e]

v_rcp_f16 v5, 0
// CHECK: [0x80,0x7a,0x0a,0x7e]

v_rcp_f16 v5, -1
// CHECK: [0xc1,0x7a,0x0a,0x7e]

v_rcp_f16 v5, 0.5
// CHECK: [0xf0,0x7a,0x0a,0x7e]

v_rcp_f16 v5, -4.0
// CHECK: [0xf7,0x7a,0x0a,0x7e]

v_rcp_f16 v5, src_vccz
// CHECK: [0xfb,0x7a,0x0a,0x7e]

v_rcp_f16 v5, src_execz
// CHECK: [0xfc,0x7a,0x0a,0x7e]

v_rcp_f16 v5, src_scc
// CHECK: [0xfd,0x7a,0x0a,0x7e]

v_rcp_f16 v5, src_lds_direct
// CHECK: [0xfe,0x7a,0x0a,0x7e]

v_rcp_f16 v5, 0xfe0b
// CHECK: [0xff,0x7a,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rcp_f16 v5, 0x3456
// CHECK: [0xff,0x7a,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_sqrt_f16 v5, v1
// CHECK: [0x01,0x7d,0x0a,0x7e]

v_sqrt_f16 v255, v1
// CHECK: [0x01,0x7d,0xfe,0x7f]

v_sqrt_f16 v5, v255
// CHECK: [0xff,0x7d,0x0a,0x7e]

v_sqrt_f16 v5, s1
// CHECK: [0x01,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, s101
// CHECK: [0x65,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, vcc_lo
// CHECK: [0x6a,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, vcc_hi
// CHECK: [0x6b,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, tba_lo
// CHECK: [0x6c,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, tba_hi
// CHECK: [0x6d,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, tma_lo
// CHECK: [0x6e,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, tma_hi
// CHECK: [0x6f,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, ttmp11
// CHECK: [0x7b,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, m0
// CHECK: [0x7c,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, exec_lo
// CHECK: [0x7e,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, exec_hi
// CHECK: [0x7f,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, 0
// CHECK: [0x80,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, -1
// CHECK: [0xc1,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, 0.5
// CHECK: [0xf0,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, -4.0
// CHECK: [0xf7,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, src_vccz
// CHECK: [0xfb,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, src_execz
// CHECK: [0xfc,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, src_scc
// CHECK: [0xfd,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, src_lds_direct
// CHECK: [0xfe,0x7c,0x0a,0x7e]

v_sqrt_f16 v5, 0xfe0b
// CHECK: [0xff,0x7c,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_sqrt_f16 v5, 0x3456
// CHECK: [0xff,0x7c,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rsq_f16 v5, v1
// CHECK: [0x01,0x7f,0x0a,0x7e]

v_rsq_f16 v255, v1
// CHECK: [0x01,0x7f,0xfe,0x7f]

v_rsq_f16 v5, v255
// CHECK: [0xff,0x7f,0x0a,0x7e]

v_rsq_f16 v5, s1
// CHECK: [0x01,0x7e,0x0a,0x7e]

v_rsq_f16 v5, s101
// CHECK: [0x65,0x7e,0x0a,0x7e]

v_rsq_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x7e,0x0a,0x7e]

v_rsq_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x7e,0x0a,0x7e]

v_rsq_f16 v5, vcc_lo
// CHECK: [0x6a,0x7e,0x0a,0x7e]

v_rsq_f16 v5, vcc_hi
// CHECK: [0x6b,0x7e,0x0a,0x7e]

v_rsq_f16 v5, tba_lo
// CHECK: [0x6c,0x7e,0x0a,0x7e]

v_rsq_f16 v5, tba_hi
// CHECK: [0x6d,0x7e,0x0a,0x7e]

v_rsq_f16 v5, tma_lo
// CHECK: [0x6e,0x7e,0x0a,0x7e]

v_rsq_f16 v5, tma_hi
// CHECK: [0x6f,0x7e,0x0a,0x7e]

v_rsq_f16 v5, ttmp11
// CHECK: [0x7b,0x7e,0x0a,0x7e]

v_rsq_f16 v5, m0
// CHECK: [0x7c,0x7e,0x0a,0x7e]

v_rsq_f16 v5, exec_lo
// CHECK: [0x7e,0x7e,0x0a,0x7e]

v_rsq_f16 v5, exec_hi
// CHECK: [0x7f,0x7e,0x0a,0x7e]

v_rsq_f16 v5, 0
// CHECK: [0x80,0x7e,0x0a,0x7e]

v_rsq_f16 v5, -1
// CHECK: [0xc1,0x7e,0x0a,0x7e]

v_rsq_f16 v5, 0.5
// CHECK: [0xf0,0x7e,0x0a,0x7e]

v_rsq_f16 v5, -4.0
// CHECK: [0xf7,0x7e,0x0a,0x7e]

v_rsq_f16 v5, src_vccz
// CHECK: [0xfb,0x7e,0x0a,0x7e]

v_rsq_f16 v5, src_execz
// CHECK: [0xfc,0x7e,0x0a,0x7e]

v_rsq_f16 v5, src_scc
// CHECK: [0xfd,0x7e,0x0a,0x7e]

v_rsq_f16 v5, src_lds_direct
// CHECK: [0xfe,0x7e,0x0a,0x7e]

v_rsq_f16 v5, 0xfe0b
// CHECK: [0xff,0x7e,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rsq_f16 v5, 0x3456
// CHECK: [0xff,0x7e,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_log_f16 v5, v1
// CHECK: [0x01,0x81,0x0a,0x7e]

v_log_f16 v255, v1
// CHECK: [0x01,0x81,0xfe,0x7f]

v_log_f16 v5, v255
// CHECK: [0xff,0x81,0x0a,0x7e]

v_log_f16 v5, s1
// CHECK: [0x01,0x80,0x0a,0x7e]

v_log_f16 v5, s101
// CHECK: [0x65,0x80,0x0a,0x7e]

v_log_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x80,0x0a,0x7e]

v_log_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x80,0x0a,0x7e]

v_log_f16 v5, vcc_lo
// CHECK: [0x6a,0x80,0x0a,0x7e]

v_log_f16 v5, vcc_hi
// CHECK: [0x6b,0x80,0x0a,0x7e]

v_log_f16 v5, tba_lo
// CHECK: [0x6c,0x80,0x0a,0x7e]

v_log_f16 v5, tba_hi
// CHECK: [0x6d,0x80,0x0a,0x7e]

v_log_f16 v5, tma_lo
// CHECK: [0x6e,0x80,0x0a,0x7e]

v_log_f16 v5, tma_hi
// CHECK: [0x6f,0x80,0x0a,0x7e]

v_log_f16 v5, ttmp11
// CHECK: [0x7b,0x80,0x0a,0x7e]

v_log_f16 v5, m0
// CHECK: [0x7c,0x80,0x0a,0x7e]

v_log_f16 v5, exec_lo
// CHECK: [0x7e,0x80,0x0a,0x7e]

v_log_f16 v5, exec_hi
// CHECK: [0x7f,0x80,0x0a,0x7e]

v_log_f16 v5, 0
// CHECK: [0x80,0x80,0x0a,0x7e]

v_log_f16 v5, -1
// CHECK: [0xc1,0x80,0x0a,0x7e]

v_log_f16 v5, 0.5
// CHECK: [0xf0,0x80,0x0a,0x7e]

v_log_f16 v5, -4.0
// CHECK: [0xf7,0x80,0x0a,0x7e]

v_log_f16 v5, src_vccz
// CHECK: [0xfb,0x80,0x0a,0x7e]

v_log_f16 v5, src_execz
// CHECK: [0xfc,0x80,0x0a,0x7e]

v_log_f16 v5, src_scc
// CHECK: [0xfd,0x80,0x0a,0x7e]

v_log_f16 v5, src_lds_direct
// CHECK: [0xfe,0x80,0x0a,0x7e]

v_log_f16 v5, 0xfe0b
// CHECK: [0xff,0x80,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_log_f16 v5, 0x3456
// CHECK: [0xff,0x80,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_exp_f16 v5, v1
// CHECK: [0x01,0x83,0x0a,0x7e]

v_exp_f16 v255, v1
// CHECK: [0x01,0x83,0xfe,0x7f]

v_exp_f16 v5, v255
// CHECK: [0xff,0x83,0x0a,0x7e]

v_exp_f16 v5, s1
// CHECK: [0x01,0x82,0x0a,0x7e]

v_exp_f16 v5, s101
// CHECK: [0x65,0x82,0x0a,0x7e]

v_exp_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x82,0x0a,0x7e]

v_exp_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x82,0x0a,0x7e]

v_exp_f16 v5, vcc_lo
// CHECK: [0x6a,0x82,0x0a,0x7e]

v_exp_f16 v5, vcc_hi
// CHECK: [0x6b,0x82,0x0a,0x7e]

v_exp_f16 v5, tba_lo
// CHECK: [0x6c,0x82,0x0a,0x7e]

v_exp_f16 v5, tba_hi
// CHECK: [0x6d,0x82,0x0a,0x7e]

v_exp_f16 v5, tma_lo
// CHECK: [0x6e,0x82,0x0a,0x7e]

v_exp_f16 v5, tma_hi
// CHECK: [0x6f,0x82,0x0a,0x7e]

v_exp_f16 v5, ttmp11
// CHECK: [0x7b,0x82,0x0a,0x7e]

v_exp_f16 v5, m0
// CHECK: [0x7c,0x82,0x0a,0x7e]

v_exp_f16 v5, exec_lo
// CHECK: [0x7e,0x82,0x0a,0x7e]

v_exp_f16 v5, exec_hi
// CHECK: [0x7f,0x82,0x0a,0x7e]

v_exp_f16 v5, 0
// CHECK: [0x80,0x82,0x0a,0x7e]

v_exp_f16 v5, -1
// CHECK: [0xc1,0x82,0x0a,0x7e]

v_exp_f16 v5, 0.5
// CHECK: [0xf0,0x82,0x0a,0x7e]

v_exp_f16 v5, -4.0
// CHECK: [0xf7,0x82,0x0a,0x7e]

v_exp_f16 v5, src_vccz
// CHECK: [0xfb,0x82,0x0a,0x7e]

v_exp_f16 v5, src_execz
// CHECK: [0xfc,0x82,0x0a,0x7e]

v_exp_f16 v5, src_scc
// CHECK: [0xfd,0x82,0x0a,0x7e]

v_exp_f16 v5, src_lds_direct
// CHECK: [0xfe,0x82,0x0a,0x7e]

v_exp_f16 v5, 0xfe0b
// CHECK: [0xff,0x82,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_exp_f16 v5, 0x3456
// CHECK: [0xff,0x82,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_frexp_mant_f16 v5, v1
// CHECK: [0x01,0x85,0x0a,0x7e]

v_frexp_mant_f16 v255, v1
// CHECK: [0x01,0x85,0xfe,0x7f]

v_frexp_mant_f16 v5, v255
// CHECK: [0xff,0x85,0x0a,0x7e]

v_frexp_mant_f16 v5, s1
// CHECK: [0x01,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, s101
// CHECK: [0x65,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, vcc_lo
// CHECK: [0x6a,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, vcc_hi
// CHECK: [0x6b,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, tba_lo
// CHECK: [0x6c,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, tba_hi
// CHECK: [0x6d,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, tma_lo
// CHECK: [0x6e,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, tma_hi
// CHECK: [0x6f,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, ttmp11
// CHECK: [0x7b,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, m0
// CHECK: [0x7c,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, exec_lo
// CHECK: [0x7e,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, exec_hi
// CHECK: [0x7f,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, 0
// CHECK: [0x80,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, -1
// CHECK: [0xc1,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, 0.5
// CHECK: [0xf0,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, -4.0
// CHECK: [0xf7,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, src_vccz
// CHECK: [0xfb,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, src_execz
// CHECK: [0xfc,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, src_scc
// CHECK: [0xfd,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, src_lds_direct
// CHECK: [0xfe,0x84,0x0a,0x7e]

v_frexp_mant_f16 v5, 0xfe0b
// CHECK: [0xff,0x84,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_frexp_mant_f16 v5, 0x3456
// CHECK: [0xff,0x84,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_frexp_exp_i16_f16 v5, v1
// CHECK: [0x01,0x87,0x0a,0x7e]

v_frexp_exp_i16_f16 v255, v1
// CHECK: [0x01,0x87,0xfe,0x7f]

v_frexp_exp_i16_f16 v5, v255
// CHECK: [0xff,0x87,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, s1
// CHECK: [0x01,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, s101
// CHECK: [0x65,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, vcc_lo
// CHECK: [0x6a,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, vcc_hi
// CHECK: [0x6b,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, tba_lo
// CHECK: [0x6c,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, tba_hi
// CHECK: [0x6d,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, tma_lo
// CHECK: [0x6e,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, tma_hi
// CHECK: [0x6f,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, ttmp11
// CHECK: [0x7b,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, m0
// CHECK: [0x7c,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, exec_lo
// CHECK: [0x7e,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, exec_hi
// CHECK: [0x7f,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, 0
// CHECK: [0x80,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, -1
// CHECK: [0xc1,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, 0.5
// CHECK: [0xf0,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, -4.0
// CHECK: [0xf7,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, src_vccz
// CHECK: [0xfb,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, src_execz
// CHECK: [0xfc,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, src_scc
// CHECK: [0xfd,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, src_lds_direct
// CHECK: [0xfe,0x86,0x0a,0x7e]

v_frexp_exp_i16_f16 v5, 0xfe0b
// CHECK: [0xff,0x86,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_frexp_exp_i16_f16 v5, 0x3456
// CHECK: [0xff,0x86,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_floor_f16 v5, v1
// CHECK: [0x01,0x89,0x0a,0x7e]

v_floor_f16 v255, v1
// CHECK: [0x01,0x89,0xfe,0x7f]

v_floor_f16 v5, v255
// CHECK: [0xff,0x89,0x0a,0x7e]

v_floor_f16 v5, s1
// CHECK: [0x01,0x88,0x0a,0x7e]

v_floor_f16 v5, s101
// CHECK: [0x65,0x88,0x0a,0x7e]

v_floor_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x88,0x0a,0x7e]

v_floor_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x88,0x0a,0x7e]

v_floor_f16 v5, vcc_lo
// CHECK: [0x6a,0x88,0x0a,0x7e]

v_floor_f16 v5, vcc_hi
// CHECK: [0x6b,0x88,0x0a,0x7e]

v_floor_f16 v5, tba_lo
// CHECK: [0x6c,0x88,0x0a,0x7e]

v_floor_f16 v5, tba_hi
// CHECK: [0x6d,0x88,0x0a,0x7e]

v_floor_f16 v5, tma_lo
// CHECK: [0x6e,0x88,0x0a,0x7e]

v_floor_f16 v5, tma_hi
// CHECK: [0x6f,0x88,0x0a,0x7e]

v_floor_f16 v5, ttmp11
// CHECK: [0x7b,0x88,0x0a,0x7e]

v_floor_f16 v5, m0
// CHECK: [0x7c,0x88,0x0a,0x7e]

v_floor_f16 v5, exec_lo
// CHECK: [0x7e,0x88,0x0a,0x7e]

v_floor_f16 v5, exec_hi
// CHECK: [0x7f,0x88,0x0a,0x7e]

v_floor_f16 v5, 0
// CHECK: [0x80,0x88,0x0a,0x7e]

v_floor_f16 v5, -1
// CHECK: [0xc1,0x88,0x0a,0x7e]

v_floor_f16 v5, 0.5
// CHECK: [0xf0,0x88,0x0a,0x7e]

v_floor_f16 v5, -4.0
// CHECK: [0xf7,0x88,0x0a,0x7e]

v_floor_f16 v5, src_vccz
// CHECK: [0xfb,0x88,0x0a,0x7e]

v_floor_f16 v5, src_execz
// CHECK: [0xfc,0x88,0x0a,0x7e]

v_floor_f16 v5, src_scc
// CHECK: [0xfd,0x88,0x0a,0x7e]

v_floor_f16 v5, src_lds_direct
// CHECK: [0xfe,0x88,0x0a,0x7e]

v_floor_f16 v5, 0xfe0b
// CHECK: [0xff,0x88,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_floor_f16 v5, 0x3456
// CHECK: [0xff,0x88,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_ceil_f16 v5, v1
// CHECK: [0x01,0x8b,0x0a,0x7e]

v_ceil_f16 v255, v1
// CHECK: [0x01,0x8b,0xfe,0x7f]

v_ceil_f16 v5, v255
// CHECK: [0xff,0x8b,0x0a,0x7e]

v_ceil_f16 v5, s1
// CHECK: [0x01,0x8a,0x0a,0x7e]

v_ceil_f16 v5, s101
// CHECK: [0x65,0x8a,0x0a,0x7e]

v_ceil_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x8a,0x0a,0x7e]

v_ceil_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x8a,0x0a,0x7e]

v_ceil_f16 v5, vcc_lo
// CHECK: [0x6a,0x8a,0x0a,0x7e]

v_ceil_f16 v5, vcc_hi
// CHECK: [0x6b,0x8a,0x0a,0x7e]

v_ceil_f16 v5, tba_lo
// CHECK: [0x6c,0x8a,0x0a,0x7e]

v_ceil_f16 v5, tba_hi
// CHECK: [0x6d,0x8a,0x0a,0x7e]

v_ceil_f16 v5, tma_lo
// CHECK: [0x6e,0x8a,0x0a,0x7e]

v_ceil_f16 v5, tma_hi
// CHECK: [0x6f,0x8a,0x0a,0x7e]

v_ceil_f16 v5, ttmp11
// CHECK: [0x7b,0x8a,0x0a,0x7e]

v_ceil_f16 v5, m0
// CHECK: [0x7c,0x8a,0x0a,0x7e]

v_ceil_f16 v5, exec_lo
// CHECK: [0x7e,0x8a,0x0a,0x7e]

v_ceil_f16 v5, exec_hi
// CHECK: [0x7f,0x8a,0x0a,0x7e]

v_ceil_f16 v5, 0
// CHECK: [0x80,0x8a,0x0a,0x7e]

v_ceil_f16 v5, -1
// CHECK: [0xc1,0x8a,0x0a,0x7e]

v_ceil_f16 v5, 0.5
// CHECK: [0xf0,0x8a,0x0a,0x7e]

v_ceil_f16 v5, -4.0
// CHECK: [0xf7,0x8a,0x0a,0x7e]

v_ceil_f16 v5, src_vccz
// CHECK: [0xfb,0x8a,0x0a,0x7e]

v_ceil_f16 v5, src_execz
// CHECK: [0xfc,0x8a,0x0a,0x7e]

v_ceil_f16 v5, src_scc
// CHECK: [0xfd,0x8a,0x0a,0x7e]

v_ceil_f16 v5, src_lds_direct
// CHECK: [0xfe,0x8a,0x0a,0x7e]

v_ceil_f16 v5, 0xfe0b
// CHECK: [0xff,0x8a,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_ceil_f16 v5, 0x3456
// CHECK: [0xff,0x8a,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_trunc_f16 v5, v1
// CHECK: [0x01,0x8d,0x0a,0x7e]

v_trunc_f16 v255, v1
// CHECK: [0x01,0x8d,0xfe,0x7f]

v_trunc_f16 v5, v255
// CHECK: [0xff,0x8d,0x0a,0x7e]

v_trunc_f16 v5, s1
// CHECK: [0x01,0x8c,0x0a,0x7e]

v_trunc_f16 v5, s101
// CHECK: [0x65,0x8c,0x0a,0x7e]

v_trunc_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x8c,0x0a,0x7e]

v_trunc_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x8c,0x0a,0x7e]

v_trunc_f16 v5, vcc_lo
// CHECK: [0x6a,0x8c,0x0a,0x7e]

v_trunc_f16 v5, vcc_hi
// CHECK: [0x6b,0x8c,0x0a,0x7e]

v_trunc_f16 v5, tba_lo
// CHECK: [0x6c,0x8c,0x0a,0x7e]

v_trunc_f16 v5, tba_hi
// CHECK: [0x6d,0x8c,0x0a,0x7e]

v_trunc_f16 v5, tma_lo
// CHECK: [0x6e,0x8c,0x0a,0x7e]

v_trunc_f16 v5, tma_hi
// CHECK: [0x6f,0x8c,0x0a,0x7e]

v_trunc_f16 v5, ttmp11
// CHECK: [0x7b,0x8c,0x0a,0x7e]

v_trunc_f16 v5, m0
// CHECK: [0x7c,0x8c,0x0a,0x7e]

v_trunc_f16 v5, exec_lo
// CHECK: [0x7e,0x8c,0x0a,0x7e]

v_trunc_f16 v5, exec_hi
// CHECK: [0x7f,0x8c,0x0a,0x7e]

v_trunc_f16 v5, 0
// CHECK: [0x80,0x8c,0x0a,0x7e]

v_trunc_f16 v5, -1
// CHECK: [0xc1,0x8c,0x0a,0x7e]

v_trunc_f16 v5, 0.5
// CHECK: [0xf0,0x8c,0x0a,0x7e]

v_trunc_f16 v5, -4.0
// CHECK: [0xf7,0x8c,0x0a,0x7e]

v_trunc_f16 v5, src_vccz
// CHECK: [0xfb,0x8c,0x0a,0x7e]

v_trunc_f16 v5, src_execz
// CHECK: [0xfc,0x8c,0x0a,0x7e]

v_trunc_f16 v5, src_scc
// CHECK: [0xfd,0x8c,0x0a,0x7e]

v_trunc_f16 v5, src_lds_direct
// CHECK: [0xfe,0x8c,0x0a,0x7e]

v_trunc_f16 v5, 0xfe0b
// CHECK: [0xff,0x8c,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_trunc_f16 v5, 0x3456
// CHECK: [0xff,0x8c,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_rndne_f16 v5, v1
// CHECK: [0x01,0x8f,0x0a,0x7e]

v_rndne_f16 v255, v1
// CHECK: [0x01,0x8f,0xfe,0x7f]

v_rndne_f16 v5, v255
// CHECK: [0xff,0x8f,0x0a,0x7e]

v_rndne_f16 v5, s1
// CHECK: [0x01,0x8e,0x0a,0x7e]

v_rndne_f16 v5, s101
// CHECK: [0x65,0x8e,0x0a,0x7e]

v_rndne_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x8e,0x0a,0x7e]

v_rndne_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x8e,0x0a,0x7e]

v_rndne_f16 v5, vcc_lo
// CHECK: [0x6a,0x8e,0x0a,0x7e]

v_rndne_f16 v5, vcc_hi
// CHECK: [0x6b,0x8e,0x0a,0x7e]

v_rndne_f16 v5, tba_lo
// CHECK: [0x6c,0x8e,0x0a,0x7e]

v_rndne_f16 v5, tba_hi
// CHECK: [0x6d,0x8e,0x0a,0x7e]

v_rndne_f16 v5, tma_lo
// CHECK: [0x6e,0x8e,0x0a,0x7e]

v_rndne_f16 v5, tma_hi
// CHECK: [0x6f,0x8e,0x0a,0x7e]

v_rndne_f16 v5, ttmp11
// CHECK: [0x7b,0x8e,0x0a,0x7e]

v_rndne_f16 v5, m0
// CHECK: [0x7c,0x8e,0x0a,0x7e]

v_rndne_f16 v5, exec_lo
// CHECK: [0x7e,0x8e,0x0a,0x7e]

v_rndne_f16 v5, exec_hi
// CHECK: [0x7f,0x8e,0x0a,0x7e]

v_rndne_f16 v5, 0
// CHECK: [0x80,0x8e,0x0a,0x7e]

v_rndne_f16 v5, -1
// CHECK: [0xc1,0x8e,0x0a,0x7e]

v_rndne_f16 v5, 0.5
// CHECK: [0xf0,0x8e,0x0a,0x7e]

v_rndne_f16 v5, -4.0
// CHECK: [0xf7,0x8e,0x0a,0x7e]

v_rndne_f16 v5, src_vccz
// CHECK: [0xfb,0x8e,0x0a,0x7e]

v_rndne_f16 v5, src_execz
// CHECK: [0xfc,0x8e,0x0a,0x7e]

v_rndne_f16 v5, src_scc
// CHECK: [0xfd,0x8e,0x0a,0x7e]

v_rndne_f16 v5, src_lds_direct
// CHECK: [0xfe,0x8e,0x0a,0x7e]

v_rndne_f16 v5, 0xfe0b
// CHECK: [0xff,0x8e,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_rndne_f16 v5, 0x3456
// CHECK: [0xff,0x8e,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_fract_f16 v5, v1
// CHECK: [0x01,0x91,0x0a,0x7e]

v_fract_f16 v255, v1
// CHECK: [0x01,0x91,0xfe,0x7f]

v_fract_f16 v5, v255
// CHECK: [0xff,0x91,0x0a,0x7e]

v_fract_f16 v5, s1
// CHECK: [0x01,0x90,0x0a,0x7e]

v_fract_f16 v5, s101
// CHECK: [0x65,0x90,0x0a,0x7e]

v_fract_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x90,0x0a,0x7e]

v_fract_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x90,0x0a,0x7e]

v_fract_f16 v5, vcc_lo
// CHECK: [0x6a,0x90,0x0a,0x7e]

v_fract_f16 v5, vcc_hi
// CHECK: [0x6b,0x90,0x0a,0x7e]

v_fract_f16 v5, tba_lo
// CHECK: [0x6c,0x90,0x0a,0x7e]

v_fract_f16 v5, tba_hi
// CHECK: [0x6d,0x90,0x0a,0x7e]

v_fract_f16 v5, tma_lo
// CHECK: [0x6e,0x90,0x0a,0x7e]

v_fract_f16 v5, tma_hi
// CHECK: [0x6f,0x90,0x0a,0x7e]

v_fract_f16 v5, ttmp11
// CHECK: [0x7b,0x90,0x0a,0x7e]

v_fract_f16 v5, m0
// CHECK: [0x7c,0x90,0x0a,0x7e]

v_fract_f16 v5, exec_lo
// CHECK: [0x7e,0x90,0x0a,0x7e]

v_fract_f16 v5, exec_hi
// CHECK: [0x7f,0x90,0x0a,0x7e]

v_fract_f16 v5, 0
// CHECK: [0x80,0x90,0x0a,0x7e]

v_fract_f16 v5, -1
// CHECK: [0xc1,0x90,0x0a,0x7e]

v_fract_f16 v5, 0.5
// CHECK: [0xf0,0x90,0x0a,0x7e]

v_fract_f16 v5, -4.0
// CHECK: [0xf7,0x90,0x0a,0x7e]

v_fract_f16 v5, src_vccz
// CHECK: [0xfb,0x90,0x0a,0x7e]

v_fract_f16 v5, src_execz
// CHECK: [0xfc,0x90,0x0a,0x7e]

v_fract_f16 v5, src_scc
// CHECK: [0xfd,0x90,0x0a,0x7e]

v_fract_f16 v5, src_lds_direct
// CHECK: [0xfe,0x90,0x0a,0x7e]

v_fract_f16 v5, 0xfe0b
// CHECK: [0xff,0x90,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_fract_f16 v5, 0x3456
// CHECK: [0xff,0x90,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_sin_f16 v5, v1
// CHECK: [0x01,0x93,0x0a,0x7e]

v_sin_f16 v255, v1
// CHECK: [0x01,0x93,0xfe,0x7f]

v_sin_f16 v5, v255
// CHECK: [0xff,0x93,0x0a,0x7e]

v_sin_f16 v5, s1
// CHECK: [0x01,0x92,0x0a,0x7e]

v_sin_f16 v5, s101
// CHECK: [0x65,0x92,0x0a,0x7e]

v_sin_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x92,0x0a,0x7e]

v_sin_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x92,0x0a,0x7e]

v_sin_f16 v5, vcc_lo
// CHECK: [0x6a,0x92,0x0a,0x7e]

v_sin_f16 v5, vcc_hi
// CHECK: [0x6b,0x92,0x0a,0x7e]

v_sin_f16 v5, tba_lo
// CHECK: [0x6c,0x92,0x0a,0x7e]

v_sin_f16 v5, tba_hi
// CHECK: [0x6d,0x92,0x0a,0x7e]

v_sin_f16 v5, tma_lo
// CHECK: [0x6e,0x92,0x0a,0x7e]

v_sin_f16 v5, tma_hi
// CHECK: [0x6f,0x92,0x0a,0x7e]

v_sin_f16 v5, ttmp11
// CHECK: [0x7b,0x92,0x0a,0x7e]

v_sin_f16 v5, m0
// CHECK: [0x7c,0x92,0x0a,0x7e]

v_sin_f16 v5, exec_lo
// CHECK: [0x7e,0x92,0x0a,0x7e]

v_sin_f16 v5, exec_hi
// CHECK: [0x7f,0x92,0x0a,0x7e]

v_sin_f16 v5, 0
// CHECK: [0x80,0x92,0x0a,0x7e]

v_sin_f16 v5, -1
// CHECK: [0xc1,0x92,0x0a,0x7e]

v_sin_f16 v5, 0.5
// CHECK: [0xf0,0x92,0x0a,0x7e]

v_sin_f16 v5, -4.0
// CHECK: [0xf7,0x92,0x0a,0x7e]

v_sin_f16 v5, src_vccz
// CHECK: [0xfb,0x92,0x0a,0x7e]

v_sin_f16 v5, src_execz
// CHECK: [0xfc,0x92,0x0a,0x7e]

v_sin_f16 v5, src_scc
// CHECK: [0xfd,0x92,0x0a,0x7e]

v_sin_f16 v5, src_lds_direct
// CHECK: [0xfe,0x92,0x0a,0x7e]

v_sin_f16 v5, 0xfe0b
// CHECK: [0xff,0x92,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_sin_f16 v5, 0x3456
// CHECK: [0xff,0x92,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_cos_f16 v5, v1
// CHECK: [0x01,0x95,0x0a,0x7e]

v_cos_f16 v255, v1
// CHECK: [0x01,0x95,0xfe,0x7f]

v_cos_f16 v5, v255
// CHECK: [0xff,0x95,0x0a,0x7e]

v_cos_f16 v5, s1
// CHECK: [0x01,0x94,0x0a,0x7e]

v_cos_f16 v5, s101
// CHECK: [0x65,0x94,0x0a,0x7e]

v_cos_f16 v5, flat_scratch_lo
// CHECK: [0x66,0x94,0x0a,0x7e]

v_cos_f16 v5, flat_scratch_hi
// CHECK: [0x67,0x94,0x0a,0x7e]

v_cos_f16 v5, vcc_lo
// CHECK: [0x6a,0x94,0x0a,0x7e]

v_cos_f16 v5, vcc_hi
// CHECK: [0x6b,0x94,0x0a,0x7e]

v_cos_f16 v5, tba_lo
// CHECK: [0x6c,0x94,0x0a,0x7e]

v_cos_f16 v5, tba_hi
// CHECK: [0x6d,0x94,0x0a,0x7e]

v_cos_f16 v5, tma_lo
// CHECK: [0x6e,0x94,0x0a,0x7e]

v_cos_f16 v5, tma_hi
// CHECK: [0x6f,0x94,0x0a,0x7e]

v_cos_f16 v5, ttmp11
// CHECK: [0x7b,0x94,0x0a,0x7e]

v_cos_f16 v5, m0
// CHECK: [0x7c,0x94,0x0a,0x7e]

v_cos_f16 v5, exec_lo
// CHECK: [0x7e,0x94,0x0a,0x7e]

v_cos_f16 v5, exec_hi
// CHECK: [0x7f,0x94,0x0a,0x7e]

v_cos_f16 v5, 0
// CHECK: [0x80,0x94,0x0a,0x7e]

v_cos_f16 v5, -1
// CHECK: [0xc1,0x94,0x0a,0x7e]

v_cos_f16 v5, 0.5
// CHECK: [0xf0,0x94,0x0a,0x7e]

v_cos_f16 v5, -4.0
// CHECK: [0xf7,0x94,0x0a,0x7e]

v_cos_f16 v5, src_vccz
// CHECK: [0xfb,0x94,0x0a,0x7e]

v_cos_f16 v5, src_execz
// CHECK: [0xfc,0x94,0x0a,0x7e]

v_cos_f16 v5, src_scc
// CHECK: [0xfd,0x94,0x0a,0x7e]

v_cos_f16 v5, src_lds_direct
// CHECK: [0xfe,0x94,0x0a,0x7e]

v_cos_f16 v5, 0xfe0b
// CHECK: [0xff,0x94,0x0a,0x7e,0x0b,0xfe,0x00,0x00]

v_cos_f16 v5, 0x3456
// CHECK: [0xff,0x94,0x0a,0x7e,0x56,0x34,0x00,0x00]

v_exp_legacy_f32 v5, v1
// CHECK: [0x01,0x97,0x0a,0x7e]

v_exp_legacy_f32 v255, v1
// CHECK: [0x01,0x97,0xfe,0x7f]

v_exp_legacy_f32 v5, v255
// CHECK: [0xff,0x97,0x0a,0x7e]

v_exp_legacy_f32 v5, s1
// CHECK: [0x01,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, s101
// CHECK: [0x65,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, m0
// CHECK: [0x7c,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, 0
// CHECK: [0x80,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, -1
// CHECK: [0xc1,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, src_vccz
// CHECK: [0xfb,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, src_execz
// CHECK: [0xfc,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, src_scc
// CHECK: [0xfd,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, src_lds_direct
// CHECK: [0xfe,0x96,0x0a,0x7e]

v_exp_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x96,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x96,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_legacy_f32 v5, v1
// CHECK: [0x01,0x99,0x0a,0x7e]

v_log_legacy_f32 v255, v1
// CHECK: [0x01,0x99,0xfe,0x7f]

v_log_legacy_f32 v5, v255
// CHECK: [0xff,0x99,0x0a,0x7e]

v_log_legacy_f32 v5, s1
// CHECK: [0x01,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, s101
// CHECK: [0x65,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x66,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x67,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, m0
// CHECK: [0x7c,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, 0
// CHECK: [0x80,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, -1
// CHECK: [0xc1,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, src_vccz
// CHECK: [0xfb,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, src_execz
// CHECK: [0xfc,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, src_scc
// CHECK: [0xfd,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, src_lds_direct
// CHECK: [0xfe,0x98,0x0a,0x7e]

v_log_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x98,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x98,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_mov_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_mov_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_mov_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_mov_b32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_mov_b32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_mov_b32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_mov_b32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_mov_b32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_mov_b32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_i32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_u32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_u32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u32_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_u32_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_i32_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_i32_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f16_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_f16_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f32_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_f32_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_rpi_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_rpi_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_rpi_i32_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_rpi_i32_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_flr_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_flr_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_flr_i32_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_flr_i32_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_off_f32_i4_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte0_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte1_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte2_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte3_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_fract_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_fract_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x36,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_fract_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_fract_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_fract_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_fract_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_fract_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_fract_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_fract_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_fract_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_fract_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x36,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_trunc_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_trunc_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x38,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_trunc_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_trunc_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_trunc_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_trunc_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_trunc_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_trunc_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_trunc_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x38,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ceil_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_ceil_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ceil_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_ceil_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_ceil_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_ceil_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_ceil_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ceil_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_ceil_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3a,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rndne_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rndne_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rndne_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rndne_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rndne_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rndne_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rndne_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rndne_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rndne_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3c,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_floor_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_floor_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x3e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_floor_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_floor_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_floor_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_floor_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_floor_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_floor_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_floor_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_floor_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_floor_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_floor_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x3e,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_exp_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_exp_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_exp_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_exp_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_exp_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_exp_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_log_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_log_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_log_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_log_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_log_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_log_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rcp_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rcp_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rcp_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rcp_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rcp_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_iflag_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_iflag_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_iflag_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rcp_iflag_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rsq_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rsq_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rsq_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rsq_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rsq_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rsq_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rsq_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rsq_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rsq_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sqrt_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sqrt_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sqrt_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_sqrt_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_sqrt_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_sqrt_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_sqrt_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sqrt_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_sqrt_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sin_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sin_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x52,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sin_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sin_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sin_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_sin_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_sin_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_sin_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_sin_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_sin_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sin_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_sin_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x52,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cos_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cos_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cos_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cos_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cos_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cos_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cos_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cos_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cos_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cos_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cos_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cos_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_not_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_not_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_not_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_not_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_not_b32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_not_b32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_not_b32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_not_b32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_not_b32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_not_b32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_bfrev_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x58,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_bfrev_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_bfrev_b32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_bfrev_b32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_bfrev_b32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_bfrev_b32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x58,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbh_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5a,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbh_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_ffbh_u32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_ffbh_u32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_ffbh_u32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_ffbh_u32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x5a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbl_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbl_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_ffbl_b32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_ffbl_b32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_ffbl_b32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_ffbl_b32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbh_i32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x5e,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbh_i32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbh_i32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbh_i32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_ffbh_i32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_ffbh_i32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_ffbh_i32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_ffbh_i32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbh_i32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x5e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_exp_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_exp_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_exp_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_exp_i32_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_frexp_exp_i32_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_mant_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_mant_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_mant_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x68,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_mant_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_mant_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_frexp_mant_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x68,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_u16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_u16_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_u16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_u16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_i16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_i16_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_i16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_i16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_u16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_u16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_u16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_u16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u16_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_u16_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_i16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_i16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x78,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_i16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_i16_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cvt_i16_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x78,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rcp_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rcp_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rcp_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rcp_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rcp_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7a,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sqrt_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sqrt_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sqrt_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sqrt_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sqrt_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sqrt_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_sqrt_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_sqrt_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_sqrt_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_sqrt_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sqrt_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sqrt_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_sqrt_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7c,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rsq_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rsq_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rsq_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x7e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rsq_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rsq_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rsq_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rsq_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rsq_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rsq_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rsq_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rsq_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rsq_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rsq_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x80,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_log_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_log_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_log_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_log_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_log_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_log_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_log_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x82,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_exp_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_exp_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_exp_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_exp_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_exp_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_exp_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x82,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_mant_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_mant_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_mant_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x84,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_mant_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_mant_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_mant_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_frexp_mant_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_frexp_exp_i16_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_frexp_exp_i16_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_frexp_exp_i16_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x86,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_frexp_exp_i16_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_frexp_exp_i16_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_frexp_exp_i16_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_floor_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_floor_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_floor_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_floor_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x88,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_floor_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_floor_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_floor_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_floor_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_floor_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_floor_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_floor_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_floor_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_floor_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_floor_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_floor_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_floor_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_floor_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_floor_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_floor_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ceil_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ceil_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_ceil_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ceil_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ceil_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ceil_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_ceil_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_ceil_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_ceil_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_ceil_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ceil_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ceil_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_ceil_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8a,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_trunc_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_trunc_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_trunc_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_trunc_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_trunc_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_trunc_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_trunc_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_trunc_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_trunc_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_trunc_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_trunc_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_trunc_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_trunc_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8c,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rndne_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rndne_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rndne_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x8e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rndne_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rndne_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rndne_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_rndne_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_rndne_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_rndne_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_rndne_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rndne_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rndne_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_rndne_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x8e,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_fract_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_fract_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_fract_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_fract_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x90,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_fract_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_fract_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_fract_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_fract_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_fract_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_fract_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_fract_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_fract_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_fract_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_fract_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_fract_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_fract_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_fract_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_fract_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sin_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sin_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sin_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sin_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x92,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sin_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sin_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sin_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sin_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sin_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_sin_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_sin_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_sin_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_sin_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_sin_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sin_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sin_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sin_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sin_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_sin_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x92,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cos_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cos_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cos_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cos_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x94,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cos_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cos_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cos_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cos_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cos_f16_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_cos_f16_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_cos_f16_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_cos_f16_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_cos_f16_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_cos_f16_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cos_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cos_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cos_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cos_f16_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_cos_f16_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x94,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_legacy_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_legacy_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_legacy_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x96,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_legacy_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_legacy_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_legacy_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_legacy_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_exp_legacy_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x96,0x0a,0x7e,0x01,0xe4,0x20,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_legacy_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_legacy_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_legacy_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_legacy_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_legacy_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x98,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_legacy_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_legacy_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_legacy_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_legacy_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x42,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x43,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x30,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x34,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x38,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x3c,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_legacy_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_legacy_f32_dpp v5, -v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x10,0x00]

v_log_legacy_f32_dpp v5, |v1| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x98,0x0a,0x7e,0x01,0xe4,0x20,0x00]
