; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512fp16,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512fp16,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK

declare <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half>, metadata)
declare <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half>, metadata)
declare <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half>, metadata)
declare <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half>, metadata)
declare <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half>, metadata)
declare <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half>, metadata)
declare <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half>, metadata)
declare <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half>, metadata)
declare <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half>, metadata)
declare <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half>, metadata)
declare <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half>, metadata)
declare <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half>, metadata)
declare <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half>, metadata)

define <2 x i64> @strict_vector_fptosi_v2f16_to_v2i64(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2qq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i64> @llvm.experimental.constrained.fptosi.v2i64.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i64> %ret
}

define <2 x i64> @strict_vector_fptoui_v2f16_to_v2i64(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uqq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i64> @llvm.experimental.constrained.fptoui.v2i64.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i64> %ret
}

define <2 x i32> @strict_vector_fptosi_v2f16_to_v2i32(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2dq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i32> @llvm.experimental.constrained.fptosi.v2i32.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i32> %ret
}

define <2 x i32> @strict_vector_fptoui_v2f16_to_v2i32(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i32> @llvm.experimental.constrained.fptoui.v2i32.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i32> %ret
}

define <2 x i16> @strict_vector_fptosi_v2f16_to_v2i16(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i16> @llvm.experimental.constrained.fptosi.v2i16.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i16> %ret
}

define <2 x i16> @strict_vector_fptoui_v2f16_to_v2i16(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i16> @llvm.experimental.constrained.fptoui.v2i16.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i16> %ret
}

define <2 x i8> @strict_vector_fptosi_v2f16_to_v2i8(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i8> @llvm.experimental.constrained.fptosi.v2i8.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i8> %ret
}

define <2 x i8> @strict_vector_fptoui_v2f16_to_v2i8(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i8> @llvm.experimental.constrained.fptoui.v2i8.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i8> %ret
}

define <2 x i1> @strict_vector_fptosi_v2f16_to_v2i1(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v2f16_to_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k0
; CHECK-NEXT:    vpmovm2q %k0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i1> @llvm.experimental.constrained.fptosi.v2i1.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i1> %ret
}

define <2 x i1> @strict_vector_fptoui_v2f16_to_v2i1(<2 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v2f16_to_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k0
; CHECK-NEXT:    vpmovm2q %k0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x i1> @llvm.experimental.constrained.fptoui.v2i1.v2f16(<2 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <2 x i1> %ret
}

define <4 x i32> @strict_vector_fptosi_v4f16_to_v4i32(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2dq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i32> @llvm.experimental.constrained.fptosi.v4i32.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i32> @strict_vector_fptoui_v4f16_to_v4i32(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2udq %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i32> @llvm.experimental.constrained.fptoui.v4i32.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i32> %ret
}

define <4 x i16> @strict_vector_fptosi_v4f16_to_v4i16(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i16> @llvm.experimental.constrained.fptosi.v4i16.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i16> @strict_vector_fptoui_v4f16_to_v4i16(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i16> @llvm.experimental.constrained.fptoui.v4i16.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i16> %ret
}

define <4 x i8> @strict_vector_fptosi_v4f16_to_v4i8(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i8> @llvm.experimental.constrained.fptosi.v4i8.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i8> @strict_vector_fptoui_v4f16_to_v4i8(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i8> @llvm.experimental.constrained.fptoui.v4i8.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i8> %ret
}

define <4 x i1> @strict_vector_fptosi_v4f16_to_v4i1(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v4f16_to_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k0
; CHECK-NEXT:    vpmovm2d %k0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i1> @llvm.experimental.constrained.fptosi.v4i1.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <4 x i1> @strict_vector_fptoui_v4f16_to_v4i1(<4 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v4f16_to_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $15, %xmm0, %xmm0
; CHECK-NEXT:    vpmovw2m %xmm0, %k0
; CHECK-NEXT:    vpmovm2d %k0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x i1> @llvm.experimental.constrained.fptoui.v4i1.v4f16(<4 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <4 x i1> %ret
}

define <8 x i16> @strict_vector_fptosi_v8f16_to_v8i16(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i16> @strict_vector_fptoui_v8f16_to_v8i16(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i8> @strict_vector_fptosi_v8f16_to_v8i8(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2w %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i8> @strict_vector_fptoui_v8f16_to_v8i8(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2uw %xmm0, %xmm0
; CHECK-NEXT:    vpmovwb %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i1> @strict_vector_fptosi_v8f16_to_v8i1(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f16_to_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq %xmm0, %ymm0
; CHECK-NEXT:    vpmovd2m %ymm0, %k0
; CHECK-NEXT:    vpmovm2w %k0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

define <8 x i1> @strict_vector_fptoui_v8f16_to_v8i1(<8 x half> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f16_to_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttph2dq %xmm0, %ymm0
; CHECK-NEXT:    vpslld $31, %ymm0, %ymm0
; CHECK-NEXT:    vpmovd2m %ymm0, %k0
; CHECK-NEXT:    vpmovm2w %k0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f16(<8 x half> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

attributes #0 = { strictfp }
