; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ

;
; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
;

define <64 x i8> @abd_ext_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_ext_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_ext_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsb %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %aext = sext <64 x i8> %a to <64 x i64>
  %bext = sext <64 x i8> %b to <64 x i64>
  %sub = sub <64 x i64> %aext, %bext
  %abs = call <64 x i64> @llvm.abs.v64i64(<64 x i64> %sub, i1 false)
  %trunc = trunc <64 x i64> %abs to <64 x i8>
  ret <64 x i8> %trunc
}

define <64 x i8> @abd_ext_v64i8_undef(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_ext_v64i8_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_ext_v64i8_undef:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsb %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %aext = sext <64 x i8> %a to <64 x i64>
  %bext = sext <64 x i8> %b to <64 x i64>
  %sub = sub <64 x i64> %aext, %bext
  %abs = call <64 x i64> @llvm.abs.v64i64(<64 x i64> %sub, i1 true)
  %trunc = trunc <64 x i64> %abs to <64 x i8>
  ret <64 x i8> %trunc
}

define <32 x i16> @abd_ext_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_ext_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_ext_v32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsw %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsw %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubw %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %aext = sext <32 x i16> %a to <32 x i64>
  %bext = sext <32 x i16> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 false)
  %trunc = trunc <32 x i64> %abs to <32 x i16>
  ret <32 x i16> %trunc
}

define <32 x i16> @abd_ext_v32i16_undef(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_ext_v32i16_undef:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_ext_v32i16_undef:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsw %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsw %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubw %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %aext = sext <32 x i16> %a to <32 x i64>
  %bext = sext <32 x i16> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 true)
  %trunc = trunc <32 x i64> %abs to <32 x i16>
  ret <32 x i16> %trunc
}

define <16 x i32> @abd_ext_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_ext_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubd %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = sext <16 x i32> %a to <16 x i64>
  %bext = sext <16 x i32> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 false)
  %trunc = trunc <16 x i64> %abs to <16 x i32>
  ret <16 x i32> %trunc
}

define <16 x i32> @abd_ext_v16i32_undef(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_ext_v16i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubd %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = sext <16 x i32> %a to <16 x i64>
  %bext = sext <16 x i32> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 true)
  %trunc = trunc <16 x i64> %abs to <16 x i32>
  ret <16 x i32> %trunc
}

define <8 x i64> @abd_ext_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_ext_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = sext <8 x i64> %a to <8 x i128>
  %bext = sext <8 x i64> %b to <8 x i128>
  %sub = sub <8 x i128> %aext, %bext
  %abs = call <8 x i128> @llvm.abs.v8i128(<8 x i128> %sub, i1 false)
  %trunc = trunc <8 x i128> %abs to <8 x i64>
  ret <8 x i64> %trunc
}

define <8 x i64> @abd_ext_v8i64_undef(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_ext_v8i64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %aext = sext <8 x i64> %a to <8 x i128>
  %bext = sext <8 x i64> %b to <8 x i128>
  %sub = sub <8 x i128> %aext, %bext
  %abs = call <8 x i128> @llvm.abs.v8i128(<8 x i128> %sub, i1 true)
  %trunc = trunc <8 x i128> %abs to <8 x i64>
  ret <8 x i64> %trunc
}

;
; sub(smax(a,b),smin(a,b)) -> abds(a,b)
;

define <64 x i8> @abd_minmax_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_minmax_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_minmax_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsb %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %min = call <64 x i8> @llvm.smin.v64i8(<64 x i8> %a, <64 x i8> %b)
  %max = call <64 x i8> @llvm.smax.v64i8(<64 x i8> %a, <64 x i8> %b)
  %sub = sub <64 x i8> %max, %min
  ret <64 x i8> %sub
}

define <32 x i16> @abd_minmax_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_minmax_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_minmax_v32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsw %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsw %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubw %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %min = call <32 x i16> @llvm.smin.v32i16(<32 x i16> %a, <32 x i16> %b)
  %max = call <32 x i16> @llvm.smax.v32i16(<32 x i16> %a, <32 x i16> %b)
  %sub = sub <32 x i16> %max, %min
  ret <32 x i16> %sub
}

define <16 x i32> @abd_minmax_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_minmax_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubd %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %min = call <16 x i32> @llvm.smin.v16i32(<16 x i32> %a, <16 x i32> %b)
  %max = call <16 x i32> @llvm.smax.v16i32(<16 x i32> %a, <16 x i32> %b)
  %sub = sub <16 x i32> %max, %min
  ret <16 x i32> %sub
}

define <8 x i64> @abd_minmax_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_minmax_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %min = call <8 x i64> @llvm.smin.v8i64(<8 x i64> %a, <8 x i64> %b)
  %max = call <8 x i64> @llvm.smax.v8i64(<8 x i64> %a, <8 x i64> %b)
  %sub = sub <8 x i64> %max, %min
  ret <8 x i64> %sub
}

;
; select(icmp(a,b),sub(a,b),sub(b,a)) -> abds(a,b)
;

define <64 x i8> @abd_cmp_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_cmp_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsb %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_cmp_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsb %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubb %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %cmp = icmp sgt <64 x i8> %a, %b
  %ab = sub <64 x i8> %a, %b
  %ba = sub <64 x i8> %b, %a
  %sel = select <64 x i1> %cmp, <64 x i8> %ab, <64 x i8> %ba
  ret <64 x i8> %sel
}

define <32 x i16> @abd_cmp_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_cmp_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpminsw %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_cmp_v32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpminsw %ymm2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpmaxsw %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubw %ymm4, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512DQ-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %cmp = icmp sge <32 x i16> %a, %b
  %ab = sub <32 x i16> %a, %b
  %ba = sub <32 x i16> %b, %a
  %sel = select <32 x i1> %cmp, <32 x i16> %ab, <32 x i16> %ba
  ret <32 x i16> %sel
}

define <16 x i32> @abd_cmp_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_cmp_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubd %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %cmp = icmp slt <16 x i32> %a, %b
  %ab = sub <16 x i32> %a, %b
  %ba = sub <16 x i32> %b, %a
  %sel = select <16 x i1> %cmp, <16 x i32> %ba, <16 x i32> %ab
  ret <16 x i32> %sel
}

define <8 x i64> @abd_cmp_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_cmp_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %cmp = icmp sge <8 x i64> %a, %b
  %ab = sub <8 x i64> %a, %b
  %ba = sub <8 x i64> %b, %a
  %sel = select <8 x i1> %cmp, <8 x i64> %ab, <8 x i64> %ba
  ret <8 x i64> %sel
}

;
; abs(sub_nsw(x, y)) -> abds(a,b)
;

define <64 x i8> @abd_subnsw_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512BW-LABEL: abd_subnsw_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsubb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpabsb %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_subnsw_v64i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpsubb %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpabsb %ymm0, %ymm0
; AVX512DQ-NEXT:    vpabsb %ymm2, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %sub = sub nsw <64 x i8> %a, %b
  %abs = call <64 x i8> @llvm.abs.v64i8(<64 x i8> %sub, i1 false)
  ret <64 x i8> %abs
}

define <32 x i16> @abd_subnsw_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512BW-LABEL: abd_subnsw_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsubw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpabsw %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: abd_subnsw_v32i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512DQ-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512DQ-NEXT:    vpsubw %ymm2, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpabsw %ymm0, %ymm0
; AVX512DQ-NEXT:    vpabsw %ymm2, %ymm1
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    retq
  %sub = sub nsw <32 x i16> %a, %b
  %abs = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %sub, i1 false)
  ret <32 x i16> %abs
}

define <16 x i32> @abd_subnsw_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; AVX512-LABEL: abd_subnsw_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsd %zmm0, %zmm0
; AVX512-NEXT:    retq
  %sub = sub nsw <16 x i32> %a, %b
  %abs = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %sub, i1 false)
  ret <16 x i32> %abs
}

define <8 x i64> @abd_subnsw_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; AVX512-LABEL: abd_subnsw_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    retq
  %sub = sub nsw <8 x i64> %a, %b
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 false)
  ret <8 x i64> %abs
}

declare <64 x i8> @llvm.abs.v64i8(<64 x i8>, i1)
declare <32 x i16> @llvm.abs.v32i16(<32 x i16>, i1)
declare <16 x i32> @llvm.abs.v16i32(<16 x i32>, i1)
declare <8 x i64> @llvm.abs.v8i64(<8 x i64>, i1)
declare <16 x i64> @llvm.abs.v16i64(<16 x i64>, i1)
declare <32 x i64> @llvm.abs.v32i64(<32 x i64>, i1)
declare <64 x i64> @llvm.abs.v64i64(<64 x i64>, i1)
declare <8 x i128> @llvm.abs.v8i128(<8 x i128>, i1)

declare <64 x i8> @llvm.smax.v64i8(<64 x i8>, <64 x i8>)
declare <32 x i16> @llvm.smax.v32i16(<32 x i16>, <32 x i16>)
declare <16 x i32> @llvm.smax.v16i32(<16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.smax.v8i64(<8 x i64>, <8 x i64>)

declare <64 x i8> @llvm.smin.v64i8(<64 x i8>, <64 x i8>)
declare <32 x i16> @llvm.smin.v32i16(<32 x i16>, <32 x i16>)
declare <16 x i32> @llvm.smin.v16i32(<16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.smin.v8i64(<8 x i64>, <8 x i64>)
