; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve -mattr=+vpu | FileCheck %s


; <256 x float>

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_false_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_false_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp false <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_false_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_false_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp false <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_false_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_false_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp false <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oeq_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_oeq_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp oeq <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oeq_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_oeq_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp oeq <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oeq_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_oeq_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.eq %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp oeq <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ogt_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ogt_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ogt <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ogt_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ogt_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ogt <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ogt_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ogt_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.gt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ogt <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oge_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_oge_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp oge <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oge_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_oge_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp oge <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_oge_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_oge_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ge %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp oge <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_olt_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_olt_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp olt <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_olt_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_olt_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp olt <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_olt_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_olt_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.lt %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp olt <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ole_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ole_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ole <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ole_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ole_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ole <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ole_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ole_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.le %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ole <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_one_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_one_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp one <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_one_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_one_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp one <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_one_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_one_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ne %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp one <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ord_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ord_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.num %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ord <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ord_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ord_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.num %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ord <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ord_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ord_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.num %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ord <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uno_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_uno_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.nan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp uno <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uno_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_uno_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.nan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp uno <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uno_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_uno_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.nan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp uno <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ueq_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ueq_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.eqnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ueq <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ueq_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ueq_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.eqnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ueq <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ueq_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ueq_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.eqnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ueq <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ugt_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ugt_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.gtnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ugt <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ugt_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ugt_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.gtnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ugt <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ugt_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ugt_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.gtnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ugt <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uge_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_uge_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.genan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp uge <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uge_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_uge_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.genan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp uge <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_uge_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_uge_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.genan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp uge <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ult_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ult_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ltnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ult <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ult_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ult_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.ltnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ult <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ult_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ult_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.ltnan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ult <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ule_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ule_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.lenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp ule <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ule_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_ule_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.lenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ule <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_ule_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_ule_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.lenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp ule <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_une_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_une_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s0, 256
; CHECK-NEXT:    lvl %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.nenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp une <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_une_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_une_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v1, %v0
; CHECK-NEXT:    vfmk.s.nenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp une <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_une_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_une_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v1, %s0
; CHECK-NEXT:    vfcmp.s %v0, %v0, %v1
; CHECK-NEXT:    vfmk.s.nenan %vm1, %v0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp une <256 x float> %x, %vy
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_true_vv_v256f32(<256 x float> %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_true_vv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %z = fcmp true <256 x float> %x, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_true_sv_v256f32(float %x, <256 x float> %y) {
; CHECK-LABEL: fcmp_true_sv_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %xins = insertelement <256 x float> undef, float %x, i32 0
  %vx = shufflevector <256 x float> %xins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp true <256 x float> %vx, %y
  ret <256 x i1> %z
}

; Function Attrs: nounwind
define fastcc <256 x i1> @fcmp_true_vs_v256f32(<256 x float> %x, float %y) {
; CHECK-LABEL: fcmp_true_vs_v256f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andm %vm1, %vm0, %vm0
; CHECK-NEXT:    b.l.t (, %s10)
  %yins = insertelement <256 x float> undef, float %y, i32 0
  %vy = shufflevector <256 x float> %yins, <256 x float> undef, <256 x i32> zeroinitializer
  %z = fcmp true <256 x float> %x, %vy
  ret <256 x i1> %z
}
