; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -relocation-model=pic -mtriple=sparc | FileCheck --check-prefix=SPARC %s
; RUN: llc < %s -relocation-model=pic -mtriple=sparcv9 | FileCheck --check-prefix=SPARC64 %s

;; SPARC32 and SPARC64 for classic UltraSPARCs implement GETPCX
;; with a fake `call`.
;; All other SPARC64 targets implement it with `rd %pc, %o7`.
;; Need to do the tests in separate files because apparently `tune-cpu`
;; attribute applies to the entire file at once.

@value = external global i32

define i32 @testCall() nounwind #0 {
; SPARC-LABEL: testCall:
; SPARC:       ! %bb.0:
; SPARC-NEXT:    save %sp, -96, %sp
; SPARC-NEXT:  .Ltmp0:
; SPARC-NEXT:    call .Ltmp1
; SPARC-NEXT:  .Ltmp2:
; SPARC-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp2-.Ltmp0)), %i0
; SPARC-NEXT:  .Ltmp1:
; SPARC-NEXT:    or %i0, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp1-.Ltmp0)), %i0
; SPARC-NEXT:    add %i0, %o7, %i0
; SPARC-NEXT:    sethi %hi(value), %i1
; SPARC-NEXT:    add %i1, %lo(value), %i1
; SPARC-NEXT:    ld [%i0+%i1], %i0
; SPARC-NEXT:    ld [%i0], %i0
; SPARC-NEXT:    ret
; SPARC-NEXT:    restore
;
; SPARC64-LABEL: testCall:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -128, %sp
; SPARC64-NEXT:  .Ltmp0:
; SPARC64-NEXT:    call .Ltmp1
; SPARC64-NEXT:  .Ltmp2:
; SPARC64-NEXT:    sethi %hi(_GLOBAL_OFFSET_TABLE_+(.Ltmp2-.Ltmp0)), %i0
; SPARC64-NEXT:  .Ltmp1:
; SPARC64-NEXT:    or %i0, %lo(_GLOBAL_OFFSET_TABLE_+(.Ltmp1-.Ltmp0)), %i0
; SPARC64-NEXT:    add %i0, %o7, %i0
; SPARC64-NEXT:    sethi %hi(value), %i1
; SPARC64-NEXT:    add %i1, %lo(value), %i1
; SPARC64-NEXT:    ldx [%i0+%i1], %i0
; SPARC64-NEXT:    ld [%i0], %i0
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
  %1 = load i32, ptr @value
  ret i32 %1
}

attributes #0 = { "tune-cpu"="ultrasparc" }
