; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+m -O2 < %s | FileCheck %s --check-prefix=CHECK-O2
; RUN: llc -mtriple=riscv64 -mattr=+m -O3 < %s | FileCheck %s --check-prefix=CHECK-O3

; RUN: llc -mtriple=riscv64 -mattr=+m -tail-dup-size=2 < %s | FileCheck %s --check-prefix=CHECK-O2
; RUN: llc -mtriple=riscv64 -mattr=+m -tail-dup-placement-threshold=2 < %s | FileCheck %s --check-prefix=CHECK-O2
; RUN: llc -mtriple=riscv64 -mattr=+m -tail-dup-placement-threshold=6 < %s | FileCheck %s --check-prefix=CHECK-O3

@a = external global i32
@b = external global i32
@c = external global i32

declare i32 @foo(i32)

define i32 @test(i32 %n) {
; CHECK-O2-LABEL: test:
; CHECK-O2:       # %bb.0: # %entry
; CHECK-O2-NEXT:    sext.w a1, a0
; CHECK-O2-NEXT:    blez a1, .LBB0_2
; CHECK-O2-NEXT:  # %bb.1: # %if.then
; CHECK-O2-NEXT:    lui a1, %hi(a)
; CHECK-O2-NEXT:    lw a1, %lo(a)(a1)
; CHECK-O2-NEXT:    mul a0, a1, a0
; CHECK-O2-NEXT:    j .LBB0_3
; CHECK-O2-NEXT:  .LBB0_2: # %if.else
; CHECK-O2-NEXT:    lui a1, %hi(b)
; CHECK-O2-NEXT:    lw a1, %lo(b)(a1)
; CHECK-O2-NEXT:    divw a0, a1, a0
; CHECK-O2-NEXT:  .LBB0_3: # %if.end
; CHECK-O2-NEXT:    lui a1, %hi(c)
; CHECK-O2-NEXT:    lw a1, %lo(c)(a1)
; CHECK-O2-NEXT:    addi a0, a0, -1
; CHECK-O2-NEXT:    mulw a0, a0, a1
; CHECK-O2-NEXT:    tail foo
;
; CHECK-O3-LABEL: test:
; CHECK-O3:       # %bb.0: # %entry
; CHECK-O3-NEXT:    sext.w a1, a0
; CHECK-O3-NEXT:    blez a1, .LBB0_2
; CHECK-O3-NEXT:  # %bb.1: # %if.then
; CHECK-O3-NEXT:    lui a1, %hi(a)
; CHECK-O3-NEXT:    lw a1, %lo(a)(a1)
; CHECK-O3-NEXT:    mul a0, a1, a0
; CHECK-O3-NEXT:    lui a1, %hi(c)
; CHECK-O3-NEXT:    lw a1, %lo(c)(a1)
; CHECK-O3-NEXT:    addi a0, a0, -1
; CHECK-O3-NEXT:    mulw a0, a0, a1
; CHECK-O3-NEXT:    tail foo
; CHECK-O3-NEXT:  .LBB0_2: # %if.else
; CHECK-O3-NEXT:    lui a1, %hi(b)
; CHECK-O3-NEXT:    lw a1, %lo(b)(a1)
; CHECK-O3-NEXT:    divw a0, a1, a0
; CHECK-O3-NEXT:    lui a1, %hi(c)
; CHECK-O3-NEXT:    lw a1, %lo(c)(a1)
; CHECK-O3-NEXT:    addi a0, a0, -1
; CHECK-O3-NEXT:    mulw a0, a0, a1
; CHECK-O3-NEXT:    tail foo
entry:
  %cmp = icmp sgt i32 %n, 0
  br i1 %cmp, label %if.then, label %if.else

if.then:
  %va = load i32, ptr @a
  %mul = mul nsw i32 %va, %n
  br label %if.end

if.else:
  %vb = load i32, ptr @b
  %div = sdiv i32 %vb, %n
  br label %if.end

if.end:
  %phi = phi i32 [ %mul, %if.then ], [ %div, %if.else ]
  %vc = load i32, ptr @c
  %add = add nsw i32 %phi, -1
  %arg = mul i32 %add, %vc
  %ret = tail call i32 @foo(i32 %arg)
  ret i32 %ret
}
