; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr -verify-machineinstrs \
; RUN:     -mtriple=powerpc64-- -mcpu=pwr7 < %s | FileCheck \
; RUN:     --check-prefix=PWR7-BE %s
; RUN: llc -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr -verify-machineinstrs \
; RUN:     -mtriple=powerpc64-- -mcpu=pwr8 < %s | FileCheck \
; RUN:     --check-prefix=PWR8-BE %s
; RUN: llc -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr -verify-machineinstrs \
; RUN:     -mtriple=powerpc64le-- -mcpu=pwr8 < %s | FileCheck \
; RUN:     --check-prefix=PWR8-LE %s

define  <16 x i8> @i8(ptr nocapture noundef readonly %p) {
; PWR7-BE-LABEL: i8:
; PWR7-BE:       # %bb.0: # %entry
; PWR7-BE-NEXT:    lxvw4x v3, 0, r3
; PWR7-BE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; PWR7-BE-NEXT:    vspltisb v2, 10
; PWR7-BE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; PWR7-BE-NEXT:    lxvw4x v4, 0, r3
; PWR7-BE-NEXT:    vperm v2, v3, v2, v4
; PWR7-BE-NEXT:    blr
;
; PWR8-BE-LABEL: i8:
; PWR8-BE:       # %bb.0: # %entry
; PWR8-BE-NEXT:    lxvw4x v2, 0, r3
; PWR8-BE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; PWR8-BE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; PWR8-BE-NEXT:    lxvw4x v3, 0, r3
; PWR8-BE-NEXT:    li r3, 10
; PWR8-BE-NEXT:    mtvsrwz v4, r3
; PWR8-BE-NEXT:    vperm v2, v2, v4, v3
; PWR8-BE-NEXT:    blr
;
; PWR8-LE-LABEL: i8:
; PWR8-LE:       # %bb.0: # %entry
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    addis r3, r2, .LCPI0_0@toc@ha
; PWR8-LE-NEXT:    addi r3, r3, .LCPI0_0@toc@l
; PWR8-LE-NEXT:    xxswapd v2, vs0
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    li r3, 10
; PWR8-LE-NEXT:    mtvsrd v4, r3
; PWR8-LE-NEXT:    xxswapd v3, vs0
; PWR8-LE-NEXT:    vperm v2, v4, v2, v3
; PWR8-LE-NEXT:    blr
entry:
  %0 = load <16 x i8>, ptr %p, align 16
  %vecinit1 = insertelement <16 x i8> %0, i8 10, i64 1
  ret <16 x i8> %vecinit1
}

define  <8 x i16> @i16(ptr nocapture noundef readonly %p) {
; PWR7-BE-LABEL: i16:
; PWR7-BE:       # %bb.0: # %entry
; PWR7-BE-NEXT:    lxvw4x v3, 0, r3
; PWR7-BE-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; PWR7-BE-NEXT:    vspltish v2, 9
; PWR7-BE-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; PWR7-BE-NEXT:    lxvw4x v4, 0, r3
; PWR7-BE-NEXT:    vperm v2, v3, v2, v4
; PWR7-BE-NEXT:    blr
;
; PWR8-BE-LABEL: i16:
; PWR8-BE:       # %bb.0: # %entry
; PWR8-BE-NEXT:    lxvw4x v2, 0, r3
; PWR8-BE-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; PWR8-BE-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; PWR8-BE-NEXT:    lxvw4x v3, 0, r3
; PWR8-BE-NEXT:    li r3, 9
; PWR8-BE-NEXT:    mtvsrwz v4, r3
; PWR8-BE-NEXT:    vperm v2, v2, v4, v3
; PWR8-BE-NEXT:    blr
;
; PWR8-LE-LABEL: i16:
; PWR8-LE:       # %bb.0: # %entry
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; PWR8-LE-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; PWR8-LE-NEXT:    xxswapd v2, vs0
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    li r3, 9
; PWR8-LE-NEXT:    mtvsrd v4, r3
; PWR8-LE-NEXT:    xxswapd v3, vs0
; PWR8-LE-NEXT:    vperm v2, v4, v2, v3
; PWR8-LE-NEXT:    blr
entry:
  %0 = load <8 x i16>, ptr %p, align 16
  %vecinit1 = insertelement <8 x i16> %0, i16 9, i64 1
  ret <8 x i16> %vecinit1
}

define  <4 x i32> @i32(ptr nocapture noundef readonly %p) {
; PWR7-BE-LABEL: i32:
; PWR7-BE:       # %bb.0: # %entry
; PWR7-BE-NEXT:    lxvw4x v3, 0, r3
; PWR7-BE-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR7-BE-NEXT:    vspltisw v2, 7
; PWR7-BE-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR7-BE-NEXT:    lxvw4x v4, 0, r3
; PWR7-BE-NEXT:    vperm v2, v3, v2, v4
; PWR7-BE-NEXT:    blr
;
; PWR8-BE-LABEL: i32:
; PWR8-BE:       # %bb.0: # %entry
; PWR8-BE-NEXT:    lxvw4x v2, 0, r3
; PWR8-BE-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR8-BE-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR8-BE-NEXT:    lxvw4x v3, 0, r3
; PWR8-BE-NEXT:    li r3, 7
; PWR8-BE-NEXT:    mtvsrwz v4, r3
; PWR8-BE-NEXT:    vperm v2, v2, v4, v3
; PWR8-BE-NEXT:    blr
;
; PWR8-LE-LABEL: i32:
; PWR8-LE:       # %bb.0: # %entry
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    addis r3, r2, .LCPI2_0@toc@ha
; PWR8-LE-NEXT:    addi r3, r3, .LCPI2_0@toc@l
; PWR8-LE-NEXT:    xxswapd v2, vs0
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    li r3, 7
; PWR8-LE-NEXT:    mtvsrwz v4, r3
; PWR8-LE-NEXT:    xxswapd v3, vs0
; PWR8-LE-NEXT:    vperm v2, v4, v2, v3
; PWR8-LE-NEXT:    blr
entry:
  %0 = load <4 x i32>, ptr %p, align 16
  %vecinit1 = insertelement <4 x i32> %0, i32 7, i64 1
  ret <4 x i32> %vecinit1
}

define  <2 x i64> @i64(ptr nocapture noundef readonly %p) {
; PWR7-BE-LABEL: i64:
; PWR7-BE:       # %bb.0: # %entry
; PWR7-BE-NEXT:    lxvd2x v2, 0, r3
; PWR7-BE-NEXT:    li r3, 10
; PWR7-BE-NEXT:    std r3, -16(r1)
; PWR7-BE-NEXT:    std r3, -8(r1)
; PWR7-BE-NEXT:    addi r3, r1, -16
; PWR7-BE-NEXT:    lxvd2x v3, 0, r3
; PWR7-BE-NEXT:    xxmrghd v2, v2, v3
; PWR7-BE-NEXT:    blr
;
; PWR8-BE-LABEL: i64:
; PWR8-BE:       # %bb.0: # %entry
; PWR8-BE-NEXT:    lxvd2x v2, 0, r3
; PWR8-BE-NEXT:    li r3, 10
; PWR8-BE-NEXT:    mtfprd f0, r3
; PWR8-BE-NEXT:    xxmrghd v2, v2, vs0
; PWR8-BE-NEXT:    blr
;
; PWR8-LE-LABEL: i64:
; PWR8-LE:       # %bb.0: # %entry
; PWR8-LE-NEXT:    lxvd2x vs0, 0, r3
; PWR8-LE-NEXT:    li r3, 10
; PWR8-LE-NEXT:    xxswapd v2, vs0
; PWR8-LE-NEXT:    mtfprd f0, r3
; PWR8-LE-NEXT:    xxpermdi v2, vs0, v2, 1
; PWR8-LE-NEXT:    blr
entry:
  %0 = load <2 x i64>, ptr %p, align 16
  %vecinit1 = insertelement <2 x i64> %0, i64 10, i64 1
  ret <2 x i64> %vecinit1
}
