; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch32 < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 < %s | FileCheck %s --check-prefix=LA64

declare void @llvm.prefetch(ptr, i32, i32, i32)

define void @load_prefetch_no_offset(ptr %a) {
; LA32-LABEL: load_prefetch_no_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    preld 0, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: load_prefetch_no_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    preld 0, $a0, 0
; LA64-NEXT:    ret
entry:
  call void @llvm.prefetch(ptr %a, i32 0, i32 3, i32 1)
  ret void
}

define void @store_prefetch_no_offset(ptr %a) {
; LA32-LABEL: store_prefetch_no_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    preld 8, $a0, 0
; LA32-NEXT:    ret
;
; LA64-LABEL: store_prefetch_no_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    preld 8, $a0, 0
; LA64-NEXT:    ret
entry:
  call void @llvm.prefetch(ptr %a, i32 1, i32 3, i32 1)
  ret void
}

define void @load_prefetch_with_offset(ptr %a) {
; LA32-LABEL: load_prefetch_with_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    preld 0, $a0, 200
; LA32-NEXT:    ret
;
; LA64-LABEL: load_prefetch_with_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    preld 0, $a0, 200
; LA64-NEXT:    ret
entry:
  %addr = getelementptr i8, ptr %a, i64 200
  call void @llvm.prefetch(ptr %addr, i32 0, i32 3, i32 1)
  ret void
}

define void @store_prefetch_with_offset(ptr %a) {
; LA32-LABEL: store_prefetch_with_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    preld 8, $a0, 200
; LA32-NEXT:    ret
;
; LA64-LABEL: store_prefetch_with_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    preld 8, $a0, 200
; LA64-NEXT:    ret
entry:
  %addr = getelementptr i8, ptr %a, i64 200
  call void @llvm.prefetch(ptr %addr, i32 1, i32 3, i32 1)
  ret void
}
