; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lasx < %s | FileCheck %s

;; fsqrt
define void @sqrt_v8f32(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: sqrt_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld $xr0, $a1, 0
; CHECK-NEXT:    xvfsqrt.s $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x float>, ptr %a0, align 16
  %sqrt = call <8 x float> @llvm.sqrt.v8f32 (<8 x float> %v0)
  store <8 x float> %sqrt, ptr %res, align 16
  ret void
}

define void @sqrt_v4f64(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: sqrt_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld $xr0, $a1, 0
; CHECK-NEXT:    xvfsqrt.d $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0, align 16
  %sqrt = call <4 x double> @llvm.sqrt.v4f64 (<4 x double> %v0)
  store <4 x double> %sqrt, ptr %res, align 16
  ret void
}

;; 1.0 / (fsqrt vec)
define void @one_div_sqrt_v8f32(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_div_sqrt_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld $xr0, $a1, 0
; CHECK-NEXT:    xvfrsqrt.s $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <8 x float>, ptr %a0, align 16
  %sqrt = call <8 x float> @llvm.sqrt.v8f32 (<8 x float> %v0)
  %div = fdiv <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, %sqrt
  store <8 x float> %div, ptr %res, align 16
  ret void
}

define void @one_div_sqrt_v4f64(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_div_sqrt_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvld $xr0, $a1, 0
; CHECK-NEXT:    xvfrsqrt.d $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0, align 16
  %sqrt = call <4 x double> @llvm.sqrt.v4f64 (<4 x double> %v0)
  %div = fdiv <4 x double> <double 1.0, double 1.0, double 1.0, double 1.0>, %sqrt
  store <4 x double> %div, ptr %res, align 16
  ret void
}

declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)
