; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d --filetype=obj --verify-machineinstrs < %s \
; RUN:   -o /dev/null 2>&1
; RUN: llc --mtriple=loongarch64 -mattr=+d --filetype=obj --verify-machineinstrs < %s \
; RUN:   -o /dev/null 2>&1
; RUN: llc --mtriple=loongarch32 -mattr=+d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 -mattr=+d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64

define i32 @relax_b18(i32 signext %a, i32 signext %b) {
; LA32-LABEL: relax_b18:
; LA32:       # %bb.0:
; LA32-NEXT:    beq $a0, $a1, .LBB0_1
; LA32-NEXT:    b .LBB0_2
; LA32-NEXT:  .LBB0_1: # %iftrue
; LA32-NEXT:    ori $a0, $zero, 1
; LA32-NEXT:    #APP
; LA32-NEXT:    .space 1048576
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB0_2: # %iffalse
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: relax_b18:
; LA64:       # %bb.0:
; LA64-NEXT:    beq $a0, $a1, .LBB0_1
; LA64-NEXT:    b .LBB0_2
; LA64-NEXT:  .LBB0_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 1048576
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB0_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
  %cond = icmp eq i32 %a, %b
  br i1 %cond, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 1048576", ""()
  ret i32 1

iffalse:
  ret i32 0
}

define i32 @relax_b23(i1 %a) {
; LA32-LABEL: relax_b23:
; LA32:       # %bb.0:
; LA32-NEXT:    andi $a0, $a0, 1
; LA32-NEXT:    bnez $a0, .LBB1_1
; LA32-NEXT:    b .LBB1_2
; LA32-NEXT:  .LBB1_1: # %iftrue
; LA32-NEXT:    ori $a0, $zero, 1
; LA32-NEXT:    #APP
; LA32-NEXT:    .space 16777216
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB1_2: # %iffalse
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: relax_b23:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    bnez $a0, .LBB1_1
; LA64-NEXT:    b .LBB1_2
; LA64-NEXT:  .LBB1_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 16777216
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB1_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
  br i1 %a, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 16777216", ""()
  ret i32 1

iffalse:
  ret i32 0
}

define i32 @relax_b28(i1 %a) {
; LA32-LABEL: relax_b28:
; LA32:       # %bb.0:
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    .cfi_def_cfa_offset 16
; LA32-NEXT:    andi $a0, $a0, 1
; LA32-NEXT:    bnez $a0, .LBB2_1
; LA32-NEXT:  # %bb.3:
; LA32-NEXT:    pcalau12i $a0, %pc_hi20(.LBB2_2)
; LA32-NEXT:    addi.w $a0, $a0, %pc_lo12(.LBB2_2)
; LA32-NEXT:    jr $a0
; LA32-NEXT:  .LBB2_1: # %iftrue
; LA32-NEXT:    ori $a0, $zero, 1
; LA32-NEXT:    #APP
; LA32-NEXT:    .space 536870912
; LA32-NEXT:    #NO_APP
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB2_2: # %iffalse
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: relax_b28:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    .cfi_def_cfa_offset 16
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    bnez $a0, .LBB2_1
; LA64-NEXT:  # %bb.3:
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(.LBB2_2)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(.LBB2_2)
; LA64-NEXT:    jr $a0
; LA64-NEXT:  .LBB2_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 536870912
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB2_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  br i1 %a, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 536870912", ""()
  ret i32 1

iffalse:
  ret i32 0
}
