; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -dxil-intrinsic-expansion -scalarizer -mtriple=dxil-pc-shadermodel6.3-library %s | FileCheck %s

declare half @llvm.dx.radians.f16(half)
declare float @llvm.dx.radians.f32(float)

declare <4 x half> @llvm.dx.radians.v4f16(<4 x half>)
declare <4 x float> @llvm.dx.radians.v4f32(<4 x float>)

define noundef half @radians_half(half noundef %a) {
; CHECK-LABEL: define noundef half @radians_half(
; CHECK-SAME: half noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fmul half [[A]], 0xH2478
; CHECK-NEXT:    ret half [[TMP0]]
;
entry:
  %elt.radians = call half @llvm.dx.radians.f16(half %a)
  ret half %elt.radians
}

define noundef float @radians_float(float noundef %a) {
; CHECK-LABEL: define noundef float @radians_float(
; CHECK-SAME: float noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = fmul float [[A]], 0x3F91DF46A0000000
; CHECK-NEXT:    ret float [[TMP0]]
;
entry:
  %elt.radians = call float @llvm.dx.radians.f32(float %a)
  ret float %elt.radians
}

define noundef <4 x half> @radians_half_vector(<4 x half> noundef %a) {
; CHECK-LABEL: define noundef <4 x half> @radians_half_vector(
; CHECK-SAME: <4 x half> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK: [[ee0:%.*]] = extractelement <4 x half> [[A]], i64 0
; CHECK: [[ie0:%.*]] = fmul half [[ee0]], 0xH2478
; CHECK: [[ee1:%.*]] = extractelement <4 x half> [[A]], i64 1
; CHECK: [[ie1:%.*]] = fmul half [[ee1]], 0xH2478
; CHECK: [[ee2:%.*]] = extractelement <4 x half> [[A]], i64 2
; CHECK: [[ie2:%.*]] = fmul half [[ee2]], 0xH2478
; CHECK: [[ee3:%.*]] = extractelement <4 x half> [[A]], i64 3
; CHECK: [[ie3:%.*]] = fmul half [[ee3]], 0xH2478
; CHECK: [[TMP0:%.*]] = insertelement <4 x half> poison, half [[ie0]], i64 0
; CHECK: [[TMP1:%.*]] = insertelement <4 x half> [[TMP0]], half [[ie1]], i64 1
; CHECK: [[TMP2:%.*]] = insertelement <4 x half> [[TMP1]], half [[ie2]], i64 2
; CHECK: [[TMP3:%.*]] = insertelement <4 x half> [[TMP2]], half [[ie3]], i64 3
; CHECK: ret <4 x half> [[TMP3]]
;
entry:
  %elt.radians = call <4 x half> @llvm.dx.radians.v4f16(<4 x half> %a)
  ret <4 x half> %elt.radians
}

define noundef <4 x float> @radians_float_vector(<4 x float> noundef %a) {
; CHECK-LABEL: define noundef <4 x float> @radians_float_vector(
; CHECK-SAME: <4 x float> noundef [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK: [[ee0:%.*]] = extractelement <4 x float> [[A]], i64 0
; CHECK: [[ie0:%.*]] = fmul float [[ee0]], 0x3F91DF46A0000000
; CHECK: [[ee1:%.*]] = extractelement <4 x float> [[A]], i64 1
; CHECK: [[ie1:%.*]] = fmul float [[ee1]], 0x3F91DF46A0000000
; CHECK: [[ee2:%.*]] = extractelement <4 x float> [[A]], i64 2
; CHECK: [[ie2:%.*]] = fmul float [[ee2]], 0x3F91DF46A0000000
; CHECK: [[ee3:%.*]] = extractelement <4 x float> [[A]], i64 3
; CHECK: [[ie3:%.*]] = fmul float [[ee3]], 0x3F91DF46A0000000
; CHECK: [[TMP0:%.*]] = insertelement <4 x float> poison, float [[ie0]], i64 0
; CHECK: [[TMP1:%.*]] = insertelement <4 x float> [[TMP0]], float [[ie1]], i64 1
; CHECK: [[TMP2:%.*]] = insertelement <4 x float> [[TMP1]], float [[ie2]], i64 2
; CHECK: [[TMP3:%.*]] = insertelement <4 x float> [[TMP2]], float [[ie3]], i64 3
; CHECK: ret <4 x float> [[TMP3]]
;
entry:
  %elt.radians = call <4 x float> @llvm.dx.radians.v4f32(<4 x float> %a)
  ret <4 x float> %elt.radians
}
