; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=csky -verify-machineinstrs -csky-no-aliases -mattr=+2e3 < %s \
; RUN:   | FileCheck %s

declare void @notdead(ptr)
declare ptr @llvm.frameaddress(i32)
declare ptr @llvm.returnaddress(i32)

define ptr @test_frameaddress_0() nounwind {
; CHECK-LABEL: test_frameaddress_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    mov16 l4, sp
; CHECK-NEXT:    mov16 a0, l4
; CHECK-NEXT:    mov16 sp, l4
; CHECK-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
  %1 = call ptr @llvm.frameaddress(i32 0)
  ret ptr %1
}

define ptr @test_frameaddress_2() nounwind {
; CHECK-LABEL: test_frameaddress_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    mov16 l4, sp
; CHECK-NEXT:    ld32.w a0, (l4, 0)
; CHECK-NEXT:    ld16.w a0, (a0, 0)
; CHECK-NEXT:    mov16 sp, l4
; CHECK-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
  %1 = call ptr @llvm.frameaddress(i32 2)
  ret ptr %1
}

define ptr @test_frameaddress_3_alloca() nounwind {
; CHECK-LABEL: test_frameaddress_3_alloca:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    st32.w lr, (sp, 4) # 4-byte Folded Spill
; CHECK-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    mov16 l4, sp
; CHECK-NEXT:    subi16 sp, sp, 100
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    addu16 a0, sp
; CHECK-NEXT:    jsri32 [.LCPI2_0]
; CHECK-NEXT:    ld32.w a0, (l4, 0)
; CHECK-NEXT:    ld16.w a0, (a0, 0)
; CHECK-NEXT:    ld16.w a0, (a0, 0)
; CHECK-NEXT:    mov16 sp, l4
; CHECK-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    ld32.w lr, (sp, 4) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
  %1 = alloca [100 x i8]
  %2 = bitcast ptr %1 to ptr
  call void @notdead(ptr %2)
  %3 = call ptr @llvm.frameaddress(i32 3)
  ret ptr %3
}

define ptr @test_returnaddress_0() nounwind {
; CHECK-LABEL: test_returnaddress_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mov16 a0, lr
; CHECK-NEXT:    rts16
  %1 = call ptr @llvm.returnaddress(i32 0)
  ret ptr %1
}

define ptr @test_returnaddress_2() nounwind {
; CHECK-LABEL: test_returnaddress_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    subi16 sp, sp, 4
; CHECK-NEXT:    st32.w l4, (sp, 0) # 4-byte Folded Spill
; CHECK-NEXT:    mov16 l4, sp
; CHECK-NEXT:    ld32.w a0, (l4, 0)
; CHECK-NEXT:    ld16.w a0, (a0, 0)
; CHECK-NEXT:    ld16.w a0, (a0, 4)
; CHECK-NEXT:    mov16 sp, l4
; CHECK-NEXT:    ld32.w l4, (sp, 0) # 4-byte Folded Reload
; CHECK-NEXT:    addi16 sp, sp, 4
; CHECK-NEXT:    rts16
  %1 = call ptr @llvm.returnaddress(i32 2)
  ret ptr %1
}
