; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-- -mattr=+fullfp16 < %s | FileCheck %s

define float @select_fneg_a_or_8_cmp_olt_a_neg8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_fneg_a_or_8_cmp_olt_a_neg8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-8.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vminnm.f32 s0, s2, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %fneg.a = fneg nnan nsz float %a
  %cmp.a = fcmp nnan nsz olt float %a, -8.0
  %min.a = select nnan nsz i1 %cmp.a, float %fneg.a, float 8.0
  ret float %min.a
}

define half @select_fneg_a_or_8_cmp_olt_a_neg8_f16(half %a, half %b) #0 {
; CHECK-LABEL: select_fneg_a_or_8_cmp_olt_a_neg8_f16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f16 s0, #-8.000000e+00
; CHECK-NEXT:    vmov.f16 s2, r0
; CHECK-NEXT:    vminnm.f16 s0, s2, s0
; CHECK-NEXT:    vneg.f16 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    mov pc, lr
  %fneg.a = fneg nnan nsz half %a
  %cmp.a = fcmp nnan nsz olt half %a, -8.0
  %min.a = select nnan nsz i1 %cmp.a, half %fneg.a, half 8.0
  ret half %min.a
}

define float @select_fneg_a_or_8_cmp_ogt_a_neg8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_fneg_a_or_8_cmp_ogt_a_neg8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-8.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmaxnm.f32 s0, s2, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %fneg.a = fneg nnan nsz float %a
  %cmp.a = fcmp nnan nsz ogt float %a, -8.0
  %min.a = select nnan nsz i1 %cmp.a, float %fneg.a, float 8.0
  ret float %min.a
}

define half @select_fneg_a_or_8_cmp_ogt_a_neg8_f16(half %a, half %b) #0 {
; CHECK-LABEL: select_fneg_a_or_8_cmp_ogt_a_neg8_f16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f16 s0, #-8.000000e+00
; CHECK-NEXT:    vmov.f16 s2, r0
; CHECK-NEXT:    vmaxnm.f16 s0, s2, s0
; CHECK-NEXT:    vneg.f16 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    mov pc, lr
  %fneg.a = fneg nnan nsz half %a
  %cmp.a = fcmp nnan nsz ogt half %a, -8.0
  %min.a = select nnan nsz i1 %cmp.a, half %fneg.a, half 8.0
  ret half %min.a
}

define float @select_fsub0_or_8_cmp_olt_fsub1_neg8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_fsub0_or_8_cmp_olt_fsub1_neg8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s4, #-8.000000e+00
; CHECK-NEXT:    vsub.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %sub.0 = fsub nnan nsz float 4.0, %a
  %sub.1 = fsub nnan nsz float %a, 4.0
  %cmp.a = fcmp nnan nsz olt float %sub.0, -8.0
  %min.a = select nnan nsz i1 %cmp.a, float %sub.1, float 8.0
  ret float %min.a
}

define float @select_fsub0_or_neg8_cmp_olt_fsub1_8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_fsub0_or_neg8_cmp_olt_fsub1_8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s4, #8.000000e+00
; CHECK-NEXT:    vsub.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %sub.0 = fsub nnan nsz float 4.0, %a
  %sub.1 = fsub nnan nsz float %a, 4.0
  %cmp.a = fcmp nnan nsz olt float %sub.0, 8.0
  %min.a = select nnan nsz i1 %cmp.a, float %sub.1, float -8.0
  ret float %min.a
}

define float @select_mul4_or_neg8_cmp_olt_mulneg4_8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_mul4_or_neg8_cmp_olt_mulneg4_8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s4, #8.000000e+00
; CHECK-NEXT:    vmul.f32 s0, s2, s0
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %mul.0 = fmul nnan nsz float %a, 4.0
  %mul.1 = fmul nnan nsz float %a, -4.0
  %cmp.a = fcmp nnan nsz olt float %mul.1, 8.0
  %min.a = select nnan nsz i1 %cmp.a, float %mul.0, float -8.0
  ret float %min.a
}

define float @select_mul4_or_8_cmp_olt_mulneg4_neg8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_mul4_or_8_cmp_olt_mulneg4_neg8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s4, #-8.000000e+00
; CHECK-NEXT:    vmul.f32 s0, s2, s0
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %mul.0 = fmul nnan nsz float %a, 4.0
  %mul.1 = fmul nnan nsz float %a, -4.0
  %cmp.a = fcmp nnan nsz olt float %mul.1, -8.0
  %min.a = select nnan nsz i1 %cmp.a, float %mul.0, float 8.0
  ret float %min.a
}

define float @select_mul4_or_8_cmp_olt_mulneg4_8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_mul4_or_8_cmp_olt_mulneg4_8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s6, #8.000000e+00
; CHECK-NEXT:    vmov.f32 s4, #4.000000e+00
; CHECK-NEXT:    vmul.f32 s0, s2, s0
; CHECK-NEXT:    vmul.f32 s2, s2, s4
; CHECK-NEXT:    vcmp.f32 s6, s0
; CHECK-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NEXT:    vselgt.f32 s0, s2, s6
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    mov pc, lr
  %mul.0 = fmul nnan nsz float %a, 4.0
  %mul.1 = fmul nnan nsz float %a, -4.0
  %cmp.a = fcmp nnan nsz olt float %mul.1, 8.0
  %min.a = select nnan nsz i1 %cmp.a, float %mul.0, float 8.0
  ret float %min.a
}

define float @select_mul4_or_neg8_cmp_olt_mulneg4_neg8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_mul4_or_neg8_cmp_olt_mulneg4_neg8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #-4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s6, #-8.000000e+00
; CHECK-NEXT:    vmov.f32 s4, #4.000000e+00
; CHECK-NEXT:    vmul.f32 s0, s2, s0
; CHECK-NEXT:    vmul.f32 s2, s2, s4
; CHECK-NEXT:    vcmp.f32 s6, s0
; CHECK-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NEXT:    vselgt.f32 s0, s2, s6
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    mov pc, lr
  %mul.0 = fmul nnan nsz float %a, 4.0
  %mul.1 = fmul nnan nsz float %a, -4.0
  %cmp.a = fcmp nnan nsz olt float %mul.1, -8.0
  %min.a = select nnan nsz i1 %cmp.a, float %mul.0, float -8.0
  ret float %min.a
}

define float @select_mulneg4_or_neg8_cmp_olt_mul4_8_f32(float %a, float %b) #0 {
; CHECK-LABEL: select_mulneg4_or_neg8_cmp_olt_mul4_8_f32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s0, #4.000000e+00
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vmov.f32 s4, #8.000000e+00
; CHECK-NEXT:    vmul.f32 s0, s2, s0
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    eor r0, r0, #-2147483648
; CHECK-NEXT:    mov pc, lr
  %mul.0 = fmul nnan nsz float %a, -4.0
  %mul.1 = fmul nnan nsz float %a, 4.0
  %cmp.a = fcmp nnan nsz olt float %mul.1, 8.0
  %min.a = select nnan nsz i1 %cmp.a, float %mul.0, float -8.0
  ret float %min.a
}

; FIXME: Should be unnecessary
attributes #0 = { "no-signed-zeros-fp-math"="true" }
