; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx600 -amdgpu-bypass-slow-div=0 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx600 -amdgpu-bypass-slow-div=0 -amdgpu-codegenprepare-expand-div64 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN-IR %s

define amdgpu_kernel void @s_test_srem(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0xd
; GCN-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s12
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s13
; GCN-NEXT:    s_sub_u32 s0, 0, s12
; GCN-NEXT:    s_subb_u32 s1, 0, s13
; GCN-NEXT:    s_mov_b32 s4, s8
; GCN-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s5, s9
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v2, s0, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s0, v0
; GCN-NEXT:    v_mul_lo_u32 v5, s1, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s0, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v3, v0, v4
; GCN-NEXT:    v_mul_lo_u32 v5, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v1, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v8, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v7, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v6, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s0, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s0, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s1, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_mul_lo_u32 v3, s0, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_mul_lo_u32 v6, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v3
; GCN-NEXT:    v_mul_hi_u32 v8, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v5, v1, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v3
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v7, v5, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s10, v0
; GCN-NEXT:    v_mul_hi_u32 v4, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v5, s11, v1
; GCN-NEXT:    v_mul_lo_u32 v1, s11, v1
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, s11, v0
; GCN-NEXT:    v_mul_hi_u32 v0, s11, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, v3, v0, vcc
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, 0, v2, vcc
; GCN-NEXT:    v_mul_lo_u32 v1, s12, v1
; GCN-NEXT:    v_mul_hi_u32 v2, s12, v0
; GCN-NEXT:    v_mul_lo_u32 v3, s13, v0
; GCN-NEXT:    v_mul_lo_u32 v0, s12, v0
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GCN-NEXT:    v_sub_i32_e32 v2, vcc, s11, v1
; GCN-NEXT:    v_mov_b32_e32 v3, s13
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, s10, v0
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, vcc
; GCN-NEXT:    v_subrev_i32_e64 v4, s[0:1], s12, v0
; GCN-NEXT:    v_subbrev_u32_e64 v5, s[2:3], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s13, v5
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s12, v4
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], s13, v5
; GCN-NEXT:    v_subrev_i32_e64 v3, s[0:1], s12, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[2:3]
; GCN-NEXT:    v_subbrev_u32_e64 v2, s[0:1], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v6
; GCN-NEXT:    v_cndmask_b32_e64 v3, v4, v3, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, s11
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v4, v1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s13, v1
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s12, v0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, s13, v1
; GCN-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_mov_b64 s[4:5], 0
; GCN-IR-NEXT:    s_mov_b32 s11, 0
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[8:9], s[6:7], 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[12:13], s[2:3], 0
; GCN-IR-NEXT:    s_flbit_i32_b64 s10, s[6:7]
; GCN-IR-NEXT:    s_flbit_i32_b64 s18, s[2:3]
; GCN-IR-NEXT:    s_or_b64 s[8:9], s[8:9], s[12:13]
; GCN-IR-NEXT:    s_sub_u32 s12, s10, s18
; GCN-IR-NEXT:    s_subb_u32 s13, 0, 0
; GCN-IR-NEXT:    v_cmp_gt_u64_e64 s[14:15], s[12:13], 63
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[16:17], s[12:13], 63
; GCN-IR-NEXT:    s_or_b64 s[14:15], s[8:9], s[14:15]
; GCN-IR-NEXT:    s_and_b64 s[8:9], s[14:15], exec
; GCN-IR-NEXT:    s_cselect_b32 s9, 0, s3
; GCN-IR-NEXT:    s_cselect_b32 s8, 0, s2
; GCN-IR-NEXT:    s_or_b64 s[14:15], s[14:15], s[16:17]
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[14:15]
; GCN-IR-NEXT:    s_cbranch_vccz .LBB0_5
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    s_add_u32 s14, s12, 1
; GCN-IR-NEXT:    s_addc_u32 s15, s13, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[8:9], s[14:15], 0
; GCN-IR-NEXT:    s_sub_i32 s12, 63, s12
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; GCN-IR-NEXT:    s_lshl_b64 s[8:9], s[2:3], s12
; GCN-IR-NEXT:    s_cbranch_vccz .LBB0_4
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    s_lshr_b64 s[12:13], s[2:3], s14
; GCN-IR-NEXT:    s_add_u32 s16, s6, -1
; GCN-IR-NEXT:    s_addc_u32 s17, s7, -1
; GCN-IR-NEXT:    s_not_b64 s[4:5], s[10:11]
; GCN-IR-NEXT:    s_add_u32 s10, s4, s18
; GCN-IR-NEXT:    s_addc_u32 s11, s5, 0
; GCN-IR-NEXT:    s_mov_b64 s[14:15], 0
; GCN-IR-NEXT:    s_mov_b32 s5, 0
; GCN-IR-NEXT:  .LBB0_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    s_lshl_b64 s[12:13], s[12:13], 1
; GCN-IR-NEXT:    s_lshr_b32 s4, s9, 31
; GCN-IR-NEXT:    s_lshl_b64 s[8:9], s[8:9], 1
; GCN-IR-NEXT:    s_or_b64 s[12:13], s[12:13], s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[8:9], s[14:15], s[8:9]
; GCN-IR-NEXT:    s_sub_u32 s4, s16, s12
; GCN-IR-NEXT:    s_subb_u32 s4, s17, s13
; GCN-IR-NEXT:    s_ashr_i32 s14, s4, 31
; GCN-IR-NEXT:    s_mov_b32 s15, s14
; GCN-IR-NEXT:    s_and_b32 s4, s14, 1
; GCN-IR-NEXT:    s_and_b64 s[14:15], s[14:15], s[6:7]
; GCN-IR-NEXT:    s_sub_u32 s12, s12, s14
; GCN-IR-NEXT:    s_subb_u32 s13, s13, s15
; GCN-IR-NEXT:    s_add_u32 s10, s10, 1
; GCN-IR-NEXT:    s_addc_u32 s11, s11, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[18:19], s[10:11], 0
; GCN-IR-NEXT:    s_mov_b64 s[14:15], s[4:5]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[18:19]
; GCN-IR-NEXT:    s_cbranch_vccz .LBB0_3
; GCN-IR-NEXT:  .LBB0_4: ; %Flow7
; GCN-IR-NEXT:    s_lshl_b64 s[8:9], s[8:9], 1
; GCN-IR-NEXT:    s_or_b64 s[8:9], s[4:5], s[8:9]
; GCN-IR-NEXT:  .LBB0_5: ; %udiv-end
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s8
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s6, v0
; GCN-IR-NEXT:    s_mov_b32 s12, s0
; GCN-IR-NEXT:    s_mul_i32 s0, s6, s9
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s3
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GCN-IR-NEXT:    s_mul_i32 s0, s7, s8
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, s0, v0
; GCN-IR-NEXT:    s_mul_i32 s0, s6, s8
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, s2, v0
; GCN-IR-NEXT:    s_mov_b32 s15, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s14, -1
; GCN-IR-NEXT:    s_mov_b32 s13, s1
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[12:15], 0
; GCN-IR-NEXT:    s_endpgm
  %result = urem i64 %x, %y
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define i64 @v_test_srem(i64 %x, i64 %y) {
; GCN-LABEL: v_test_srem:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v3, v4, vcc
; GCN-NEXT:    v_xor_b32_e32 v2, v2, v4
; GCN-NEXT:    v_xor_b32_e32 v3, v5, v4
; GCN-NEXT:    v_cvt_f32_u32_e32 v4, v3
; GCN-NEXT:    v_cvt_f32_u32_e32 v5, v2
; GCN-NEXT:    v_sub_i32_e32 v6, vcc, 0, v3
; GCN-NEXT:    v_subb_u32_e32 v7, vcc, 0, v2, vcc
; GCN-NEXT:    v_madmk_f32 v4, v5, 0x4f800000, v4
; GCN-NEXT:    v_rcp_f32_e32 v4, v4
; GCN-NEXT:    v_mul_f32_e32 v4, 0x5f7ffffc, v4
; GCN-NEXT:    v_mul_f32_e32 v5, 0x2f800000, v4
; GCN-NEXT:    v_trunc_f32_e32 v5, v5
; GCN-NEXT:    v_madmk_f32 v4, v5, 0xcf800000, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v4, v4
; GCN-NEXT:    v_cvt_u32_f32_e32 v5, v5
; GCN-NEXT:    v_mul_hi_u32 v8, v6, v4
; GCN-NEXT:    v_mul_lo_u32 v9, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v10, v7, v4
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v9
; GCN-NEXT:    v_mul_lo_u32 v9, v6, v4
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GCN-NEXT:    v_mul_lo_u32 v10, v4, v8
; GCN-NEXT:    v_mul_hi_u32 v11, v4, v9
; GCN-NEXT:    v_mul_hi_u32 v12, v4, v8
; GCN-NEXT:    v_mul_hi_u32 v13, v5, v8
; GCN-NEXT:    v_mul_lo_u32 v8, v5, v8
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_addc_u32_e32 v11, vcc, 0, v12, vcc
; GCN-NEXT:    v_mul_lo_u32 v12, v5, v9
; GCN-NEXT:    v_mul_hi_u32 v9, v5, v9
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v10, v12
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, v11, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v10, vcc, 0, v13, vcc
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v10, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v5, v9, vcc
; GCN-NEXT:    v_mul_lo_u32 v8, v6, v5
; GCN-NEXT:    v_mul_hi_u32 v9, v6, v4
; GCN-NEXT:    v_mul_lo_u32 v7, v7, v4
; GCN-NEXT:    v_mul_lo_u32 v6, v6, v4
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; GCN-NEXT:    v_mul_lo_u32 v10, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v11, v4, v6
; GCN-NEXT:    v_mul_hi_u32 v12, v4, v7
; GCN-NEXT:    v_mul_hi_u32 v9, v5, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v5, v6
; GCN-NEXT:    v_mul_hi_u32 v8, v5, v7
; GCN-NEXT:    v_add_i32_e32 v10, vcc, v11, v10
; GCN-NEXT:    v_addc_u32_e32 v11, vcc, 0, v12, vcc
; GCN-NEXT:    v_mul_lo_u32 v7, v5, v7
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v10, v6
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, v11, v9, vcc
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, v5, v7, vcc
; GCN-NEXT:    v_ashrrev_i32_e32 v6, 31, v1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GCN-NEXT:    v_xor_b32_e32 v0, v0, v6
; GCN-NEXT:    v_mul_lo_u32 v7, v0, v5
; GCN-NEXT:    v_mul_hi_u32 v8, v0, v4
; GCN-NEXT:    v_mul_hi_u32 v9, v0, v5
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v6, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v6
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v8, v7
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v9, vcc
; GCN-NEXT:    v_mul_lo_u32 v9, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v10, v1, v5
; GCN-NEXT:    v_mul_lo_u32 v5, v1, v5
; GCN-NEXT:    v_add_i32_e32 v7, vcc, v7, v9
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v8, v4, vcc
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v10, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v7, vcc
; GCN-NEXT:    v_mul_lo_u32 v5, v3, v5
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v4
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v7, v5
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GCN-NEXT:    v_sub_i32_e32 v7, vcc, v1, v5
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v4
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v7, v2, vcc
; GCN-NEXT:    v_sub_i32_e64 v7, s[4:5], v0, v3
; GCN-NEXT:    v_subbrev_u32_e64 v8, s[6:7], 0, v4, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v8, v2
; GCN-NEXT:    v_cndmask_b32_e64 v9, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v7, v3
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v10, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[6:7], v8, v2
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v4, v2, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v1, v2
; GCN-NEXT:    v_cndmask_b32_e64 v9, v9, v10, s[6:7]
; GCN-NEXT:    v_sub_i32_e64 v10, s[4:5], v7, v3
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v0, v3
; GCN-NEXT:    v_subbrev_u32_e64 v4, s[4:5], 0, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v2
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v9
; GCN-NEXT:    v_cndmask_b32_e32 v2, v5, v3, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v2, v7, v10, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v4, v8, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GCN-NEXT:    v_xor_b32_e32 v0, v0, v6
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v6
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v6
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v6, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v14, 31, v1
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v14
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v14
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v14
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v14, vcc
; GCN-IR-NEXT:    v_xor_b32_e32 v2, v2, v4
; GCN-IR-NEXT:    v_xor_b32_e32 v3, v3, v4
; GCN-IR-NEXT:    v_sub_i32_e32 v2, vcc, v2, v4
; GCN-IR-NEXT:    v_subb_u32_e32 v3, vcc, v3, v4, vcc
; GCN-IR-NEXT:    v_ffbh_u32_e32 v4, v2
; GCN-IR-NEXT:    v_add_i32_e64 v4, s[6:7], 32, v4
; GCN-IR-NEXT:    v_ffbh_u32_e32 v5, v3
; GCN-IR-NEXT:    v_min_u32_e32 v12, v4, v5
; GCN-IR-NEXT:    v_ffbh_u32_e32 v4, v0
; GCN-IR-NEXT:    v_add_i32_e64 v4, s[6:7], 32, v4
; GCN-IR-NEXT:    v_ffbh_u32_e32 v5, v1
; GCN-IR-NEXT:    v_min_u32_e32 v13, v4, v5
; GCN-IR-NEXT:    v_sub_i32_e64 v4, s[6:7], v12, v13
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[0:1]
; GCN-IR-NEXT:    v_subb_u32_e64 v5, s[6:7], 0, 0, s[6:7]
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[6:7], 63, v[4:5]
; GCN-IR-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GCN-IR-NEXT:    v_mov_b32_e32 v15, v14
; GCN-IR-NEXT:    v_cndmask_b32_e64 v7, v1, 0, s[4:5]
; GCN-IR-NEXT:    v_cndmask_b32_e64 v6, v0, 0, s[4:5]
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB1_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v4
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v5, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v4, s[4:5], 63, v4
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[4:5], v[0:1], v4
; GCN-IR-NEXT:    v_mov_b32_e32 v6, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v7, 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB1_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_add_i32_e32 v16, vcc, -1, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v17, vcc, -1, v3, vcc
; GCN-IR-NEXT:    v_not_b32_e32 v7, v12
; GCN-IR-NEXT:    v_lshr_b64 v[10:11], v[0:1], v8
; GCN-IR-NEXT:    v_not_b32_e32 v6, 0
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, v7, v13
; GCN-IR-NEXT:    v_mov_b32_e32 v12, 0
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v6, vcc
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    v_mov_b32_e32 v13, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v7, 0
; GCN-IR-NEXT:  .LBB1_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[10:11], v[10:11], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v6, 31, v5
; GCN-IR-NEXT:    v_or_b32_e32 v10, v10, v6
; GCN-IR-NEXT:    v_lshl_b64 v[4:5], v[4:5], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v6, vcc, v16, v10
; GCN-IR-NEXT:    v_subb_u32_e32 v6, vcc, v17, v11, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v4, v12, v4
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v12, 31, v6
; GCN-IR-NEXT:    v_add_i32_e32 v8, vcc, 1, v8
; GCN-IR-NEXT:    v_or_b32_e32 v5, v13, v5
; GCN-IR-NEXT:    v_and_b32_e32 v6, 1, v12
; GCN-IR-NEXT:    v_and_b32_e32 v13, v12, v3
; GCN-IR-NEXT:    v_and_b32_e32 v12, v12, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GCN-IR-NEXT:    v_sub_i32_e64 v10, s[4:5], v10, v12
; GCN-IR-NEXT:    v_subb_u32_e64 v11, s[4:5], v11, v13, s[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v13, v7
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v12, v6
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz .LBB1_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  .LBB1_5: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[4:5], v[4:5], 1
; GCN-IR-NEXT:    v_or_b32_e32 v7, v7, v5
; GCN-IR-NEXT:    v_or_b32_e32 v6, v6, v4
; GCN-IR-NEXT:  .LBB1_6: ; %Flow5
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mul_lo_u32 v4, v2, v7
; GCN-IR-NEXT:    v_mul_hi_u32 v5, v2, v6
; GCN-IR-NEXT:    v_mul_lo_u32 v3, v3, v6
; GCN-IR-NEXT:    v_mul_lo_u32 v2, v2, v6
; GCN-IR-NEXT:    v_add_i32_e32 v4, vcc, v5, v4
; GCN-IR-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v14
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v15
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v14
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v15, vcc
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = srem i64 %x, %y
  ret i64 %result
}

define amdgpu_kernel void @s_test_srem23_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem23_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s5, s[4:5], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_ashr_i64 s[8:9], s[4:5], 41
; GCN-NEXT:    v_cvt_f32_i32_e32 v0, s8
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_ashr_i64 s[0:1], s[2:3], 41
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, s0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    s_xor_b32 s1, s0, s8
; GCN-NEXT:    s_ashr_i32 s1, s1, 30
; GCN-NEXT:    s_or_b32 s1, s1, 1
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-NEXT:    v_cmp_ge_f32_e64 s[2:3], |v1|, |v0|
; GCN-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-NEXT:    s_cselect_b32 s1, s1, 0
; GCN-NEXT:    v_readfirstlane_b32 s2, v2
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s1, s1, s8
; GCN-NEXT:    s_sub_i32 s0, s0, s1
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x170000
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem23_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_load_dword s5, s[4:5], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_ashr_i64 s[8:9], s[4:5], 41
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v0, s8
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    s_ashr_i64 s[0:1], s[2:3], 41
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, s0
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    s_xor_b32 s1, s0, s8
; GCN-IR-NEXT:    s_ashr_i32 s1, s1, 30
; GCN-IR-NEXT:    s_or_b32 s1, s1, 1
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 s[2:3], |v1|, |v0|
; GCN-IR-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-IR-NEXT:    s_cselect_b32 s1, s1, 0
; GCN-IR-NEXT:    v_readfirstlane_b32 s2, v2
; GCN-IR-NEXT:    s_add_i32 s1, s2, s1
; GCN-IR-NEXT:    s_mul_i32 s1, s1, s8
; GCN-IR-NEXT:    s_sub_i32 s0, s0, s1
; GCN-IR-NEXT:    s_bfe_i32 s0, s0, 0x170000
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 41
  %2 = ashr i64 %y, 41
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_srem24_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem24_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s5, s[4:5], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_ashr_i64 s[8:9], s[4:5], 40
; GCN-NEXT:    v_cvt_f32_i32_e32 v0, s8
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_ashr_i64 s[0:1], s[2:3], 40
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, s0
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-NEXT:    s_xor_b32 s1, s0, s8
; GCN-NEXT:    s_ashr_i32 s1, s1, 30
; GCN-NEXT:    s_or_b32 s1, s1, 1
; GCN-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-NEXT:    v_cmp_ge_f32_e64 s[2:3], |v1|, |v0|
; GCN-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-NEXT:    s_cselect_b32 s1, s1, 0
; GCN-NEXT:    v_readfirstlane_b32 s2, v2
; GCN-NEXT:    s_add_i32 s1, s2, s1
; GCN-NEXT:    s_mul_i32 s1, s1, s8
; GCN-NEXT:    s_sub_i32 s0, s0, s1
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem24_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_load_dword s5, s[4:5], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_ashr_i64 s[8:9], s[4:5], 40
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v0, s8
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    s_ashr_i64 s[0:1], s[2:3], 40
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, s0
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v0
; GCN-IR-NEXT:    s_xor_b32 s1, s0, s8
; GCN-IR-NEXT:    s_ashr_i32 s1, s1, 30
; GCN-IR-NEXT:    s_or_b32 s1, s1, 1
; GCN-IR-NEXT:    v_mul_f32_e32 v2, v1, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_mad_f32 v1, -v2, v0, v1
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 s[2:3], |v1|, |v0|
; GCN-IR-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-IR-NEXT:    s_cselect_b32 s1, s1, 0
; GCN-IR-NEXT:    v_readfirstlane_b32 s2, v2
; GCN-IR-NEXT:    s_add_i32 s1, s2, s1
; GCN-IR-NEXT:    s_mul_i32 s1, s1, s8
; GCN-IR-NEXT:    s_sub_i32 s0, s0, s1
; GCN-IR-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 40
  %2 = ashr i64 %y, 40
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define i64 @v_test_srem24_64(i64 %x, i64 %y) {
; GCN-LABEL: v_test_srem24_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashr_i64 v[2:3], v[2:3], 40
; GCN-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-NEXT:    v_cvt_f32_i32_e32 v3, v2
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-NEXT:    v_xor_b32_e32 v5, v0, v2
; GCN-NEXT:    v_ashrrev_i32_e32 v5, 30, v5
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v3
; GCN-NEXT:    v_or_b32_e32 v5, 1, v5
; GCN-NEXT:    v_mul_f32_e32 v4, v1, v4
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_mad_f32 v1, -v4, v3, v1
; GCN-NEXT:    v_cvt_i32_f32_e32 v4, v4
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, |v3|
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v4, v1
; GCN-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem24_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashr_i64 v[2:3], v[2:3], 40
; GCN-IR-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v3, v2
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-IR-NEXT:    v_xor_b32_e32 v5, v0, v2
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v5, 30, v5
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v4, v3
; GCN-IR-NEXT:    v_or_b32_e32 v5, 1, v5
; GCN-IR-NEXT:    v_mul_f32_e32 v4, v1, v4
; GCN-IR-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-IR-NEXT:    v_mad_f32 v1, -v4, v3, v1
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v4, v4
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, |v3|
; GCN-IR-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v4, v1
; GCN-IR-NEXT:    v_mul_lo_u32 v1, v1, v2
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GCN-IR-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %1 = ashr i64 %x, 40
  %2 = ashr i64 %y, 40
  %result = srem i64 %1, %2
  ret i64 %result
}

define amdgpu_kernel void @s_test_srem25_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem25_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s1, s[4:5], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i64 s[0:1], s[0:1], 39
; GCN-NEXT:    s_abs_i32 s8, s0
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_sub_i32 s2, 0, s8
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v1, s2, v0
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], 39
; GCN-NEXT:    s_abs_i32 s3, s2
; GCN-NEXT:    s_ashr_i32 s0, s2, 31
; GCN-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_mul_hi_u32 v0, s3, v0
; GCN-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-NEXT:    s_mul_i32 s1, s1, s8
; GCN-NEXT:    s_sub_i32 s1, s3, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_xor_b32 s1, s1, s0
; GCN-NEXT:    s_sub_i32 s0, s1, s0
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem25_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dword s1, s[4:5], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i64 s[0:1], s[0:1], 39
; GCN-IR-NEXT:    s_abs_i32 s8, s0
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_sub_i32 s2, 0, s8
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-IR-NEXT:    v_mul_lo_u32 v1, s2, v0
; GCN-IR-NEXT:    s_ashr_i64 s[2:3], s[2:3], 39
; GCN-IR-NEXT:    s_abs_i32 s3, s2
; GCN-IR-NEXT:    s_ashr_i32 s0, s2, 31
; GCN-IR-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s3, v0
; GCN-IR-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-IR-NEXT:    s_mul_i32 s1, s1, s8
; GCN-IR-NEXT:    s_sub_i32 s1, s3, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_xor_b32 s1, s1, s0
; GCN-IR-NEXT:    s_sub_i32 s0, s1, s0
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 39
  %2 = ashr i64 %y, 39
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_srem31_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem31_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s1, s[4:5], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i64 s[0:1], s[0:1], 33
; GCN-NEXT:    s_abs_i32 s8, s0
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_sub_i32 s2, 0, s8
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v1, s2, v0
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], 33
; GCN-NEXT:    s_abs_i32 s3, s2
; GCN-NEXT:    s_ashr_i32 s0, s2, 31
; GCN-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_mul_hi_u32 v0, s3, v0
; GCN-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-NEXT:    s_mul_i32 s1, s1, s8
; GCN-NEXT:    s_sub_i32 s1, s3, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_xor_b32 s1, s1, s0
; GCN-NEXT:    s_sub_i32 s0, s1, s0
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem31_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dword s1, s[4:5], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i64 s[0:1], s[0:1], 33
; GCN-IR-NEXT:    s_abs_i32 s8, s0
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_sub_i32 s2, 0, s8
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-IR-NEXT:    v_mul_lo_u32 v1, s2, v0
; GCN-IR-NEXT:    s_ashr_i64 s[2:3], s[2:3], 33
; GCN-IR-NEXT:    s_abs_i32 s3, s2
; GCN-IR-NEXT:    s_ashr_i32 s0, s2, 31
; GCN-IR-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s3, v0
; GCN-IR-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-IR-NEXT:    s_mul_i32 s1, s1, s8
; GCN-IR-NEXT:    s_sub_i32 s1, s3, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_xor_b32 s1, s1, s0
; GCN-IR-NEXT:    s_sub_i32 s0, s1, s0
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 33
  %2 = ashr i64 %y, 33
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

; 32 known sign bits
define amdgpu_kernel void @s_test_srem32_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem32_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[4:5], 0xe
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_abs_i32 s8, s0
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-NEXT:    s_sub_i32 s0, 0, s8
; GCN-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v1, s0, v0
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_abs_i32 s2, s3
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_mul_hi_u32 v0, s2, v0
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_ashr_i32 s0, s3, 31
; GCN-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-NEXT:    s_mul_i32 s1, s1, s8
; GCN-NEXT:    s_sub_i32 s1, s2, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_sub_i32 s2, s1, s8
; GCN-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-NEXT:    s_xor_b32 s1, s1, s0
; GCN-NEXT:    s_sub_i32 s0, s1, s0
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem32_64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dword s0, s[4:5], 0xe
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_abs_i32 s8, s0
; GCN-IR-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-IR-NEXT:    s_sub_i32 s0, 0, s8
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v0, v0
; GCN-IR-NEXT:    v_mul_f32_e32 v0, 0x4f7ffffe, v0
; GCN-IR-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-IR-NEXT:    v_mul_lo_u32 v1, s0, v0
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    v_mul_hi_u32 v1, v0, v1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_abs_i32 s2, s3
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s2, v0
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_ashr_i32 s0, s3, 31
; GCN-IR-NEXT:    v_readfirstlane_b32 s1, v0
; GCN-IR-NEXT:    s_mul_i32 s1, s1, s8
; GCN-IR-NEXT:    s_sub_i32 s1, s2, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_sub_i32 s2, s1, s8
; GCN-IR-NEXT:    s_cmp_ge_u32 s1, s8
; GCN-IR-NEXT:    s_cselect_b32 s1, s2, s1
; GCN-IR-NEXT:    s_xor_b32 s1, s1, s0
; GCN-IR-NEXT:    s_sub_i32 s0, s1, s0
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 32
  %2 = ashr i64 %y, 32
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

; 33 known sign bits
define amdgpu_kernel void @s_test_srem33_64(ptr addrspace(1) %out, i64 %x, i64 %y) {
; GCN-LABEL: s_test_srem33_64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i64 s[10:11], s[2:3], 31
; GCN-NEXT:    s_ashr_i64 s[6:7], s[4:5], 31
; GCN-NEXT:    s_ashr_i32 s4, s5, 31
; GCN-NEXT:    s_add_u32 s6, s6, s4
; GCN-NEXT:    s_mov_b32 s5, s4
; GCN-NEXT:    s_addc_u32 s7, s7, s4
; GCN-NEXT:    s_xor_b64 s[8:9], s[6:7], s[4:5]
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s9
; GCN-NEXT:    s_sub_u32 s2, 0, s8
; GCN-NEXT:    s_subb_u32 s4, 0, s9
; GCN-NEXT:    s_ashr_i32 s12, s3, 31
; GCN-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s13, s12
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    v_mul_lo_u32 v2, s2, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v5, s4, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s2, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v3, v0, v4
; GCN-NEXT:    v_mul_lo_u32 v5, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v1, v2
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v4
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v6
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v4, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v7, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s2, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s4, v0
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_mul_lo_u32 v3, s2, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_mul_lo_u32 v6, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v3
; GCN-NEXT:    v_mul_hi_u32 v8, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v5, v1, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v3
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v7, v5, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    s_add_u32 s2, s10, s12
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    s_addc_u32 s3, s11, s12
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    s_xor_b64 s[10:11], s[2:3], s[12:13]
; GCN-NEXT:    v_mul_lo_u32 v2, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s10, v0
; GCN-NEXT:    v_mul_hi_u32 v4, s10, v1
; GCN-NEXT:    v_mul_hi_u32 v5, s11, v1
; GCN-NEXT:    v_mul_lo_u32 v1, s11, v1
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, s11, v0
; GCN-NEXT:    v_mul_hi_u32 v0, s11, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, v3, v0, vcc
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, 0, v2, vcc
; GCN-NEXT:    v_mul_lo_u32 v1, s8, v1
; GCN-NEXT:    v_mul_hi_u32 v2, s8, v0
; GCN-NEXT:    v_mul_lo_u32 v3, s9, v0
; GCN-NEXT:    v_mul_lo_u32 v0, s8, v0
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GCN-NEXT:    v_sub_i32_e32 v2, vcc, s11, v1
; GCN-NEXT:    v_mov_b32_e32 v3, s9
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, s10, v0
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, vcc
; GCN-NEXT:    v_subrev_i32_e64 v4, s[0:1], s8, v0
; GCN-NEXT:    v_subbrev_u32_e64 v5, s[2:3], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s9, v5
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s8, v4
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], s9, v5
; GCN-NEXT:    v_subrev_i32_e64 v3, s[0:1], s8, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[2:3]
; GCN-NEXT:    v_subbrev_u32_e64 v2, s[0:1], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v6
; GCN-NEXT:    v_cndmask_b32_e64 v3, v4, v3, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, s11
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v4, v1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s9, v1
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, s9, v1
; GCN-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v0, s12, v0
; GCN-NEXT:    v_xor_b32_e32 v1, s12, v1
; GCN-NEXT:    v_mov_b32_e32 v2, s12
; GCN-NEXT:    v_subrev_i32_e32 v0, vcc, s12, v0
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v2, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem33_64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GCN-IR-NEXT:    s_mov_b32 s13, 0
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i64 s[2:3], s[2:3], 31
; GCN-IR-NEXT:    s_ashr_i64 s[8:9], s[4:5], 31
; GCN-IR-NEXT:    s_ashr_i32 s4, s3, 31
; GCN-IR-NEXT:    s_mov_b32 s5, s4
; GCN-IR-NEXT:    s_xor_b64 s[2:3], s[2:3], s[4:5]
; GCN-IR-NEXT:    s_sub_u32 s6, s2, s4
; GCN-IR-NEXT:    s_subb_u32 s7, s3, s4
; GCN-IR-NEXT:    s_ashr_i32 s2, s9, 31
; GCN-IR-NEXT:    s_mov_b32 s3, s2
; GCN-IR-NEXT:    s_xor_b64 s[8:9], s[8:9], s[2:3]
; GCN-IR-NEXT:    s_sub_u32 s8, s8, s2
; GCN-IR-NEXT:    s_subb_u32 s9, s9, s2
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[10:11], s[6:7], 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[2:3], s[8:9], 0
; GCN-IR-NEXT:    s_flbit_i32_b64 s12, s[8:9]
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[2:3], s[10:11]
; GCN-IR-NEXT:    s_flbit_i32_b64 s20, s[6:7]
; GCN-IR-NEXT:    s_sub_u32 s14, s12, s20
; GCN-IR-NEXT:    s_subb_u32 s15, 0, 0
; GCN-IR-NEXT:    v_cmp_gt_u64_e64 s[16:17], s[14:15], 63
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[18:19], s[14:15], 63
; GCN-IR-NEXT:    s_or_b64 s[16:17], s[10:11], s[16:17]
; GCN-IR-NEXT:    s_and_b64 s[10:11], s[16:17], exec
; GCN-IR-NEXT:    s_cselect_b32 s11, 0, s7
; GCN-IR-NEXT:    s_cselect_b32 s10, 0, s6
; GCN-IR-NEXT:    s_or_b64 s[16:17], s[16:17], s[18:19]
; GCN-IR-NEXT:    s_mov_b64 s[2:3], 0
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[16:17]
; GCN-IR-NEXT:    s_cbranch_vccz .LBB8_5
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    s_add_u32 s16, s14, 1
; GCN-IR-NEXT:    s_addc_u32 s17, s15, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[10:11], s[16:17], 0
; GCN-IR-NEXT:    s_sub_i32 s14, 63, s14
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[10:11]
; GCN-IR-NEXT:    s_lshl_b64 s[10:11], s[6:7], s14
; GCN-IR-NEXT:    s_cbranch_vccz .LBB8_4
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    s_lshr_b64 s[14:15], s[6:7], s16
; GCN-IR-NEXT:    s_add_u32 s18, s8, -1
; GCN-IR-NEXT:    s_addc_u32 s19, s9, -1
; GCN-IR-NEXT:    s_not_b64 s[2:3], s[12:13]
; GCN-IR-NEXT:    s_add_u32 s12, s2, s20
; GCN-IR-NEXT:    s_addc_u32 s13, s3, 0
; GCN-IR-NEXT:    s_mov_b64 s[16:17], 0
; GCN-IR-NEXT:    s_mov_b32 s3, 0
; GCN-IR-NEXT:  .LBB8_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    s_lshl_b64 s[14:15], s[14:15], 1
; GCN-IR-NEXT:    s_lshr_b32 s2, s11, 31
; GCN-IR-NEXT:    s_lshl_b64 s[10:11], s[10:11], 1
; GCN-IR-NEXT:    s_or_b64 s[14:15], s[14:15], s[2:3]
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[16:17], s[10:11]
; GCN-IR-NEXT:    s_sub_u32 s2, s18, s14
; GCN-IR-NEXT:    s_subb_u32 s2, s19, s15
; GCN-IR-NEXT:    s_ashr_i32 s16, s2, 31
; GCN-IR-NEXT:    s_mov_b32 s17, s16
; GCN-IR-NEXT:    s_and_b32 s2, s16, 1
; GCN-IR-NEXT:    s_and_b64 s[16:17], s[16:17], s[8:9]
; GCN-IR-NEXT:    s_sub_u32 s14, s14, s16
; GCN-IR-NEXT:    s_subb_u32 s15, s15, s17
; GCN-IR-NEXT:    s_add_u32 s12, s12, 1
; GCN-IR-NEXT:    s_addc_u32 s13, s13, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[20:21], s[12:13], 0
; GCN-IR-NEXT:    s_mov_b64 s[16:17], s[2:3]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[20:21]
; GCN-IR-NEXT:    s_cbranch_vccz .LBB8_3
; GCN-IR-NEXT:  .LBB8_4: ; %Flow7
; GCN-IR-NEXT:    s_lshl_b64 s[10:11], s[10:11], 1
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[2:3], s[10:11]
; GCN-IR-NEXT:  .LBB8_5: ; %udiv-end
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s10
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s8, v0
; GCN-IR-NEXT:    s_mul_i32 s11, s8, s11
; GCN-IR-NEXT:    s_mul_i32 s9, s9, s10
; GCN-IR-NEXT:    s_mul_i32 s8, s8, s10
; GCN-IR-NEXT:    v_readfirstlane_b32 s12, v0
; GCN-IR-NEXT:    s_add_i32 s11, s12, s11
; GCN-IR-NEXT:    s_add_i32 s11, s11, s9
; GCN-IR-NEXT:    s_sub_u32 s6, s6, s8
; GCN-IR-NEXT:    s_subb_u32 s7, s7, s11
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[6:7], s[4:5]
; GCN-IR-NEXT:    s_sub_u32 s4, s6, s4
; GCN-IR-NEXT:    s_subb_u32 s5, s7, s5
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s4
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s5
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i64 %x, 31
  %2 = ashr i64 %y, 31
  %result = srem i64 %1, %2
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_srem24_48(ptr addrspace(1) %out, i48 %x, i48 %y) {
; GCN-LABEL: s_test_srem24_48:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_sext_i32_i16 s3, s3
; GCN-NEXT:    s_sext_i32_i16 s5, s5
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_alignbit_b32 v0, s5, v0, 24
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_alignbit_b32 v2, s3, v2, 24
; GCN-NEXT:    v_cvt_f32_i32_e32 v3, v2
; GCN-NEXT:    v_rcp_iflag_f32_e32 v4, v1
; GCN-NEXT:    v_xor_b32_e32 v5, v2, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v5, 30, v5
; GCN-NEXT:    v_or_b32_e32 v5, 1, v5
; GCN-NEXT:    v_mul_f32_e32 v4, v3, v4
; GCN-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-NEXT:    v_mad_f32 v3, -v4, v1, v3
; GCN-NEXT:    v_cvt_i32_f32_e32 v4, v4
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, |v1|
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GCN-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_subrev_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-NEXT:    buffer_store_short v1, off, s[4:7], 0 offset:4
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem24_48:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_sext_i32_i16 s3, s3
; GCN-IR-NEXT:    s_sext_i32_i16 s5, s5
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s4
; GCN-IR-NEXT:    v_alignbit_b32 v0, s5, v0, 24
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-IR-NEXT:    v_mov_b32_e32 v2, s2
; GCN-IR-NEXT:    v_alignbit_b32 v2, s3, v2, 24
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v3, v2
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v4, v1
; GCN-IR-NEXT:    v_xor_b32_e32 v5, v2, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v5, 30, v5
; GCN-IR-NEXT:    v_or_b32_e32 v5, 1, v5
; GCN-IR-NEXT:    v_mul_f32_e32 v4, v3, v4
; GCN-IR-NEXT:    v_trunc_f32_e32 v4, v4
; GCN-IR-NEXT:    v_mad_f32 v3, -v4, v1, v3
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v4, v4
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v3|, |v1|
; GCN-IR-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GCN-IR-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    v_subrev_i32_e32 v0, vcc, v0, v2
; GCN-IR-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-IR-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCN-IR-NEXT:    buffer_store_short v1, off, s[4:7], 0 offset:4
; GCN-IR-NEXT:    s_endpgm
  %1 = ashr i48 %x, 24
  %2 = ashr i48 %y, 24
  %result = srem i48 %1, %2
  store i48 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_srem_k_num_i64(ptr addrspace(1) %out, i64 %x) {
; GCN-LABEL: s_test_srem_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i32 s4, s3, 31
; GCN-NEXT:    s_add_u32 s2, s2, s4
; GCN-NEXT:    s_mov_b32 s5, s4
; GCN-NEXT:    s_addc_u32 s3, s3, s4
; GCN-NEXT:    s_xor_b64 s[8:9], s[2:3], s[4:5]
; GCN-NEXT:    v_cvt_f32_u32_e32 v0, s8
; GCN-NEXT:    v_cvt_f32_u32_e32 v1, s9
; GCN-NEXT:    s_sub_u32 s2, 0, s8
; GCN-NEXT:    s_subb_u32 s3, 0, s9
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    v_madmk_f32 v0, v1, 0x4f800000, v0
; GCN-NEXT:    v_rcp_f32_e32 v0, v0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mul_f32_e32 v0, 0x5f7ffffc, v0
; GCN-NEXT:    v_mul_f32_e32 v1, 0x2f800000, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_madmk_f32 v0, v1, 0xcf800000, v0
; GCN-NEXT:    v_cvt_u32_f32_e32 v1, v1
; GCN-NEXT:    v_cvt_u32_f32_e32 v0, v0
; GCN-NEXT:    v_mul_lo_u32 v2, s2, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v5, s3, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s2, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v3, v0, v4
; GCN-NEXT:    v_mul_lo_u32 v5, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v6, v1, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v1, v4
; GCN-NEXT:    v_mul_hi_u32 v8, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v7, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v5, v6, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, s2, v1
; GCN-NEXT:    v_mul_hi_u32 v3, s2, v0
; GCN-NEXT:    v_mul_lo_u32 v4, s3, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GCN-NEXT:    v_mul_lo_u32 v3, s2, v0
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_mul_lo_u32 v6, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v7, v0, v3
; GCN-NEXT:    v_mul_hi_u32 v8, v0, v2
; GCN-NEXT:    v_mul_hi_u32 v5, v1, v3
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v3
; GCN-NEXT:    v_mul_hi_u32 v4, v1, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v6, v3
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v7, v5, vcc
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v4, vcc
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v2, v1, 24
; GCN-NEXT:    v_mul_hi_u32 v0, v0, 24
; GCN-NEXT:    v_mul_hi_u32 v1, v1, 24
; GCN-NEXT:    v_mov_b32_e32 v3, s9
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v0, vcc, 0, v1, vcc
; GCN-NEXT:    v_mul_lo_u32 v1, s9, v0
; GCN-NEXT:    v_mul_hi_u32 v2, s8, v0
; GCN-NEXT:    v_mul_lo_u32 v0, s8, v0
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GCN-NEXT:    v_sub_i32_e32 v2, vcc, 0, v1
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, 24, v0
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, vcc
; GCN-NEXT:    v_subrev_i32_e64 v4, s[0:1], s8, v0
; GCN-NEXT:    v_subbrev_u32_e64 v5, s[2:3], 0, v2, s[0:1]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s9, v5
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_le_u32_e64 s[2:3], s8, v4
; GCN-NEXT:    v_subb_u32_e64 v2, s[0:1], v2, v3, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[2:3]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[2:3], s9, v5
; GCN-NEXT:    v_subrev_i32_e64 v3, s[0:1], s8, v4
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[2:3]
; GCN-NEXT:    v_subbrev_u32_e64 v2, s[0:1], 0, v2, s[0:1]
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, v6
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s9, v1
; GCN-NEXT:    v_cndmask_b32_e64 v3, v4, v3, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, -1, vcc
; GCN-NEXT:    v_cmp_le_u32_e32 vcc, s8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, s9, v1
; GCN-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v4
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem_k_num_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_mov_b64 s[6:7], 0
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i32 s8, s3, 31
; GCN-IR-NEXT:    s_mov_b32 s9, s8
; GCN-IR-NEXT:    s_xor_b64 s[2:3], s[2:3], s[8:9]
; GCN-IR-NEXT:    s_sub_u32 s4, s2, s8
; GCN-IR-NEXT:    s_subb_u32 s5, s3, s8
; GCN-IR-NEXT:    s_flbit_i32_b64 s12, s[4:5]
; GCN-IR-NEXT:    s_add_u32 s2, s12, 0xffffffc5
; GCN-IR-NEXT:    s_addc_u32 s3, 0, -1
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[8:9], s[4:5], 0
; GCN-IR-NEXT:    v_cmp_gt_u64_e64 s[10:11], s[2:3], 63
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[14:15], s[2:3], 63
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[8:9], s[10:11]
; GCN-IR-NEXT:    s_and_b64 s[8:9], s[10:11], exec
; GCN-IR-NEXT:    s_cselect_b32 s8, 0, 24
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[10:11], s[14:15]
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[10:11]
; GCN-IR-NEXT:    s_mov_b32 s9, 0
; GCN-IR-NEXT:    s_cbranch_vccz .LBB10_5
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    s_add_u32 s8, s2, 1
; GCN-IR-NEXT:    s_addc_u32 s9, s3, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[10:11], s[8:9], 0
; GCN-IR-NEXT:    s_sub_i32 s2, 63, s2
; GCN-IR-NEXT:    s_andn2_b64 vcc, exec, s[10:11]
; GCN-IR-NEXT:    s_lshl_b64 s[2:3], 24, s2
; GCN-IR-NEXT:    s_cbranch_vccz .LBB10_4
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    s_lshr_b64 s[10:11], 24, s8
; GCN-IR-NEXT:    s_add_u32 s14, s4, -1
; GCN-IR-NEXT:    s_addc_u32 s15, s5, -1
; GCN-IR-NEXT:    s_sub_u32 s8, 58, s12
; GCN-IR-NEXT:    s_subb_u32 s9, 0, 0
; GCN-IR-NEXT:    s_mov_b64 s[12:13], 0
; GCN-IR-NEXT:    s_mov_b32 s7, 0
; GCN-IR-NEXT:  .LBB10_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    s_lshl_b64 s[10:11], s[10:11], 1
; GCN-IR-NEXT:    s_lshr_b32 s6, s3, 31
; GCN-IR-NEXT:    s_lshl_b64 s[2:3], s[2:3], 1
; GCN-IR-NEXT:    s_or_b64 s[10:11], s[10:11], s[6:7]
; GCN-IR-NEXT:    s_or_b64 s[2:3], s[12:13], s[2:3]
; GCN-IR-NEXT:    s_sub_u32 s6, s14, s10
; GCN-IR-NEXT:    s_subb_u32 s6, s15, s11
; GCN-IR-NEXT:    s_ashr_i32 s12, s6, 31
; GCN-IR-NEXT:    s_mov_b32 s13, s12
; GCN-IR-NEXT:    s_and_b32 s6, s12, 1
; GCN-IR-NEXT:    s_and_b64 s[12:13], s[12:13], s[4:5]
; GCN-IR-NEXT:    s_sub_u32 s10, s10, s12
; GCN-IR-NEXT:    s_subb_u32 s11, s11, s13
; GCN-IR-NEXT:    s_add_u32 s8, s8, 1
; GCN-IR-NEXT:    s_addc_u32 s9, s9, 0
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[16:17], s[8:9], 0
; GCN-IR-NEXT:    s_mov_b64 s[12:13], s[6:7]
; GCN-IR-NEXT:    s_and_b64 vcc, exec, s[16:17]
; GCN-IR-NEXT:    s_cbranch_vccz .LBB10_3
; GCN-IR-NEXT:  .LBB10_4: ; %Flow6
; GCN-IR-NEXT:    s_lshl_b64 s[2:3], s[2:3], 1
; GCN-IR-NEXT:    s_or_b64 s[8:9], s[6:7], s[2:3]
; GCN-IR-NEXT:  .LBB10_5: ; %udiv-end
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s8
; GCN-IR-NEXT:    v_mul_hi_u32 v0, s4, v0
; GCN-IR-NEXT:    s_mul_i32 s6, s4, s9
; GCN-IR-NEXT:    s_mul_i32 s5, s5, s8
; GCN-IR-NEXT:    s_mul_i32 s4, s4, s8
; GCN-IR-NEXT:    v_add_i32_e32 v0, vcc, s6, v0
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, s5, v0
; GCN-IR-NEXT:    v_sub_i32_e64 v0, vcc, 24, s4
; GCN-IR-NEXT:    s_mov_b32 s3, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s2, -1
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GCN-IR-NEXT:    s_endpgm
  %result = srem i64 24, %x
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define i64 @v_test_srem_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_srem_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v2
; GCN-NEXT:    v_xor_b32_e32 v0, v0, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v1
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v0
; GCN-NEXT:    v_subb_u32_e32 v5, vcc, 0, v1, vcc
; GCN-NEXT:    v_madmk_f32 v2, v3, 0x4f800000, v2
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_madmk_f32 v2, v3, 0xcf800000, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v6, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v3
; GCN-NEXT:    v_mul_lo_u32 v8, v5, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v9, v2, v7
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v11, v3, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v3, v6
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v10, vcc
; GCN-NEXT:    v_mul_lo_u32 v10, v3, v7
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v7
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v9, v7, vcc
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v11, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v4, v3
; GCN-NEXT:    v_mul_hi_u32 v7, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v5, v5, v2
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v9, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_mul_hi_u32 v6, v3, v5
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v10, vcc
; GCN-NEXT:    v_mul_lo_u32 v5, v3, v5
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v8, v4
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v9, v7, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v3, v5, vcc
; GCN-NEXT:    v_mul_lo_u32 v4, v3, 24
; GCN-NEXT:    v_mul_hi_u32 v2, v2, 24
; GCN-NEXT:    v_mul_hi_u32 v3, v3, 24
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, 0, v3, vcc
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v2
; GCN-NEXT:    v_mul_hi_u32 v4, v0, v2
; GCN-NEXT:    v_mul_lo_u32 v2, v0, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v3
; GCN-NEXT:    v_sub_i32_e32 v2, vcc, 24, v2
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v4, v1, vcc
; GCN-NEXT:    v_sub_i32_e64 v5, s[4:5], v2, v0
; GCN-NEXT:    v_subbrev_u32_e64 v6, s[6:7], 0, v4, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v6, v1
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v5, v0
; GCN-NEXT:    v_cndmask_b32_e64 v8, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[6:7], v6, v1
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v4, v1, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v7, v7, v8, s[6:7]
; GCN-NEXT:    v_sub_i32_e64 v8, s[4:5], v5, v0
; GCN-NEXT:    v_subb_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_subbrev_u32_e64 v4, s[4:5], 0, v4, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v7
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[4:5]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v6, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem_k_num_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v2
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v2
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v2, vcc
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_min_u32_e32 v10, v2, v3
; GCN-IR-NEXT:    s_movk_i32 s6, 0xffc5
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, s6, v10
; GCN-IR-NEXT:    v_addc_u32_e64 v3, s[6:7], 0, -1, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[2:3]
; GCN-IR-NEXT:    v_cmp_ne_u64_e64 s[6:7], 63, v[2:3]
; GCN-IR-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-IR-NEXT:    v_cndmask_b32_e64 v4, 24, 0, s[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[4:5], s[4:5], -1
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB11_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v2
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], 24, v2
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB11_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_add_i32_e32 v12, vcc, -1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v13, vcc, -1, v1, vcc
; GCN-IR-NEXT:    v_lshr_b64 v[8:9], 24, v6
; GCN-IR-NEXT:    v_sub_i32_e32 v6, vcc, 58, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v10, 0
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[4:5], 0, 0, vcc
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    v_mov_b32_e32 v11, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:  .LBB11_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v8, v8, v4
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, v12, v8
; GCN-IR-NEXT:    v_subb_u32_e32 v4, vcc, v13, v9, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v2, v10, v2
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v10, 31, v4
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v6
; GCN-IR-NEXT:    v_or_b32_e32 v3, v11, v3
; GCN-IR-NEXT:    v_and_b32_e32 v4, 1, v10
; GCN-IR-NEXT:    v_and_b32_e32 v11, v10, v1
; GCN-IR-NEXT:    v_and_b32_e32 v10, v10, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_sub_i32_e64 v8, s[4:5], v8, v10
; GCN-IR-NEXT:    v_subb_u32_e64 v9, s[4:5], v9, v11, s[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v11, v5
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v4
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz .LBB11_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  .LBB11_5: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v5, v5, v3
; GCN-IR-NEXT:    v_or_b32_e32 v4, v4, v2
; GCN-IR-NEXT:  .LBB11_6: ; %Flow5
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mul_lo_u32 v2, v0, v5
; GCN-IR-NEXT:    v_mul_hi_u32 v3, v0, v4
; GCN-IR-NEXT:    v_mul_lo_u32 v1, v1, v4
; GCN-IR-NEXT:    v_mul_lo_u32 v0, v0, v4
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 24, v0
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = srem i64 24, %x
  ret i64 %result
}

define i64 @v_test_srem_pow2_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_srem_pow2_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v1, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v2
; GCN-NEXT:    v_xor_b32_e32 v0, v0, v2
; GCN-NEXT:    v_cvt_f32_u32_e32 v2, v0
; GCN-NEXT:    v_cvt_f32_u32_e32 v3, v1
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v0
; GCN-NEXT:    v_subb_u32_e32 v5, vcc, 0, v1, vcc
; GCN-NEXT:    v_madmk_f32 v2, v3, 0x4f800000, v2
; GCN-NEXT:    v_rcp_f32_e32 v2, v2
; GCN-NEXT:    v_mul_f32_e32 v2, 0x5f7ffffc, v2
; GCN-NEXT:    v_mul_f32_e32 v3, 0x2f800000, v2
; GCN-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-NEXT:    v_madmk_f32 v2, v3, 0xcf800000, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v2, v2
; GCN-NEXT:    v_cvt_u32_f32_e32 v3, v3
; GCN-NEXT:    v_mul_hi_u32 v6, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v3
; GCN-NEXT:    v_mul_lo_u32 v8, v5, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v7
; GCN-NEXT:    v_mul_lo_u32 v7, v4, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v9, v2, v7
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v6
; GCN-NEXT:    v_mul_hi_u32 v11, v3, v6
; GCN-NEXT:    v_mul_lo_u32 v6, v3, v6
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v10, vcc
; GCN-NEXT:    v_mul_lo_u32 v10, v3, v7
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v7
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v8, v10
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, v9, v7, vcc
; GCN-NEXT:    v_addc_u32_e32 v8, vcc, 0, v11, vcc
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_addc_u32_e32 v7, vcc, 0, v8, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GCN-NEXT:    v_mul_lo_u32 v6, v4, v3
; GCN-NEXT:    v_mul_hi_u32 v7, v4, v2
; GCN-NEXT:    v_mul_lo_u32 v5, v5, v2
; GCN-NEXT:    v_mul_lo_u32 v4, v4, v2
; GCN-NEXT:    v_add_i32_e32 v6, vcc, v7, v6
; GCN-NEXT:    v_add_i32_e32 v5, vcc, v6, v5
; GCN-NEXT:    v_mul_lo_u32 v8, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v9, v2, v4
; GCN-NEXT:    v_mul_hi_u32 v10, v2, v5
; GCN-NEXT:    v_mul_hi_u32 v7, v3, v4
; GCN-NEXT:    v_mul_lo_u32 v4, v3, v4
; GCN-NEXT:    v_mul_hi_u32 v6, v3, v5
; GCN-NEXT:    v_add_i32_e32 v8, vcc, v9, v8
; GCN-NEXT:    v_addc_u32_e32 v9, vcc, 0, v10, vcc
; GCN-NEXT:    v_mul_lo_u32 v5, v3, v5
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v8, v4
; GCN-NEXT:    v_addc_u32_e32 v4, vcc, v9, v7, vcc
; GCN-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GCN-NEXT:    v_addc_u32_e32 v5, vcc, 0, v6, vcc
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GCN-NEXT:    v_addc_u32_e32 v2, vcc, v3, v5, vcc
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 17, v2
; GCN-NEXT:    v_mul_lo_u32 v3, v1, v2
; GCN-NEXT:    v_mul_hi_u32 v4, v0, v2
; GCN-NEXT:    v_mul_lo_u32 v2, v0, v2
; GCN-NEXT:    v_add_i32_e32 v3, vcc, v4, v3
; GCN-NEXT:    v_sub_i32_e32 v4, vcc, 0, v3
; GCN-NEXT:    v_sub_i32_e32 v2, vcc, 0x8000, v2
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v4, v1, vcc
; GCN-NEXT:    v_sub_i32_e64 v5, s[4:5], v2, v0
; GCN-NEXT:    v_subbrev_u32_e64 v6, s[6:7], 0, v4, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v6, v1
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_ge_u32_e64 s[6:7], v5, v0
; GCN-NEXT:    v_cndmask_b32_e64 v8, 0, -1, s[6:7]
; GCN-NEXT:    v_cmp_eq_u32_e64 s[6:7], v6, v1
; GCN-NEXT:    v_subb_u32_e64 v4, s[4:5], v4, v1, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v7, v7, v8, s[6:7]
; GCN-NEXT:    v_sub_i32_e64 v8, s[4:5], v5, v0
; GCN-NEXT:    v_subb_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_subbrev_u32_e64 v4, s[4:5], 0, v4, s[4:5]
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v7
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, -1, vcc
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc, v2, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, -1, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[4:5]
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v6, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem_pow2_k_num_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v2
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v2
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v2, vcc
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_min_u32_e32 v10, v2, v3
; GCN-IR-NEXT:    s_movk_i32 s6, 0xffd0
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, s6, v10
; GCN-IR-NEXT:    v_addc_u32_e64 v3, s[6:7], 0, -1, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e32 vcc, 63, v[2:3]
; GCN-IR-NEXT:    v_cmp_ne_u64_e64 s[6:7], 63, v[2:3]
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0x8000
; GCN-IR-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-IR-NEXT:    v_cndmask_b32_e64 v4, v4, 0, s[4:5]
; GCN-IR-NEXT:    s_xor_b64 s[4:5], s[4:5], -1
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB12_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v2
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; GCN-IR-NEXT:    s_mov_b64 s[4:5], 0x8000
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], s[4:5], v2
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[8:9]
; GCN-IR-NEXT:    s_cbranch_execz .LBB12_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_add_i32_e32 v12, vcc, -1, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v13, vcc, -1, v1, vcc
; GCN-IR-NEXT:    v_lshr_b64 v[8:9], s[4:5], v6
; GCN-IR-NEXT:    v_sub_i32_e32 v6, vcc, 47, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v10, 0
; GCN-IR-NEXT:    v_subb_u32_e64 v7, s[4:5], 0, 0, vcc
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    v_mov_b32_e32 v11, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:  .LBB12_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v8, v8, v4
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, v12, v8
; GCN-IR-NEXT:    v_subb_u32_e32 v4, vcc, v13, v9, vcc
; GCN-IR-NEXT:    v_or_b32_e32 v2, v10, v2
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v10, 31, v4
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v6
; GCN-IR-NEXT:    v_or_b32_e32 v3, v11, v3
; GCN-IR-NEXT:    v_and_b32_e32 v4, 1, v10
; GCN-IR-NEXT:    v_and_b32_e32 v11, v10, v1
; GCN-IR-NEXT:    v_and_b32_e32 v10, v10, v0
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_sub_i32_e64 v8, s[4:5], v8, v10
; GCN-IR-NEXT:    v_subb_u32_e64 v9, s[4:5], v9, v11, s[4:5]
; GCN-IR-NEXT:    v_mov_b32_e32 v11, v5
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v4
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz .LBB12_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  .LBB12_5: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v5, v5, v3
; GCN-IR-NEXT:    v_or_b32_e32 v4, v4, v2
; GCN-IR-NEXT:  .LBB12_6: ; %Flow5
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_mul_lo_u32 v2, v0, v5
; GCN-IR-NEXT:    v_mul_hi_u32 v3, v0, v4
; GCN-IR-NEXT:    v_mul_lo_u32 v1, v1, v4
; GCN-IR-NEXT:    v_mul_lo_u32 v0, v0, v4
; GCN-IR-NEXT:    v_add_i32_e32 v2, vcc, v3, v2
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 0x8000, v0
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = srem i64 32768, %x
  ret i64 %result
}

define i64 @v_test_srem_pow2_k_den_i64(i64 %x) {
; GCN-LABEL: v_test_srem_pow2_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v2, 31, v1
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 17, v2
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0xffff8000, v2
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem_pow2_k_den_i64:
; GCN-IR:       ; %bb.0: ; %_udiv-special-cases
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v12, 31, v1
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v12
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v12
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v12
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v12, vcc
; GCN-IR-NEXT:    v_ffbh_u32_e32 v2, v0
; GCN-IR-NEXT:    v_add_i32_e64 v2, s[4:5], 32, v2
; GCN-IR-NEXT:    v_ffbh_u32_e32 v3, v1
; GCN-IR-NEXT:    v_min_u32_e32 v10, v2, v3
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 48, v10
; GCN-IR-NEXT:    v_subb_u32_e64 v3, s[4:5], 0, 0, s[4:5]
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[0:1]
; GCN-IR-NEXT:    v_cmp_lt_u64_e64 s[4:5], 63, v[2:3]
; GCN-IR-NEXT:    v_mov_b32_e32 v13, v12
; GCN-IR-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 63, v[2:3]
; GCN-IR-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GCN-IR-NEXT:    v_cndmask_b32_e64 v5, v1, 0, s[4:5]
; GCN-IR-NEXT:    v_cndmask_b32_e64 v4, v0, 0, s[4:5]
; GCN-IR-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GCN-IR-NEXT:    s_and_saveexec_b64 s[6:7], s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB13_6
; GCN-IR-NEXT:  ; %bb.1: ; %udiv-bb1
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v2
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v3, vcc
; GCN-IR-NEXT:    v_sub_i32_e64 v2, s[4:5], 63, v2
; GCN-IR-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[0:1], v2
; GCN-IR-NEXT:    v_mov_b32_e32 v4, 0
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GCN-IR-NEXT:    s_xor_b64 s[8:9], exec, s[4:5]
; GCN-IR-NEXT:    s_cbranch_execz .LBB13_5
; GCN-IR-NEXT:  ; %bb.2: ; %udiv-preheader
; GCN-IR-NEXT:    v_lshr_b64 v[8:9], v[0:1], v6
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 0xffffffcf, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v10, 0
; GCN-IR-NEXT:    v_addc_u32_e64 v7, s[4:5], 0, -1, vcc
; GCN-IR-NEXT:    s_mov_b64 s[10:11], 0
; GCN-IR-NEXT:    v_mov_b32_e32 v11, 0
; GCN-IR-NEXT:    s_movk_i32 s12, 0x7fff
; GCN-IR-NEXT:    v_mov_b32_e32 v5, 0
; GCN-IR-NEXT:  .LBB13_3: ; %udiv-do-while
; GCN-IR-NEXT:    ; =>This Inner Loop Header: Depth=1
; GCN-IR-NEXT:    v_lshl_b64 v[8:9], v[8:9], 1
; GCN-IR-NEXT:    v_lshrrev_b32_e32 v4, 31, v3
; GCN-IR-NEXT:    v_or_b32_e32 v8, v8, v4
; GCN-IR-NEXT:    v_sub_i32_e32 v4, vcc, s12, v8
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_subb_u32_e32 v4, vcc, 0, v9, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v6, vcc, 1, v6
; GCN-IR-NEXT:    v_or_b32_e32 v2, v10, v2
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v10, 31, v4
; GCN-IR-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; GCN-IR-NEXT:    v_and_b32_e32 v4, 1, v10
; GCN-IR-NEXT:    v_and_b32_e32 v10, 0x8000, v10
; GCN-IR-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GCN-IR-NEXT:    v_or_b32_e32 v3, v11, v3
; GCN-IR-NEXT:    v_sub_i32_e64 v8, s[4:5], v8, v10
; GCN-IR-NEXT:    v_mov_b32_e32 v11, v5
; GCN-IR-NEXT:    v_subbrev_u32_e64 v9, s[4:5], 0, v9, s[4:5]
; GCN-IR-NEXT:    s_or_b64 s[10:11], vcc, s[10:11]
; GCN-IR-NEXT:    v_mov_b32_e32 v10, v4
; GCN-IR-NEXT:    s_andn2_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:    s_cbranch_execnz .LBB13_3
; GCN-IR-NEXT:  ; %bb.4: ; %Flow
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[10:11]
; GCN-IR-NEXT:  .LBB13_5: ; %Flow4
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[8:9]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[2:3], 1
; GCN-IR-NEXT:    v_or_b32_e32 v5, v5, v3
; GCN-IR-NEXT:    v_or_b32_e32 v4, v4, v2
; GCN-IR-NEXT:  .LBB13_6: ; %Flow5
; GCN-IR-NEXT:    s_or_b64 exec, exec, s[6:7]
; GCN-IR-NEXT:    v_lshl_b64 v[2:3], v[4:5], 15
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GCN-IR-NEXT:    v_xor_b32_e32 v0, v0, v12
; GCN-IR-NEXT:    v_xor_b32_e32 v1, v1, v13
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v12
; GCN-IR-NEXT:    v_subb_u32_e32 v1, vcc, v1, v13, vcc
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %result = srem i64 %x, 32768
  ret i64 %result
}

define amdgpu_kernel void @s_test_srem24_k_num_i64(ptr addrspace(1) %out, i64 %x) {
; GCN-LABEL: s_test_srem24_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], 40
; GCN-NEXT:    v_cvt_f32_i32_e32 v0, s2
; GCN-NEXT:    s_mov_b32 s3, 0x41c00000
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_ashr_i32 s0, s2, 30
; GCN-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    s_or_b32 s8, s0, 1
; GCN-NEXT:    v_mul_f32_e32 v1, 0x41c00000, v1
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_mad_f32 v2, -v1, v0, s3
; GCN-NEXT:    v_cvt_i32_f32_e32 v1, v1
; GCN-NEXT:    v_cmp_ge_f32_e64 s[0:1], |v2|, |v0|
; GCN-NEXT:    s_and_b64 s[0:1], s[0:1], exec
; GCN-NEXT:    s_cselect_b32 s0, s8, 0
; GCN-NEXT:    v_readfirstlane_b32 s1, v1
; GCN-NEXT:    s_add_i32 s0, s1, s0
; GCN-NEXT:    s_mul_i32 s0, s0, s2
; GCN-NEXT:    s_sub_i32 s0, 24, s0
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem24_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i64 s[2:3], s[2:3], 40
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v0, s2
; GCN-IR-NEXT:    s_mov_b32 s3, 0x41c00000
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_ashr_i32 s0, s2, 30
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v1, v0
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    s_or_b32 s8, s0, 1
; GCN-IR-NEXT:    v_mul_f32_e32 v1, 0x41c00000, v1
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_mad_f32 v2, -v1, v0, s3
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v1, v1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 s[0:1], |v2|, |v0|
; GCN-IR-NEXT:    s_and_b64 s[0:1], s[0:1], exec
; GCN-IR-NEXT:    s_cselect_b32 s0, s8, 0
; GCN-IR-NEXT:    v_readfirstlane_b32 s1, v1
; GCN-IR-NEXT:    s_add_i32 s0, s1, s0
; GCN-IR-NEXT:    s_mul_i32 s0, s0, s2
; GCN-IR-NEXT:    s_sub_i32 s0, 24, s0
; GCN-IR-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %x.shr = ashr i64 %x, 40
  %result = srem i64 24, %x.shr
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_test_srem24_k_den_i64(ptr addrspace(1) %out, i64 %x) {
; GCN-LABEL: s_test_srem24_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s8, 0x46b6fe00
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], 40
; GCN-NEXT:    v_cvt_f32_i32_e32 v0, s2
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_ashr_i32 s0, s2, 30
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mul_f32_e32 v1, 0x38331158, v0
; GCN-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-NEXT:    v_mad_f32 v0, -v1, s8, v0
; GCN-NEXT:    v_cvt_i32_f32_e32 v1, v1
; GCN-NEXT:    s_or_b32 s3, s0, 1
; GCN-NEXT:    v_cmp_ge_f32_e64 s[0:1], |v0|, s8
; GCN-NEXT:    s_and_b64 s[0:1], s[0:1], exec
; GCN-NEXT:    s_cselect_b32 s0, s3, 0
; GCN-NEXT:    v_readfirstlane_b32 s1, v1
; GCN-NEXT:    s_add_i32 s0, s1, s0
; GCN-NEXT:    s_mulk_i32 s0, 0x5b7f
; GCN-NEXT:    s_sub_i32 s0, s2, s0
; GCN-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-NEXT:    s_endpgm
;
; GCN-IR-LABEL: s_test_srem24_k_den_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-IR-NEXT:    s_mov_b32 s8, 0x46b6fe00
; GCN-IR-NEXT:    s_mov_b32 s7, 0xf000
; GCN-IR-NEXT:    s_mov_b32 s6, -1
; GCN-IR-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-IR-NEXT:    s_ashr_i64 s[2:3], s[2:3], 40
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v0, s2
; GCN-IR-NEXT:    s_mov_b32 s4, s0
; GCN-IR-NEXT:    s_ashr_i32 s0, s2, 30
; GCN-IR-NEXT:    s_mov_b32 s5, s1
; GCN-IR-NEXT:    v_mul_f32_e32 v1, 0x38331158, v0
; GCN-IR-NEXT:    v_trunc_f32_e32 v1, v1
; GCN-IR-NEXT:    v_mad_f32 v0, -v1, s8, v0
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v1, v1
; GCN-IR-NEXT:    s_or_b32 s3, s0, 1
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 s[0:1], |v0|, s8
; GCN-IR-NEXT:    s_and_b64 s[0:1], s[0:1], exec
; GCN-IR-NEXT:    s_cselect_b32 s0, s3, 0
; GCN-IR-NEXT:    v_readfirstlane_b32 s1, v1
; GCN-IR-NEXT:    s_add_i32 s0, s1, s0
; GCN-IR-NEXT:    s_mulk_i32 s0, 0x5b7f
; GCN-IR-NEXT:    s_sub_i32 s0, s2, s0
; GCN-IR-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GCN-IR-NEXT:    s_ashr_i32 s1, s0, 31
; GCN-IR-NEXT:    v_mov_b32_e32 v0, s0
; GCN-IR-NEXT:    v_mov_b32_e32 v1, s1
; GCN-IR-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCN-IR-NEXT:    s_endpgm
  %x.shr = ashr i64 %x, 40
  %result = srem i64 %x.shr, 23423
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define i64 @v_test_srem24_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_srem24_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v3, 30, v0
; GCN-NEXT:    v_or_b32_e32 v3, 1, v3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v1
; GCN-NEXT:    v_mul_f32_e32 v2, 0x41c00000, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_mad_f32 v4, -v2, v1, s4
; GCN-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v4|, |v1|
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, 24, v0
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem24_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-IR-NEXT:    s_mov_b32 s4, 0x41c00000
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v3, 30, v0
; GCN-IR-NEXT:    v_or_b32_e32 v3, 1, v3
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mul_f32_e32 v2, 0x41c00000, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_mad_f32 v4, -v2, v1, s4
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v4|, |v1|
; GCN-IR-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-IR-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 24, v0
; GCN-IR-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = ashr i64 %x, 40
  %result = srem i64 24, %x.shr
  ret i64 %result
}

define i64 @v_test_srem24_pow2_k_num_i64(i64 %x) {
; GCN-LABEL: v_test_srem24_pow2_k_num_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-NEXT:    v_ashrrev_i32_e32 v3, 30, v0
; GCN-NEXT:    v_or_b32_e32 v3, 1, v3
; GCN-NEXT:    v_rcp_iflag_f32_e32 v2, v1
; GCN-NEXT:    v_mul_f32_e32 v2, 0x47000000, v2
; GCN-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-NEXT:    v_mad_f32 v4, -v2, v1, s4
; GCN-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-NEXT:    v_cmp_ge_f32_e64 vcc, |v4|, |v1|
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GCN-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, 0x8000, v0
; GCN-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem24_pow2_k_num_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-IR-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v3, 30, v0
; GCN-IR-NEXT:    v_or_b32_e32 v3, 1, v3
; GCN-IR-NEXT:    v_rcp_iflag_f32_e32 v2, v1
; GCN-IR-NEXT:    v_mul_f32_e32 v2, 0x47000000, v2
; GCN-IR-NEXT:    v_trunc_f32_e32 v2, v2
; GCN-IR-NEXT:    v_mad_f32 v4, -v2, v1, s4
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v2, v2
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v4|, |v1|
; GCN-IR-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v2, v1
; GCN-IR-NEXT:    v_mul_lo_u32 v0, v1, v0
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, 0x8000, v0
; GCN-IR-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = ashr i64 %x, 40
  %result = srem i64 32768, %x.shr
  ret i64 %result
}

define i64 @v_test_srem24_pow2_k_den_i64(i64 %x) {
; GCN-LABEL: v_test_srem24_pow2_k_den_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-NEXT:    v_lshrrev_b32_e32 v2, 17, v1
; GCN-NEXT:    v_add_i32_e32 v2, vcc, v0, v2
; GCN-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; GCN-NEXT:    v_and_b32_e32 v2, 0xffff8000, v2
; GCN-NEXT:    v_sub_i32_e32 v0, vcc, v0, v2
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, v1, v3, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GCN-IR-LABEL: v_test_srem24_pow2_k_den_i64:
; GCN-IR:       ; %bb.0:
; GCN-IR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-IR-NEXT:    v_ashr_i64 v[0:1], v[0:1], 40
; GCN-IR-NEXT:    s_mov_b32 s4, 0x47000000
; GCN-IR-NEXT:    v_cvt_f32_i32_e32 v1, v0
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v2, 30, v0
; GCN-IR-NEXT:    v_or_b32_e32 v2, 1, v2
; GCN-IR-NEXT:    v_mul_f32_e32 v3, 0x38000000, v1
; GCN-IR-NEXT:    v_trunc_f32_e32 v3, v3
; GCN-IR-NEXT:    v_mad_f32 v1, -v3, s4, v1
; GCN-IR-NEXT:    v_cvt_i32_f32_e32 v3, v3
; GCN-IR-NEXT:    v_cmp_ge_f32_e64 vcc, |v1|, s4
; GCN-IR-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GCN-IR-NEXT:    v_add_i32_e32 v1, vcc, v3, v1
; GCN-IR-NEXT:    v_lshlrev_b32_e32 v1, 15, v1
; GCN-IR-NEXT:    v_sub_i32_e32 v0, vcc, v0, v1
; GCN-IR-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GCN-IR-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-IR-NEXT:    s_setpc_b64 s[30:31]
  %x.shr = ashr i64 %x, 40
  %result = srem i64 %x.shr, 32768
  ret i64 %result
}
