; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -mtriple=amdgcn < %s | FileCheck --check-prefixes=SI,SI-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn < %s | FileCheck --check-prefixes=SI,SI-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck --check-prefixes=VI,VI-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck --check-prefixes=VI,VI-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck --check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck --check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck --check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s

; Test that add/sub with a constant is swapped to sub/add with negated
; constant to minimize code size.

define amdgpu_kernel void @v_test_i32_x_sub_64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_x_sub_64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_x_sub_64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_x_sub_64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_subrev_u32_e32 v2, vcc, 64, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_x_sub_64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 0xffffffc0, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_i32_x_sub_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_subrev_u32_e32 v1, 64, v1
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_i32_x_sub_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 0xffffffc0, v1
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_i32_x_sub_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_subrev_nc_u32_e32 v1, 64, v1
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_i32_x_sub_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 0xffffffc0, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_test_i32_x_sub_64:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_subrev_nc_u32_e32 v1, 64, v1
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_test_i32_x_sub_64:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v1, 0xffffffc0, v1
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 %x, 64
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_x_sub_64_multi_use(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_x_sub_64_multi_use:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 glc
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v2
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 64, v3
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_x_sub_64_multi_use:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64 glc
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 glc
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffc0, v3
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    buffer_store_dword v3, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_x_sub_64_multi_use:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1] glc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    flat_load_dword v4, v[0:1] glc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    v_subrev_u32_e32 v2, vcc, 64, v3
; VI-SDAG-NEXT:    v_subrev_u32_e32 v3, vcc, 64, v4
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v3
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_x_sub_64_multi_use:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1] glc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    flat_load_dword v4, v[0:1] glc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 0xffffffc0, v3
; VI-GISEL-NEXT:    v_add_u32_e32 v3, vcc, 0xffffffc0, v4
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v3
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v2, v0, s[2:3] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_subrev_u32_e32 v1, 64, v1
; GFX9-SDAG-NEXT:    v_subrev_u32_e32 v2, 64, v2
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v2, v0, s[2:3] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, 0xffffffc0, v1
; GFX9-GISEL-NEXT:    v_add_u32_e32 v2, 0xffffffc0, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v1, v0, s[2:3] glc dlc
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v2, v0, s[2:3] glc dlc
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_subrev_nc_u32_e32 v1, 64, v1
; GFX10-SDAG-NEXT:    v_subrev_nc_u32_e32 v2, 64, v2
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-SDAG-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v1, v0, s[2:3] glc dlc
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v2, v0, s[2:3] glc dlc
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, 0xffffffc0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, 0xffffffc0, v2
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-GISEL-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v2, v0, s[2:3] glc dlc
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_subrev_nc_u32_e32 v1, 64, v1
; GFX11-SDAG-NEXT:    v_subrev_nc_u32_e32 v2, 64, v2
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1] dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    global_store_b32 v0, v2, s[0:1] dlc
; GFX11-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_test_i32_x_sub_64_multi_use:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[2:3] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v2, v0, s[2:3] glc dlc
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v1, 0xffffffc0, v1
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v2, 0xffffffc0, v2
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1] dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    global_store_b32 v0, v2, s[0:1] dlc
; GFX11-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load volatile i32, ptr addrspace(1) %gep
  %y = load volatile i32, ptr addrspace(1) %gep
  %result0 = sub i32 %x, 64
  %result1 = sub i32 %y, 64
  store volatile i32 %result0, ptr addrspace(1) %gep.out
  store volatile i32 %result1, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_64_sub_x(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_64_sub_x:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_sub_i32_e32 v2, vcc, 64, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_64_sub_x:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_sub_i32_e32 v2, vcc, 64, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_64_sub_x:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u32_e32 v2, vcc, 64, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_64_sub_x:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_sub_u32_e32 v2, vcc, 64, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_64_sub_x:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v1, 64, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_64_sub_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 64, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_64_sub_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 64, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 64, %x
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_x_sub_65(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_x_sub_65:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffbf, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_x_sub_65:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffbf, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_x_sub_65:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 0xffffffbf, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_x_sub_65:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 0xffffffbf, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_x_sub_65:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v1, 0xffffffbf, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_x_sub_65:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0xffffffbf, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_x_sub_65:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0xffffffbf, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 %x, 65
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_65_sub_x(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_65_sub_x:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_sub_i32_e32 v2, vcc, 0x41, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_65_sub_x:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_sub_i32_e32 v2, vcc, 0x41, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_65_sub_x:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u32_e32 v2, vcc, 0x41, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_65_sub_x:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_sub_u32_e32 v2, vcc, 0x41, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_65_sub_x:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v1, 0x41, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_65_sub_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0x41, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_65_sub_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0x41, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 65, %x
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_x_sub_neg16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_x_sub_neg16:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 16, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_x_sub_neg16:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 16, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_x_sub_neg16:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 16, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_x_sub_neg16:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 16, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_x_sub_neg16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v1, 16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_x_sub_neg16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 16, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_x_sub_neg16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 16, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 %x, -16
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_neg16_sub_x(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_neg16_sub_x:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_sub_i32_e32 v2, vcc, -16, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_neg16_sub_x:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_sub_i32_e32 v2, vcc, -16, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_neg16_sub_x:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u32_e32 v2, vcc, -16, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_neg16_sub_x:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_sub_u32_e32 v2, vcc, -16, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_neg16_sub_x:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v1, -16, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_neg16_sub_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, -16, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_neg16_sub_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, -16, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 -16, %x
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_x_sub_neg17(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_x_sub_neg17:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 17, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_x_sub_neg17:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 17, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_x_sub_neg17:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u32_e32 v2, vcc, 17, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_x_sub_neg17:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u32_e32 v2, vcc, 17, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_x_sub_neg17:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v1, 17, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_x_sub_neg17:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 17, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_x_sub_neg17:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 17, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 %x, -17
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i32_neg17_sub_x(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i32_neg17_sub_x:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_sub_i32_e32 v2, vcc, 0xffffffef, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i32_neg17_sub_x:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_sub_i32_e32 v2, vcc, 0xffffffef, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i32_neg17_sub_x:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u32_e32 v2, vcc, 0xffffffef, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i32_neg17_sub_x:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_sub_u32_e32 v2, vcc, 0xffffffef, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_i32_neg17_sub_x:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_sub_u32_e32 v1, 0xffffffef, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_i32_neg17_sub_x:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0xffffffef, v1
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_i32_neg17_sub_x:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0xffffffef, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i32, ptr addrspace(1) %gep
  %result = sub i32 -17, %x
  store i32 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @s_test_i32_x_sub_64(i32 %x) #0 {
; SI-LABEL: s_test_i32_x_sub_64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s0, s[4:5], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_sub_i32 s0, s0, 64
; SI-NEXT:    ;;#ASMSTART
; SI-NEXT:    ; use s0
; SI-NEXT:    ;;#ASMEND
; SI-NEXT:    s_endpgm
;
; VI-LABEL: s_test_i32_x_sub_64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s0, s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_sub_i32 s0, s0, 64
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s0
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_test_i32_x_sub_64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_sub_i32 s0, s0, 64
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s0
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: s_test_i32_x_sub_64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x24
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_sub_i32 s0, s0, 64
; GFX10-NEXT:    ;;#ASMSTART
; GFX10-NEXT:    ; use s0
; GFX10-NEXT:    ;;#ASMEND
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: s_test_i32_x_sub_64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_sub_i32 s0, s0, 64
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_endpgm
  %result = sub i32 %x, 64
  call void asm sideeffect "; use $0", "s"(i32 %result)
  ret void
}

define amdgpu_kernel void @v_test_i16_x_sub_64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i16_x_sub_64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v2
; SI-SDAG-NEXT:    buffer_store_short v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i16_x_sub_64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_short v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i16_x_sub_64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_ushort v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_subrev_u16_e32 v2, 64, v3
; VI-SDAG-NEXT:    flat_store_short v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i16_x_sub_64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_ushort v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v3
; VI-GISEL-NEXT:    flat_store_short v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_i16_x_sub_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_subrev_u16_e32 v1, 64, v1
; GFX9-SDAG-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_i16_x_sub_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, 0xffc0, v1
; GFX9-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_i16_x_sub_64:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX10-SDAG-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_i16_x_sub_64:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX10-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: v_test_i16_x_sub_64:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    global_load_u16 v0, v1, s[2:3]
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_sub_nc_u16 v0.l, v0.l, 64
; GFX11-SDAG-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: v_test_i16_x_sub_64:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX11-SDAG-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-TRUE16-LABEL: v_test_i16_x_sub_64:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0xffc0, v1.l
; GFX11-GISEL-TRUE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-GISEL-TRUE16-NEXT:    s_endpgm
;
; GFX11-GISEL-FAKE16-LABEL: v_test_i16_x_sub_64:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX11-GISEL-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-GISEL-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i16, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i16, ptr addrspace(1) %gep
  %result = sub i16 %x, 64
  store i16 %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i16_x_sub_64_zext_to_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_ushort v3, v[1:2], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v0, vcc, 64, v3
; SI-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-SDAG-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_ushort v3, v[1:2], s[4:7], 0 addr64
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v0, vcc, 0xffffffc0, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v0, v[1:2], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-SDAG-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-SDAG-NEXT:    flat_load_ushort v2, v[1:2]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_subrev_u16_e32 v2, 64, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 1, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; VI-GISEL-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-GISEL-NEXT:    flat_load_ushort v2, v[1:2]
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v3
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_subrev_u16_e32 v1, 64, v1
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, 0xffc0, v1
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ushort v1, v1, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v1
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    global_load_u16 v0, v0, s[2:3]
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_sub_nc_u16 v0.l, v0.l, 64
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-TRUE16-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    global_load_u16 v1, v1, s[2:3]
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-SDAG-FAKE16-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-TRUE16-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-TRUE16-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v1
; GFX11-GISEL-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    global_load_u16 v0, v0, s[2:3]
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0xffc0, v0.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-TRUE16-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-GISEL-TRUE16-NEXT:    s_endpgm
;
; GFX11-GISEL-FAKE16-LABEL: v_test_i16_x_sub_64_zext_to_i32:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX11-GISEL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    global_load_u16 v1, v1, s[2:3]
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-GISEL-FAKE16-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i16, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i32, ptr addrspace(1) %out, i64 %tid.ext
  %x = load i16, ptr addrspace(1) %gep
  %result = sub i16 %x, 64
  %zext = zext i16 %result to i32
  store i32 %zext, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_i16_x_sub_64_multi_use(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_i16_x_sub_64_multi_use:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 glc
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    buffer_load_ushort v3, v[0:1], s[4:7], 0 addr64 glc
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v2
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 64, v3
; SI-SDAG-NEXT:    buffer_store_short v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    buffer_store_short v3, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_i16_x_sub_64_multi_use:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 glc
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    buffer_load_ushort v3, v[0:1], s[4:7], 0 addr64 glc
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffc0, v3
; SI-GISEL-NEXT:    buffer_store_short v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    buffer_store_short v3, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_i16_x_sub_64_multi_use:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_ushort v3, v[0:1] glc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    v_subrev_u16_e32 v2, 64, v3
; VI-SDAG-NEXT:    v_subrev_u16_e32 v3, 64, v4
; VI-SDAG-NEXT:    flat_store_short v[0:1], v2
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    flat_store_short v[0:1], v3
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_i16_x_sub_64_multi_use:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_ushort v3, v[0:1] glc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    flat_load_ushort v4, v[0:1] glc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v3
; VI-GISEL-NEXT:    v_add_u16_e32 v3, 0xffc0, v4
; VI-GISEL-NEXT:    flat_store_short v[0:1], v2
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    flat_store_short v[0:1], v3
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_ushort v1, v0, s[2:3] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    global_load_ushort v2, v0, s[2:3] glc
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_subrev_u16_e32 v1, 64, v1
; GFX9-SDAG-NEXT:    v_subrev_u16_e32 v2, 64, v2
; GFX9-SDAG-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    global_store_short v0, v2, s[0:1]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ushort v1, v0, s[2:3] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    global_load_ushort v2, v0, s[2:3] glc
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, 0xffc0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v2
; GFX9-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    global_store_short v0, v2, s[0:1]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_ushort v1, v0, s[2:3] glc dlc
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    global_load_ushort v2, v0, s[2:3] glc dlc
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX10-SDAG-NEXT:    v_sub_nc_u16 v2, v2, 64
; GFX10-SDAG-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-SDAG-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-SDAG-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ushort v1, v0, s[2:3] glc dlc
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    global_load_ushort v2, v0, s[2:3] glc dlc
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, 0xffc0, v2
; GFX10-GISEL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-GISEL-NEXT:    global_store_short v0, v2, s[0:1]
; GFX10-GISEL-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-TRUE16-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    global_load_u16 v0, v1, s[2:3] glc dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    global_load_u16 v2, v1, s[2:3] glc dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_sub_nc_u16 v0.l, v0.l, 64
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_sub_nc_u16 v0.h, v0.h, 64
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    global_store_b16 v1, v2, s[0:1] dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1] dlc
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-TRUE16-NEXT:    s_endpgm
;
; GFX11-SDAG-FAKE16-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    global_load_u16 v2, v0, s[2:3] glc dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_sub_nc_u16 v1, v1, 64
; GFX11-SDAG-FAKE16-NEXT:    v_sub_nc_u16 v2, v2, 64
; GFX11-SDAG-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1] dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    global_store_b16 v0, v2, s[0:1] dlc
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-SDAG-FAKE16-NEXT:    s_endpgm
;
; GFX11-GISEL-TRUE16-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX11-GISEL-TRUE16:       ; %bb.0:
; GFX11-GISEL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    global_load_u16 v2, v0, s[2:3] glc dlc
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0xffc0, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0xffc0, v2.l
; GFX11-GISEL-TRUE16-NEXT:    global_store_b16 v0, v1, s[0:1] dlc
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-TRUE16-NEXT:    global_store_b16 v0, v2, s[0:1] dlc
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-TRUE16-NEXT:    s_endpgm
;
; GFX11-GISEL-FAKE16-LABEL: v_test_i16_x_sub_64_multi_use:
; GFX11-GISEL-FAKE16:       ; %bb.0:
; GFX11-GISEL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    global_load_u16 v1, v0, s[2:3] glc dlc
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    global_load_u16 v2, v0, s[2:3] glc dlc
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u16 v1, 0xffc0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_add_nc_u16 v2, 0xffc0, v2
; GFX11-GISEL-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1] dlc
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-FAKE16-NEXT:    global_store_b16 v0, v2, s[0:1] dlc
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-GISEL-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i16, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %x = load volatile i16, ptr addrspace(1) %gep
  %y = load volatile i16, ptr addrspace(1) %gep
  %result0 = sub i16 %x, 64
  %result1 = sub i16 %y, 64
  store volatile i16 %result0, ptr addrspace(1) %gep.out
  store volatile i16 %result1, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_sub_64_64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_64_64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 64, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffc00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_64_64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffc0, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_64_64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 64
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u16_sdwa v2, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_subrev_u16_e32 v3, 64, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_64_64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_not_b32_e32 v4, 63
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_sub_64_64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v1, v1, 64 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_64_64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 64 op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_64_64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 64 op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 64, i16 64>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_sub_7_64(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_7_64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, -7, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffc00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_7_64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, -7, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffc0, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_7_64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 64
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, -7, v3
; VI-SDAG-NEXT:    v_sub_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_7_64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_not_b32_e32 v4, 63
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, -7, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_sub_7_64:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_mov_b32 s2, 0x400007
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_i16 v1, v1, s2
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_sub_7_64:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x400007
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_sub_i16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_7_64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 0x400007
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_7_64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 0x400007
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 7, i16 64>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_sub_64_123(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_64_123:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 64, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xff850000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_64_123:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffc0, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffff85, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_64_123:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff85
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_sdwa v2, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_subrev_u16_e32 v3, 64, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_64_123:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff85
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffc0, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_sub_64_123:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_mov_b32 s2, 0x7b0040
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_i16 v1, v1, s2
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_sub_64_123:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7b0040
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_sub_i16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_64_123:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 0x7b0040
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_64_123:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 0x7b0040
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 64, i16 123>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

; Can fold 0 and inline immediate in other half.
define amdgpu_kernel void @v_test_v2i16_x_sub_7_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_7_0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, -7, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v3, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_7_0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, -7, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_7_0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-SDAG-NEXT:    v_add_u16_e32 v3, -7, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_7_0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; VI-GISEL-NEXT:    v_add_u16_e32 v3, -7, v3
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_sub_7_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v1, v1, 7
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_7_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 7
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_7_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 7
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 7, i16 0>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

; Can fold 0 and inline immediate in other half.
define amdgpu_kernel void @v_test_v2i16_x_sub_0_16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_0_16:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xfff00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_0_16:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, -16, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_0_16:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, -16
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_0_16:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, -16
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_sub_0_16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_i16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_0_16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_0_16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 0, i16 16>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_sub_0_1_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_0_1_0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0x3c000000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_0_1_0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0x3c00, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_0_1_0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 0x3c00
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_0_1_0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x3c00
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_sub_0_1_0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_brev_b32 s2, 35
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_i16 v1, v1, s2
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_sub_0_1_0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_bfrev_b32_e32 v2, 35
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_sub_i16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_0_1_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 0xc4000000
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_0_1_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 0xc4000000
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 0, i16 -15360>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_sub_0_neg1_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xbc000000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffbc00, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 0xffffbc00
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffffbc00
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_brev_b32 s2, 34
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_i16 v1, v1, s2
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_bfrev_b32_e32 v2, 34
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_sub_i16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_i16 v1, v1, 0x44000000
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_sub_0_neg1_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_i16 v1, v1, 0x44000000
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = sub <2 x i16> %x, <i16 0, i16 17408>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

; -32 isn't an inline immediate, but 32 is
define amdgpu_kernel void @v_test_v2i16_x_add_neg32_neg32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg32_neg32:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 32, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffe00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg32_neg32:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffe0, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffe0, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg32_neg32:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 32
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u16_sdwa v2, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_subrev_u16_e32 v3, 32, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg32_neg32:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_not_b32_e32 v4, 31
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffe0, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg32_neg32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg32_neg32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg32_neg32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -32, i16 -32>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_0_neg32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_0_neg32:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffe00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_0_neg32:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffffe0, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_0_neg32:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 32
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_0_neg32:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_not_b32_e32 v2, 31
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_0_neg32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_0_neg32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_0_neg32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 0, i16 -32>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg32_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg32_0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v3, vcc, 32, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v3, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg32_0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffe0, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg32_0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-SDAG-NEXT:    v_subrev_u16_e32 v3, 32, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg32_0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; VI-GISEL-NEXT:    v_add_u16_e32 v3, 0xffe0, v3
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg32_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg32_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg32_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -32, i16 0>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

; 16 and -16 are both inline immediates
define amdgpu_kernel void @v_test_v2i16_x_add_neg16_neg16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg16_neg16:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, -16, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xfff00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg16_neg16:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, -16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, -16, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg16_neg16:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, -16
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, -16, v3
; VI-SDAG-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg16_neg16:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, -16
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, -16, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg16_neg16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v1, v1, -16 op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg16_neg16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_u16 v1, v1, -16 op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg16_neg16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_u16 v1, v1, -16 op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -16, i16 -16>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_0_neg16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_0_neg16:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xfff00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_0_neg16:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, -16, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_0_neg16:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, -16
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_0_neg16:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, -16
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_0_neg16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_0_neg16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_0_neg16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 16 op_sel:[0,1] op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 0, i16 -16>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg16_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg16_0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, -16, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v3, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg16_0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, -16, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg16_0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-SDAG-NEXT:    v_add_u16_e32 v3, -16, v3
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg16_0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; VI-GISEL-NEXT:    v_add_u16_e32 v3, -16, v3
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 16
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg16_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 16
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 16
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -16, i16 0>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg_fpone(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg_fpone:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 0xffffc400, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xc4000000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg_fpone:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffc400, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffc400, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg_fpone:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffc400
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, 0xc400, v3
; VI-SDAG-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg_fpone:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffc400
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xc400, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_movk_i32 s2, 0xc400
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v1, s2 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xc400c400
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, 0xffffc400, v1 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, 0xc400c400, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_add_u16 v1, 0xffffc400, v1 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_test_v2i16_x_add_neg_fpone:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, 0xc400c400, v1
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -15360, i16 -15360>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg_negfpone(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg_negfpone:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 0x4400, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0x44000000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg_negfpone:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0x4400, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0x4400, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg_negfpone:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4400
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, 0x4400, v3
; VI-SDAG-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg_negfpone:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x4400
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0x4400, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_movk_i32 s2, 0x4400
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v1, s2 op_sel_hi:[1,0]
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0x44004400
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, 0x4400, v1 op_sel_hi:[0,1]
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, 0x44004400, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_add_u16 v1, 0x4400, v1 op_sel_hi:[0,1]
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_test_v2i16_x_add_neg_negfpone:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, 0x44004400, v1
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 17408, i16 17408>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg_fptwo(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg_fptwo:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 0x4000, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 2.0, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg_fptwo:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0x4000, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0x4000, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg_fptwo:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, 0x4000, v3
; VI-SDAG-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg_fptwo:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x4000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0x4000, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg_fptwo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 2.0 op_sel:[0,1]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg_fptwo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_u16 v1, v1, 2.0 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg_fptwo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 2.0 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 16384, i16 16384>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg_negfptwo(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_add_i32_e32 v3, vcc, 0xffffc000, v2
; SI-SDAG-NEXT:    s_mov_b32 s4, 0xffff0000
; SI-SDAG-NEXT:    v_bfi_b32 v2, s4, v2, v3
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, -2.0, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffc000, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v3, vcc, 0xffffc000, v3
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffc000
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_add_u16_e32 v2, 0xc000, v3
; VI-SDAG-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffc000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xc000, v3
; VI-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_add_u16 v1, v1, -2.0 op_sel:[0,1]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_u16 v1, v1, -2.0 op_sel:[0,1]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_neg_negfptwo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_u16 v1, v1, -2.0 op_sel:[0,1]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -16384, i16 -16384>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_undef_neg32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_undef_neg32:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; SI-SDAG-NEXT:    v_add_i32_e32 v2, vcc, 0xffe00000, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_undef_neg32:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffe0, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_undef_neg32:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 32
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_sub_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_undef_neg32:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_not_b32_e32 v2, 31
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    s_and_b32 s0, 0xffff, s0
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v2, s0, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-LABEL: v_test_v2i16_x_add_undef_neg32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: v_test_v2i16_x_add_undef_neg32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: v_test_v2i16_x_add_undef_neg32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_sub_u16 v1, v1, 32 op_sel:[0,1] op_sel_hi:[1,0]
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 undef, i16 -32>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @v_test_v2i16_x_add_neg32_undef(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-SDAG-LABEL: v_test_v2i16_x_add_neg32_undef:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-SDAG-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-SDAG-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_subrev_i32_e32 v2, vcc, 32, v2
; SI-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-SDAG-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: v_test_v2i16_x_add_neg32_undef:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_mov_b32 s7, 0xf000
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-GISEL-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; SI-GISEL-NEXT:    v_add_i32_e32 v2, vcc, 0xffffffe0, v2
; SI-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-GISEL-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-GISEL-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: v_test_v2i16_x_add_neg32_undef:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    flat_load_dword v3, v[0:1]
; VI-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; VI-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_subrev_u16_e32 v2, 32, v3
; VI-SDAG-NEXT:    flat_store_dword v[0:1], v2
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: v_test_v2i16_x_add_neg32_undef:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    flat_load_dword v3, v[0:1]
; VI-GISEL-NEXT:    s_and_b32 s2, 0xffff, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; VI-GISEL-NEXT:    s_lshl_b32 s0, s2, 16
; VI-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0)
; VI-GISEL-NEXT:    v_add_u16_e32 v2, 0xffe0, v3
; VI-GISEL-NEXT:    v_or_b32_e32 v2, s0, v2
; VI-GISEL-NEXT:    flat_store_dword v[0:1], v2
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX9-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-GISEL-NEXT:    v_not_b32_e32 v2, 31
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v2
; GFX9-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX10-SDAG-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX10-SDAG:       ; %bb.0:
; GFX10-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-SDAG-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX10-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-SDAG-NEXT:    s_endpgm
;
; GFX10-GISEL-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX10-GISEL:       ; %bb.0:
; GFX10-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-GISEL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, 0xffffffe0, v1
; GFX10-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_pk_sub_u16 v1, v1, 32
; GFX11-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: v_test_v2i16_x_add_neg32_undef:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, 0xffffffe0, v1
; GFX11-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %gep.out = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %x = load <2 x i16>, ptr addrspace(1) %gep
  %result = add <2 x i16> %x, <i16 -32, i16 undef>
  store <2 x i16> %result, ptr addrspace(1) %gep.out
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
