; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds < %s --amdgpu-lower-module-lds-strategy=module | FileCheck -check-prefixes=CHECK,M_OR_HY %s
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds < %s --amdgpu-lower-module-lds-strategy=table | FileCheck -check-prefixes=CHECK,TABLE %s
; RUN: not --crash opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds < %s --amdgpu-lower-module-lds-strategy=kernel 2>&1 | FileCheck -check-prefixes=KERNEL %s
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds < %s --amdgpu-lower-module-lds-strategy=hybrid | FileCheck -check-prefixes=CHECK,M_OR_HY %s

;; Two kernels access the same variable, specialisation gives them each their own copy of it

@kernel.lds = addrspace(3) global i8 undef
define amdgpu_kernel void @k0() {
; CHECK-LABEL: @k0(
; CHECK-NEXT:    [[LD:%.*]] = load i8, ptr addrspace(3) @llvm.amdgcn.kernel.k0.lds, align 1
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[LD]], 2
; CHECK-NEXT:    store i8 [[MUL]], ptr addrspace(3) @llvm.amdgcn.kernel.k0.lds, align 1
; CHECK-NEXT:    ret void
;
  %ld = load i8, ptr addrspace(3) @kernel.lds
  %mul = mul i8 %ld, 2
  store i8 %mul, ptr  addrspace(3) @kernel.lds
  ret void
}

define amdgpu_kernel void @k1() {
; CHECK-LABEL: @k1(
; CHECK-NEXT:    [[LD:%.*]] = load i8, ptr addrspace(3) @llvm.amdgcn.kernel.k1.lds, align 1
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[LD]], 3
; CHECK-NEXT:    store i8 [[MUL]], ptr addrspace(3) @llvm.amdgcn.kernel.k1.lds, align 1
; CHECK-NEXT:    ret void
;
  %ld = load i8, ptr addrspace(3) @kernel.lds
  %mul = mul i8 %ld, 3
  store i8 %mul, ptr  addrspace(3) @kernel.lds
  ret void
}

;; Function accesses variable, reachable from two kernels, can't use kernel lowering for either
;; Hybrid can put it in module lds without cost as the first variable is free

; KERNEL: LLVM ERROR: cannot lower LDS 'function.lds' to kernel access as it is reachable from multiple kernels

@function.lds = addrspace(3) global i16 undef
define void @f0() {
; M_OR_HY-LABEL: @f0(
; M_OR_HY-NEXT:    [[LD:%.*]] = load i16, ptr addrspace(3) @llvm.amdgcn.module.lds, align 2
; M_OR_HY-NEXT:    [[MUL:%.*]] = mul i16 [[LD]], 4
; M_OR_HY-NEXT:    store i16 [[MUL]], ptr addrspace(3) @llvm.amdgcn.module.lds, align 2
; M_OR_HY-NEXT:    ret void
;
; TABLE-LABEL: @f0(
; TABLE-NEXT:    [[TMP1:%.*]] = call i32 @llvm.amdgcn.lds.kernel.id()
; TABLE-NEXT:    [[FUNCTION_LDS2:%.*]] = getelementptr inbounds [2 x [1 x i32]], ptr addrspace(4) @llvm.amdgcn.lds.offset.table, i32 0, i32 [[TMP1]], i32 0
; TABLE-NEXT:    [[TMP2:%.*]] = load i32, ptr addrspace(4) [[FUNCTION_LDS2]], align 4
; TABLE-NEXT:    [[FUNCTION_LDS3:%.*]] = inttoptr i32 [[TMP2]] to ptr addrspace(3)
; TABLE-NEXT:    [[LD:%.*]] = load i16, ptr addrspace(3) [[FUNCTION_LDS3]], align 2
; TABLE-NEXT:    [[MUL:%.*]] = mul i16 [[LD]], 4
; TABLE-NEXT:    [[FUNCTION_LDS:%.*]] = getelementptr inbounds [2 x [1 x i32]], ptr addrspace(4) @llvm.amdgcn.lds.offset.table, i32 0, i32 [[TMP1]], i32 0
; TABLE-NEXT:    [[TMP3:%.*]] = load i32, ptr addrspace(4) [[FUNCTION_LDS]], align 4
; TABLE-NEXT:    [[FUNCTION_LDS1:%.*]] = inttoptr i32 [[TMP3]] to ptr addrspace(3)
; TABLE-NEXT:    store i16 [[MUL]], ptr addrspace(3) [[FUNCTION_LDS1]], align 2
; TABLE-NEXT:    ret void
;
  %ld = load i16, ptr addrspace(3) @function.lds
  %mul = mul i16 %ld, 4
  store i16 %mul, ptr  addrspace(3) @function.lds
  ret void
}


define amdgpu_kernel void @k0_f0() {
; M_OR_HY-LABEL: @k0_f0(
; M_OR_HY-NEXT:    call void @llvm.donothing() [ "ExplicitUse"(ptr addrspace(3) @llvm.amdgcn.module.lds) ]
; M_OR_HY-NEXT:    call void @f0()
; M_OR_HY-NEXT:    ret void
;
; TABLE-LABEL: @k0_f0(
; TABLE-NEXT:    call void @llvm.donothing() [ "ExplicitUse"(ptr addrspace(3) @llvm.amdgcn.kernel.k0_f0.lds) ]
; TABLE-NEXT:    call void @f0()
; TABLE-NEXT:    ret void
;
  call void @f0()
  ret void
}

define amdgpu_kernel void @k1_f0() {
; M_OR_HY-LABEL: @k1_f0(
; M_OR_HY-NEXT:    call void @llvm.donothing() [ "ExplicitUse"(ptr addrspace(3) @llvm.amdgcn.module.lds) ]
; M_OR_HY-NEXT:    call void @f0()
; M_OR_HY-NEXT:    ret void
;
; TABLE-LABEL: @k1_f0(
; TABLE-NEXT:    call void @llvm.donothing() [ "ExplicitUse"(ptr addrspace(3) @llvm.amdgcn.kernel.k1_f0.lds) ]
; TABLE-NEXT:    call void @f0()
; TABLE-NEXT:    ret void
;
  call void @f0()
  ret void
}
