; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-- -amdgpu-lower-module-lds --amdgpu-lower-module-lds-strategy=module < %s | FileCheck %s
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds --amdgpu-lower-module-lds-strategy=module < %s | FileCheck %s

@var = addrspace(3) global i32 undef, align 4

; Regression test. Duplicate constantexpr in phi nodes shall not emit broken IR
define amdgpu_kernel void @func(i32 %c) {
; CHECK-LABEL: @func(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i32 [[C:%.*]], label [[RETURN:%.*]] [
; CHECK-NEXT:    i32 0, label [[BB0:%.*]]
; CHECK-NEXT:    i32 1, label [[BB1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       bb0:
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr addrspace(3) @llvm.amdgcn.kernel.func.lds to ptr
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) @llvm.amdgcn.kernel.func.lds to ptr
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[TMP:%.*]] = phi ptr [ [[TMP0]], [[BB0]] ], [ [[TMP1]], [[BB1]] ]
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  switch i32 %c, label %return [
  i32 0, label %bb0
  i32 1, label %bb1
  ]

bb0:
  br label %bb2

bb1:
  br label %bb2

bb2:
  %tmp = phi ptr [ addrspacecast (ptr addrspace(3) @var to ptr), %bb0 ], [ addrspacecast (ptr addrspace(3) @var to ptr), %bb1 ]
  br label %return

return:
  ret void
}
