; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;RUN: llc < %s -mtriple=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck --check-prefixes=GFX6 %s
;RUN: llc < %s -mtriple=amdgcn -mcpu=tonga -verify-machineinstrs | FileCheck --check-prefixes=GFX8PLUS %s
;RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck --check-prefixes=GFX11 %s
;RUN: llc < %s -mtriple=amdgcn -mattr=-enable-prt-strict-null -mcpu=gfx1100 -verify-machineinstrs | FileCheck --check-prefixes=NOPRT %s

define amdgpu_ps {<4 x float>, <4 x float>, <4 x float>} @buffer_load(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v8, 0
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 0 idxen
; GFX6-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], 0 idxen glc
; GFX6-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], 0 idxen slc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v8, 0
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 0 idxen
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], 0 idxen glc
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], 0 idxen slc
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 0 idxen
; GFX11-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], 0 idxen glc
; GFX11-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], 0 idxen slc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v8, 0
; NOPRT-NEXT:    s_clause 0x2
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 0 idxen
; NOPRT-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], 0 idxen glc
; NOPRT-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], 0 idxen slc
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 0, i32 0, i32 0)
  %data_glc = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 0, i32 0, i32 1)
  %data_slc = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 0, i32 0, i32 2)
  %r0 = insertvalue {<4 x float>, <4 x float>, <4 x float>} undef, <4 x float> %data, 0
  %r1 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r0, <4 x float> %data_glc, 1
  %r2 = insertvalue {<4 x float>, <4 x float>, <4 x float>} %r1, <4 x float> %data_slc, 2
  ret {<4 x float>, <4 x float>, <4 x float>} %r2
}

define amdgpu_ps <4 x float> @buffer_load_immoffs(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_immoffs:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:42
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_immoffs:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, 0
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:42
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_immoffs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:42
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_immoffs:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v0, 0
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:42
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 42, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_immoffs_large(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_immoffs_large:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v8, 0
; GFX6-NEXT:    s_movk_i32 s4, 0x7ffc
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 60 idxen offset:4092
; GFX6-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], s4 idxen offset:4092
; GFX6-NEXT:    s_mov_b32 s4, 0x8ffc
; GFX6-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], s4 idxen offset:4
; GFX6-NEXT:    s_waitcnt vmcnt(1)
; GFX6-NEXT:    v_add_f32_e32 v3, v3, v7
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v0, v8, v0
; GFX6-NEXT:    v_add_f32_e32 v1, v9, v1
; GFX6-NEXT:    v_add_f32_e32 v2, v10, v2
; GFX6-NEXT:    v_add_f32_e32 v3, v11, v3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_immoffs_large:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v8, 0
; GFX8PLUS-NEXT:    s_movk_i32 s4, 0x7ffc
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 60 idxen offset:4092
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], s4 idxen offset:4092
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0x8ffc
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], s4 idxen offset:4
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(1)
; GFX8PLUS-NEXT:    v_add_f32_e32 v3, v3, v7
; GFX8PLUS-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8PLUS-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX8PLUS-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    v_add_f32_e32 v0, v8, v0
; GFX8PLUS-NEXT:    v_add_f32_e32 v1, v9, v1
; GFX8PLUS-NEXT:    v_add_f32_e32 v2, v10, v2
; GFX8PLUS-NEXT:    v_add_f32_e32 v3, v11, v3
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_immoffs_large:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v8, 0
; GFX11-NEXT:    s_movk_i32 s4, 0x7ffc
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 60 idxen offset:4092
; GFX11-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], s4 idxen offset:4092
; GFX11-NEXT:    s_mov_b32 s4, 0x8ffc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX11-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], s4 idxen offset:4
; GFX11-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v3, v3, v7
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v1, v9, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_dual_add_f32 v0, v8, v0 :: v_dual_add_f32 v3, v11, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v10, v2
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_immoffs_large:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v8, 0
; NOPRT-NEXT:    s_movk_i32 s4, 0x7ffc
; NOPRT-NEXT:    s_clause 0x1
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v8, s[0:3], 60 idxen offset:4092
; NOPRT-NEXT:    buffer_load_format_xyzw v[4:7], v8, s[0:3], s4 idxen offset:4092
; NOPRT-NEXT:    s_mov_b32 s4, 0x8ffc
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_add_f32_e32 v1, v1, v5
; NOPRT-NEXT:    buffer_load_format_xyzw v[8:11], v8, s[0:3], s4 idxen offset:4
; NOPRT-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v3, v3, v7
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v1, v9, v1
; NOPRT-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; NOPRT-NEXT:    v_dual_add_f32 v0, v8, v0 :: v_dual_add_f32 v3, v11, v3
; NOPRT-NEXT:    v_add_f32_e32 v2, v10, v2
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %d.0 = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 4092, i32 60, i32 0)
  %d.1 = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 4092, i32 32764, i32 0)
  %d.2 = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 4, i32 36860, i32 0)
  %d.3 = fadd <4 x float> %d.0, %d.1
  %data = fadd <4 x float> %d.2, %d.3
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_12bit(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_voffset_large_12bit:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:4092
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_voffset_large_12bit:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, 0
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:4092
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_12bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_voffset_large_12bit:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v0, 0
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen offset:4092
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 4092, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_13bit(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_voffset_large_13bit:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x1000
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_voffset_large_13bit:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, 0x1000
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_13bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0x1000 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_voffset_large_13bit:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, 0x1000 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 8188, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_16bit(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_voffset_large_16bit:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xf000
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_voffset_large_16bit:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, 0xf000
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_16bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0xf000 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_voffset_large_16bit:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, 0xf000 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 65532, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_23bit(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_voffset_large_23bit:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x7ff000
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_voffset_large_23bit:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, 0x7ff000
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_23bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0x7ff000 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_voffset_large_23bit:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, 0x7ff000 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 8388604, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_voffset_large_24bit(ptr addrspace(8) inreg) {
; GFX6-LABEL: buffer_load_voffset_large_24bit:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xfff000
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_voffset_large_24bit:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, 0xfff000
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_voffset_large_24bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, 0xfff000 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_voffset_large_24bit:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, 0xfff000 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:4092
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 16777212, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_idx(ptr addrspace(8) inreg, i32) {
; GFX6-LABEL: buffer_load_idx:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_idx:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_idx:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_idx:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v0, s[0:3], 0 idxen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 %1, i32 0, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_ofs(ptr addrspace(8) inreg, i32) {
; GFX6-LABEL: buffer_load_ofs:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, v0
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_ofs:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, v0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_ofs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_ofs:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 %1, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_ofs_imm(ptr addrspace(8) inreg, i32) {
; GFX6-LABEL: buffer_load_ofs_imm:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    s_mov_b32 s4, 0
; GFX6-NEXT:    v_mov_b32_e32 v1, v0
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:60
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_ofs_imm:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    s_mov_b32 s4, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v1, v0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, s4
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:60
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_ofs_imm:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, s4
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:60
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_ofs_imm:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    s_mov_b32 s4, 0
; NOPRT-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; NOPRT-NEXT:    v_dual_mov_b32 v1, v0 :: v_dual_mov_b32 v0, s4
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen offset:60
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %ofs = add i32 %1, 60
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 0, i32 %ofs, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_both(ptr addrspace(8) inreg, i32, i32) {
; GFX6-LABEL: buffer_load_both:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_both:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_both:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_both:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[0:1], s[0:3], 0 idxen offen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 %1, i32 %2, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps <4 x float> @buffer_load_both_reversed(ptr addrspace(8) inreg, i32, i32) {
; GFX6-LABEL: buffer_load_both_reversed:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v2, v0
; GFX6-NEXT:    buffer_load_format_xyzw v[0:3], v[1:2], s[0:3], 0 idxen offen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_both_reversed:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, v0
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[0:3], v[1:2], s[0:3], 0 idxen offen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_both_reversed:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v[1:2], s[0:3], 0 idxen offen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_both_reversed:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v2, v0
; NOPRT-NEXT:    buffer_load_format_xyzw v[0:3], v[1:2], s[0:3], 0 idxen offen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8) %0, i32 %2, i32 %1, i32 0, i32 0)
  ret <4 x float> %data
}

define amdgpu_ps float @buffer_load_x(ptr addrspace(8) inreg %rsrc) {
; GFX6-LABEL: buffer_load_x:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_x:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, 0
; GFX8PLUS-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_x:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_x:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v0, 0
; NOPRT-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call float @llvm.amdgcn.struct.ptr.buffer.load.format.f32(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  ret float %data
}

define amdgpu_ps float @buffer_load_x_i32(ptr addrspace(8) inreg %rsrc) {
; GFX6-LABEL: buffer_load_x_i32:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_x_i32:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, 0
; GFX8PLUS-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_x_i32:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_x_i32:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v0, 0
; NOPRT-NEXT:    buffer_load_format_x v0, v0, s[0:3], 0 idxen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call i32 @llvm.amdgcn.struct.ptr.buffer.load.format.i32(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %fdata = bitcast i32 %data to float
  ret float %fdata
}

define amdgpu_ps <2 x float> @buffer_load_xy(ptr addrspace(8) inreg %rsrc) {
; GFX6-LABEL: buffer_load_xy:
; GFX6:       ; %bb.0: ; %main_body
; GFX6-NEXT:    v_mov_b32_e32 v0, 0
; GFX6-NEXT:    buffer_load_format_xy v[0:1], v0, s[0:3], 0 idxen
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_xy:
; GFX8PLUS:       ; %bb.0: ; %main_body
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, 0
; GFX8PLUS-NEXT:    buffer_load_format_xy v[0:1], v0, s[0:3], 0 idxen
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_xy:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    buffer_load_format_xy v[0:1], v0, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_xy:
; NOPRT:       ; %bb.0: ; %main_body
; NOPRT-NEXT:    v_mov_b32_e32 v0, 0
; NOPRT-NEXT:    buffer_load_format_xy v[0:1], v0, s[0:3], 0 idxen
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    ; return to shader part epilog
main_body:
  %data = call <2 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v2f32(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  ret <2 x float> %data
}

define amdgpu_cs float @buffer_load_v4i32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v4i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v6, v2
; GFX6-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v6
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v4i32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v5, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v6, v2
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx4 v[0:1], v[2:5]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v6
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v4i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v5, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v2
; GFX11-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v6
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v4i32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v6, 0
; NOPRT-NEXT:    buffer_load_format_xyzw v[2:6], v6, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b128 v[0:1], v[2:5], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v6
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <4 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v4i32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <4 x i32>, i32 } %load, 0
  store <4 x i32> %data, ptr addrspace(1) %out
  %status = extractvalue { <4 x i32>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_v4f32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v4f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v6, v2
; GFX6-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx4 v[2:5], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v6
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v4f32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v5, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v6, v2
; GFX8PLUS-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx4 v[0:1], v[2:5]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v6
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v4f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v5, v2
; GFX11-NEXT:    v_mov_b32_e32 v6, v2
; GFX11-NEXT:    buffer_load_format_xyzw v[2:6], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b128 v[0:1], v[2:5], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v6
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v4f32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v6, 0
; NOPRT-NEXT:    buffer_load_format_xyzw v[2:6], v6, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b128 v[0:1], v[2:5], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v6
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <4 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v4f32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <4 x float>, i32 } %load, 0
  store <4 x float> %data, ptr addrspace(1) %out
  %status = extractvalue { <4 x float>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_v3i32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v3i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v5
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v3i32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v5, v2
; GFX8PLUS-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx3 v[0:1], v[2:4]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v5
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v3i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v5, v2
; GFX11-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v5
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v3i32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    buffer_load_format_xyz v[2:5], v5, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b96 v[0:1], v[2:4], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v5
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <3 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v3i32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <3 x i32>, i32 } %load, 0
  store <3 x i32> %data, ptr addrspace(1) %out
  %status = extractvalue { <3 x i32>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_v3f32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v3f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v4, v[0:1], s[0:3], 0 addr64 offset:8
; GFX6-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v5
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v3f32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v5, v2
; GFX8PLUS-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx3 v[0:1], v[2:4]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v5
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v3f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    v_mov_b32_e32 v5, v2
; GFX11-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b96 v[0:1], v[2:4], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v5
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v3f32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v5, 0
; NOPRT-NEXT:    buffer_load_format_xyz v[2:5], v5, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b96 v[0:1], v[2:4], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v5
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <3 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v3f32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <3 x float>, i32 } %load, 0
  store <3 x float> %data, ptr addrspace(1) %out
  %status = extractvalue { <3 x float>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_v2i32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v2i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v2i32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    buffer_load_format_xy v[2:4], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v2i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    buffer_load_format_xy v[2:4], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v2i32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    buffer_load_format_xy v[2:4], v4, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b64 v[0:1], v[2:3], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v4
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <2 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v2i32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <2 x i32>, i32 } %load, 0
  store <2 x i32> %data, ptr addrspace(1) %out
  %status = extractvalue { <2 x i32>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_v2f32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_v2f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_load_format_xyz v[2:5], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v4
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_v2f32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v4, v2
; GFX8PLUS-NEXT:    buffer_load_format_xy v[2:4], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v4
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_v2f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    v_mov_b32_e32 v4, v2
; GFX11-NEXT:    buffer_load_format_xy v[2:4], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b64 v[0:1], v[2:3], off
; GFX11-NEXT:    v_mov_b32_e32 v0, v4
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_v2f32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v4, 0
; NOPRT-NEXT:    buffer_load_format_xy v[2:4], v4, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b64 v[0:1], v[2:3], off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v4
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { <2 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v2f32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { <2 x float>, i32 } %load, 0
  store <2 x float> %data, ptr addrspace(1) %out
  %status = extractvalue { <2 x float>, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_i32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_i32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_i32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dword v[0:1], v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v3
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_i32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_i32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    buffer_load_format_x v[2:3], v3, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b32 v[0:1], v2, off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { i32, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_i32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { i32, i32 } %load, 0
  store i32 %data, ptr addrspace(1) %out
  %status = extractvalue { i32, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

define amdgpu_cs float @buffer_load_f32_tfe(ptr addrspace(8) inreg %rsrc, ptr addrspace(1) %out) {
; GFX6-LABEL: buffer_load_f32_tfe:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v2, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, v2
; GFX6-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX6-NEXT:    s_mov_b32 s2, 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s0, s2
; GFX6-NEXT:    s_mov_b32 s1, s2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8PLUS-LABEL: buffer_load_f32_tfe:
; GFX8PLUS:       ; %bb.0:
; GFX8PLUS-NEXT:    v_mov_b32_e32 v2, 0
; GFX8PLUS-NEXT:    v_mov_b32_e32 v3, v2
; GFX8PLUS-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    flat_store_dword v[0:1], v2
; GFX8PLUS-NEXT:    v_mov_b32_e32 v0, v3
; GFX8PLUS-NEXT:    s_waitcnt vmcnt(0)
; GFX8PLUS-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: buffer_load_f32_tfe:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    buffer_load_format_x v[2:3], v2, s[0:3], 0 idxen tfe
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    ; return to shader part epilog
;
; NOPRT-LABEL: buffer_load_f32_tfe:
; NOPRT:       ; %bb.0:
; NOPRT-NEXT:    v_mov_b32_e32 v3, 0
; NOPRT-NEXT:    buffer_load_format_x v[2:3], v3, s[0:3], 0 idxen tfe
; NOPRT-NEXT:    s_waitcnt vmcnt(0)
; NOPRT-NEXT:    global_store_b32 v[0:1], v2, off
; NOPRT-NEXT:    v_mov_b32_e32 v0, v3
; NOPRT-NEXT:    ; return to shader part epilog
  %load = call { float, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_f32i32s(ptr addrspace(8) %rsrc, i32 0, i32 0, i32 0, i32 0)
  %data = extractvalue { float, i32 } %load, 0
  store float %data, ptr addrspace(1) %out
  %status = extractvalue { float, i32 } %load, 1
  %fstatus = bitcast i32 %status to float
  ret float %fstatus
}

declare float @llvm.amdgcn.struct.ptr.buffer.load.format.f32(ptr addrspace(8), i32, i32, i32, i32) #0
declare <2 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v2f32(ptr addrspace(8), i32, i32, i32, i32) #0
declare <4 x float> @llvm.amdgcn.struct.ptr.buffer.load.format.v4f32(ptr addrspace(8), i32, i32, i32, i32) #0
declare i32 @llvm.amdgcn.struct.ptr.buffer.load.format.i32(ptr addrspace(8), i32, i32, i32, i32) #0
declare { <4 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v4i32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { <4 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v4f32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { <3 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v3i32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { <3 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v3f32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { <2 x i32>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v2i32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { <2 x float>, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_v2f32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { i32, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_i32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
declare { float, i32 } @llvm.amdgcn.struct.ptr.buffer.load.format.sl_f32i32s(ptr addrspace(8), i32, i32, i32, i32 immarg) #0
attributes #0 = { nounwind readonly }
