; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE


target triple = "aarch64-unknown-linux-gnu"

define <4 x i8> @sdiv_v4i8(<4 x i8> %op1) {
; CHECK-LABEL: sdiv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sxtb z0.h, p0/m, z0.h
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp]
; NONEON-NOSVE-NEXT:    sxtb w11, w8
; NONEON-NOSVE-NEXT:    sxtb w13, w9
; NONEON-NOSVE-NEXT:    sxtb w14, w10
; NONEON-NOSVE-NEXT:    sxtb w15, w12
; NONEON-NOSVE-NEXT:    ubfx w11, w11, #10, #5
; NONEON-NOSVE-NEXT:    ubfx w13, w13, #10, #5
; NONEON-NOSVE-NEXT:    ubfx w14, w14, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w11
; NONEON-NOSVE-NEXT:    ubfx w11, w15, #10, #5
; NONEON-NOSVE-NEXT:    add w9, w9, w13
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    add w10, w10, w14
; NONEON-NOSVE-NEXT:    sxtb w9, w9
; NONEON-NOSVE-NEXT:    add w11, w12, w11
; NONEON-NOSVE-NEXT:    sxtb w10, w10
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    sxtb w11, w11
; NONEON-NOSVE-NEXT:    lsr w9, w9, #5
; NONEON-NOSVE-NEXT:    lsr w10, w10, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    lsr w8, w11, #5
; NONEON-NOSVE-NEXT:    strh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <4 x i8> %op1, shufflevector (<4 x i8> insertelement (<4 x i8> poison, i8 32, i32 0), <4 x i8> poison, <4 x i32> zeroinitializer)
  ret <4 x i8> %res
}

define <8 x i8> @sdiv_v8i8(<8 x i8> %op1) {
; CHECK-LABEL: sdiv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <8 x i8> %op1, shufflevector (<8 x i8> insertelement (<8 x i8> poison, i8 32, i32 0), <8 x i8> poison, <8 x i32> zeroinitializer)
  ret <8 x i8> %res
}

define <16 x i8> @sdiv_v16i8(<16 x i8> %op1) {
; CHECK-LABEL: sdiv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <16 x i8> %op1, shufflevector (<16 x i8> insertelement (<16 x i8> poison, i8 32, i32 0), <16 x i8> poison, <16 x i32> zeroinitializer)
  ret <16 x i8> %res
}

define void @sdiv_v32i8(ptr %a) {
; CHECK-LABEL: sdiv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    asrd z1.b, p0/m, z1.b, #5
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #10, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxtb w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = sdiv <32 x i8> %op1, shufflevector (<32 x i8> insertelement (<32 x i8> poison, i8 32, i32 0), <32 x i8> poison, <32 x i32> zeroinitializer)
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @sdiv_v2i16(<2 x i16> %op1) {
; CHECK-LABEL: sdiv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v2i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    sxth w10, w8
; NONEON-NOSVE-NEXT:    sxth w11, w9
; NONEON-NOSVE-NEXT:    ubfx w10, w10, #26, #5
; NONEON-NOSVE-NEXT:    ubfx w11, w11, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w10
; NONEON-NOSVE-NEXT:    add w9, w9, w11
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #5, #11
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #5, #11
; NONEON-NOSVE-NEXT:    stp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <2 x i16> %op1, shufflevector (<2 x i16> insertelement (<2 x i16> poison, i16 32, i32 0), <2 x i16> poison, <2 x i32> zeroinitializer)
  ret <2 x i16> %res
}

define <4 x i16> @sdiv_v4i16(<4 x i16> %op1) {
; CHECK-LABEL: sdiv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <4 x i16> %op1, shufflevector (<4 x i16> insertelement (<4 x i16> poison, i16 32, i32 0), <4 x i16> poison, <4 x i32> zeroinitializer)
  ret <4 x i16> %res
}

define <8 x i16> @sdiv_v8i16(<8 x i16> %op1) {
; CHECK-LABEL: sdiv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <8 x i16> %op1, shufflevector (<8 x i16> insertelement (<8 x i16> poison, i16 32, i32 0), <8 x i16> poison, <8 x i32> zeroinitializer)
  ret <8 x i16> %res
}

define void @sdiv_v16i16(ptr %a) {
; CHECK-LABEL: sdiv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    asrd z1.h, p0/m, z1.h, #5
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    ubfx w9, w8, #26, #5
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    sxth w8, w8
; NONEON-NOSVE-NEXT:    lsr w8, w8, #5
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sdiv <16 x i16> %op1, shufflevector (<16 x i16> insertelement (<16 x i16> poison, i16 32, i32 0), <16 x i16> poison, <16 x i32> zeroinitializer)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @sdiv_v2i32(<2 x i32> %op1) {
; CHECK-LABEL: sdiv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <2 x i32> %op1, shufflevector (<2 x i32> insertelement (<2 x i32> poison, i32 32, i32 0), <2 x i32> poison, <2 x i32> zeroinitializer)
  ret <2 x i32> %res
}

define <4 x i32> @sdiv_v4i32(<4 x i32> %op1) {
; CHECK-LABEL: sdiv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <4 x i32> %op1, shufflevector (<4 x i32> insertelement (<4 x i32> poison, i32 32, i32 0), <4 x i32> poison, <4 x i32> zeroinitializer)
  ret <4 x i32> %res
}

define void @sdiv_v8i32(ptr %a) {
; CHECK-LABEL: sdiv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    asrd z1.s, p0/m, z1.s, #5
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #4]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w10, w8, #5
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    asr w9, w8, #31
; NONEON-NOSVE-NEXT:    add w8, w8, w9, lsr #27
; NONEON-NOSVE-NEXT:    asr w8, w8, #5
; NONEON-NOSVE-NEXT:    stp w8, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sdiv <8 x i32> %op1, shufflevector (<8 x i32> insertelement (<8 x i32> poison, i32 32, i32 0), <8 x i32> poison, <8 x i32> zeroinitializer)
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @sdiv_v1i64(<1 x i64> %op1) {
; CHECK-LABEL: sdiv_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d0
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x8, x8, #5
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <1 x i64> %op1, shufflevector (<1 x i64> insertelement (<1 x i64> poison, i64 32, i32 0), <1 x i64> poison, <1 x i32> zeroinitializer)
  ret <1 x i64> %res
}

; Vector i64 sdiv are not legal for NEON so use SVE when available.
define <2 x i64> @sdiv_v2i64(<2 x i64> %op1) {
; CHECK-LABEL: sdiv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x10, x8, #5
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x8, x8, #5
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sdiv <2 x i64> %op1, shufflevector (<2 x i64> insertelement (<2 x i64> poison, i64 32, i32 0), <2 x i64> poison, <2 x i32> zeroinitializer)
  ret <2 x i64> %res
}

define void @sdiv_v4i64(ptr %a) {
; CHECK-LABEL: sdiv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #5
; CHECK-NEXT:    asrd z1.d, p0/m, z1.d, #5
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: sdiv_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x10, x8, #5
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x8, x8, #5
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #8]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x10, x8, #5
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    asr x9, x8, #63
; NONEON-NOSVE-NEXT:    add x8, x8, x9, lsr #59
; NONEON-NOSVE-NEXT:    asr x8, x8, #5
; NONEON-NOSVE-NEXT:    stp x8, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sdiv <4 x i64> %op1, shufflevector (<4 x i64> insertelement (<4 x i64> poison, i64 32, i32 0), <4 x i64> poison, <4 x i32> zeroinitializer)
  store <4 x i64> %res, ptr %a
  ret void
}
